/*
 * Decompiled with CFR 0.152.
 */
package devRegularMap.vecmath;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Writer;
import jv.object.PsDebug;
import jv.vecmath.PiVector;

public class PuSubgroup {
    protected static String[] m_elt;
    protected static String[] m_G;
    protected static String m_H;
    protected static int INFINITY;
    protected static String[] m_lowIndSubgroup;
    protected static int[] m_indexSubgroup;
    protected static String[][] m_coset;
    protected static int[][] m_cosetPerm;
    protected static final String m_absolute_path;
    protected static String m_aceIn;
    protected static String m_aceOut;
    protected static File m_aceOutPath;

    static {
        INFINITY = 100;
        m_absolute_path = String.valueOf(System.getProperty("user.dir")) + "\\src\\devRegularMap\\ioFile\\";
        m_aceIn = String.valueOf(m_absolute_path) + "aceIn.in";
        m_aceOut = "aceOut.out";
        m_aceOutPath = new File(String.valueOf(m_absolute_path) + m_aceOut);
    }

    public static void setGroup(String[] g) {
        m_G = g;
    }

    public static void setElementOfGroup(String[] elt) {
        m_elt = elt;
    }

    public static String[] getLowIndexSubgroup() {
        return m_lowIndSubgroup;
    }

    public static int[] getIndexOfSubgroup() {
        return m_indexSubgroup;
    }

    public static int indexOfHinG(String H, String[] G) {
        int index = -1;
        File file = new File(m_aceIn);
        try {
            boolean exist = file.createNewFile();
            if (!exist) {
                FileWriter fstream = new FileWriter(m_aceIn);
                BufferedWriter out = new BufferedWriter(fstream);
                out.close();
            }
        }
        catch (IOException e) {
            PsDebug.error((String)"Unable to write aceIn");
        }
        try {
            FileOutputStream fin = new FileOutputStream(m_aceIn);
            PrintStream write = new PrintStream(fin);
            int i = 0;
            while (i < G.length) {
                write.println(G[i]);
                ++i;
            }
            write.println("subgroup name:H;");
            write.println("subgroup generators:" + H);
            write.println("end");
            write.println("st;pr:-1,1000;");
            fin.close();
        }
        catch (IOException e) {
            PsDebug.error((String)"Unable to write to aceIn");
        }
        String commands = "cmd /c ace.exe <aceIn.in> " + m_aceOut;
        try {
            boolean exist = m_aceOutPath.createNewFile();
            if (!exist) {
                FileWriter fstream = new FileWriter(m_aceOut);
                BufferedWriter out = new BufferedWriter(fstream);
                out.close();
            }
            Runtime r = Runtime.getRuntime();
            Process p = r.exec(commands, null, new File(m_absolute_path));
            p.waitFor();
        }
        catch (Exception e) {
            PsDebug.error((String)("Error executing: " + commands));
        }
        try {
            FileInputStream fstream = new FileInputStream(m_aceOutPath);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String str = " ";
            int i = 0;
            while (i < 5) {
                str = br.readLine();
                ++i;
            }
            String[] line = str.split("\\s+");
            index = Integer.parseInt(line[2]);
            br.close();
        }
        catch (Exception e) {
            PsDebug.error((String)e.getMessage());
        }
        return index;
    }

    public static String[] searchSubgroup(String genH) {
        int ordG = m_elt.length;
        String H = genH;
        m_lowIndSubgroup = new String[ordG];
        m_indexSubgroup = new int[ordG];
        int H0 = PuSubgroup.indexOfHinG(String.valueOf(H) + ";", m_G);
        String[] lsub = new String[100];
        lsub[0] = String.valueOf(H) + " (" + H0 + " colors)";
        int ind = 1;
        PiVector index = new PiVector(1);
        index.setEntry(0, H0);
        int i = 1;
        while (i < ordG) {
            String extH = String.valueOf(H) + "," + m_elt[i] + ";";
            int GindH = PuSubgroup.indexOfHinG(extH, m_G);
            if (GindH < INFINITY && index.getIndexOf(GindH) == -1 && GindH != 1) {
                index.addEntry(GindH);
                lsub[ind] = String.valueOf(genH) + "," + m_elt[i] + " (" + GindH + " colors)";
                PuSubgroup.m_lowIndSubgroup[ind] = m_elt[i];
                PuSubgroup.m_indexSubgroup[ind] = GindH;
                ++ind;
            }
            ++i;
        }
        return lsub;
    }

    public static int[][] getSubGroupPermutation(String sub) {
        Closeable fstream;
        try {
            FileOutputStream fin = new FileOutputStream(m_aceIn);
            PrintStream write = new PrintStream(fin);
            int i = 0;
            while (i < m_G.length) {
                write.println(m_G[i]);
                ++i;
            }
            write.println("subgroup name:H;");
            write.println("subgroup generators:" + sub + ";");
            write.println("end");
            write.println("st;pr:-1,1000;");
            fin.close();
        }
        catch (IOException e) {
            PsDebug.error((String)"Unable to write to aceIn For coset enumeration ");
        }
        try {
            fstream = new FileWriter(m_aceOut);
            BufferedWriter out = new BufferedWriter((Writer)fstream);
            String commands = "cmd /c ace.exe <aceIn.in> " + m_aceOut;
            Process p = Runtime.getRuntime().exec(commands, null, new File(m_absolute_path));
            p.waitFor();
            out.close();
        }
        catch (Exception e) {
            PsDebug.error((String)e.getMessage());
        }
        try {
            fstream = new FileInputStream(m_aceOutPath);
            DataInputStream in = new DataInputStream((InputStream)fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String str = " ";
            int readline = 0;
            int i = 0;
            while (i < 5) {
                str = br.readLine();
                ++i;
            }
            String[] line = str.split("\\s+");
            int ord = Integer.parseInt(line[2]);
            m_cosetPerm = new int[5][ord];
            br.readLine();
            br.readLine();
            str = br.readLine();
            str = str.trim();
            line = str.split("\\s+");
            int numGen = line.length - 4;
            String gen = "rRsSt";
            int[] nArray = new int[5];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            nArray[4] = 4;
            int[] perm = nArray;
            int i2 = 0;
            while (i2 < numGen) {
                int j1 = 0;
                while (j1 < gen.length()) {
                    if (line[i2 + 2].charAt(0) == gen.charAt(j1)) {
                        perm[i2] = j1;
                    }
                    ++j1;
                }
                ++i2;
            }
            readline = 8;
            int ind = 0;
            while ((str = br.readLine()) != null) {
                if (readline >= 9 && readline < ord + 9) {
                    str = str.trim();
                    line = str.split("\\s+");
                    int i3 = 0;
                    while (i3 < numGen) {
                        PuSubgroup.m_cosetPerm[perm[i3]][ind] = Integer.parseInt(line[2 + i3]);
                        ++i3;
                    }
                    ++ind;
                }
                ++readline;
            }
            br.close();
        }
        catch (Exception e) {
            PsDebug.error((String)e.getMessage());
        }
        return m_cosetPerm;
    }

    public static int getIndexOfEltInG(String elt, int[][] perm, String gen, boolean flag) {
        char[] repchar = elt.toCharArray();
        int len = repchar.length;
        int index = 1;
        String capgen = gen.toUpperCase();
        if (flag) {
            int i = 0;
            while (i < len) {
                int a;
                if (repchar[i] == gen.charAt(2) || repchar[i] == capgen.charAt(2)) {
                    index = perm[4][index - 1];
                } else if (repchar[i] == capgen.charAt(1)) {
                    a = perm[3][index - 1];
                    index = a == 0 ? perm[2][index - 1] : a;
                } else if (repchar[i] == gen.charAt(1)) {
                    index = perm[2][index - 1];
                } else if (repchar[i] == capgen.charAt(0)) {
                    a = perm[1][index - 1];
                    index = a == 0 ? perm[0][index - 1] : a;
                } else if (repchar[i] == gen.charAt(0)) {
                    index = perm[0][index - 1];
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                if (repchar[len - 1 - i] == gen.charAt(2) || repchar[i] == capgen.charAt(2)) {
                    index = perm[4][index - 1];
                } else if (repchar[len - 1 - i] == capgen.charAt(1)) {
                    index = perm[3][index - 1];
                } else if (repchar[len - 1 - i] == gen.charAt(1)) {
                    index = perm[2][index - 1];
                } else if (repchar[len - 1 - i] == capgen.charAt(0)) {
                    index = perm[1][index - 1];
                } else if (repchar[len - 1 - i] == gen.charAt(0)) {
                    index = perm[0][index - 1];
                }
                ++i;
            }
        }
        return index - 1;
    }
}

