/*
 * Decompiled with CFR 0.152.
 */
package devRegularMap.vecmath;

import jv.vecmath.PdVector;

public class PuSpherical {
    public static PdVector[] connect(PdVector v0, PdVector v1, int n) {
        PdVector[] arc = new PdVector[n];
        PdVector xaxis = new PdVector(1.0, 0.0, 0.0);
        double phi0 = Math.PI / 180 * PdVector.angle((PdVector)xaxis, (PdVector)v0);
        double phi1 = Math.PI / 180 * PdVector.angle((PdVector)xaxis, (PdVector)v1);
        int i = 0;
        while (i < n) {
            arc[i] = new PdVector(3);
            double t = (double)i / (double)(n - 1);
            double a = t * phi1 + (1.0 - t) * phi0;
            arc[i].m_data[0] = Math.cos(a);
            arc[i].m_data[1] = Math.sin(a);
            arc[i].m_data[2] = 0.0;
            ++i;
        }
        return arc;
    }

    public static PdVector[] makeEdge(PdVector v0, PdVector v1, int n) {
        PdVector[] arc = new PdVector[n];
        PdVector n01 = PdVector.crossNew((PdVector)v0, (PdVector)v1);
        PdVector bn = PdVector.crossNew((PdVector)n01, (PdVector)v0);
        bn.normalize();
        double psi = Math.PI / 180 * PdVector.angle((PdVector)v0, (PdVector)v1);
        int i = 0;
        while (i < n) {
            double t = (double)i * psi / (double)(n - 1);
            arc[i] = PdVector.blendNew((double)Math.cos(t), (PdVector)v0, (double)Math.sin(t), (PdVector)bn);
            ++i;
        }
        return arc;
    }
}

