/*
 * Decompiled with CFR 0.152.
 */
package devRegularMap.vecmath;

import devRegularMap.vecmath.PuBasicRM;
import devRegularMap.vecmath.PuHyperbolic;
import devRegularMap.vecmath.PuLorentz3D;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import jv.vecmath.PdVector;

public class PuSearchGenAndSpaceModel {
    protected static int m_p;
    protected static int m_q;
    protected static int m_g;
    protected static int m_i;
    protected static int m_ordG;
    protected static String[] m_elt;
    protected static int[] m_ordElt;
    protected static String[] m_generator;
    protected static int[] m_spaceModel;
    protected static boolean m_dualIsEnable;

    public PuSearchGenAndSpaceModel(int p, int q, int g, int i, String[] elt, int[] ordElt, boolean flag) {
        m_p = p;
        m_q = q;
        m_g = g;
        m_i = i;
        m_ordG = elt.length;
        m_ordElt = ordElt;
        m_elt = elt;
        m_generator = new String[3];
        m_spaceModel = new int[5];
        m_dualIsEnable = flag;
        PuLorentz3D.initLorentzUtility(p, q, -1);
        PuHyperbolic.setParameter(p, q);
    }

    public static void setGenerator(String[] gen) {
        m_generator = gen;
    }

    public String[] getGenerator() {
        return m_generator;
    }

    public String[] getGeneratorOld() {
        File output = new File("R" + m_g + "." + m_i + "{" + m_p + "," + m_q + "}_gen.out");
        if (m_dualIsEnable) {
            output = new File("R" + m_g + "." + m_i + "{" + m_p + "," + m_q + "}d_gen.out");
        }
        try {
            Character tmp_qT;
            FileInputStream fstream = new FileInputStream("C:\\Users\\faniry\\Master-Works\\Thirdlibs\\" + output);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String str = br.readLine();
            str = br.readLine();
            str = br.readLine();
            str = br.readLine();
            str = br.readLine();
            str = br.readLine();
            int i = 0;
            while (i < 3) {
                StringBuffer sb = new StringBuffer();
                int j = 2 + i * 12;
                while (j < str.length()) {
                    if (str.charAt(j) == ' ' || str.charAt(j) == '\n') break;
                    sb.append(str.charAt(j));
                    ++j;
                }
                PuSearchGenAndSpaceModel.m_generator[i] = sb.toString();
                ++i;
            }
            str = br.readLine();
            str = br.readLine();
            Character tmp_pT = Character.valueOf(str.charAt(0));
            if (str.charAt(0) == 'H') {
                tmp_qT = Character.valueOf(str.charAt(2));
                PuSearchGenAndSpaceModel.m_spaceModel[0] = PuBasicRM.HOSOHEDRA;
                PuSearchGenAndSpaceModel.m_spaceModel[1] = 2;
                PuSearchGenAndSpaceModel.m_spaceModel[2] = Integer.parseInt(tmp_qT.toString());
            } else if (str.charAt(0) == '{') {
                tmp_pT = Character.valueOf(str.charAt(3));
                tmp_qT = Character.valueOf(str.charAt(1));
                Character tmp_a = Character.valueOf(str.charAt(6));
                Character tmp_b = Character.valueOf(str.charAt(8));
                PuSearchGenAndSpaceModel.m_spaceModel[0] = PuBasicRM.TORI;
                PuSearchGenAndSpaceModel.m_spaceModel[1] = Integer.parseInt(tmp_pT.toString());
                PuSearchGenAndSpaceModel.m_spaceModel[2] = Integer.parseInt(tmp_qT.toString());
                PuSearchGenAndSpaceModel.m_spaceModel[3] = Integer.parseInt(tmp_a.toString());
                PuSearchGenAndSpaceModel.m_spaceModel[4] = Integer.parseInt(tmp_b.toString());
            } else if (Integer.parseInt(tmp_pT.toString()) == PuBasicRM.CUBE) {
                PuSearchGenAndSpaceModel.m_spaceModel[0] = PuBasicRM.CUBE;
                PuSearchGenAndSpaceModel.m_spaceModel[1] = 3;
                PuSearchGenAndSpaceModel.m_spaceModel[2] = 4;
            } else if (Integer.parseInt(tmp_pT.toString()) == PuBasicRM.TETRAHEDRON) {
                PuSearchGenAndSpaceModel.m_spaceModel[0] = PuBasicRM.TETRAHEDRON;
                PuSearchGenAndSpaceModel.m_spaceModel[1] = 3;
                PuSearchGenAndSpaceModel.m_spaceModel[2] = 3;
            }
            in.close();
        }
        catch (Exception e) {
            PuSearchGenAndSpaceModel.suitableSpaceModelAndGenerator();
            try {
                Character tmp_qT;
                FileInputStream fstream = new FileInputStream("C:\\Users\\faniry\\Master-Works\\Thirdlibs\\" + output);
                DataInputStream in = new DataInputStream(fstream);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                String str = br.readLine();
                str = br.readLine();
                str = br.readLine();
                str = br.readLine();
                str = br.readLine();
                str = br.readLine();
                int i = 0;
                while (i < 3) {
                    StringBuffer sb = new StringBuffer();
                    int j = 2 + i * 12;
                    while (j < str.length()) {
                        if (str.charAt(j) == ' ' || str.charAt(j) == '\n') break;
                        sb.append(str.charAt(j));
                        ++j;
                    }
                    PuSearchGenAndSpaceModel.m_generator[i] = sb.toString();
                    ++i;
                }
                str = br.readLine();
                str = br.readLine();
                Character tmp_pT = Character.valueOf(str.charAt(0));
                if (str.charAt(0) == 'H') {
                    tmp_qT = Character.valueOf(str.charAt(2));
                    PuSearchGenAndSpaceModel.m_spaceModel[0] = PuBasicRM.HOSOHEDRA;
                    PuSearchGenAndSpaceModel.m_spaceModel[1] = 2;
                    PuSearchGenAndSpaceModel.m_spaceModel[3] = Integer.parseInt(tmp_qT.toString());
                } else if (str.charAt(0) == '{') {
                    tmp_pT = Character.valueOf(str.charAt(3));
                    tmp_qT = Character.valueOf(str.charAt(1));
                    Character tmp_a = Character.valueOf(str.charAt(6));
                    Character tmp_b = Character.valueOf(str.charAt(8));
                    PuSearchGenAndSpaceModel.m_spaceModel[0] = PuBasicRM.TORI;
                    PuSearchGenAndSpaceModel.m_spaceModel[1] = Integer.parseInt(tmp_pT.toString());
                    PuSearchGenAndSpaceModel.m_spaceModel[2] = Integer.parseInt(tmp_qT.toString());
                    PuSearchGenAndSpaceModel.m_spaceModel[3] = Integer.parseInt(tmp_a.toString());
                    PuSearchGenAndSpaceModel.m_spaceModel[4] = Integer.parseInt(tmp_b.toString());
                } else if (Integer.parseInt(tmp_pT.toString()) == 1) {
                    PuSearchGenAndSpaceModel.m_spaceModel[0] = PuBasicRM.CUBE;
                    PuSearchGenAndSpaceModel.m_spaceModel[1] = 3;
                    PuSearchGenAndSpaceModel.m_spaceModel[2] = 4;
                } else if (Integer.parseInt(tmp_pT.toString()) == 0) {
                    PuSearchGenAndSpaceModel.m_spaceModel[0] = PuBasicRM.TETRAHEDRON;
                    PuSearchGenAndSpaceModel.m_spaceModel[1] = 3;
                    PuSearchGenAndSpaceModel.m_spaceModel[2] = 3;
                }
                in.close();
                fstream.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        return m_generator;
    }

    public static void setSpaceModel(int[] sm) {
        m_spaceModel = sm;
    }

    public static int[] getSpaceModel() {
        return m_spaceModel;
    }

    private static void suitableSpaceModelAndGenerator() {
        String output = "R" + m_g + "." + m_i + "{" + m_p + "," + m_q + "}_gen.out";
        if (m_dualIsEnable) {
            output = "R" + m_g + "." + m_i + "{" + m_p + "," + m_q + "}d_gen.out";
        }
        try {
            int i;
            int i2;
            StringBuffer sb;
            FileWriter fstream = new FileWriter("C:\\Users\\faniry\\Master-Works\\Thirdlibs\\" + output);
            BufferedWriter out = new BufferedWriter(fstream);
            String[] sm = new String[10];
            int n = 0;
            String B = " ";
            int qT = 0;
            int pT = 0;
            int indstr = 0;
            String[][] ABC = new String[10][10];
            if (m_p % (m_g + 1) == 0) {
                n = m_p / (m_g + 1);
                sb = new StringBuffer();
                i2 = 0;
                while (i2 < n) {
                    sb.append("r");
                    ++i2;
                }
                B = sb.toString();
                qT = m_g + 1;
                pT = 2;
                ABC[indstr] = PuSearchGenAndSpaceModel.searchGeneratorNew(pT, qT, B);
                if (ABC[indstr][0] != null) {
                    sm[indstr] = "H_" + (m_g + 1);
                }
                ++indstr;
            } else if (m_q % (m_g + 1) == 0) {
                sm[indstr] = "H_" + (m_g + 1);
                n = m_q / (m_g + 1);
                sb = new StringBuffer();
                i2 = 0;
                while (i2 < n) {
                    sb.append("s");
                    ++i2;
                }
                B = sb.toString();
                qT = m_g + 1;
                pT = 2;
                ABC[indstr] = PuSearchGenAndSpaceModel.searchGeneratorNew(pT, qT, B);
                if (ABC[indstr][0] != null) {
                    sm[indstr] = "H_" + (m_g + 1);
                }
                ++indstr;
            }
            if (m_p % 3 == 0 && m_g == 5) {
                n = m_p / 3;
                sb = new StringBuffer();
                i2 = 0;
                while (i2 < n) {
                    sb.append("r");
                    ++i2;
                }
                B = sb.toString();
                qT = 3;
                pT = 4;
                ABC[indstr] = PuSearchGenAndSpaceModel.searchGeneratorNew(pT, qT, B);
                if (ABC[indstr][0] != null) {
                    sm[indstr] = String.valueOf(PuBasicRM.CUBE) + " C";
                }
                ++indstr;
            } else if (m_q % 3 == 0 && m_g == 5) {
                sm[indstr] = "C";
                n = m_q / 3;
                sb = new StringBuffer();
                i2 = 0;
                while (i2 < n) {
                    sb.append("s");
                    ++i2;
                }
                B = sb.toString();
                qT = 3;
                pT = 4;
                ABC[indstr] = PuSearchGenAndSpaceModel.searchGeneratorNew(pT, qT, B);
                if (ABC[indstr][0] != null) {
                    sm[indstr] = String.valueOf(PuBasicRM.CUBE) + " C";
                }
                ++indstr;
            }
            if (m_p % 3 == 0 && m_g == 3) {
                n = m_p / 3;
                sb = new StringBuffer();
                i2 = 0;
                while (i2 < n) {
                    sb.append("r");
                    ++i2;
                }
                B = sb.toString();
                qT = 3;
                pT = 3;
                ABC[indstr] = PuSearchGenAndSpaceModel.searchGeneratorNew(pT, qT, B);
                if (ABC[indstr][0] != null) {
                    sm[indstr] = String.valueOf(PuBasicRM.TETRAHEDRON) + " T";
                }
                ++indstr;
            } else if (m_q % 3 == 0 && m_g == 3) {
                n = m_q / 3;
                sb = new StringBuffer();
                i2 = 0;
                while (i2 < n) {
                    sb.append("s");
                    ++i2;
                }
                B = sb.toString();
                pT = 3;
                qT = 3;
                ABC[indstr] = PuSearchGenAndSpaceModel.searchGeneratorNew(pT, qT, B);
                if (ABC[indstr][0] != null) {
                    sm[indstr] = String.valueOf(PuBasicRM.TETRAHEDRON) + " T";
                }
                ++indstr;
            }
            int inda = 1;
            int a = 0;
            int type = 1;
            while (inda <= m_g - 1) {
                if (inda * inda == m_g - 1) {
                    a = inda;
                    type = 1;
                }
                if (2 * inda * inda == m_g - 1) {
                    a = inda;
                    type = 2;
                }
                if (6 * inda * inda == m_g - 1) {
                    a = inda;
                    type = 3;
                }
                if (3 * inda * inda == m_g - 1) {
                    a = inda;
                    type = 4;
                }
                ++inda;
            }
            if (a != 0) {
                StringBuffer sb2;
                if (m_p % 4 == 0 && (type == 1 || type == 2)) {
                    n = m_p / 4;
                    sb2 = new StringBuffer();
                    i = 0;
                    while (i < n) {
                        sb2.append("r");
                        ++i;
                    }
                    B = sb2.toString();
                    pT = 4;
                    qT = 4;
                    ABC[indstr] = PuSearchGenAndSpaceModel.searchGeneratorNew(pT, qT, B);
                    if (ABC[indstr][0] != null) {
                        if (type == 1) {
                            sm[indstr] = "{4,4}_" + a + "," + 0;
                        }
                        if (type == 2) {
                            sm[indstr] = "{4,4}_" + a + "," + a;
                        }
                    }
                    ++indstr;
                }
                if (m_q % 4 == 0 && (type == 1 || type == 2)) {
                    n = m_q / 4;
                    sb2 = new StringBuffer();
                    i = 0;
                    while (i < n) {
                        sb2.append("s");
                        ++i;
                    }
                    B = sb2.toString();
                    pT = 4;
                    qT = 4;
                    ABC[indstr] = PuSearchGenAndSpaceModel.searchGeneratorNew(pT, qT, B);
                    if (ABC[indstr][0] != null) {
                        if (type == 1) {
                            sm[indstr] = "{4,4}_" + a + "," + 0;
                        }
                        if (type == 2) {
                            sm[indstr] = "{4,4}_" + a + "," + a;
                        }
                    }
                    ++indstr;
                }
                if (m_p % 3 == 0 && (type == 2 || type == 3)) {
                    n = m_p / 3;
                    sb2 = new StringBuffer();
                    i = 0;
                    while (i < n) {
                        sb2.append("r");
                        ++i;
                    }
                    B = sb2.toString();
                    pT = 3;
                    qT = 6;
                    ABC[indstr] = PuSearchGenAndSpaceModel.searchGeneratorNew(pT, qT, B);
                    if (ABC[indstr][0] != null) {
                        if (type == 2) {
                            sm[indstr] = "{3,6}_" + a + "," + 0;
                        }
                        if (type == 3) {
                            sm[indstr] = "{3,6}_" + a + "," + a;
                        }
                    }
                    ++indstr;
                }
                if (m_q % 3 == 0 && (type == 2 || type == 3)) {
                    n = m_q / 3;
                    sb2 = new StringBuffer();
                    i = 0;
                    while (i < n) {
                        sb2.append("s");
                        ++i;
                    }
                    B = sb2.toString();
                    pT = 3;
                    qT = 6;
                    ABC[indstr] = PuSearchGenAndSpaceModel.searchGeneratorNew(pT, qT, B);
                    if (ABC[indstr][0] != null) {
                        if (type == 2) {
                            sm[indstr] = "{3,6}_" + a + "," + 0;
                        }
                        if (type == 3) {
                            sm[indstr] = "{3,6}_" + a + "," + a;
                        }
                        ++indstr;
                    }
                }
                if (m_p % 6 == 0 && (type == 1 || type == 4)) {
                    n = m_p / 6;
                    sb2 = new StringBuffer();
                    i = 0;
                    while (i < n) {
                        sb2.append("r");
                        ++i;
                    }
                    B = sb2.toString();
                    pT = 6;
                    qT = 3;
                    ABC[indstr] = PuSearchGenAndSpaceModel.searchGeneratorNew(pT, qT, B);
                    if (ABC[indstr][0] != null) {
                        if (type == 1) {
                            sm[indstr] = "{6,3}_" + a + "," + 0;
                        }
                        if (type == 4) {
                            sm[indstr] = "{6,3}_" + a + "," + a;
                        }
                    }
                    ++indstr;
                }
                if (m_q % 6 == 0 && (type == 1 || type == 4)) {
                    n = m_q / 6;
                    sb2 = new StringBuffer();
                    i = 0;
                    while (i < n) {
                        sb2.append("s");
                        ++i;
                    }
                    B = sb2.toString();
                    pT = 6;
                    qT = 3;
                    ABC[indstr] = PuSearchGenAndSpaceModel.searchGeneratorNew(pT, qT, B);
                    if (ABC[indstr][0] != null) {
                        if (type == 1) {
                            sm[indstr] = "{6,3}_" + a + "," + 0;
                        }
                        if (type == 4) {
                            sm[indstr] = "{6,3}_" + a + "," + a;
                        }
                    }
                    ++indstr;
                }
            }
            out.write("List of generators found and possible space model for mapping.");
            out.newLine();
            out.write("Author: Faniry Harijaona Razafindrazaka");
            out.newLine();
            out.newLine();
            boolean notwritting = true;
            i = 0;
            while (i < 0) {
                if (ABC[i] != null && notwritting) {
                    if (m_dualIsEnable) {
                        out.write("R" + m_g + "." + m_i + "{" + m_p + "," + m_q + "}");
                    } else {
                        out.write("R" + m_g + "." + m_i + "{" + m_p + "," + m_q + "}d");
                    }
                    out.newLine();
                    notwritting = false;
                }
                if (ABC[i][0] != null) {
                    out.newLine();
                    out.write("A=" + ABC[i][0]);
                    int i1 = 0;
                    while (i1 < 10 - ABC[i][0].length()) {
                        out.write(" ");
                        ++i1;
                    }
                    out.write("B=" + ABC[i][1]);
                    i1 = 0;
                    while (i1 < 10 - ABC[i][1].length()) {
                        out.write(" ");
                        ++i1;
                    }
                    out.write("C=" + ABC[i][2]);
                    i1 = 0;
                    while (i1 < 10 - ABC[i][2].length()) {
                        out.write(" ");
                        ++i1;
                    }
                    out.newLine();
                    out.write("Space model: ");
                    out.newLine();
                    out.write(sm[i]);
                }
                ++i;
            }
            out.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    public static String[] searchGeneratorNew(int pT, int qT, String B) {
        int j;
        String[] ABC = new String[3];
        int maxElt = m_ordElt.length;
        String[] A = new String[6 * maxElt];
        String[] C = new String[6 * maxElt];
        int ind = 0;
        String[] a = new String[]{"r", "s", "S", "R"};
        int i = 0;
        while (i < maxElt) {
            if (m_elt[i].charAt(m_elt[i].length() - 1) != 't') {
                if (m_ordElt[i] == 2) {
                    C[ind] = m_elt[i];
                    ++ind;
                }
                j = 0;
                while (j < 4) {
                    if (PuHyperbolic.isOrder(String.valueOf(m_elt[i]) + a[j], 2)) {
                        C[ind] = String.valueOf(m_elt[i]) + a[j];
                        ++ind;
                    }
                    ++j;
                }
            }
            ++i;
        }
        ind = 0;
        i = 0;
        while (i < maxElt) {
            if (m_elt[i].charAt(m_elt[i].length() - 1) != 't') {
                if (m_ordElt[i] == pT) {
                    A[ind] = m_elt[i];
                    ++ind;
                }
                j = 0;
                while (j < 4) {
                    if (PuHyperbolic.isOrder(String.valueOf(m_elt[i]) + a[j], pT)) {
                        A[ind] = String.valueOf(m_elt[i]) + a[j];
                        ++ind;
                    }
                    ++j;
                }
            }
            ++i;
        }
        PuLorentz3D cabcBA = PuLorentz3D.Identity();
        PuLorentz3D mB = PuLorentz3D.Identity();
        mB = PuHyperbolic.getTrans(B);
        PdVector N1 = new PdVector(0.0, 0.0, 0.0);
        if (B.charAt(0) == 's') {
            PdVector P;
            N1 = P = PuHyperbolic.getPofTriangle(m_p, m_q);
        }
        int i2 = 0;
        while (i2 < maxElt) {
            PuLorentz3D mA = PuLorentz3D.Identity();
            if (A[i2] == null) break;
            mA = PuHyperbolic.getTrans(A[i2]);
            int j2 = 0;
            while (j2 < maxElt) {
                PuLorentz3D mC = PuLorentz3D.Identity();
                if (C[j2] == null) break;
                mC = PuHyperbolic.getTrans(C[j2]);
                PuLorentz3D ca = new PuLorentz3D();
                ca.TransMult(mC, mA);
                PuLorentz3D bc = new PuLorentz3D();
                bc.TransMult(mB, mC);
                PuLorentz3D invB = mB.inverse();
                PuLorentz3D invA = mA.inverse();
                PuLorentz3D BA = new PuLorentz3D();
                BA.TransMult(invB, invA);
                cabcBA.TransMult(ca, bc);
                cabcBA.TransMult(cabcBA, BA);
                if (PuHyperbolic.isIdentity(cabcBA)) {
                    PuLorentz3D mABC2 = PuLorentz3D.Identity();
                    mABC2.TransMult(mA, mB);
                    mABC2.TransMult(mABC2, mC);
                    mABC2.TransMult(mABC2, mABC2);
                    if (PuHyperbolic.isIdentity(mABC2)) {
                        PuLorentz3D mAB2 = new PuLorentz3D();
                        mAB2.TransMult(mA, mB);
                        mAB2.TransMult(mAB2, mAB2);
                        if (PuHyperbolic.isIdentity(mAB2)) {
                            PuLorentz3D mBC2 = new PuLorentz3D();
                            mBC2.TransMult(mB, mC);
                            mBC2.TransMult(mBC2, mBC2);
                            PdVector AN1 = PuHyperbolic.transform(N1, A[i2], 0);
                            PdVector CN1 = PuHyperbolic.transform(N1, C[j2], 0);
                            double alpha = PuHyperbolic.hangle(AN1, N1, CN1);
                            if (!(Math.abs(alpha - Math.PI) < 1.0E-8) && !(Math.abs(alpha) < 1.0E-8) && PuHyperbolic.computeAreaHyperbolic(N1, CN1, AN1) > 1.0E-8) {
                                PdVector[] basecorner = PuHyperbolic.getOtherPointQuarterTube(N1, new String[]{A[i2], B, C[j2]});
                                PdVector[] ct1 = new PdVector[]{basecorner[0], basecorner[1], basecorner[2]};
                                PdVector[] ct2 = new PdVector[]{basecorner[0], basecorner[2], basecorner[3]};
                                if (!PuHyperbolic.ccw(ct1)) {
                                    PdVector tmp = basecorner[1];
                                    basecorner[1] = basecorner[3];
                                    basecorner[3] = tmp;
                                } else if (!PuHyperbolic.ccw(ct2)) {
                                    PdVector tmp = basecorner[2];
                                    basecorner[2] = basecorner[3];
                                    basecorner[3] = tmp;
                                }
                                alpha = PuHyperbolic.hangle(basecorner[3], basecorner[0], basecorner[1]);
                                double beta = PuHyperbolic.hangle(basecorner[2], basecorner[3], basecorner[0]);
                                double angR = (double)qT * (alpha + beta);
                                if (Math.abs(angR - Math.PI * 2) < 1.0E-8) {
                                    System.out.println(String.valueOf(A[i2]) + " " + B + " " + C[j2]);
                                }
                            }
                        }
                    }
                }
                ++j2;
            }
            ++i2;
        }
        return ABC;
    }

    public static String[] searchGenerator(int pT, int qT, String B) {
        int j;
        String[] ABC = new String[3];
        int maxElt = m_ordElt.length;
        String[] A = new String[maxElt];
        String[] C = new String[maxElt];
        boolean found = false;
        int ind = 0;
        String[] a = new String[]{"r", "s", "S", "R"};
        int i = 0;
        while (i < maxElt) {
            if (m_elt[i].charAt(m_elt[i].length() - 1) != 't') {
                if (m_ordElt[i] == 2) {
                    C[ind] = m_elt[i];
                    ++ind;
                }
                j = 0;
                while (j < 4) {
                    if (PuHyperbolic.isOrder(String.valueOf(m_elt[i]) + a[j], 2)) {
                        C[ind] = String.valueOf(m_elt[i]) + a[j];
                        ++ind;
                    }
                    ++j;
                }
            }
            ++i;
        }
        ind = 0;
        i = 0;
        while (i < maxElt) {
            if (m_elt[i].charAt(m_elt[i].length() - 1) != 't') {
                if (m_ordElt[i] == pT) {
                    A[ind] = m_elt[i];
                    ++ind;
                }
                j = 0;
                while (j < 4) {
                    if (PuHyperbolic.isOrder(String.valueOf(m_elt[i]) + a[j], pT)) {
                        A[ind] = String.valueOf(m_elt[i]) + a[j];
                        ++ind;
                    }
                    ++j;
                }
            }
            ++i;
        }
        String[] invC = (String[])C.clone();
        int i2 = 0;
        while (i2 < C.length) {
            if (C[i2] != null) {
                invC[i2] = PuHyperbolic.inverseRepresentation(C[i2]);
            }
            ++i2;
        }
        String[][] CandCinv = new String[][]{C, invC};
        PuLorentz3D mB = PuLorentz3D.Identity();
        mB = PuHyperbolic.getTrans(B);
        PdVector N1 = new PdVector(0.0, 0.0, 0.0);
        if (B.charAt(0) == 's') {
            PdVector P;
            N1 = P = PuHyperbolic.getPofTriangle(m_p, m_q);
        }
        int m = 0;
        while (m < 2) {
            if (found) break;
            int i3 = 0;
            while (i3 < maxElt) {
                if (found) break;
                PuLorentz3D mA = PuLorentz3D.Identity();
                if (A[i3] == null) break;
                mA = PuHyperbolic.getTrans(A[i3]);
                PuLorentz3D mAB2 = new PuLorentz3D();
                mAB2.TransMult(mA, mB);
                mAB2.TransMult(mAB2, mAB2);
                if (PuHyperbolic.isIdentity(mAB2)) {
                    int j2 = 0;
                    while (j2 < maxElt) {
                        PuLorentz3D mC = PuLorentz3D.Identity();
                        if (CandCinv[m][j2] == null) break;
                        mC = PuHyperbolic.getTrans(CandCinv[m][j2]);
                        PuLorentz3D mBC2 = new PuLorentz3D();
                        mBC2.TransMult(mB, mC);
                        mBC2.TransMult(mBC2, mBC2);
                        if (PuHyperbolic.isIdentity(mBC2)) {
                            PuLorentz3D mABC2 = PuLorentz3D.Identity();
                            mABC2.TransMult(mA, mB);
                            mABC2.TransMult(mABC2, mC);
                            mABC2.TransMult(mABC2, mABC2);
                            if (PuHyperbolic.isIdentity(mABC2)) {
                                PdVector[] basecorner = PuHyperbolic.getOtherPointQuarterTube(N1, new String[]{A[i3], B, CandCinv[m][j2]});
                                PdVector[] ct1 = new PdVector[]{basecorner[0], basecorner[1], basecorner[2]};
                                PdVector[] ct2 = new PdVector[]{basecorner[0], basecorner[2], basecorner[3]};
                                if (!PuHyperbolic.ccw(ct1)) {
                                    PdVector tmp = basecorner[1];
                                    basecorner[1] = basecorner[3];
                                    basecorner[3] = tmp;
                                } else if (!PuHyperbolic.ccw(ct2)) {
                                    PdVector tmp = basecorner[2];
                                    basecorner[2] = basecorner[3];
                                    basecorner[3] = tmp;
                                }
                                double alpha = PuHyperbolic.hangle(basecorner[3], basecorner[0], basecorner[1]);
                                double beta = PuHyperbolic.hangle(basecorner[2], basecorner[3], basecorner[0]);
                                double angR = (double)qT * (alpha + beta);
                                if (Math.abs(angR - Math.PI * 2) < 1.0E-8 && Math.abs(alpha) > 1.0E-8 && Math.abs(beta) > 1.0E-8) {
                                    System.out.println("The angle at the junction is : " + alpha + " " + beta + " and the sum " + angR);
                                    ABC[0] = A[i3];
                                    ABC[1] = B;
                                    ABC[2] = CandCinv[m][j2];
                                    System.out.println(String.valueOf(ABC[0]) + " " + ABC[1] + " " + ABC[2]);
                                    found = true;
                                }
                            }
                        }
                        ++j2;
                    }
                }
                ++i3;
            }
            ++m;
        }
        if (!found) {
            System.err.println("Generator and Space model not found");
        } else {
            System.out.println("Generator and Space model found");
        }
        return ABC;
    }
}

