/*
 * Decompiled with CFR 0.152.
 */
package devRegularMap.vecmath;

import devRegularMap.number.PgQuarterTube;
import devRegularMap.vecmath.PuHyperboloid;
import devRegularMap.vecmath.PuIsometry;
import devRegularMap.vecmath.PuSubgroup;
import jv.geom.PgElementSet;
import jv.object.PsObject;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;

public class PuQuadTesselation {
    protected static PgElementSet m_elementSet;
    protected static PiVector[] m_neighbor;
    protected static int m_pt;
    protected static int m_qt;
    protected static int m_gt;
    protected static int m_it;
    protected static boolean m_dualIsEnable;
    protected static int m_a;
    protected static int m_b;
    protected static PiVector m_tParam;
    protected static String[] m_eltG;
    protected static String[] m_coset;
    protected static int[] m_ordCoset;
    protected static int[][] m_cosetPerm;
    protected static String[] m_eltH;
    protected static int m_ordG;
    protected static int[] m_ordElt;
    protected static String[] m_eltGs;
    protected static int[][] m_rRsSt;
    protected static PdMatrix[] m_tMat;
    protected static int[][] m_aAbBc;
    protected static PdMatrix[] m_abc;
    protected static PdVector m_sign;
    protected static int m_numDiscr;

    static {
        m_sign = new PdVector(-1.0, 0.0, 0.0);
        m_numDiscr = 6;
    }

    public static void setGeometry(PgElementSet p) {
        m_elementSet = p;
    }

    public static void setParameters(PiVector p) {
        m_gt = p.m_data[0];
        m_it = p.m_data[1];
        m_pt = p.m_data[2];
        m_qt = p.m_data[3];
        m_a = p.m_data[4];
        m_b = p.m_data[5];
    }

    public String[] getElementTable() {
        return m_eltG;
    }

    public int[][] getPermutationTable() {
        return m_aAbBc;
    }

    public String[] getCosetRepresentativ() {
        return m_coset;
    }

    public int[] getOrderEltCoset() {
        return m_ordCoset;
    }

    public String[] getElementTableOfH() {
        return m_eltH;
    }

    public int getOrdG() {
        return m_ordG;
    }

    public int[] getElementsOrder() {
        return m_ordElt;
    }

    public static void makeNeighbor() {
        int noe = m_eltG.length;
        m_neighbor = new PiVector[noe];
        String[] bt = new String[]{"bc", "c", "abc"};
        int i = 0;
        while (i < noe) {
            String tr = m_eltG[i];
            PuQuadTesselation.m_neighbor[i] = new PiVector(3);
            int j = 0;
            while (j < 3) {
                PuQuadTesselation.m_neighbor[i].m_data[j] = PuSubgroup.getIndexOfEltInG(String.valueOf(tr) + bt[j], m_aAbBc, "abc", true) - 1;
                ++j;
            }
            ++i;
        }
    }

    public static void replicate(PgElementSet geom, PiVector param) {
        PuQuadTesselation.setGeometry(geom);
        PuQuadTesselation.setParameters(param);
        PuQuadTesselation.makeNeighbor();
        PdVector[] vertex = new PdVector[]{geom.getVertex(0), geom.getVertex(1), geom.getVertex(2), geom.getVertex(3)};
        m_abc = PuQuadTesselation.getABC(vertex);
        PgQuarterTube.init(vertex);
        PgQuarterTube[] Qt = new PgQuarterTube[m_eltG.length];
        geom.copy((PsObject)Qt[0].getElementSet());
    }

    public static void generateTubeFromQtube(PgElementSet geom) {
        int nov = geom.getNumVertices();
        int noe = geom.getNumElements();
        int newnov = nov + 5;
        int newnoe = 4;
        PdVector[] vertex = m_elementSet.getVertices();
        m_abc = PuQuadTesselation.getABC(vertex);
        PiVector[] newElt = new PiVector[newnoe];
        PdVector[] newVert = new PdVector[newnov];
        int i = 0;
        while (i < nov) {
            newVert[i] = geom.getVertex(i);
            ++i;
        }
        i = 0;
        while (i < noe) {
            newElt[i] = geom.getElement(i);
            ++i;
        }
        PdMatrix trans = PuIsometry.getTrans("c", m_abc, "abc");
        PdVector cv0 = new PdVector(3);
        PdVector cv1 = new PdVector(3);
        trans.leftMultMatrix(cv0, vertex[0]);
        trans.leftMultMatrix(cv1, vertex[1]);
        newElt[1].m_data[0] = 0;
        newElt[1].m_data[1] = 4;
        newElt[1].m_data[2] = 5;
    }

    public static PgElementSet fundQuadrilateral(PiVector param) {
        PgElementSet geom = new PgElementSet(3);
        geom.setNumVertices(4);
        geom.setNumElements(1);
        int p = param.m_data[1];
        double phi = Math.PI / (double)p;
        double a1 = PuHyperboloid.dist(PuHyperboloid.m_O, PuHyperboloid.m_P);
        double a2 = PuMath.asinh((double)(Math.cos(phi) / Math.sinh(a1)));
        double b1 = PuMath.acosh((double)(Math.cosh(a1) / Math.sin(phi)));
        PdVector N0 = new PdVector(Math.cosh(b1), -Math.sinh(b1), 0.0);
        geom.setVertex(0, N0);
        PdVector N1 = new PdVector(1.0, 0.0, 0.0);
        geom.setVertex(1, new PdVector(1.0, 0.0, 0.0));
        PdVector N2 = new PdVector(Math.cosh(2.0 * a2), 0.0, PuMath.sinh((double)(2.0 * a2)));
        geom.setVertex(2, N2);
        PdMatrix m = new PdMatrix(3);
        double theta = PuHyperboloid.orientedAngle(N1, N2, N0);
        PuHyperboloid.translateToOrigin(m, N2);
        PdMatrix minv = PdMatrix.copyNew((PdMatrix)m);
        minv.invert();
        m.leftMult(PuIsometry.translate(-b1));
        m.leftMult(PuIsometry.rotation(-theta));
        m.leftMult(minv);
        PdVector N3 = new PdVector(3);
        N3.leftMultMatrix(m, N2);
        geom.setVertex(3, N3);
        geom.setElement(0, 0, 1, 2, 3);
        return geom;
    }

    public static PgElementSet generateSymmetryGroup(PiVector param) {
        m_elementSet = PuQuadTesselation.fundQuadrilateral(param);
        return m_elementSet;
    }

    public static PdMatrix[] getABC(PdVector[] N) {
        PdMatrix[] iso = new PdMatrix[3];
        double theta = PuHyperboloid.orientedAngle(N[3], N[0], N[2]);
        double alpha = PuHyperboloid.orientedAngle(N[0], N[1], N[3]);
        PdMatrix T = new PdMatrix(3);
        PdMatrix Tinv = new PdMatrix(3);
        PuHyperboloid.translateToOrigin(T, N[0]);
        Tinv.copy(T);
        Tinv.invert();
        iso[1] = T;
        iso[1].leftMult(PuIsometry.rotation(alpha + theta));
        iso[1].leftMult(Tinv);
        PdVector midN1N2 = PuHyperboloid.getMidPoint(N[1], N[2]);
        double phi = Math.PI;
        PdMatrix R0 = new PdMatrix(3);
        PuHyperboloid.rotateAroundPoint(R0, midN1N2, phi);
        PdVector tN0 = new PdVector(3);
        PdVector tN3 = new PdVector(3);
        tN0.leftMultMatrix(R0, N[0]);
        tN3.leftMultMatrix(R0, N[3]);
        PdVector mid = PuHyperboloid.getMidPoint(tN0, tN3);
        PdMatrix R1 = new PdMatrix(3);
        PuHyperboloid.rotateAroundPoint(R1, mid, phi);
        R0.leftMult(R1);
        iso[0] = R0;
        iso[2] = new PdMatrix(3);
        PdMatrix T1 = PuHyperboloid.mapToCoshCurve(N[0], N[1]);
        PdMatrix T2 = PuHyperboloid.mapToCoshCurve(N[3], N[2]);
        T1.invert();
        T2.leftMult(T1);
        iso[2] = T2;
        return iso;
    }
}

