/*
 * Decompiled with CFR 0.152.
 */
package devRegularMap.vecmath;

import devRegularMap.vecmath.PuCompGeometry;
import devRegularMap.vecmath.PuHyperbolic;
import devRegularMap.vecmath.PuLorentz3D;
import devRegularMap.vecmath.PuSearchGenAndSpaceModel;
import java.awt.Color;
import jv.geom.PgElementSet;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PuPlanarRegularMap {
    protected Color c0;
    protected Color c1;
    protected Color c2;
    protected Color c3;
    protected Color c4;
    protected int m_p;
    protected int m_q;
    protected int m_ordG;
    protected String[] m_elt;
    protected int m_discrEdge;
    protected int m_discrEdgeT;
    protected PuSearchGenAndSpaceModel m_rep;
    protected PiVector[][] m_subElt;
    protected Color[][] m_col;
    protected PiVector[] m_edgeinterpolation;
    protected int[] m_deletedElt;
    protected Color[] m_color;
    protected PuLorentz3D m_A;
    protected PuLorentz3D m_B;
    protected PuLorentz3D m_C;
    protected PuLorentz3D m_ABC;
    protected PuLorentz3D m_AB;
    protected int m_numPpattern;
    protected PvDisplayIf m_display;
    protected boolean m_dualIsEnable;

    public PuPlanarRegularMap(PvDisplayIf currDisp, String[] elt, int[] ordElt, int g, int i, int p, int q, int discr, boolean flag) {
        this.m_elt = elt;
        this.m_p = p;
        this.m_q = q;
        this.m_discrEdge = discr;
        this.m_discrEdgeT = 8;
        this.m_ordG = elt.length;
        this.m_display = currDisp;
        this.m_dualIsEnable = flag;
        if (this.m_dualIsEnable) {
            this.m_p = q;
            this.m_q = p;
        }
        this.c0 = new Color(232, 159, 155);
        this.c1 = new Color(242, 231, 145);
        this.c3 = new Color(190, 217, 130);
        this.c2 = new Color(156, 191, 235);
        this.c4 = new Color(201, 159, 223);
        if (this.m_p % 2 == 0) {
            if (this.m_q % 5 == 0) {
                this.m_color = new Color[]{this.c0, this.c1, this.c2, this.c3, this.c4};
            } else if (this.m_q % 4 == 0) {
                this.m_color = new Color[]{this.c0, this.c1, this.c2, this.c3};
            } else if (this.m_q % 3 == 0) {
                this.m_color = new Color[]{this.c0, this.c1, this.c2};
            } else if (this.m_q % 2 == 0) {
                this.m_color = new Color[]{this.c0, this.c1};
            }
        } else if (this.m_p % 3 == 0 && this.m_q % 2 != 0) {
            this.m_color = new Color[]{Color.darkGray, Color.orange};
        } else if (this.m_p % 3 == 0 && (this.m_q % 2 == 0 || this.m_q % 3 == 0)) {
            this.m_color = new Color[]{this.c0, this.c1, this.c2, this.c3};
        } else if (this.m_p % 5 == 0) {
            this.m_color = new Color[]{this.c3, this.c4};
        }
        this.m_rep = new PuSearchGenAndSpaceModel(this.m_p, this.m_q, g, i, elt, ordElt, this.m_dualIsEnable);
        this.m_rep.getGenerator();
    }

    public void setNumDiscr(int discr) {
        this.m_discrEdge = discr;
    }

    public Color[] defaultColoring() {
        return this.m_color;
    }

    public PuLorentz3D[] getGenTransformations() {
        return new PuLorentz3D[]{this.m_A, this.m_B, this.m_C, this.m_AB, this.m_ABC};
    }

    public PgElementSet getPlanarRM() {
        int color = this.m_color.length;
        PuLorentz3D.initLorentzUtility(this.m_p, this.m_q, color);
        PgElementSet PgonPattern = PuHyperbolic.getFundTriangle(this.m_p, this.m_q, this.m_discrEdgeT);
        PgonPattern.getElement(0).setName("I");
        PgonPattern.setElementColor(0, this.m_color[0]);
        int numVert = PgonPattern.getNumVertices();
        PdVector[] vertex = PgonPattern.getVertices();
        PuHyperbolic.liftToHyperboloid(vertex);
        PuLorentz3D trans = new PuLorentz3D();
        int n = 0;
        while (n < this.m_elt.length) {
            PdVector[] rotVertex = new PdVector[numVert];
            int i = 0;
            while (i < numVert) {
                rotVertex[i] = new PdVector(3);
                trans = PuHyperbolic.getTrans(this.m_elt[n]);
                trans.getMatrix().leftMultMatrix(rotVertex[i], vertex[i]);
                ++i;
            }
            PuHyperbolic.projectToPoincareDisk(rotVertex);
            int currnumVert = PgonPattern.getNumVertices();
            int currnumElt = PgonPattern.getNumElements();
            PgonPattern.setNumVertices(numVert + currnumVert);
            PgonPattern.setNumElements(currnumElt + 1);
            int i2 = 0;
            while (i2 < numVert) {
                PgonPattern.setVertex(currnumVert + i2, rotVertex[i2]);
                ++i2;
            }
            PiVector tmp = (PiVector)PgonPattern.getElement(0).clone();
            tmp.add(currnumVert);
            PgonPattern.setElement(currnumElt, tmp);
            PgonPattern.getElement(currnumElt).setName(this.m_elt[n]);
            PgonPattern.setElementColor(currnumElt, this.m_color[trans.getColorPermutation().getEntry(0)]);
            ++n;
        }
        PuHyperbolic.projectToPoincareDisk(vertex);
        PgonPattern.showElementColors(true);
        PgonPattern.setName("Planar Regular Map");
        return PgonPattern;
    }

    public PgElementSet getTesselation() {
        this.m_numPpattern = 2;
        int p = this.m_p;
        int q = this.m_q;
        int nLayers = 3;
        PuLorentz3D.initLorentzUtility(p, q, this.m_color.length);
        PuLorentz3D RotateQ = PuLorentz3D.RotateQ();
        PuLorentz3D RotateP = PuLorentz3D.RotateP();
        PuLorentz3D Rotate2P = new PuLorentz3D();
        PuLorentz3D Rotate3P = new PuLorentz3D();
        Rotate2P.TransMult(RotateP, RotateP);
        Rotate3P.TransMult(RotateP, Rotate2P);
        PuLorentz3D[] trans = new PuLorentz3D[]{RotateP, RotateQ, Rotate2P, Rotate3P};
        PgElementSet PgonPattern = new PgElementSet(3);
        PgElementSet Tesselation = (PgElementSet)PgonPattern.clone();
        int i = 0;
        while (i < Tesselation.getNumElements()) {
            Tesselation.setElementColor(i, this.m_color[0]);
            ++i;
        }
        PuLorentz3D RotateCenter = PuLorentz3D.Identity();
        PuLorentz3D RotateVertex = new PuLorentz3D();
        int i2 = 0;
        while (i2 < p) {
            RotateVertex.TransMult(RotateCenter, RotateQ);
            this.Replicate(RotateVertex, nLayers - 2, 1, p, q, trans, PgonPattern, Tesselation);
            int j = 0;
            while (j < q - 3) {
                RotateVertex.TransMult(RotateVertex, RotateQ);
                this.Replicate(RotateVertex, nLayers - 2, 0, p, q, trans, PgonPattern, Tesselation);
                ++j;
            }
            RotateCenter.TransMult(RotateCenter, RotateP);
            ++i2;
        }
        Tesselation.showElementColors(true);
        return Tesselation;
    }

    public PgElementSet fundPgon(int p, int q, int discr) {
        PgElementSet triangle = new PgElementSet(3);
        PdVector firstPoint = new PdVector(0.0, 0.0, 0.0);
        double s = Math.sin(Math.PI / (double)p);
        double c = Math.cos(Math.PI / (double)q);
        double tan2 = s * s / (c * c);
        double cotan2 = c * c / (s * s);
        double d = 1.0 / Math.sqrt(1.0 - tan2);
        double r = 1.0 / Math.sqrt(cotan2 - 1.0);
        PdVector secondPoint = new PdVector(3);
        secondPoint.m_data[0] = d - r;
        double a = Math.tan(Math.PI / (double)p);
        double b = Math.sin(Math.PI * (0.5 - 1.0 / (double)p - 1.0 / (double)q));
        double xthirdPoint = b / Math.sqrt(b * b * (1.0 - a * a) + 2.0 * a * b * Math.sqrt(1.0 - b * b));
        double ythirdPoint = a * xthirdPoint;
        PdVector thirdPoint = new PdVector(xthirdPoint, ythirdPoint, 0.0);
        triangle.setNumVertices(p * (discr - 1));
        triangle.setNumElements(2 * p);
        PdVector[] Edge1 = PuHyperbolic.makeEdge(firstPoint, secondPoint, discr);
        PdVector[] Edge2 = PuHyperbolic.makeEdge(secondPoint, thirdPoint, discr);
        PdVector[] Edge3 = PuHyperbolic.makeEdge(thirdPoint, firstPoint, discr);
        int ind = 0;
        PiVector elt = new PiVector(3 * (discr - 1));
        PdVector[][] pdVectorArrayArray = new PdVector[][]{Edge1, Edge2, Edge3};
        int n = pdVectorArrayArray.length;
        int n2 = 0;
        while (n2 < n) {
            PdVector[] e = pdVectorArrayArray[n2];
            int i = 0;
            while (i < e.length - 1) {
                triangle.setVertex(ind, e[i]);
                elt.setEntry(ind, ind);
                ++ind;
                ++i;
            }
            ++n2;
        }
        triangle.setElement(0, elt);
        PuHyperbolic.reflect(triangle, this.m_discrEdgeT);
        int i = 1;
        while (i < p) {
            triangle.setElement(2 * i, PuHyperbolic.rotate(triangle.getElement(0), triangle, (double)(2 * i) * Math.PI / (double)p, this.m_discrEdgeT));
            triangle.setElement(2 * i + 1, PuHyperbolic.rotate(triangle.getElement(1), triangle, (double)(2 * i) * Math.PI / (double)p, this.m_discrEdgeT));
            ++i;
        }
        triangle.removeUnusedVertices();
        return triangle;
    }

    private void Replicate(PuLorentz3D InitialTran, int LayersTodo, int AdjacencyType, int p, int q, PuLorentz3D[] trans, PgElementSet PgonPattern, PgElementSet Tesselation) {
        PuLorentz3D RotateCenter = new PuLorentz3D();
        PuLorentz3D RotateVertex = new PuLorentz3D();
        this.DrawPgonPattern(InitialTran, PgonPattern, Tesselation);
        if (LayersTodo > 0) {
            int ExposedEdges;
            if (AdjacencyType == 1) {
                ExposedEdges = p - 3;
                RotateCenter.TransMult(InitialTran, trans[3]);
            } else {
                ExposedEdges = p - 2;
                RotateCenter.TransMult(InitialTran, trans[2]);
            }
            int i = 0;
            while (i < ExposedEdges) {
                RotateVertex.TransMult(RotateCenter, trans[1]);
                this.Replicate(RotateVertex, LayersTodo - 1, 1, p, q, trans, PgonPattern, Tesselation);
                int VertexPgons = i < ExposedEdges - 1 ? q - 3 : q - 4;
                int j = 0;
                while (j < VertexPgons) {
                    RotateVertex.TransMult(RotateVertex, trans[1]);
                    this.Replicate(RotateVertex, LayersTodo - 1, 0, p, q, trans, PgonPattern, Tesselation);
                    ++j;
                }
                RotateCenter.TransMult(RotateCenter, trans[0]);
                ++i;
            }
        }
    }

    private void DrawPgonPattern(PuLorentz3D rotateVertex2, PgElementSet PgonPattern, PgElementSet Tesselation) {
        int numVert = PgonPattern.getNumVertices();
        int numElement = PgonPattern.getNumElements();
        PdVector[] vertex = PgonPattern.getVertices();
        PuHyperbolic.liftToHyperboloid(vertex);
        PdVector[] rotVertex = new PdVector[numVert];
        int i = 0;
        while (i < numVert) {
            rotVertex[i] = new PdVector(3);
            rotateVertex2.getMatrix().leftMultMatrix(rotVertex[i], vertex[i]);
            ++i;
        }
        PuHyperbolic.projectToPoincareDisk(rotVertex);
        PuHyperbolic.projectToPoincareDisk(vertex);
        Tesselation.setNumVertices(this.m_numPpattern * numVert);
        Tesselation.setNumElements(this.m_numPpattern * numElement);
        i = 0;
        while (i < numVert) {
            Tesselation.setVertex((this.m_numPpattern - 1) * numVert + i, rotVertex[i]);
            ++i;
        }
        i = 0;
        while (i < numElement) {
            PiVector tmp = (PiVector)PgonPattern.getElement(i).clone();
            tmp.add((this.m_numPpattern - 1) * numVert);
            Tesselation.setElement(i + (this.m_numPpattern - 1) * numElement, tmp);
            Tesselation.setElementColor(i + (this.m_numPpattern - 1) * numElement, this.m_color[rotateVertex2.getColorPermutation().getEntry(0)]);
            ++i;
        }
        ++this.m_numPpattern;
    }

    private PgElementSet getFoldout(boolean clip) {
        PgElementSet foldout = new PgElementSet(3);
        foldout.setName("Foldout");
        PdVector N1 = new PdVector(0.0, 0.0, 0.0);
        String[] generator = this.m_rep.getGenerator();
        PuLorentz3D.initLorentzUtility(this.m_p, this.m_q, this.m_color.length);
        this.initTransformations(generator);
        if (generator[1].charAt(0) == 's') {
            PuHyperbolic.mapToPointTriangle(N1, PuHyperbolic.getPofTriangle(this.m_p, this.m_q));
        }
        PdVector[] baseCorner = PuHyperbolic.getOtherPointQuarterTube(N1, generator);
        PdVector[] ct1 = new PdVector[]{baseCorner[0], baseCorner[1], baseCorner[2]};
        PdVector[] ct2 = new PdVector[]{baseCorner[0], baseCorner[2], baseCorner[3]};
        if (!PuHyperbolic.ccw(ct1)) {
            PdVector tmp = baseCorner[1];
            baseCorner[1] = baseCorner[3];
            baseCorner[3] = tmp;
        } else if (!PuHyperbolic.ccw(ct2)) {
            PdVector tmp = baseCorner[2];
            baseCorner[2] = baseCorner[3];
            baseCorner[3] = tmp;
        }
        PuHyperbolic.makeInitQtube(baseCorner, foldout, this.m_discrEdge);
        if (clip) {
            foldout = PuHyperbolic.refinedPolygon(baseCorner[0], baseCorner[1], baseCorner[3], baseCorner[2], this.m_discrEdge);
            this.m_subElt = new PiVector[foldout.getNumElements()][10];
            this.m_deletedElt = new int[foldout.getNumElements()];
            this.m_col = new Color[foldout.getNumElements()][10];
            this.m_edgeinterpolation = new PiVector[1000];
            foldout = this.generateClipedQuartertubeNew(foldout, baseCorner);
        } else {
            foldout = PuHyperbolic.refinedPolygon(baseCorner[0], baseCorner[1], baseCorner[3], baseCorner[2], this.m_discrEdge);
        }
        return foldout;
    }

    public PgElementSet getTubeFoldout(boolean clip) {
        PgElementSet foldout = this.getFoldout(clip);
        PiVector[] baseQuad = foldout.getElements();
        Color[] eltcol = foldout.getElementColors();
        PdVector[] currVertex = foldout.getVertices();
        PuHyperbolic.liftToHyperboloid(currVertex);
        PuLorentz3D BC = new PuLorentz3D();
        BC.TransMult(this.m_B, this.m_C);
        PuLorentz3D ABC = new PuLorentz3D();
        ABC.TransMult(this.m_A, BC);
        PuLorentz3D AB = new PuLorentz3D();
        AB.TransMult(this.m_A, this.m_B);
        PuLorentz3D[] posReflection = new PuLorentz3D[]{this.m_C, AB, ABC};
        int j = 0;
        while (j < 3) {
            int currnumVertices = foldout.getNumVertices();
            int currnumElements = foldout.getNumElements();
            foldout.setNumElements(currnumElements + baseQuad.length);
            PiVector[] newbaseQuad = new PiVector[baseQuad.length];
            int k = 0;
            while (k < newbaseQuad.length) {
                newbaseQuad[k] = new PiVector(baseQuad[k].getSize());
                int l = 0;
                while (l < newbaseQuad[k].getSize()) {
                    newbaseQuad[k].setEntry(l, baseQuad[k].getEntry(l) + currnumVertices);
                    ++l;
                }
                foldout.setElement(currnumElements + k, newbaseQuad[k]);
                if (clip) {
                    Color inducedcol = new Color(0);
                    if (eltcol[k].getRGB() == this.m_color[0].getRGB()) {
                        inducedcol = this.m_color[posReflection[j].getColorPermutation().getEntry(0)];
                    }
                    if (eltcol[k].getRGB() == this.m_color[1].getRGB()) {
                        inducedcol = this.m_color[posReflection[j].getColorPermutation().getEntry(1)];
                    }
                    if (this.m_color.length > 2 && eltcol[k].getRGB() == this.m_color[2].getRGB()) {
                        inducedcol = this.m_color[posReflection[j].getColorPermutation().getEntry(2)];
                    }
                    if (this.m_color.length > 3 && eltcol[k].getRGB() == this.m_color[3].getRGB()) {
                        inducedcol = this.m_color[posReflection[j].getColorPermutation().getEntry(3)];
                    }
                    if (this.m_color.length > 4 && eltcol[k].getRGB() == this.m_color[4].getRGB()) {
                        inducedcol = this.m_color[posReflection[j].getColorPermutation().getEntry(4)];
                    }
                    foldout.setElementColor(currnumElements + k, inducedcol);
                }
                ++k;
            }
            foldout.setNumVertices(currnumVertices + currVertex.length);
            k = 0;
            while (k < currVertex.length) {
                PdVector tmp = new PdVector(3);
                posReflection[j].getMatrix().leftMultMatrix(tmp, currVertex[k]);
                foldout.setVertex(currnumVertices + k, tmp);
                ++k;
            }
            ++j;
        }
        PuHyperbolic.projectToPoincareDisk(foldout.getVertices());
        foldout.makeElementNormals();
        return foldout;
    }

    private void replicateFoldout(PiVector[] neighbor, int numPol, PgElementSet fundTube, boolean colored) {
        int currentindex = 0;
        int nextfreeindex = 1;
        int[] processed = new int[numPol];
        int[] reflectsign = new int[numPol];
        PuLorentz3D[] currentTrans = new PuLorentz3D[numPol];
        boolean[] tobeChecked = new boolean[numPol];
        tobeChecked[0] = true;
        processed[0] = currentindex;
        reflectsign[0] = 1;
        currentTrans[0] = PuLorentz3D.Identity();
        PiVector[] baseQuad = fundTube.getElements();
        Color[] eltcol = fundTube.getElementColors();
        PdVector[] currVertex = fundTube.getVertices();
        PuHyperbolic.liftToHyperboloid(currVertex);
        PuLorentz3D invB = this.m_B.inverse();
        PuLorentz3D ABB = new PuLorentz3D();
        ABB.TransMult(this.m_B, this.m_B);
        ABB.TransMult(this.m_A, ABB);
        PuLorentz3D[] posReflection = new PuLorentz3D[]{this.m_B, invB, ABB, this.m_A};
        int i = 0;
        while (i < processed.length) {
            PiVector nbh = neighbor[processed[i]];
            PuLorentz3D[] trans = new PuLorentz3D[3];
            int j = 0;
            while (j < 1) {
                if (!tobeChecked[nbh.m_data[j]]) {
                    trans = posReflection;
                    processed[nextfreeindex] = nbh.m_data[j];
                    tobeChecked[nbh.m_data[j]] = true;
                    currentTrans[nextfreeindex] = new PuLorentz3D();
                    currentTrans[nextfreeindex].TransMult(currentTrans[i], trans[j]);
                    int currnumVertices = fundTube.getNumVertices();
                    int currnumElements = fundTube.getNumElements();
                    fundTube.setNumElements(currnumElements + baseQuad.length);
                    PiVector[] newbaseQuad = new PiVector[baseQuad.length];
                    Color tubCol = Color.getHSBColor((float)Math.random() * 100.0f, (float)Math.random() * 200.0f, (float)Math.random() * 200.0f);
                    int k = 0;
                    while (k < newbaseQuad.length) {
                        newbaseQuad[k] = new PiVector(baseQuad[k].getSize());
                        int l = 0;
                        while (l < newbaseQuad[k].getSize()) {
                            newbaseQuad[k].setEntry(l, baseQuad[k].getEntry(l) + currnumVertices);
                            ++l;
                        }
                        fundTube.setElement(currnumElements + k, newbaseQuad[k]);
                        fundTube.getElement(currnumElements + k).setName("Q" + j);
                        if (colored) {
                            Color inducedcol = new Color(0);
                            if (eltcol[k].getRGB() == this.c0.getRGB()) {
                                inducedcol = this.m_color[currentTrans[nextfreeindex].getColorPermutation().getEntry(0)];
                            }
                            if (eltcol[k].getRGB() == this.c1.getRGB()) {
                                inducedcol = this.m_color[currentTrans[nextfreeindex].getColorPermutation().getEntry(1)];
                            }
                            if (eltcol[k].getRGB() == this.c2.getRGB()) {
                                inducedcol = this.m_color[currentTrans[nextfreeindex].getColorPermutation().getEntry(2)];
                            }
                            if (eltcol[k].getRGB() == this.c3.getRGB()) {
                                inducedcol = this.m_color[currentTrans[nextfreeindex].getColorPermutation().getEntry(3)];
                            }
                            if (eltcol[k].getRGB() == this.c4.getRGB()) {
                                inducedcol = this.m_color[currentTrans[nextfreeindex].getColorPermutation().getEntry(4)];
                            }
                            fundTube.setElementColor(currnumElements + k, inducedcol);
                        } else {
                            fundTube.setElementColor(currnumElements + k, tubCol);
                        }
                        ++k;
                    }
                    fundTube.setNumVertices(currnumVertices + currVertex.length);
                    k = 0;
                    while (k < currVertex.length) {
                        PdVector tmp = new PdVector(3);
                        currentTrans[nextfreeindex].getMatrix().leftMultMatrix(tmp, currVertex[k]);
                        fundTube.setVertex(currnumVertices + k, tmp);
                        ++k;
                    }
                    if (nextfreeindex < processed.length - 1) {
                        ++nextfreeindex;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void initTransformations(String[] Generator) {
        this.m_A = PuHyperbolic.getTrans(Generator[0]);
        this.m_B = PuHyperbolic.getTrans(Generator[1]);
        this.m_C = PuHyperbolic.getTrans(Generator[2]);
        this.m_AB = new PuLorentz3D();
        this.m_ABC = new PuLorentz3D();
        this.m_AB.TransMult(this.m_A, this.m_B);
        this.m_ABC.TransMult(this.m_AB, this.m_C);
    }

    public PgElementSet getFundSquare() {
        PgElementSet planarSurface = this.getClipFoldout();
        PgElementSet planarGrid = this.getUnClipFoldout();
        PiVector[][] subElt = this.getSubEltIndex();
        Color[][] color = this.getTileColors();
        PgElementSet squareGridI = new PgElementSet(3);
        squareGridI.setNumVertices(this.m_discrEdge * this.m_discrEdge * 4);
        int ind = 0;
        int j = 0;
        while (j < this.m_discrEdge) {
            int i = 0;
            while (i < this.m_discrEdge) {
                PdVector vert = new PdVector(-1.0 + (double)i / (double)this.m_discrEdge, (double)j / (double)this.m_discrEdge, 0.0);
                squareGridI.setVertex(ind, vert);
                ++ind;
                ++i;
            }
            ++j;
        }
        squareGridI.setNumElements((this.m_discrEdge - 1) * (this.m_discrEdge - 1));
        squareGridI.makeQuadrConn(this.m_discrEdge, this.m_discrEdge);
        PdVector[] vertex = squareGridI.getVertices();
        PiVector[] element = squareGridI.getElements();
        PdVector[] planarGridVertex = planarGrid.getVertices();
        boolean[] oriented = new boolean[squareGridI.getNumElements()];
        int numVert = planarGrid.getNumVertices();
        int numElt = planarGrid.getNumElements();
        double[] triangleArea = new double[4];
        int i = 0;
        while (i < numElt) {
            PiVector squareElt = element[i];
            PiVector planElt = planarGrid.getElement(i);
            if (!oriented[i]) {
                int tmp = squareElt.getEntry(1);
                squareElt.setEntry(1, squareElt.getEntry(3));
                squareElt.setEntry(3, tmp);
                oriented[i] = true;
            }
            int l = 0;
            while (l < 4) {
                triangleArea[l] = PuHyperbolic.computeAreaHyperbolic(planarGridVertex[planElt.m_data[(l + 3) % 4]], planarGridVertex[planElt.m_data[l]], planarGridVertex[planElt.m_data[(l + 1) % 4]]);
                ++l;
            }
            PiVector[] currPlanSubElt = subElt[i];
            if (currPlanSubElt[0] != null) {
                squareElt.setTag(2);
            }
            int j2 = 0;
            while (j2 < currPlanSubElt.length) {
                if (currPlanSubElt[j2] == null) break;
                PiVector elt = currPlanSubElt[j2];
                int k = 0;
                while (k < elt.getSize()) {
                    if (elt.getEntry(k) >= numVert) {
                        PdVector planVert = planarSurface.getVertex(elt.m_data[k]);
                        double[] localArea = new double[4];
                        double[] w = new double[4];
                        int l2 = 0;
                        while (l2 < 4) {
                            localArea[l2] = PuHyperbolic.computeAreaHyperbolic(planVert, planarGridVertex[planElt.m_data[l2]], planarGridVertex[planElt.m_data[(l2 + 1) % 4]]);
                            ++l2;
                        }
                        double sum = 0.0;
                        int l3 = 0;
                        while (l3 < 4) {
                            w[l3] = triangleArea[l3] * localArea[(l3 + 1) % 4] * localArea[(l3 + 2) % 4];
                            sum += w[l3];
                            ++l3;
                        }
                        PdVector nv = new PdVector(0.0, 0.0, 0.0);
                        int l4 = 0;
                        while (l4 < 4) {
                            nv = PdVector.blendNew((double)1.0, (PdVector)nv, (double)w[l4], (PdVector)vertex[squareElt.m_data[l4]]);
                            ++l4;
                        }
                        nv.multScalar(1.0 / sum);
                        int nov = squareGridI.getNumVertices();
                        squareGridI.setNumVertices(nov + 1);
                        squareGridI.setVertex(nov, nv);
                        elt.setEntry(k, nov);
                    }
                    ++k;
                }
                int noes = squareGridI.getNumElements();
                squareGridI.setNumElements(noes + 1);
                squareGridI.setElement(noes, elt);
                squareGridI.setElementColor(noes, color[i][j2]);
                ++j2;
            }
            ++i;
        }
        squareGridI.removeMarkedElements();
        squareGridI.showElementColors(true);
        squareGridI.makeElementNormals();
        return squareGridI;
    }

    public PiVector[][] getSubEltIndex() {
        return this.m_subElt;
    }

    public Color[][] getTileColors() {
        return this.m_col;
    }

    public PiVector[] getEdgeInterpolation() {
        return this.m_edgeinterpolation;
    }

    public int[] getDeletedElements() {
        return this.m_deletedElt;
    }

    public PgElementSet getClipFoldout() {
        return this.getFoldout(true);
    }

    public PgElementSet getUnClipFoldout() {
        return this.getFoldout(false);
    }

    private PgElementSet generateClipedQuartertubeNew(PgElementSet geom, PdVector[] baseCorner) {
        PgElementSet tesselation = this.getTesselation();
        int numElement = geom.getNumElements();
        int discr = this.m_discrEdgeT;
        PuHyperbolic.projectToKlein(geom.getVertices());
        PuHyperbolic.projectToKlein(tesselation.getVertices());
        PuHyperbolic.projectToKlein(baseCorner);
        PiVector tileIntersect = new PiVector(1);
        int ind = 0;
        PdVector[] tessVertex = tesselation.getVertices();
        PiVector[] tessElement = tesselation.getElements();
        int i = 0;
        while (i < tesselation.getNumElements()) {
            boolean intersect = false;
            PiVector celt = tessElement[i];
            PdVector[] ct = new PdVector[this.m_p];
            int j = 0;
            while (j < this.m_p) {
                ct[j] = tessVertex[celt.getEntry(j * (discr - 1))];
                ++j;
            }
            j = 0;
            while (j < this.m_p) {
                PdVector ts0 = ct[j];
                PdVector ts1 = ct[(j + 1) % this.m_p];
                intersect = PuCompGeometry.intersect2D_SegPoly(ts0, ts1, baseCorner);
                if (intersect) break;
                ++j;
            }
            if (intersect) {
                tileIntersect.setEntry(ind, i);
                ++ind;
            }
            ++i;
        }
        PiVector count = new PiVector(1);
        count.setEntry(0, 0);
        int i2 = 0;
        while (i2 < tileIntersect.getSize()) {
            PdVector[] cqpos;
            int l = tileIntersect.getEntry(i2);
            PiVector celt = new PiVector(this.m_p);
            PdVector[] ct = new PdVector[this.m_p];
            int j = 0;
            while (j < this.m_p) {
                celt.m_data[j] = tessElement[l].m_data[j * (discr - 1)];
                ct[j] = tessVertex[celt.m_data[j]];
                ++j;
            }
            PdVector[] firstTri = new PdVector[]{ct[0], ct[1], ct[2]};
            if (!PuHyperbolic.ccw(firstTri)) {
                celt.invert();
                int j2 = 0;
                while (j2 < this.m_p) {
                    ct[j2] = tessVertex[celt.m_data[j2]];
                    ++j2;
                }
            }
            Color ccol = tesselation.getElementColor(tileIntersect.getEntry(i2));
            PiVector cqintersect = new PiVector();
            PdVector[] quadvertex = geom.getVertices();
            ind = 0;
            int inside = 0;
            int j3 = 0;
            while (j3 < numElement) {
                geom.getElement(j3).setTag(2);
                boolean intersect = false;
                PiVector cquad = geom.getElement(j3);
                cqpos = new PdVector[]{quadvertex[cquad.getEntry(0)], quadvertex[cquad.getEntry(1)], quadvertex[cquad.getEntry(2)], quadvertex[cquad.getEntry(3)]};
                int k = 0;
                while (k < 4) {
                    PdVector qs0 = cqpos[k];
                    PdVector qs1 = cqpos[(k + 1) % 3];
                    intersect = PuCompGeometry.intersect2D_SegPoly(qs0, qs1, ct);
                    if (intersect) break;
                    if (PuCompGeometry.insideTriangle(qs0, ct, false)) {
                        ++inside;
                    }
                    ++k;
                }
                if (intersect || inside == 4) {
                    cqintersect.addEntry(j3);
                }
                ++j3;
            }
            j3 = 0;
            while (j3 < cqintersect.getSize()) {
                int indexElt = cqintersect.getEntry(j3);
                PiVector quadIndex = geom.getElement(indexElt);
                cqpos = new PdVector[]{quadvertex[quadIndex.getEntry(0)], quadvertex[quadIndex.getEntry(1)], quadvertex[quadIndex.getEntry(2)], quadvertex[quadIndex.getEntry(3)]};
                ind = 0;
                int currentnoe = geom.getNumElements();
                PiVector cutQuad = new PiVector(3);
                PdVector tpoint = new PdVector(3);
                PiVector i_point = new PiVector();
                if (PuCompGeometry.isPointInsideQuad(ct, cqpos, tpoint, i_point)) {
                    int currentnov = geom.getNumVertices();
                    int n = cutQuad.getSize();
                    geom.setNumVertices(currentnov + 1);
                    geom.setVertex(currentnov, tpoint);
                    if (cutQuad.m_data[0] == cutQuad.m_data[n - 1]) {
                        cutQuad.removeEntry(n - 1);
                        --n;
                    }
                    PdVector p1 = ct[(i_point.m_data[0] + (this.m_p - 1)) % this.m_p];
                    PdVector p2 = ct[i_point.m_data[0]];
                    int k = 0;
                    while (k < n) {
                        if (PuCompGeometry.liesOnSegment(geom.getVertex(cutQuad.m_data[k]), p1, p2)) {
                            PiVector c_tmp = (PiVector)cutQuad.clone();
                            cutQuad.setSize(n + 1);
                            cutQuad.setEntry(k + 1, currentnov);
                            int l1 = k + 2;
                            while (l1 < n + 1) {
                                cutQuad.setEntry(l1, c_tmp.m_data[l1 - 1]);
                                ++l1;
                            }
                            break;
                        }
                        ++k;
                    }
                }
                if (cutQuad.getSize() > 2) {
                    geom.setDimOfElements(-1);
                    geom.setNumElements(currentnoe + 1);
                    geom.setElement(currentnoe, cutQuad);
                    geom.setElementColor(currentnoe, ccol);
                    if (this.m_subElt[indexElt] == null) {
                        this.m_subElt[indexElt] = new PiVector[10];
                        this.m_subElt[indexElt][0] = cutQuad;
                        this.m_col[indexElt][0] = ccol;
                    } else {
                        int k = 0;
                        while (k < 10) {
                            if (this.m_subElt[indexElt][k] == null && cutQuad.getSize() > 2) {
                                this.m_subElt[indexElt][k] = cutQuad;
                                this.m_col[indexElt][k] = ccol;
                                break;
                            }
                            ++k;
                        }
                    }
                }
                ++j3;
            }
            ++i2;
        }
        PuHyperbolic.projectfromKleintoPoincare(geom.getVertices());
        PuHyperbolic.projectfromKleintoPoincare(tesselation.getVertices());
        geom.showElementColors(true);
        geom.makeNeighbour();
        geom.removeMarkedElements();
        geom.makeElementNormals();
        geom.removeUnusedVertices();
        return geom;
    }
}

