/*
 * Decompiled with CFR 0.152.
 */
package devRegularMap.vecmath;

import devRegularMap.functions.PgGon;
import devRegularMap.number.PgyroEinVector;
import devRegularMap.vecmath.PuCompGeometry;
import devRegularMap.vecmath.PuHyperboloid;
import java.awt.Color;
import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;

public class PuMesh4gGon {
    private static int m_discr = 30;

    public static PgElementSet[] createMesh(PgGon gon) {
        PdVector ao_vs;
        PdVector a_vs;
        gon.makeGlobalOrientation();
        PdVector[] vertex = gon.getVertices();
        PiVector[] polygon = gon.getPolygons();
        int g = gon.getNumPolygons() / 4;
        int noe = 2 * g;
        int a = gon.getStart();
        int ao = gon.followNextBy(2 * g - 1);
        boolean oriented = gon.hasSameOrientation(a, ao);
        if (oriented) {
            a_vs = vertex[polygon[a].m_data[0]];
            ao_vs = vertex[polygon[ao].m_data[0]];
        } else {
            a_vs = vertex[polygon[a].m_data[0]];
            ao_vs = vertex[polygon[ao].m_data[1]];
        }
        PdVector mid = PuHyperboloid.getMidPoint(a_vs, ao_vs);
        PgElementSet[] mesh = new PgElementSet[noe];
        int s = gon.getStart();
        int sn = gon.getNext(s);
        PdVector[] v = new PdVector[4];
        int i = 0;
        while (i < noe) {
            v[0] = mid;
            v[1] = vertex[polygon[s].m_data[i % 2]];
            v[2] = vertex[polygon[s].m_data[(i + 1) % 2]];
            v[3] = vertex[polygon[sn].m_data[(i + 1) % 2]];
            mesh[i] = PuMesh4gGon.make2DGrid(v, m_discr);
            s = gon.followNextBy(2 * i + 2);
            sn = gon.followNextBy(2 * i + 3);
            ++i;
        }
        return mesh;
    }

    private static PgElementSet make2DGrid(PdVector[] N, int n) {
        int j;
        PgElementSet geom = new PgElementSet(3);
        int i = 0;
        while (i < 4) {
            geom.setVertex(i, N[i]);
            ++i;
        }
        PuHyperboloid.hyperboloidToKlein(geom.getVertices());
        int nov = 4;
        int newnov = n * n;
        int newnoe = (n - 1) * (n - 1);
        int ind = 0;
        PdVector[] vertex = N;
        geom.setNumVertices(newnov);
        geom.setNumElements(newnoe);
        PdVector[] N1N0 = PuHyperboloid.makeEdge(vertex[1], vertex[0], n);
        PdVector[] N2N3 = PuHyperboloid.makeEdge(vertex[2], vertex[3], n);
        PdVector[] N1N2 = PuHyperboloid.makeEdge(vertex[1], vertex[2], n);
        PdVector[] N0N3 = PuHyperboloid.makeEdge(vertex[0], vertex[3], n);
        PuHyperboloid.hyperboloidToKlein(N1N0);
        PuHyperboloid.hyperboloidToKlein(N2N3);
        PuHyperboloid.hyperboloidToKlein(N1N2);
        PuHyperboloid.hyperboloidToKlein(N0N3);
        int j2 = 1;
        while (j2 < n - 1) {
            geom.setVertex(nov + ind, N1N2[j2]);
            ++ind;
            ++j2;
        }
        int i2 = 1;
        while (i2 < n - 1) {
            PdVector dir = PdVector.subNew((PdVector)N1N0[i2], (PdVector)N2N3[i2]);
            dir.normalize();
            j = 0;
            while (j < n) {
                PdVector iPoint = new PdVector(3);
                PdVector dir1 = PdVector.subNew((PdVector)N0N3[j], (PdVector)N1N2[j]);
                dir1.normalize();
                PuVectorGeom.intersectionOfLineAndLine((PdVector)iPoint, (PdVector)N0N3[j], (PdVector)dir1, (PdVector)N1N0[i2], (PdVector)dir);
                geom.setVertex(nov + ind, iPoint);
                ++ind;
                ++j;
            }
            ++i2;
        }
        i2 = 1;
        while (i2 < n - 1) {
            geom.setVertex(nov + ind, N0N3[i2]);
            ++ind;
            ++i2;
        }
        PiVector index = new PiVector(n * n);
        index.setEntry(0, 1);
        index.setEntry(n - 1, 2);
        index.setEntry(n * (n - 1), 0);
        index.setEntry((n + 1) * (n - 1), 3);
        ind = 0;
        int i3 = 0;
        while (i3 < n * n) {
            if (i3 != 0 && i3 != n - 1 && i3 != n * (n - 1) && i3 != (n + 1) * (n - 1)) {
                index.setEntry(i3, nov + ind);
                ++ind;
            }
            ++i3;
        }
        ind = 0;
        i3 = 0;
        while (i3 < n - 1) {
            j = 0;
            while (j < n - 1) {
                int a = index.m_data[i3 * n + j];
                int b = index.m_data[i3 * n + j + 1];
                int c = index.m_data[(i3 + 1) * n + j + 1];
                int d = index.m_data[(i3 + 1) * n + j];
                geom.setElement(ind, a, b, c, d);
                ++ind;
                ++j;
            }
            ++i3;
        }
        geom.makeVertexNormals();
        PiVector[] neighbor = new PiVector[newnoe];
        PiVector.realloc((PiVector[])neighbor, (int)newnoe, (int)4);
        neighbor[0].set(new int[]{1, n - 1, -1, -1});
        neighbor[n - 2].set(new int[]{-1, 2 * n - 3, n - 3, -1});
        neighbor[(n - 1) * (n - 2)].set(new int[]{(n - 1) * (n - 2) + 1, -1, -1, (n - 1) * (n - 2) - (n - 1)});
        neighbor[n * (n - 2)].set(new int[]{-1, -1, n * (n - 2) - 1, n * (n - 2) - (n - 1)});
        int i4 = 1;
        while (i4 <= n - 3) {
            neighbor[i4 * (n - 1)].set(new int[]{i4 * (n - 1) + 1, (i4 + 1) * (n - 1), -1, (i4 - 1) * (n - 1)});
            int aux = (n - 1) * (n - 2) + i4;
            neighbor[aux].set(new int[]{aux + 1, -1, aux - 1, aux - (n - 1)});
            aux = i4 * (n - 1) + (n - 2);
            neighbor[aux].set(new int[]{-1, aux + (n - 1), aux - 1, aux - (n - 1)});
            neighbor[i4].set(new int[]{i4 + 1, i4 + (n - 1), i4 - 1, -1});
            ++i4;
        }
        i4 = 0;
        while (i4 < n - 3) {
            int aux = n + i4 * (n - 1);
            neighbor[aux].set(new int[]{aux + 1, aux + (n - 1), aux - 1, aux - (n - 1)});
            neighbor[aux].set(new int[]{++aux + 1, aux + (n - 1), aux - 1, aux - (n - 1)});
            neighbor[aux].set(new int[]{++aux + 1, aux + (n - 1), aux - 1, aux - (n - 1)});
            ++i4;
        }
        geom.setNeighbours(neighbor);
        PuHyperboloid.kleinToHyperboloid(geom.getVertices());
        return geom;
    }

    public static PgElementSet merge(PgElementSet[] geom) {
        PgElementSet m_elementSet = new PgElementSet(3);
        m_elementSet.copy((PsObject)geom[0]);
        int locnov = geom[0].getNumVertices();
        int locnoe = geom[0].getNumElements();
        int not = geom.length;
        m_elementSet.setNumVertices(not * locnov);
        m_elementSet.setNumElements(not * locnoe);
        int m = 0;
        while (m < not) {
            PgElementSet nt = geom[m];
            int j = 0;
            while (j < locnov) {
                m_elementSet.setVertex(m * locnov + j, nt.getVertex(j));
                m_elementSet.setVertexNormal(m * locnov + j, nt.getVertexNormal(j));
                ++j;
            }
            j = 0;
            while (j < locnoe) {
                PiVector f = (PiVector)nt.getElement(j).clone();
                f.add(m * locnov);
                m_elementSet.setElement(m * locnoe + j, f);
                m_elementSet.setElementColor(m * locnoe + j, nt.getElementColor(j));
                ++j;
            }
            ++m;
        }
        m_elementSet.showElementColors(true);
        m_elementSet.makeElementNormals();
        return m_elementSet;
    }

    public static void clip(PgElementSet geom, PdVector[] ct, int indTri, int numElt, Color col) {
        PdVector[] quadvertex = geom.getVertices();
        PiVector count = new PiVector(1);
        count.setEntry(0, 0);
        if (!PuCompGeometry.ccw(ct)) {
            PdVector tmp = (PdVector)ct[1].clone();
            ct[1].copy(ct[2]);
            ct[2].copy(tmp);
        }
        if (!PuCompGeometry.ccw(ct)) {
            System.out.println("not ccw");
        }
        int j = 0;
        while (j < numElt) {
            PiVector cquad = geom.getElement(j);
            PdVector[] cqpos = new PdVector[]{quadvertex[cquad.getEntry(0)], quadvertex[cquad.getEntry(1)], quadvertex[cquad.getEntry(2)], quadvertex[cquad.getEntry(3)]};
            if (PuCompGeometry.quadInsideTriangle(cqpos, ct)) {
                geom.setElementColor(j, col);
                cquad.setName(String.valueOf(indTri) + "," + j);
                cquad.setTag(0);
            } else if (PuCompGeometry.isPolygonIntersectPolygon(cqpos, ct)) {
                int currentnoe = geom.getNumElements();
                PiVector cutQuad = new PiVector(1);
                PuCompGeometry.computeInterQuadTriangleNew(cutQuad, cqpos, ct, cquad, geom);
                PdVector tpoint = new PdVector(3);
                PiVector i_point = new PiVector();
                if (cutQuad.getSize() >= 2 && cutQuad.getIndexOf(-1) == -1) {
                    if (PuCompGeometry.isPointInsideQuad(ct, cqpos, tpoint, i_point)) {
                        int currentnov = geom.getNumVertices();
                        int n = cutQuad.getSize();
                        geom.setNumVertices(currentnov + 1);
                        geom.setVertex(currentnov, tpoint);
                        PdVector p1 = ct[(i_point.m_data[0] + 2) % 3];
                        PdVector p2 = ct[i_point.m_data[0]];
                        int k = 0;
                        while (k < n) {
                            if (PuCompGeometry.liesOnSegment(geom.getVertex(cutQuad.m_data[k]), p1, p2)) {
                                PiVector c_tmp = (PiVector)cutQuad.clone();
                                cutQuad.setSize(n + 1);
                                cutQuad.setEntry(k + 1, currentnov);
                                int l1 = k + 2;
                                while (l1 < n + 1) {
                                    cutQuad.setEntry(l1, c_tmp.m_data[l1 - 1]);
                                    ++l1;
                                }
                                break;
                            }
                            ++k;
                        }
                    }
                    if (cutQuad.getSize() > 2) {
                        currentnoe = geom.getNumElements();
                        geom.setDimOfElements(-1);
                        geom.setNumElements(currentnoe + 1);
                        geom.setElement(currentnoe, cutQuad);
                        geom.getElement(currentnoe).setName(String.valueOf(indTri) + "," + j);
                        geom.setElementColor(currentnoe, col);
                    }
                }
            }
            ++j;
        }
    }

    public static void mapTileFromSourceToTarget(PgElementSet tile, PgElementSet sourceBar, PgElementSet targetBar) {
        int nov = tile.getNumVertices();
        PdVector bar = new PdVector(3);
        PuHyperboloid.hyperboloidToKlein(targetBar.getVertices());
        int i = 0;
        while (i < nov) {
            PdVector v = tile.getVertex(i);
            int indTri = PuMesh4gGon.getTriangle(v, sourceBar);
            bar = PuMesh4gGon.getBary(indTri, sourceBar, v);
            PiVector elt = targetBar.getElement(indTri);
            PdVector[] pos = new PdVector[3];
            int j = 0;
            while (j < 3) {
                pos[j] = targetBar.getVertex(elt.m_data[j]);
                ++j;
            }
            double[] gamma = new double[3];
            int j2 = 0;
            while (j2 < 3) {
                gamma[j2] = PgyroEinVector.getGamma(pos[j2]);
                ++j2;
            }
            double sum = 0.0;
            int j3 = 0;
            while (j3 < 3) {
                sum += bar.m_data[j3] * gamma[j3];
                ++j3;
            }
            v.blend(bar.m_data[0] * gamma[0], pos[0], bar.m_data[1] * gamma[1], pos[1], bar.m_data[2] * gamma[2], pos[2]);
            v.multScalar(1.0 / sum);
            ++i;
        }
    }

    public static int getTriangle(PdVector v, PgElementSet sourceBar) {
        int a = -1;
        int noe = sourceBar.getNumElements();
        PdVector[] vertex = sourceBar.getVertices();
        PdVector[] pos = new PdVector[3];
        int i = 0;
        while (i < noe) {
            PiVector elt = sourceBar.getElement(i);
            int j = 0;
            while (j < 3) {
                pos[j] = vertex[elt.m_data[j]];
                ++j;
            }
            if (PuCompGeometry.isInsidePolygon(v, pos, true)) {
                return i;
            }
            ++i;
        }
        PsDebug.message((String)"No vertex of the clipped tile was identified to be inside");
        return a;
    }

    public static PdVector getBary(int ind, PgElementSet geom, PdVector v) {
        PiVector elt = geom.getElement(ind);
        PdVector[] pos = new PdVector[3];
        PdVector Kv = (PdVector)v.clone();
        int i = 0;
        while (i < 3) {
            pos[i] = (PdVector)geom.getVertex(elt.m_data[i]).clone();
            ++i;
        }
        PuHyperboloid.hyperboloidToKlein(new PdVector[]{Kv});
        PuHyperboloid.hyperboloidToKlein(pos);
        double[] gamma = new double[3];
        int j = 0;
        while (j < 3) {
            gamma[j] = PgyroEinVector.getGamma(pos[j]);
            ++j;
        }
        PdMatrix M = new PdMatrix(3, 3);
        int i2 = 1;
        while (i2 < 3) {
            int j2 = 0;
            while (j2 < 3) {
                M.addEntry(i2, j2, gamma[j2] * (pos[j2].m_data[i2] - Kv.m_data[i2]));
                ++j2;
            }
            ++i2;
        }
        int j3 = 0;
        while (j3 < 3) {
            M.setEntry(0, j3, 1.0);
            ++j3;
        }
        M.invert();
        Kv = new PdVector(1.0, 0.0, 0.0);
        Kv.leftMultMatrix(M);
        return Kv;
    }
}

