/*
 * Decompiled with CFR 0.152.
 */
package devRegularMap.vecmath;

import jv.vecmath.PdMatrix;
import jv.vecmath.PiVector;

public class PuLorentz3D {
    private static int p;
    private static int q;
    private static double pi;
    private PiVector m_perm;
    private PdMatrix m_trans;
    private static int m_color;

    static {
        pi = Math.PI;
        m_color = 4;
    }

    public static void initLorentzUtility(int ps, int qs, int numCol) {
        p = ps;
        q = qs;
        m_color = numCol;
    }

    public PuLorentz3D() {
        this.m_perm = new PiVector(4);
        this.m_trans = new PdMatrix(3);
    }

    public PuLorentz3D(PdMatrix M, PiVector p) {
        this.m_trans = M;
        this.m_perm = p;
    }

    public void setColorPermutation(PiVector p) {
        this.m_perm = p;
    }

    public PiVector getColorPermutation() {
        return this.m_perm;
    }

    public PuLorentz3D inverse() {
        PdMatrix invA = (PdMatrix)this.getMatrix().clone();
        PiVector permInvA = this.getInversePermutation();
        invA.invert();
        PuLorentz3D inv = new PuLorentz3D(invA, permInvA);
        return inv;
    }

    public PiVector getInversePermutation() {
        PiVector invperm = new PiVector(this.getColorPermutation().getSize());
        PiVector perm = this.getColorPermutation();
        int i = 0;
        while (i < perm.getSize()) {
            invperm.setEntry(perm.getEntry(i), i);
            ++i;
        }
        return invperm;
    }

    public PdMatrix getMatrix() {
        return this.m_trans;
    }

    public static PdMatrix ReflectP() {
        PdMatrix M = new PdMatrix(3, 3);
        double coshb = Math.cos(pi / (double)q) / Math.sin(pi / (double)p);
        double cosh2b = 2.0 * coshb * coshb - 1.0;
        double sinh2b = Math.sqrt(cosh2b * cosh2b - 1.0);
        M.setEntry(0, 0, -cosh2b);
        M.setEntry(0, 1, 0.0);
        M.setEntry(0, 2, sinh2b);
        M.setEntry(1, 0, 0.0);
        M.setEntry(1, 1, 1.0);
        M.setEntry(1, 2, 0.0);
        M.setEntry(2, 0, -sinh2b);
        M.setEntry(2, 1, 0.0);
        M.setEntry(2, 2, cosh2b);
        return M;
    }

    private static PdMatrix ReflectQ() {
        PdMatrix M = new PdMatrix(3, 3);
        M.setEntry(0, 0, 1.0);
        M.setEntry(0, 1, 0.0);
        M.setEntry(0, 2, 0.0);
        M.setEntry(1, 0, 0.0);
        M.setEntry(1, 1, -1.0);
        M.setEntry(1, 2, 0.0);
        M.setEntry(2, 0, 0.0);
        M.setEntry(2, 1, 0.0);
        M.setEntry(2, 2, 1.0);
        return M;
    }

    public static PuLorentz3D Reflect2() {
        PuLorentz3D Mm = new PuLorentz3D();
        PdMatrix M = new PdMatrix(3, 3);
        M.setEntry(0, 0, Math.cos(2.0 * pi / (double)p));
        M.setEntry(0, 1, Math.sin(2.0 * pi / (double)p));
        M.setEntry(0, 2, 0.0);
        M.setEntry(1, 0, Math.sin(2.0 * pi / (double)p));
        M.setEntry(1, 1, -Math.cos(2.0 * pi / (double)p));
        M.setEntry(1, 2, 0.0);
        M.setEntry(2, 0, 0.0);
        M.setEntry(2, 1, 0.0);
        M.setEntry(2, 2, 1.0);
        Mm.setTransMatrix(M);
        if (m_color == 2) {
            Mm.setColorPermutation(new PiVector(0, 1));
        } else if (m_color == 3) {
            Mm.setColorPermutation(new PiVector(0, 1, 2));
        } else if (m_color == 4) {
            Mm.setColorPermutation(new PiVector(0, 1, 2, 3));
        } else if (m_color == 5) {
            PiVector perm = new PiVector(5);
            perm.setEntry(0, 0);
            perm.setEntry(1, 1);
            perm.setEntry(2, 2);
            perm.setEntry(3, 3);
            perm.setEntry(4, 4);
            Mm.setColorPermutation(perm);
        }
        return Mm;
    }

    public PuLorentz3D copy() {
        PuLorentz3D M = new PuLorentz3D();
        M.setColorPermutation((PiVector)this.getColorPermutation().clone());
        M.setTransMatrix((PdMatrix)this.getMatrix().clone());
        return M;
    }

    public void setTransMatrix(PdMatrix M) {
        this.m_trans = M;
    }

    public static PuLorentz3D RotateP() {
        PuLorentz3D Mn = new PuLorentz3D();
        PdMatrix M = PuLorentz3D.Reflect2().getMatrix();
        M.rightMult(PuLorentz3D.ReflectQ());
        Mn.setTransMatrix(M);
        if (m_color == 2) {
            Mn.setColorPermutation(new PiVector(0, 1));
        } else if (m_color == 3) {
            Mn.setColorPermutation(new PiVector(0, 2, 1));
        } else if (m_color == 4) {
            if (p == 3) {
                Mn.setColorPermutation(new PiVector(0, 3, 1, 2));
            } else if (p % 2 == 0) {
                Mn.setColorPermutation(new PiVector(0, 3, 1, 2));
            }
        } else if (m_color == 5) {
            PiVector perm = new PiVector(5);
            perm.setEntry(0, 0);
            perm.setEntry(1, 4);
            perm.setEntry(2, 3);
            perm.setEntry(3, 2);
            perm.setEntry(4, 1);
            Mn.setColorPermutation(perm);
        }
        return Mn;
    }

    public static PuLorentz3D RotateQ() {
        PuLorentz3D Mn = new PuLorentz3D();
        PdMatrix M = PuLorentz3D.ReflectP();
        M.rightMult(PuLorentz3D.Reflect2().getMatrix());
        Mn.setTransMatrix(M);
        if (m_color == 2) {
            Mn.setColorPermutation(new PiVector(1, 0));
        } else if (m_color == 3) {
            Mn.setColorPermutation(new PiVector(1, 2, 0));
        } else if (m_color == 4) {
            if (p == 3) {
                Mn.setColorPermutation(new PiVector(1, 2, 3, 0));
            } else if (p % 2 == 0) {
                Mn.setColorPermutation(new PiVector(1, 2, 3, 0));
            }
        } else if (m_color == 5) {
            PiVector perm = new PiVector(5);
            perm.setEntry(0, 1);
            perm.setEntry(1, 2);
            perm.setEntry(2, 3);
            perm.setEntry(3, 4);
            perm.setEntry(4, 0);
            Mn.setColorPermutation(perm);
        }
        return Mn;
    }

    public static PuLorentz3D Identity() {
        PuLorentz3D Mn = new PuLorentz3D();
        PdMatrix M = new PdMatrix(3, 3);
        int m = 0;
        while (m < 3) {
            int n = 0;
            while (n < 3) {
                if (m == n) {
                    M.setEntry(m, n, 1.0);
                } else {
                    M.setEntry(m, n, 0.0);
                }
                ++n;
            }
            ++m;
        }
        Mn.setTransMatrix(M);
        if (m_color == 2) {
            Mn.setColorPermutation(new PiVector(0, 1));
        } else if (m_color == 3) {
            Mn.setColorPermutation(new PiVector(0, 1, 2));
        } else if (m_color == 4) {
            Mn.setColorPermutation(new PiVector(0, 1, 2, 3));
        } else if (m_color == 5) {
            PiVector perm = new PiVector(5);
            perm.setEntry(0, 0);
            perm.setEntry(1, 1);
            perm.setEntry(2, 2);
            perm.setEntry(3, 3);
            perm.setEntry(4, 4);
            Mn.setColorPermutation(perm);
        }
        return Mn;
    }

    public void TransMult(PuLorentz3D M, PuLorentz3D N) {
        PdMatrix Mtrans = M.getMatrix();
        PdMatrix Ntrans = N.getMatrix();
        PdMatrix MN = new PdMatrix(3);
        MN.mult(Mtrans, Ntrans);
        this.setTransMatrix(MN);
        PiVector Mperm = M.getColorPermutation();
        PiVector Nperm = N.getColorPermutation();
        PiVector perm = new PiVector(Mperm.getSize());
        int i = 0;
        while (i < Mperm.getSize()) {
            perm.setEntry(i, Mperm.getEntry(Nperm.getEntry(i)));
            ++i;
        }
        this.setColorPermutation(perm);
    }

    public static PiVector permMult(PiVector p1, PiVector p2) {
        PiVector p1p2 = new PiVector(p1.getSize());
        int i = 0;
        while (i < p1p2.getSize()) {
            p1p2.setEntry(i, p1.getEntry(p2.getEntry(i)));
            ++i;
        }
        return p1p2;
    }

    public static PiVector invert(PiVector p1) {
        PiVector ip1 = new PiVector(p1.getSize());
        int i = 0;
        while (i < p1.getSize()) {
            ip1.setEntry(p1.getEntry(i), i);
            ++i;
        }
        return ip1;
    }
}

