/*
 * Decompiled with CFR 0.152.
 */
package devRegularMap.vecmath;

import devRegularMap.vecmath.PuHyperboloid;
import devRegularMap.vecmath.PuSpace;
import jv.object.PsDebug;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PuLorentz;

public class PuIsometry {
    protected static int m_geometry;
    protected static PdVector[] m_ftriangle;
    protected static int m_p;
    protected static int m_q;
    protected static final PdVector m_O;
    protected static final PdVector m_sign;
    protected static boolean SPHERICAL2D;
    protected static final PdVector m_P;

    static {
        m_O = new PdVector(1.0, 0.0, 0.0);
        m_sign = new PdVector(-1.0, 1.0, 1.0);
        m_P = new PdVector(Math.cosh(1.0), Math.sinh(1.0), 0.0);
    }

    public static void setGeomSpace(int geom) {
        m_geometry = geom;
    }

    public static void setTriangle(PdVector[] MNO) {
        m_ftriangle = MNO;
    }

    public static void isSpherical2D(boolean flag) {
        SPHERICAL2D = flag;
    }

    public static void setpq(int p, int q) {
        m_p = p;
        m_q = q;
    }

    public static PdMatrix[] getIsometries(int p, int q, PdVector[] triangle, int genus) {
        PdMatrix[] isom = new PdMatrix[3];
        PdMatrix r1 = new PdMatrix(3);
        PdMatrix r2 = new PdMatrix(3);
        PdMatrix r3 = new PdMatrix(3);
        PdVector M = triangle[2];
        PdVector N = triangle[0];
        PdVector O = triangle[1];
        PdVector xaxis = new PdVector(1.0, 0.0, 0.0);
        PdVector sign = new PdVector(-1.0, 1.0, 1.0);
        PdMatrix T = new PdMatrix(3);
        PdMatrix Tinv = new PdMatrix(3);
        PdMatrix R = new PdMatrix(3);
        PdMatrix Rinv = new PdMatrix(3);
        if (genus > 1) {
            r1.set((double[][])new double[][]{{1.0, 0.0, 0.0}, {0.0, -1.0, 0.0}, {0.0, 0.0, 1.0}});
            r3.set((double[][])new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, -1.0}});
            double d = PuLorentz.distToOrigin((PdVector)N, (PdVector)sign);
            double coshx = Math.cosh(d);
            double sinhx = Math.sinh(d);
            T.set((double[][])new double[][]{{coshx, sinhx, 0.0}, {sinhx, coshx, 0.0}, {0.0, 0.0, 1.0}});
            Tinv.set((double[][])new double[][]{{coshx, -sinhx, 0.0}, {-sinhx, coshx, 0.0}, {0.0, 0.0, 1.0}});
            Tinv = PdMatrix.copyNew((PdMatrix)T);
            Tinv.invert();
            PdVector tpq = new PdVector(3);
            PdVector tpr = new PdVector(3);
            PuLorentz.getTangent((PdVector)tpq, (PdVector)N, (PdVector)O, (PdVector)sign);
            PuLorentz.getTangent((PdVector)tpr, (PdVector)N, (PdVector)M, (PdVector)sign);
            double theta = 2.0 * Math.acos(PuLorentz.dot((PdVector)tpq, (PdVector)tpr, (PdVector)sign));
            R.set((double[][])new double[][]{{1.0, 0.0, 0.0}, {0.0, Math.cos(theta), Math.sin(theta)}, {0.0, -Math.sin(theta), Math.cos(theta)}});
            Rinv.set((double[][])new double[][]{{1.0, 0.0, 0.0}, {0.0, Math.cos(theta), -Math.sin(theta)}, {0.0, Math.sin(theta), Math.cos(theta)}});
            r2.mult(R, T);
            r2.leftMult(r3);
            r2.leftMult(Tinv);
        } else if (genus == 1) {
            r1.set((double[][])new double[][]{{-1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}});
            r3.set((double[][])new double[][]{{1.0, 0.0, 0.0}, {0.0, -1.0, 0.0}, {0.0, 0.0, 1.0}});
            T = new PdMatrix(3);
            Tinv = new PdMatrix(3);
            T.set((double[][])new double[][]{{1.0, 0.0, -triangle[0].m_data[0]}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}});
            Tinv.set((double[][])new double[][]{{1.0, 0.0, triangle[0].m_data[0]}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}});
            R = new PdMatrix(3);
            double theta = Math.PI * 2 / (double)q;
            R.set((double[][])new double[][]{{Math.cos(theta), Math.sin(theta), 0.0}, {-Math.sin(theta), Math.cos(theta), 0.0}, {0.0, 0.0, 1.0}});
            r2.mult(R, T);
            r2.leftMult(r3);
            r2.leftMult(Tinv);
        } else {
            T = new PdMatrix(3);
            Tinv = new PdMatrix(3);
            if (SPHERICAL2D) {
                if (p == 2) {
                    r2.set((double[][])new double[][]{{-1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}});
                    r1.set((double[][])new double[][]{{1.0, 0.0, 0.0}, {0.0, -1.0, 0.0}, {0.0, 0.0, 1.0}});
                    T.set((double[][])new double[][]{{1.0, 0.0, -triangle[1].m_data[0]}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}});
                    Tinv.set((double[][])new double[][]{{1.0, 0.0, triangle[1].m_data[0]}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}});
                    double alpha = 2.0 * (Math.PI - (Math.PI / (double)q + 1.5707963267948966));
                    R = new PdMatrix(3);
                    R.set((double[][])new double[][]{{Math.cos(alpha), Math.sin(alpha), 0.0}, {-Math.sin(alpha), Math.cos(alpha), 0.0}, {0.0, 0.0, 1.0}});
                    r3.mult(R, T);
                    r3.leftMult(r1);
                    r3.leftMult(Tinv);
                } else {
                    r1.set((double[][])new double[][]{{-1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}});
                    r3.set((double[][])new double[][]{{1.0, 0.0, 0.0}, {0.0, -1.0, 0.0}, {0.0, 0.0, 1.0}});
                    T.set((double[][])new double[][]{{1.0, 0.0, -triangle[0].m_data[0]}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}});
                    Tinv.set((double[][])new double[][]{{1.0, 0.0, triangle[0].m_data[0]}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}});
                    double alpha = 2.0 * (Math.PI - (Math.PI / (double)p + 1.5707963267948966));
                    R = new PdMatrix(3);
                    R.set((double[][])new double[][]{{Math.cos(alpha), Math.sin(alpha), 0.0}, {-Math.sin(alpha), Math.cos(alpha), 0.0}, {0.0, 0.0, 1.0}});
                    r2.mult(R, T);
                    r2.leftMult(r3);
                    r2.leftMult(Tinv);
                }
            } else {
                r1.set((double[][])new double[][]{{-1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}});
                r3.set((double[][])new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, -1.0}});
                double theta = Math.PI / 180 * PdVector.angle((PdVector)xaxis, (PdVector)triangle[0]);
                PdMatrix M0 = new PdMatrix(3);
                PdMatrix M0inv = new PdMatrix(3);
                M0.set((double[][])new double[][]{{Math.cos(theta), Math.sin(theta), 0.0}, {-Math.sin(theta), Math.cos(theta), 0.0}, {0.0, 0.0, 1.0}});
                M0inv.set((double[][])new double[][]{{Math.cos(theta), -Math.sin(theta), 0.0}, {Math.sin(theta), Math.cos(theta), 0.0}, {0.0, 0.0, 1.0}});
                PdMatrix M1 = new PdMatrix(3);
                double phi = Math.PI / (double)q;
                M1.set((double[][])new double[][]{{1.0, 0.0, 0.0}, {0.0, Math.cos(phi), Math.sin(phi)}, {0.0, -Math.sin(phi), Math.cos(phi)}});
                PdMatrix M1inv = new PdMatrix(3);
                M1inv.set((double[][])new double[][]{{1.0, 0.0, 0.0}, {0.0, Math.cos(phi), -Math.sin(phi)}, {0.0, Math.sin(phi), Math.cos(phi)}});
                r2.mult(M1, M0);
                r2.leftMult(r3);
                r2.leftMult(M1inv);
                r2.leftMult(M0inv);
            }
        }
        PdMatrix r = new PdMatrix(3);
        PdMatrix s = new PdMatrix(3);
        r.mult(r1, r2);
        s.mult(r2, r3);
        isom[0] = r;
        isom[1] = s;
        isom[2] = r2;
        return isom;
    }

    public static PdMatrix[] getIsometries() {
        PdMatrix[] isom = new PdMatrix[3];
        PdMatrix r1 = new PdMatrix(3);
        PdMatrix r2 = new PdMatrix(3);
        PdMatrix r3 = new PdMatrix(3);
        PdVector M = m_ftriangle[2];
        PdVector N = m_ftriangle[1];
        PdVector O = m_ftriangle[0];
        PdVector xaxis = new PdVector(1.0, 0.0, 0.0);
        switch (PuSpace.SPACE) {
            case -1: {
                r1.set((double[][])new double[][]{{1.0, 0.0, 0.0}, {0.0, -1.0, 0.0}, {0.0, 0.0, 1.0}});
                r3.set((double[][])new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, -1.0}});
                PdVector sign = new PdVector(-1.0, 1.0, 1.0);
                PdMatrix T = new PdMatrix(3);
                PdMatrix Tinv = new PdMatrix(3);
                double d = PuLorentz.distToOrigin((PdVector)N, (PdVector)sign);
                double coshx = Math.cosh(d);
                double sinhx = Math.sinh(d);
                T.set((double[][])new double[][]{{coshx, sinhx, 0.0}, {sinhx, coshx, 0.0}, {0.0, 0.0, 1.0}});
                Tinv.set((double[][])new double[][]{{coshx, -sinhx, 0.0}, {-sinhx, coshx, 0.0}, {0.0, 0.0, 1.0}});
                Tinv = PdMatrix.copyNew((PdMatrix)T);
                Tinv.invert();
                PdMatrix R = new PdMatrix(3);
                PdMatrix Rinv = new PdMatrix(3);
                PdVector tpq = new PdVector(3);
                PdVector tpr = new PdVector(3);
                PuLorentz.getTangent((PdVector)tpq, (PdVector)N, (PdVector)O, (PdVector)sign);
                PuLorentz.getTangent((PdVector)tpr, (PdVector)N, (PdVector)M, (PdVector)sign);
                double theta = 2.0 * Math.acos(PuLorentz.dot((PdVector)tpq, (PdVector)tpr, (PdVector)sign));
                R.set((double[][])new double[][]{{1.0, 0.0, 0.0}, {0.0, Math.cos(theta), Math.sin(theta)}, {0.0, -Math.sin(theta), Math.cos(theta)}});
                Rinv.set((double[][])new double[][]{{1.0, 0.0, 0.0}, {0.0, Math.cos(theta), -Math.sin(theta)}, {0.0, Math.sin(theta), Math.cos(theta)}});
                r2.mult(R, T);
                r2.leftMult(r3);
                r2.leftMult(Tinv);
                break;
            }
            case 0: {
                r1.set((double[][])new double[][]{{-1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}});
                r3.set((double[][])new double[][]{{1.0, 0.0, 0.0}, {0.0, -1.0, 0.0}, {0.0, 0.0, 1.0}});
                PdMatrix T = new PdMatrix(3);
                PdMatrix Tinv = new PdMatrix(3);
                T.set((double[][])new double[][]{{1.0, 0.0, -PuIsometry.m_ftriangle[1].m_data[0]}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}});
                Tinv.set((double[][])new double[][]{{1.0, 0.0, PuIsometry.m_ftriangle[1].m_data[0]}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}});
                PdMatrix R = new PdMatrix(3);
                double theta = Math.PI * 2 / (double)m_q;
                R.set((double[][])new double[][]{{Math.cos(theta), Math.sin(theta), 0.0}, {-Math.sin(theta), Math.cos(theta), 0.0}, {0.0, 0.0, 1.0}});
                r2.mult(R, T);
                r2.leftMult(r3);
                r2.leftMult(Tinv);
                break;
            }
            case 1: {
                PdMatrix T;
                if (SPHERICAL2D) {
                    r1.set((double[][])new double[][]{{-1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}});
                    r3.set((double[][])new double[][]{{1.0, 0.0, 0.0}, {0.0, -1.0, 0.0}, {0.0, 0.0, 1.0}});
                    T = new PdMatrix(3);
                    PdMatrix Tinv = new PdMatrix(3);
                    T.set((double[][])new double[][]{{1.0, 0.0, -PuIsometry.m_ftriangle[1].m_data[0]}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}});
                    Tinv.set((double[][])new double[][]{{1.0, 0.0, PuIsometry.m_ftriangle[1].m_data[0]}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}});
                    double alpha = 2.0 * (Math.PI - (Math.PI / (double)m_p + 1.5707963267948966));
                    if (m_p == 2) {
                        alpha = 1.8849555921538759;
                    }
                    PdMatrix R = new PdMatrix(3);
                    R.set((double[][])new double[][]{{Math.cos(alpha), Math.sin(alpha), 0.0}, {-Math.sin(alpha), Math.cos(alpha), 0.0}, {0.0, 0.0, 1.0}});
                    r2.mult(R, T);
                    r2.leftMult(r3);
                    r2.leftMult(Tinv);
                    break;
                }
                r1.set((double[][])new double[][]{{-1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}});
                r3.set((double[][])new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, -1.0}});
                double theta = Math.PI / 180 * PdVector.angle((PdVector)xaxis, (PdVector)m_ftriangle[1]);
                PdMatrix M0 = new PdMatrix(3);
                PdMatrix M0inv = new PdMatrix(3);
                M0.set((double[][])new double[][]{{Math.cos(theta), Math.sin(theta), 0.0}, {-Math.sin(theta), Math.cos(theta), 0.0}, {0.0, 0.0, 1.0}});
                M0inv.set((double[][])new double[][]{{Math.cos(theta), -Math.sin(theta), 0.0}, {Math.sin(theta), Math.cos(theta), 0.0}, {0.0, 0.0, 1.0}});
                PdMatrix M1 = new PdMatrix(3);
                double phi = Math.PI / (double)m_q;
                M1.set((double[][])new double[][]{{1.0, 0.0, 0.0}, {0.0, Math.cos(phi), Math.sin(phi)}, {0.0, -Math.sin(phi), Math.cos(phi)}});
                PdMatrix M1inv = new PdMatrix(3);
                M1inv.set((double[][])new double[][]{{1.0, 0.0, 0.0}, {0.0, Math.cos(phi), -Math.sin(phi)}, {0.0, Math.sin(phi), Math.cos(phi)}});
                r2.mult(M1, M0);
                r2.leftMult(r3);
                r2.leftMult(M1inv);
                r2.leftMult(M0inv);
            }
        }
        PdMatrix r = new PdMatrix(3);
        PdMatrix s = new PdMatrix(3);
        r.mult(r1, r2);
        s.mult(r2, r3);
        isom[0] = r;
        isom[1] = s;
        isom[2] = r2;
        return isom;
    }

    public static PdMatrix getTrans(String rep, PdMatrix[] isom, String gen) {
        PdMatrix trans = new PdMatrix();
        String capgen = gen.toUpperCase();
        trans.set((double[][])new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}});
        if (rep == "") {
            return trans;
        }
        PdMatrix g0 = isom[0];
        PdMatrix g1 = isom[1];
        PdMatrix G0 = PdMatrix.copyNew((PdMatrix)g0);
        G0.invert();
        PdMatrix G1 = PdMatrix.copyNew((PdMatrix)g1);
        G1.invert();
        PdMatrix t = isom[2];
        PdMatrix T = PdMatrix.copyNew((PdMatrix)t);
        T.invert();
        char[] repchar = rep.toCharArray();
        int j = 0;
        while (j < repchar.length) {
            if (repchar[repchar.length - 1 - j] == gen.charAt(0)) {
                trans.leftMult(g0);
            }
            if (repchar[repchar.length - 1 - j] == gen.charAt(1)) {
                trans.leftMult(g1);
            }
            if (repchar[repchar.length - 1 - j] == capgen.charAt(0)) {
                trans.leftMult(G0);
            }
            if (repchar[repchar.length - 1 - j] == capgen.charAt(1)) {
                trans.leftMult(G1);
            }
            if (repchar[repchar.length - 1 - j] == gen.charAt(2)) {
                trans.leftMult(t);
            }
            if (repchar[repchar.length - 1 - j] == capgen.charAt(2)) {
                trans.leftMult(T);
            }
            ++j;
        }
        return trans;
    }

    public static String getInverseStringElt(String c, String gen) {
        String invc = "";
        String capgen = gen.toUpperCase();
        char[] repchar = c.toCharArray();
        int k = 0;
        while (k < repchar.length) {
            if (repchar[k] == gen.charAt(1)) {
                invc = String.valueOf(capgen.charAt(1)) + invc;
            } else if (repchar[k] == gen.charAt(0)) {
                invc = String.valueOf(capgen.charAt(0)) + invc;
            } else if (repchar[k] == capgen.charAt(1)) {
                invc = String.valueOf(gen.charAt(1)) + invc;
            } else if (repchar[k] == capgen.charAt(0)) {
                invc = String.valueOf(gen.charAt(0)) + invc;
            } else if (repchar[k] == gen.charAt(2)) {
                invc = String.valueOf(gen.charAt(2)) + invc;
            }
            ++k;
        }
        return invc;
    }

    public static PdMatrix translate(double d) {
        PdMatrix T = new PdMatrix(3);
        double coshx = Math.cosh(d);
        double sinhx = Math.sinh(d);
        T.set((double[][])new double[][]{{coshx, sinhx, 0.0}, {sinhx, coshx, 0.0}, {0.0, 0.0, 1.0}});
        return T;
    }

    public static PdMatrix rotation(double theta) {
        PdMatrix r = new PdMatrix(3);
        r.set((double[][])new double[][]{{1.0, 0.0, 0.0}, {0.0, Math.cos(theta), -Math.sin(theta)}, {0.0, Math.sin(theta), Math.cos(theta)}});
        return r;
    }

    public static PdMatrix reflexion(PdVector x, PdVector y) {
        PdMatrix m = new PdMatrix(3);
        m = PuHyperboloid.mapToCoshCurve(x, y);
        PdMatrix minv = PdMatrix.copyNew((PdMatrix)m);
        minv.invert();
        PdMatrix r1 = new PdMatrix(3);
        r1.set((double[][])new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, -1.0}});
        m.leftMult(r1);
        m.leftMult(minv);
        return m;
    }

    public static PdMatrix mapXtoY(PdVector u, PdVector v, PdVector w, PdVector z) {
        double a = u.m_data[0];
        double b = u.m_data[1];
        double c = v.m_data[0];
        double d = v.m_data[1];
        double at = w.m_data[0];
        double bt = w.m_data[1];
        double ct = z.m_data[0];
        double dt = z.m_data[1];
        double e = (-d * at + b * ct) / (-d * a + b * c);
        double f = (-c * at + a * ct) / (-c * b + a * d);
        double h = (-c * bt + a * dt) / (-c * b + a * d);
        double g = (-d * bt + b * dt) / (-d * a + b * c);
        PdMatrix sr = new PdMatrix(3);
        sr.set((double[][])new double[][]{{e, f, 0.0}, {g, h, 0.0}, {0.0, 0.0, 1.0}});
        return sr;
    }

    public static void getFixedPoints(PdMatrix trans, PdVector[] pf, PdVector[] vertex) {
        int ind = 0;
        PdVector tmp = new PdVector(3);
        boolean fixPointFound = false;
        int i = 0;
        while (i < vertex.length) {
            tmp.leftMultMatrix(trans, vertex[i]);
            double d = PuHyperboloid.dist(tmp, vertex[i]);
            System.out.println(String.valueOf(i) + " " + d);
            if (d < 1.0E-10) {
                pf[ind] = (PdVector)tmp.clone();
                fixPointFound = true;
                if (ind < pf.length) {
                    ++ind;
                }
            }
            ++i;
        }
        if (!fixPointFound) {
            PsDebug.message((String)"No fix point is found for the transformation");
        }
    }
}

