/*
 * Decompiled with CFR 0.152.
 */
package devRegularMap.vecmath;

import devRegularMap.vecmath.PuIsometry;
import jv.number.PuComplex;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PuLorentz;
import jv.vecmath.PuMath;

public class PuHyperboloid {
    public static final PdVector m_O = new PdVector(1.0, 0.0, 0.0);
    protected static final PdVector m_sign = new PdVector(-1.0, 1.0, 1.0);
    public static final PdVector m_P = new PdVector(Math.cosh(1.0), Math.sinh(1.0), 0.0);

    public static void poincareToHyperboloid(PdVector[] vertex) {
        int i = 0;
        while (i < vertex.length) {
            double y = vertex[i].m_data[1];
            double z = vertex[i].m_data[2];
            vertex[i].set(1.0 + z * z + y * y, 2.0 * y, 2.0 * z);
            vertex[i].multScalar(1.0 / (1.0 - z * z - y * y));
            ++i;
        }
    }

    public static void poincareToHyperboloid(PdVector vertex) {
        double y = vertex.m_data[1];
        double z = vertex.m_data[2];
        vertex.set(1.0 + z * z + y * y, 2.0 * y, 2.0 * z);
        vertex.multScalar(1.0 / (1.0 - z * z - y * y));
    }

    public static void hyperboloidToPoincare(PdVector[] v) {
        int i = 0;
        while (i < v.length) {
            v[i].m_data[1] = v[i].m_data[1] / (1.0 + v[i].m_data[0]);
            v[i].m_data[2] = v[i].m_data[2] / (1.0 + v[i].m_data[0]);
            v[i].m_data[0] = 0.0;
            ++i;
        }
    }

    public static void hyperboloidToPoincare(PdVector v) {
        v.m_data[1] = v.m_data[1] / (1.0 + v.m_data[0]);
        v.m_data[2] = v.m_data[2] / (1.0 + v.m_data[0]);
        v.m_data[0] = 0.0;
    }

    public static void hyperboloidToKlein(PdVector[] v) {
        PuHyperboloid.hyperboloidToPoincare(v);
        int i = 0;
        while (i < v.length) {
            double sqrLength = 1.0 + v[i].m_data[1] * v[i].m_data[1] + v[i].m_data[2] * v[i].m_data[2];
            v[i].m_data[1] = 2.0 * v[i].m_data[1] / sqrLength;
            v[i].m_data[2] = 2.0 * v[i].m_data[2] / sqrLength;
            v[i].m_data[0] = 0.0;
            ++i;
        }
    }

    public static void kleinToHyperboloid(PdVector[] v) {
        int i = 0;
        while (i < v.length) {
            double sqrLength = 1.0 + Math.sqrt(1.0 - v[i].m_data[1] * v[i].m_data[1] - v[i].m_data[2] * v[i].m_data[2]);
            v[i].m_data[1] = v[i].m_data[1] / sqrLength;
            v[i].m_data[2] = v[i].m_data[2] / sqrLength;
            v[i].m_data[0] = 0.0;
            ++i;
        }
        PuHyperboloid.poincareToHyperboloid(v);
    }

    public static void kleinToHyperboloid(PdVector v) {
        double sqrLength = 1.0 + Math.sqrt(1.0 - v.m_data[1] * v.m_data[1] - v.m_data[2] * v.m_data[2]);
        v.m_data[1] = v.m_data[1] / sqrLength;
        v.m_data[2] = v.m_data[2] / sqrLength;
        v.m_data[0] = 0.0;
        PuHyperboloid.poincareToHyperboloid(v);
    }

    public static void hyperboloidToUpperHemisphere(PdVector v) {
        v.m_data[1] = v.m_data[1] / v.m_data[0];
        v.m_data[2] = v.m_data[2] / v.m_data[0];
        v.m_data[0] = 1.0 / v.m_data[0];
    }

    public static void hyperboloidToUpperHemisphere(PdVector[] v) {
        int i = 0;
        while (i < v.length) {
            v[i].m_data[1] = v[i].m_data[1] / v[i].m_data[0];
            v[i].m_data[2] = v[i].m_data[2] / v[i].m_data[0];
            v[i].m_data[0] = 1.0 / v[i].m_data[0];
            ++i;
        }
    }

    public static void upperHemisphereToHyperboloid(PdVector v) {
    }

    public static void upperHemisphereToHyperboloid(PdVector[] v) {
    }

    public static double dist(PdVector x, PdVector y) {
        double s = Math.abs(PuLorentz.dot((PdVector)x, (PdVector)y, (PdVector)m_sign));
        s = Math.abs(s - 1.0) < 1.0E-8 ? Math.acos(s) : PuMath.acosh((double)s);
        return s;
    }

    public static double orientedAngle(PdVector base, PdVector x, PdVector y) {
        if (PuHyperboloid.isTheSame(base, x) || PuHyperboloid.isTheSame(base, y)) {
            PsDebug.warning((String)"Base is the same as point in orientedAngle");
        }
        PdVector tx = new PdVector(3);
        PdVector ty = new PdVector(3);
        PuLorentz.getTangent((PdVector)tx, (PdVector)base, (PdVector)x, (PdVector)m_sign);
        PuLorentz.getTangent((PdVector)ty, (PdVector)base, (PdVector)y, (PdVector)m_sign);
        double t = PuLorentz.dot((PdVector)ty, (PdVector)tx, (PdVector)m_sign);
        double alpha = Math.acos(t);
        PdVector cross = PdVector.crossNew((PdVector)ty, (PdVector)tx);
        if (PdVector.dot((PdVector)m_O, (PdVector)cross) > 0.0) {
            alpha = -alpha;
        }
        return alpha;
    }

    public static PdMatrix mapToCoshCurve(PdVector x, PdVector y) {
        PdMatrix m = new PdMatrix(3);
        PdVector cy = PdVector.copyNew((PdVector)y);
        PuHyperboloid.translateToOrigin(m, x);
        cy.leftMultMatrix(m);
        double alpha = PuHyperboloid.orientedAngle(m_O, cy, m_P);
        PdMatrix r = PuIsometry.rotation(alpha);
        m.leftMult(r);
        return m;
    }

    public static void translateToOrigin(PdMatrix m, PdVector x) {
        if (Math.abs(x.m_data[0] - PuHyperboloid.m_O.m_data[0]) < 1.0E-10 && Math.abs(x.m_data[1] - PuHyperboloid.m_O.m_data[1]) < 1.0E-10 && Math.abs(x.m_data[2] - PuHyperboloid.m_O.m_data[2]) < 1.0E-10) {
            m.set((double[][])new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}});
        } else {
            double alpha = PuHyperboloid.orientedAngle(m_O, x, m_P);
            PdMatrix R = new PdMatrix(3);
            R.set((double[][])new double[][]{{1.0, 0.0, 0.0}, {0.0, Math.cos(alpha), -Math.sin(alpha)}, {0.0, Math.sin(alpha), Math.cos(alpha)}});
            PdVector Rx = new PdVector(3);
            Rx.leftMultMatrix(R, x);
            double d = PuLorentz.distToOrigin((PdVector)Rx, (PdVector)m_sign);
            double coshd = Math.cosh(-d);
            double sinhd = Math.sinh(-d);
            PdMatrix T = new PdMatrix(3);
            T.set((double[][])new double[][]{{coshd, sinhd, 0.0}, {sinhd, coshd, 0.0}, {0.0, 0.0, 1.0}});
            m.mult(T, R);
        }
    }

    public static boolean isTheSame(PdVector x, PdVector y) {
        boolean test3;
        double x0 = x.m_data[0] - y.m_data[0];
        double x1 = x.m_data[1] - y.m_data[1];
        double x2 = x.m_data[2] - y.m_data[2];
        boolean test1 = Math.abs(x0) < 1.0E-8;
        boolean test2 = Math.abs(x1) < 1.0E-8;
        boolean bl = test3 = Math.abs(x2) < 1.0E-8;
        return test1 && test2 && test3;
    }

    public static void rotateAroundPoint(PdMatrix m, PdVector x, double alpha) {
        PuHyperboloid.translateToOrigin(m, x);
        PdMatrix minv = PdMatrix.copyNew((PdMatrix)m);
        minv.invert();
        m.leftMult(PuIsometry.rotation(alpha));
        m.leftMult(minv);
    }

    public static PdVector[] makeEdge(PdVector x, PdVector y, int numDiscr) {
        PdVector[] e = new PdVector[numDiscr];
        PdMatrix T = new PdMatrix(3);
        PuHyperboloid.translateToOrigin(T, x);
        PdMatrix Tinv = PdMatrix.copyNew((PdMatrix)T);
        Tinv.invert();
        PdVector ty = new PdVector(3);
        ty.leftMultMatrix(T, y);
        PdVector dir = new PdVector(3);
        PuLorentz.getTangent((PdVector)dir, (PdVector)m_O, (PdVector)ty, (PdVector)m_sign);
        double hd = PuLorentz.distToOrigin((PdVector)ty, (PdVector)m_sign);
        int i = 0;
        while (i < numDiscr) {
            double t = (double)i * hd / (double)(numDiscr - 1);
            e[i] = PdVector.blendNew((double)Math.cosh(t), (PdVector)new PdVector(1.0, 0.0, 0.0), (double)Math.sinh(t), (PdVector)dir);
            e[i].leftMultMatrix(Tinv);
            ++i;
        }
        return e;
    }

    public static PdVector getMidPoint(PdVector x, PdVector y) {
        PdMatrix m = PuHyperboloid.mapToCoshCurve(x, y);
        m.invert();
        double d = PuHyperboloid.dist(x, y);
        PdVector mid = new PdVector(Math.cosh(d / 2.0), Math.sinh(d / 2.0), 0.0);
        mid.leftMultMatrix(m);
        return mid;
    }

    public static boolean isHyperboloid(PgGeometry hyper) {
        PdVector O = hyper.getVertex(0);
        return Math.abs(O.m_data[0]) > 1.0E-10;
    }

    public static double angleWithY(PdVector v) {
        return PuHyperboloid.orientedAngle(m_O, v, m_P);
    }

    public static PuComplex[] getMoebius(PdMatrix trans) {
        PdVector[] z = new PdVector[]{new PdVector(0.0, 0.0, 0.0), new PdVector(0.0, -0.5, 0.0), new PdVector(0.0, 0.5, 0.0)};
        PdVector[] w = new PdVector[3];
        int i = 0;
        while (i < 3) {
            w[i] = PuHyperboloid.transformBy(trans, z[i]);
            ++i;
        }
        PuComplex[] Z = new PuComplex[3];
        int i2 = 0;
        while (i2 < 3) {
            Z[i2] = new PuComplex(z[i2].m_data[1], z[i2].m_data[2]);
            ++i2;
        }
        PuComplex[] W = new PuComplex[3];
        int i3 = 0;
        while (i3 < 3) {
            W[i3] = new PuComplex(w[i3].m_data[1], w[i3].m_data[2]);
            ++i3;
        }
        PuComplex[][] M = new PuComplex[3][3];
        int i4 = 0;
        while (i4 < 3) {
            M[i4][0] = PuComplex.mult((PuComplex)Z[i4], (PuComplex)W[i4]);
            M[i4][1] = W[i4];
            M[i4][2] = PuComplex.ONE;
            ++i4;
        }
        PuComplex a = PuHyperboloid.det(M);
        int i5 = 0;
        while (i5 < 3) {
            M[i5][0] = PuComplex.mult((PuComplex)Z[i5], (PuComplex)W[i5]);
            M[i5][1] = Z[i5];
            M[i5][2] = W[i5];
            ++i5;
        }
        PuComplex b = PuHyperboloid.det(M);
        int i6 = 0;
        while (i6 < 3) {
            M[i6][0] = Z[i6];
            M[i6][1] = W[i6];
            M[i6][2] = PuComplex.ONE;
            ++i6;
        }
        PuComplex c = PuHyperboloid.det(M);
        int i7 = 0;
        while (i7 < 3) {
            M[i7][0] = PuComplex.mult((PuComplex)Z[i7], (PuComplex)W[i7]);
            M[i7][1] = Z[i7];
            M[i7][2] = PuComplex.ONE;
            ++i7;
        }
        PuComplex d = PuHyperboloid.det(M);
        return new PuComplex[]{a, b, c, d};
    }

    public static PdVector transformBy(PdMatrix trans, PdVector z) {
        PdVector transz = (PdVector)z.clone();
        PuHyperboloid.poincareToHyperboloid(transz);
        transz.leftMultMatrix(trans);
        PuHyperboloid.hyperboloidToPoincare(transz);
        return transz;
    }

    public static PuComplex det(PuComplex[][] H) {
        PuComplex a = new PuComplex(H[0][0]);
        a.mult(PuComplex.sub((PuComplex)PuComplex.mult((PuComplex)H[1][1], (PuComplex)H[2][2]), (PuComplex)PuComplex.mult((PuComplex)H[2][1], (PuComplex)H[1][2])));
        PuComplex b = new PuComplex(H[0][1]);
        b.mult(PuComplex.sub((PuComplex)PuComplex.mult((PuComplex)H[1][0], (PuComplex)H[2][2]), (PuComplex)PuComplex.mult((PuComplex)H[2][0], (PuComplex)H[1][2])));
        PuComplex c = new PuComplex(H[0][2]);
        c.mult(PuComplex.sub((PuComplex)PuComplex.mult((PuComplex)H[1][0], (PuComplex)H[2][1]), (PuComplex)PuComplex.mult((PuComplex)H[2][0], (PuComplex)H[1][1])));
        a.sub(b);
        a.add(c);
        return a;
    }

    public static PdVector[] getFixePoints(PdMatrix M) {
        PuComplex[] fixPoints = new PuComplex[2];
        PuComplex[] coeff = PuHyperboloid.getMoebius(M);
        PuComplex aMind = PuComplex.sub((PuComplex)coeff[0], (PuComplex)coeff[3]);
        PuComplex aMindsqr = PuComplex.sqr((PuComplex)aMind);
        PuComplex bc = PuComplex.mult((PuComplex)coeff[1], (PuComplex)coeff[2]);
        bc.mult(4.0);
        PuComplex res = PuComplex.add((PuComplex)aMindsqr, (PuComplex)bc);
        res.sqrt();
        PuComplex c2 = PuComplex.mult((PuComplex)coeff[2], (double)2.0);
        PuComplex res1 = PuComplex.add((PuComplex)aMind, (PuComplex)res);
        PuComplex res2 = PuComplex.sub((PuComplex)aMind, (PuComplex)res);
        res1.div(c2);
        res2.div(c2);
        if (res1.abs() < 1.0) {
            fixPoints[0] = res1;
            fixPoints[1] = res2;
        } else {
            fixPoints[0] = res2;
            fixPoints[1] = res1;
        }
        PdVector f1 = new PdVector(0.0, fixPoints[0].re, fixPoints[0].im);
        PdVector f2 = new PdVector(0.0, fixPoints[1].re, fixPoints[1].im);
        PuHyperboloid.poincareToHyperboloid(f1);
        PuHyperboloid.poincareToHyperboloid(f2);
        return new PdVector[]{f1, f2};
    }

    public static PdMatrix translateEdge(PdVector e0, PdVector e1, PdVector e2, PdVector e3) {
        PdMatrix T1 = PuHyperboloid.mapToCoshCurve(e2, e3);
        PdMatrix T2 = PuHyperboloid.mapToCoshCurve(e0, e1);
        T1.invert();
        T2.leftMult(T1);
        return T2;
    }

    public static PdVector[] transform(PdMatrix trans, PdVector[] p) {
        PdVector[] tp = new PdVector[p.length];
        int i = 0;
        while (i < p.length) {
            tp[i] = (PdVector)p[i].clone();
            trans.leftMultMatrix(tp[i], p[i]);
            ++i;
        }
        return tp;
    }
}

