/*
 * Decompiled with CFR 0.152.
 */
package devRegularMap.vecmath;

import devRegularMap.vecmath.PuLorentz3D;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import jv.geom.PgElementSet;
import jv.geom.PgPolygon;
import jv.number.PuComplex;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;

public class PuHyperbolic {
    protected static int m_p;
    protected static int m_q;
    protected int m_g;
    protected int m_i;
    protected int m_ordG;

    public PuHyperbolic(int p, int q, int g, int i, int ordG) {
        m_p = p;
        m_q = q;
        this.m_g = g;
        this.m_i = i;
        this.m_ordG = ordG;
    }

    public static void setParameter(int p, int q) {
        m_p = p;
        m_q = q;
    }

    public static PgElementSet refinedPolygon(PdVector z1, PdVector z2, PdVector z3, PdVector z4, int numInt) {
        PgElementSet newf = new PgElementSet(3);
        newf.setNumVertices(4 * (numInt - 1));
        newf.setNumElements((int)Math.floor(numInt * numInt / (numInt - 1)));
        PdVector[] firstSide = PuHyperbolic.makeEdge(z1, z3, numInt);
        PdVector[] thirdSide = PuHyperbolic.makeEdge(z2, z4, numInt);
        int ind = 0;
        int i = 0;
        while (i < numInt) {
            PdVector[] v = PuHyperbolic.makeEdge(firstSide[i], thirdSide[i], numInt);
            int j = 0;
            while (j < numInt) {
                newf.setVertex(ind, v[j]);
                ++ind;
                ++j;
            }
            ++i;
        }
        ind = 0;
        i = 0;
        while (i < numInt - 1) {
            int j = 0;
            while (j < numInt - 1) {
                newf.setElement(ind, i * numInt + j, i * numInt + j + 1, (i + 1) * numInt + j + 1, (i + 1) * numInt + j);
                ++ind;
                ++j;
            }
            ++i;
        }
        newf.makeElementNormals();
        return newf;
    }

    public static PdVector[] makeEdge(PdVector z1, PdVector z2, int numInt) {
        int numIntPoint = numInt;
        PdVector[] v = new PdVector[numIntPoint];
        PuComplex z2c = new PuComplex(z2.m_data[0], z2.m_data[1]);
        PuComplex z1c = new PuComplex(z1.m_data[0], z1.m_data[1]);
        PuComplex transz2c = PuComplex.moebius((PuComplex)PuComplex.ONE, (PuComplex)PuComplex.mult((PuComplex)z1c, (double)-1.0), (PuComplex)PuComplex.mult((PuComplex)PuComplex.conj((PuComplex)z1c), (double)-1.0), (PuComplex)PuComplex.ONE, (PuComplex)z2c);
        double dh = 0.5 * Math.log((1.0 + transz2c.abs()) / (1.0 - transz2c.abs()));
        int i = 0;
        while (i < numIntPoint) {
            double t = (double)i * dh / (double)(numIntPoint - 1);
            t = Math.sinh(t) / Math.cosh(t);
            PuComplex tmp = PuComplex.polarToRect((double)t, (double)transz2c.arg());
            PuComplex invtmp = PuComplex.moebius((PuComplex)PuComplex.ONE, (PuComplex)z1c, (PuComplex)PuComplex.conj((PuComplex)z1c), (PuComplex)PuComplex.ONE, (PuComplex)tmp);
            v[i] = new PdVector(invtmp.re(), invtmp.im(), 0.0);
            ++i;
        }
        return v;
    }

    public static PgPolygon drawUnitCircle() {
        PgPolygon unitCircle = new PgPolygon();
        unitCircle.setNumVertices(60);
        int i = 0;
        while (i < 60) {
            unitCircle.setVertex(i, Math.cos(Math.PI * 2 * (double)i / 59.0), Math.sin(Math.PI * 2 * (double)i / 59.0), 0.0);
            ++i;
        }
        unitCircle.setName("Unit Circle");
        unitCircle.showVertices(false);
        return unitCircle;
    }

    public static double computeAreaHyperbolic(PdVector v0, PdVector v1, PdVector v2) {
        PdVector m_vv1 = new PdVector(3);
        PdVector m_vv2 = new PdVector(3);
        m_vv1.set((v0.m_data[1] - v1.m_data[1]) * (v0.m_data[1] * v1.m_data[1] + v0.m_data[2] * v1.m_data[2] - 1.0) + (v0.m_data[2] - v1.m_data[2]) * (v0.m_data[1] * v1.m_data[2] - v0.m_data[2] * v1.m_data[1]), (v0.m_data[1] - v1.m_data[1]) * (v0.m_data[2] * v1.m_data[1] - v0.m_data[1] * v1.m_data[2]) + (v0.m_data[2] - v1.m_data[2]) * (v0.m_data[1] * v1.m_data[1] + v0.m_data[2] * v1.m_data[2] - 1.0));
        m_vv1.multScalar(1.0 / ((v0.m_data[1] * v1.m_data[1] + v0.m_data[2] * v1.m_data[2] - 1.0) * (v0.m_data[1] * v1.m_data[1] + v0.m_data[2] * v1.m_data[2] - 1.0) + (v0.m_data[1] * v1.m_data[2] - v0.m_data[2] * v1.m_data[1]) * (v0.m_data[1] * v1.m_data[2] - v0.m_data[2] * v1.m_data[1])));
        m_vv2.set((v0.m_data[1] - v2.m_data[1]) * (v0.m_data[1] * v2.m_data[1] + v0.m_data[2] * v2.m_data[2] - 1.0) + (v0.m_data[2] - v2.m_data[2]) * (v0.m_data[1] * v2.m_data[2] - v0.m_data[2] * v2.m_data[1]), (v0.m_data[1] - v2.m_data[1]) * (v0.m_data[2] * v2.m_data[1] - v0.m_data[1] * v2.m_data[2]) + (v0.m_data[2] - v2.m_data[2]) * (v0.m_data[1] * v2.m_data[1] + v0.m_data[2] * v2.m_data[2] - 1.0));
        m_vv2.multScalar(1.0 / ((v0.m_data[1] * v2.m_data[1] + v0.m_data[2] * v2.m_data[2] - 1.0) * (v0.m_data[1] * v2.m_data[1] + v0.m_data[2] * v2.m_data[2] - 1.0) + (v0.m_data[1] * v2.m_data[2] - v0.m_data[2] * v2.m_data[1]) * (v0.m_data[1] * v2.m_data[2] - v0.m_data[2] * v2.m_data[1])));
        double angle = PuHyperbolic.computeCircleAngle(m_vv1, m_vv2);
        if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        return angle;
    }

    private static double computeCircleAngle(PdVector start, PdVector end) {
        double endAngle;
        double startAngle;
        double d = start.m_data[0] * end.m_data[1] - start.m_data[1] * end.m_data[0];
        if (Math.abs(d) < 1.0E-10) {
            return 0.0;
        }
        double s = start.m_data[0] * start.m_data[0] + start.m_data[1] * start.m_data[1] + 1.0;
        double e = end.m_data[0] * end.m_data[0] + end.m_data[1] * end.m_data[1] + 1.0;
        double cx = (end.m_data[1] * s - start.m_data[1] * e) / (2.0 * d);
        double cy = (start.m_data[0] * e - end.m_data[0] * s) / (2.0 * d);
        double x = start.m_data[0] - cx;
        double y = start.m_data[1] - cy;
        if (Math.abs(x) > Math.abs(y)) {
            startAngle = Math.atan(y / x);
            if (x < 0.0) {
                startAngle += Math.PI;
            }
        } else {
            startAngle = 1.5707963267948966 - Math.atan(x / y);
            if (y < 0.0) {
                startAngle += Math.PI;
            }
        }
        x = end.m_data[0] - cx;
        y = end.m_data[1] - cy;
        if (Math.abs(x) > Math.abs(y)) {
            endAngle = Math.atan(y / x);
            if (x < 0.0) {
                endAngle += Math.PI;
            }
        } else {
            endAngle = 1.5707963267948966 - Math.atan(x / y);
            if (y < 0.0) {
                endAngle += Math.PI;
            }
        }
        if (endAngle - startAngle > Math.PI) {
            return startAngle - endAngle;
        }
        if (endAngle - startAngle > 0.0) {
            return endAngle - startAngle;
        }
        if (endAngle - startAngle > -Math.PI) {
            return startAngle - endAngle;
        }
        return endAngle - startAngle;
    }

    public static double hyperbolicDistance(PdVector z1, PdVector z2) {
        PuComplex z2c = new PuComplex(z2.m_data[1], z2.m_data[2]);
        PuComplex z1c = new PuComplex(z1.m_data[1], z1.m_data[2]);
        PuComplex transz2c = PuComplex.moebius((PuComplex)PuComplex.ONE, (PuComplex)PuComplex.mult((PuComplex)z1c, (double)-1.0), (PuComplex)PuComplex.mult((PuComplex)PuComplex.conj((PuComplex)z1c), (double)-1.0), (PuComplex)PuComplex.ONE, (PuComplex)z2c);
        double hd = 0.5 * Math.log((1.0 + transz2c.abs()) / (1.0 - transz2c.abs()));
        return hd;
    }

    public static void reflect(PgElementSet ft, int discr) {
        PdVector[] f_vertex = ft.getVertices();
        PdVector dir = PdVector.subNew((PdVector)f_vertex[0], (PdVector)f_vertex[2 * (discr - 1)]);
        dir.normalize();
        PdVector reflect1 = new PdVector(3);
        PdVector reflect2 = new PdVector(3);
        PdVector reflect3 = new PdVector(3);
        PuVectorGeom.rotatePointAroundLine((PdVector)reflect1, (PdVector)f_vertex[0], (PdVector)f_vertex[2 * (discr - 1)], (PdVector)dir, (double)Math.PI);
        PuVectorGeom.rotatePointAroundLine((PdVector)reflect2, (PdVector)f_vertex[discr - 1], (PdVector)f_vertex[2 * (discr - 1)], (PdVector)dir, (double)Math.PI);
        PuVectorGeom.rotatePointAroundLine((PdVector)reflect3, (PdVector)f_vertex[2 * (discr - 1)], (PdVector)f_vertex[2 * (discr - 1)], (PdVector)dir, (double)Math.PI);
        PdVector[] Edge1 = PuHyperbolic.makeEdge(reflect1, reflect2, discr);
        PdVector[] Edge2 = PuHyperbolic.makeEdge(reflect2, reflect3, discr);
        PdVector[] Edge3 = PuHyperbolic.makeEdge(reflect3, reflect1, discr);
        int ind = 0;
        int currNumVertex = ft.getNumVertices();
        PiVector elt = new PiVector(3 * (discr - 1));
        PdVector[][] pdVectorArrayArray = new PdVector[][]{Edge1, Edge2, Edge3};
        int n = pdVectorArrayArray.length;
        int n2 = 0;
        while (n2 < n) {
            PdVector[] e = pdVectorArrayArray[n2];
            int i = 0;
            while (i < e.length - 1) {
                ft.setVertex(ind + currNumVertex, e[i]);
                elt.setEntry(ind, ind + currNumVertex);
                ++ind;
                ++i;
            }
            ++n2;
        }
        ft.setElement(1, elt);
    }

    public static PiVector rotate(PiVector currelt, PgElementSet ft, double angle, int discr) {
        PdVector rot1 = new PdVector(3);
        PdVector rot2 = new PdVector(3);
        PdVector rot3 = new PdVector(3);
        PuVectorGeom.rotatePointAroundVector((PdVector)rot1, (PdVector)ft.getVertex(currelt.getEntry(0)), (PdVector)new PdVector(0.0, 0.0, 1.0), (double)angle);
        PuVectorGeom.rotatePointAroundVector((PdVector)rot2, (PdVector)ft.getVertex(currelt.getEntry(discr - 1)), (PdVector)new PdVector(0.0, 0.0, 1.0), (double)angle);
        PuVectorGeom.rotatePointAroundVector((PdVector)rot3, (PdVector)ft.getVertex(currelt.getEntry(2 * (discr - 1))), (PdVector)new PdVector(0.0, 0.0, 1.0), (double)angle);
        int currNumVertices = ft.getNumVertices();
        PdVector[] Edge1 = PuHyperbolic.makeEdge(rot1, rot2, discr);
        PdVector[] Edge2 = PuHyperbolic.makeEdge(rot2, rot3, discr);
        PdVector[] Edge3 = PuHyperbolic.makeEdge(rot3, rot1, discr);
        int ind = 0;
        PiVector elt = new PiVector(3 * (discr - 1));
        PdVector[][] pdVectorArrayArray = new PdVector[][]{Edge1, Edge2, Edge3};
        int n = pdVectorArrayArray.length;
        int n2 = 0;
        while (n2 < n) {
            PdVector[] e = pdVectorArrayArray[n2];
            int i = 0;
            while (i < e.length - 1) {
                ft.setVertex(ind + currNumVertices, e[i]);
                elt.setEntry(ind, ind + currNumVertices);
                ++ind;
                ++i;
            }
            ++n2;
        }
        return elt;
    }

    public static PdVector[] liftToHyperboloidNew(PdVector[] vertex) {
        PdVector[] l_vertex = new PdVector[vertex.length];
        int i = 0;
        while (i < vertex.length) {
            double x = vertex[i].m_data[0];
            double y = vertex[i].m_data[1];
            l_vertex[i] = new PdVector(2.0 * x, 2.0 * y, 1.0 + x * x + y * y);
            l_vertex[i].multScalar(1.0 / (1.0 - x * x - y * y));
            ++i;
        }
        return l_vertex;
    }

    public static void liftToHyperboloid(PdVector[] vertex) {
        int i = 0;
        while (i < vertex.length) {
            double y = vertex[i].m_data[1];
            double z = vertex[i].m_data[2];
            vertex[i].set(1.0 + z * z + y * y, 2.0 * y, 2.0 * z);
            vertex[i].multScalar(1.0 / (1.0 - z * z - y * y));
            ++i;
        }
    }

    public static void liftToHyperboloid(PdVector vertex) {
        double x = vertex.m_data[0];
        double y = vertex.m_data[1];
        vertex.setEntry(0, 2.0 * x);
        vertex.setEntry(1, 2.0 * y);
        vertex.setEntry(2, 1.0 + x * x + y * y);
        vertex.multScalar(1.0 / (1.0 - x * x - y * y));
    }

    public static void projectToPoincareDisk(PdVector[] v) {
        int i = 0;
        while (i < v.length) {
            v[i].m_data[1] = v[i].m_data[1] / (1.0 + v[i].m_data[0]);
            v[i].m_data[2] = v[i].m_data[2] / (1.0 + v[i].m_data[0]);
            v[i].m_data[0] = 0.0;
            ++i;
        }
    }

    public static void projectToPoincareDisk(PdVector v) {
        v.m_data[1] = v.m_data[1] / (1.0 + v.m_data[0]);
        v.m_data[2] = v.m_data[2] / (1.0 + v.m_data[0]);
        v.m_data[0] = 0.0;
    }

    public static void projectToKlein(PdVector[] v) {
        int i = 0;
        while (i < v.length) {
            v[i].multScalar(2.0 / (1.0 + v[i].sqrLength()));
            ++i;
        }
    }

    public static void projectToKlein(PdVector v) {
        v.multScalar(2.0 / (1.0 + v.sqrLength()));
    }

    public static void projectfromKleintoPoincare(PdVector[] v) {
        int i = 0;
        while (i < v.length) {
            v[i].multScalar(1.0 / (1.0 + Math.sqrt(1.0 - v[i].sqrLength())));
            ++i;
        }
    }

    public static void projectfromKleintoPoincare(PdVector v) {
        v.multScalar(1.0 / (1.0 + Math.sqrt(1.0 - v.sqrLength())));
    }

    public void suitableSpaceModelAndGenerator(File mapName) {
        try {
            int i;
            int i2;
            StringBuffer sb;
            String output = "R" + this.m_g + "." + this.m_i + "{" + m_p + "," + m_q + "}_gen.out";
            FileWriter fstream = new FileWriter("C:\\Users\\faniry\\Master-Works\\Thirdlibs\\" + output);
            BufferedWriter out = new BufferedWriter(fstream);
            String[] sm = new String[10];
            int n = 0;
            String B = " ";
            int qT = 0;
            int pT = 0;
            int indstr = 0;
            String[][] ABC = new String[10][10];
            if (m_p % (this.m_g + 1) == 0) {
                n = m_p / (this.m_g + 1);
                sb = new StringBuffer();
                i2 = 0;
                while (i2 < n) {
                    sb.append("r");
                    ++i2;
                }
                B = sb.toString();
                qT = this.m_g + 1;
                pT = 2;
                ABC[indstr] = this.searchGenerator(pT, qT, B, mapName);
                if (ABC[indstr][0] != null) {
                    sm[indstr] = "H_" + (this.m_g + 1);
                }
                ++indstr;
            } else if (m_q % (this.m_g + 1) == 0) {
                sm[indstr] = "H_" + (this.m_g + 1);
                n = m_q / (this.m_g + 1);
                sb = new StringBuffer();
                i2 = 0;
                while (i2 < n) {
                    sb.append("s");
                    ++i2;
                }
                B = sb.toString();
                qT = this.m_g + 1;
                pT = 2;
                ABC[indstr] = this.searchGenerator(pT, qT, B, mapName);
                if (ABC[indstr][0] != null) {
                    sm[indstr] = "H_" + (this.m_g + 1);
                }
                ++indstr;
            }
            if (m_p % 3 == 0 && this.m_g == 5) {
                n = m_p / 3;
                sb = new StringBuffer();
                i2 = 0;
                while (i2 < n) {
                    sb.append("r");
                    ++i2;
                }
                B = sb.toString();
                qT = 3;
                pT = 4;
                ABC[indstr] = this.searchGenerator(pT, qT, B, mapName);
                if (ABC[indstr][0] != null) {
                    sm[indstr] = "1 C";
                }
                ++indstr;
            } else if (m_q % 3 == 0 && this.m_g == 5) {
                sm[indstr] = "C";
                n = m_q / 3;
                sb = new StringBuffer();
                i2 = 0;
                while (i2 < n) {
                    sb.append("s");
                    ++i2;
                }
                B = sb.toString();
                qT = 3;
                pT = 4;
                ABC[indstr] = this.searchGenerator(pT, qT, B, mapName);
                if (ABC[indstr][0] != null) {
                    sm[indstr] = "1 C";
                }
                ++indstr;
            }
            if (m_p % 3 == 0 && this.m_g == 3) {
                n = m_p / 3;
                sb = new StringBuffer();
                i2 = 0;
                while (i2 < n) {
                    sb.append("r");
                    ++i2;
                }
                B = sb.toString();
                qT = 3;
                pT = 3;
                ABC[indstr] = this.searchGenerator(pT, qT, B, mapName);
                if (ABC[indstr][0] != null) {
                    sm[indstr] = "0 T";
                }
                ++indstr;
            } else if (m_q % 3 == 0 && this.m_g == 3) {
                n = m_q / 3;
                sb = new StringBuffer();
                i2 = 0;
                while (i2 < n) {
                    sb.append("s");
                    ++i2;
                }
                B = sb.toString();
                pT = 3;
                qT = 3;
                ABC[indstr] = this.searchGenerator(pT, qT, B, mapName);
                if (ABC[indstr][0] != null) {
                    sm[indstr] = "0 T";
                }
                ++indstr;
            }
            int inda = 1;
            int a = 0;
            int type = 1;
            while (inda <= this.m_g - 1) {
                if (inda * inda == this.m_g - 1) {
                    a = inda;
                    type = 1;
                }
                if (2 * inda * inda == this.m_g - 1) {
                    a = inda;
                    type = 2;
                }
                if (6 * inda * inda == this.m_g - 1) {
                    a = inda;
                    type = 3;
                }
                if (3 * inda * inda == this.m_g - 1) {
                    a = inda;
                    type = 4;
                }
                ++inda;
            }
            if (a != 0) {
                StringBuffer sb2;
                if (m_p % 4 == 0 && (type == 1 || type == 2)) {
                    n = m_p / 4;
                    sb2 = new StringBuffer();
                    i = 0;
                    while (i < n) {
                        sb2.append("r");
                        ++i;
                    }
                    B = sb2.toString();
                    pT = 4;
                    qT = 4;
                    ABC[indstr] = this.searchGenerator(pT, qT, B, mapName);
                    if (ABC[indstr][0] != null) {
                        if (type == 1) {
                            sm[indstr] = "{4,4}_" + a + "," + 0;
                        }
                        if (type == 2) {
                            sm[indstr] = "{4,4}_" + a + "," + a;
                        }
                    }
                    ++indstr;
                }
                if (m_q % 4 == 0 && (type == 1 || type == 2)) {
                    n = m_q / 4;
                    sb2 = new StringBuffer();
                    i = 0;
                    while (i < n) {
                        sb2.append("s");
                        ++i;
                    }
                    B = sb2.toString();
                    pT = 2;
                    qT = 4;
                    ABC[indstr] = this.searchGenerator(pT, qT, B, mapName);
                    if (ABC[indstr][0] != null) {
                        if (type == 1) {
                            sm[indstr] = "{4,4}_" + a + "," + 0;
                        }
                        if (type == 2) {
                            sm[indstr] = "{4,4}_" + a + "," + a;
                        }
                    }
                    ++indstr;
                }
                if (m_p % 3 == 0 && (type == 2 || type == 3)) {
                    n = m_p / 3;
                    sb2 = new StringBuffer();
                    i = 0;
                    while (i < n) {
                        sb2.append("r");
                        ++i;
                    }
                    B = sb2.toString();
                    pT = 3;
                    qT = 6;
                    ABC[indstr] = this.searchGenerator(pT, qT, B, mapName);
                    if (ABC[indstr][0] != null) {
                        if (type == 2) {
                            sm[indstr] = "{3,6}_" + a + "," + 0;
                        }
                        if (type == 3) {
                            sm[indstr] = "{3,6}_" + a + "," + a;
                        }
                    }
                    ++indstr;
                }
                if (m_q % 3 == 0 && (type == 2 || type == 3)) {
                    n = m_q / 3;
                    sb2 = new StringBuffer();
                    i = 0;
                    while (i < n) {
                        sb2.append("s");
                        ++i;
                    }
                    B = sb2.toString();
                    pT = 3;
                    qT = 6;
                    ABC[indstr] = this.searchGenerator(pT, qT, B, mapName);
                    if (ABC[indstr][0] != null) {
                        if (type == 2) {
                            sm[indstr] = "{3,6}_" + a + "," + 0;
                        }
                        if (type == 3) {
                            sm[indstr] = "{3,6}_" + a + "," + a;
                        }
                        ++indstr;
                    }
                }
                if (m_p % 6 == 0 && (type == 1 || type == 4)) {
                    n = m_p / 6;
                    sb2 = new StringBuffer();
                    i = 0;
                    while (i < n) {
                        sb2.append("r");
                        ++i;
                    }
                    B = sb2.toString();
                    pT = 6;
                    qT = 3;
                    ABC[indstr] = this.searchGenerator(pT, qT, B, mapName);
                    if (ABC[indstr][0] != null) {
                        if (type == 1) {
                            sm[indstr] = "{6,3}_" + a + "," + 0;
                        }
                        if (type == 4) {
                            sm[indstr] = "{6,3}_" + a + "," + a;
                        }
                    }
                    ++indstr;
                }
                if (m_q % 6 == 0 && (type == 1 || type == 4)) {
                    n = m_q / 6;
                    sb2 = new StringBuffer();
                    i = 0;
                    while (i < n) {
                        sb2.append("s");
                        ++i;
                    }
                    B = sb2.toString();
                    pT = 6;
                    qT = 3;
                    ABC[indstr] = this.searchGenerator(pT, qT, B, mapName);
                    if (ABC[indstr][0] != null) {
                        if (type == 1) {
                            sm[indstr] = "{6,3}_" + a + "," + 0;
                        }
                        if (type == 4) {
                            sm[indstr] = "{6,3}_" + a + "," + a;
                        }
                    }
                    ++indstr;
                }
            }
            out.write("List of generators found and possible space model for mapping.");
            out.newLine();
            out.write("Author: Faniry Harijaona Razafindrazaka");
            out.newLine();
            out.newLine();
            boolean notwritting = true;
            i = 0;
            while (i < 10) {
                if (ABC[i] != null && notwritting) {
                    out.write("R" + this.m_g + "." + this.m_i + "{" + m_p + "," + m_q + "}");
                    out.newLine();
                    notwritting = false;
                }
                if (ABC[i][0] != null) {
                    out.newLine();
                    out.write("A=" + ABC[i][0]);
                    int i1 = 0;
                    while (i1 < 10 - ABC[i][0].length()) {
                        out.write(" ");
                        ++i1;
                    }
                    out.write("B=" + ABC[i][1]);
                    i1 = 0;
                    while (i1 < 10 - ABC[i][1].length()) {
                        out.write(" ");
                        ++i1;
                    }
                    out.write("C=" + ABC[i][2]);
                    i1 = 0;
                    while (i1 < 10 - ABC[i][2].length()) {
                        out.write(" ");
                        ++i1;
                    }
                    out.newLine();
                    out.write("Space model: ");
                    out.newLine();
                    out.write(sm[i]);
                }
                ++i;
            }
            out.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    public String[] searchGenerator(int pT, int qT, String B, File mapName) {
        String[] ABC = new String[3];
        int maxElt = 1000;
        String[] A = new String[maxElt];
        String[] C = new String[maxElt];
        boolean found = false;
        try {
            String str;
            FileInputStream fstream = new FileInputStream("C:\\Users\\faniry\\Master-Works\\Thirdlibs\\" + mapName);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            int readline = 0;
            int indC = 0;
            int indA = 0;
            while ((str = br.readLine()) != null) {
                if (readline > 9 && readline < 8 + this.m_ordG) {
                    int i;
                    StringBuffer sb;
                    if (str.charAt(50) == '2' && str.charAt(49) == ' ') {
                        sb = new StringBuffer();
                        i = 54;
                        while (i < str.length()) {
                            sb.append(str.charAt(i));
                            ++i;
                        }
                        C[indC] = sb.toString();
                        ++indC;
                    }
                    if (str.charAt(50) == Integer.toString(pT).charAt(0) && str.charAt(49) == ' ') {
                        sb = new StringBuffer();
                        i = 54;
                        while (i < str.length()) {
                            sb.append(str.charAt(i));
                            ++i;
                        }
                        A[indA] = sb.toString();
                        ++indA;
                    }
                }
                ++readline;
            }
            in.close();
        }
        catch (Exception e) {
            System.err.println(e);
        }
        String[] invC = (String[])C.clone();
        int count = 0;
        int i = 0;
        while (i < C.length) {
            if (C[i] != null) {
                invC[i] = PuHyperbolic.inverseRepresentation(C[i]);
                ++count;
            }
            ++i;
        }
        i = 0;
        while (i < count) {
            C[i + count] = invC[i];
            ++i;
        }
        PuLorentz3D mB = PuLorentz3D.Identity();
        mB = PuHyperbolic.getTrans(B);
        PdVector N1 = new PdVector(0.0, 0.0, 0.0);
        if (B.charAt(0) == 's') {
            PdVector P;
            N1 = P = PuHyperbolic.getPofTriangle(m_p, m_q);
        }
        int i2 = 0;
        while (i2 < maxElt) {
            if (found) break;
            PuLorentz3D mA = PuLorentz3D.Identity();
            if (A[i2] == null) break;
            mA = PuHyperbolic.getTrans(A[i2]);
            PuLorentz3D mAB2 = new PuLorentz3D();
            mAB2.TransMult(mA, mB);
            mAB2.TransMult(mAB2, mAB2);
            if (PuHyperbolic.isIdentity(mAB2)) {
                int j = 0;
                while (j < maxElt) {
                    PuLorentz3D mC = PuLorentz3D.Identity();
                    if (C[j] == null) break;
                    mC = PuHyperbolic.getTrans(C[j]);
                    PuLorentz3D mBC2 = new PuLorentz3D();
                    mBC2.TransMult(mB, mC);
                    mBC2.TransMult(mBC2, mBC2);
                    if (PuHyperbolic.isIdentity(mBC2)) {
                        PuLorentz3D mABC2 = PuLorentz3D.Identity();
                        mABC2.TransMult(mA, mB);
                        mABC2.TransMult(mABC2, mC);
                        mABC2.TransMult(mABC2, mABC2);
                        if (PuHyperbolic.isIdentity(mABC2)) {
                            PdVector[] basecorner = PuHyperbolic.getOtherPointQuarterTube(N1, new String[]{A[i2], B, C[j]});
                            PdVector[] ct1 = new PdVector[]{basecorner[0], basecorner[1], basecorner[2]};
                            PdVector[] ct2 = new PdVector[]{basecorner[0], basecorner[2], basecorner[3]};
                            if (!PuHyperbolic.ccw(ct1)) {
                                PdVector tmp = basecorner[1];
                                basecorner[1] = basecorner[3];
                                basecorner[3] = tmp;
                            } else if (!PuHyperbolic.ccw(ct2)) {
                                PdVector tmp = basecorner[2];
                                basecorner[2] = basecorner[3];
                                basecorner[3] = tmp;
                            }
                            double alpha = PuHyperbolic.hangle(basecorner[3], basecorner[0], basecorner[1]);
                            double beta = PuHyperbolic.hangle(basecorner[2], basecorner[3], basecorner[0]);
                            double angR = (double)qT * (alpha + beta);
                            if (Math.abs(angR - Math.PI * 2) < 1.0E-8 && Math.abs(alpha) > 1.0E-8 && Math.abs(beta) > 1.0E-8) {
                                ABC[0] = A[i2];
                                ABC[1] = B;
                                ABC[2] = C[j];
                                found = true;
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i2;
        }
        if (!found) {
            System.err.println("Generator and Space model not found for " + mapName);
        } else {
            System.out.println("Generator and Space model     found for " + mapName);
        }
        return ABC;
    }

    public static String inverseRepresentation(String rep) {
        StringBuffer sb = new StringBuffer();
        int slength = rep.length();
        int i = 0;
        while (i < slength) {
            if (rep.charAt(slength - i - 1) == 'r') {
                sb.append("R");
            }
            if (rep.charAt(slength - i - 1) == 's') {
                sb.append("S");
            }
            if (rep.charAt(slength - i - 1) == 'R') {
                sb.append("r");
            }
            if (rep.charAt(slength - i - 1) == 'S') {
                sb.append("s");
            }
            if (rep.charAt(slength - i - 1) == 't') {
                sb.append("t");
            }
            ++i;
        }
        return sb.toString();
    }

    public static double hangle(PdVector A, PdVector B, PdVector C) {
        double angle = 1.0;
        PdVector cA = (PdVector)A.clone();
        PdVector cB = (PdVector)B.clone();
        PdVector cC = (PdVector)C.clone();
        PdVector O = new PdVector(0.0, 0.0, 0.0);
        PuHyperbolic.mapZtoZ1(cA, cB);
        PuHyperbolic.mapZtoZ1(cC, cB);
        PdVector e1 = PdVector.subNew((PdVector)cA, (PdVector)O);
        PdVector e2 = PdVector.subNew((PdVector)cC, (PdVector)O);
        angle = Math.PI / 180 * PdVector.angle((PdVector)e1, (PdVector)e2);
        return angle;
    }

    public static void mapZtoZ1(PdVector z, PdVector z1) {
        PuComplex zc = new PuComplex(z.m_data[0], z.m_data[1]);
        PuComplex z1c = new PuComplex(z1.m_data[0], z1.m_data[1]);
        PuComplex transz2c = PuComplex.moebius((PuComplex)PuComplex.ONE, (PuComplex)PuComplex.mult((PuComplex)z1c, (double)-1.0), (PuComplex)PuComplex.mult((PuComplex)PuComplex.conj((PuComplex)z1c), (double)-1.0), (PuComplex)PuComplex.ONE, (PuComplex)zc);
        z.setEntry(0, transz2c.re);
        z.setEntry(1, transz2c.im);
    }

    public static void mapToPointTriangle(PdVector z, PdVector z1) {
        PuComplex zc = new PuComplex(z.m_data[0], z.m_data[1]);
        PuComplex z1c = new PuComplex(z1.m_data[0], z1.m_data[1]);
        PuComplex transz2c = PuComplex.moebius((PuComplex)PuComplex.ONE, (PuComplex)PuComplex.mult((PuComplex)z1c, (double)1.0), (PuComplex)PuComplex.mult((PuComplex)PuComplex.conj((PuComplex)z1c), (double)1.0), (PuComplex)PuComplex.ONE, (PuComplex)zc);
        z.setEntry(0, transz2c.re);
        z.setEntry(1, transz2c.im);
    }

    public static PdVector getPofTriangle(int p, int q) {
        double a = Math.tan(Math.PI / (double)p);
        double b = Math.sin(Math.PI * (0.5 - 1.0 / (double)p - 1.0 / (double)q));
        double xthirdPoint = b / Math.sqrt(b * b * (1.0 - a * a) + 2.0 * a * b * Math.sqrt(1.0 - b * b));
        double ythirdPoint = a * xthirdPoint;
        PdVector thirdPoint = new PdVector(xthirdPoint, ythirdPoint, 0.0);
        return thirdPoint;
    }

    public static boolean isIdentity(PuLorentz3D T) {
        PdMatrix M = T.getMatrix();
        int test = 0;
        int i = 0;
        while (i < M.getNumRows()) {
            int j = 0;
            while (j < M.getNumCols()) {
                if (i == j) {
                    if (Math.abs(M.getEntry(i, i) - 1.0) < 1.0E-8) {
                        ++test;
                    }
                } else if (Math.abs(M.getEntry(i, j)) < 1.0E-8) {
                    ++test;
                }
                ++j;
            }
            ++i;
        }
        return test == M.getSize() * M.getISize();
    }

    public static boolean isIdentity(PdMatrix M) {
        int test = 0;
        int i = 0;
        while (i < M.getNumRows()) {
            int j = 0;
            while (j < M.getNumCols()) {
                if (i == j) {
                    if (Math.abs(M.getEntry(i, i) - 1.0) < 1.0E-8) {
                        ++test;
                    }
                } else if (Math.abs(M.getEntry(i, j)) < 1.0E-8) {
                    ++test;
                }
                ++j;
            }
            ++i;
        }
        return test == M.getSize() * M.getISize();
    }

    public static PuLorentz3D getTrans(String rep) {
        PuLorentz3D trans = PuLorentz3D.Identity();
        if (rep == "") {
            return trans;
        }
        PuLorentz3D r = PuLorentz3D.RotateP();
        PuLorentz3D s = PuLorentz3D.RotateQ();
        PuLorentz3D R = r.inverse();
        PuLorentz3D S = s.inverse();
        PuLorentz3D t = PuLorentz3D.Reflect2();
        char[] repchar = rep.toCharArray();
        int j = 0;
        while (j < repchar.length) {
            if (repchar[repchar.length - 1 - j] == "r".charAt(0)) {
                trans.TransMult(r, trans);
            }
            if (repchar[repchar.length - 1 - j] == "s".charAt(0)) {
                trans.TransMult(s, trans);
            }
            if (repchar[repchar.length - 1 - j] == "S".charAt(0)) {
                trans.TransMult(S, trans);
            }
            if (repchar[repchar.length - 1 - j] == "R".charAt(0)) {
                trans.TransMult(R, trans);
            }
            if (repchar[repchar.length - 1 - j] == "t".charAt(0)) {
                trans.TransMult(t, trans);
            }
            ++j;
        }
        return trans;
    }

    public static PdVector[] getOtherPointQuarterTube(PdVector N1, String[] ABC) {
        PdVector CN1 = PuHyperbolic.transform(N1, ABC[2], 0);
        PdVector AN1 = PuHyperbolic.transform(N1, ABC[0], 0);
        PdVector CAN1 = PuHyperbolic.transform(AN1, ABC[2], 0);
        PdVector mid1 = PuHyperbolic.getHyperMidPoint(N1, AN1);
        PdVector mid2 = PuHyperbolic.getHyperMidPoint(CN1, CAN1);
        PdVector[] ct = new PdVector[]{N1, mid1, mid2};
        if (!PuHyperbolic.ccw(ct)) {
            CN1 = PuHyperbolic.transform(N1, ABC[2], 1);
            CAN1 = PuHyperbolic.transform(AN1, ABC[2], 1);
            mid1 = PuHyperbolic.getHyperMidPoint(N1, AN1);
            mid2 = PuHyperbolic.getHyperMidPoint(CN1, CAN1);
            ct = new PdVector[]{N1, mid1, mid2};
        }
        return new PdVector[]{N1, mid1, mid2, CN1};
    }

    public static boolean ccw(PdVector[] triangle) {
        double test = (triangle[1].m_data[0] - triangle[0].m_data[0]) * (triangle[2].m_data[1] - triangle[0].m_data[1]) - (triangle[2].m_data[0] - triangle[0].m_data[0]) * (triangle[1].m_data[1] - triangle[0].m_data[1]);
        return test > 0.0;
    }

    public static PgElementSet getFundTriangle(int p, int q, int discrEdge) {
        PgElementSet triangle = new PgElementSet(3);
        PdVector firstPoint = new PdVector(0.0, 0.0, 0.0);
        double s = Math.sin(Math.PI / (double)p);
        double c = Math.cos(Math.PI / (double)q);
        double tan2 = s * s / (c * c);
        double cotan2 = c * c / (s * s);
        double d = 1.0 / Math.sqrt(1.0 - tan2);
        double r = 1.0 / Math.sqrt(cotan2 - 1.0);
        PdVector secondPoint = new PdVector(3);
        secondPoint.m_data[0] = d - r;
        double a = Math.tan(Math.PI / (double)p);
        double b = Math.sin(Math.PI * (0.5 - 1.0 / (double)p - 1.0 / (double)q));
        double xthirdPoint = b / Math.sqrt(b * b * (1.0 - a * a) + 2.0 * a * b * Math.sqrt(1.0 - b * b));
        double ythirdPoint = a * xthirdPoint;
        PdVector thirdPoint = new PdVector(xthirdPoint, ythirdPoint, 0.0);
        triangle.setNumVertices(p * (discrEdge - 1));
        triangle.setNumElements(1);
        PdVector[] Edge1 = PuHyperbolic.makeEdge(firstPoint, secondPoint, discrEdge);
        PdVector[] Edge2 = PuHyperbolic.makeEdge(secondPoint, thirdPoint, discrEdge);
        PdVector[] Edge3 = PuHyperbolic.makeEdge(thirdPoint, firstPoint, discrEdge);
        int ind = 0;
        PiVector elt = new PiVector(3 * (discrEdge - 1));
        PdVector[][] pdVectorArrayArray = new PdVector[][]{Edge1, Edge2, Edge3};
        int n = pdVectorArrayArray.length;
        int n2 = 0;
        while (n2 < n) {
            PdVector[] e = pdVectorArrayArray[n2];
            int i = 0;
            while (i < e.length - 1) {
                triangle.setVertex(ind, e[i]);
                elt.setEntry(ind, ind);
                ++ind;
                ++i;
            }
            ++n2;
        }
        triangle.setElement(0, elt);
        return triangle;
    }

    public static PdVector getHyperMidPoint(PdVector z1, PdVector z2) {
        PdVector mid = new PdVector(3);
        int numIntPoint = 3;
        PuComplex z2c = new PuComplex(z2.m_data[0], z2.m_data[1]);
        PuComplex z1c = new PuComplex(z1.m_data[0], z1.m_data[1]);
        PuComplex transz2c = PuComplex.moebius((PuComplex)PuComplex.ONE, (PuComplex)PuComplex.mult((PuComplex)z1c, (double)-1.0), (PuComplex)PuComplex.mult((PuComplex)PuComplex.conj((PuComplex)z1c), (double)-1.0), (PuComplex)PuComplex.ONE, (PuComplex)z2c);
        double dh = 0.5 * Math.log((1.0 + transz2c.abs()) / (1.0 - transz2c.abs()));
        double t = dh / (double)(numIntPoint - 1);
        t = Math.sinh(t) / Math.cosh(t);
        PuComplex tmp = PuComplex.polarToRect((double)t, (double)transz2c.arg());
        PuComplex invtmp = PuComplex.moebius((PuComplex)PuComplex.ONE, (PuComplex)z1c, (PuComplex)PuComplex.conj((PuComplex)z1c), (PuComplex)PuComplex.ONE, (PuComplex)tmp);
        mid = new PdVector(invtmp.re(), invtmp.im(), 0.0);
        return mid;
    }

    public static PdVector transform(PdVector v, String rep, int i) {
        PdVector transv = (PdVector)v.clone();
        PdVector tmp1 = new PdVector(3);
        PdMatrix trans = PuHyperbolic.getTrans(rep).getMatrix();
        if (i == 1) {
            trans.invert();
        }
        PuHyperbolic.liftToHyperboloid(transv);
        trans.leftMultMatrix(tmp1, transv);
        transv.m_data = tmp1.m_data;
        PuHyperbolic.projectToPoincareDisk(transv);
        return transv;
    }

    private static boolean isInsideTriangle(PdVector v, PdVector[] triangle) {
        int pointinside = 0;
        int j = 0;
        while (j < 3) {
            double test = (triangle[(j + 1) % 3].m_data[0] - triangle[j].m_data[0]) * (v.m_data[1] - triangle[j].m_data[1]) - (v.m_data[0] - triangle[j].m_data[0]) * (triangle[(j + 1) % 3].m_data[1] - triangle[j].m_data[1]);
            if (test > 1.0E-8) {
                ++pointinside;
            }
            ++j;
        }
        return pointinside == 3;
    }

    public static boolean isOutsideTile(PiVector quad, PiVector currenttile, PgElementSet foldout, PgElementSet tesselation, int m_discr) {
        PdVector[] cornerquad = new PdVector[]{foldout.getVertex(quad.getEntry(0)), foldout.getVertex(quad.getEntry(1)), foldout.getVertex(quad.getEntry(2)), foldout.getVertex(quad.getEntry(3))};
        PdVector[] cornertile = new PdVector[]{tesselation.getVertex(currenttile.getEntry(0)), tesselation.getVertex(currenttile.getEntry(m_discr - 1)), tesselation.getVertex(currenttile.getEntry(2 * (m_discr - 1)))};
        return PuHyperbolic.isOutsideTile(cornerquad, cornertile);
    }

    public static boolean isOutsideTile(PdVector[] cornerquad, PdVector[] cornertile) {
        int quadinside = 0;
        int i = 0;
        while (i < 4) {
            if (PuHyperbolic.isInsideTriangle(cornerquad[i], cornertile)) {
                ++quadinside;
            }
            ++i;
        }
        return quadinside == 0;
    }

    public static boolean isInsideTile(PdVector[] cornerquad, PdVector[] cornertile) {
        int quadinside = 0;
        int i = 0;
        while (i < 4) {
            if (PuHyperbolic.isInsideTriangle(cornerquad[i], cornertile)) {
                ++quadinside;
            }
            ++i;
        }
        return quadinside == 4;
    }

    public static void makeInitQtube(PdVector[] quarterTube, PgElementSet pe, int discr) {
        pe.setNumElements(4 * (discr - 1));
        PdVector N1 = quarterTube[0];
        PdVector AN1 = quarterTube[1];
        PdVector CinvAN1 = quarterTube[2];
        PdVector CinvN1 = quarterTube[3];
        PdVector[] Edge1 = PuHyperbolic.makeEdge(N1, AN1, discr);
        PdVector[] Edge2 = PuHyperbolic.makeEdge(AN1, CinvAN1, discr);
        PdVector[] Edge3 = PuHyperbolic.makeEdge(CinvAN1, CinvN1, discr);
        PdVector[] Edge4 = PuHyperbolic.makeEdge(CinvN1, N1, discr);
        int ind = 0;
        PiVector face1 = new PiVector(4 * (discr - 1));
        PdVector[][] pdVectorArrayArray = new PdVector[][]{Edge1, Edge2, Edge3, Edge4};
        int n = pdVectorArrayArray.length;
        int n2 = 0;
        while (n2 < n) {
            PdVector[] s = pdVectorArrayArray[n2];
            int j = 0;
            while (j < discr - 1) {
                pe.setVertex(ind, s[j]);
                face1.setEntry(ind, ind);
                ++ind;
                ++j;
            }
            ++n2;
        }
        pe.setElement(0, face1);
    }

    public static boolean isTranslation(String s) {
        PdVector P = new PdVector(0.0, 0.0, 0.0);
        PdVector Q = PuHyperbolic.getPofTriangle(m_p, m_q);
        PdVector transP = PuHyperbolic.transform(P, s, 0);
        PdVector transQ = PuHyperbolic.transform(Q, s, 0);
        PuHyperbolic.mapZtoZ1(transQ, transP);
        return Math.abs(Q.m_data[0] - transQ.m_data[0]) < 1.0E-8 && Math.abs(Q.m_data[1] - transQ.m_data[1]) < 1.0E-8;
    }

    public static boolean isOrder(String rep, int p) {
        PuLorentz3D trans = PuHyperbolic.getTrans(rep);
        int i = 0;
        while (i < p) {
            trans.TransMult(trans, trans);
            ++i;
        }
        return PuHyperbolic.isIdentity(trans);
    }

    public static void makeBandModel(PgElementSet poinc) {
        PdVector[] vertex = poinc.getVertices();
        int i = 0;
        while (i < vertex.length) {
            vertex[i] = PuHyperbolic.bandMap(vertex[i]);
            ++i;
        }
    }

    public static PdVector bandMap(PdVector x) {
        PuComplex z = new PuComplex(x.m_data[0], x.m_data[1]);
        PuComplex log1 = PuComplex.logPB((PuComplex)PuComplex.add((PuComplex)z, (double)1.0));
        PuComplex log2 = PuComplex.logPB((PuComplex)PuComplex.add((PuComplex)PuComplex.mult((PuComplex)z, (double)-1.0), (double)1.0));
        PuComplex agtanhz = PuComplex.sub((PuComplex)log1, (PuComplex)log2);
        agtanhz.mult(0.3183098861837907);
        if (Math.abs(agtanhz.im) < 1.0) {
            return new PdVector(agtanhz.re, agtanhz.im, 0.0);
        }
        return x;
    }

    public static boolean isConvex(PdVector[] v) {
        int n = v.length;
        double alpha = PdVector.angle((PdVector)v[0], (PdVector)v[1], (PdVector)v[n - 1]);
        if (Math.abs(alpha) < 1.0E-8 || Math.abs(alpha - 180.0) < 1.0E-8) {
            return false;
        }
        int i = 1;
        while (i < n) {
            alpha = PdVector.angle((PdVector)v[i], (PdVector)v[i - 1], (PdVector)v[(i + 1) % n]);
            if (Math.abs(alpha) < 1.0E-8 || Math.abs(alpha - 180.0) < 1.0E-8) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

