/*
 * Decompiled with CFR 0.152.
 */
package devRegularMap.vecmath;

import devRegularMap.vecmath.PuHyperboloid;
import jv.geom.PgElementSet;
import jv.vecmath.P_Vector;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jv.vecmath.PuVectorGeom;

public class PuCompGeometry {
    static final int MAX_INTER = 100;

    public static boolean intersect2D_SegPoly(PdVector ts0, PdVector ts1, PdVector[] poly) {
        PdVector Kts0 = (PdVector)ts0.clone();
        PdVector Kts1 = (PdVector)ts1.clone();
        PdVector[] Kpoly = new PdVector[poly.length];
        int i = 0;
        while (i < poly.length) {
            Kpoly[i] = (PdVector)poly[i].clone();
            ++i;
        }
        PuHyperboloid.hyperboloidToKlein(new PdVector[]{Kts0, Kts1});
        PuHyperboloid.hyperboloidToKlein(Kpoly);
        int n = poly.length;
        double eps = 1.0E-8;
        if (Kts0.m_data == Kts1.m_data) {
            return false;
        }
        double tE = 0.0;
        double tL = 1.0;
        PdVector dS = PdVector.subNew((PdVector)Kts1, (PdVector)Kts0);
        PdVector e = new PdVector(3);
        int i2 = 0;
        while (i2 < n) {
            e = PdVector.subNew((PdVector)Kpoly[(i2 + 1) % n], (PdVector)Kpoly[i2]);
            double N = PuCompGeometry.perp(e, PdVector.subNew((PdVector)Kts0, (PdVector)Kpoly[i2]));
            double D = -PuCompGeometry.perp(e, dS);
            if (Math.abs(D) < eps) {
                if (N < 0.0 && Math.abs(N) > eps) {
                    return false;
                }
            } else {
                double t = N / D;
                if (D < 0.0 && Math.abs(D) > eps ? t > tE && Math.abs(t - tE) > eps && (tE = t) > tL && Math.abs(tE - tL) > eps : D > 0.0 && Math.abs(D) > eps && t < tL && Math.abs(t - tL) > eps && (tL = t) < tE && Math.abs(tL - tE) > eps) {
                    return false;
                }
            }
            ++i2;
        }
        return true;
    }

    private static double perp(PdVector u, PdVector v) {
        return u.m_data[1] * v.m_data[2] - u.m_data[2] * v.m_data[1];
    }

    public static boolean insideTriangle(PdVector v, PdVector[] triangle, boolean edgePoint) {
        int pointinside = 0;
        int j = 0;
        while (j < 3) {
            double area;
            double test = (triangle[(j + 1) % 3].m_data[1] - triangle[j].m_data[1]) * (v.m_data[2] - triangle[j].m_data[2]) - (v.m_data[1] - triangle[j].m_data[1]) * (triangle[(j + 1) % 3].m_data[2] - triangle[j].m_data[2]);
            if (test > 1.0E-8) {
                ++pointinside;
            }
            if ((area = PdVector.area((PdVector)triangle[j], (PdVector)v, (PdVector)triangle[(j + 1) % 3])) < 1.0E-8 && edgePoint) {
                return true;
            }
            ++j;
        }
        return pointinside == 3;
    }

    public static PiVector computeInterQuadTriangle(PiVector count, PdVector[] quad, PdVector[] triangle, PiVector pol1index, PiVector indcutQuad, PgElementSet pe, int index, PiVector[] edgeinterpolation) {
        int ind = 0;
        PiVector cutQuad = new PiVector(1);
        double m_eps = 1.0E-8;
        int k = 0;
        while (k < quad.length) {
            PdVector[] interPoints = new PdVector[2];
            PdVector interptime = new PdVector(2);
            PdVector qs0 = quad[k];
            PdVector qs1 = quad[(k + 1) % 4];
            int iqs0 = pol1index.getEntry(k);
            int iqs1 = pol1index.getEntry((k + 1) % 4);
            int locs0 = k;
            int locs1 = (k + 1) % 4;
            if (PuCompGeometry.intersectionLinePolygon(qs0, qs1, triangle, interPoints, interptime)) {
                PdVector enterPol = interPoints[0];
                PdVector leavePol = interPoints[1];
                if (PdVector.subNew((PdVector)enterPol, (PdVector)leavePol).length() < m_eps) {
                    if (PdVector.subNew((PdVector)qs0, (PdVector)enterPol).length() < m_eps) {
                        cutQuad.setEntry(ind, iqs0);
                        indcutQuad.setEntry(ind, locs0);
                    } else if (PdVector.subNew((PdVector)qs1, (PdVector)enterPol).length() < m_eps) {
                        cutQuad.setEntry(ind, iqs1);
                        indcutQuad.setEntry(ind, locs1);
                    } else {
                        int currentnov = pe.getNumVertices();
                        pe.setNumVertices(currentnov + 1);
                        pe.setVertex(currentnov, enterPol);
                        cutQuad.setEntry(ind, currentnov);
                        indcutQuad.setEntry(ind, currentnov);
                        edgeinterpolation[count.getEntry((int)0)] = new PiVector(index, locs0, locs1, currentnov);
                        count.setEntry(0, count.getEntry(0) + 1);
                    }
                    ++ind;
                } else {
                    int currentnov;
                    PdVector edge = PdVector.subNew((PdVector)qs1, (PdVector)qs0);
                    double interE = PdVector.dot((PdVector)edge, (PdVector)PdVector.subNew((PdVector)interPoints[0], (PdVector)qs0));
                    double interL = PdVector.dot((PdVector)edge, (PdVector)PdVector.subNew((PdVector)interPoints[1], (PdVector)qs0));
                    interE /= edge.sqrLength();
                    interL /= edge.sqrLength();
                    if (Math.abs(interE) < m_eps && Math.abs(interL - 1.0) < m_eps) {
                        cutQuad.setEntry(ind, iqs0);
                        cutQuad.setEntry(ind + 1, iqs1);
                        indcutQuad.setEntry(ind, locs0);
                        indcutQuad.setEntry(ind + 1, locs1);
                    } else if (Math.abs(interE) < m_eps) {
                        currentnov = pe.getNumVertices();
                        pe.setNumVertices(currentnov + 1);
                        pe.setVertex(currentnov, leavePol);
                        cutQuad.setEntry(ind, iqs0);
                        cutQuad.setEntry(ind + 1, currentnov);
                        indcutQuad.setEntry(ind, locs0);
                        indcutQuad.setEntry(ind + 1, currentnov);
                        edgeinterpolation[count.getEntry((int)0)] = new PiVector(index, locs0, locs1, currentnov);
                        count.setEntry(0, count.getEntry(0) + 1);
                    } else if (Math.abs(interL - 1.0) < m_eps) {
                        currentnov = pe.getNumVertices();
                        pe.setNumVertices(currentnov + 1);
                        pe.setVertex(currentnov, enterPol);
                        cutQuad.setEntry(ind, currentnov);
                        cutQuad.setEntry(ind + 1, iqs1);
                        indcutQuad.setEntry(ind, currentnov);
                        indcutQuad.setEntry(ind + 1, locs1);
                        edgeinterpolation[count.getEntry((int)0)] = new PiVector(index, locs0, locs1, currentnov);
                        count.setEntry(0, count.getEntry(0) + 1);
                    } else {
                        currentnov = pe.getNumVertices();
                        pe.setNumVertices(currentnov + 2);
                        pe.setVertex(currentnov, enterPol);
                        pe.setVertex(currentnov + 1, leavePol);
                        cutQuad.setEntry(ind, currentnov);
                        cutQuad.setEntry(ind + 1, currentnov + 1);
                        indcutQuad.setEntry(ind, currentnov);
                        indcutQuad.setEntry(ind + 1, currentnov + 1);
                        edgeinterpolation[count.getEntry((int)0)] = new PiVector(index, locs0, locs1, currentnov);
                        edgeinterpolation[count.getEntry((int)0) + 1] = new PiVector(index, locs0, locs1, currentnov + 1);
                        count.setEntry(0, count.getEntry(0) + 2);
                    }
                    ind += 2;
                }
            }
            ++k;
        }
        return cutQuad;
    }

    public static void computeInterQuadTriangleNew(PiVector cutQuad, PdVector[] quad, PdVector[] triangle, PiVector quadIndex, PgElementSet geom) {
        int ind = 0;
        cutQuad.setEntry(0, -1);
        double m_eps = 1.0E-8;
        int k = 0;
        while (k < quad.length) {
            PdVector[] interPoints = new PdVector[2];
            PdVector interptime = new PdVector(2);
            PdVector qs0 = quad[k];
            PdVector qs1 = quad[(k + 1) % 4];
            int iqs0 = quadIndex.getEntry(k);
            int iqs1 = quadIndex.getEntry((k + 1) % 4);
            if (PuCompGeometry.intersectionLinePolygon(qs0, qs1, triangle, interPoints, interptime)) {
                PdVector enterPol = interPoints[0];
                PdVector leavePol = interPoints[1];
                if (PdVector.subNew((PdVector)enterPol, (PdVector)leavePol).length() < m_eps) {
                    if (PdVector.subNew((PdVector)qs0, (PdVector)enterPol).length() < m_eps) {
                        if (cutQuad.getLastEntry() != iqs0 && cutQuad.getFirstEntry() != iqs0) {
                            cutQuad.addEntry(iqs0);
                        }
                    } else if (PdVector.subNew((PdVector)qs1, (PdVector)enterPol).length() < m_eps) {
                        if (cutQuad.getLastEntry() != iqs1 && cutQuad.getFirstEntry() != iqs1) {
                            cutQuad.addEntry(iqs1);
                        }
                    } else {
                        int currentnov = geom.getNumVertices();
                        geom.setNumVertices(currentnov + 1);
                        geom.setVertex(currentnov, enterPol);
                        if (cutQuad.getLastEntry() != currentnov && cutQuad.getFirstEntry() != currentnov) {
                            cutQuad.addEntry(currentnov);
                        }
                    }
                    ++ind;
                } else {
                    int currentnov;
                    PdVector edge = PdVector.subNew((PdVector)qs1, (PdVector)qs0);
                    double interE = PdVector.dot((PdVector)edge, (PdVector)PdVector.subNew((PdVector)interPoints[0], (PdVector)qs0));
                    double interL = PdVector.dot((PdVector)edge, (PdVector)PdVector.subNew((PdVector)interPoints[1], (PdVector)qs0));
                    interE /= edge.sqrLength();
                    interL /= edge.sqrLength();
                    if (Math.abs(interE) < m_eps && Math.abs(interL - 1.0) < m_eps) {
                        if (cutQuad.getLastEntry() != iqs0) {
                            cutQuad.addEntry(iqs0);
                        }
                        if (cutQuad.getFirstEntry() != iqs1) {
                            cutQuad.addEntry(iqs1);
                        }
                    } else if (Math.abs(interE) < m_eps) {
                        currentnov = geom.getNumVertices();
                        geom.setNumVertices(currentnov + 1);
                        geom.setVertex(currentnov, leavePol);
                        if (cutQuad.getLastEntry() != iqs0) {
                            cutQuad.addEntry(iqs0);
                        }
                        if (cutQuad.getFirstEntry() != currentnov) {
                            cutQuad.addEntry(currentnov);
                        }
                    } else if (Math.abs(interL - 1.0) < m_eps) {
                        currentnov = geom.getNumVertices();
                        geom.setNumVertices(currentnov + 1);
                        geom.setVertex(currentnov, enterPol);
                        if (cutQuad.getLastEntry() != currentnov) {
                            cutQuad.addEntry(currentnov);
                        }
                        if (cutQuad.getFirstEntry() != iqs1) {
                            cutQuad.addEntry(iqs1);
                        }
                    } else {
                        currentnov = geom.getNumVertices();
                        geom.setNumVertices(currentnov + 2);
                        geom.setVertex(currentnov, enterPol);
                        geom.setVertex(currentnov + 1, leavePol);
                        if (cutQuad.getLastEntry() != currentnov) {
                            cutQuad.addEntry(currentnov);
                        }
                        if (cutQuad.getFirstEntry() != currentnov + 1) {
                            cutQuad.addEntry(currentnov + 1);
                        }
                    }
                    ind += 2;
                }
            }
            ++k;
        }
        if (cutQuad.getSize() >= 3) {
            cutQuad.removeEntry(0);
        } else {
            cutQuad = new PiVector();
        }
    }

    public static boolean isSegmentIntersectSegment(PdVector p1, PdVector p2, PdVector q1, PdVector q2) {
        double eps = 1.0E-7;
        if (PuCompGeometry.liesOnSegment(q1, p1, p2)) {
            return true;
        }
        if (PuCompGeometry.liesOnSegment(q2, p1, p2)) {
            return true;
        }
        if (PuCompGeometry.liesOnSegment(p1, q1, q2)) {
            return true;
        }
        if (PuCompGeometry.liesOnSegment(p2, q1, q2)) {
            return true;
        }
        PdMatrix M = PuHyperboloid.mapToCoshCurve(p1, p2);
        PdVector tp1 = new PdVector(3);
        PdVector tp2 = new PdVector(3);
        PdVector tq1 = new PdVector(3);
        PdVector tq2 = new PdVector(3);
        M.leftMultMatrix(tp1, p1);
        M.leftMultMatrix(tp2, p2);
        M.leftMultMatrix(tq1, q1);
        M.leftMultMatrix(tq2, q2);
        if (tq1.m_data[2] < -eps && tq2.m_data[2] < -eps || tq1.m_data[2] > eps && tq2.m_data[2] > eps) {
            return false;
        }
        PuHyperboloid.hyperboloidToKlein(new PdVector[]{tp1, tp2, tq1, tq2});
        PdVector intPoint = new PdVector(3);
        PdVector dir1 = PdVector.subNew((PdVector)tp2, (PdVector)tp1);
        PdVector dir2 = PdVector.subNew((PdVector)tq2, (PdVector)tq1);
        dir1.normalize();
        dir2.normalize();
        double s = PuVectorGeom.intersectionOfLineAndLine((PdVector)intPoint, (PdVector)tp1, (PdVector)dir1, (PdVector)tq1, (PdVector)dir2);
        return !(s < 0.0) && !(s > 1.0);
    }

    public static boolean intersectionSegmentSegment(PdVector p1, PdVector p2, PdVector q1, PdVector q2, PdVector interPoint) {
        double eps = 1.0E-7;
        if (PuCompGeometry.liesOnSegment(q1, p1, p2)) {
            interPoint.copy(q1);
            return true;
        }
        if (PuCompGeometry.liesOnSegment(q2, p1, p2)) {
            interPoint.copy(q2);
            return true;
        }
        if (PuCompGeometry.liesOnSegment(p1, q1, q2)) {
            interPoint.copy(p1);
            return true;
        }
        if (PuCompGeometry.liesOnSegment(p2, q1, q2)) {
            interPoint.copy(p2);
            return true;
        }
        PdMatrix M = PuHyperboloid.mapToCoshCurve(p1, p2);
        PdVector tp1 = new PdVector(3);
        PdVector tp2 = new PdVector(3);
        PdVector tq1 = new PdVector(3);
        PdVector tq2 = new PdVector(3);
        M.leftMultMatrix(tp1, p1);
        M.leftMultMatrix(tp2, p2);
        M.leftMultMatrix(tq1, q1);
        M.leftMultMatrix(tq2, q2);
        if (tq1.m_data[2] < -eps && tq2.m_data[2] < -eps || tq1.m_data[2] > eps && tq2.m_data[2] > eps) {
            return false;
        }
        PuHyperboloid.hyperboloidToKlein(new PdVector[]{tp1, tp2, tq1, tq2});
        PdVector dir1 = PdVector.subNew((PdVector)tp2, (PdVector)tp1);
        PdVector dir2 = PdVector.subNew((PdVector)tq2, (PdVector)tq1);
        double len = dir1.length();
        dir1.normalize();
        dir2.normalize();
        double s = PuVectorGeom.intersectionOfLineAndLine((PdVector)interPoint, (PdVector)tp1, (PdVector)dir1, (PdVector)tq1, (PdVector)dir2);
        if (s / len < 0.0 || s / len > 1.0) {
            return false;
        }
        PuHyperboloid.kleinToHyperboloid(interPoint);
        M.invert();
        interPoint.leftMultMatrix(M);
        return true;
    }

    static boolean intersectionLinePolygon(PdVector ts0, PdVector ts1, PdVector[] poly, PdVector[] interPoints, PdVector interptime) {
        PdVector Kts0 = (PdVector)ts0.clone();
        PdVector Kts1 = (PdVector)ts1.clone();
        PdVector[] Kpoly = new PdVector[poly.length];
        int i = 0;
        while (i < poly.length) {
            Kpoly[i] = (PdVector)poly[i].clone();
            ++i;
        }
        PuHyperboloid.hyperboloidToKlein(new PdVector[]{Kts0, Kts1});
        PuHyperboloid.hyperboloidToKlein(Kpoly);
        int n = poly.length;
        double eps = 1.0E-8;
        if (Kts0.m_data == Kts1.m_data) {
            return false;
        }
        double tE = 0.0;
        double tL = 1.0;
        PdVector dS = PdVector.subNew((PdVector)Kts1, (PdVector)Kts0);
        PdVector e = new PdVector(3);
        int i2 = 0;
        while (i2 < n) {
            e = PdVector.subNew((PdVector)Kpoly[(i2 + 1) % n], (PdVector)Kpoly[i2]);
            double N = PuCompGeometry.perp(e, PdVector.subNew((PdVector)Kts0, (PdVector)Kpoly[i2]));
            double D = -PuCompGeometry.perp(e, dS);
            if (Math.abs(D) < eps) {
                if (N < 0.0 && Math.abs(N) > eps) {
                    return false;
                }
            } else {
                double t = N / D;
                if (D < 0.0 && Math.abs(D) > eps ? t > tE && Math.abs(t - tE) > eps && (tE = t) > tL && Math.abs(tE - tL) > eps : D > 0.0 && Math.abs(D) > eps && t < tL && Math.abs(t - tL) > eps && (tL = t) < tE && Math.abs(tL - tE) > eps) {
                    return false;
                }
            }
            ++i2;
        }
        interPoints[0] = PdVector.blendNew((double)1.0, (PdVector)Kts0, (double)tE, (PdVector)dS);
        interPoints[1] = PdVector.blendNew((double)1.0, (PdVector)Kts0, (double)tL, (PdVector)dS);
        PuHyperboloid.kleinToHyperboloid(new PdVector[]{interPoints[0], interPoints[1]});
        interptime.m_data[0] = tE;
        interptime.m_data[1] = tL;
        return true;
    }

    public static boolean pointTriangleinQuad(PdVector[] triangle, PdVector[] quad, PdVector inPoint, PiVector i_point) {
        PdVector[] ct1 = new PdVector[]{quad[0], quad[1], quad[3]};
        PdVector[] ct2 = new PdVector[]{quad[1], quad[2], quad[3]};
        int i = 0;
        while (i < triangle.length) {
            PdVector[][] pdVectorArrayArray = new PdVector[][]{ct1, ct2};
            int n = pdVectorArrayArray.length;
            int n2 = 0;
            while (n2 < n) {
                PdVector[] ct = pdVectorArrayArray[n2];
                if (PuCompGeometry.insideTriangle(triangle[i], ct, false)) {
                    inPoint.copy(triangle[i]);
                    i_point.addEntry(i);
                    return true;
                }
                ++n2;
            }
            ++i;
        }
        return false;
    }

    public static boolean isPointInsideQuad(PdVector[] triangle, PdVector[] quad, PdVector tpoint, PiVector i_point) {
        int i = 0;
        while (i < triangle.length) {
            if (PuCompGeometry.isInsidePolygon(triangle[i], quad, false)) {
                tpoint.copy(triangle[i]);
                i_point.addEntry(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int indOfCellNew(PdVector[] corner, PdVector p, int m_discr) {
        boolean inside;
        double eps = 1.0E-8;
        PdVector[] N1N0 = PuHyperboloid.makeEdge(corner[1], corner[0], m_discr);
        PdVector[] N2N3 = PuHyperboloid.makeEdge(corner[2], corner[3], m_discr);
        PdVector[] N1N2 = PuHyperboloid.makeEdge(corner[1], corner[2], m_discr);
        PdVector[] N0N3 = PuHyperboloid.makeEdge(corner[0], corner[3], m_discr);
        PdVector[] normal_i = new PdVector[m_discr];
        PdVector[] normal_j = new PdVector[m_discr];
        int i = 0;
        while (i < m_discr) {
            normal_i[i] = PdVector.crossNew((PdVector)N1N2[i], (PdVector)N0N3[i]);
            normal_i[i].normalize();
            ++i;
        }
        i = 0;
        while (i < m_discr) {
            normal_j[i] = PdVector.crossNew((PdVector)N2N3[i], (PdVector)N1N0[i]);
            normal_j[i].normalize();
            ++i;
        }
        int ind_i = -1;
        int ind_j = -1;
        int i2 = 0;
        while (i2 < m_discr - 1) {
            double dot_i = PdVector.dot((PdVector)p, (PdVector)normal_i[i2]);
            double dot_ip1 = PdVector.dot((PdVector)p, (PdVector)normal_i[i2 + 1]);
            boolean bl = inside = dot_i < -eps && dot_ip1 > eps || Math.abs(dot_i) < eps && dot_ip1 > eps || dot_i < -eps && Math.abs(dot_ip1) < eps || Math.abs(dot_i) < eps && Math.abs(dot_ip1) < eps;
            if (inside) {
                ind_i = i2;
                break;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < m_discr - 1) {
            double dot_j = PdVector.dot((PdVector)p, (PdVector)normal_j[i2]);
            double dot_jp1 = PdVector.dot((PdVector)p, (PdVector)normal_j[i2 + 1]);
            boolean bl = inside = dot_j < -eps && dot_jp1 > eps || Math.abs(dot_j) < eps && dot_jp1 > eps || dot_j < -eps && Math.abs(dot_jp1) < eps || Math.abs(dot_j) < eps && Math.abs(dot_jp1) < eps;
            if (inside) {
                ind_j = i2;
                break;
            }
            ++i2;
        }
        return ind_j * (m_discr - 1) + ind_i;
    }

    public static PdVector[] getInterGridLine(PdVector start, PdVector end, PdVector[] corner, int m_discr) {
        PdVector[] tmp = new PdVector[100];
        PdVector[] N1N0 = PuHyperboloid.makeEdge(corner[1], corner[0], m_discr);
        PdVector[] N2N3 = PuHyperboloid.makeEdge(corner[2], corner[3], m_discr);
        PdVector[] N1N2 = PuHyperboloid.makeEdge(corner[1], corner[2], m_discr);
        PdVector[] N0N3 = PuHyperboloid.makeEdge(corner[0], corner[3], m_discr);
        int ind = 0;
        int i = 0;
        while (i < m_discr) {
            tmp[ind] = new PdVector(3);
            if (PuCompGeometry.intersectionSegmentSegment(start, end, N1N2[i], N0N3[i], tmp[ind])) {
                ++ind;
            }
            ++i;
        }
        i = 0;
        while (i < m_discr) {
            tmp[ind] = new PdVector(3);
            if (PuCompGeometry.intersectionSegmentSegment(start, end, N2N3[i], N1N0[i], tmp[ind])) {
                ++ind;
            }
            ++i;
        }
        if (PuCompGeometry.isPointInsidePolygon(start, corner, true)) {
            tmp[ind] = start;
            ++ind;
        }
        if (PuCompGeometry.isPointInsidePolygon(end, corner, true)) {
            tmp[ind] = end;
            ++ind;
        }
        PdVector[] interPoints = new PdVector[ind];
        PdVector dir = PdVector.subNew((PdVector)end, (PdVector)start);
        double len = dir.length();
        PdVector dirPoint = new PdVector();
        double[] value = new double[ind];
        int i2 = 0;
        while (i2 < ind) {
            dirPoint = PdVector.subNew((PdVector)tmp[i2], (PdVector)end);
            value[i2] = dirPoint.length() / len;
            ++i2;
        }
        int[] index = new int[ind];
        PuMath.heapsort((int)ind, (double[])value, (int[])index);
        int i3 = 0;
        while (i3 < ind) {
            interPoints[i3] = tmp[index[i3]];
            ++i3;
        }
        return interPoints;
    }

    public static boolean isInsidePolygon(PdVector p, PdVector[] pol, boolean onEdge) {
        int size = pol.length;
        PdVector tp = new PdVector(3);
        PdVector kp = (PdVector)p.clone();
        PdVector[] kquad = new PdVector[size];
        int i = 0;
        while (i < size) {
            kquad[i] = (PdVector)pol[i].clone();
            ++i;
        }
        PuHyperboloid.hyperboloidToKlein(new PdVector[]{kp});
        PuHyperboloid.hyperboloidToKlein(kquad);
        i = 0;
        while (i < size) {
            PdMatrix M = PuHyperboloid.mapToCoshCurve(pol[i], pol[(i + 1) % size]);
            M.leftMultMatrix(tp, p);
            PuHyperboloid.hyperboloidToPoincare(new PdVector[]{tp});
            if (tp.m_data[2] < -1.0E-5) {
                return false;
            }
            if (onEdge && Math.abs(tp.m_data[2]) < 1.0E-5) {
                return true;
            }
            ++i;
        }
        return true;
    }

    public static boolean isPointInsidePolygon(PdVector p, PdVector[] pol, boolean onEdge) {
        double eps = 1.0E-8;
        int size = pol.length;
        PdVector[] normal = new PdVector[4];
        int i = 0;
        while (i < size) {
            normal[i] = PdVector.crossNew((PdVector)pol[(i + 1) % 4], (PdVector)pol[i]);
            normal[i].normalize();
            ++i;
        }
        i = 0;
        while (i < size) {
            double dot = PdVector.dot((PdVector)p, (PdVector)normal[i]);
            if (dot > eps) {
                return false;
            }
            if (Math.abs(dot) < eps && !onEdge) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isPointLeftToLine(PdVector v, PdVector ls, PdVector le, boolean onEdge) {
        if (PuHyperboloid.isTheSame(v, ls) && onEdge) {
            return true;
        }
        if (PuHyperboloid.isTheSame(v, le) && onEdge) {
            return true;
        }
        PdVector tv = new PdVector(3);
        PdMatrix M = PuHyperboloid.mapToCoshCurve(ls, le);
        M.leftMultMatrix(tv, v);
        double angle = PuHyperboloid.angleWithY(tv);
        if (angle < 0.0) {
            return true;
        }
        return Math.abs(angle) < 1.0E-7 && onEdge;
    }

    public static void checkCCW(PdVector[] pos) {
        if (PuCompGeometry.ccw(pos)) {
            return;
        }
        P_Vector.invert((Object[])pos, (int)pos.length);
    }

    public static boolean onEdge(PdVector planVert, PiVector currPlanElt, PdVector[] planarVertex, int[] indexEdge) {
        double eps = 1.0E-4;
        int i = 0;
        while (i < currPlanElt.getSize()) {
            int ind2;
            int ind1 = currPlanElt.getEntry(i);
            double area = PdVector.area((PdVector)planVert, (PdVector)planarVertex[ind1], (PdVector)planarVertex[ind2 = currPlanElt.getEntry((i + 1) % 4)]);
            if (area < eps) {
                indexEdge[0] = i;
                indexEdge[1] = (i + 1) % 4;
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean ccw(PdVector[] triangle) {
        PuHyperboloid.hyperboloidToKlein(triangle);
        double test = (triangle[1].m_data[1] - triangle[0].m_data[1]) * (triangle[2].m_data[2] - triangle[0].m_data[2]) - (triangle[2].m_data[1] - triangle[0].m_data[1]) * (triangle[1].m_data[2] - triangle[0].m_data[2]);
        PuHyperboloid.kleinToHyperboloid(triangle);
        return test > 0.0;
    }

    public static boolean ccwQuad(PdVector[] quad) {
        PdVector[] triangle = new PdVector[]{quad[0], quad[1], quad[3]};
        return PuCompGeometry.ccw(triangle);
    }

    public static boolean liesOnSegment(PdVector v, PdVector p1, PdVector p2) {
        PdVector Kv = new PdVector(3);
        PdVector Kp1 = new PdVector(3);
        PdVector Kp2 = new PdVector(3);
        PdMatrix M = PuHyperboloid.mapToCoshCurve(p1, p2);
        M.leftMultMatrix(Kv, v);
        M.leftMultMatrix(Kp1, p1);
        M.leftMultMatrix(Kp2, p2);
        PuHyperboloid.hyperboloidToKlein(new PdVector[]{Kv, Kp1, Kp2});
        if (Math.abs(Kv.m_data[2]) < -1.0E-7 || Math.abs(Kv.m_data[2]) > 1.0E-7) {
            return false;
        }
        return !(Kv.m_data[1] - Kp2.m_data[1] > 1.0E-7) && !(Kv.m_data[1] < -1.0E-7);
    }

    public static boolean liesOnSegment(PdVector v, PdVector[] quad) {
        int i = 0;
        while (i < 4) {
            if (PuCompGeometry.liesOnSegment(v, quad[i], quad[(i + 1) % 4])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isPolygonIntersectPolygon(PdVector[] qvert, PdVector[] fvert) {
        boolean test3;
        boolean test2;
        boolean test1;
        PdVector ts1;
        PdVector ts0;
        PdVector[] interPoints = new PdVector[2];
        PdVector interptime = new PdVector(3);
        double eps = 1.0E-6;
        int inside = 0;
        int j = 0;
        while (j < fvert.length) {
            ts0 = fvert[j];
            ts1 = fvert[(j + 1) % fvert.length];
            PuCompGeometry.intersectionLinePolygon(ts0, ts1, qvert, interPoints, interptime);
            boolean bl = test1 = interptime.m_data[0] > eps && interptime.m_data[0] < 1.0 - eps;
            if (test1) {
                return true;
            }
            boolean bl2 = test2 = interptime.m_data[1] > eps && interptime.m_data[1] < 1.0 - eps;
            if (test2) {
                return true;
            }
            boolean bl3 = test3 = Math.abs(interptime.m_data[0]) < eps && Math.abs(interptime.m_data[1] - 1.0) < eps;
            if (test3) {
                ++inside;
            }
            ++j;
        }
        if (inside == fvert.length) {
            return true;
        }
        j = 0;
        while (j < qvert.length) {
            ts0 = qvert[j];
            ts1 = qvert[(j + 1) % qvert.length];
            PuCompGeometry.intersectionLinePolygon(ts0, ts1, fvert, interPoints, interptime);
            boolean bl = test1 = interptime.m_data[0] > eps && interptime.m_data[0] < 1.0 - eps;
            if (test1) {
                return true;
            }
            boolean bl4 = test2 = interptime.m_data[1] > eps && interptime.m_data[1] < 1.0 - eps;
            if (test2) {
                return true;
            }
            boolean bl5 = test3 = Math.abs(interptime.m_data[0]) < eps && Math.abs(interptime.m_data[1] - 1.0) < eps;
            if (test3) {
                // empty if block
            }
            ++j;
        }
        return false;
    }

    public static boolean isLineIntersectPolygon(PdVector v0, PdVector v1, PdVector[] fvert) {
        boolean test2;
        boolean test1;
        PdVector[] interPoints = new PdVector[2];
        PdVector interptime = new PdVector(3);
        double eps = 1.0E-6;
        PuCompGeometry.intersectionLinePolygon(v0, v1, fvert, interPoints, interptime);
        boolean bl = test1 = interptime.m_data[0] > eps && interptime.m_data[0] < 1.0 - eps;
        if (test1) {
            return true;
        }
        boolean bl2 = test2 = interptime.m_data[1] > eps && interptime.m_data[1] < 1.0 - eps;
        return test2;
    }

    public static boolean isLineIntersectPolygon(PdVector v0, PdVector v1, PdVector[] fvert, boolean onEdge) {
        boolean test2;
        boolean test1;
        PdVector[] interPoints = new PdVector[2];
        PdVector interptime = new PdVector(3);
        double eps = 1.0E-6;
        PuCompGeometry.intersectionLinePolygon(v0, v1, fvert, interPoints, interptime);
        if (Math.abs(interptime.m_data[0]) < 1.0E-9 && onEdge) {
            return true;
        }
        if (Math.abs(interptime.m_data[0] - 1.0) < 1.0E-9 && onEdge) {
            return true;
        }
        boolean bl = test1 = interptime.m_data[0] > eps && interptime.m_data[0] < 1.0 - eps;
        if (test1) {
            return true;
        }
        boolean bl2 = test2 = interptime.m_data[1] > eps && interptime.m_data[1] < 1.0 - eps;
        return test2;
    }

    public static boolean isSegmentInsidePolygon(PdVector v0, PdVector v1, PdVector[] fvert, boolean onEdge) {
        boolean test = PuCompGeometry.isInsidePolygon(v0, fvert, onEdge);
        boolean test1 = PuCompGeometry.isInsidePolygon(v1, fvert, onEdge);
        return test && test1;
    }

    public static boolean lineLeavesAtVertex(PdVector n_I, PdVector o_I, PdVector[] vcorner, PiVector indVert) {
        PdVector Kp1 = (PdVector)n_I.clone();
        PdVector Kp2 = (PdVector)o_I.clone();
        PdVector[] Kcorner = new PdVector[4];
        int i = 0;
        while (i < 4) {
            Kcorner[i] = (PdVector)vcorner[i].clone();
            ++i;
        }
        PuHyperboloid.hyperboloidToKlein(new PdVector[]{Kp1, Kp2});
        PuHyperboloid.hyperboloidToKlein(Kcorner);
        i = 0;
        while (i < 4) {
            PdVector Kq1 = Kcorner[i];
            PdVector Kq2 = Kcorner[(i + 1) % 4];
            double EPS = 1.0E-6;
            double par = (Kp2.m_data[1] - Kp1.m_data[1]) * (Kq2.m_data[2] - Kq1.m_data[2]) - (Kp2.m_data[2] - Kp1.m_data[2]) * (Kq2.m_data[1] - Kq1.m_data[1]);
            double tp = ((Kq1.m_data[1] - Kp1.m_data[1]) * (Kq2.m_data[2] - Kq1.m_data[2]) - (Kq1.m_data[2] - Kp1.m_data[2]) * (Kq2.m_data[1] - Kq1.m_data[1])) / par;
            double tq = ((Kp2.m_data[2] - Kp1.m_data[2]) * (Kq1.m_data[1] - Kp1.m_data[1]) - (Kp2.m_data[1] - Kp1.m_data[1]) * (Kq1.m_data[2] - Kp1.m_data[2])) / par;
            if (Math.abs(tq) < EPS && -EPS < tp && tp < 1.0 + EPS) {
                indVert.setEntry(0, i);
                return true;
            }
            if (Math.abs(1.0 - tq) < EPS && -EPS < tp && tp < 1.0 + EPS) {
                indVert.setEntry(0, (i + 1) % 4);
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isTriangleInsidePolygon(PdVector[] tri, PdVector[] poly) {
        int ind = 0;
        int i = 0;
        while (i < 3) {
            if (PuCompGeometry.isInsidePolygon(tri[i], poly, false)) {
                ++ind;
            }
            ++i;
        }
        return ind == 3;
    }

    public static boolean triangleIsOutside(PdVector[] quad, PdVector[] ct) {
        PdVector[] kquad = new PdVector[4];
        PdVector[] ktri = new PdVector[3];
        int i = 0;
        while (i < 4) {
            kquad[i] = (PdVector)quad[i].clone();
            ++i;
        }
        i = 0;
        while (i < 3) {
            ktri[i] = (PdVector)ct[i].clone();
            ++i;
        }
        PuHyperboloid.hyperboloidToKlein(kquad);
        PuHyperboloid.hyperboloidToKlein(ktri);
        int j = 0;
        while (j < 3) {
            int k = 0;
            while (k < 4) {
                if (PuCompGeometry.liesOnSegment(ktri[j], kquad[k], kquad[(k + 1) % 4])) {
                    PdVector dir = PdVector.subNew((PdVector)ktri[j], (PdVector)kquad[k]);
                    PdVector dirTest1 = PdVector.subNew((PdVector)kquad[k], (PdVector)ktri[(j + 1) % 3]);
                    PdVector dirTest2 = PdVector.subNew((PdVector)kquad[k], (PdVector)ktri[(j + 2) % 3]);
                    double a = PuCompGeometry.perp(dir, dirTest1);
                    double b = PuCompGeometry.perp(dir, dirTest2);
                    if (a > 1.0E-6 && b > 1.0E-6) {
                        return true;
                    }
                    boolean test1 = PuCompGeometry.isInsidePolygon(ktri[(j + 1) % 3], kquad, true);
                    boolean test2 = PuCompGeometry.isInsidePolygon(ktri[(j + 2) % 3], kquad, true);
                    return !test1 && !test2;
                }
                ++k;
            }
            ++j;
        }
        return false;
    }

    public static boolean quadInsideTriangle(PdVector[] cqpos, PdVector[] ct) {
        int inside = 0;
        int i = 0;
        while (i < 4) {
            if (PuCompGeometry.isInsidePolygon(cqpos[i], ct, false)) {
                ++inside;
            }
            ++i;
        }
        return inside == 4;
    }

    public static boolean quadIntersectSegment(PdVector[] adjQuad, PdVector n, PdVector o) {
        int i = 0;
        while (i < 4) {
            if (PuCompGeometry.isSegmentIntersectSegment(adjQuad[i], adjQuad[(i + 1) % 4], n, o)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void computeInterTrianglePgon(int eltIndex, PgElementSet geom, PdVector[] ordVertex) {
        PiVector elt = geom.getElement(eltIndex);
        int size = elt.getSize();
        PdVector[] tri = new PdVector[size];
        int i = 0;
        while (i < size) {
            tri[i] = (PdVector)geom.getVertex(elt.m_data[i]).clone();
            ++i;
        }
        PiVector cutQuad = new PiVector();
        cutQuad.setEntry(0, -1);
        double m_eps = 1.0E-8;
        int k = 0;
        while (k < size) {
            PdVector[] interPoints = new PdVector[2];
            PdVector interptime = new PdVector(2);
            PdVector qs0 = tri[k];
            PdVector qs1 = tri[(k + 1) % size];
            int iqs0 = elt.getEntry(k);
            int iqs1 = elt.getEntry((k + 1) % size);
            if (PuCompGeometry.intersectionLinePolygon(qs0, qs1, ordVertex, interPoints, interptime)) {
                PdVector enterPol = interPoints[0];
                PdVector leavePol = interPoints[1];
                if (PdVector.subNew((PdVector)enterPol, (PdVector)leavePol).length() < m_eps) {
                    if (PdVector.subNew((PdVector)qs0, (PdVector)enterPol).length() < m_eps) {
                        if (cutQuad.getLastEntry() != iqs0 && cutQuad.getFirstEntry() != iqs0) {
                            cutQuad.addEntry(iqs0);
                        }
                    } else if (PdVector.subNew((PdVector)qs1, (PdVector)enterPol).length() < m_eps) {
                        if (cutQuad.getLastEntry() != iqs1 && cutQuad.getFirstEntry() != iqs1) {
                            cutQuad.addEntry(iqs1);
                        }
                    } else {
                        int currentnov = geom.getNumVertices();
                        geom.setNumVertices(currentnov + 1);
                        geom.setVertex(currentnov, enterPol);
                        if (cutQuad.getLastEntry() != currentnov && cutQuad.getFirstEntry() != currentnov) {
                            cutQuad.addEntry(currentnov);
                        }
                    }
                } else {
                    int currentnov;
                    PdVector edge = PdVector.subNew((PdVector)qs1, (PdVector)qs0);
                    double interE = PdVector.dot((PdVector)edge, (PdVector)PdVector.subNew((PdVector)interPoints[0], (PdVector)qs0));
                    double interL = PdVector.dot((PdVector)edge, (PdVector)PdVector.subNew((PdVector)interPoints[1], (PdVector)qs0));
                    interE /= edge.sqrLength();
                    interL /= edge.sqrLength();
                    if (Math.abs(interE) < m_eps && Math.abs(interL - 1.0) < m_eps) {
                        if (cutQuad.getLastEntry() != iqs0) {
                            cutQuad.addEntry(iqs0);
                        }
                        if (cutQuad.getFirstEntry() != iqs1) {
                            cutQuad.addEntry(iqs1);
                        }
                    } else if (Math.abs(interE) < m_eps) {
                        currentnov = geom.getNumVertices();
                        geom.setNumVertices(currentnov + 1);
                        geom.setVertex(currentnov, leavePol);
                        if (cutQuad.getLastEntry() != iqs0) {
                            cutQuad.addEntry(iqs0);
                        }
                        if (cutQuad.getFirstEntry() != currentnov) {
                            cutQuad.addEntry(currentnov);
                        }
                    } else if (Math.abs(interL - 1.0) < m_eps) {
                        currentnov = geom.getNumVertices();
                        geom.setNumVertices(currentnov + 1);
                        geom.setVertex(currentnov, enterPol);
                        if (cutQuad.getLastEntry() != currentnov) {
                            cutQuad.addEntry(currentnov);
                        }
                        if (cutQuad.getFirstEntry() != iqs1) {
                            cutQuad.addEntry(iqs1);
                        }
                    } else {
                        currentnov = geom.getNumVertices();
                        geom.setNumVertices(currentnov + 2);
                        geom.setVertex(currentnov, enterPol);
                        geom.setVertex(currentnov + 1, leavePol);
                        if (cutQuad.getLastEntry() != currentnov) {
                            cutQuad.addEntry(currentnov);
                        }
                        if (cutQuad.getFirstEntry() != currentnov + 1) {
                            cutQuad.addEntry(currentnov + 1);
                        }
                    }
                }
            }
            ++k;
        }
        if (cutQuad.getSize() >= 3) {
            cutQuad.removeEntry(0);
        } else {
            cutQuad = new PiVector();
        }
        PdVector tpoint = new PdVector(3);
        PiVector i_point = new PiVector();
        int sizePol = ordVertex.length;
        if (cutQuad.getSize() >= 2 && cutQuad.getIndexOf(-1) == -1) {
            if (PuCompGeometry.isPointInsideQuad(ordVertex, tri, tpoint, i_point)) {
                int currentnov = geom.getNumVertices();
                int n = cutQuad.getSize();
                geom.setNumVertices(currentnov + 1);
                geom.setVertex(currentnov, tpoint);
                PdVector p1 = ordVertex[(i_point.m_data[0] + sizePol - 1) % sizePol];
                PdVector p2 = ordVertex[i_point.m_data[0]];
                int k2 = 0;
                while (k2 < n) {
                    if (PuCompGeometry.liesOnSegment(geom.getVertex(cutQuad.m_data[k2]), p1, p2)) {
                        PiVector c_tmp = (PiVector)cutQuad.clone();
                        cutQuad.setSize(n + 1);
                        cutQuad.setEntry(k2 + 1, currentnov);
                        int l1 = k2 + 2;
                        while (l1 < n + 1) {
                            cutQuad.setEntry(l1, c_tmp.m_data[l1 - 1]);
                            ++l1;
                        }
                        break;
                    }
                    ++k2;
                }
            }
            if (cutQuad.getSize() > 2) {
                int currentnoe = geom.getNumElements();
                geom.setDimOfElements(-1);
                geom.setNumElements(currentnoe + 1);
                geom.setElement(currentnoe, cutQuad);
                geom.getElement(currentnoe).setName(elt.getName());
                geom.setElementColor(currentnoe, geom.getElementColor(eltIndex));
            }
        }
    }

    public static void computeInterTrianglePgon(PgElementSet geom, PdVector[] ordVertex) {
        int noe = geom.getNumElements();
        int i = 0;
        while (i < noe) {
            PuCompGeometry.computeInterTrianglePgon(i, geom, ordVertex);
            geom.getElement(i).setTag(2);
            ++i;
        }
        geom.removeMarkedElements();
        geom.removeUnusedVertices();
    }

    public static boolean isTriangleRightToLine(PdVector[] pos, PdVector[] line) {
        PdMatrix M = PuHyperboloid.mapToCoshCurve(line[0], line[1]);
        PdVector[] tpos = new PdVector[3];
        int count = 0;
        int i = 0;
        while (i < 3) {
            tpos[i] = (PdVector)pos[i].clone();
            tpos[i].leftMultMatrix(M);
            if (tpos[i].m_data[2] < 0.0) {
                ++count;
            }
            ++i;
        }
        return count == 3;
    }

    public static boolean ccwOrientLine(PdVector start, PdVector end) {
        PdVector O = new PdVector(1.0, 0.0, 0.0);
        PdVector[] triangle = new PdVector[]{O, start, end};
        return PuCompGeometry.ccw(triangle);
    }

    public static int getIndexOfIntersectionSegmentPolygon(PdVector u, PdVector v, PdVector[] pol, int index) {
        int size = pol.length;
        int i = 0;
        while (i < size) {
            if (PuCompGeometry.isSegmentIntersectSegment(u, v, pol[i], pol[(i + 1) % size]) && i != index) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

