/*
 * Decompiled with CFR 0.152.
 */
package devRegularMap.vecmath;

import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PuCleanMesh;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PwParameterLines;
import jvx.geom.PwPlatonic;
import jvx.geom.PwRefineElementSet;

public class PuBasicRM {
    protected static int HOSOHEDRA = 0;
    protected static int TETRAHEDRON = 1;
    protected static int CUBE = 2;
    protected static int DODECAHEDRON = 3;
    protected static int TORI = 4;
    protected static int T63 = 41;
    protected static int T44 = 42;
    protected static int T36 = 43;
    protected static int m_p;
    protected static int m_q;

    public static PgElementSet getSpaceModel(int[] spaceModel) {
        m_p = spaceModel[1];
        m_q = spaceModel[2];
        PgElementSet geom = new PgElementSet(3);
        switch (spaceModel[0]) {
            case 0: {
                int ind = 0;
                int n_lune = m_q;
                geom.setNumVertices(n_lune + 1);
                geom.setNumElements(n_lune);
                PdVector[] m_vertex = new PdVector[n_lune + 2];
                PdVector e1 = new PdVector(1.0, 0.0, 0.0);
                PdVector e2 = new PdVector(0.0, 1.0, 0.0);
                PdVector e3 = new PdVector(0.0, 0.0, 1.0);
                PdVector e3_minus = new PdVector(0.0, 0.0, -1.0);
                int i = 0;
                while (i < n_lune) {
                    m_vertex[ind] = PdVector.blendNew((double)Math.cos(Math.PI * 2 * (double)i / (double)n_lune), (PdVector)e1, (double)Math.sin(Math.PI * 2 * (double)i / (double)n_lune), (PdVector)e2);
                    geom.setVertex(ind, m_vertex[ind]);
                    ++ind;
                    ++i;
                }
                geom.setVertex(n_lune, e3);
                geom.setVertex(n_lune + 1, e3_minus);
                i = 0;
                while (i < n_lune) {
                    geom.setElement(i, i, n_lune + 1, (i + 1) % n_lune, n_lune);
                    ++i;
                }
                ind = 0;
                PwRefineElementSet.refineSplitCentral((PgElementSet)geom);
                i = 0;
                while (i < n_lune) {
                    Color col = Color.getHSBColor((float)i / (float)n_lune, (float)Math.sin(Math.PI * (double)i / (double)(2 * (n_lune - 1))), 1.0f);
                    int j = 0;
                    while (j < 4) {
                        geom.setElementColor(ind, col);
                        ++ind;
                        ++j;
                    }
                    ++i;
                }
                i = 0;
                while (i < 9) {
                    if (i % 2 == 0) {
                        int j = 0;
                        while (j < geom.getNumVertices()) {
                            geom.getVertex(j).normalize();
                            ++j;
                        }
                    } else {
                        PwRefineElementSet.quadrisection((PgElementSet)geom, (int)5);
                    }
                    ++i;
                }
                break;
            }
            case 1: {
                geom = PwPlatonic.getSolid((int)0);
                int numElt = geom.getNumElements();
                int i = 0;
                while (i < numElt) {
                    Color col = Color.getHSBColor((float)i / (float)numElt, (float)Math.sin(Math.PI * (double)i / (double)(2 * (numElt - 1))), 1.0f);
                    geom.setElementColor(i, col);
                    ++i;
                }
                PuBasicRM.refinePlatonic(geom);
                break;
            }
            case 2: {
                geom = PwPlatonic.getSolid((int)1);
                int numElt = geom.getNumElements();
                int i = 0;
                while (i < numElt) {
                    Color col = Color.getHSBColor((float)i / (float)numElt, (float)Math.sin(Math.PI * (double)i / (double)(2 * (numElt - 1))), 1.0f);
                    geom.setElementColor(i, col);
                    ++i;
                }
                PuBasicRM.refinePlatonic(geom);
                break;
            }
            case 4: {
                int geomtype = -1;
                if (m_p == 4 && m_q == 4) {
                    geomtype = T44;
                } else if (m_p == 6 && m_q == 3) {
                    geomtype = T63;
                } else if (m_p == 3 && m_q == 6) {
                    geomtype = T36;
                }
                geom = PuBasicRM.getTori(spaceModel[3], spaceModel[4], geomtype);
            }
        }
        geom.showElementColors(true);
        return geom;
    }

    private static void refinePlatonic(PgElementSet geom) {
        PwParameterLines.refineParameterLines((PgElementSet)geom, (int)1);
        PwRefineElementSet.refineSplitCentral((PgElementSet)geom);
        int i = 0;
        while (i < 4) {
            if (i % 2 == 0) {
                int j = 0;
                while (j < geom.getNumVertices()) {
                    geom.getVertex(j).normalize();
                    ++j;
                }
            } else {
                PwRefineElementSet.quadrisection((PgElementSet)geom, (int)5);
            }
            ++i;
        }
    }

    public static PgElementSet getPlanarTori(int a, int b, int geomtype) {
        PdVector[] vertex;
        int ind;
        int y;
        int x;
        PgElementSet geom = new PgElementSet(3);
        if (geomtype == T63) {
            x = a + b + 1;
            y = a + b + 1;
            ind = 0;
            PgElementSet scentgen = new PgElementSet(3);
            scentgen.setNumVertices(x * y);
            ind = 0;
            int i = 0;
            while (i < x) {
                int j = 0;
                while (j < y) {
                    scentgen.setVertex(ind, (double)i, (double)(ind % y), 0.0);
                    ++ind;
                    ++j;
                }
                ++i;
            }
            vertex = scentgen.getVertices();
            int i2 = 0;
            while (i2 < vertex.length) {
                double xcoord = vertex[i2].m_data[0];
                double ycoord = vertex[i2].m_data[1];
                if (ycoord == (double)(a + b)) {
                    scentgen.getVertex(i2).setTag(2);
                }
                if (xcoord + (double)b <= (double)(a + b) && ycoord - (double)a > 0.0) {
                    scentgen.getVertex(i2 + y * b - a - 1).setTag(2);
                }
                if (xcoord + (double)a <= (double)(a + b) && ycoord + (double)b <= (double)(a + b)) {
                    scentgen.getVertex(i2 + y * a + b).setTag(2);
                }
                ++i2;
            }
            scentgen.removeMarkedVertices();
            scentgen.makeNeighbour();
            PdVector[] centgen = new PdVector[scentgen.getNumVertices()];
            vertex = scentgen.getVertices();
            geom.setNumElements(centgen.length);
            geom.setNumVertices(6 * centgen.length);
            ind = 0;
            int i3 = 0;
            while (i3 < centgen.length) {
                PdVector vert = scentgen.getVertex(i3);
                double u = vert.getEntry(0);
                double v = vert.getEntry(1);
                vert.setEntry(0, 1.5 * u);
                vert.setEntry(1, (u + 2.0 * v) * Math.sqrt(3.0) / 2.0);
                centgen[i3] = vert;
                ++ind;
                ++i3;
            }
            vertex = new PdVector[geom.getNumVertices()];
            PiVector[] face = new PiVector[centgen.length];
            ind = 0;
            int i4 = 0;
            while (i4 < centgen.length) {
                face[i4] = new PiVector(6);
                int j = 0;
                while (j < 6) {
                    double vcos = Math.cos(1.0471975511965976 * (double)j);
                    double vsin = Math.sin(1.0471975511965976 * (double)j);
                    vertex[ind] = new PdVector(centgen[i4].m_data[0] + vcos, centgen[i4].m_data[1] + vsin, 0.0);
                    face[i4].setEntry(j, ind);
                    ++ind;
                    ++j;
                }
                ++i4;
            }
            double eps = 1.0E-8;
            int i5 = 0;
            while (i5 < face.length) {
                int j = 0;
                while (j < face.length) {
                    PiVector face1 = face[i5];
                    PiVector face2 = face[j];
                    int k = 0;
                    while (k < 6) {
                        int l = 0;
                        while (l < 6) {
                            int ind1 = face1.getEntry(k);
                            int ind2 = face2.getEntry(l);
                            PdVector tmp1 = vertex[ind1];
                            PdVector tmp2 = vertex[ind2];
                            if (Math.abs(tmp1.m_data[0] - tmp2.m_data[0]) < eps && Math.abs(tmp1.m_data[1] - tmp2.m_data[1]) < eps && ind1 != ind2) {
                                face2.setEntry(l, ind1);
                            }
                            ++l;
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i5;
            }
            i5 = 0;
            while (i5 < face.length) {
                int j = 0;
                while (j < 6) {
                    geom.setVertex(face[i5].getEntry(j), vertex[face[i5].getEntry(j)]);
                    ++j;
                }
                geom.setElement(i5, face[i5]);
                ++i5;
            }
            ind = 0;
            i5 = 0;
            while (i5 < geom.getNumVertices()) {
                PdVector vert = geom.getVertex(i5);
                double u = vert.m_data[0];
                double v = vert.m_data[1];
                geom.setVertex(i5, 0.6666666666666666 * u, 0.5 * (2.0 / Math.sqrt(3.0) * v - 0.6666666666666666 * u), 0.0);
                ++i5;
            }
            Color[] v = new Color[]{Color.gray, Color.yellow};
            int i6 = 0;
            while (i6 < geom.getNumElements() / (a + b)) {
                int j = 0;
                while (j < a + b) {
                    geom.setElementColor(ind, v[(i6 + j) % 2]);
                    ++ind;
                    ++j;
                }
                ++i6;
            }
        }
        if (geomtype == T44 || geomtype == T36) {
            x = a + b + 1;
            y = a + b + 1;
            ind = 0;
            geom.setNumElements((x - 1) * (y - 1));
            int i = 0;
            while (i < x - 1) {
                int j = 0;
                while (j < y - 1) {
                    geom.setElement(ind, i * y + j, (i + 1) * y + j, (i + 1) * y + j + 1, i * y + j + 1);
                    ++ind;
                    ++j;
                }
                ++i;
            }
            geom.setNumVertices(x * y);
            ind = 0;
            i = 0;
            while (i < x) {
                int j = 0;
                while (j < y) {
                    geom.setVertex(ind, (double)i, (double)(ind % y), 0.0);
                    ++ind;
                    ++j;
                }
                ++i;
            }
            PiVector patchEl = new PiVector((x - 1) * (y - 1));
            int i7 = 0;
            while (i7 < geom.getNumElements()) {
                patchEl.setEntry(i7, i7);
                ++i7;
            }
            vertex = geom.getVertices();
            PiVector identify = new PiVector(x * y);
            int i8 = 0;
            while (i8 < identify.getSize()) {
                identify.setEntry(i8, i8);
                ++i8;
            }
            i8 = 0;
            while (i8 < geom.getNumElements()) {
                PiVector f = geom.getElement(i8);
                double xcoord = vertex[f.getEntry((int)0)].m_data[0];
                double ycoord = vertex[f.getEntry((int)0)].m_data[1];
                if (xcoord + (double)b <= (double)(a + b - 1) && ycoord - (double)a >= 0.0) {
                    geom.getElement(i8 + (y - 1) * b - a).setTag(2);
                }
                if (xcoord + (double)a <= (double)(a + b - 1) && ycoord + (double)b <= (double)(a + b - 1) && i8 + (y - 1) * a + b <= geom.getNumElements()) {
                    geom.getElement(i8 + (y - 1) * a + b).setTag(2);
                }
                ++i8;
            }
            geom.removeMarkedElements();
            geom.makeNeighbour();
            Color[] v = new Color[]{Color.gray, Color.ORANGE};
            ind = 0;
            int i9 = 0;
            while (i9 < geom.getNumElements() / (a + b)) {
                int j = 0;
                while (j < a + b) {
                    geom.setElementColor(ind, v[(i9 + j) % 2]);
                    ++ind;
                    ++j;
                }
                ++i9;
            }
            if (geomtype == T36) {
                PgElementSet elt = (PgElementSet)geom.clone();
                geom.setNumElements(2 * elt.getNumElements());
                int i10 = 0;
                while (i10 < elt.getNumElements()) {
                    PiVector quad = elt.getElement(i10);
                    geom.setElement(i10, quad.getEntry(0), quad.getEntry(1), quad.getEntry(3));
                    geom.setElement(elt.getNumElements() + i10, quad.getEntry(1), quad.getEntry(3), quad.getEntry(2));
                    geom.setElementColor(i10, v[i10 % 2]);
                    geom.setElementColor(elt.getNumElements() + i10, v[(elt.getNumElements() + i10 + 1) % 2].brighter());
                    ++i10;
                }
                geom.makeElementNormals();
            }
        }
        int i = 0;
        while (i < geom.getNumVertices()) {
            PdVector vert = geom.getVertex(i);
            double u = vert.getEntry(0);
            double v = vert.getEntry(1);
            vert.setEntry(0, ((double)a * u + (double)b * v) / (double)(a * a + b * b));
            vert.setEntry(1, ((double)(-b) * u + (double)a * v) / (double)(a * a + b * b));
            vert.multScalar(Math.PI * 2);
            ++i;
        }
        geom.makeNeighbour();
        geom.removeUnusedVertices();
        return geom;
    }

    public static PgElementSet getTori(int a, int b, int geomtype) {
        PgElementSet planar = PuBasicRM.getPlanarTori(a, b, geomtype);
        PwRefineElementSet.quadrisection((PgElementSet)planar, (int)4);
        PwRefineElementSet.quadrisection((PgElementSet)planar, (int)4);
        PwRefineElementSet.quadrisection((PgElementSet)planar, (int)4);
        PwRefineElementSet.quadrisection((PgElementSet)planar, (int)4);
        PwRefineElementSet.quadrisection((PgElementSet)planar, (int)4);
        int i = 0;
        while (i < planar.getNumVertices()) {
            PdVector vert = planar.getVertex(i);
            double t = vert.getEntry(1);
            double s = -vert.getEntry(0);
            vert.m_data[0] = (2.0 + Math.cos(t)) * Math.cos(s);
            vert.m_data[1] = (2.0 + Math.cos(t)) * Math.sin(s);
            vert.m_data[2] = Math.sin(t);
            ++i;
        }
        PuCleanMesh.identifyVertices((PgPointSet)planar, (double)1.0E-8);
        planar.makeNeighbour();
        planar.makeElementNormals();
        planar.makeVertexNormals();
        return planar;
    }
}

