/*
 * Decompiled with CFR 0.152.
 */
package devRegularMap.sparser;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import jv.object.PsDebug;
import jv.vecmath.PiVector;

public class PsRMDatabase {
    protected static String[] m_sourceMap;
    protected static String[][] m_targetMap;
    protected static String[] m_ftype;
    protected static final String m_absolute_path;

    static {
        m_absolute_path = String.valueOf(System.getProperty("user.dir")) + "\\src\\devRegularMap\\ioFile\\";
    }

    private static void generateList(int genus) {
        if (genus == 0) {
            m_sourceMap = new String[55];
            m_targetMap = new String[1][];
            PsRMDatabase.m_sourceMap[0] = "tetrahedron {3,3}";
            PsRMDatabase.m_sourceMap[1] = "octahedron {3,4}";
            PsRMDatabase.m_sourceMap[2] = "cube {4,3}";
            PsRMDatabase.m_sourceMap[3] = "icosahedron {3,5}";
            PsRMDatabase.m_sourceMap[4] = "dodecahedron {5,3}";
            int i = 3;
            while (i < 53) {
                PsRMDatabase.m_sourceMap[i + 2] = "hosohedron {2," + i + "}";
                ++i;
            }
        } else if (genus == 1) {
            m_sourceMap = new String[42];
            m_targetMap = new String[1][];
            int ind = 0;
            String t = "torus {4,4}";
            int i = 1;
            while (i < 8) {
                PsRMDatabase.m_sourceMap[ind] = String.valueOf(t) + i + ",0";
                ++ind;
                ++i;
            }
            i = 1;
            while (i < 8) {
                PsRMDatabase.m_sourceMap[ind] = String.valueOf(t) + i + "," + i;
                ++ind;
                ++i;
            }
            t = "torus {3,6}";
            i = 1;
            while (i < 8) {
                PsRMDatabase.m_sourceMap[ind] = String.valueOf(t) + i + ",0";
                ++ind;
                ++i;
            }
            i = 1;
            while (i < 8) {
                PsRMDatabase.m_sourceMap[ind] = String.valueOf(t) + i + "," + i;
                ++ind;
                ++i;
            }
            t = "torus {6,3}";
            i = 1;
            while (i < 8) {
                PsRMDatabase.m_sourceMap[ind] = String.valueOf(t) + i + ",0";
                ++ind;
                ++i;
            }
            i = 1;
            while (i < 8) {
                PsRMDatabase.m_sourceMap[ind] = String.valueOf(t) + i + "," + i;
                ++ind;
                ++i;
            }
        } else {
            int i = 2;
            while (i < 102) {
                if (genus == i) {
                    HashMap<String, String> spm = new HashMap<String, String>();
                    HashMap<String, String> gen = new HashMap<String, String>();
                    String[][] map = PsRMDatabase.loadFactorList(i, spm, gen);
                    int size = 0;
                    while (map[size][0] != null) {
                        ++size;
                    }
                    m_targetMap = new String[size][];
                    int j = 0;
                    while (j < size) {
                        String tmp = (String)spm.get(map[j][0]);
                        if (tmp.contains(";")) {
                            PsRMDatabase.m_targetMap[j] = tmp.split(";");
                            int len = m_targetMap[j].length;
                            int k = 0;
                            while (k < len) {
                                String[] d;
                                String schlafi = "";
                                String s = m_targetMap[j][k];
                                s.trim();
                                if (s.contains("R")) {
                                    d = new HashMap();
                                    PsRMDatabase.conderInformation(s, d);
                                    String[] tmp1 = ((String)d.get(s)).split("_");
                                    String[] tmp11 = tmp1[0].split(",");
                                    int p = Integer.parseInt(tmp11[0].substring(1, tmp11[0].length()));
                                    int q = Integer.parseInt(tmp11[1].substring(0, tmp11[1].length() - 1));
                                    schlafi = s.contains("'") ? "{" + q + "," + p + "}" : "{" + p + "," + q + "}";
                                } else if (s.contains("cube")) {
                                    schlafi = " {4,3}";
                                } else if (s.contains("tetrahedron")) {
                                    schlafi = " {3,3}";
                                } else if (s.contains("octahedron")) {
                                    schlafi = " {3,4}";
                                } else if (s.contains("dodecahedron")) {
                                    schlafi = " {5,3}";
                                } else if (s.contains("icosahedron")) {
                                    schlafi = " {3,5}";
                                } else if (s.contains("hosohedron")) {
                                    d = s.split("-");
                                    s = d[0];
                                    schlafi = " {2," + d[1] + "}";
                                }
                                PsRMDatabase.m_targetMap[j][k] = String.valueOf(s) + schlafi;
                                ++k;
                            }
                        } else {
                            String[] d;
                            PsRMDatabase.m_targetMap[j] = new String[]{tmp};
                            String schlafi = "";
                            String s = m_targetMap[j][0];
                            s.trim();
                            if (s.contains("R")) {
                                d = new HashMap();
                                PsRMDatabase.conderInformation(s, d);
                                String[] tmp1 = ((String)d.get(s)).split("_");
                                String[] tmp11 = tmp1[0].split(",");
                                int p = Integer.parseInt(tmp11[0].substring(1, tmp11[0].length()));
                                int q = Integer.parseInt(tmp11[1].substring(0, tmp11[1].length() - 1));
                                schlafi = s.contains("'") ? "{" + q + "," + p + "}" : "{" + p + "," + q + "}";
                            } else if (s.contains("cube")) {
                                schlafi = " {4,3}";
                            } else if (s.contains("tetrahedron")) {
                                schlafi = " {3,3}";
                            } else if (s.contains("octahedron")) {
                                schlafi = " {3,4}";
                            } else if (s.contains("dodecahedron")) {
                                schlafi = " {5,3}";
                            } else if (s.contains("icosahedron")) {
                                schlafi = " {3,5}";
                            } else if (s.contains("hosohedron")) {
                                d = s.split("-");
                                s = d[0];
                                schlafi = " {2," + d[1] + "}";
                            }
                            PsRMDatabase.m_targetMap[j][0] = String.valueOf(s) + schlafi;
                        }
                        ++j;
                    }
                    HashMap<String, String> d = new HashMap<String, String>();
                    int j2 = 0;
                    while (j2 < size) {
                        PsRMDatabase.conderInformation(map[j2][0], d);
                        ++j2;
                    }
                    m_sourceMap = new String[size];
                    m_ftype = new String[size];
                    j2 = 0;
                    while (j2 < size) {
                        String[] tmp = ((String)d.get(map[j2][0])).split("_");
                        String[] tmp1 = tmp[0].split(",");
                        String[] tmp2 = map[j2][0].split("\\.");
                        int p = Integer.parseInt(tmp1[0].substring(1, tmp1[0].length()));
                        int q = Integer.parseInt(tmp1[1].substring(0, tmp1[1].length() - 1));
                        PsRMDatabase.m_sourceMap[j2] = tmp2[1].contains("'") ? String.valueOf(map[j2][0]) + "{" + q + "," + p + "}" : String.valueOf(map[j2][0]) + "{" + p + "," + q + "}";
                        PsRMDatabase.m_ftype[j2] = map[j2][1];
                        ++j2;
                    }
                    break;
                }
                ++i;
            }
        }
    }

    public static String[][] getListTargetMap() {
        return m_targetMap;
    }

    public static String[] getListSourceMap(int genus) {
        PsRMDatabase.generateList(genus);
        return m_sourceMap;
    }

    public static String[] getFtype() {
        return m_ftype;
    }

    public static String[][] loadFactorList(int genus, Map<String, String> spm, Map<String, String> gens) {
        String[][] info = new String[1000][2];
        int ind = 0;
        try {
            String str;
            FileInputStream fstream = new FileInputStream(String.valueOf(m_absolute_path) + "RMFactorList.txt");
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((str = br.readLine()) != null) {
                String[] tmp = str.split("->");
                String[] s = tmp[0].split("#");
                String[] s1 = tmp[1].split(";");
                String[] tmp1 = s[1].split("\\.");
                String[] tmp2 = s1[1].split(":");
                int g = Integer.parseInt(tmp1[0].substring(2, tmp1[0].length()));
                String gen = br.readLine();
                tmp = gen.split(",\\s+");
                tmp1 = tmp[0].split("\\s+");
                gen = String.valueOf(tmp1[2]) + "," + tmp[1] + "," + tmp[2];
                s[1] = s[1].trim();
                s1[0] = s1[0].trim();
                tmp2[1].trim();
                if (genus == g) {
                    if (!gens.containsKey(s[1])) {
                        gens.put(s[1], gen);
                        spm.put(s[1], s1[0]);
                        info[ind][0] = s[1];
                        info[ind][1] = tmp2[1];
                        ++ind;
                        continue;
                    }
                    gens.put(s[1], String.valueOf(gens.get(s[1])) + ";" + gen);
                    spm.put(s[1], String.valueOf(spm.get(s[1])) + ";" + s1[0]);
                    continue;
                }
                if (g > genus) break;
            }
            br.close();
        }
        catch (Exception e) {
            PsDebug.error((String)e.getMessage());
        }
        return info;
    }

    public static void conderInformation(String r, Map<String, String> d) {
        try {
            String str;
            FileInputStream fstream = new FileInputStream(String.valueOf(m_absolute_path) + "OrientableRegularMaps101.txt");
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            int readline = 0;
            while ((str = br.readLine()) != null) {
                if (readline >= 18) {
                    if (str.length() == 0) {
                        str = br.readLine();
                    }
                    String[] l = str.split("\\s+");
                    String rd = r.substring(0, r.length() - 1);
                    if (l[0].equals(r) || l[0].equals(rd) && r.contains("'")) {
                        if (d.containsKey(r)) break;
                        d.put(r, l[3]);
                        break;
                    }
                }
                ++readline;
            }
            br.close();
        }
        catch (Exception e) {
            PsDebug.error((String)e.getMessage());
        }
    }

    public static void getParameters(PiVector param, String map) {
        int g = -1;
        int i = -1;
        int p = -1;
        int q = -1;
        int a = -1;
        int b = -1;
        if (map.contains("torus")) {
            String[] s = map.split("\\s+");
            String[] tmp = s[1].split(",");
            g = 1;
            p = Integer.parseInt(tmp[0].substring(1, tmp[0].length()));
            b = Integer.parseInt(tmp[2]);
            tmp = tmp[1].split("\\}");
            q = Integer.parseInt(tmp[0]);
            a = Integer.parseInt(tmp[1]);
            if (p == 4 && q == 4) {
                i = b == 0 ? a - 1 : 7 + a;
            }
            if (p == 3 && q == 6) {
                i = b == 0 ? 14 + a - 1 : 21 + a - 1;
            }
            if (p == 6 && q == 3) {
                i = b == 0 ? 28 + a - 1 : 35 + a - 1;
            }
        } else if (map.contains("R")) {
            String[] tmp = map.split("\\.");
            String s = tmp[0];
            s.trim();
            g = Integer.parseInt(s.substring(1, s.length()));
            s = tmp[1];
            s.trim();
            if (s.contains("'")) {
                tmp = s.split("'");
                i = Integer.parseInt(tmp[0]);
                String[] l = tmp[1].split(",");
                q = Integer.parseInt(l[1].substring(0, l[1].length() - 1));
                p = Integer.parseInt(l[0].substring(1, l[0].length()));
            } else {
                tmp = s.split(",");
                String[] l = tmp[0].split("\\{");
                i = Integer.parseInt(l[0]);
                p = Integer.parseInt(l[1]);
                q = Integer.parseInt(tmp[1].substring(0, tmp[1].length() - 1));
            }
        } else {
            g = 0;
            if (map.contains("tetrahedron")) {
                i = 0;
                p = 3;
                q = 3;
            } else if (map.contains("cube")) {
                i = 2;
                p = 4;
                q = 3;
            } else if (map.contains("octahedron")) {
                i = 1;
                p = 3;
                q = 4;
            } else if (map.contains("icosahedron")) {
                i = 3;
                p = 3;
                q = 5;
            } else if (map.contains("dodecahedron")) {
                i = 4;
                p = 5;
                q = 3;
            } else if (map.contains("hosohedron")) {
                String aux = "";
                if (map.contains("-")) {
                    String[] tmp = map.split("-");
                    aux = tmp[1];
                } else {
                    String[] tmp = map.split("\\s+");
                    tmp = tmp[1].split(",");
                    int j = 0;
                    while (j < tmp[1].length() - 1) {
                        aux = String.valueOf(aux) + tmp[1].charAt(j);
                        ++j;
                    }
                }
                i = Integer.parseInt(aux) + 5;
                p = 2;
                q = Integer.parseInt(aux);
            }
        }
        param.set(new int[]{g, i, p, q, a, b});
    }

    public static String[] getGenerator(String source, String target) {
        String[] generator = new String[3];
        HashMap<String, String> spm = new HashMap<String, String>();
        HashMap<String, String> gen = new HashMap<String, String>();
        PiVector param = new PiVector(6);
        PsRMDatabase.getParameters(param, source);
        String[][] map = PsRMDatabase.loadFactorList(param.m_data[0], spm, gen);
        int size = 0;
        while (map[size][0] != null) {
            ++size;
        }
        String s = source.split("\\{")[0];
        int j = 0;
        while (j < size) {
            if (map[j][0].equals(s)) {
                String tmp = (String)spm.get(map[j][0]);
                String tmp1 = (String)gen.get(map[j][0]);
                if (tmp.contains(";")) {
                    String[] sm = tmp.split(";");
                    String[] ABC = tmp1.split(";");
                    String t = "";
                    if (target.contains("R")) {
                        t = target.split("\\{")[0];
                    } else if (target.contains("hosohedron")) {
                        if (!target.contains("-")) {
                            String[] tmp2 = target.split("\\s+");
                            String[] tmp3 = tmp2[1].split(",");
                            String a = "";
                            int i = 0;
                            while (i < tmp3[1].length() - 1) {
                                a = String.valueOf(a) + tmp3[1].charAt(i);
                                ++i;
                            }
                            t = String.valueOf(tmp2[0]) + "-" + a;
                        } else {
                            t = target;
                        }
                    } else {
                        t = !target.contains("torus") ? target.split("\\s+")[0] : target;
                    }
                    int k = 0;
                    while (k < sm.length) {
                        if (sm[k].equals(t)) {
                            generator = ABC[k].split(",");
                        }
                        ++k;
                    }
                    break;
                }
                generator = tmp1.split(",");
                break;
            }
            ++j;
        }
        return generator;
    }

    public static String getTargetMap(String source) {
        if (!source.contains("R")) {
            return null;
        }
        String target = "";
        String s = source.split("\\{")[0];
        HashMap<String, String> spm = new HashMap<String, String>();
        HashMap<String, String> gen = new HashMap<String, String>();
        PiVector param = new PiVector(6);
        PsRMDatabase.getParameters(param, source);
        String[][] map = PsRMDatabase.loadFactorList(param.m_data[0], spm, gen);
        int size = 0;
        while (map[size][0] != null) {
            ++size;
        }
        int j = 0;
        while (j < size) {
            if (map[j][0].equals(s)) {
                String tmp = (String)spm.get(map[j][0]);
                target = tmp.contains(";") ? tmp.split(";")[0] : tmp;
            }
            ++j;
        }
        PsRMDatabase.getParameters(param, target);
        if (target.contains("R")) {
            int p = param.m_data[2];
            int q = param.m_data[3];
            target = String.valueOf(target) + "{" + p + "," + q + "}";
        }
        return target;
    }

    public static String[] getTargetMaps(String source) {
        if (!source.contains("R")) {
            return null;
        }
        int maxTrg = 5;
        String[] target = new String[maxTrg];
        String s = source.split("\\{")[0];
        HashMap<String, String> spm = new HashMap<String, String>();
        HashMap<String, String> gen = new HashMap<String, String>();
        PiVector param = new PiVector(6);
        PsRMDatabase.getParameters(param, source);
        String[][] map = PsRMDatabase.loadFactorList(param.m_data[0], spm, gen);
        int size = 0;
        while (map[size][0] != null) {
            ++size;
        }
        int j = 0;
        while (j < size) {
            if (map[j][0].equals(s)) {
                String tmp = (String)spm.get(map[j][0]);
                target = tmp.contains(";") ? tmp.split(";") : new String[]{tmp};
            }
            ++j;
        }
        int i = 0;
        while (i < target.length) {
            PsRMDatabase.getParameters(param, target[i]);
            if (target[i].contains("R")) {
                int p = param.m_data[2];
                int q = param.m_data[3];
                target[i] = String.valueOf(target[i]) + "{" + p + "," + q + "}";
            }
            ++i;
        }
        return target;
    }

    public static String getFtype(String source) {
        HashMap<String, String> spm = new HashMap<String, String>();
        HashMap<String, String> gen = new HashMap<String, String>();
        PiVector param = new PiVector(6);
        PsRMDatabase.getParameters(param, source);
        String[][] map = PsRMDatabase.loadFactorList(param.m_data[0], spm, gen);
        int size = 0;
        while (map[size][0] != null) {
            ++size;
        }
        String s = source.split("\\{")[0];
        int j = 0;
        while (j < size) {
            if (map[j][0].equals(s)) {
                map[j][1].trim();
                return map[j][1].trim();
            }
            ++j;
        }
        return null;
    }
}

