/*
 * Decompiled with CFR 0.152.
 */
package devRegularMap.smoothing;

import java.awt.Color;
import jv.geom.PgBndPolygon;
import jv.geom.PgElementSet;
import jv.geom.PgVectorField;
import jv.number.PdColor;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jv.vecmath.PuVectorGeom;
import jvx.geom.PgVertexStar;
import jvx.geom.PwRefineElementSet;
import jvx.project.PjWorkshop;

public class PwCatmullClarkSmoothing
extends PjWorkshop
implements Runnable {
    protected PgElementSet m_elementSet;
    protected PuInteger m_frame;
    protected static boolean m_bTangential;
    protected Thread m_thread;
    protected boolean m_bRunning = false;
    protected boolean m_bStopped = true;

    public PwCatmullClarkSmoothing() {
        super("Catmull Clarck Smoothing");
        if (this.getClass() == PwCatmullClarkSmoothing.class) {
            this.init();
        }
    }

    public void init() {
        this.m_frame = new PuInteger(PsConfig.getMessage((boolean)true, (int)54000, (String)"Frame/Iter"));
        this.m_frame.addUpdateListener((PsUpdateIf)this);
        this.m_frame.setDefBounds(1, 100, 1, 1);
        this.m_frame.setDefValue(1);
        this.m_frame.init();
    }

    public boolean update(Object event) {
        if (event == this.m_elementSet) {
            this.m_elementSet.update((Object)this.m_elementSet);
            return super.update(null);
        }
        return super.update(null);
    }

    public void setGeometry(PgGeometry geom) {
        super.setGeometry(geom);
        this.m_elementSet = (PgElementSet)geom;
    }

    public void smoothCC() {
        PwCatmullClarkSmoothing.smoothingCC(this.m_elementSet);
    }

    public void smoothLoop() {
        PwCatmullClarkSmoothing.refineIntoFour(this.m_elementSet);
        this.update(this.m_elementSet);
    }

    public static void refineIntoFour(PgElementSet m_elementSet) {
        PgElementSet geom = (PgElementSet)m_elementSet.clone();
        if (geom.getDimOfElements() != 3) {
            PgElementSet.triangulate((PgElementSet)geom);
        }
        if (!geom.checkNeighbour(false)) {
            geom.makeNeighbour();
        }
        geom.removeUnusedVertices();
        int numEdges = geom.getNumEdges();
        PdVector[] newVertices = new PdVector[numEdges];
        PiVector[] neighbours = geom.getNeighbours();
        PiVector[] elements = geom.getElements();
        int nov = geom.getNumVertices();
        int noe = geom.getNumElements();
        int ind = 0;
        int i = noe - 1;
        while (i >= 0) {
            int j = 0;
            while (j < 3) {
                if (neighbours[i].m_data[j] < i) {
                    newVertices[ind] = neighbours[i].m_data[j] != -1 ? PdVector.blendNew((double)0.375, (PdVector)geom.getVertex(elements[i].m_data[(j + 1) % 3]), (double)0.375, (PdVector)geom.getVertex(elements[i].m_data[(j + 2) % 3]), (double)0.125, (PdVector)geom.getVertex(elements[i].m_data[j]), (double)0.125, (PdVector)geom.getVertex(elements[neighbours[i].m_data[j]].m_data[geom.getOppVertexLocInd(i, j)])) : PdVector.blendNew((double)0.5, (PdVector)geom.getVertex(elements[i].m_data[(j + 1) % 3]), (double)0.5, (PdVector)geom.getVertex(elements[i].m_data[(j + 2) % 3]));
                    ++ind;
                }
                ++j;
            }
            --i;
        }
        PgVertexStar vs = new PgVertexStar();
        PdVector[] oldVertices = new PdVector[nov];
        boolean[] vertexComputed = new boolean[nov];
        int elIndex = 0;
        while (elIndex < noe) {
            int elSize = elements[elIndex].getSize();
            int ee = 0;
            while (ee < elSize) {
                int i2 = elements[elIndex].m_data[ee];
                if (!vertexComputed[i2]) {
                    vertexComputed[i2] = true;
                    vs.makeVertexStar(geom, i2, elIndex);
                    PiVector link = vs.getLink();
                    int linkSize = vs.getSize();
                    oldVertices[i2] = (PdVector)geom.getVertex(i2).clone();
                    if (vs.isClosed()) {
                        double beta = -PuMath.sqr((double)(0.375 + 0.25 * Math.cos(Math.PI * 2 / (double)linkSize))) + 0.625;
                        oldVertices[i2].multScalar(1.0 - beta);
                        beta /= (double)linkSize;
                        int j = 0;
                        while (j < linkSize) {
                            oldVertices[i2].blendBase(oldVertices[i2], beta, geom.getVertex(link.m_data[j]));
                            ++j;
                        }
                    } else {
                        boolean isBndEnd = false;
                        if (geom.hasBoundary()) {
                            PgBndPolygon[] bndList = geom.getBoundaries();
                            int numBnd = bndList.length;
                            int j = 0;
                            while (j < numBnd) {
                                PiVector vertInd = bndList[j].getVertexInd();
                                int bndSize = bndList[j].getNumVertices();
                                if (vertInd.m_data[0] == i2 || vertInd.m_data[bndSize - 1] == i2) {
                                    isBndEnd = true;
                                }
                                ++j;
                            }
                        }
                        if (!isBndEnd) {
                            oldVertices[i2].blend(0.75, oldVertices[i2], 0.125, geom.getVertex(link.m_data[0]), 0.125, geom.getVertex(link.m_data[linkSize]));
                        }
                    }
                }
                ++ee;
            }
            ++elIndex;
        }
        m_elementSet.setVertices(oldVertices);
    }

    public static void quadrisectionEuclidean(PgElementSet geom, boolean bInsertMidPoints) {
        if (!geom.checkNeighbour(false)) {
            geom.makeNeighbour();
        }
        int noe = geom.getNumElements();
        int nov = geom.getNumVertices();
        int[] startEl = new int[noe];
        int newNoe = 0;
        PiVector[] element = geom.getElements();
        PiVector[] neighbour = geom.getNeighbours();
        int newNov = nov + noe + geom.getNumEdges();
        geom.setNumVertices(newNov);
        int i = 0;
        while (i < noe) {
            int elSize = element[i].getSize();
            startEl[i] = newNoe;
            newNoe += elSize;
            if (bInsertMidPoints) {
                geom.setVertex(nov + i, PgGeometry.getCenterOfElement(null, (PdVector[])geom.getVertices(), (int[])element[i].m_data));
            }
            if (geom.hasVertexColors()) {
                Color col = PdColor.blend((double)(1.0 / (double)elSize), (Color)geom.getVertexColor(element[i].m_data[0]), (double)(1.0 / (double)elSize), (Color)geom.getVertexColor(element[i].m_data[1]));
                int j = 2;
                while (j < elSize) {
                    col = PdColor.blend((double)1.0, (Color)col, (double)(1.0 / (double)elSize), (Color)geom.getVertexColor(element[i].m_data[j]));
                    ++j;
                }
                geom.setVertexColor(nov + i, col);
            }
            if (geom.hasVertexTextures()) {
                PdVector[] tex = geom.getVertexTextures();
                PdVector newTex = PdVector.copyNew((PdVector)tex[element[i].m_data[0]]);
                int j = 1;
                while (j < elSize) {
                    newTex.add(tex[element[i].m_data[j]]);
                    ++j;
                }
                newTex.multScalar(1.0 / (double)elSize);
                tex[nov + i] = newTex;
            }
            if (geom.getNumVectorFields() > 0) {
                int numVF = geom.getNumVectorFields();
                int j = 0;
                while (j < numVF) {
                    PgVectorField vf = geom.getVectorField(j);
                    if (vf.getBasedOn() == 0) {
                        vf.setNumVectors(nov + i + 1);
                        PdVector newVec = PdVector.copyNew((PdVector)vf.getVector(element[i].m_data[0]));
                        int k = 1;
                        while (k < elSize) {
                            newVec.add(vf.getVector(element[i].m_data[k]));
                            ++k;
                        }
                        newVec.multScalar(1.0 / (double)elSize);
                        vf.setVector(nov + i, newVec);
                    }
                    ++j;
                }
            }
            ++i;
        }
        PiVector[] newElement = new PiVector[newNoe];
        PiVector[] newNeighbour = new PiVector[newNoe];
        PdVector[][] newElTextures = new PdVector[][]{};
        int nextVertexInd = noe + nov;
        if (geom.hasBoundary()) {
            PgBndPolygon[] bndList = geom.getBoundaries();
            int numBnd = bndList.length;
            int i2 = 0;
            while (i2 < numBnd) {
                int bndSize = bndList[i2].getNumVertices();
                bndList[i2].setNumVertices(2 * bndSize - 1);
                PiVector vertexInd = bndList[i2].getVertexInd();
                int j = bndSize;
                while (j > 0) {
                    vertexInd.m_data[2 * j - 2] = vertexInd.m_data[j - 1];
                    --j;
                }
                ++i2;
            }
        }
        if (geom.hasElementTextures()) {
            newElTextures = new PdVector[newNoe][];
        }
        int i3 = 0;
        while (i3 < noe) {
            int elSize = element[i3].getSize();
            int j = 0;
            while (j < elSize) {
                int index = startEl[i3] + j;
                newElement[index] = new PiVector(4);
                newNeighbour[index] = new PiVector(4);
                newElement[index].m_data[0] = i3 + nov;
                newElement[index].m_data[2] = element[i3].m_data[j];
                newNeighbour[index].m_data[2] = startEl[i3] + (j + 1) % elSize;
                newNeighbour[index].m_data[3] = startEl[i3] + (j + elSize - 1) % elSize;
                ++j;
            }
            j = 0;
            while (j < elSize) {
                if (neighbour[i3].m_data[j] < i3) {
                    if (bInsertMidPoints) {
                        geom.setVertex(nextVertexInd, PdVector.blendNew((double)0.5, (PdVector)geom.getVertex(element[i3].m_data[(j + 1) % elSize]), (double)0.5, (PdVector)geom.getVertex(element[i3].m_data[(j + 2) % elSize])));
                    }
                    if (geom.hasVertexColors()) {
                        Color col = PdColor.blend((double)0.5, (Color)geom.getVertexColor(element[i3].m_data[(j + 1) % elSize]), (double)0.5, (Color)geom.getVertexColor(element[i3].m_data[(j + 2) % elSize]));
                        geom.setVertexColor(nextVertexInd, col);
                    }
                    if (geom.hasVertexTextures()) {
                        PdVector[] tex = geom.getVertexTextures();
                        tex[nextVertexInd] = PdVector.blendNew((double)0.5, (PdVector)tex[element[i3].m_data[(j + 1) % elSize]], (double)0.5, (PdVector)tex[element[i3].m_data[(j + 2) % elSize]]);
                    }
                    if (geom.getNumVectorFields() > 0) {
                        int numVF = geom.getNumVectorFields();
                        int k = 0;
                        while (k < numVF) {
                            PgVectorField vf = geom.getVectorField(k);
                            if (vf.getBasedOn() == 0) {
                                vf.setNumVectors(nextVertexInd + 1);
                                vf.setVector(nextVertexInd, PdVector.blendNew((double)0.5, (PdVector)vf.getVector(element[i3].m_data[(j + 1) % elSize]), (double)0.5, (PdVector)vf.getVector(element[i3].m_data[(j + 2) % elSize])));
                            }
                            ++k;
                        }
                    }
                    newElement[startEl[i3] + (j + 1) % elSize].m_data[3] = nextVertexInd;
                    newElement[startEl[i3] + (j + 2) % elSize].m_data[1] = nextVertexInd;
                    if (neighbour[i3].m_data[j] == -1) {
                        newNeighbour[startEl[i3] + (j + 1) % elSize].m_data[1] = -1;
                        newNeighbour[startEl[i3] + (j + 2) % elSize].m_data[0] = -1;
                        if (geom.hasBoundary()) {
                            PgBndPolygon[] bndList = geom.getBoundaries();
                            int numBnd = bndList.length;
                            int k = 0;
                            while (k < numBnd) {
                                int oldBndSize = bndList[k].getNumVertices() / 2;
                                PiVector vertexInd = bndList[k].getVertexInd();
                                int m = 0;
                                while (m < oldBndSize) {
                                    if (vertexInd.m_data[2 * m] == element[i3].m_data[(j + 1) % elSize] && vertexInd.m_data[2 * m + 2] == element[i3].m_data[(j + 2) % elSize] || vertexInd.m_data[2 * m] == element[i3].m_data[(j + 2) % elSize] && vertexInd.m_data[2 * m + 2] == element[i3].m_data[(j + 1) % elSize]) {
                                        vertexInd.m_data[2 * m + 1] = nextVertexInd;
                                    }
                                    ++m;
                                }
                                ++k;
                            }
                        }
                    } else {
                        int nn = neighbour[i3].m_data[j];
                        int neighSize = element[nn].getSize();
                        int oppLocInd = geom.getOppVertexLocInd(i3, j);
                        int ind0 = (oppLocInd + 1) % neighSize;
                        int ind1 = (oppLocInd + 2) % neighSize;
                        newElement[startEl[nn] + ind0].m_data[3] = nextVertexInd;
                        newElement[startEl[nn] + ind1].m_data[1] = nextVertexInd;
                        if (element[i3].m_data[(j + 1) % elSize] == element[nn].m_data[ind1]) {
                            newNeighbour[startEl[i3] + (j + 1) % elSize].m_data[1] = startEl[nn] + ind1;
                            newNeighbour[startEl[nn] + ind1].m_data[0] = startEl[i3] + (j + 1) % elSize;
                            newNeighbour[startEl[i3] + (j + 2) % elSize].m_data[0] = startEl[nn] + ind0;
                            newNeighbour[startEl[nn] + ind0].m_data[1] = startEl[i3] + (j + 2) % elSize;
                        } else {
                            newNeighbour[startEl[i3] + (j + 1) % elSize].m_data[1] = startEl[nn] + ind0;
                            newNeighbour[startEl[nn] + ind0].m_data[1] = startEl[i3] + (j + 1) % elSize;
                            newNeighbour[startEl[i3] + (j + 2) % elSize].m_data[0] = startEl[nn] + ind1;
                            newNeighbour[startEl[nn] + ind1].m_data[0] = startEl[i3] + (j + 2) % elSize;
                        }
                    }
                    ++nextVertexInd;
                }
                ++j;
            }
            if (geom.hasElementTextures()) {
                PdVector[] tex = geom.getElementTexture(i3);
                PdVector midTex = PdVector.copyNew((PdVector)tex[0]);
                int j2 = 1;
                while (j2 < elSize) {
                    midTex.add(tex[j2]);
                    ++j2;
                }
                midTex.multScalar(1.0 / (double)elSize);
                j2 = 0;
                while (j2 < elSize) {
                    newElTextures[startEl[i3] + j2] = new PdVector[4];
                    ++j2;
                }
                j2 = 0;
                while (j2 < elSize) {
                    newElTextures[startEl[i3] + j2][0] = PdVector.copyNew((PdVector)midTex);
                    newElTextures[startEl[i3] + j2][2] = PdVector.copyNew((PdVector)tex[j2]);
                    PdVector edgeTex = PdVector.blendNew((double)0.5, (PdVector)tex[j2], (double)0.5, (PdVector)tex[(j2 + 1) % elSize]);
                    newElTextures[startEl[i3] + j2][3] = PdVector.copyNew((PdVector)edgeTex);
                    newElTextures[startEl[i3] + (j2 + 1) % elSize][1] = PdVector.copyNew((PdVector)edgeTex);
                    ++j2;
                }
            }
            ++i3;
        }
        geom.setNumElements(newNoe);
        if (geom.hasElementColors()) {
            i3 = noe - 1;
            while (i3 >= 0) {
                int elSize = geom.getDimOfElement(i3);
                int j = 0;
                while (j < elSize) {
                    geom.setElementColor(startEl[i3] + elSize - 1 - j, new Color(geom.getElementColor(i3).getRGB()));
                    ++j;
                }
                --i3;
            }
        }
        if (geom.hasElementBackColors()) {
            i3 = noe - 1;
            while (i3 >= 0) {
                int elSize = geom.getDimOfElement(i3);
                int j = 0;
                while (j < elSize) {
                    geom.setElementBackColor(startEl[i3] + elSize - 1 - j, new Color(geom.getElementBackColor(i3).getRGB()));
                    ++j;
                }
                --i3;
            }
        }
        if (geom.getNumVectorFields() > 0) {
            int numVF = geom.getNumVectorFields();
            int k = 0;
            while (k < numVF) {
                PgVectorField vf = geom.getVectorField(k);
                if (vf.getBasedOn() == 1) {
                    vf.setNumVectors(newNoe);
                    int i4 = noe - 1;
                    while (i4 >= 0) {
                        int elSize = geom.getElement(i4).getSize();
                        int j = 0;
                        while (j < elSize) {
                            vf.setVector(startEl[i4] + elSize - 1 - j, PdVector.copyNew((PdVector)vf.getVector(i4)));
                            ++j;
                        }
                        --i4;
                    }
                }
                ++k;
            }
        }
        geom.setDimOfElements(4);
        geom.setElements(newElement);
        geom.setNeighbours(newNeighbour);
        if (geom.hasBoundary()) {
            PgBndPolygon[] bndList = geom.getBoundaries();
            int numBnd = bndList.length;
            int i5 = 0;
            while (i5 < numBnd) {
                if (!bndList[i5].makeElementInd()) {
                    geom.removeBoundaries();
                    break;
                }
                ++i5;
            }
        }
        if (geom.hasElementTextures()) {
            geom.setElementTextures((PdVector[][])newElTextures);
        }
        if (geom.isEnabledEdges()) {
            geom.makeEdgeStars();
        }
        geom.makeVertexNormals();
        geom.makeElementNormals();
    }

    public static void smoothingCC(PgElementSet elementSet) {
        PgElementSet rgeom = (PgElementSet)elementSet.clone();
        PgElementSet sgeom = elementSet;
        if (!rgeom.checkNeighbour(false)) {
            rgeom.makeNeighbour();
            rgeom.removeUnusedVertices();
        }
        PiVector[] element = rgeom.getElements();
        PiVector[] neighbour = rgeom.getNeighbours();
        int nov = rgeom.getNumVertices();
        int noe = rgeom.getNumElements();
        int newNov = nov + noe + rgeom.getNumEdges();
        PdVector[] m_newVertices = new PdVector[newNov];
        int i = 0;
        while (i < noe) {
            m_newVertices[i + nov] = PgGeometry.getCenterOfElement(null, (PdVector[])rgeom.getVertices(), (int[])element[i].m_data);
            ++i;
        }
        int nextVertexInd = noe + nov;
        int i2 = 0;
        while (i2 < noe) {
            int elSize = element[i2].getSize();
            int j = 0;
            while (j < elSize) {
                int neigh = neighbour[i2].m_data[j];
                if (neigh < i2) {
                    PdVector v1 = rgeom.getVertex(element[i2].m_data[(j + 1) % elSize]);
                    PdVector v2 = rgeom.getVertex(element[i2].m_data[(j + 2) % elSize]);
                    m_newVertices[nextVertexInd] = neigh > -1 ? PdVector.blendNew((double)0.25, (PdVector)v1, (double)0.25, (PdVector)v2, (double)0.25, (PdVector)m_newVertices[nov + i2], (double)0.25, (PdVector)m_newVertices[nov + neigh]) : PdVector.blendNew((double)0.5, (PdVector)v1, (double)0.5, (PdVector)v2);
                    ++nextVertexInd;
                }
                ++j;
            }
            ++i2;
        }
        PwRefineElementSet.quadrisection((PgElementSet)rgeom, (boolean)false);
        element = rgeom.getElements();
        PgVertexStar vertexStar = new PgVertexStar();
        boolean[] m_isBndEndPoint = new boolean[nov];
        if (rgeom.hasBoundary()) {
            PgBndPolygon[] bndList = rgeom.getBoundaries();
            int numBnd = bndList.length;
            int i3 = 0;
            while (i3 < numBnd) {
                int bndSize = bndList[i3].getNumVertices();
                PiVector vertInd = bndList[i3].getVertexInd();
                m_isBndEndPoint[vertInd.m_data[0]] = true;
                m_isBndEndPoint[vertInd.m_data[bndSize - 1]] = true;
                ++i3;
            }
        }
        PiVector anElementIndex = PgVertexStar.getElementPerVertex((PgElementSet)rgeom);
        PdVector[] oldVertices = sgeom.getVertices();
        PdVector tmp = new PdVector(3);
        int i4 = 0;
        while (i4 < nov) {
            PdVector dir;
            vertexStar.makeVertexStar(rgeom, i4, anElementIndex.m_data[i4]);
            PiVector vertexInd = vertexStar.getLink();
            m_newVertices[i4] = rgeom.getVertex(i4);
            int vsSize = vertexStar.getSize();
            if (vertexStar.isClosed()) {
                double beta = 1.0 / (double)vsSize;
                double gamma = 1.0 / (double)vsSize;
                PiVector elementInd = vertexStar.getElement();
                PiVector locInd = vertexStar.getVertexLocInd();
                tmp.copy(oldVertices[i4]);
                tmp.multScalar(1.0 - beta - gamma);
                PdVector vNormal = elementSet.getVertexNormal(i4);
                int j = 0;
                while (j < vsSize) {
                    tmp.blend(1.0, tmp, gamma / (double)vsSize, m_newVertices[element[elementInd.m_data[j]].m_data[(locInd.m_data[j] + 2) % 4]], beta / (double)vsSize, m_newVertices[vertexInd.m_data[j]]);
                    ++j;
                }
                dir = PdVector.subNew((PdVector)tmp, (PdVector)oldVertices[i4]);
                if (m_bTangential) {
                    PuVectorGeom.projectOntoPlane((PdVector)dir, (PdVector)vNormal);
                }
                if (!oldVertices[i4].hasTag(1)) {
                    oldVertices[i4].add(dir);
                }
            } else if (!m_isBndEndPoint[i4]) {
                tmp = new PdVector();
                tmp.blend(0.5, oldVertices[i4], 0.25, m_newVertices[vertexInd.m_data[0]], 0.25, m_newVertices[vertexInd.m_data[vsSize]]);
                dir = PdVector.subNew((PdVector)tmp, (PdVector)oldVertices[i4]);
                PdVector vNormal = elementSet.getVertexNormal(i4);
                if (m_bTangential) {
                    PuVectorGeom.projectOntoPlane((PdVector)dir, (PdVector)vNormal);
                }
                if (!oldVertices[i4].hasTag(1)) {
                    oldVertices[i4].add(dir);
                }
            }
            ++i4;
        }
        elementSet.makeVertexNormals();
        elementSet.makeElementNormals();
    }

    public void quadrisection() {
        PwCatmullClarkSmoothing.quadrisectionEuclidean(this.m_elementSet, true);
        this.update(this.m_elementSet);
    }

    public void startSmoothing() {
        if (!this.m_bStopped || this.m_bRunning) {
            return;
        }
        this.m_bRunning = true;
        this.m_thread = new Thread((Runnable)this, "JavaView: Smooth Surface");
        this.m_thread.setPriority(5);
        this.m_thread.start();
        PsDebug.notify((String)"Thread started");
    }

    public void stopSmoothing() {
        if (this.m_bRunning) {
            this.m_bRunning = false;
            this.m_thread = null;
            this.updatePanels(this);
            PsDebug.notify((String)"Thread stopped");
        }
    }

    public void setTangentialSmooth(boolean state) {
        m_bTangential = state;
    }

    public void oneStep() {
        int frame = 0;
        while (frame < this.m_frame.getValue()) {
            this.smoothCC();
            ++frame;
        }
        this.update(this.m_elementSet);
    }

    @Override
    public void run() {
        this.m_bStopped = false;
        int frame = 0;
        while (this.m_thread != null && this.m_bRunning) {
            this.smoothCC();
            if (frame > this.m_frame.getValue()) {
                this.update(this.m_elementSet);
                frame = 0;
                continue;
            }
            ++frame;
        }
        this.m_bStopped = true;
    }
}

