/*
 * Decompiled with CFR 0.152.
 */
package devRegularMap.smoothing;

import jv.geom.PgPolygonSet;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;
import jvx.geom.PgFrame;

public class PuPolygonSmoothing {
    public static void makeLinkAtNodes(PgPolygonSet m_polySet, PiVector[] m_linkVert, PiVector[] neighbor) {
        PiVector[] polygon = m_polySet.getPolygons();
        int nop = m_polySet.getNumPolygons();
        int nov = m_polySet.getNumVertices();
        PiVector valence = new PiVector(nov);
        PiVector nodeIndex = new PiVector(nov);
        nodeIndex.setConstant(-1);
        int numNodes = 0;
        int i = 0;
        while (i < nop) {
            PiVector poly = polygon[i];
            int polySize = poly.getSize();
            int j = 0;
            while (j < polySize - 1) {
                int n = poly.m_data[j];
                valence.m_data[n] = valence.m_data[n] + 1;
                if (valence.m_data[poly.m_data[j]] == 3) {
                    nodeIndex.m_data[poly.m_data[j]] = numNodes++;
                }
                int n2 = poly.m_data[j + 1];
                valence.m_data[n2] = valence.m_data[n2] + 1;
                if (valence.m_data[poly.m_data[j + 1]] == 3) {
                    nodeIndex.m_data[poly.m_data[j + 1]] = numNodes++;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < nov) {
            if (nodeIndex.m_data[i] != -1) {
                m_linkVert[nodeIndex.m_data[i]] = new PiVector(valence.m_data[i]);
            }
            ++i;
        }
        boolean[] checked = new boolean[nov];
        int index = 0;
        int i2 = 0;
        while (i2 < nop) {
            int s = polygon[i2].m_data[0];
            if (!checked[s]) {
                m_linkVert[index].m_data[0] = polygon[i2].m_data[1];
                int r = 1;
                int t = i2;
                while (r < valence.m_data[s]) {
                    t = neighbor[t].m_data[0];
                    m_linkVert[index].m_data[r] = polygon[t].m_data[1];
                    ++r;
                }
                ++index;
                checked[s] = true;
            }
            ++i2;
        }
    }

    public static void makeNormals(PgPolygonSet m_polySet, PiVector[] neighbor, boolean preTwist) {
        PiVector[] polygon = m_polySet.getPolygons();
        PdVector[] vertex = m_polySet.getVertices();
        int nop = m_polySet.getNumPolygons();
        int nov = m_polySet.getNumVertices();
        boolean[] checked = new boolean[nov];
        int polSize = polygon[0].getSize();
        int i = 0;
        while (i < nop) {
            PdVector normal;
            PiVector pol = polygon[i];
            PiVector nPol = polygon[neighbor[i].m_data[1]];
            int n = pol.m_data[0];
            if (!checked[n]) {
                normal = PuPolygonSmoothing.makeNormalAtJunction(polygon, vertex, neighbor, i);
                m_polySet.setVertexNormal(n, normal);
                checked[n] = true;
            }
            if (!checked[n = nPol.m_data[0]]) {
                normal = PuPolygonSmoothing.makeNormalAtJunction(polygon, vertex, neighbor, neighbor[i].m_data[1]);
                m_polySet.setVertexNormal(n, normal);
                checked[n] = true;
            }
            PdVector ns = m_polySet.getVertexNormal(pol.m_data[0]);
            PdVector ne = m_polySet.getVertexNormal(nPol.m_data[0]);
            PdVector newEdge = PdVector.subNew((PdVector)vertex[pol.getEntry(1)], (PdVector)vertex[pol.getEntry(0)]);
            PgFrame prevFrame = new PgFrame(3);
            PgFrame nextFrame = new PgFrame(3);
            prevFrame.e1.copy(newEdge);
            prevFrame.e1.normalize();
            PdVector cn = PdVector.crossNew((PdVector)newEdge, (PdVector)ns);
            PdVector bnS = PdVector.crossNew((PdVector)cn, (PdVector)newEdge);
            prevFrame.e2.copy(bnS);
            prevFrame.e2.normalize();
            prevFrame.e3.cross(prevFrame.e1, prevFrame.e2);
            prevFrame.base.copy(vertex[pol.m_data[0]]);
            PgFrame[] frame = new PgFrame[2 * polSize - 1];
            PiVector merge = new PiVector(2 * polSize - 1);
            int j = 0;
            while (j < polSize) {
                merge.m_data[j] = pol.m_data[j];
                ++j;
            }
            j = 0;
            while (j < polSize - 1) {
                merge.m_data[polSize + j] = nPol.m_data[polSize - 2 - j];
                ++j;
            }
            frame[0] = (PgFrame)prevFrame.clone();
            j = 1;
            while (j < 2 * polSize - 2) {
                newEdge.sub(vertex[merge.m_data[j + 1]], vertex[merge.m_data[j]]);
                frame[j] = new PgFrame(3);
                nextFrame.parallelTranslate(prevFrame, frame[j], vertex[merge.m_data[j]], newEdge);
                prevFrame = (PgFrame)nextFrame.clone();
                ++j;
            }
            prevFrame.base.copy(vertex[merge.m_data[2 * polSize - 2]]);
            frame[2 * polSize - 2] = (PgFrame)prevFrame.clone();
            PdVector pne = new PdVector(3);
            PuVectorGeom.projectOntoPlane((PdVector)pne, (PdVector)ne, (PdVector)frame[2 * polSize - 2].e1);
            double alpha = PdVector.angleWithOrientation((PdVector)frame[2 * polSize - 2].e2, (PdVector)pne, (PdVector)frame[2 * polSize - 2].e1);
            if (preTwist) {
                alpha = Math.PI * 2 - Math.abs(alpha);
            }
            int j2 = 1;
            while (j2 < 2 * polSize - 2) {
                double t = (double)j2 / (double)(2 * polSize - 2);
                PdVector normalAti = new PdVector(3);
                PuVectorGeom.rotatePointAroundVector((PdVector)normalAti, (PdVector)frame[j2].e2, (PdVector)frame[j2].e1, (double)(t * alpha));
                normalAti.normalize();
                m_polySet.setVertexNormal(merge.getEntry(j2), normalAti);
                ++j2;
            }
            ++i;
        }
    }

    public static PdVector makeNormalAtJunction(PiVector[] polygon, PdVector[] vertex, PiVector[] neighbor, int index) {
        PdVector normal = new PdVector(3);
        int start = neighbor[index].m_data[0];
        int valence = 0;
        boolean found = false;
        int nb = start;
        PiVector link = new PiVector();
        link.addEntry(polygon[start].m_data[1]);
        while (!found) {
            nb = neighbor[nb].m_data[0];
            if (nb == start) {
                found = true;
                continue;
            }
            link.addEntry(polygon[nb].m_data[1]);
        }
        valence = link.getSize();
        PdVector node = vertex[polygon[index].m_data[0]];
        int i = 0;
        while (i < valence) {
            PdVector edge1 = PdVector.subNew((PdVector)vertex[link.m_data[i]], (PdVector)node);
            PdVector edge2 = PdVector.subNew((PdVector)vertex[link.m_data[(i + 1) % valence]], (PdVector)node);
            normal.add(PdVector.crossNew((PdVector)edge1, (PdVector)edge2));
            ++i;
        }
        normal.multScalar(1.0 / (double)valence);
        normal.normalize();
        return normal;
    }
}

