/*
 * Decompiled with CFR 0.152.
 */
package devRegularMap.number;

import devRegularMap.vecmath.PuHyperboloid;
import jv.vecmath.PdVector;

public class PgyroMoebVector {
    private static int m_c = 1;
    public PdVector m_vec;
    public double[] m_data;

    public PgyroMoebVector(int dim) {
        this.m_vec = new PdVector(dim);
        this.m_data = new double[3];
        this.m_vec.m_data = this.m_data;
    }

    public PgyroMoebVector(double a, double b, double c) {
        this.m_data = new double[]{a, b, c};
        this.m_vec = new PdVector(3);
        this.m_vec.m_data = this.m_data;
    }

    public PgyroMoebVector(PdVector u) {
        this.m_vec = new PdVector(3);
        this.m_vec.copy(u);
        this.m_data = this.m_vec.m_data;
    }

    public PdVector getVector() {
        return this.m_vec;
    }

    public static void setConstant(int c) {
        m_c = c;
    }

    public static double getGamma(PdVector v) {
        return 1.0 / Math.sqrt(1.0 - v.sqrLength() / (double)(m_c * m_c));
    }

    public double getGamma() {
        PgyroMoebVector v = this;
        PdVector pv = v.m_vec;
        return PgyroMoebVector.getGamma(pv);
    }

    public void addLeft(PgyroMoebVector v) {
        PgyroMoebVector u = this;
        PdVector pdv = v.m_vec;
        PdVector pdu = u.m_vec;
        double dot = PdVector.dot((PdVector)pdu, (PdVector)pdv);
        double a = 1.0 + 2.0 / (double)(m_c * m_c) * dot + pdv.sqrLength() / (double)(m_c * m_c);
        double b = 1.0 - 1.0 / (double)(m_c * m_c) * pdu.sqrLength();
        double c = 1.0 + 2.0 / (double)(m_c * m_c) * dot + (double)(1 / (m_c * m_c * m_c * m_c)) * pdu.sqrLength() * pdv.sqrLength();
        pdu.blend(a, pdu, b, pdv);
        pdu.multScalar(c);
    }

    public void addLeft(PgyroMoebVector u, PgyroMoebVector v) {
        this.copy(u);
        this.addLeft(v);
    }

    public static PgyroMoebVector addLeftNew(PgyroMoebVector u, PgyroMoebVector v) {
        PgyroMoebVector sum = new PgyroMoebVector(u.m_vec);
        PdVector pdv = v.m_vec;
        PdVector pdu = u.m_vec;
        double dot = PdVector.dot((PdVector)pdu, (PdVector)pdv);
        double a = 1.0 + 2.0 / (double)(m_c * m_c) * dot + pdv.sqrLength() / (double)(m_c * m_c);
        double b = 1.0 - 1.0 / (double)(m_c * m_c) * pdu.sqrLength();
        double c = 1.0 + 2.0 / (double)(m_c * m_c) * dot + (double)(1 / (m_c * m_c * m_c * m_c)) * pdu.sqrLength() * pdv.sqrLength();
        sum.m_vec.blend(a, pdu, b, pdv);
        sum.m_vec.multScalar(c);
        return sum;
    }

    public static PgyroMoebVector subLeftNew(PgyroMoebVector u, PgyroMoebVector v) {
        PgyroMoebVector umin = u.minusNew();
        return PgyroMoebVector.addLeftNew(umin, v);
    }

    public void addMult(double a, PgyroMoebVector u) {
        PgyroMoebVector v = new PgyroMoebVector(3);
        v.addLeft(u);
        v.multScalar(a);
        this.addLeft(v);
    }

    public static PgyroMoebVector blend(double a, PgyroMoebVector u, double b, PgyroMoebVector v, double c, PgyroMoebVector w) {
        PgyroMoebVector res = new PgyroMoebVector(3);
        res.addMult(a, u);
        res.addMult(b, v);
        res.addMult(c, w);
        return res;
    }

    public void subLeft(PgyroMoebVector v) {
        PgyroMoebVector u = this;
        PdVector pdv = v.m_vec;
        pdv.multScalar(-1.0);
        u.addLeft(v);
    }

    public static PgyroMoebVector subLeft(PgyroMoebVector u, PgyroMoebVector v) {
        PgyroMoebVector sub = new PgyroMoebVector(3);
        sub.copy(u);
        sub.subLeft(v);
        return sub;
    }

    public void minus() {
        PdVector a = (PdVector)this.m_vec.clone();
        a.multScalar(-1.0);
        PgyroMoebVector zero = new PgyroMoebVector(3);
        PgyroMoebVector minu = new PgyroMoebVector(a);
        zero.addLeft(minu);
        this.copy(zero);
    }

    public PgyroMoebVector minusNew() {
        PgyroMoebVector v = new PgyroMoebVector(3);
        v.copy(this);
        v.m_vec.multScalar(-1.0);
        return v;
    }

    public void multScalar(double s) {
        double gamma_v = this.getGamma();
        double a = Math.sqrt(gamma_v * gamma_v - 1.0);
        if (a == 0.0) {
            return;
        }
        double b = gamma_v - a;
        double c = Math.pow(b, 2.0 * s);
        double res = (1.0 - c) / (1.0 + c) * gamma_v / a;
        this.m_vec.multScalar(res);
    }

    public static double distance(PgyroMoebVector u, PgyroMoebVector v) {
        PgyroMoebVector w = new PgyroMoebVector(3);
        w.copy(u);
        w.addLeft(w.minusNew(), v);
        return w.m_vec.length();
    }

    public void copy(PgyroMoebVector u) {
        this.m_vec.copy(u.m_vec);
    }

    public static PgyroMoebVector gyr(PgyroMoebVector u, PgyroMoebVector v, PgyroMoebVector w) {
        PgyroMoebVector uplusv = PgyroMoebVector.addLeftNew(u, v);
        PgyroMoebVector vplusw = PgyroMoebVector.addLeftNew(v, w);
        PgyroMoebVector uplusvw = PgyroMoebVector.addLeftNew(u, vplusw);
        return PgyroMoebVector.addLeftNew(uplusv.minusNew(), uplusvw);
    }

    public void coAdd(PgyroMoebVector v) {
        PgyroMoebVector u = this;
        this.copy(PgyroMoebVector.addLeftNew(u, PgyroMoebVector.gyr(u, v.minusNew(), v)));
    }

    public static PgyroMoebVector coAdd(PgyroMoebVector u, PgyroMoebVector v) {
        PdVector sum = PdVector.blendNew((double)u.getGamma(), (PdVector)u.m_vec, (double)v.getGamma(), (PdVector)v.m_vec);
        double gamma = u.getGamma() + v.getGamma();
        PgyroMoebVector dir = PgyroMoebVector.addLeftNew(u.minusNew(), v);
        double gamma_dir = dir.getGamma();
        double s = gamma - (gamma_dir + 1.0) / gamma;
        sum.multScalar(1.0 / s);
        return new PgyroMoebVector(sum);
    }

    public void coSub(PgyroMoebVector u) {
        PgyroMoebVector v = this;
        v.copy(PgyroMoebVector.subLeft(v, PgyroMoebVector.gyr(v, u, u)));
    }

    public static PgyroMoebVector coSub(PgyroMoebVector u, PgyroMoebVector v) {
        PgyroMoebVector sub = new PgyroMoebVector(u.m_vec);
        sub.coSub(v);
        return sub;
    }

    public void coAddMult(double a, PgyroMoebVector u) {
        PgyroMoebVector v = new PgyroMoebVector(u.m_vec);
        v.multScalar(a);
        this.coAdd(v);
    }

    public static PgyroMoebVector getMidPoint(PgyroMoebVector u, PgyroMoebVector v) {
        PgyroMoebVector coSum = PgyroMoebVector.coAdd(u, v);
        coSum.multScalar(0.5);
        return coSum;
    }

    public static PgyroMoebVector coBlend(double a, PgyroMoebVector u, double b, PgyroMoebVector v, double c, PgyroMoebVector w, double d, PgyroMoebVector x) {
        PgyroMoebVector res = new PgyroMoebVector(3);
        res.coAddMult(a, u);
        res.coAddMult(b, v);
        res.coAddMult(c, w);
        res.coAddMult(d, x);
        return res;
    }

    public static PgyroMoebVector coBlend(double a, PgyroMoebVector u, double b, PgyroMoebVector v) {
        PgyroMoebVector uScale = new PgyroMoebVector(u.m_vec);
        PgyroMoebVector vScale = new PgyroMoebVector(v.m_vec);
        uScale.multScalar(a);
        vScale.multScalar(b);
        return PgyroMoebVector.coAdd(uScale, vScale);
    }

    public void coBlend(double a, PgyroMoebVector u, double b, PgyroMoebVector v, double c, PgyroMoebVector w) {
        PgyroMoebVector res = new PgyroMoebVector(3);
        res.coAddMult(a, u);
        res.coAddMult(b, v);
        res.coAddMult(c, w);
    }

    public double length() {
        PdVector upoinc = (PdVector)this.m_vec.clone();
        this.EinsteinToHyperboloid(upoinc);
        double len = PuHyperboloid.dist(new PdVector(1.0, 0.0, 0.0), upoinc);
        return len;
    }

    public void EinsteinToHyperboloid(PdVector u) {
        int len = u.getSize();
        double alpha = 1.0 / (1.0 + Math.sqrt(1.0 - u.sqrLength()));
        u.multScalar(alpha);
        alpha = 1.0 / (1.0 - u.sqrLength());
        u.m_data[0] = 1.0 + u.sqrLength();
        int i = 1;
        while (i < len) {
            u.m_data[i] = 2.0 * u.m_data[i];
            ++i;
        }
        u.multScalar(alpha);
    }

    public double sqrLength() {
        return this.length() * this.length();
    }

    public void addRight(PgyroMoebVector v) {
        PgyroMoebVector u = this;
        PgyroMoebVector res = new PgyroMoebVector(v.m_vec);
        res.addLeft(u);
        u.copy(res);
    }

    public static PgyroMoebVector coAdd(PgyroMoebVector[] v) {
        int len = v.length;
        PdVector num = new PdVector(3);
        int i = 0;
        while (i < len) {
            num.add(v[i].getGamma(), v[i].m_vec);
            ++i;
        }
        double M = 2 - len;
        double N = 0.0;
        int j = 1;
        while (j < len) {
            N = N - (double)len + 3.0;
            ++j;
        }
        double gamma = 0.0;
        int i2 = 0;
        while (i2 < len) {
            gamma += v[i2].getGamma();
            ++i2;
        }
        double gamma_w = 0.0;
        int i3 = 0;
        while (i3 < len) {
            int j2 = i3 + 1;
            while (j2 < len) {
                PgyroMoebVector w = PgyroMoebVector.addLeftNew(v[i3].minusNew(), v[j2]);
                gamma_w += w.getGamma();
                ++j2;
            }
            ++i3;
        }
        double denum = gamma - (gamma_w + N) / (gamma + M);
        num.multScalar(1.0 / denum);
        PgyroMoebVector sum = new PgyroMoebVector(num);
        return sum;
    }

    public static PgyroMoebVector coAddPara(PgyroMoebVector base, PgyroMoebVector p1, PgyroMoebVector p2) {
        PgyroMoebVector sum = PgyroMoebVector.coAddNew(p1, p2);
        sum.subLeft(base);
        return sum;
    }

    public static PgyroMoebVector coAddNew(PgyroMoebVector p1, PgyroMoebVector p2) {
        PgyroMoebVector sum = new PgyroMoebVector(p1.m_vec);
        sum.coAdd(p2);
        return sum;
    }

    public void parallelTranslateFromTo(PgyroMoebVector base, PgyroMoebVector p1) {
        PgyroMoebVector v = this;
        v.copy(PgyroMoebVector.gyr(p1, base.minusNew(), v));
    }
}

