/*
 * Decompiled with CFR 0.152.
 */
package devRegularMap.number;

import jv.vecmath.PdVector;

public class PgyroEinVector {
    private static int m_c = 1;
    public PdVector m_vec;
    public double[] m_data;

    public PgyroEinVector(int dim) {
        this.m_vec = new PdVector(dim);
        this.m_data = new double[3];
        this.m_vec.m_data = this.m_data;
    }

    public PgyroEinVector(double a, double b, double c) {
        this.m_data = new double[]{a, b, c};
        this.m_vec = new PdVector(3);
        this.m_vec.m_data = this.m_data;
    }

    public PgyroEinVector(PdVector u) {
        this.m_vec = new PdVector(3);
        this.m_vec.copy(u);
        this.m_data = this.m_vec.m_data;
    }

    public PdVector getVector() {
        return this.m_vec;
    }

    public static void setConstant(int c) {
        m_c = c;
    }

    public static double getGamma(PdVector v) {
        return 1.0 / Math.sqrt(1.0 - v.sqrLength() / (double)(m_c * m_c));
    }

    public double getGamma() {
        PgyroEinVector v = this;
        PdVector pv = v.m_vec;
        return PgyroEinVector.getGamma(pv);
    }

    public void addLeft(PgyroEinVector v) {
        PgyroEinVector u = this;
        PdVector pdv = v.m_vec;
        PdVector pdu = u.m_vec;
        double gamma_u = u.getGamma();
        double dot = PdVector.dot((PdVector)pdu, (PdVector)pdv);
        double a = 1.0 / gamma_u;
        double b = 1.0 / (double)(m_c * m_c) * (gamma_u / (1.0 + gamma_u));
        double c = 1.0 / (1.0 + dot / (double)(m_c * m_c));
        pdu.blend(1.0, pdu, a, pdv, b * dot, pdu);
        pdu.multScalar(c);
    }

    public void addLeft(PgyroEinVector u, PgyroEinVector v) {
        this.copy(u);
        this.addLeft(v);
    }

    public static PgyroEinVector addLeftNew(PgyroEinVector u, PgyroEinVector v) {
        PgyroEinVector sum = new PgyroEinVector(u.m_vec);
        PdVector pdv = v.m_vec;
        PdVector pdu = u.m_vec;
        double gamma_u = u.getGamma();
        double dot = PdVector.dot((PdVector)pdu, (PdVector)pdv);
        double a = 1.0 / gamma_u;
        double b = 1.0 / (double)(m_c * m_c) * (gamma_u / (1.0 + gamma_u));
        double c = 1.0 / (1.0 + dot / (double)(m_c * m_c));
        sum.m_vec.blend(1.0, pdu, a, pdv, b * dot, pdu);
        sum.m_vec.multScalar(c);
        return sum;
    }

    public static PgyroEinVector subLeftNew(PgyroEinVector u, PgyroEinVector v) {
        PgyroEinVector umin = u.minusNew();
        return PgyroEinVector.addLeftNew(umin, v);
    }

    public void addMult(double a, PgyroEinVector u) {
        PgyroEinVector v = new PgyroEinVector(3);
        v.addLeft(u);
        v.multScalar(a);
        this.addLeft(v);
    }

    public static PgyroEinVector blend(double a, PgyroEinVector u, double b, PgyroEinVector v, double c, PgyroEinVector w) {
        PgyroEinVector res = new PgyroEinVector(3);
        res.addMult(a, u);
        res.addMult(b, v);
        res.addMult(c, w);
        return res;
    }

    public void subLeft(PgyroEinVector v) {
        PgyroEinVector u = this;
        PdVector pdv = v.m_vec;
        pdv.multScalar(-1.0);
        u.addLeft(v);
    }

    public static PgyroEinVector subLeft(PgyroEinVector u, PgyroEinVector v) {
        PgyroEinVector sub = new PgyroEinVector(3);
        sub.copy(u);
        sub.subLeft(v);
        return sub;
    }

    public void minus() {
        PdVector a = (PdVector)this.m_vec.clone();
        a.multScalar(-1.0);
        PgyroEinVector zero = new PgyroEinVector(3);
        PgyroEinVector minu = new PgyroEinVector(a);
        zero.addLeft(minu);
        this.copy(zero);
    }

    public PgyroEinVector minusNew() {
        PgyroEinVector v = new PgyroEinVector(3);
        v.copy(this);
        v.m_vec.multScalar(-1.0);
        return v;
    }

    public void multScalar(double s) {
        double gamma_v = this.getGamma();
        double a = Math.sqrt(gamma_v * gamma_v - 1.0);
        if (a == 0.0) {
            return;
        }
        double b = gamma_v - a;
        double c = Math.pow(b, 2.0 * s);
        double res = (1.0 - c) / (1.0 + c) * gamma_v / a;
        this.m_vec.multScalar(res);
    }

    public static double distance(PgyroEinVector u, PgyroEinVector v) {
        PgyroEinVector w = new PgyroEinVector(3);
        w.copy(u);
        w.addLeft(w.minusNew(), v);
        return w.m_vec.length();
    }

    public void copy(PgyroEinVector u) {
        this.m_vec.copy(u.m_vec);
    }

    public static PgyroEinVector gyr(PgyroEinVector u, PgyroEinVector v, PgyroEinVector w) {
        PgyroEinVector uplusv = PgyroEinVector.addLeftNew(u, v);
        PgyroEinVector vplusw = PgyroEinVector.addLeftNew(v, w);
        PgyroEinVector uplusvw = PgyroEinVector.addLeftNew(u, vplusw);
        return PgyroEinVector.addLeftNew(uplusv.minusNew(), uplusvw);
    }

    public void coAdd(PgyroEinVector v) {
        PgyroEinVector u = this;
        this.copy(PgyroEinVector.addLeftNew(u, PgyroEinVector.gyr(u, v.minusNew(), v)));
    }

    public static PgyroEinVector coAdd(PgyroEinVector u, PgyroEinVector v) {
        PdVector sum = PdVector.blendNew((double)u.getGamma(), (PdVector)u.m_vec, (double)v.getGamma(), (PdVector)v.m_vec);
        double gamma = u.getGamma() + v.getGamma();
        PgyroEinVector dir = PgyroEinVector.addLeftNew(u.minusNew(), v);
        double gamma_dir = dir.getGamma();
        double s = gamma - (gamma_dir + 1.0) / gamma;
        sum.multScalar(1.0 / s);
        return new PgyroEinVector(sum);
    }

    public void coSub(PgyroEinVector u) {
        PgyroEinVector v = this;
        v.copy(PgyroEinVector.subLeft(v, PgyroEinVector.gyr(v, u, u)));
    }

    public static PgyroEinVector coSub(PgyroEinVector u, PgyroEinVector v) {
        PgyroEinVector sub = new PgyroEinVector(u.m_vec);
        sub.coSub(v);
        return sub;
    }

    public void coAddMult(double a, PgyroEinVector u) {
        PgyroEinVector v = new PgyroEinVector(u.m_vec);
        v.multScalar(a);
        this.coAdd(v);
    }

    public static PgyroEinVector getMidPoint(PgyroEinVector u, PgyroEinVector v) {
        PgyroEinVector coSum = PgyroEinVector.coAdd(u, v);
        coSum.multScalar(0.5);
        return coSum;
    }

    public static PgyroEinVector coBlend(double a, PgyroEinVector u, double b, PgyroEinVector v, double c, PgyroEinVector w, double d, PgyroEinVector x) {
        PgyroEinVector res = new PgyroEinVector(3);
        res.coAddMult(a, u);
        res.coAddMult(b, v);
        res.coAddMult(c, w);
        res.coAddMult(d, x);
        return res;
    }

    public static PgyroEinVector coBlend(double a, PgyroEinVector u, double b, PgyroEinVector v) {
        PgyroEinVector uScale = new PgyroEinVector(u.m_vec);
        PgyroEinVector vScale = new PgyroEinVector(v.m_vec);
        uScale.multScalar(a);
        vScale.multScalar(b);
        return PgyroEinVector.coAdd(uScale, vScale);
    }

    public void coBlend(double a, PgyroEinVector u, double b, PgyroEinVector v, double c, PgyroEinVector w) {
        PgyroEinVector res = new PgyroEinVector(3);
        res.coAddMult(a, u);
        res.coAddMult(b, v);
        res.coAddMult(c, w);
    }

    public double length() {
        PdVector upoinc = (PdVector)this.m_vec.clone();
        double len = upoinc.length();
        return len;
    }

    public void EinsteinToHyperboloid(PdVector u) {
        int len = u.getSize();
        double alpha = 1.0 / (1.0 + Math.sqrt(1.0 - u.sqrLength()));
        u.multScalar(alpha);
        alpha = 1.0 / (1.0 - u.sqrLength());
        u.m_data[0] = 1.0 + u.sqrLength();
        int i = 1;
        while (i < len) {
            u.m_data[i] = 2.0 * u.m_data[i];
            ++i;
        }
        u.multScalar(alpha);
    }

    public double sqrLength() {
        return this.length() * this.length();
    }

    public void addRight(PgyroEinVector v) {
        PgyroEinVector u = this;
        PgyroEinVector res = new PgyroEinVector(v.m_vec);
        res.addLeft(u);
        u.copy(res);
    }

    public static PgyroEinVector coAdd(PgyroEinVector[] v) {
        int len = v.length;
        PdVector num = new PdVector(3);
        int i = 0;
        while (i < len) {
            num.add(v[i].getGamma(), v[i].m_vec);
            ++i;
        }
        double M = 2 - len;
        double N = 0.0;
        int j = 1;
        while (j < len) {
            N = N - (double)len + 3.0;
            ++j;
        }
        double gamma = 0.0;
        int i2 = 0;
        while (i2 < len) {
            gamma += v[i2].getGamma();
            ++i2;
        }
        double gamma_w = 0.0;
        int i3 = 0;
        while (i3 < len) {
            int j2 = i3 + 1;
            while (j2 < len) {
                PgyroEinVector w = PgyroEinVector.addLeftNew(v[i3].minusNew(), v[j2]);
                gamma_w += w.getGamma();
                ++j2;
            }
            ++i3;
        }
        double denum = gamma - (gamma_w + N) / (gamma + M);
        num.multScalar(1.0 / denum);
        PgyroEinVector sum = new PgyroEinVector(num);
        return sum;
    }

    public static PgyroEinVector coAddPara(PgyroEinVector base, PgyroEinVector p1, PgyroEinVector p2) {
        PgyroEinVector sum = PgyroEinVector.coAddNew(p1, p2);
        sum.subLeft(base);
        return sum;
    }

    public static PgyroEinVector coAddNew(PgyroEinVector p1, PgyroEinVector p2) {
        PgyroEinVector sum = new PgyroEinVector(p1.m_vec);
        sum.coAdd(p2);
        return sum;
    }

    public void parallelTranslateFromTo(PgyroEinVector base, PgyroEinVector p1) {
        PgyroEinVector v = this;
        v.copy(PgyroEinVector.gyr(p1, base.minusNew(), v));
    }
}

