/*
 * Decompiled with CFR 0.152.
 */
package devRegularMap.number;

import devRegularMap.functions.PuPlanarMaps;
import devRegularMap.grid.PwPutGrid;
import devRegularMap.vecmath.PuHyperboloid;
import devRegularMap.vecmath.PuIsometry;
import devRegularMap.vecmath.PuSpace;
import devRegularMap.vecmath.PuSubgroup;
import jv.geom.PgElementSet;
import jv.geom.PgPolygonSet;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgTile
extends PuPlanarMaps {
    protected String m_rep;
    protected static PdVector m_O;
    protected static PdVector m_N;
    protected static PdVector m_M;
    protected static PgElementSet m_elementSet;
    protected static PdMatrix m_SR;

    public PgTile(String rep) {
        this.m_rep = rep;
    }

    public static void init(PdVector M, PdVector N, PdVector O) {
        m_O = O;
        m_M = M;
        m_N = N;
    }

    public static void initParallelogram() {
        m_SR = PgTile.getParallelogram();
    }

    public static void makeLines(PgPolygonSet pol) {
        PdVector[] vertex = pol.getVertices();
        int newnov = m_eltH.length * m_coset.length;
        int newnop = m_coset.length * m_eltH.length;
        pol.setNumVertices(newnov);
        pol.setNumPolygons(newnop);
        PdMatrix trans = new PdMatrix(3);
        int indv = 0;
        int inde = 0;
        boolean[] checked = new boolean[newnop + 1];
        int index = -1;
        int i = 0;
        while (i < m_coset.length) {
            int j = 0;
            while (j < m_eltH.length) {
                String inv = PuIsometry.getInverseStringElt(m_coset[i], "rst");
                String mov = String.valueOf(inv) + m_eltH[j];
                index = PuSubgroup.getIndexOfEltInG(mov, m_rRsSt, "rst", true);
                if (!checked[index]) {
                    PdVector[] rotVertex = new PdVector[2];
                    trans = PuIsometry.getTrans(mov, m_rst, "rst");
                    int k = 0;
                    while (k < 2) {
                        rotVertex[k] = new PdVector(3);
                        PdVector vhomo = PdVector.copyNew((PdVector)vertex[k]);
                        trans.leftMultMatrix(rotVertex[k], vhomo);
                        ++k;
                    }
                    k = 0;
                    while (k < 2) {
                        pol.setVertex(indv, rotVertex[k]);
                        ++indv;
                        ++k;
                    }
                    PiVector tmp = PiVector.copyNew((PiVector)pol.getPolygon(0));
                    tmp.add(inde * 2);
                    pol.setPolygon(index, tmp);
                    pol.setPolygonSize(index, 1.0);
                    checked[index] = true;
                    ++inde;
                }
                ++j;
            }
            ++i;
        }
        PwPutGrid.refinePolygonSet(pol, 10);
    }

    private static void makeGrid(String rep, int index) {
        m_elementSet = new PgElementSet(3);
        m_elementSet.setNumVertices(3);
        m_elementSet.setNumElements(1);
        PdMatrix M = PuIsometry.getTrans(rep, m_rst, "rst");
        PdVector[] vertex = new PdVector[]{m_N, m_O, m_M};
        PdVector[] rotVertex = new PdVector[3];
        int i = 0;
        while (i < 3) {
            rotVertex[i] = new PdVector(3);
            M.leftMultMatrix(rotVertex[i], vertex[i]);
            ++i;
        }
        i = 0;
        while (i < 3) {
            m_elementSet.setVertex(i, rotVertex[i]);
            ++i;
        }
        m_elementSet.setElement(0, 0, 1, 2);
        m_elementSet.setElementColor(0, m_color[index]);
        m_elementSet.makeVertexNormals();
        if (PuSpace.SPACE == 0 || PuSpace.SPACE == 1) {
            PwPutGrid.refineGrid(m_elementSet);
        }
        if (PuSpace.SPACE == 0) {
            PdVector[] vGrid = m_elementSet.getVertices();
            int nov = m_elementSet.getNumVertices();
            int i2 = 0;
            while (i2 < nov) {
                vGrid[i2].m_data[2] = 0.0;
                vGrid[i2].leftMultMatrix(m_SR);
                double t = vGrid[i2].m_data[0];
                double s = vGrid[i2].m_data[1];
                vGrid[i2].m_data[0] = (2.0 + Math.cos(t)) * Math.cos(s);
                vGrid[i2].m_data[1] = (2.0 + Math.cos(t)) * Math.sin(s);
                vGrid[i2].m_data[2] = Math.sin(t);
                ++i2;
            }
        }
    }

    public static PgElementSet getGeometry(String rep, int index) {
        PgTile.makeGrid(rep, index);
        return m_elementSet;
    }

    public static boolean makeVertexNormals(PgElementSet[] tile) {
        int not = tile.length;
        int n = 7;
        int i = 0;
        while (i < not) {
            tile[i].makeVertexNormals();
            ++i;
        }
        PdVector edgeB = new PdVector(3);
        PdVector edgeC = new PdVector(3);
        int i2 = 0;
        while (i2 < not) {
            PdVector[][] vpos = new PdVector[2 * m_q][3];
            PiVector[] vind = new PiVector[2 * m_q];
            String rep = m_eltG[i2];
            PiVector nb = new PiVector(2 * m_q);
            int ind = -1;
            int m = 0;
            while (m < n) {
                int index;
                rep = m_eltG[i2];
                if (m == 0) {
                    int k;
                    int j = 0;
                    while (j < m_q) {
                        nb.m_data[j] = index = PuSubgroup.getIndexOfEltInG(String.valueOf(rep) + "t", m_rRsSt, "rst", true);
                        vind[j] = tile[index].getElement(0);
                        k = 0;
                        while (k < 3) {
                            vpos[j][k] = tile[index].getVertex(vind[j].m_data[k]);
                            ++k;
                        }
                        rep = String.valueOf(rep) + "s";
                        ++j;
                    }
                    rep = m_eltG[i2];
                    j = 0;
                    while (j < m_q) {
                        index = PuSubgroup.getIndexOfEltInG(String.valueOf(rep) + "s", m_rRsSt, "rst", true);
                        vind[j + PgTile.m_q] = tile[index].getElement(0);
                        nb.m_data[j + PgTile.m_q] = index;
                        k = 0;
                        while (k < 3) {
                            vpos[j + PgTile.m_q][k] = tile[index].getVertex(vind[j + PgTile.m_q].m_data[k]);
                            ++k;
                        }
                        rep = String.valueOf(rep) + "s";
                        ++j;
                    }
                    ind = 0;
                } else if (m > 0 && m < n - 1) {
                    vpos = new PdVector[4][4];
                    vind = new PiVector[4];
                    nb = new PiVector(1);
                    index = PuSubgroup.getIndexOfEltInG(String.valueOf(rep) + "St", m_rRsSt, "rst", true);
                    int a = m * n - m * (1 + m) / 2;
                    int b = (m - 1) * n - (m - 1) * m / 2;
                    vind[0] = tile[i2].getElement(a);
                    int k = 0;
                    while (k < vind[0].getSize()) {
                        vpos[0][k] = tile[i2].getVertex(vind[0].m_data[k]);
                        ++k;
                    }
                    vind[1] = tile[i2].getElement(b);
                    k = 0;
                    while (k < vind[1].getSize()) {
                        vpos[1][k] = tile[i2].getVertex(vind[1].m_data[k]);
                        ++k;
                    }
                    vind[2] = tile[index].getElement(a);
                    k = 0;
                    while (k < vind[2].getSize()) {
                        vpos[2][k] = tile[index].getVertex(vind[2].m_data[k]);
                        ++k;
                    }
                    vind[3] = tile[index].getElement(b);
                    k = 0;
                    while (k < vind[3].getSize()) {
                        vpos[3][k] = tile[index].getVertex(vind[3].m_data[k]);
                        ++k;
                    }
                    ind = m + 2;
                } else if (m == n - 1) {
                    vpos = new PdVector[4][4];
                    vind = new PiVector[4];
                    nb = new PiVector(3);
                    index = PuSubgroup.getIndexOfEltInG(String.valueOf(rep) + "St", m_rRsSt, "rst", true);
                    int index2 = PuSubgroup.getIndexOfEltInG(String.valueOf(rep) + "rt", m_rRsSt, "rst", true);
                    int index3 = PuSubgroup.getIndexOfEltInG(String.valueOf(rep) + "rs", m_rRsSt, "rst", true);
                    int a = m * n - m * (1 + m) / 2 - 1;
                    vind[0] = tile[i2].getElement(a);
                    int k = 0;
                    while (k < vind[0].getSize()) {
                        vpos[0][k] = tile[i2].getVertex(vind[0].m_data[k]);
                        ++k;
                    }
                    vind[1] = tile[index].getElement(a);
                    k = 0;
                    while (k < vind[1].getSize()) {
                        vpos[1][k] = tile[index].getVertex(vind[1].m_data[k]);
                        ++k;
                    }
                    vind[2] = tile[index2].getElement(a);
                    k = 0;
                    while (k < vind[2].getSize()) {
                        vpos[2][k] = tile[index2].getVertex(vind[2].m_data[k]);
                        ++k;
                    }
                    vind[3] = tile[index3].getElement(a);
                    k = 0;
                    while (k < vind[3].getSize()) {
                        vpos[3][k] = tile[index3].getVertex(vind[3].m_data[k]);
                        ++k;
                    }
                    ind = 1;
                }
                PdVector normal = new PdVector(3);
                normal.setConstant(0.0);
                int numAdj = vind.length;
                int j = 0;
                while (j < numAdj) {
                    int l = vind[j].getIndexOf(ind);
                    int noE = vind[j].getSize();
                    PdVector vertexO = vpos[j][l];
                    PdVector vertexB = vpos[j][(l + 1) % noE];
                    PdVector vertexC = vpos[j][(l + noE - 1) % noE];
                    edgeB.sub(vertexB, vertexO);
                    edgeC.sub(vertexC, vertexO);
                    normal.add(PdVector.crossNew((PdVector)edgeB, (PdVector)edgeC));
                    ++j;
                }
                normal.normalize();
                tile[i2].setVertexNormal(ind, normal);
                ++m;
            }
            ++i2;
        }
        return true;
    }

    private static PdMatrix getParallelogram() {
        PdVector sum;
        PdVector Rdir;
        PdVector dir;
        double a = m_a;
        double b = m_b;
        double scale = Math.tan(Math.PI / (double)m_p);
        double theta = Math.PI * 2 / (double)m_q;
        if (m_p == 6) {
            theta /= 2.0;
        }
        PdMatrix R = new PdMatrix(3);
        R.set((double[][])new double[][]{{Math.cos(theta), -Math.sin(theta), 0.0}, {Math.sin(theta), Math.cos(theta), 0.0}, {0.0, 0.0, 1.0}});
        a *= scale;
        if (m_b == 0 && m_p == 6) {
            dir = new PdVector(a, 0.0, 0.0);
            Rdir = new PdVector(3);
            Rdir.leftMultMatrix(R, dir);
            sum = PdVector.addNew((PdVector)dir, (PdVector)Rdir);
            a = sum.m_data[0];
            b = sum.m_data[1];
        }
        if (m_a == m_b) {
            if (m_p != 6) {
                dir = new PdVector(a, 0.0, 0.0);
                Rdir = new PdVector(3);
                Rdir.leftMultMatrix(R, dir);
                sum = PdVector.addNew((PdVector)dir, (PdVector)Rdir);
                a = sum.m_data[0];
                b = sum.m_data[1];
            } else {
                dir = new PdVector(a, 0.0, 0.0);
                Rdir = new PdVector(3);
                Rdir.leftMultMatrix(R, dir);
                PdVector dir1 = PdVector.addNew((PdVector)dir, (PdVector)Rdir);
                PdVector dir2 = new PdVector(3);
                dir2.leftMultMatrix(R, dir1);
                PdVector sum2 = PdVector.addNew((PdVector)dir1, (PdVector)dir2);
                a = sum2.m_data[0];
                b = sum2.m_data[1];
            }
        }
        PdVector v = new PdVector(3);
        R.set((double[][])new double[][]{{Math.cos(theta), -Math.sin(theta), 0.0}, {Math.sin(theta), Math.cos(theta), 0.0}, {0.0, 0.0, 1.0}});
        R.leftMultMatrix(v, new PdVector(a, b, 0.0));
        PdVector u = new PdVector(a, b, 0.0);
        PdVector w = new PdVector(1.0, 0.0, 0.0);
        PdVector z = new PdVector(0.0, 1.0, 0.0);
        PdMatrix SR = PuIsometry.mapXtoY(u, v, w, z);
        SR.multScalar(Math.PI * 2);
        return SR;
    }

    public static void makeCurvedEdge(PgElementSet geom) {
        int n = 7;
        int nov = 3;
        PdVector[] vertex = geom.getVertices();
        int newnov = 3 * (n - 2) + 3;
        geom.setNumVertices(newnov);
        PdVector[][] newEdge = new PdVector[3][n];
        int i = 0;
        while (i < 3) {
            newEdge[i] = PuHyperboloid.makeEdge(vertex[i], vertex[(i + 1) % 3], n);
            ++i;
        }
        int ind = 0;
        int i2 = 0;
        while (i2 < 3) {
            int j = 1;
            while (j < n - 1) {
                m_elementSet.setVertex(nov + ind, newEdge[i2][j]);
                ++ind;
                ++j;
            }
            ++i2;
        }
        PiVector index = new PiVector(n);
        index.setEntry(0, 0);
        index.setEntry(n - 1, 1);
        index.setEntry(2 * n - 2, 2);
        int s = 0;
        int i3 = 1;
        while (i3 < newnov) {
            if (i3 != n - 1 && i3 != 2 * n - 2) {
                index.setEntry(i3, nov + s);
                ++s;
            }
            ++i3;
        }
        PiVector newF = new PiVector(newnov);
        int i4 = 0;
        while (i4 < newnov) {
            newF.m_data[i4] = index.getEntry(i4);
            ++i4;
        }
        m_elementSet.setElement(0, newF);
    }

    @Override
    public PgElementSet getTriangle(PdVector[] tVert) {
        PgElementSet geom = new PgElementSet(3);
        geom.setNumVertices(3);
        geom.setNumElements(1);
        int i = 0;
        while (i < 3) {
            geom.setVertex(i, tVert[i]);
            ++i;
        }
        geom.setElement(0, 0, 1, 2);
        PgTile.makeCurvedEdge(geom);
        return geom;
    }
}

