/*
 * Decompiled with CFR 0.152.
 */
package devRegularMap.number;

import devRegularMap.functions.PuPlanarMaps;
import devRegularMap.grid.PwPutGrid;
import devRegularMap.vecmath.PuIsometry;
import devRegularMap.vecmath.PuQuadTesselation;
import jv.geom.PgElementSet;
import jv.geom.PgPolygonSet;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;

public class PgQuarterTube
extends PuQuadTesselation {
    protected static PdVector[] m_N;
    protected PgElementSet m_elementSet;
    protected PiVector m_perm;
    protected String m_rep;
    protected PgPolygonSet m_pol;
    protected int m_indPol;
    protected PgElementSet m_tube;
    protected static int m_tDiscr;
    protected static double m_tubeRadius;
    protected static PgPolygonSet[] m_NO;
    protected static PiVector[] m_neighbor;
    protected int LOCAL_SPACE;
    protected int m_discr = 7;

    static {
        m_tDiscr = 13;
        m_tubeRadius = 0.2;
    }

    public static void init(PdVector[] N) {
        m_N = N;
    }

    public static void setNeighbor(PgPolygonSet[] NO, PiVector[] neighbor) {
        m_neighbor = neighbor;
        m_NO = NO;
    }

    public PgQuarterTube(String rep) {
        this.m_elementSet = new PgElementSet(3);
        this.m_rep = rep;
    }

    public PgQuarterTube(PgPolygonSet pol, int ind) {
        this.m_pol = pol;
        this.m_indPol = ind;
    }

    public PgElementSet getGrid2D() {
        this.makeGrid2D();
        return this.m_elementSet;
    }

    private void makeGrid2D() {
        this.m_elementSet.setNumVertices(4);
        this.m_elementSet.setNumElements(1);
        PdMatrix M = PuIsometry.getTrans(this.m_rep, m_abc, "abc");
        this.m_perm = this.getIndexPermutation(this.m_rep);
        int i = 0;
        while (i < 4) {
            PdVector v = new PdVector(3);
            v.leftMultMatrix(M, m_N[i]);
            this.getElementSet().setVertex(this.m_perm.m_data[i], v);
            ++i;
        }
        this.m_elementSet.setElement(0, 0, 1, 2, 3);
        PwPutGrid.makeQuadGrid(this.m_elementSet, 7);
    }

    private PiVector getIndexPermutation(String rep) {
        PiVector p = new PiVector(4);
        PiVector c = new PiVector(4);
        PiVector pc = new PiVector(4);
        int i = 0;
        while (i < 4) {
            p.m_data[i] = i;
            ++i;
        }
        c.m_data[0] = 3;
        c.m_data[1] = 2;
        c.m_data[2] = 1;
        c.m_data[3] = 0;
        char[] ch = rep.toCharArray();
        int len = ch.length;
        int i2 = 0;
        while (i2 < len) {
            if (ch[len - 1 - i2] == 'c' || ch[len - 1 - i2] == 'C') {
                int j = 0;
                while (j < 4) {
                    pc.m_data[j] = p.m_data[c.m_data[j]];
                    ++j;
                }
                p.copy(pc);
            }
            ++i2;
        }
        return p;
    }

    public PgElementSet getElementSet() {
        return this.m_elementSet;
    }

    public PgElementSet get3DQuarterTube() {
        this.make3DQtube();
        return this.m_tube;
    }

    private void make3DQtube() {
        PdVector n;
        PdVector n2;
        this.m_tube = new PgElementSet(3);
        PiVector polIndex = this.m_pol.getPolygon(0);
        PdVector[] vertex = this.m_pol.getVertices();
        int radialDiscr = 7;
        int polyDiscr = 7;
        this.m_tube.setNumVertices(polyDiscr * (radialDiscr - 1));
        PdVector[] frame_e2 = new PdVector[polyDiscr];
        PdVector[] frame_e3 = new PdVector[polyDiscr];
        PdVector[] frame_base = new PdVector[polyDiscr];
        PdVector[] polygon = this.m_pol.getVertices();
        PdVector[] normal = this.m_pol.getVertexNormals();
        PiVector nb = m_neighbor[this.m_indPol];
        PgPolygonSet nPol0 = m_NO[nb.m_data[0]];
        PgPolygonSet nPol1 = m_NO[nb.m_data[2]];
        PdVector dir1 = PdVector.subNew((PdVector)vertex[polIndex.m_data[1]], (PdVector)this.m_pol.getVertex(0));
        PdVector dir2 = PdVector.subNew((PdVector)nPol0.getVertex(polIndex.m_data[1]), (PdVector)nPol0.getVertex(0));
        PdVector normAtN = this.m_pol.getVertexNormal(0);
        dir1 = PdVector.crossNew((PdVector)normAtN, (PdVector)PdVector.crossNew((PdVector)dir1, (PdVector)normAtN));
        dir2 = PdVector.crossNew((PdVector)normAtN, (PdVector)PdVector.crossNew((PdVector)dir2, (PdVector)normAtN));
        double angleEnd = Math.PI / 180 * PdVector.angle((PdVector)dir1, (PdVector)dir2);
        dir1 = PdVector.subNew((PdVector)vertex[polIndex.m_data[polyDiscr - 2]], (PdVector)this.m_pol.getVertex(1));
        dir2 = PdVector.subNew((PdVector)nPol1.getVertex(polIndex.m_data[polyDiscr - 2]), (PdVector)nPol1.getVertex(1));
        PdVector normAtO = this.m_pol.getVertexNormal(1);
        dir1 = PdVector.crossNew((PdVector)normAtO, (PdVector)PdVector.crossNew((PdVector)dir1, (PdVector)normAtO));
        dir2 = PdVector.crossNew((PdVector)normAtO, (PdVector)PdVector.crossNew((PdVector)dir2, (PdVector)normAtO));
        int sign = PuPlanarMaps.getOrientation()[this.m_indPol] ? 1 : -1;
        double angleStart = sign == -1 ? Math.abs(PdVector.angleWithOrientation((PdVector)dir1, (PdVector)dir2, (PdVector)normAtO)) : Math.abs(PdVector.angleWithOrientation((PdVector)dir2, (PdVector)dir1, (PdVector)normAtO));
        double dEnd = 1.0 / Math.tan(angleEnd / 2.0);
        double dStart = 1.0 / Math.tan(angleStart / 2.0);
        frame_e2[0] = this.m_pol.getVertexNormal(1);
        PdVector tanDir = PdVector.subNew((PdVector)vertex[polIndex.m_data[polyDiscr - 2]], (PdVector)vertex[polIndex.m_data[polyDiscr - 1]]);
        if (sign == 1) {
            n2 = PdVector.crossNew((PdVector)frame_e2[0], (PdVector)tanDir);
            frame_e3[0] = PdVector.crossNew((PdVector)n2, (PdVector)frame_e2[0]);
        } else {
            n2 = PdVector.crossNew((PdVector)tanDir, (PdVector)frame_e2[0]);
            frame_e3[0] = PdVector.crossNew((PdVector)frame_e2[0], (PdVector)n2);
        }
        frame_e3[0].normalize();
        PuVectorGeom.rotatePointAroundVector((PdVector)frame_e3[0], (PdVector)frame_e3[0], (PdVector)frame_e2[0], (double)((double)(-sign) * angleStart / 2.0));
        frame_e3[0].setLength(1.0 / Math.sin(angleStart / 2.0));
        frame_base[0] = polygon[1];
        int i = 1;
        while (i < polyDiscr - 1) {
            frame_e2[i] = normal[polIndex.m_data[polyDiscr - 1 - i]];
            frame_e2[i].normalize();
            tanDir = PdVector.subNew((PdVector)vertex[polIndex.m_data[polyDiscr - i - 2]], (PdVector)vertex[polIndex.m_data[polyDiscr - 1 - i]]);
            frame_e3[i] = sign == 1 ? PdVector.crossNew((PdVector)tanDir, (PdVector)frame_e2[i]) : PdVector.crossNew((PdVector)frame_e2[i], (PdVector)tanDir);
            frame_e3[i].normalize();
            double t = (double)i / (double)(polyDiscr - 1);
            double di = (1.0 - t) * dStart + t * dEnd;
            double alphai = Math.atan(1.0 / di);
            double ri = 1.0 / Math.sin(alphai);
            PuVectorGeom.rotatePointAroundVector((PdVector)frame_e3[i], (PdVector)frame_e3[i], (PdVector)frame_e2[i], (double)((double)(-sign) * (1.5707963267948966 - alphai)));
            frame_e3[i].setLength(ri);
            frame_base[i] = polygon[polIndex.m_data[polyDiscr - 1 - i]];
            ++i;
        }
        frame_e2[polyDiscr - 1] = normal[polIndex.m_data[0]];
        frame_e2[polyDiscr - 1].normalize();
        tanDir = PdVector.subNew((PdVector)vertex[polIndex.m_data[1]], (PdVector)vertex[polIndex.m_data[0]]);
        if (sign == 1) {
            n = PdVector.crossNew((PdVector)frame_e2[polyDiscr - 1], (PdVector)tanDir);
            frame_e3[polyDiscr - 1] = PdVector.crossNew((PdVector)n, (PdVector)frame_e2[polyDiscr - 1]);
        } else {
            n = PdVector.crossNew((PdVector)tanDir, (PdVector)frame_e2[polyDiscr - 1]);
            frame_e3[polyDiscr - 1] = PdVector.crossNew((PdVector)frame_e2[polyDiscr - 1], (PdVector)n);
        }
        frame_e3[polyDiscr - 1].normalize();
        PuVectorGeom.rotatePointAroundVector((PdVector)frame_e3[polyDiscr - 1], (PdVector)frame_e3[polyDiscr - 1], (PdVector)frame_e2[polyDiscr - 1], (double)((double)sign * angleEnd / 2.0));
        frame_e3[polyDiscr - 1].setLength(1.0 / Math.sin(angleEnd / 2.0));
        frame_base[polyDiscr - 1] = polygon[0];
        double[] vcos = new double[radialDiscr];
        double[] vsin = new double[radialDiscr];
        double vFac = Math.PI / (double)(radialDiscr - 1);
        PdVector[] m_vertex = new PdVector[polyDiscr * radialDiscr];
        int j = 0;
        while (j < radialDiscr) {
            double t = vFac * (double)j;
            vcos[j] = Math.cos(t);
            vsin[j] = Math.sin(t);
            ++j;
        }
        m_vertex[0] = PdVector.blendNew((double)1.0, (PdVector)frame_e2[polyDiscr - 1], (double)0.0, (PdVector)frame_e3[polyDiscr - 1]);
        m_vertex[1] = PdVector.blendNew((double)1.0, (PdVector)frame_e2[0], (double)0.0, (PdVector)frame_e3[0]);
        m_vertex[2] = PdVector.blendNew((double)-1.0, (PdVector)frame_e2[0], (double)0.0, (PdVector)frame_e3[0]);
        m_vertex[3] = PdVector.blendNew((double)-1.0, (PdVector)frame_e2[polyDiscr - 1], (double)0.0, (PdVector)frame_e3[polyDiscr - 1]);
        m_vertex[0].multScalar(m_tubeRadius);
        m_vertex[1].multScalar(m_tubeRadius);
        m_vertex[2].multScalar(m_tubeRadius);
        m_vertex[3].multScalar(m_tubeRadius);
        this.m_tube.setVertex(0, PdVector.blendNew((double)1.0, (PdVector)m_vertex[0], (double)1.0, (PdVector)frame_base[polyDiscr - 1]));
        this.m_tube.setVertex(1, PdVector.blendNew((double)1.0, (PdVector)m_vertex[1], (double)1.0, (PdVector)frame_base[0]));
        this.m_tube.setVertex(2, PdVector.blendNew((double)1.0, (PdVector)m_vertex[2], (double)1.0, (PdVector)frame_base[0]));
        this.m_tube.setVertex(3, PdVector.blendNew((double)1.0, (PdVector)m_vertex[3], (double)1.0, (PdVector)frame_base[polyDiscr - 1]));
        int ind = 4;
        int j2 = 1;
        while (j2 < radialDiscr - 1) {
            m_vertex[ind] = PdVector.blendNew((double)vcos[j2], (PdVector)frame_e2[0], (double)vsin[j2], (PdVector)frame_e3[0]);
            m_vertex[ind].multScalar(m_tubeRadius);
            this.m_tube.setVertex(ind, PdVector.blendNew((double)1.0, (PdVector)m_vertex[ind], (double)1.0, (PdVector)frame_base[0]));
            ++ind;
            ++j2;
        }
        int i2 = 1;
        while (i2 < polyDiscr - 1) {
            int j3 = 0;
            while (j3 < radialDiscr) {
                m_vertex[ind] = PdVector.blendNew((double)vcos[j3], (PdVector)frame_e2[i2], (double)vsin[j3], (PdVector)frame_e3[i2]);
                m_vertex[ind].multScalar(m_tubeRadius);
                this.m_tube.setVertex(ind, PdVector.blendNew((double)1.0, (PdVector)m_vertex[ind], (double)1.0, (PdVector)frame_base[i2]));
                ++ind;
                ++j3;
            }
            ++i2;
        }
        j2 = 1;
        while (j2 < radialDiscr - 1) {
            m_vertex[ind] = PdVector.blendNew((double)vcos[j2], (PdVector)frame_e2[polyDiscr - 1], (double)vsin[j2], (PdVector)frame_e3[polyDiscr - 1]);
            m_vertex[ind].multScalar(m_tubeRadius);
            this.m_tube.setVertex(ind, PdVector.blendNew((double)1.0, (PdVector)m_vertex[ind], (double)1.0, (PdVector)frame_base[polyDiscr - 1]));
            ++ind;
            ++j2;
        }
        int n3 = polyDiscr;
        int noe = (n3 - 1) * (n3 - 1);
        this.m_tube.setNumElements(noe);
        PiVector index = new PiVector(n3 * n3);
        index.setEntry(0, 1);
        index.setEntry(n3 - 1, 2);
        index.setEntry(n3 * (n3 - 1), 0);
        index.setEntry((n3 + 1) * (n3 - 1), 3);
        ind = 0;
        int i3 = 0;
        while (i3 < n3 * n3) {
            if (i3 != 0 && i3 != n3 - 1 && i3 != n3 * (n3 - 1) && i3 != (n3 + 1) * (n3 - 1)) {
                index.setEntry(i3, 4 + ind);
                ++ind;
            }
            ++i3;
        }
        ind = 0;
        i3 = 0;
        while (i3 < n3 - 1) {
            int j4 = 0;
            while (j4 < n3 - 1) {
                int a = index.m_data[i3 * n3 + j4];
                int b = index.m_data[i3 * n3 + j4 + 1];
                int c = index.m_data[(i3 + 1) * n3 + j4 + 1];
                int d = index.m_data[(i3 + 1) * n3 + j4];
                this.m_tube.setElement(ind, a, b, c, d);
                ++ind;
                ++j4;
            }
            ++i3;
        }
        this.m_tube.makeVertexNormals();
    }
}

