/*
 * Decompiled with CFR 0.152.
 */
package devRegularMap.inputApps;

import devRegularMap.functions.PgGon;
import devRegularMap.functions.PuRMaps;
import devRegularMap.functions.symGroup;
import devRegularMap.info.Pt4gGon;
import devRegularMap.sparser.PsRMDatabase;
import devRegularMap.vecmath.PuHyperboloid;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygonSet;
import jv.geom.PuCleanMesh;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PjExplicitInput
extends PjProject {
    protected PuRMaps m_src;
    protected PuRMaps m_trg;
    protected PgElementSet m_3DMap;
    protected PgElementSet m_2DMap;
    protected PgElementSet m_3DTube;
    protected PgElementSet m_fundPatch;
    protected PgPolygonSet m_NO;
    protected PgPolygonSet m_skeleton;
    protected PgGon m_4gGon;
    protected boolean m_b3D;
    protected boolean m_b2D;
    protected boolean m_bFtube;
    protected boolean m_bHas3DComputed;
    protected boolean m_bHasPlanarComputed;
    protected boolean m_bHasItubeComputed;
    protected boolean m_bSrc;
    protected boolean m_bTrg;
    int m_v0;
    int m_v1;

    public PjExplicitInput() {
        super("Input");
        if (((Object)((Object)this)).getClass() == PjExplicitInput.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_src = new PuRMaps("");
        this.m_trg = new PuRMaps("");
        this.m_src.setTargetMap(this.m_trg);
        this.m_bSrc = true;
        this.m_bTrg = false;
        this.initGeometry();
    }

    public void initGeometry() {
        this.m_3DMap = new PgElementSet(3);
        this.m_2DMap = new PgElementSet(3);
        this.m_3DTube = new PgElementSet(3);
        this.m_fundPatch = new PgElementSet(3);
        this.m_NO = new PgPolygonSet(3);
        this.m_skeleton = new PgPolygonSet(3);
        this.m_4gGon = new PgGon();
        this.m_3DMap.setName("3D");
        this.m_2DMap.setName("2D");
        this.m_3DTube.setName("Tube");
        this.m_fundPatch.setName("FundPatch");
        this.m_NO.setName("NO");
        this.m_skeleton.setName("Skeleton");
        this.m_4gGon.setName("boundary");
    }

    public boolean update(Object event) {
        if (event == this.m_display) {
            PuHyperboloid.hyperboloidToUpperHemisphere(this.m_2DMap.getVertices());
            PuHyperboloid.hyperboloidToPoincare(this.m_NO.getVertices());
            PuHyperboloid.hyperboloidToPoincare(this.m_4gGon.getVertices());
            this.m_2DMap.makeElementNormals();
            this.m_display.update((Object)this.m_display);
            return true;
        }
        if (event == null) {
            this.updateGeometry();
        }
        return super.update(event);
    }

    public void start() {
        this.addGeometry((PgGeometryIf)this.m_2DMap);
        this.addGeometry((PgGeometryIf)this.m_NO);
        this.addGeometry((PgGeometryIf)this.m_skeleton);
        this.addGeometry((PgGeometryIf)this.m_4gGon);
        this.m_display.selectCamera(3);
        this.m_display.fit();
        super.start();
    }

    public void updateGeometry() {
        this.update(this.m_display);
        this.m_2DMap.update((Object)this.m_2DMap);
        this.m_3DMap.update((Object)this.m_3DMap);
        this.m_3DTube.update((Object)this.m_3DTube);
        this.m_skeleton.update((Object)this.m_skeleton);
        this.m_fundPatch.update((Object)this.m_fundPatch);
        this.m_4gGon.update((Object)this.m_4gGon);
    }

    public void setGeometries(PgElementSet symM_S2D, PgElementSet symM_S3D, PgElementSet targetI, PgElementSet targetTube, PgPolygonSet skeleton) {
        this.m_2DMap = symM_S2D;
        this.m_3DMap = symM_S3D;
        this.m_3DTube = targetTube;
        this.m_fundPatch = targetI;
        this.m_skeleton = skeleton;
    }

    public void setSourceMap(String text) {
        PiVector param = new PiVector(6);
        boolean dual = false;
        PsRMDatabase.getParameters(param, text);
        if (text.contains("'")) {
            dual = true;
        }
        this.m_src.setParameters(param);
        this.m_src.setDual(dual);
        this.m_src.setName(text);
    }

    public void setTargetMap(String text) {
        PiVector param = new PiVector(6);
        boolean dual = false;
        PsRMDatabase.getParameters(param, text);
        if (text.contains("'")) {
            dual = true;
        }
        this.m_trg.setParameters(param);
        this.m_trg.setDual(dual);
        this.m_trg.setName(text);
    }

    public void setFtype(String text) {
        this.m_src.setFtype(text);
    }

    public void compute() {
        String[] gen = PsRMDatabase.getGenerator(this.m_src.getName(), this.m_trg.getName());
        this.m_src.setGenerators(gen);
        if (this.m_b3D) {
            if (this.m_bSrc) {
                if (!this.m_bHas3DComputed) {
                    this.computeSkeleton();
                    this.m_src.setSkeleton(this.m_skeleton);
                    this.m_src.hasSkeleton(true);
                    this.m_src.getTri3D();
                }
            } else {
                this.m_trg.getTri3D();
                PsDebug.error((String)"Target does not have a space model yet");
            }
        } else if (this.m_b2D) {
            if (this.m_bSrc) {
                if (!this.m_bHasPlanarComputed) {
                    this.m_src.getTri2D();
                }
            } else {
                this.m_trg.getTri2D();
            }
        } else if (this.m_bFtube && !this.m_bHasItubeComputed) {
            this.m_src.getFundQtube();
        }
    }

    public void computeNO() {
        PgPolygonSet[] NO = this.getNO();
        int i = 0;
        while (i < NO.length) {
            PuHyperboloid.hyperboloidToUpperHemisphere(NO[i].getVertices());
            NO[i].showVertices(false);
            this.m_display.addGeometry((PgGeometryIf)NO[i]);
            ++i;
        }
    }

    public PgPolygonSet[] getNO() {
        PgPolygonSet[] NO = this.m_bSrc ? this.m_src.getNO2DLine() : this.m_trg.getNO2DLine();
        return NO;
    }

    public void computeSkeleton() {
        this.computeControlSkeleton(this.m_skeleton);
        this.m_display.selectCamera(0);
        this.m_display.fit();
    }

    private void computeControlSkeleton(PgPolygonSet skeleton) {
        PgPolygonSet[] NO = this.m_src.getNO2DLine();
        int i = 0;
        while (i < NO.length) {
            PuHyperboloid.hyperboloidToUpperHemisphere(NO[i].getVertices());
            ++i;
        }
        int nop = NO.length;
        symGroup sym = this.m_src.getSymmetryGroup();
        PiVector[] neighbor = sym.getNeighbor();
        boolean[] checked = new boolean[nop];
        int nobp = 0;
        PiVector indBoundary = new PiVector();
        int i2 = 0;
        while (i2 < nop) {
            PdVector v1;
            PdVector v0;
            PdVector sub;
            int curr = i2;
            int nb = neighbor[i2].m_data[1];
            if (!checked[curr] && (sub = PdVector.subNew((PdVector)(v0 = NO[curr].getVertex(0)), (PdVector)(v1 = NO[nb].getVertex(0)))).length() > 1.0E-10) {
                indBoundary.addEntry(curr);
                indBoundary.addEntry(nb);
                checked[curr] = true;
                checked[nb] = true;
                nobp += 2;
            }
            ++i2;
        }
        int locnov = NO[0].getNumVertices();
        PgPolygonSet m = (PgPolygonSet)NO[0].clone();
        PiVector ind_NO = new PiVector();
        ind_NO.addEntry(0);
        int i3 = 1;
        while (i3 < nop) {
            m.merge((PgGeometryIf)NO[i3]);
            ++i3;
        }
        PuCleanMesh.identifyVertices((PgPointSet)m, (double)1.0E-9);
        nop = m.getNumPolygons();
        checked = new boolean[nop];
        i3 = 0;
        while (i3 < nobp) {
            int curr = indBoundary.m_data[i3];
            int opp = indBoundary.m_data[(i3 + 1) % nobp];
            if (!checked[curr]) {
                int curr_s = m.getPolygon((int)curr).m_data[0];
                int opp_s = m.getPolygon((int)opp).m_data[0];
                int curr_e = m.getPolygon((int)curr).m_data[locnov - 1];
                int opp_e = m.getPolygon((int)opp).m_data[locnov - 1];
                int j = 0;
                while (j < nop) {
                    if (j != curr) {
                        PiVector p = m.getPolygon(j);
                        if (p.m_data[0] == opp_s) {
                            p.m_data[0] = curr_s;
                        }
                        if (p.m_data[locnov - 1] == opp_e) {
                            p.m_data[locnov - 1] = curr_e;
                        }
                    }
                    ++j;
                }
                checked[opp] = true;
                checked[curr] = true;
            }
            ++i3;
        }
        PdVector[] vertex = m.getVertices();
        PiVector[] polygon = m.getPolygons();
        int i4 = 0;
        while (i4 < nop) {
            NO[i4].setVertex(0, vertex[polygon[i4].getFirstEntry()]);
            NO[i4].setVertex(1, vertex[polygon[i4].getLastEntry()]);
            if (indBoundary.getIndexOf(i4) == -1) {
                NO[neighbor[i4].m_data[1]].setVertex(0, vertex[polygon[i4].getFirstEntry()]);
                NO[neighbor[i4].m_data[1]].setVertex(1, vertex[polygon[i4].getLastEntry()]);
            }
            ++i4;
        }
        symGroup m_symM_T = this.m_src.getSymmetryGroup();
        String[] elt = m_symM_T.getElements();
        int noe = elt.length;
        nop = elt.length / 2;
        skeleton.init();
        skeleton.copy((PsObject)NO[0]);
        skeleton.setNumVertices(NO[0].getNumVertices() * nop);
        skeleton.setNumPolygons(nop);
        PiVector index = new PiVector(nop);
        boolean[] oriented = m_symM_T.getElementOrientation();
        int inde = 0;
        int i5 = 0;
        while (i5 < noe) {
            if (oriented[i5]) {
                index.m_data[inde] = i5;
                ++inde;
            }
            ++i5;
        }
        PiVector[] neighborM_T = m_symM_T.getNeighbor();
        PiVector[] m_skNeighbor = new PiVector[noe];
        inde = 0;
        int i6 = 0;
        while (i6 < noe) {
            if (oriented[i6]) {
                m_skNeighbor[inde] = new PiVector(2);
                m_skNeighbor[inde].m_data[0] = index.getIndexOf(neighborM_T[neighborM_T[i6].m_data[0]].m_data[1]);
                m_skNeighbor[inde].m_data[1] = index.getIndexOf(neighborM_T[neighborM_T[i6].m_data[2]].m_data[1]);
                ++inde;
            }
            ++i6;
        }
        checked = new boolean[nop];
        i6 = 0;
        while (i6 < nop) {
            PiVector nb = m_skNeighbor[i6];
            int j = 0;
            while (j < 2) {
                int a = nb.m_data[j];
                if (!checked[a]) {
                    int k = 0;
                    while (k < locnov) {
                        skeleton.setVertex(a * locnov + k, NO[index.m_data[a]].getVertex(k));
                        ++k;
                    }
                    PiVector tmp = new PiVector(locnov);
                    tmp.copy(NO[index.m_data[a]].getPolygon(0));
                    tmp.add(a * locnov);
                    skeleton.setPolygon(a, tmp);
                    checked[a] = true;
                }
                ++j;
            }
            ++i6;
        }
        PuCleanMesh.identifyVertices((PgPointSet)skeleton, (double)1.0E-9);
        skeleton.removeUnusedVertices();
    }

    public void setVisible(boolean bPlanar, boolean b3d, boolean bFtube, boolean bHyp) {
        this.m_b2D = bPlanar;
        this.m_b3D = b3d;
        this.m_bFtube = bFtube;
    }

    public void setActiveView(boolean state, boolean state2) {
        this.m_bSrc = state;
        this.m_bTrg = state2;
    }

    public PuRMaps getRegularMap() {
        if (this.m_bSrc) {
            return this.m_src;
        }
        return this.m_trg;
    }

    public void initRMap() {
        this.m_src.init();
        this.m_trg.init();
        this.m_src.setGeometries(this.m_2DMap, this.m_3DMap, this.m_fundPatch, this.m_3DTube);
        this.m_trg.setGeometries(this.m_2DMap, this.m_3DMap, this.m_fundPatch, this.m_3DTube);
    }

    public void project() {
        this.update(null);
    }

    public void compute4gGon() {
        Pt4gGon g = new Pt4gGon();
        g.setGeometry(this.m_4gGon);
        g.setRegularMap(this.m_trg);
        g.compute4gGon();
    }

    public void setV0(int v0) {
        this.m_v0 = v0;
    }

    public void setV1(int v1) {
        this.m_v1 = v1;
    }

    public void moveVertices() {
        PgGeometryIf geom = this.m_display.getSelectedGeometry();
        geom.setVertex(this.m_v0, geom.getVertex(this.m_v1));
    }
}

