/*
 * Decompiled with CFR 0.152.
 */
package devRegularMap.info;

import devRegularMap.functions.PuRMaps;
import devRegularMap.grid.PwPutGrid;
import jv.geom.PgPointSet;
import jv.geom.PgPolygonSet;
import jv.number.PuBoolean;
import jv.project.PjProject;
import jv.vecmath.PdVector;

public class PtShowLines
extends PjProject {
    protected PuBoolean m_bNO;
    protected PuBoolean m_bMN;
    protected PuBoolean m_bOM;
    protected PuBoolean m_bM;
    protected PuBoolean m_bN;
    protected PuBoolean m_bO;
    protected PgPointSet m_M;
    protected PgPointSet m_N;
    protected PgPointSet m_O;
    protected PgPolygonSet m_NO;
    protected PgPolygonSet m_OM;
    protected PgPolygonSet m_MN;
    protected PuRMaps m_rMaps;
    protected PuBoolean m_b2D;
    protected PuBoolean m_b3D;
    protected boolean m_pointIsComputed;

    public PtShowLines() {
        super(" ");
        if (((Object)((Object)this)).getClass() == PtShowLines.class) {
            this.init();
        }
    }

    public void init() {
        this.m_bNO = new PuBoolean("NO");
        this.m_bMN = new PuBoolean("MN");
        this.m_bOM = new PuBoolean("OM");
        this.m_bM = new PuBoolean("M");
        this.m_bN = new PuBoolean("N");
        this.m_bO = new PuBoolean("O");
        this.m_b2D = new PuBoolean(" ");
        this.m_b3D = new PuBoolean(" ");
        super.init();
    }

    public boolean update(Object event) {
        if (event == this) {
            int genus;
            if (this.m_bM.getState() || this.m_bN.getState() || this.m_bO.getState()) {
                this.computePoint();
            }
            if (this.m_bNO.getState()) {
                this.computeNOLines();
                genus = this.m_rMaps.getGenus();
                if (genus > 1 && this.m_b2D.getState()) {
                    PwPutGrid.refinePolygonSet(this.m_NO, 12, genus);
                }
                if (genus == 0 && this.m_b3D.getState()) {
                    PwPutGrid.refinePolygonSet(this.m_NO, 12, genus);
                }
            }
            if (this.m_bOM.getState()) {
                this.computeOMLines();
                genus = this.m_rMaps.getGenus();
                if (genus > 1 && this.m_b2D.getState()) {
                    PwPutGrid.refinePolygonSet(this.m_OM, 12, genus);
                }
                if (genus == 0 && this.m_b3D.getState()) {
                    PwPutGrid.refinePolygonSet(this.m_OM, 12, genus);
                }
            }
            if (this.m_bMN.getState()) {
                this.computeMNLines();
                genus = this.m_rMaps.getGenus();
                if (genus > 1 && this.m_b2D.getState()) {
                    PwPutGrid.refinePolygonSet(this.m_MN, 12, genus);
                }
                if (genus == 0 && this.m_b3D.getState()) {
                    PwPutGrid.refinePolygonSet(this.m_MN, 12, genus);
                }
            }
            return true;
        }
        return super.update(event);
    }

    public void setGeometriesPoint(PgPointSet M, PgPointSet N, PgPointSet O) {
        this.m_M = M;
        this.m_N = N;
        this.m_O = O;
    }

    public void setGeometriesLine(PgPolygonSet NO, PgPolygonSet OM, PgPolygonSet MN) {
        this.m_NO = NO;
        this.m_OM = OM;
        this.m_MN = MN;
        this.m_rMaps.setLines(NO, OM, MN);
    }

    public void setBooleans(PuBoolean bM, PuBoolean bN, PuBoolean bO, PuBoolean bMN, PuBoolean bNO, PuBoolean bOM) {
        this.m_bM = bM;
        this.m_bN = bN;
        this.m_bO = bO;
        this.m_bMN = bMN;
        this.m_bNO = bNO;
        this.m_bOM = bOM;
    }

    public void setEnabledPoint(boolean M, boolean N, boolean O) {
        this.m_bM.setState(M);
        this.m_bN.setState(N);
        this.m_bO.setState(O);
    }

    public void setEnableLine(boolean NO, boolean OM, boolean MN) {
        this.m_bNO.setState(NO);
        this.m_bOM.setState(OM);
        this.m_bMN.setState(MN);
    }

    public void hasPointComputed(boolean flag) {
        this.m_pointIsComputed = flag;
    }

    public void setView(boolean b2D, boolean b3D) {
        this.m_b2D.setState(b2D);
        this.m_b3D.setState(b3D);
    }

    public void setRegularMap(PuRMaps map) {
        this.m_rMaps = map;
    }

    public void computePoint() {
        if (this.m_b2D.getState()) {
            this.m_rMaps.makeVertexArray();
        } else if (this.m_b3D.getState()) {
            this.m_rMaps.makeVertexArray3D();
        }
        PdVector[] vertexM = this.m_rMaps.getVertexM();
        PdVector[] vertexN = this.m_rMaps.getVertexN();
        PdVector[] vertexO = this.m_rMaps.getVertexO();
        this.m_M.setNumVertices(vertexM.length);
        this.m_N.setNumVertices(vertexN.length);
        this.m_O.setNumVertices(vertexO.length);
        int i = 0;
        while (i < vertexM.length) {
            this.m_M.setVertex(i, vertexM[i]);
            ++i;
        }
        i = 0;
        while (i < vertexN.length) {
            this.m_N.setVertex(i, vertexN[i]);
            ++i;
        }
        i = 0;
        while (i < vertexO.length) {
            this.m_O.setVertex(i, vertexO[i]);
            ++i;
        }
    }

    public void computeNOLines() {
        if (this.m_b2D.getState()) {
            this.m_rMaps.makeNO2D();
        } else if (this.m_b3D.getState()) {
            this.m_rMaps.makeNO3D();
        }
    }

    public void computeOMLines() {
        if (this.m_b2D.getState()) {
            this.m_rMaps.makeOM2D();
        } else if (this.m_b3D.getState()) {
            this.m_rMaps.makeOM3D();
        }
    }

    public void computeMNLines() {
        if (this.m_b2D.getState()) {
            this.m_rMaps.makeMN2D();
        } else if (this.m_b3D.getState()) {
            this.m_rMaps.makeMN3D();
        }
    }

    public void showStringLabel() {
    }
}

