/*
 * Decompiled with CFR 0.152.
 */
package devRegularMap.info;

import devRegularMap.functions.PuRMaps;
import devRegularMap.info.PtShowLines;
import devRegularMap.smoothing.PuPolygonSmoothing;
import devRegularMap.smoothing.PwCatmullClarkSmoothing;
import jv.geom.PgElementSet;
import jv.geom.PgPolygonSet;
import jv.number.PuBoolean;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PjProject;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PwRefinePolygon;

public class PtShapeModelling
extends PjProject
implements Runnable {
    protected PuDouble m_tubeRadius;
    protected PuDouble m_weightRepell;
    protected PuDouble m_weightAttract;
    protected PuDouble m_weightUnify;
    protected PuDouble m_weightStraight;
    protected PuDouble m_weightStraightEnd;
    protected PuDouble m_weightStarSpring;
    protected PuDouble m_weightSmooth;
    protected PuDouble m_gamma;
    protected PuInteger m_frame;
    protected PgElementSet m_geomTile;
    protected PgElementSet m_geomTube;
    protected PuRMaps m_rMaps;
    protected PgPolygonSet m_skeleton;
    protected PiVector[] m_skNeighbor;
    protected PuBoolean m_isEnabledTile;
    protected PuBoolean m_isEnabledTube;
    protected PuBoolean m_isEnabledSkeleton;
    protected PuBoolean m_isEnabledLineOrPoint;
    protected PuBoolean m_hasSkeleton;
    protected Thread m_thread;
    protected boolean m_bRunning = false;
    protected boolean m_bStopped = true;
    protected PiVector[] m_nodeStar;
    protected PdVector[] m_velocity;
    protected PtShowLines m_pjShowLines;
    protected PwCatmullClarkSmoothing m_cs;
    protected final double D_MAX = 1.0;

    public PtShapeModelling() {
        super("Shape");
        if (this.getClass() == PtShapeModelling.class) {
            this.init();
        }
    }

    public void init() {
        double radius = 0.3;
        this.m_tubeRadius = new PuDouble(PsConfig.getMessage((boolean)true, (int)54000, (String)"Radius"));
        this.m_tubeRadius.addUpdateListener((PsUpdateIf)this);
        this.m_tubeRadius.setDefBounds(0.0, 10.0, 0.05, 0.1);
        this.m_tubeRadius.setDefValue(radius);
        this.m_tubeRadius.init();
        this.m_tubeRadius.setValue(radius);
        double repell = 0.1;
        double attract = 0.1;
        double unify = 0.1;
        double straighten = 1.0;
        double straightenEnd = 0.0;
        double starSpring = 1.0;
        double smooth = 0.3;
        double gamma = 0.1;
        this.m_weightRepell = new PuDouble(PsConfig.getMessage((boolean)true, (int)54000, (String)"Rep"));
        this.m_weightRepell.addUpdateListener((PsUpdateIf)this);
        this.m_weightRepell.setDefBounds(0.0, 10.0, 0.01, 0.1);
        this.m_weightRepell.setDefValue(repell);
        this.m_weightRepell.init();
        this.m_weightRepell.setValue(repell);
        this.m_weightAttract = new PuDouble(PsConfig.getMessage((boolean)true, (int)54000, (String)"Attr"));
        this.m_weightAttract.addUpdateListener((PsUpdateIf)this);
        this.m_weightAttract.setDefBounds(0.0, 10.0, 0.01, 0.1);
        this.m_weightAttract.setDefValue(attract);
        this.m_weightAttract.init();
        this.m_weightAttract.setValue(attract);
        this.m_weightUnify = new PuDouble(PsConfig.getMessage((boolean)true, (int)54000, (String)"U_E"));
        this.m_weightUnify.addUpdateListener((PsUpdateIf)this);
        this.m_weightUnify.setDefBounds(0.0, 10.0, 0.01, 0.1);
        this.m_weightUnify.setDefValue(unify);
        this.m_weightUnify.init();
        this.m_weightUnify.setValue(unify);
        this.m_weightStraight = new PuDouble(PsConfig.getMessage((boolean)true, (int)54000, (String)"Extrp"));
        this.m_weightStraight.addUpdateListener((PsUpdateIf)this);
        this.m_weightStraight.setDefBounds(0.0, 10.0, 0.01, 0.1);
        this.m_weightStraight.setDefValue(straighten);
        this.m_weightStraight.init();
        this.m_weightStraight.setValue(straighten);
        this.m_weightStraightEnd = new PuDouble(PsConfig.getMessage((boolean)true, (int)54000, (String)"Extrp_end"));
        this.m_weightStraightEnd.addUpdateListener((PsUpdateIf)this);
        this.m_weightStraightEnd.setDefBounds(0.0, 10.0, 0.01, 0.1);
        this.m_weightStraightEnd.setDefValue(straightenEnd);
        this.m_weightStraightEnd.init();
        this.m_weightStraightEnd.setValue(straightenEnd);
        this.m_weightStarSpring = new PuDouble(PsConfig.getMessage((boolean)true, (int)54000, (String)"Spring_N"));
        this.m_weightStarSpring.addUpdateListener((PsUpdateIf)this);
        this.m_weightStarSpring.setDefBounds(0.0, 10.0, 0.01, 0.1);
        this.m_weightStarSpring.setDefValue(starSpring);
        this.m_weightStarSpring.init();
        this.m_weightStarSpring.setValue(starSpring);
        this.m_weightSmooth = new PuDouble(PsConfig.getMessage((boolean)true, (int)54000, (String)"Step Size"));
        this.m_weightSmooth.addUpdateListener((PsUpdateIf)this);
        this.m_weightSmooth.setDefBounds(0.0, 1.0, 0.01, 0.1);
        this.m_weightSmooth.setDefValue(smooth);
        this.m_weightSmooth.init();
        this.m_weightSmooth.setValue(smooth);
        this.m_gamma = new PuDouble(PsConfig.getMessage((boolean)true, (int)54000, (String)"Gamma"));
        this.m_gamma.addUpdateListener((PsUpdateIf)this);
        this.m_gamma.setDefBounds(0.0, 1.0, 0.05, 0.1);
        this.m_gamma.setDefValue(gamma);
        this.m_gamma.init();
        this.m_gamma.setValue(gamma);
        this.m_frame = new PuInteger(PsConfig.getMessage((boolean)true, (int)54000, (String)"Frame/Iter"));
        this.m_frame.addUpdateListener((PsUpdateIf)this);
        this.m_frame.setDefBounds(1, 100, 1, 1);
        this.m_frame.setDefValue(50);
        this.m_frame.init();
        this.m_isEnabledLineOrPoint = new PuBoolean(" ");
        this.m_hasSkeleton = new PuBoolean(" ");
        this.m_cs = new PwCatmullClarkSmoothing();
        this.m_cs.setParent((PsUpdateIf)this);
        super.init();
    }

    public boolean update(Object event) {
        if (event == this.m_tubeRadius) {
            this.m_rMaps.setTubeRadius(this.m_tubeRadius.getValue());
            this.m_rMaps.makeTargetTube();
            this.m_rMaps.hasSpaceModel(true);
            if (!this.m_isEnabledTube.getState() && this.m_isEnabledTile.getState()) {
                this.m_rMaps.getTri3D();
            }
            return super.update(null);
        }
        if (event == this) {
            if (this.m_isEnabledTube.getState()) {
                this.m_rMaps.makeTargetTube();
            } else if (this.m_isEnabledTile.getState()) {
                this.m_rMaps.getTri3D();
            }
            return super.update(null);
        }
        if (event == this.m_geomTile) {
            this.m_geomTile.showEdges(false);
            this.m_geomTile.update((Object)this.m_geomTile);
            return true;
        }
        if (event == this.m_geomTube) {
            this.m_geomTube.setTransparency(0.7);
            this.m_geomTube.showTransparency(true);
            this.m_geomTube.showEdges(false);
            this.m_geomTube.update((Object)this.m_geomTube);
            return true;
        }
        if (event == this.m_skeleton) {
            this.m_skeleton.update((Object)this.m_skeleton);
            return true;
        }
        if (event == this.m_cs) {
            this.m_rMaps.hasSpaceModel(true);
            if (!this.m_isEnabledTube.getState() && this.m_isEnabledTile.getState()) {
                this.m_rMaps.getTri3D();
            }
            this.update(null);
            return true;
        }
        if (event == this.m_frame) {
            return true;
        }
        return super.update(event);
    }

    public void setGeometry(PgElementSet geomTile, PgElementSet geomTube) {
        this.m_geomTile = geomTile;
        this.m_geomTube = geomTube;
        this.m_cs.setGeometry((PgGeometry)this.m_geomTube);
    }

    public void setSkeleton(PgPolygonSet skeleton) {
        this.m_skeleton = skeleton;
    }

    public void setRegularMap(PuRMaps map) {
        this.m_rMaps = map;
    }

    public void setLineClass(PtShowLines pjShowLines) {
        this.m_pjShowLines = pjShowLines;
    }

    public void setBooleanPointOrLine(PuBoolean[] flag) {
        int i = 0;
        while (i < flag.length) {
            if (flag[i].getState()) {
                this.m_isEnabledLineOrPoint.setState(true);
                return;
            }
            ++i;
        }
        this.m_isEnabledLineOrPoint.setState(false);
    }

    public void initSkeleton() {
        this.m_rMaps.getSkeleton(this.m_skeleton);
        this.m_rMaps.setSkeleton(this.m_skeleton);
        this.m_rMaps.hasSkeleton(true);
    }

    public void setVisible(boolean btube, boolean btile) {
        this.m_isEnabledTube.setState(btube);
        this.m_isEnabledTile.setState(btile);
    }

    public void hasSkeleton(boolean flag) {
        this.m_rMaps.hasSkeleton(flag);
    }

    public void refineDLG() {
        PwRefinePolygon.refineDLG((PgPolygonSet)this.m_skeleton);
        int discr = this.m_skeleton.getPolygon(0).getSize();
        this.m_rMaps.setNumSample(discr);
        if (this.m_isEnabledTube.getState()) {
            this.m_rMaps.makeTargetTube();
            if (this.m_isEnabledLineOrPoint.getState()) {
                this.m_rMaps.makeFundGridPatch();
            }
        } else if (this.m_isEnabledTile.getState()) {
            this.m_rMaps.has2DGridPatch(false);
            this.m_rMaps.hasFundQtube(false);
            this.m_rMaps.has2DQtube(false);
            this.m_rMaps.hasSpaceModel(false);
            this.m_rMaps.getTri3D();
        }
        this.update(null);
    }

    public void coarsenDLG() {
        PwRefinePolygon.coarsenDLG((PgPolygonSet)this.m_skeleton);
        int discr = this.m_skeleton.getPolygon(0).getSize();
        this.m_rMaps.setNumSample(discr);
        if (this.m_isEnabledTube.getState()) {
            this.m_rMaps.makeTargetTube();
            if (this.m_isEnabledLineOrPoint.getState()) {
                this.m_rMaps.makeFundGridPatch();
            }
        } else if (this.m_isEnabledTile.getState()) {
            this.m_rMaps.has2DGridPatch(false);
            this.m_rMaps.hasFundQtube(false);
            this.m_rMaps.has2DQtube(false);
            this.m_rMaps.hasSpaceModel(false);
            this.m_rMaps.getTri3D();
        }
        this.update(null);
    }

    public void smoothCC() {
        PgElementSet spaceModel = this.m_rMaps.getTargetTube();
        PwCatmullClarkSmoothing.smoothingCC(spaceModel);
        this.m_rMaps.hasSpaceModel(true);
        if (!this.m_isEnabledTube.getState() && this.m_isEnabledTile.getState()) {
            this.m_rMaps.getTri3D();
        }
        this.update(null);
    }

    public void setBooleans(PuBoolean bShow3DTube, PuBoolean bShow3DTile, PuBoolean bSkeleton) {
        this.m_isEnabledTube = bShow3DTube;
        this.m_isEnabledTile = bShow3DTile;
        this.m_isEnabledSkeleton = bSkeleton;
    }

    public void startSmoothing() {
        if (!this.m_bStopped || this.m_bRunning) {
            return;
        }
        this.m_bRunning = true;
        this.m_thread = new Thread((Runnable)this, "JavaView: Smooth Surface");
        this.m_thread.setPriority(5);
        this.m_thread.start();
        PsDebug.notify((String)"Thread started");
    }

    public void stopSmoothing() {
        if (this.m_bRunning) {
            this.m_bRunning = false;
            this.m_thread = null;
            this.updatePanels(this);
            PsDebug.notify((String)"Thread stopped");
        }
    }

    public void oneStep() {
        int nov = this.m_skeleton.getNumVertices();
        PiVector[] neighbor = this.m_rMaps.getSkeletonNeighbor();
        this.m_nodeStar = new PiVector[this.m_rMaps.getTargetMap().getNumVertices()];
        this.m_nodeStar = new PiVector[this.m_rMaps.getTargetMap().getNumVertices()];
        PuPolygonSmoothing.makeLinkAtNodes(this.m_skeleton, this.m_nodeStar, neighbor);
        int frame = 0;
        while (frame < this.m_frame.getValue()) {
            this.m_velocity = new PdVector[nov];
            int i = 0;
            while (i < nov) {
                this.m_velocity[i] = new PdVector(3);
                ++i;
            }
            this.smoothStep();
            if (++frame < this.m_frame.getValue()) continue;
            if (this.m_isEnabledTube.getState()) {
                PuPolygonSmoothing.makeNormals(this.m_skeleton, neighbor, false);
                this.m_rMaps.makeTargetTube();
                if (this.m_isEnabledLineOrPoint.getState()) {
                    this.m_rMaps.makeFundGridPatch();
                }
                this.update(this.m_geomTube);
            } else if (this.m_isEnabledTile.getState()) {
                this.m_rMaps.getTri3D();
                this.update(this.m_geomTile);
            }
            this.update(this.m_skeleton);
        }
        PuPolygonSmoothing.makeNormals(this.m_skeleton, neighbor, false);
        this.update(null);
    }

    @Override
    public void run() {
        this.m_bStopped = false;
        int nov = this.m_skeleton.getNumVertices();
        PiVector[] neighbor = this.m_rMaps.getSkeletonNeighbor();
        this.m_nodeStar = new PiVector[this.m_rMaps.getTargetMap().getNumVertices()];
        this.m_nodeStar = new PiVector[this.m_rMaps.getTargetMap().getNumVertices()];
        PuPolygonSmoothing.makeLinkAtNodes(this.m_skeleton, this.m_nodeStar, neighbor);
        int frame = 0;
        while (this.m_thread != null && this.m_bRunning) {
            this.m_velocity = new PdVector[nov];
            int i = 0;
            while (i < nov) {
                this.m_velocity[i] = new PdVector(3);
                ++i;
            }
            this.smoothStep();
            if (++frame <= this.m_frame.getValue()) continue;
            if (this.m_isEnabledTube.getState()) {
                PuPolygonSmoothing.makeNormals(this.m_skeleton, neighbor, false);
                this.m_rMaps.makeTargetTube();
                if (this.m_isEnabledLineOrPoint.getState()) {
                    this.m_rMaps.makeFundGridPatch();
                }
                this.update(this.m_geomTube);
            } else if (this.m_isEnabledTile.getState()) {
                this.m_rMaps.has2DGridPatch(false);
                this.m_rMaps.hasFundQtube(false);
                this.m_rMaps.has2DQtube(false);
                this.m_rMaps.hasSpaceModel(false);
                this.m_rMaps.getTri3D();
                this.update(this.m_geomTile);
            }
            this.update(this.m_skeleton);
            frame = 0;
        }
        this.m_bStopped = true;
        PuPolygonSmoothing.makeNormals(this.m_skeleton, neighbor, false);
        this.update(null);
    }

    public void smoothStep() {
        PiVector poly;
        int nop = this.m_skeleton.getNumPolygons();
        int dim = this.m_skeleton.getDimOfVertices();
        double wRepell = this.m_weightRepell.getValue();
        wRepell /= (double)(this.m_skeleton.getNumVertices() - 1);
        double wAttract = this.m_weightAttract.getValue();
        double wUnify = this.m_weightUnify.getValue();
        double wNodeSprings = this.m_weightStarSpring.getValue();
        double wStraightness = this.m_weightStraight.getValue();
        double wStraightnessEnd = this.m_weightStraightEnd.getValue();
        double stepSize = this.m_weightSmooth.getValue();
        int numEdges = 0;
        double avgLength = 0.0;
        PiVector valence = new PiVector(this.m_skeleton.getNumVertices());
        boolean[] bNode = new boolean[this.m_skeleton.getNumVertices()];
        int i = 0;
        while (i < this.m_skeleton.getNumVertices()) {
            bNode[i] = false;
            ++i;
        }
        i = 0;
        while (i < nop) {
            int polySize;
            PiVector poly2 = this.m_skeleton.getPolygon(i);
            if (!bNode[poly2.m_data[0]]) {
                bNode[poly2.m_data[0]] = true;
            }
            if (!bNode[poly2.m_data[(polySize = poly2.getSize()) - 1]]) {
                bNode[poly2.m_data[polySize - 1]] = true;
            }
            numEdges += polySize - 1;
            avgLength += this.m_skeleton.getLengthOfPolygon(i);
            int j = 0;
            while (j < polySize) {
                int n = poly2.m_data[j];
                valence.m_data[n] = valence.m_data[n] + 1;
                ++j;
            }
            ++i;
        }
        avgLength /= (double)numEdges;
        PdVector[] force = PdVector.realloc(null, (int)this.m_skeleton.getNumVertices(), (int)dim);
        PdVector diff = new PdVector(dim);
        double dist = 0.0;
        int i2 = 0;
        while (i2 < this.m_skeleton.getNumVertices()) {
            if (wRepell != 0.0) {
                int j = i2 + 1;
                while (j < this.m_skeleton.getNumVertices()) {
                    diff.sub(this.m_skeleton.getVertex(j), this.m_skeleton.getVertex(i2));
                    dist = diff.sqrLength();
                    if (diff.normalize()) {
                        if (dist < 1.0E-10) {
                            dist = 1.0E-10;
                        }
                        diff.multScalar(wRepell / dist);
                        force[i2].sub(diff);
                        force[j].add(diff);
                    }
                    ++j;
                }
            }
            ++i2;
        }
        PiVector[] neighbor = this.m_rMaps.getSkeletonNeighbor();
        int i3 = 0;
        while (i3 < nop) {
            poly = this.m_skeleton.getPolygon(i3);
            int polySize = poly.getSize();
            int j = 0;
            while (j < polySize - 1) {
                diff.sub(this.m_skeleton.getVertex(poly.m_data[j + 1]), this.m_skeleton.getVertex(poly.m_data[j]));
                diff.multScalar(wAttract);
                force[poly.m_data[j]].add(diff);
                force[poly.m_data[j + 1]].sub(diff);
                ++j;
            }
            PiVector npoly = this.m_skeleton.getPolygon(neighbor[i3].m_data[1]);
            diff.sub(this.m_skeleton.getVertex(npoly.m_data[polySize - 2]), this.m_skeleton.getVertex(poly.m_data[polySize - 1]));
            diff.multScalar(wAttract);
            force[poly.m_data[polySize - 1]].add(diff);
            force[npoly.m_data[polySize - 2]].sub(diff);
            ++i3;
        }
        i3 = 0;
        while (i3 < nop) {
            poly = this.m_skeleton.getPolygon(i3);
            int j = 0;
            while (j < poly.getSize() - 1) {
                diff.sub(this.m_skeleton.getVertex(poly.m_data[j + 1]), this.m_skeleton.getVertex(poly.m_data[j]));
                dist = diff.length();
                if (diff.normalize()) {
                    diff.multScalar(wUnify * (dist - avgLength));
                    force[poly.m_data[j]].add(diff);
                    force[poly.m_data[j + 1]].sub(diff);
                }
                ++j;
            }
            PiVector npoly = this.m_skeleton.getPolygon(neighbor[i3].m_data[1]);
            diff.sub(this.m_skeleton.getVertex(npoly.m_data[poly.getSize() - 2]), this.m_skeleton.getVertex(poly.m_data[poly.getSize() - 1]));
            dist = diff.length();
            if (diff.normalize()) {
                diff.multScalar(wUnify * (dist - avgLength));
                force[poly.m_data[poly.getSize() - 1]].add(diff);
                force[npoly.m_data[poly.getSize() - 2]].sub(diff);
            }
            ++i3;
        }
        int numNodeStars = 0;
        if (this.m_nodeStar != null && this.m_nodeStar.length > 0) {
            numNodeStars = this.m_nodeStar.length;
        }
        int i4 = 0;
        while (i4 < numNodeStars) {
            PiVector star = this.m_nodeStar[i4];
            int starSize = star.getSize();
            int j = 0;
            while (j < starSize - 1) {
                int k = j + 1;
                while (k < starSize) {
                    diff.sub(this.m_skeleton.getVertex(star.m_data[k]), this.m_skeleton.getVertex(star.m_data[j]));
                    dist = diff.length();
                    if (diff.normalize()) {
                        double angle = Math.PI * 2 * (double)(k - j) / (1.0 * (double)starSize);
                        double d = Math.sqrt((1.0 - Math.cos(angle)) * (1.0 - Math.cos(angle)) + Math.sin(angle) * Math.sin(angle));
                        diff.multScalar(wNodeSprings * ((d *= avgLength) - dist));
                        force[star.m_data[j]].sub(diff);
                        force[star.m_data[k]].add(diff);
                    }
                    ++k;
                }
                ++j;
            }
            ++i4;
        }
        double w = 0.5;
        int i5 = 0;
        while (i5 < nop) {
            PiVector poly3 = this.m_skeleton.getPolygon(i5);
            PiVector npoly = this.m_skeleton.getPolygon(neighbor[i5].m_data[1]);
            if (poly3.getSize() >= 4) {
                int j = 2;
                while (j < poly3.getSize() - 2) {
                    diff.blend(-w, this.m_skeleton.getVertex(poly3.m_data[j - 2]), -w, this.m_skeleton.getVertex(poly3.m_data[j + 2]));
                    diff.add(this.m_skeleton.getVertex(poly3.m_data[j - 1]));
                    diff.add(this.m_skeleton.getVertex(poly3.m_data[j + 1]));
                    diff.sub(this.m_skeleton.getVertex(poly3.m_data[j]));
                    diff.multScalar(wStraightness);
                    force[poly3.m_data[j]].add(diff);
                    ++j;
                }
                diff.blend(-w, this.m_skeleton.getVertex(poly3.m_data[1]), -w, this.m_skeleton.getVertex(poly3.m_data[3]));
                diff.add(this.m_skeleton.getVertex(poly3.m_data[2]));
                diff.multScalar(wStraightnessEnd);
                force[poly3.m_data[1]].add(diff);
                diff.blend(-w, this.m_skeleton.getVertex(poly3.m_data[poly3.getSize() - 3]), -w, this.m_skeleton.getVertex(npoly.m_data[poly3.getSize() - 3]));
                diff.add(this.m_skeleton.getVertex(poly3.m_data[poly3.getSize() - 2]));
                diff.add(this.m_skeleton.getVertex(npoly.m_data[poly3.getSize() - 2]));
                diff.sub(this.m_skeleton.getVertex(poly3.m_data[poly3.getSize() - 1]));
                diff.multScalar(wStraightness);
                force[poly3.m_data[poly3.getSize() - 1]].add(diff);
            }
            ++i5;
        }
        i5 = 0;
        while (i5 < this.m_skeleton.getNumVertices()) {
            this.m_velocity[i5] = PdVector.blendNew((double)(1.0 - this.m_gamma.getValue()), (PdVector)this.m_velocity[i5], (double)stepSize, (PdVector)force[i5]);
            PdVector s_v = PdVector.copyNew((PdVector)this.m_velocity[i5]);
            s_v.multScalar(stepSize);
            double l = Math.min(1.0, s_v.length());
            s_v.normalize();
            s_v.multScalar(l);
            if (!this.m_skeleton.getVertex(i5).hasTag(1)) {
                this.m_skeleton.getVertex(i5).add(s_v);
            }
            ++i5;
        }
    }
}

