/*
 * Decompiled with CFR 0.152.
 */
package devRegularMap.info;

import devRegularMap.functions.PuRMaps;
import devRegularMap.functions.symGroup;
import devRegularMap.smoothing.PuPolygonSmoothing;
import devRegularMap.sparser.PsMisc;
import devRegularMap.sparser.PsRMDatabase;
import devRegularMap.vecmath.PuHyperboloid;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygonSet;
import jv.geom.PuCleanMesh;
import jv.number.PuInteger;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PtRegmap
extends PjProject {
    public PuInteger m_genus;
    protected String[] m_sourceMap;
    protected String[][] m_targetMap;
    protected String[] m_ftype;
    protected int m_index;
    protected int m_ispace;
    protected PgElementSet m_geom;
    protected PgElementSet m_3DMap = new PgElementSet(3);
    protected PgElementSet m_2DMap = new PgElementSet(3);
    protected PgElementSet m_3DTube;
    protected PgElementSet m_fundPatch;
    protected PgPolygonSet m_skeleton;
    protected PuRMaps m_srcMap;
    protected PuRMaps m_trgMap;
    protected boolean m_b3D;
    protected boolean m_b2D;
    protected boolean m_bFtube;
    protected boolean m_bHas3DComputed;
    protected boolean m_bHasPlanarComputed;
    protected boolean m_bHasItubeComputed;
    protected boolean m_bIsSrcAndTrgInit;
    protected boolean[] m_bKnown;
    protected boolean m_bInput;

    public PtRegmap() {
        super("Tab map");
        this.m_geom = new PgElementSet(3);
        if (((Object)((Object)this)).getClass() == PtRegmap.class) {
            this.init();
        }
    }

    public void init() {
        this.m_genus = new PuInteger("genus", (PsUpdateIf)this);
        this.m_genus.setDefBounds(0, 101, 1, 1);
        this.m_genus.setDefValue(0);
        this.m_genus.init();
        this.m_sourceMap = PsRMDatabase.getListSourceMap(0);
        this.m_targetMap = PsRMDatabase.getListTargetMap();
        this.m_ftype = PsRMDatabase.getFtype();
        super.init();
    }

    public void setGeometries(PgElementSet twoD, PgElementSet threeD, PgElementSet ftube, PgElementSet tube, PgPolygonSet skeleton) {
        this.m_2DMap = twoD;
        this.m_3DMap = threeD;
        this.m_fundPatch = ftube;
        this.m_3DTube = tube;
        this.m_skeleton = skeleton;
    }

    public boolean isInput() {
        return this.m_bInput;
    }

    public void setInput(boolean m_bInput) {
        this.m_bInput = m_bInput;
    }

    public boolean update(Object event) {
        if (event == this.m_genus) {
            this.compute();
            return true;
        }
        return super.update(event);
    }

    public void updateListOfSourceMapAndTargetMap() {
        this.m_sourceMap = PsRMDatabase.getListSourceMap(this.m_genus.getValue());
        this.m_targetMap = PsRMDatabase.getListTargetMap();
        this.m_bKnown = new boolean[this.m_sourceMap.length];
        this.m_ftype = new String[this.m_sourceMap.length];
        if (this.m_genus.getValue() > 1) {
            PiVector index = new PiVector();
            int i = 0;
            while (i < this.m_sourceMap.length) {
                this.m_bKnown[i] = this.m_genus.getValue() < 2 || this.isTargetMapExist(i, 0, this.m_targetMap);
                index.addEntry(i);
                ++i;
            }
            String[] tmpSrc = new String[this.m_sourceMap.length];
            String[][] tmpTrg = new String[this.m_sourceMap.length][];
            tmpTrg[0] = new String[3];
            System.arraycopy(this.m_sourceMap, 0, tmpSrc, 0, this.m_sourceMap.length);
            int i2 = 0;
            while (i2 < this.m_sourceMap.length) {
                tmpTrg[i2] = new String[this.m_targetMap[i2].length];
                System.arraycopy(this.m_targetMap[i2], 0, tmpTrg[i2], 0, this.m_targetMap[i2].length);
                ++i2;
            }
            int size = index.getSize();
            this.m_sourceMap = new String[size];
            this.m_targetMap = new String[size][];
            int i3 = 0;
            while (i3 < size) {
                this.m_sourceMap[i3] = tmpSrc[index.m_data[i3]];
                this.m_targetMap[i3] = tmpTrg[index.m_data[i3]];
                this.m_ftype[i3] = PsRMDatabase.getFtype(this.m_sourceMap[i3]);
                ++i3;
            }
        }
    }

    public int viewTargetMap(int src, int trg) {
        String name = this.m_targetMap[src][trg];
        String schlafi = "";
        int genus = PsMisc.getGenus(name);
        schlafi = genus < 2 ? this.m_targetMap[src][trg].split("\\s+")[1] : (name.contains("'") ? this.m_targetMap[src][trg].split("'")[1] : "{" + this.m_targetMap[src][trg].split("\\{")[1]);
        int type = -1;
        this.m_genus.setValue(genus);
        this.updateListOfSourceMapAndTargetMap();
        int i = 0;
        while (i < this.m_sourceMap.length) {
            if (this.m_sourceMap[i].contains(schlafi)) {
                type = i;
                break;
            }
            ++i;
        }
        return type;
    }

    public boolean isTargetMapExist(int src, int trg, String[][] targetMap) {
        String name = targetMap[src][trg];
        int genus = PsMisc.getGenus(name);
        String[] srcMap = PsRMDatabase.getListSourceMap(genus);
        String[][] trgMap = PsRMDatabase.getListTargetMap();
        if (genus < 2) {
            return true;
        }
        int i = 0;
        while (i < srcMap.length) {
            if (srcMap[i].contains(name)) {
                return this.isTargetMapExist(i, 0, trgMap);
            }
            ++i;
        }
        return false;
    }

    public void computeSrcAndTrgMap() {
        int ismap = this.m_index;
        int itmap = this.m_ispace;
        int maxTarget = 5;
        boolean[] dual = new boolean[maxTarget];
        String[][] gen = new String[maxTarget][3];
        String[] M = new String[maxTarget];
        PiVector[] param = new PiVector[maxTarget];
        String[] type = new String[maxTarget];
        PiVector.realloc((PiVector[])param, (int)maxTarget, (int)6);
        M[0] = this.m_sourceMap[ismap];
        M[1] = this.m_genus.getValue() > 1 ? this.m_targetMap[ismap][itmap] : null;
        boolean known = false;
        int i = 0;
        while (!known) {
            if (M[i + 1] == null) {
                PsRMDatabase.getParameters(param[i], M[i]);
                gen[i] = null;
                dual[i] = false;
                type[i] = null;
                known = true;
                continue;
            }
            PsRMDatabase.getParameters(param[i], M[i]);
            gen[i] = PsRMDatabase.getGenerator(M[i], M[i + 1]);
            type[i] = PsRMDatabase.getFtype(M[i]);
            if (M[i].contains("'")) {
                dual[i] = true;
            }
            M[i + 2] = PsRMDatabase.getTargetMap(M[i + 1]);
            ++i;
        }
        int count = 0;
        while (M[count] != null) {
            ++count;
        }
        PuRMaps[] map = new PuRMaps[count + 1];
        map[0] = null;
        i = 1;
        while (i <= count) {
            map[i] = new PuRMaps(param[count - i], map[i - 1], gen[count - i], dual[count - i], type[count - i]);
            map[i].setName(M[count - i]);
            ++i;
        }
        this.m_srcMap = map[count];
        this.m_trgMap = this.m_srcMap.getTargetMap();
        this.m_srcMap.setGeometries(this.m_2DMap, this.m_3DMap, this.m_fundPatch, this.m_3DTube);
    }

    public PuRMaps getSrcMap() {
        return this.m_srcMap;
    }

    public void setSrcMap(String name) {
        this.m_srcMap = new PuRMaps(name);
    }

    public PuRMaps getTrgMap() {
        return this.m_trgMap;
    }

    public void setTrgMap(String name) {
        this.m_trgMap = new PuRMaps(name);
    }

    public void compute() {
        if (!this.m_bIsSrcAndTrgInit) {
            this.computeSrcAndTrgMap();
            this.setInitSrcAndTarget(true);
        }
        if (this.m_b3D) {
            if (!this.m_bHas3DComputed) {
                this.m_srcMap.hasSkeleton(false);
                if (this.m_bInput) {
                    PiVector[] skNeighbor = new PiVector[this.m_trgMap.getNumElements()];
                    this.computeControlSkeleton(this.m_skeleton, this.m_srcMap, this.m_trgMap, skNeighbor);
                    this.m_srcMap.setSkeleton(this.m_skeleton);
                    this.m_srcMap.setSkeletonNeighbor(skNeighbor);
                    this.m_srcMap.hasSkeleton(true);
                }
                this.m_srcMap.getTri3D();
                this.m_bHas3DComputed = true;
            }
        } else if (this.m_b2D) {
            if (!this.m_bHasPlanarComputed) {
                this.m_srcMap.getTri2D();
                this.m_bHasPlanarComputed = true;
            }
        } else if (this.m_bFtube && !this.m_bHasItubeComputed) {
            this.m_srcMap.getFundQtube();
            this.m_bHasItubeComputed = true;
        }
    }

    public void setInitSrcAndTarget(boolean flag) {
        this.m_bIsSrcAndTrgInit = flag;
    }

    public void setSelectedSrcMapIndex(int type) {
        this.m_index = type;
    }

    public void setSelectedTrgMap(int type) {
        this.m_ispace = type;
    }

    public void setEnabled3D(boolean flag) {
        this.m_bHas3DComputed = flag;
    }

    public void setEnabled2D(boolean flag) {
        this.m_bHasPlanarComputed = flag;
    }

    public PuRMaps getRegularMap() {
        return this.m_srcMap;
    }

    public void setVisible(boolean bPlanar, boolean b3d, boolean bFtube, boolean bHyp) {
        this.m_b2D = bPlanar;
        this.m_b3D = b3d;
        this.m_bFtube = bFtube;
    }

    public boolean has3D() {
        return this.m_b3D;
    }

    public boolean has2D() {
        return this.m_b2D;
    }

    public void setFtype(String text) {
        this.m_srcMap.setFtype(text);
        this.initRMap();
    }

    public void initRMap() {
        this.m_srcMap.setTargetMap(this.m_trgMap);
        this.m_srcMap.init();
        this.m_trgMap.init();
        this.m_srcMap.setGeometries(this.m_2DMap, this.m_3DMap, this.m_fundPatch, this.m_3DTube);
        String[] gen = PsRMDatabase.getGenerator(this.m_srcMap.getName(), this.m_trgMap.getName());
        this.m_srcMap.setGenerators(gen);
    }

    public void computeControlSkeleton(PgPolygonSet skeleton, PuRMaps src, PuRMaps trg, PiVector[] m_skNeighbor) {
        PgPolygonSet[] NO = trg.getNO2DLine();
        int nop = NO.length;
        symGroup sym = trg.getSymmetryGroup();
        PiVector[] neighbor = sym.getNeighbor();
        boolean[] checked = new boolean[nop];
        int nobp = 0;
        PiVector indBoundary = new PiVector();
        int i = 0;
        while (i < nop) {
            PdVector v1;
            PdVector v0;
            PdVector sub;
            int curr = i;
            int nb = neighbor[i].m_data[1];
            if (!checked[curr] && (sub = PdVector.subNew((PdVector)(v0 = NO[curr].getVertex(0)), (PdVector)(v1 = NO[nb].getVertex(0)))).length() > 1.0E-10) {
                indBoundary.addEntry(curr);
                indBoundary.addEntry(nb);
                checked[curr] = true;
                checked[nb] = true;
                nobp += 2;
            }
            ++i;
        }
        int locnov = NO[0].getNumVertices();
        PgPolygonSet m = (PgPolygonSet)NO[0].clone();
        int i2 = 1;
        while (i2 < nop) {
            m.merge((PgGeometryIf)NO[i2]);
            ++i2;
        }
        PuCleanMesh.identifyVertices((PgPointSet)m, (double)0.01);
        checked = new boolean[nop];
        i2 = 0;
        while (i2 < nobp) {
            int curr = indBoundary.m_data[i2];
            int opp = indBoundary.m_data[(i2 + 1) % nobp];
            if (!checked[curr]) {
                int curr_s = m.getPolygon((int)curr).m_data[0];
                int opp_s = m.getPolygon((int)opp).m_data[0];
                int curr_e = m.getPolygon((int)curr).m_data[locnov - 1];
                int opp_e = m.getPolygon((int)opp).m_data[locnov - 1];
                int j = 0;
                while (j < nop) {
                    if (j != curr) {
                        PiVector p = m.getPolygon(j);
                        if (p.m_data[0] == opp_s) {
                            p.m_data[0] = curr_s;
                        }
                        if (p.m_data[locnov - 1] == opp_e) {
                            p.m_data[locnov - 1] = curr_e;
                        }
                    }
                    ++j;
                }
                checked[opp] = true;
                checked[curr] = true;
            }
            ++i2;
        }
        PdVector[] vertex = m.getVertices();
        PiVector[] polygon = m.getPolygons();
        int i3 = 0;
        while (i3 < nop) {
            NO[i3].setVertex(0, vertex[polygon[i3].getFirstEntry()]);
            NO[i3].setVertex(1, vertex[polygon[i3].getLastEntry()]);
            if (indBoundary.getIndexOf(i3) == -1) {
                NO[neighbor[i3].m_data[1]].setVertex(0, vertex[polygon[i3].getFirstEntry()]);
                NO[neighbor[i3].m_data[1]].setVertex(1, vertex[polygon[i3].getLastEntry()]);
            }
            ++i3;
        }
        symGroup m_symM_T = src.getSymM_T();
        String[] elt = m_symM_T.getElements();
        int noe = elt.length;
        nop = elt.length / 2;
        skeleton.init();
        skeleton.copy((PsObject)NO[0]);
        skeleton.setNumVertices(NO[0].getNumVertices() * nop);
        skeleton.setNumPolygons(nop);
        PiVector index = new PiVector(nop);
        boolean[] oriented = m_symM_T.getElementOrientation();
        int inde = 0;
        int i4 = 0;
        while (i4 < noe) {
            if (oriented[i4]) {
                index.m_data[inde] = i4;
                ++inde;
            }
            ++i4;
        }
        PiVector[] neighborM_T = m_symM_T.getNeighbor();
        inde = 0;
        int i5 = 0;
        while (i5 < noe) {
            if (oriented[i5]) {
                m_skNeighbor[inde] = new PiVector(2);
                m_skNeighbor[inde].m_data[0] = index.getIndexOf(neighborM_T[neighborM_T[i5].m_data[0]].m_data[1]);
                m_skNeighbor[inde].m_data[1] = index.getIndexOf(neighborM_T[neighborM_T[i5].m_data[2]].m_data[1]);
                ++inde;
            }
            ++i5;
        }
        checked = new boolean[nop];
        i5 = 0;
        while (i5 < nop) {
            PiVector nb = m_skNeighbor[i5];
            int j = 0;
            while (j < 2) {
                int a = nb.m_data[j];
                if (!checked[a]) {
                    int k = 0;
                    while (k < locnov) {
                        skeleton.setVertex(a * locnov + k, NO[index.m_data[a]].getVertex(k));
                        ++k;
                    }
                    PiVector tmp = new PiVector(locnov);
                    tmp.copy(NO[index.m_data[a]].getPolygon(0));
                    tmp.add(a * locnov);
                    skeleton.setPolygon(a, tmp);
                    checked[a] = true;
                }
                ++j;
            }
            ++i5;
        }
        PuCleanMesh.identifyVertices((PgPointSet)skeleton, (double)0.01);
        skeleton.removeUnusedVertices();
        PuHyperboloid.hyperboloidToUpperHemisphere(skeleton.getVertices());
        PuPolygonSmoothing.makeNormals(skeleton, m_skNeighbor, false);
    }
}

