/*
 * Decompiled with CFR 0.152.
 */
package devRegularMap.info;

import devRegularMap.color.PdColor;
import devRegularMap.functions.PuRMaps;
import devRegularMap.functions.symGroup;
import devRegularMap.vecmath.PuSubgroup;
import java.awt.Color;
import jv.geom.PgElementSet;
import jv.object.PsUpdateIf;
import jv.project.PjProject;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;

public class PtColors
extends PjProject {
    protected PgElementSet m_geom;
    protected int m_indCol;
    protected String[] m_stringColor;
    protected PdColor[] m_RGBcolor;
    protected Color[] m_color;
    protected PuRMaps m_rMap;
    protected int[][] m_permColor;
    protected boolean m_ispermColorSet;
    protected boolean m_isColorSet;
    protected boolean m_bH;
    protected boolean m_bgH;
    protected boolean m_bHg;
    protected boolean m_hasColor;
    protected String m_sSubGenerator;

    public PtColors() {
        super("colors");
        if (((Object)((Object)this)).getClass() == PtColors.class) {
            this.init();
        }
    }

    public boolean update(Object event) {
        if (event == this) {
            if (!this.m_hasColor) {
                this.updateColor();
                this.updateColorList();
            } else {
                this.recomputeColors(this.m_bH, this.m_bgH, this.m_bHg);
            }
            return true;
        }
        if (event == this.m_geom) {
            this.m_geom.update((Object)this.m_geom);
            return true;
        }
        int i = 0;
        while (i < this.m_RGBcolor.length) {
            if (event == this.m_RGBcolor[i]) {
                this.m_color[i] = this.m_RGBcolor[i].getColor();
                this.recomputeColors(this.m_bH, this.m_bgH, this.m_bHg);
                this.m_geom.update((Object)this.m_geom);
                this.hasColor(true);
                return true;
            }
            ++i;
        }
        return super.update(event);
    }

    public void init() {
        this.m_sSubGenerator = "r,t";
        super.init();
    }

    public void setGeometry(PgElementSet geom) {
        this.m_geom = geom;
    }

    public void setRegularMap(PuRMaps map) {
        this.m_rMap = map;
    }

    public void setSelectedColor(int type) {
        this.m_indCol = type;
    }

    public String[] getStringColor() {
        return this.m_stringColor;
    }

    public int getNumColor() {
        return this.m_RGBcolor.length;
    }

    public PgElementSet getGeometry() {
        return this.m_geom;
    }

    public PdColor[] getColors() {
        return this.m_RGBcolor;
    }

    public void setGeneratorH(String gen) {
        this.m_rMap.getSymmetryGroup().setGeneratorH(gen);
        this.m_sSubGenerator = gen;
    }

    public void updateColor() {
        this.setPermColorSet(false);
        this.computColorPermutation();
        this.initColor();
        this.recomputeColors(this.m_bH, this.m_bgH, this.m_bHg);
    }

    public void showSubgroup() {
        this.computColorPermutation();
        if (!this.m_isColorSet) {
            this.initColor();
            this.isColorSet(true);
        }
        symGroup M_S = this.m_rMap.getSymmetryGroup();
        String[] elt = M_S.getElements();
        int index = -1;
        Color red = Color.red;
        red.brighter();
        PiVector[] tri = new PiVector[]{};
        boolean flag = true;
        tri = this.m_geom.getElements();
        int geomnoe = this.m_geom.getNumElements();
        int i = 0;
        while (i < geomnoe) {
            int label = Integer.parseInt(tri[i].getName().split(",")[0]);
            String rep = elt[label];
            index = PuSubgroup.getIndexOfEltInG(rep, this.m_permColor, "rst", flag);
            if (index == 0) {
                this.m_geom.setElementColor(i, this.m_color[0]);
            } else {
                this.m_geom.setElementColor(i, Color.gray);
            }
            ++i;
        }
    }

    public void setPermColorSet(boolean state) {
        this.m_ispermColorSet = state;
    }

    public void isColorSet(boolean state) {
        this.m_isColorSet = state;
    }

    public void updateColorList() {
        int numCol = this.m_permColor[0].length;
        this.m_RGBcolor = new PdColor[numCol];
        int i = 0;
        while (i < numCol) {
            this.m_RGBcolor[i] = new PdColor("" + i, (PsUpdateIf)this);
            this.m_RGBcolor[i].setColor(this.m_color[i]);
            ++i;
        }
    }

    public void computeColorSymmetry() {
        String gen = this.m_sSubGenerator;
        String[] lsub = this.m_rMap.getLowIndexSubGroup(gen);
        int len = 0;
        while (lsub[len] != null) {
            ++len;
        }
        this.m_stringColor = new String[len];
        double[] val = new double[len];
        int[] index = new int[len];
        int i = 0;
        while (i < len) {
            String[] tmp = lsub[i].split("\\(");
            String[] tmp0 = tmp[1].split("\\s+");
            val[i] = Integer.parseInt(tmp0[0]);
            ++i;
        }
        PuMath.heapsort((int)len, (double[])val, (int[])index);
        i = 0;
        while (i < len) {
            this.m_stringColor[i] = lsub[index[i]];
            ++i;
        }
    }

    public void initColor() {
        int numCol = this.m_permColor[0].length;
        this.m_color = new Color[numCol];
        int j = 0;
        while (j < numCol) {
            this.m_color[j] = Color.getHSBColor((float)Math.asin((float)j / (float)numCol), 0.4f, 1.0f);
            ++j;
        }
    }

    public boolean getStateH() {
        return this.m_bH;
    }

    public boolean getStategH() {
        return this.m_bgH;
    }

    public boolean getStateHg() {
        return this.m_bHg;
    }

    public void recomputeColors(boolean bH, boolean bgH, boolean bHg) {
        block9: {
            block10: {
                block8: {
                    if (!bH) break block8;
                    this.computColorPermutation();
                    if (!this.m_isColorSet) {
                        this.initColor();
                        this.isColorSet(true);
                    }
                    symGroup M_S = this.m_rMap.getSymmetryGroup();
                    String[] elt = M_S.getElements();
                    int index = -1;
                    Color red = Color.red;
                    red.brighter();
                    PiVector[] tri = new PiVector[]{};
                    boolean flag = false;
                    tri = this.m_geom.getElements();
                    int geomnoe = this.m_geom.getNumElements();
                    int i = 0;
                    while (i < geomnoe) {
                        int label = Integer.parseInt(tri[i].getName().split(",")[0]);
                        String rep = elt[label];
                        index = PuSubgroup.getIndexOfEltInG(rep, this.m_permColor, "rst", flag);
                        if (index == 0) {
                            this.m_geom.setElementColor(i, this.m_color[0]);
                        } else {
                            this.m_geom.setElementColor(i, Color.gray);
                        }
                        ++i;
                    }
                    break block9;
                }
                if (!bgH) break block10;
                this.computColorPermutation();
                if (!this.m_isColorSet) {
                    this.initColor();
                    this.isColorSet(true);
                }
                symGroup sym = this.m_rMap.getSymmetryGroup();
                String[] elt = sym.getElements();
                PiVector[] tri = this.m_geom.getElements();
                int index = -1;
                PiVector lcol = new PiVector();
                lcol.setEntry(0, -1);
                int geomnoe = this.m_geom.getNumElements();
                int i = 0;
                while (i < geomnoe) {
                    int label = Integer.parseInt(tri[i].getName().split(",")[0]);
                    String rep = elt[label];
                    index = PuSubgroup.getIndexOfEltInG(rep, this.m_permColor, "rst", true);
                    this.m_geom.setElementColor(i, this.m_color[index]);
                    ++i;
                }
                break block9;
            }
            if (!bHg) break block9;
            this.computColorPermutation();
            if (!this.m_isColorSet) {
                this.initColor();
                this.isColorSet(true);
            }
            symGroup sym = this.m_rMap.getSymmetryGroup();
            String[] elt = sym.getElements();
            PiVector[] tri = this.m_geom.getElements();
            int index = -1;
            PiVector lcol = new PiVector();
            lcol.setEntry(0, -1);
            int geomnoe = this.m_geom.getNumElements();
            int i = 0;
            while (i < geomnoe) {
                int label = Integer.parseInt(tri[i].getName().split(",")[0]);
                String rep = elt[label];
                index = PuSubgroup.getIndexOfEltInG(rep, this.m_permColor, "rst", false);
                this.m_geom.setElementColor(i, this.m_color[index]);
                ++i;
            }
        }
    }

    public void computColorPermutation() {
        symGroup M_S = this.m_rMap.getSymmetryGroup();
        String[] G = new String[]{"group name:g;", "group generators:rst;", "group relators:" + M_S.getRelators()};
        PuSubgroup.setGroup(G);
        if (!this.m_ispermColorSet) {
            this.m_permColor = PuSubgroup.getSubGroupPermutation(this.m_sSubGenerator);
            this.m_ispermColorSet = true;
        }
    }

    public void setVisible(boolean bH, boolean bgH, boolean bHg) {
        this.m_bH = bH;
        this.m_bgH = bgH;
        this.m_bHg = bHg;
    }

    public void hasColor(boolean b) {
        this.m_hasColor = b;
    }
}

