/*
 * Decompiled with CFR 0.152.
 */
package devRegularMap.info;

import devRegularMap.functions.PgGon;
import devRegularMap.functions.PuRMaps;
import devRegularMap.functions.symGroup;
import devRegularMap.grid.PwPutGrid;
import devRegularMap.vecmath.PuCompGeometry;
import devRegularMap.vecmath.PuHyperboloid;
import devRegularMap.vecmath.PuIsometry;
import devRegularMap.vecmath.PuSubgroup;
import devRegularMap.vecmath.PuUniCover;
import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PuCleanMesh;
import jv.number.PuBoolean;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class Pt4gGon
extends PjProject {
    protected PuBoolean m_cUcover;
    protected PuBoolean m_c4gGon;
    protected PuBoolean m_cIvertex;
    protected PgElementSet m_uniCover;
    protected PgElementSet m_2D;
    protected PgGon m_geom;
    protected PgGon m_4gGon;
    protected PgGon m_4gGonL;
    protected PuRMaps m_rMaps;
    protected int m_discr = 8;
    protected int m_layer = 3;
    protected boolean m_4gGonIsComputed;

    public Pt4gGon() {
        super(" ");
        if (((Object)((Object)this)).getClass() == Pt4gGon.class) {
            this.init();
        }
    }

    public void init() {
        this.m_cUcover = new PuBoolean("Ucover");
        this.m_c4gGon = new PuBoolean("4g-gon");
        this.m_cIvertex = new PuBoolean("I vertex");
        this.m_2D = new PgElementSet(3);
        this.m_uniCover = new PgElementSet(3);
        this.m_geom = new PgGon();
        super.init();
    }

    public boolean update(Object event) {
        if (event == this) {
            if (this.m_c4gGon.getState()) {
                this.compute4gGon();
                this.init4gGon(true);
            }
            if (this.m_cUcover.getState() && this.m_rMaps.getGenus() > 1) {
                this.computeUniCover();
            }
            this.update((Object)this.m_geom);
            return true;
        }
        if (event == this.m_geom) {
            this.m_4gGon.copy((PsObject)this.m_geom);
            this.m_4gGonL.copy((PsObject)this.m_geom);
            if (this.m_rMaps.getGenus() > 1) {
                PwPutGrid.refinePolygonSetHalf(this.m_4gGon, 12);
                PuHyperboloid.hyperboloidToPoincare(this.m_4gGonL.getVertices());
                PuHyperboloid.hyperboloidToPoincare(this.m_4gGon.getVertices());
            }
            int i = 0;
            while (i < this.m_4gGonL.getNumVertices()) {
                this.m_4gGonL.setVertexSize(i, 2.0);
                this.m_4gGon.setVertexSize(i, 0.0);
                ++i;
            }
            this.m_4gGonL.showVertexSizes(true);
            this.m_4gGonL.showEdgeLabels(true);
            this.m_4gGonL.setGlobalPolygonSize(0.0);
            this.m_4gGonL.showVertexColors(true);
            this.m_4gGon.showPolygonEndArrow(true);
            this.m_4gGon.showVertices(false);
            this.m_4gGon.setGlobalPolygonSize(1.5);
            this.m_4gGon.update((Object)this.m_4gGon);
            this.m_4gGonL.update((Object)this.m_4gGonL);
            return true;
        }
        if (event == this.m_uniCover) {
            this.computeUniCover();
            return true;
        }
        return super.update(event);
    }

    public void setGeometry(PgGon geom) {
        this.m_geom = geom;
    }

    public void setDisplayGeometries(PgGon gon, PgGon gonL, PgElementSet uni) {
        this.m_4gGon = gon;
        this.m_4gGonL = gonL;
        this.m_uniCover = uni;
    }

    public void init4gGon(boolean flag) {
        this.m_4gGonIsComputed = flag;
    }

    public void setRegularMap(PuRMaps map) {
        this.m_rMaps = map;
    }

    public void setBooleans(PuBoolean bUniCover, PuBoolean bShow4gGon) {
        this.m_cUcover = bUniCover;
        this.m_c4gGon = bShow4gGon;
    }

    public void setEnabledUniCover(boolean flag) {
        this.m_cUcover.setState(flag);
    }

    public void setEnabled4gGon(boolean flag) {
        this.m_c4gGon.setState(flag);
    }

    public void compute4gGon() {
        this.generateTriG();
        PiVector[] neighbor = this.m_2D.getNeighbours();
        int noe = neighbor.length;
        int nobF = 0;
        int i = 0;
        while (i < noe) {
            if (neighbor[i].getIndexOf(-1) != -1) {
                ++nobF;
            }
            ++i;
        }
        this.m_geom.init();
        this.m_geom.setNumPolygons(nobF /= 2);
        this.m_geom.setNumVertices(nobF);
        String[] name = new String[nobF];
        int i2 = 0;
        while (i2 < nobF) {
            name[i2] = "" + i2;
            ++i2;
        }
        symGroup sym = this.m_rMaps.getSymmetryGroup();
        int nopgon = sym.getCosetElements().length;
        int p = sym.getParameters().m_data[2];
        String[] coset = sym.getCosetElements();
        int[][] rRsSt = sym.getPermutation();
        int numEltG = sym.getNumElements();
        String rep = "";
        String[] nb = new String[p];
        String s = "";
        int i3 = 0;
        while (i3 < p) {
            nb[i3] = s;
            s = String.valueOf(s) + "r";
            ++i3;
        }
        int index = -1;
        int indv = 0;
        int indp = 0;
        int inds = 0;
        boolean[] identified = new boolean[numEltG];
        PdVector[] vertex = this.m_2D.getVertices();
        PiVector[] elt = this.m_2D.getElements();
        int i4 = 0;
        while (i4 < nopgon) {
            String inv = PuIsometry.getInverseStringElt(coset[i4], "rst");
            int j = 0;
            while (j < p) {
                rep = String.valueOf(inv) + nb[j];
                index = PuSubgroup.getIndexOfEltInG(rep, rRsSt, "rst", false);
                if (neighbor[index].m_data[2] == -1 && !identified[index]) {
                    PdVector N = vertex[elt[index].m_data[0]];
                    String nrep = String.valueOf(rep) + "rt";
                    index = PuSubgroup.getIndexOfEltInG(nrep, rRsSt, "rst", false);
                    PdVector Nrt = vertex[elt[index].m_data[0]];
                    this.m_geom.setVertex(indv, N);
                    this.m_geom.setVertex(indv + 1, Nrt);
                    this.m_geom.setPolygon(indp, indv, indv + 1);
                    this.m_geom.getPolygon(indp).setName(name[inds]);
                    indv += 2;
                    ++indp;
                    nrep = String.valueOf(rep) + "rs";
                    index = PuSubgroup.getIndexOfEltInG(nrep, rRsSt, "rst", false);
                    identified[index] = true;
                    N = vertex[elt[index].m_data[0]];
                    nrep = String.valueOf(nrep) + "rt";
                    index = PuSubgroup.getIndexOfEltInG(nrep, rRsSt, "rst", false);
                    Nrt = vertex[elt[index].m_data[0]];
                    this.m_geom.setVertex(indv, N);
                    this.m_geom.setVertex(indv + 1, Nrt);
                    this.m_geom.setPolygon(indp, indv + 1, indv);
                    this.m_geom.getPolygon(indp).setName(name[inds]);
                    indv += 2;
                    ++indp;
                    ++inds;
                }
                ++j;
            }
            ++i4;
        }
        PiVector[] piVectorArray = this.m_geom.getPolygons();
        int n = piVectorArray.length;
        int n2 = 0;
        while (n2 < n) {
            PiVector v = piVectorArray[n2];
            if (v.getSize() == 0) {
                v.setTag(2);
            }
            ++n2;
        }
        this.m_geom.removeMarkedPolygons();
        PuCleanMesh.identifyVertices((PgPointSet)this.m_geom, (double)0.01);
        this.m_geom.makeNeighbor();
        this.computeIvertices();
    }

    public void generateTriG() {
        PgElementSet[] tile = this.m_rMaps.getPatchTri2D();
        this.m_2D.copy((PsObject)tile[0]);
        int i = 1;
        while (i < tile.length) {
            this.m_2D.merge((PgGeometryIf)tile[i]);
            ++i;
        }
        PuCleanMesh.identifyVertices((PgPointSet)this.m_2D, (double)0.001);
        this.m_2D.makeNeighbour();
    }

    public void computeIvertices() {
        int nop = this.m_geom.getNumPolygons();
        int nov = this.m_geom.getNumVertices();
        PiVector[] polygon = this.m_geom.getPolygons();
        Color[] m_col = new Color[nov];
        int[] m_number = new int[nov];
        int i = 0;
        while (i < nov) {
            m_col[i] = new Color((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0));
            ++i;
        }
        PiVector[] neighbor = this.m_geom.getNeighbors();
        boolean[] visited = new boolean[nov];
        boolean[] visitedPol = new boolean[nop];
        int indCol = 0;
        boolean back = false;
        int[] process = new int[nop];
        process[0] = 0;
        int next = 1;
        int i2 = 0;
        while (i2 < nop) {
            int cnext;
            PiVector cpol = polygon[process[i2]];
            int j = 0;
            while (j < 2) {
                int v = cpol.m_data[j];
                if (!visited[v]) {
                    this.m_geom.setVertexColor(v, m_col[indCol]);
                    m_number[v] = indCol;
                    visited[v] = true;
                    back = false;
                    int s = j;
                    int cur = process[i2];
                    int start = v;
                    while (!back) {
                        cnext = neighbor[cur].m_data[s];
                        int opp = neighbor[cnext].m_data[2];
                        int ind = neighbor[cnext].getIndexOf(cur);
                        if (ind == 0) {
                            v = polygon[opp].m_data[0];
                            s = 0;
                        } else {
                            v = polygon[opp].m_data[1];
                            s = 1;
                        }
                        visited[v] = true;
                        this.m_geom.setVertexColor(v, m_col[indCol]);
                        m_number[v] = indCol;
                        cur = opp;
                        if (v != start) continue;
                        back = true;
                    }
                    ++indCol;
                }
                ++j;
            }
            visitedPol[process[i2]] = true;
            if (next < nov - 1) {
                cnext = neighbor[process[i2]].m_data[1];
                int cprev = neighbor[process[i2]].m_data[0];
                if (!visitedPol[cnext]) {
                    process[next] = cnext;
                    ++next;
                }
                if (!visitedPol[cprev]) {
                    process[next] = cprev;
                    ++next;
                }
            }
            ++i2;
        }
    }

    public void normalization() {
        while (this.normalizationStep1()) {
            this.normalizationStep2();
        }
    }

    public int multPol() {
        int cur = 0;
        boolean found = false;
        Color[] col = this.m_geom.getVertexColors();
        int nop = this.m_geom.getNumPolygons();
        while (!found) {
            PiVector start = this.m_geom.getPolygon(cur);
            if (col[start.m_data[0]] == col[0] && col[start.m_data[1]] != col[0] || col[start.m_data[1]] == col[0] && col[start.m_data[0]] != col[0]) {
                found = true;
            } else {
                ++cur;
            }
            if (cur > nop - 1) break;
        }
        if (found) {
            return cur;
        }
        return -1;
    }

    public void reductionStep() {
        PiVector[] polygon = this.m_geom.getPolygons();
        PiVector[] neighbor = this.m_geom.getNeighbors();
        int genus = this.m_rMaps.getGenus();
        int cur = this.multPol();
        if (cur != -1) {
            int cp = neighbor[cur].m_data[0];
            int cn = neighbor[cur].m_data[1];
            int co = neighbor[cur].m_data[2];
            int con = neighbor[co].m_data[1];
            int cop = neighbor[co].m_data[0];
            if (polygon[cn].getName().equals(polygon[con].getName()) && co != cn && cn != con) {
                this.reduce1(cur);
            } else if (polygon[cp].getName().equals(polygon[cop].getName()) && co != cp && cp != cop) {
                int tmp = polygon[cur].m_data[0];
                polygon[cur].m_data[0] = polygon[cur].m_data[1];
                polygon[cur].m_data[1] = tmp;
                tmp = polygon[co].m_data[0];
                polygon[co].m_data[0] = polygon[co].m_data[1];
                polygon[co].m_data[1] = tmp;
                tmp = neighbor[cur].m_data[0];
                neighbor[cur].m_data[0] = neighbor[cur].m_data[1];
                neighbor[cur].m_data[1] = tmp;
                tmp = neighbor[co].m_data[0];
                neighbor[co].m_data[0] = neighbor[co].m_data[1];
                neighbor[co].m_data[1] = tmp;
                this.reduce1(cur);
            } else if (genus > 1) {
                this.reduce2(cur);
            }
        } else {
            this.init4gGon(true);
            return;
        }
        this.m_geom.removeMarkedPolygons();
        this.m_geom.removeUnusedVertices();
    }

    public void reduction() {
        int cur = this.multPol();
        int genus = this.m_rMaps.getGenus();
        while (cur != -1) {
            PiVector[] polygon = this.m_geom.getPolygons();
            PiVector[] neighbor = this.m_geom.getNeighbors();
            int cp = neighbor[cur].m_data[0];
            int cn = neighbor[cur].m_data[1];
            int co = neighbor[cur].m_data[2];
            int con = neighbor[co].m_data[1];
            int cop = neighbor[co].m_data[0];
            if (polygon[cn].getName().equals(polygon[con].getName()) && co != cn && cn != con) {
                this.reduce1(cur);
            } else if (polygon[cp].getName().equals(polygon[cop].getName()) && co != cp && cp != cop) {
                int tmp = polygon[cur].m_data[0];
                polygon[cur].m_data[0] = polygon[cur].m_data[1];
                polygon[cur].m_data[1] = tmp;
                tmp = polygon[co].m_data[0];
                polygon[co].m_data[0] = polygon[co].m_data[1];
                polygon[co].m_data[1] = tmp;
                tmp = neighbor[cur].m_data[0];
                neighbor[cur].m_data[0] = neighbor[cur].m_data[1];
                neighbor[cur].m_data[1] = tmp;
                tmp = neighbor[co].m_data[0];
                neighbor[co].m_data[0] = neighbor[co].m_data[1];
                neighbor[co].m_data[1] = tmp;
                this.reduce1(cur);
            } else if (genus > 1) {
                this.reduce2(cur);
            }
            cur = this.multPol();
        }
    }

    public void reduce1(int a) {
        PiVector[] polygon = this.m_geom.getPolygons();
        PiVector[] neighbor = this.m_geom.getNeighbors();
        int an = neighbor[a].m_data[1];
        int ao = neighbor[a].m_data[2];
        int ann = neighbor[an].m_data[1];
        int aon = neighbor[ao].m_data[1];
        int aonn = neighbor[aon].m_data[1];
        int ind = (this.m_geom.getLocIndVert(an, a) + 1) % 2;
        polygon[a].m_data[1] = polygon[an].m_data[ind];
        polygon[ao].m_data[1] = polygon[aon].m_data[ind];
        neighbor[a].m_data[1] = ann;
        ind = this.m_geom.getLocIndVert(ann, an);
        neighbor[ann].m_data[ind] = a;
        neighbor[ao].m_data[1] = aonn;
        ind = this.m_geom.getLocIndVert(aonn, aon);
        neighbor[aonn].m_data[ind] = ao;
        polygon[an].setTag(2);
        polygon[aon].setTag(2);
        this.m_geom.removeMarkedPolygons();
        this.m_geom.removeUnusedVertices();
        this.m_geom.makeNeighbor();
    }

    public void reduce2(int a) {
        int nov = this.m_geom.getNumVertices();
        PiVector[] neighbor = this.m_geom.getNeighbors();
        this.m_geom.setNumVertices(nov + 1);
        int an = neighbor[a].m_data[1];
        int ind = this.m_geom.getLocIndVert(an, a);
        this.cutAndPaste(a, 0, an, (ind + 1) % 2, an, this.m_geom.getOpposite(an));
    }

    public boolean normalizationStep1() {
        PiVector alternateInd = new PiVector(2);
        if (this.searchForAlternateLabel(alternateInd)) {
            int a = alternateInd.m_data[0];
            int b = alternateInd.m_data[1];
            int bo = this.m_geom.getOpposite(b);
            int ao = this.m_geom.getOpposite(a);
            if (this.m_geom.scanPrev(a)) {
                this.m_geom.giveSameOrientation(ao, this.m_geom.getPrev(a));
                this.m_geom.setStart(this.m_geom.getOpposite(a));
            } else if (this.m_geom.scanNext(a)) {
                this.m_geom.giveSameOrientation(a, this.m_geom.getNext(a));
                this.m_geom.setStart(a);
            } else {
                PdVector O = new PdVector(1.0, 0.0, 0.0);
                this.cutAndPaste(a, 1, ao, 1, b, bo, O);
                this.m_geom.setStart(a);
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean normalizationStep2() {
        int a = this.m_geom.getStart();
        int ao = this.m_geom.getOpposite(a);
        int b = this.m_geom.getNext(a);
        int bo = this.m_geom.getOpposite(b);
        PdVector O = new PdVector(1.0, 0.0, 0.0);
        if (!this.m_geom.isNormalized(a)) {
            this.cutAndPaste(b, 1, bo, 1, ao, a, O);
        }
        return true;
    }

    public boolean searchForAlternateLabel(PiVector alt) {
        PiVector[] neighbor = this.m_geom.getNeighbors();
        PiVector[] polygon = this.m_geom.getPolygons();
        int nop = this.m_geom.getNumVertices();
        int i = 0;
        while (i < nop) {
            boolean found = false;
            int c = i;
            int cn = this.m_geom.getNext(c);
            if (!polygon[c].hasTag(0)) {
                int ind = 0;
                int a = c;
                int an = cn;
                while (!found && ind < nop) {
                    if (neighbor[an].m_data[1] == a) {
                        a = an;
                        an = neighbor[an].m_data[0];
                    } else {
                        a = an;
                        an = neighbor[an].m_data[1];
                    }
                    if (!polygon[a].hasTag(0)) {
                        found = this.check(c, a);
                    }
                    ++ind;
                }
                if (found) {
                    alt.m_data[0] = c;
                    alt.m_data[1] = a;
                    polygon[c].setTag(0);
                    polygon[a].setTag(0);
                    polygon[neighbor[c].m_data[2]].setTag(0);
                    polygon[neighbor[a].m_data[2]].setTag(0);
                    return !this.m_geom.isNormalized(c);
                }
            }
            ++i;
        }
        return false;
    }

    public boolean check(int a, int b) {
        int nop = this.m_geom.getNumPolygons();
        int ao = this.m_geom.getOpposite(a);
        int bo = this.m_geom.getOpposite(b);
        int[] index = new int[nop];
        int i = 0;
        while (i < nop) {
            index[i] = 0;
            ++i;
        }
        index[a] = 1;
        index[ao] = 1;
        index[b] = 1;
        index[bo] = 1;
        int count = 0;
        int ind = 0;
        int org = a;
        while (a != ao) {
            a = this.m_geom.followNextBy(org, ind);
            count += index[a];
            if (++ind <= 100) continue;
            System.err.println("Check does not return, check neighbor");
            return false;
        }
        return count == 3;
    }

    public void cutAndPaste(int a, int inda, int b, int indb, int c, int d, PdVector v) {
        this.cut(a, inda, b, indb);
        PiVector c_comp = this.getComponent(c, this.m_geom.getPrev(c));
        if (this.isPointInsideComponent(v, c_comp)) {
            this.paste(d, c);
        } else {
            this.paste(c, d);
        }
    }

    public boolean isPointInsideComponent(PdVector v, PiVector comp) {
        int nov = comp.getSize();
        PdVector[] pos = new PdVector[nov];
        PiVector[] pol = this.m_geom.getPolygons();
        boolean[] check = new boolean[this.m_geom.getNumVertices()];
        int ind = 0;
        int i = 0;
        while (i < nov) {
            int j = 0;
            while (j < 2) {
                int indVert = pol[comp.m_data[i]].m_data[j];
                if (!check[indVert]) {
                    pos[ind] = this.m_geom.getVertex(indVert);
                    check[indVert] = true;
                    ++ind;
                }
                ++j;
            }
            ++i;
        }
        PuCompGeometry.checkCCW(pos);
        return PuCompGeometry.isInsidePolygon(v, pos, true);
    }

    public void cutAndPaste(int a, int inda, int b, int indb, int c, int d) {
        this.cut(a, inda, b, indb);
        this.paste(c, d);
    }

    public void cut(int a, int inda, int b, int indb) {
        PiVector[] polygon = this.m_geom.getPolygons();
        PdVector v1 = (PdVector)this.m_geom.getVertex(polygon[a].m_data[inda]).clone();
        PdVector v2 = (PdVector)this.m_geom.getVertex(polygon[b].m_data[indb]).clone();
        int nov = this.m_geom.getNumVertices();
        int nop = this.m_geom.getNumPolygons();
        this.m_geom.setNumVertices(nov + 2);
        this.m_geom.setVertex(nov, v1);
        this.m_geom.setVertex(nov + 1, v2);
        this.m_geom.setVertexColor(nov, this.m_geom.getVertexColor(polygon[a].m_data[inda]));
        this.m_geom.setVertexColor(nov + 1, this.m_geom.getVertexColor(polygon[b].m_data[indb]));
        PiVector newc = new PiVector(2);
        PiVector newco = new PiVector(2);
        newc.m_data[0] = polygon[a].m_data[inda];
        newc.m_data[1] = polygon[b].m_data[indb];
        newco.m_data[0] = nov;
        newco.m_data[1] = nov + 1;
        this.m_geom.setNumPolygons(nop + 2);
        this.m_geom.setPolygon(nop, newc);
        this.m_geom.setPolygon(nop + 1, newco);
        this.m_geom.getPolygon(nop).setName("-1");
        this.m_geom.getPolygon(nop + 1).setName("-1");
        boolean orient = this.m_geom.hasSameOrientation(a, b);
        int ind = -1;
        int bn = this.m_geom.getNext(b);
        int an = this.m_geom.getNext(a);
        int bp = this.m_geom.getPrev(b);
        int ap = this.m_geom.getPrev(a);
        if (!orient) {
            if (indb == inda) {
                if (indb == 0) {
                    ind = this.m_geom.getLocIndVert(ap, a);
                    polygon[ap].m_data[ind] = nov;
                    ind = this.m_geom.getLocIndVert(bp, b);
                    polygon[bp].m_data[ind] = nov + 1;
                } else if (indb == 1) {
                    ind = this.m_geom.getLocIndVert(bn, b);
                    polygon[bn].m_data[ind] = nov + 1;
                    ind = this.m_geom.getLocIndVert(an, a);
                    polygon[an].m_data[ind] = nov;
                }
            } else if (indb != inda) {
                if (indb == 0 && inda == 1) {
                    ind = this.m_geom.getLocIndVert(an, a);
                    polygon[an].m_data[ind] = nov;
                    polygon[b].m_data[ind] = nov + 1;
                } else if (indb == 1 && inda == 0) {
                    polygon[a].m_data[ind] = nov;
                    ind = this.m_geom.getLocIndVert(bn, b);
                    polygon[bn].m_data[ind] = nov + 1;
                }
            }
        } else if (indb == inda) {
            if (indb == 0) {
                polygon[a].m_data[ind] = nov;
                ind = this.m_geom.getLocIndVert(bp, b);
                polygon[bp].m_data[ind] = nov + 1;
            } else if (indb == 1) {
                ind = this.m_geom.getLocIndVert(an, a);
                polygon[an].m_data[ind] = nov;
                polygon[b].m_data[ind] = nov + 1;
            }
        } else if (indb != inda) {
            if (indb == 0 && inda == 1) {
                ind = this.m_geom.getLocIndVert(an, a);
                polygon[an].m_data[ind] = nov;
                ind = this.m_geom.getLocIndVert(bp, b);
                polygon[bp].m_data[ind] = nov + 1;
            } else if (indb == 1 && inda == 0) {
                ind = this.m_geom.getLocIndVert(ap, a);
                polygon[ap].m_data[ind] = nov;
                ind = this.m_geom.getLocIndVert(bn, b);
                polygon[bn].m_data[ind] = nov + 1;
            }
        }
        this.m_geom.makeNeighbor();
    }

    public void paste(int c, int d) {
        if (this.isInSameComponent(c, d)) {
            PsDebug.message((String)"The two polygons are in the same component");
        } else {
            PiVector[] polygon = this.m_geom.getPolygons();
            PdVector[] vertex = this.m_geom.getVertices();
            int nov = this.m_geom.getNumVertices();
            PdMatrix T1 = PuHyperboloid.mapToCoshCurve(vertex[polygon[c].m_data[0]], vertex[polygon[c].m_data[1]]);
            PdMatrix T2 = PuHyperboloid.mapToCoshCurve(vertex[polygon[d].m_data[0]], vertex[polygon[d].m_data[1]]);
            T2.invert();
            T1.leftMult(T2);
            PiVector pol = this.getComponent(c, this.m_geom.getPrev(c));
            int len = pol.getSize();
            boolean[] checked = new boolean[nov];
            int i = 0;
            while (i < len) {
                PiVector cPol = this.m_geom.getPolygon(pol.m_data[i]);
                int j = 0;
                while (j < 2) {
                    if (!checked[cPol.m_data[j]]) {
                        vertex[cPol.m_data[j]].leftMultMatrix(T1);
                        checked[cPol.m_data[j]] = true;
                    }
                    ++j;
                }
                ++i;
            }
            int cp = this.m_geom.getPrev(c);
            int cn = this.m_geom.getNext(c);
            polygon = this.m_geom.getPolygons();
            int ind = this.m_geom.getLocIndVert(cp, c);
            polygon[cp].m_data[ind] = polygon[d].m_data[0];
            ind = this.m_geom.getLocIndVert(cn, c);
            polygon[cn].m_data[ind] = polygon[d].m_data[1];
            this.m_geom.getPolygon(c).setTag(2);
            this.m_geom.getPolygon(d).setTag(2);
            String label = this.m_geom.getPolygon(c).getName();
            PiVector[] piVectorArray = this.m_geom.getPolygons();
            int n = piVectorArray.length;
            int n2 = 0;
            while (n2 < n) {
                PiVector p = piVectorArray[n2];
                if (p.getName() == "-1") {
                    p.setName(label);
                }
                ++n2;
            }
            this.m_geom.removeMarkedPolygons();
            this.m_geom.setStart(0);
            this.m_geom.makeNeighbor();
            this.m_geom.removeUnusedVertices();
        }
    }

    public boolean isInSameComponent(int c, int d) {
        int cur = -1;
        int ind = 1;
        while (cur != c) {
            cur = this.m_geom.followNextBy(c, ind);
            if (cur == d) {
                return true;
            }
            ++ind;
        }
        return false;
    }

    public PiVector getComponent(int a, int b) {
        PiVector pol = new PiVector();
        pol.addEntry(a);
        this.m_geom.setStart(a);
        int an = this.m_geom.getNext(a);
        int ind = 1;
        while (an != b) {
            an = this.m_geom.followNextBy(ind);
            pol.addEntry(an);
            ++ind;
        }
        return pol;
    }

    public String read() {
        int a = this.m_geom.getStart();
        int an = this.m_geom.getNext(a);
        String label = this.m_geom.getPolygon(a).getName();
        int ind = 2;
        while (an != a) {
            String tmp = this.m_geom.getPolygon(an).getName();
            if (tmp.length() > 1) {
                tmp = "(" + tmp + ")";
            }
            label = String.valueOf(label) + tmp;
            an = this.m_geom.followNextBy(ind);
            ++ind;
        }
        return label;
    }

    public void computeUniCover() {
        PuUniCover uni = this.m_rMaps.getSymmetryGroup().getUniversalCover();
        this.m_uniCover.copy((PsObject)uni.getTesselation(this.m_layer));
    }
}

