/*
 * Decompiled with CFR 0.152.
 */
package devRegularMap.groups;

import devRegularMap.groups.symGroup;
import devRegularMap.number.PsVector;
import devRegularMap.smoothing.PuPolygonSmoothing;
import devRegularMap.vecmath.PuCompGeometry;
import devRegularMap.vecmath.PuHyperbolic;
import devRegularMap.vecmath.PuHyperboloid;
import devRegularMap.vecmath.PuIsometry;
import devRegularMap.vecmath.PuSpherical;
import devRegularMap.vecmath.PuSubgroup;
import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygonSet;
import jv.geom.PuCleanMesh;
import jv.object.PsObject;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jv.vecmath.PuVectorGeom;
import jvx.geom.PwCleanMesh;

public class RMap {
    protected PiVector m_sparam;
    public static final String TYPE_111 = "F111";
    public static final String TYPE_121 = "F121";
    public static final String TYPE_211 = "F211";
    protected String m_ftype;
    protected RMap m_targetMap;
    protected symGroup m_symM_S;
    protected PgElementSet[] m_tri2DM_S;
    protected PgElementSet[] m_tri3DM_S;
    protected PgPolygonSet[] m_NO;
    protected PgElementSet m_target3DQtube;
    protected PgElementSet[] m_target2Dtube;
    protected boolean m_dual;
    protected PgElementSet m_fundPatch;
    protected PgElementSet[] m_tubeEdge;
    protected PgPolygonSet m_NOLines2D;
    protected PgPolygonSet m_NOLines3D;
    protected PgPolygonSet m_NOLinesFqtube;
    protected PdVector m_M;
    protected PdVector m_N;
    protected PdVector m_O;
    protected PdVector[] m_vertex;
    protected PdMatrix[] m_isometry;
    protected PgPolygonSet m_skeleton;
    protected PiVector[] m_skNeighbor;
    protected boolean m_hasTargetQtube;
    protected boolean m_hasSkeleton;
    protected boolean m_hasFundQtube;
    protected symGroup m_symM_T;
    protected symGroup m_symS_g;
    protected String[] m_gen;
    protected String[] m_lowIndexSub;
    protected static double m_tubeRadius;
    protected static int m_discr;
    protected static PvDisplayIf m_display;

    public RMap(PiVector param, RMap targetMap, String[] gen, boolean flag, String type) {
        this.m_sparam = param;
        this.m_targetMap = targetMap;
        this.m_dual = flag;
        this.m_gen = gen;
        this.m_ftype = type;
        this.init();
    }

    public static void setTubeRadius(double r) {
        m_tubeRadius = r;
    }

    public static void setNumSample(int discr) {
        m_discr = discr;
    }

    private void init() {
        this.m_symM_S = new symGroup(this.m_sparam, "rst", this.m_dual);
        if (this.m_targetMap != null) {
            this.m_symM_T = new symGroup(this.m_targetMap.getParameters(), "rst", this.m_targetMap.isDual());
            this.m_symS_g = new symGroup(this.m_targetMap.getParameters(), "abc", this.m_targetMap.isDual());
        } else {
            this.m_symS_g = new symGroup(this.m_sparam, "abc", false);
        }
        int noe = this.m_symM_S.getNumElements();
        int noqt = this.m_symS_g.getNumElements();
        this.m_tri2DM_S = new PgElementSet[noe];
        this.m_tri3DM_S = new PgElementSet[noqt];
        this.m_NO = new PgPolygonSet[noe];
        this.m_target3DQtube = new PgElementSet(3);
        this.m_target2Dtube = new PgElementSet[this.m_symS_g.getNumElements()];
        this.m_tubeEdge = new PgElementSet[this.m_symM_S.getNumElements()];
        this.m_fundPatch = new PgElementSet(3);
        this.m_skeleton = new PgPolygonSet(3);
        this.m_skNeighbor = new PiVector[noe / 2];
        this.m_NOLines2D = new PgPolygonSet(3);
        this.m_NOLines3D = new PgPolygonSet(3);
        this.m_NOLinesFqtube = new PgPolygonSet(3);
        this.m_skeleton.setName("Skeleton");
        this.initializeIsometry();
        this.makeVertexArray();
    }

    private void makeVertexArray() {
        if (this.m_targetMap == null) {
            this.makePlanarTileKnown();
        } else {
            this.makePlanarTile();
        }
        int nov = 3 * this.m_symM_S.getNumElements();
        this.m_vertex = new PdVector[nov];
        int ind = 0;
        int i = 0;
        while (i < this.m_tri2DM_S.length) {
            int j = 1;
            while (j < 2) {
                this.m_vertex[ind] = this.m_tri2DM_S[i].getVertex(j);
                ++ind;
                ++j;
            }
            ++i;
        }
    }

    private void initializeIsometry() {
        int p = this.m_sparam.m_data[2];
        int q = this.m_sparam.m_data[3];
        int g = this.m_sparam.m_data[0];
        double cosa = Math.cos(Math.PI / (double)q) / Math.sin(Math.PI / (double)p);
        double cosb = Math.cos(Math.PI / (double)p) / Math.sin(Math.PI / (double)q);
        this.m_O = new PdVector(1.0, 0.0, 0.0);
        this.m_N = new PdVector(cosb, -Math.sinh(PuMath.acosh((double)cosb)), 0.0);
        this.m_M = new PdVector(cosa, 0.0, PuMath.sinh((double)PuMath.acosh((double)cosa)));
        PdVector[] bTriangle = new PdVector[]{this.m_N, this.m_O, this.m_M};
        this.m_isometry = PuIsometry.getIsometries(p, q, bTriangle, g);
    }

    public PdVector[] getVertices2D() {
        return this.m_vertex;
    }

    public int getNumElements() {
        return this.m_tri2DM_S.length;
    }

    public int getNumQtube() {
        return this.m_target2Dtube.length;
    }

    public RMap getTargetMap() {
        return this.m_targetMap;
    }

    public symGroup getSymmetryGroup() {
        return this.m_symM_S;
    }

    public PiVector getParameters() {
        return this.m_sparam;
    }

    public boolean isDual() {
        return this.m_dual;
    }

    public PgElementSet[] getTri2D() {
        if (this.m_tri2DM_S[0] == null) {
            if (this.m_targetMap == null) {
                this.makePlanarTileKnown();
            } else {
                this.makePlanarTile();
            }
        }
        return this.m_tri2DM_S;
    }

    public int getNumVertices() {
        return this.getNumElements() / (2 * this.m_sparam.m_data[3]);
    }

    private void makePlanarTileKnown() {
        int not = this.m_symM_S.getNumElements();
        Color[] color = this.m_symM_S.getColors();
        int i = 0;
        while (i < not) {
            this.m_tri2DM_S[i] = new PgElementSet(3);
            this.m_tri2DM_S[i].setNumElements(1);
            this.m_tri2DM_S[i].setNumVertices(3);
            ++i;
        }
        int g = this.m_sparam.m_data[0];
        int p = this.m_sparam.m_data[2];
        int q = this.m_sparam.m_data[3];
        PdVector M = new PdVector(3);
        PdVector N = new PdVector(3);
        PdVector O = new PdVector(3);
        if (g == 0) {
            PuIsometry.isSpherical2D(true);
            O = new PdVector(0.0, 0.0, 0.0);
            M = new PdVector(0.0, 1.0, 0.0);
            N = p == 2 ? new PdVector(-Math.tan(0.9424777960769379)) : new PdVector(-Math.tan(Math.PI / (double)p));
        } else if (g == 1) {
            O = new PdVector(0.0, 0.0, 0.0);
            M = new PdVector(0.0, 0.5, 0.0);
            N = new PdVector(-0.5 * Math.tan(Math.PI / (double)p), 0.0, 0.0);
        }
        PdVector[] bTriangle = new PdVector[]{N, O, M};
        PdMatrix[] isom = PuIsometry.getIsometries(p, q, bTriangle, g);
        String[] coset = this.m_symM_S.getCosetElements();
        String[] eltH = this.m_symM_S.getSubGroupElements();
        int indv = 0;
        PdVector[] rotVertex = new PdVector[3];
        int i2 = 0;
        while (i2 < coset.length) {
            int j = 0;
            while (j < eltH.length) {
                indv = 0;
                String inv = PuIsometry.getInverseStringElt(coset[i2], "rst");
                String mov = String.valueOf(inv) + eltH[j];
                int index = PuSubgroup.getIndexOfEltInG(mov, this.m_symM_S.getPermutation(), "rst", true);
                PdMatrix trans = PuIsometry.getTrans(mov, isom, "rst");
                int k = 0;
                while (k < 3) {
                    rotVertex[k] = new PdVector(3);
                    PdVector vhomo = PdVector.copyNew((PdVector)bTriangle[k]);
                    vhomo.setEntry(2, 1.0);
                    trans.leftMultMatrix(rotVertex[k], vhomo);
                    rotVertex[k].setEntry(2, 0.0);
                    ++k;
                }
                k = 0;
                while (k < 3) {
                    this.m_tri2DM_S[index].setVertex(indv, rotVertex[k]);
                    ++indv;
                    ++k;
                }
                this.m_tri2DM_S[index].setElement(0, 0, 1, 2);
                this.m_tri2DM_S[index].setElementColor(0, color[i2]);
                this.m_tri2DM_S[index].getElement(0).setName(String.valueOf(index) + ",");
                if (g == 1) {
                    this.refineTriangle(this.m_tri2DM_S[index], g);
                }
                ++j;
            }
            ++i2;
        }
    }

    private void makePlanarTile() {
        int not = this.m_symM_S.getNumElements();
        this.m_tri2DM_S = new PgElementSet[not];
        Color[] color = this.m_symM_S.getColors();
        boolean[] checked = new boolean[not];
        int p = this.m_sparam.m_data[2];
        int q = this.m_sparam.m_data[3];
        int g = this.m_sparam.m_data[0];
        double cosa = Math.cos(Math.PI / (double)q) / Math.sin(Math.PI / (double)p);
        double cosb = Math.cos(Math.PI / (double)p) / Math.sin(Math.PI / (double)q);
        PdVector O = new PdVector(1.0, 0.0, 0.0);
        PdVector N = new PdVector(cosb, -Math.sinh(PuMath.acosh((double)cosb)), 0.0);
        PdVector M = new PdVector(cosa, 0.0, PuMath.sinh((double)PuMath.acosh((double)cosa)));
        PdVector[] bTriangle = new PdVector[]{N, O, M};
        PdMatrix[] isom = PuIsometry.getIsometries(p, q, bTriangle, g);
        PdMatrix trans = new PdMatrix(3);
        String[] coset = this.m_symM_S.getCosetElements();
        String[] H = this.m_symM_S.getSubGroupElements();
        int[][] rRsSt = this.m_symM_S.getPermutation();
        int index = -1;
        int i = 0;
        while (i < coset.length) {
            int j = 0;
            while (j < H.length) {
                String rep = PuIsometry.getInverseStringElt(coset[i], "rst");
                String mov = String.valueOf(rep) + H[j];
                index = PuSubgroup.getIndexOfEltInG(mov, rRsSt, "rst", true);
                if (!checked[index]) {
                    trans = PuIsometry.getTrans(mov, isom, "rst");
                    PdVector[] transVertex = new PdVector[3];
                    PdVector.realloc((PdVector[])transVertex, (int)3, (int)3);
                    int k = 0;
                    while (k < 3) {
                        trans.leftMultMatrix(transVertex[k], bTriangle[k]);
                        ++k;
                    }
                    int indColor = PuSubgroup.getIndexOfEltInG(mov, this.m_symM_S.getCosetPermutation(), "rst", false);
                    this.m_tri2DM_S[index] = this.getTriangle(transVertex);
                    this.m_tri2DM_S[index].setElementColor(0, color[indColor]);
                    this.m_tri2DM_S[index].getElement(0).setName(String.valueOf(index) + ",");
                    checked[index] = true;
                }
                ++j;
            }
            ++i;
        }
    }

    private PgElementSet getTriangle(PdVector[] tVert) {
        PgElementSet geom = new PgElementSet(3);
        geom.setNumVertices(3);
        geom.setNumElements(1);
        int i = 0;
        while (i < 3) {
            geom.setVertex(i, tVert[i]);
            ++i;
        }
        geom.setElement(0, 0, 1, 2);
        int n = m_discr;
        int nov = 3;
        PdVector[] vertex = geom.getVertices();
        int newnov = 3 * (n - 2) + 3;
        geom.setNumVertices(newnov);
        PdVector[][] newEdge = new PdVector[3][n];
        int i2 = 0;
        while (i2 < 3) {
            newEdge[i2] = PuHyperboloid.makeEdge(vertex[i2], vertex[(i2 + 1) % 3], n);
            ++i2;
        }
        int ind = 0;
        int i3 = 0;
        while (i3 < 3) {
            int j = 1;
            while (j < n - 1) {
                geom.setVertex(nov + ind, newEdge[i3][j]);
                ++ind;
                ++j;
            }
            ++i3;
        }
        PiVector index = new PiVector(n);
        index.setEntry(0, 0);
        index.setEntry(n - 1, 1);
        index.setEntry(2 * n - 2, 2);
        int s = 0;
        int i4 = 1;
        while (i4 < newnov) {
            if (i4 != n - 1 && i4 != 2 * n - 2) {
                index.setEntry(i4, nov + s);
                ++s;
            }
            ++i4;
        }
        PiVector newF = new PiVector(newnov);
        int i5 = 0;
        while (i5 < newnov) {
            newF.m_data[i5] = index.getEntry(i5);
            ++i5;
        }
        geom.setElement(0, newF);
        return geom;
    }

    public void makeFundQtube() {
        PdVector[] corner = this.getCornerPoints();
        if (this.m_ftype.equals(TYPE_121)) {
            this.makeHalftubeGrid(this.m_fundPatch, corner);
        } else if (this.m_ftype.equals(TYPE_111)) {
            this.m_fundPatch.copy((PsObject)this.make2DGrid(corner, m_discr));
        }
        int not = this.m_symM_S.getNumElements();
        PgElementSet[] tri = this.getTri2D();
        PdVector[] Itri = new PdVector[]{tri[0].getVertex(0), tri[0].getVertex(1), tri[0].getVertex(2)};
        Color[] color = this.m_symM_S.getColors();
        PdVector[] bQuad = new PdVector[4];
        PdVector.realloc((PdVector[])bQuad, (int)4, (int)3);
        int i = 0;
        while (i < 4) {
            bQuad[i].copy(this.m_fundPatch.getVertex(i));
            ++i;
        }
        boolean found = false;
        int index = 0;
        PdVector[] triangle = new PdVector[3];
        while (!found) {
            triangle[0] = tri[index].getVertex(0);
            triangle[1] = tri[index].getVertex(1);
            triangle[2] = tri[index].getVertex(2);
            if (PuCompGeometry.isPolygonIntersectPolygon(bQuad, triangle)) {
                found = true;
                continue;
            }
            ++index;
        }
        int p = this.m_sparam.m_data[2];
        int q = this.m_sparam.m_data[3];
        int g = this.m_sparam.m_data[0];
        PdMatrix[] isom = PuIsometry.getIsometries(p, q, Itri, g);
        int noe = this.m_fundPatch.getNumElements();
        this.clip(this.m_fundPatch, triangle, index, noe, tri[index].getElementColor(0));
        String[] nb = new String[]{"t", "St", "rt"};
        boolean[] checked = new boolean[not];
        PiVector[] processed = new PiVector[not];
        checked[index] = true;
        String[] crep = new String[not];
        crep[index] = this.m_symM_S.getElement(index);
        processed[0] = new PiVector(1);
        processed[0].set(index);
        int i2 = 0;
        int next = 1;
        PdMatrix trans = new PdMatrix(3);
        PdVector[] adjTriangle = new PdVector[3];
        while (processed[i2] != null) {
            int proci = processed[i2].m_data[0];
            int j = 0;
            while (j < 3) {
                String rep = String.valueOf(crep[proci]) + nb[j];
                index = PuSubgroup.getIndexOfEltInG(rep, this.m_symM_S.getPermutation(), "rst", true);
                trans = PuIsometry.getTrans(rep, isom, "rst");
                int k = 0;
                while (k < 3) {
                    adjTriangle[k] = new PdVector(3);
                    trans.leftMultMatrix(adjTriangle[k], Itri[k]);
                    ++k;
                }
                if (PuCompGeometry.isPolygonIntersectPolygon(corner, adjTriangle) && !checked[index]) {
                    checked[index] = true;
                    int col = PuSubgroup.getIndexOfEltInG(rep, this.m_symM_S.getCosetPermutation(), "rst", false);
                    this.clip(this.m_fundPatch, adjTriangle, index, noe, color[col]);
                    crep[index] = rep;
                    processed[next] = new PiVector(1);
                    processed[next].set(index);
                    ++next;
                }
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < noe) {
            PiVector f = this.m_fundPatch.getElement(i2);
            if (!f.hasTag(0)) {
                f.setTag(2);
            }
            ++i2;
        }
        this.m_fundPatch.removeMarkedElements();
        this.m_fundPatch.showElementColors(true);
        this.m_fundPatch.removeUnusedVertices();
        PuCleanMesh.identifyVertices((PgPointSet)this.m_fundPatch, (double)1.0E-4);
    }

    private void makeHalftubeGrid(PgElementSet fundPatch, PdVector[] corner) {
        PdVector[] I_0 = new PdVector[]{(PdVector)corner[0].clone(), PuHyperboloid.getMidPoint(corner[0], corner[1]), PuHyperboloid.getMidPoint(corner[3], corner[2]), (PdVector)corner[3].clone()};
        PdVector[] I_1 = new PdVector[4];
        I_1[2] = (PdVector)I_0[1].clone();
        I_1[1] = (PdVector)I_0[2].clone();
        I_1[0] = (PdVector)corner[2].clone();
        I_1[3] = (PdVector)corner[1].clone();
        fundPatch.copy((PsObject)this.make2DGrid(I_0, m_discr));
        fundPatch.merge((PgGeometryIf)this.make2DGrid(I_1, m_discr));
    }

    public PgElementSet getFundQtube() {
        this.makeFundQtube();
        return this.m_fundPatch;
    }

    public PgPolygonSet getNOLinesFqtube() {
        this.m_fundPatch.makeNeighbour();
        this.getPolygonBoundary(this.m_fundPatch, this.m_NOLinesFqtube);
        return this.m_NOLinesFqtube;
    }

    public void getPolygonBoundary(PgElementSet m_elementSet, PgPolygonSet m_polySet) {
        int numEl = m_elementSet.getNumElements();
        m_polySet.copy((PsObject)m_elementSet);
        boolean[] marked = new boolean[numEl];
        int i = 0;
        while (i < numEl) {
            PiVector neigh = m_elementSet.getNeighbour(i);
            PiVector elem = m_elementSet.getElement(i);
            int elSize = elem.getSize();
            int j = 0;
            while (j < elSize) {
                if (neigh.m_data[j] >= i && m_elementSet.getElementColor(i).getRGB() != m_elementSet.getElementColor(neigh.m_data[j]).getRGB() && m_elementSet.getElementColor(i) != m_elementSet.getElementColor(neigh.m_data[j])) {
                    marked[i] = true;
                    marked[neigh.m_data[j]] = true;
                    PiVector poly = new PiVector(2);
                    poly.set(elem.m_data[(j + 1) % elSize], elem.m_data[(j + 2) % elSize]);
                    m_polySet.addPolygon(poly);
                }
                ++j;
            }
            ++i;
        }
        PwCleanMesh.joinPolygons((PgPolygonSet)m_polySet);
    }

    public PgElementSet[] getTri3D() {
        if (this.m_targetMap == null) {
            this.make3DTileKnown();
        } else {
            this.make3DTile();
        }
        return this.m_tri3DM_S;
    }

    public PgPolygonSet getNOLines3D() {
        int numQtube = this.m_tri3DM_S.length;
        PgPolygonSet[] NO = new PgPolygonSet[numQtube];
        int i = 0;
        while (i < numQtube) {
            NO[i] = new PgPolygonSet(3);
            NO[i].copy((PsObject)this.m_tri3DM_S[i]);
            this.getPolygonBoundary(this.m_tri3DM_S[i], NO[i]);
            ++i;
        }
        int nop = NO[0].getNumPolygons();
        int n = NO[0].getNumVertices();
        int nov = NO[0].getNumVertices();
        this.m_NOLines3D.setNumPolygons(nop * numQtube);
        this.m_NOLines3D.setNumVertices(nop * n * numQtube);
        this.m_NOLines3D.copy((PsObject)NO[0]);
        int indp = 1;
        int i2 = 1;
        while (i2 < numQtube) {
            int j = 0;
            while (j < nop) {
                PiVector pol = (PiVector)NO[i2].getPolygon(j).clone();
                int k = 0;
                while (k < pol.getSize()) {
                    this.m_NOLines3D.setVertex(nov + k, NO[i2].getVertex(pol.m_data[k]));
                    pol.setEntry(k, nov + k);
                    ++k;
                }
                this.m_NOLines3D.setPolygon(nop + indp, pol);
                nov += pol.getSize();
                ++indp;
                ++j;
            }
            ++i2;
        }
        this.m_NOLines3D.setGlobalPolygonSize(0.5);
        return this.m_NOLines3D;
    }

    private void make3DTileKnown() {
        int not = this.m_symM_S.getNumElements();
        this.m_tri3DM_S = new PgElementSet[not];
        Color[] color = this.m_symM_S.getColors();
        int g = this.m_sparam.m_data[0];
        int p = this.m_sparam.m_data[2];
        int q = this.m_sparam.m_data[3];
        PdVector M = new PdVector(3);
        PdVector N = new PdVector(3);
        PdVector O = new PdVector(3);
        if (g == 0) {
            PuIsometry.isSpherical2D(false);
            double cosa = Math.cos(Math.PI / (double)q) / Math.sin(Math.PI / (double)p);
            double cosb = Math.cos(Math.PI / (double)p) / Math.sin(Math.PI / (double)q);
            M = new PdVector(0.0, cosa, Math.sin(Math.acos(cosa)));
            N = new PdVector(Math.sin(Math.acos(cosb)), cosb, 0.0);
            O = new PdVector(0.0, 1.0, 0.0);
        } else if (g == 1) {
            O = new PdVector(0.0, 0.0, 1.0);
            M = new PdVector(0.0, 0.5, 1.0);
            N = new PdVector(-0.5 * Math.tan(Math.PI / (double)p), 0.0, 1.0);
        }
        PdVector[] bTriangle = new PdVector[]{N, O, M};
        PdMatrix[] isom = PuIsometry.getIsometries(p, q, bTriangle, g);
        int i = 0;
        while (i < not) {
            this.m_tri3DM_S[i] = new PgElementSet(3);
            this.m_tri3DM_S[i].setNumElements(1);
            this.m_tri3DM_S[i].setNumVertices(3);
            this.m_tri3DM_S[i].setVertices(bTriangle);
            this.m_tri3DM_S[i].setElement(0, 0, 1, 2);
            ++i;
        }
        int[] processed = new int[not];
        boolean[] checked = new boolean[not];
        String[] crep = new String[not];
        crep[0] = "";
        processed[0] = 0;
        String[] nb = new String[]{"t", "St", "rt"};
        int next = 1;
        int i2 = 0;
        while (i2 < not) {
            int j = 0;
            while (j < 3) {
                String rep = String.valueOf(crep[processed[i2]]) + nb[j];
                int index = PuSubgroup.getIndexOfEltInG(rep, this.m_symM_S.getPermutation(), "rst", true);
                if (!checked[index]) {
                    PdMatrix trans = PuIsometry.getTrans(rep, isom, "rst");
                    PdVector[] transVertex = this.m_tri3DM_S[index].getVertices();
                    int k = 0;
                    while (k < 3) {
                        trans.leftMultMatrix(transVertex[k], bTriangle[k]);
                        ++k;
                    }
                    k = 0;
                    while (k < 3) {
                        this.m_tri3DM_S[index].setVertex(k, transVertex[k]);
                        ++k;
                    }
                    int indColor = PuSubgroup.getIndexOfEltInG(rep, this.m_symM_S.getCosetPermutation(), "rst", false);
                    this.m_tri3DM_S[index].setElementColor(0, color[indColor]);
                    int label = PuSubgroup.getIndexOfEltInG(rep, this.m_symM_S.getPermutation(), "rst", false);
                    this.m_tri3DM_S[index].getElement(0).setName(String.valueOf(label) + ",");
                    this.refineTriangle(this.m_tri3DM_S[index], g);
                    if (g == 1) {
                        PdVector[] vGrid = this.m_tri3DM_S[index].getVertices();
                        PdMatrix SR = this.getParallelogram();
                        int k2 = 0;
                        while (k2 < vGrid.length) {
                            vGrid[k2].m_data[2] = 0.0;
                            vGrid[k2].leftMultMatrix(SR);
                            double t = vGrid[k2].m_data[0];
                            double s = vGrid[k2].m_data[1];
                            vGrid[k2].m_data[0] = (2.0 + Math.cos(t)) * Math.cos(s);
                            vGrid[k2].m_data[1] = (2.0 + Math.cos(t)) * Math.sin(s);
                            vGrid[k2].m_data[2] = Math.sin(t);
                            ++k2;
                        }
                    }
                    if (!this.m_symM_S.getElementOrientation()[index]) {
                        int k3 = 0;
                        while (k3 < this.m_tri3DM_S[index].getNumElements()) {
                            this.m_tri3DM_S[index].getElement(k3).invert();
                            ++k3;
                        }
                    }
                    crep[index] = rep;
                    checked[index] = true;
                    processed[next] = index;
                    if (next < processed.length - 1) {
                        ++next;
                    }
                }
                ++j;
            }
            ++i2;
        }
    }

    private void refineTriangle(PgElementSet geom, int g) {
        int n = m_discr;
        int nov = geom.getNumVertices();
        PdVector[] vertex = geom.getVertices();
        Color[] ecolor = geom.getElementColors();
        String label = geom.getElement(0).getName();
        int newnoe = n - 1;
        int k = 0;
        while (k < n - 2) {
            int l = 0;
            while (l < n - 2 - k) {
                ++newnoe;
                ++l;
            }
            ++k;
        }
        int newnov = (int)(((double)n + 0.5) * (double)n - 0.5 * (double)(n * n));
        geom.setNumVertices(newnov);
        geom.setNumElements(newnoe);
        PdVector[] firstSide = this.makeEdge(vertex[1], vertex[2], n, g);
        PdVector[] secondSide = this.makeEdge(vertex[2], vertex[0], n, g);
        int ind = 0;
        int prevnov = nov + ind;
        int i = 0;
        while (i < n - 1) {
            int j;
            PdVector[] v = this.makeEdge(secondSide[n - 1 - i], firstSide[i], n - i, g);
            if (i != 0) {
                j = 0;
                while (j < n - i) {
                    geom.setVertex(nov + ind, v[j]);
                    ++ind;
                    ++j;
                }
            } else {
                j = 1;
                while (j < n - 1) {
                    geom.setVertex(nov + ind, v[j]);
                    ++ind;
                    ++j;
                }
            }
            ++i;
        }
        PiVector index = new PiVector(newnov);
        index.setEntry(0, 0);
        index.setEntry(n - 1, 1);
        index.setEntry(newnov - 1, 2);
        int s = 0;
        int i2 = 1;
        while (i2 < newnov - 1) {
            if (i2 != n - 1) {
                index.setEntry(i2, prevnov + s);
                ++s;
            }
            ++i2;
        }
        int indOfe = 0;
        int k2 = 0;
        while (k2 < n - 1) {
            int a = (int)(((double)n + 0.5) * (double)k2 - 0.5 * (double)k2 * (double)k2);
            int b = (int)(((double)n + 0.5) * (double)k2 - 0.5 * (double)k2 * (double)k2 + 1.0);
            int c = (int)(((double)n + 0.5) * (double)(k2 + 1) - 0.5 * (double)(k2 + 1) * (double)(k2 + 1));
            geom.setElement(indOfe, index.m_data[a], index.m_data[b], index.m_data[c]);
            geom.setElementColor(indOfe, ecolor[0]);
            geom.getElement(indOfe).setName(label);
            ++indOfe;
            ++k2;
        }
        k2 = 0;
        while (k2 < n - 2) {
            int l = 0;
            while (l < n - 2 - k2) {
                int a = (int)(((double)n + 0.5) * (double)l - 0.5 * (double)l * (double)l + 1.0 + (double)k2);
                int b = (int)(((double)n + 0.5) * (double)l - 0.5 * (double)l * (double)l + 2.0 + (double)k2);
                int c = (int)(((double)n + 0.5) * (double)(l + 1) - 0.5 * (double)(l + 1) * (double)(l + 1) + 1.0 + (double)k2);
                int d = (int)(((double)n + 0.5) * (double)(l + 1) - 0.5 * (double)(l + 1) * (double)(l + 1) + (double)k2);
                geom.setElement(indOfe, index.m_data[a], index.m_data[b], index.m_data[c], index.m_data[d]);
                geom.setElementColor(indOfe, ecolor[0]);
                geom.getElement(indOfe).setName(label);
                ++indOfe;
                ++l;
            }
            ++k2;
        }
        geom.makeNeighbour();
    }

    private PdVector[] makeEdge(PdVector p1, PdVector p2, int n, int g) {
        PdVector[] edge = new PdVector[n];
        if (g == 0) {
            edge = PuSpherical.makeEdge(p1, p2, n);
        } else if (g == 1) {
            PdVector dir = PdVector.subNew((PdVector)p2, (PdVector)p1);
            double l = dir.length();
            dir.normalize();
            int i = 0;
            while (i < n) {
                edge[i] = new PdVector(3);
                double t = (double)i * l / (double)(n - 1);
                edge[i].multScalar(dir, t);
                edge[i].add(p1);
                ++i;
            }
        }
        return edge;
    }

    private PdMatrix getParallelogram() {
        PdVector sum;
        PdVector Rdir;
        PdVector dir;
        double a = this.m_sparam.m_data[4];
        double b = this.m_sparam.m_data[5];
        int p = this.m_sparam.m_data[2];
        int q = this.m_sparam.m_data[3];
        double scale = Math.tan(Math.PI / (double)p);
        double theta = Math.PI * 2 / (double)q;
        if (p == 6) {
            theta /= 2.0;
        }
        PdMatrix R = new PdMatrix(3);
        R.set((double[][])new double[][]{{Math.cos(theta), -Math.sin(theta), 0.0}, {Math.sin(theta), Math.cos(theta), 0.0}, {0.0, 0.0, 1.0}});
        a *= scale;
        if (Math.abs(b) < 1.0E-10 && p == 6) {
            dir = new PdVector(a, 0.0, 0.0);
            Rdir = new PdVector(3);
            Rdir.leftMultMatrix(R, dir);
            sum = PdVector.addNew((PdVector)dir, (PdVector)Rdir);
            a = sum.m_data[0];
            b = sum.m_data[1];
        }
        if (this.m_sparam.m_data[4] == this.m_sparam.m_data[5]) {
            if (p != 6) {
                dir = new PdVector(a, 0.0, 0.0);
                Rdir = new PdVector(3);
                Rdir.leftMultMatrix(R, dir);
                sum = PdVector.addNew((PdVector)dir, (PdVector)Rdir);
                a = sum.m_data[0];
                b = sum.m_data[1];
            } else {
                dir = new PdVector(a, 0.0, 0.0);
                Rdir = new PdVector(3);
                Rdir.leftMultMatrix(R, dir);
                PdVector dir1 = PdVector.addNew((PdVector)dir, (PdVector)Rdir);
                PdVector dir2 = new PdVector(3);
                dir2.leftMultMatrix(R, dir1);
                PdVector sum2 = PdVector.addNew((PdVector)dir1, (PdVector)dir2);
                a = sum2.m_data[0];
                b = sum2.m_data[1];
            }
        }
        PdVector v = new PdVector(3);
        R.set((double[][])new double[][]{{Math.cos(theta), -Math.sin(theta), 0.0}, {Math.sin(theta), Math.cos(theta), 0.0}, {0.0, 0.0, 1.0}});
        R.leftMultMatrix(v, new PdVector(a, b, 0.0));
        PdVector u = new PdVector(a, b, 0.0);
        PdVector w = new PdVector(1.0, 0.0, 0.0);
        PdVector z = new PdVector(0.0, 1.0, 0.0);
        PdMatrix SR = PuIsometry.mapXtoY(u, v, w, z);
        SR.multScalar(Math.PI * 2);
        return SR;
    }

    private void make3DTile() {
        if (!this.m_hasFundQtube) {
            this.makeFundQtube();
            this.m_hasFundQtube = true;
        }
        if (this.m_target2Dtube[0] == null) {
            this.make2Dqtube();
        }
        PgElementSet twoDFundPatch = this.m_fundPatch;
        this.m_target3DQtube.copy((PsObject)this.getTargetTube());
        PgElementSet twoDGridPatch = this.getFundGridPatch();
        PiVector[] neighbor = this.m_symS_g.getNeighbor();
        if (this.m_ftype.equals(TYPE_121)) {
            this.makeHalfTube3DMapping(neighbor, twoDFundPatch, twoDGridPatch, this.m_target3DQtube);
        } else if (this.m_ftype.equals(TYPE_111)) {
            this.makeQuarterTube3DMapping(neighbor, twoDFundPatch, twoDGridPatch, this.m_target3DQtube);
        }
    }

    private void makeQuarterTube3DMapping(PiVector[] neighbor, PgElementSet twoDFundPatch, PgElementSet twoDGridPatch, PgElementSet threeDTube) {
        int nov = twoDFundPatch.getNumVertices();
        int noe = twoDFundPatch.getNumElements();
        int locnoe = (m_discr - 1) * (m_discr - 1);
        int noqt = neighbor.length;
        boolean[] checked = new boolean[noqt];
        PiVector[] elt = twoDFundPatch.getElements();
        PdVector[] vertex = twoDFundPatch.getVertices();
        String[] eltS_g = this.m_symS_g.getElements();
        String[] eltM_S = this.m_symM_S.getElements();
        Color[] color = this.m_symM_S.getColors();
        int m = 0;
        while (m < noqt) {
            PiVector nb = neighbor[m];
            int j = 0;
            while (j < 3) {
                int i = nb.m_data[j];
                if (!checked[i]) {
                    this.m_tri3DM_S[i] = new PgElementSet(3);
                    this.m_tri3DM_S[i].copy((PsObject)twoDFundPatch);
                    PdVector[] newPos = new PdVector[nov];
                    PdVector[] normal = new PdVector[nov];
                    String repQtube = this.convertToRST(eltS_g[i]);
                    int k = 0;
                    while (k < noe) {
                        PiVector f = elt[k];
                        String[] label = f.getName().split(",");
                        int c = Integer.parseInt(label[0]);
                        String repTri = eltM_S[c];
                        int index = PuSubgroup.getIndexOfEltInG(String.valueOf(repQtube) + repTri, this.m_symM_S.getPermutation(), "rst", false);
                        int b = Integer.parseInt(label[1]);
                        this.m_tri3DM_S[i].getElement(k).setName(String.valueOf(index) + "," + b);
                        index = PuSubgroup.getIndexOfEltInG(eltM_S[index], this.m_symM_S.getCosetPermutation(), "rst", true);
                        this.m_tri3DM_S[i].setElementColor(k, color[index]);
                        this.m_tri3DM_S[i].setElementNormal(k, this.m_target3DQtube.getElementNormal(i * locnoe + k));
                        int s = 0;
                        while (s < f.getSize()) {
                            PdVector tp = vertex[elt[k].m_data[s]];
                            normal[f.m_data[s]] = new PdVector(3);
                            newPos[f.m_data[s]] = this.mapTo3D(normal[f.m_data[s]], b, tp, twoDGridPatch, threeDTube, i * locnoe);
                            ++s;
                        }
                        ++k;
                    }
                    k = 0;
                    while (k < nov) {
                        this.m_tri3DM_S[i].setVertex(k, newPos[k]);
                        this.m_tri3DM_S[i].setVertexNormal(k, normal[k]);
                        ++k;
                    }
                    checked[i] = true;
                }
                ++j;
            }
            ++m;
        }
    }

    private void makeHalfTube3DMapping(PiVector[] neighbor, PgElementSet twoDFundPatch, PgElementSet twoDGridPatch, PgElementSet threeDTube) {
        PiVector[] halftube = this.makeHalftubeFromQuarterTube(neighbor);
        int nov = twoDFundPatch.getNumVertices();
        int noe = twoDFundPatch.getNumElements();
        int noehalftube = halftube.length;
        int locnoe = (m_discr - 1) * (m_discr - 1);
        PiVector[] elt = twoDFundPatch.getElements();
        PdVector[] vertex = twoDFundPatch.getVertices();
        String[] eltS_g = this.m_symS_g.getElements();
        String[] eltM_S = this.m_symM_S.getElements();
        Color[] color = this.m_symM_S.getColors();
        int i = 0;
        while (i < noehalftube) {
            this.m_tri3DM_S[i] = new PgElementSet(3);
            this.m_tri3DM_S[i].copy((PsObject)twoDFundPatch);
            PdVector[] newPos = new PdVector[nov];
            PdVector[] normal = new PdVector[nov];
            int k = 0;
            while (k < noe) {
                PiVector f = elt[k];
                String[] label = f.getName().split(",");
                int c = Integer.parseInt(label[0]);
                int b = Integer.parseInt(label[1]);
                int shift = -1;
                String repQtube = this.convertToRST(eltS_g[halftube[i].m_data[0]]);
                String repTri = eltM_S[c];
                int index = PuSubgroup.getIndexOfEltInG(String.valueOf(repQtube) + repTri, this.m_symM_S.getPermutation(), "rst", false);
                this.m_tri3DM_S[i].getElement(k).setName(String.valueOf(index) + "," + b);
                index = PuSubgroup.getIndexOfEltInG(eltM_S[index], this.m_symM_S.getCosetPermutation(), "rst", true);
                this.m_tri3DM_S[i].setElementColor(k, color[index]);
                shift = b < locnoe ? halftube[i].m_data[0] * locnoe : halftube[i].m_data[1] * locnoe;
                this.m_tri3DM_S[i].setElementNormal(k, this.m_target3DQtube.getElementNormal(shift + k));
                int s = 0;
                while (s < f.getSize()) {
                    PdVector tp = vertex[elt[k].m_data[s]];
                    normal[f.m_data[s]] = new PdVector(3);
                    newPos[f.m_data[s]] = this.mapTo3D(normal[f.m_data[s]], b, tp, twoDGridPatch, threeDTube, shift);
                    ++s;
                }
                ++k;
            }
            k = 0;
            while (k < nov) {
                this.m_tri3DM_S[i].setVertex(k, newPos[k]);
                this.m_tri3DM_S[i].setVertexNormal(k, normal[k]);
                ++k;
            }
            ++i;
        }
    }

    private PiVector[] makeHalftubeFromQuarterTube(PiVector[] neighbor) {
        int noe = neighbor.length / 2;
        PiVector[] halftube = new PiVector[noe];
        boolean[] oriented = this.m_symS_g.getElementOrientation();
        int ind = 0;
        int i = 0;
        while (i < neighbor.length) {
            if (oriented[i]) {
                halftube[ind] = new PiVector(2);
                halftube[ind].m_data[0] = i;
                halftube[ind].m_data[1] = neighbor[i].m_data[2];
                ++ind;
            }
            ++i;
        }
        return halftube;
    }

    private void clip(PgElementSet geom, PdVector[] ct, int indTri, int numElt, Color col) {
        PdVector[] quadvertex = geom.getVertices();
        PiVector count = new PiVector(1);
        count.setEntry(0, 0);
        if (!this.m_symM_S.getElementOrientation()[indTri]) {
            PdVector tmp = (PdVector)ct[1].clone();
            ct[1].copy(ct[2]);
            ct[2].copy(tmp);
        }
        if (!PuCompGeometry.ccw(ct)) {
            System.out.println("not ccw");
        }
        int j = 0;
        while (j < numElt) {
            PiVector cquad = geom.getElement(j);
            PdVector[] cqpos = new PdVector[]{quadvertex[cquad.getEntry(0)], quadvertex[cquad.getEntry(1)], quadvertex[cquad.getEntry(2)], quadvertex[cquad.getEntry(3)]};
            if (PuCompGeometry.quadInsideTriangle(cqpos, ct)) {
                geom.setElementColor(j, col);
                cquad.setName(String.valueOf(indTri) + "," + j);
                cquad.setTag(0);
            } else if (PuCompGeometry.isPolygonIntersectPolygon(cqpos, ct)) {
                int currentnoe = geom.getNumElements();
                if (!PuCompGeometry.ccw(ct)) {
                    System.out.print("not counterclockwise");
                }
                PiVector cutQuad = new PiVector(1);
                PuCompGeometry.computeInterQuadTriangleNew(cutQuad, cqpos, ct, cquad, geom);
                PdVector tpoint = new PdVector(3);
                PiVector i_point = new PiVector();
                if (cutQuad.getSize() >= 2 && cutQuad.getIndexOf(-1) == -1) {
                    if (PuCompGeometry.isPointInsideQuad(ct, cqpos, tpoint, i_point)) {
                        int currentnov = geom.getNumVertices();
                        int n = cutQuad.getSize();
                        geom.setNumVertices(currentnov + 1);
                        geom.setVertex(currentnov, tpoint);
                        PdVector p1 = ct[(i_point.m_data[0] + 2) % 3];
                        PdVector p2 = ct[i_point.m_data[0]];
                        int k = 0;
                        while (k < n) {
                            if (PuCompGeometry.liesOnSegment(geom.getVertex(cutQuad.m_data[k]), p1, p2)) {
                                PiVector c_tmp = (PiVector)cutQuad.clone();
                                cutQuad.setSize(n + 1);
                                cutQuad.setEntry(k + 1, currentnov);
                                int l1 = k + 2;
                                while (l1 < n + 1) {
                                    cutQuad.setEntry(l1, c_tmp.m_data[l1 - 1]);
                                    ++l1;
                                }
                                break;
                            }
                            ++k;
                        }
                    }
                    if (cutQuad.getSize() > 2) {
                        currentnoe = geom.getNumElements();
                        geom.setDimOfElements(-1);
                        geom.setNumElements(currentnoe + 1);
                        geom.setElement(currentnoe, cutQuad);
                        geom.getElement(currentnoe).setName(String.valueOf(indTri) + "," + j);
                        geom.setElementColor(currentnoe, col);
                    }
                }
            }
            ++j;
        }
    }

    public void setNO(PgPolygonSet[] NO) {
        this.m_NO = NO;
    }

    public void setSkeleton(PgPolygonSet skeleton) {
        int lenPol;
        this.m_skeleton = skeleton;
        this.m_targetMap.isShowingSkeleton(true);
        boolean[] oriented = this.m_symM_T.getElementOrientation();
        PiVector[] neighbor = this.m_symM_T.getNeighbor();
        PdVector[] skVert = skeleton.getVertices();
        int noe = this.m_symM_T.getNumElements();
        int locnov = lenPol = skeleton.getPolygon(0).getSize();
        int index = 0;
        int nop = skeleton.getNumPolygons();
        PgPolygonSet[] NO = this.m_targetMap.m_NO;
        PiVector rindex = new PiVector(nop);
        int i = 0;
        while (i < noe) {
            if (oriented[i]) {
                rindex.m_data[index] = i;
                ++index;
            }
            ++i;
        }
        PiVector f = new PiVector(lenPol);
        f.m_data[0] = 0;
        f.m_data[lenPol - 1] = 1;
        int j = 1;
        while (j < lenPol - 1) {
            f.setEntry(j, j + 1);
            ++j;
        }
        int i2 = 0;
        while (i2 < nop) {
            int a = rindex.m_data[i2];
            PiVector pol = skeleton.getPolygon(i2);
            NO[a].setNumVertices(locnov);
            NO[a].setNumPolygons(1);
            NO[a].setVertex(0, skVert[pol.m_data[0]]);
            NO[a].setVertex(1, skVert[pol.m_data[locnov - 1]]);
            NO[a].setVertexNormal(0, skeleton.getVertexNormal(pol.m_data[0]));
            NO[a].setVertexNormal(1, skeleton.getVertexNormal(pol.m_data[locnov - 1]));
            int j2 = 1;
            while (j2 < locnov - 1) {
                NO[a].setVertex(j2 + 1, skVert[pol.m_data[j2]]);
                NO[a].setVertexNormal(j2 + 1, skeleton.getVertexNormal(pol.m_data[j2]));
                ++j2;
            }
            NO[a].setPolygon(0, f);
            int nb = neighbor[a].m_data[1];
            NO[nb].setNumVertices(locnov);
            NO[nb].setNumPolygons(1);
            NO[nb].setVertex(0, skVert[pol.m_data[0]]);
            NO[nb].setVertex(1, skVert[pol.m_data[locnov - 1]]);
            NO[nb].setVertexNormal(0, skeleton.getVertexNormal(pol.m_data[0]));
            NO[nb].setVertexNormal(1, skeleton.getVertexNormal(pol.m_data[locnov - 1]));
            int j3 = 1;
            while (j3 < locnov - 1) {
                NO[nb].setVertex(j3 + 1, skVert[pol.m_data[j3]]);
                NO[nb].setVertexNormal(j3 + 1, skeleton.getVertexNormal(pol.m_data[j3]));
                ++j3;
            }
            NO[nb].setPolygon(0, f);
            ++i2;
        }
    }

    public PgPolygonSet[] getNO() {
        if (this.m_hasSkeleton) {
            return this.m_NO;
        }
        if (this.m_targetMap == null) {
            this.makeNOLinesKnown();
        } else {
            this.makeNOLines();
        }
        return this.m_NO;
    }

    public void isShowingSkeleton(boolean flag) {
        this.m_hasSkeleton = flag;
    }

    private void computeControlSkeleton(PgPolygonSet skeleton) {
        PgPolygonSet[] NO = this.m_targetMap.getNO();
        String[] elt = this.m_symM_T.getElements();
        int noe = elt.length;
        int nop = elt.length / 2;
        skeleton.setNumVertices(NO[0].getNumVertices() * nop);
        skeleton.setNumPolygons(nop);
        PiVector index = new PiVector(nop);
        boolean[] oriented = this.m_symM_T.getElementOrientation();
        int inde = 0;
        int i = 0;
        while (i < noe) {
            if (oriented[i]) {
                index.m_data[inde] = i;
                ++inde;
            }
            ++i;
        }
        PiVector[] neighborM_T = this.m_symM_T.getNeighbor();
        inde = 0;
        int i2 = 0;
        while (i2 < noe) {
            if (oriented[i2]) {
                this.m_skNeighbor[inde] = new PiVector(2);
                this.m_skNeighbor[inde].m_data[0] = index.getIndexOf(neighborM_T[neighborM_T[i2].m_data[0]].m_data[1]);
                this.m_skNeighbor[inde].m_data[1] = index.getIndexOf(neighborM_T[neighborM_T[i2].m_data[2]].m_data[1]);
                ++inde;
            }
            ++i2;
        }
        int locnov = NO[0].getNumVertices();
        boolean[] checked = new boolean[nop];
        int i3 = 0;
        while (i3 < nop) {
            PiVector nb = this.m_skNeighbor[i3];
            int j = 0;
            while (j < 2) {
                int a = nb.m_data[j];
                if (!checked[a]) {
                    int k = 0;
                    while (k < locnov) {
                        skeleton.setVertex(a * locnov + k, NO[index.m_data[a]].getVertex(k));
                        skeleton.setVertexNormal(a * locnov + k, NO[index.m_data[a]].getVertexNormal(k));
                        ++k;
                    }
                    PiVector tmp = new PiVector(locnov);
                    tmp.copy(NO[index.m_data[a]].getPolygon(0));
                    tmp.add(a * locnov);
                    skeleton.setPolygon(a, tmp);
                    checked[a] = true;
                }
                ++j;
            }
            ++i3;
        }
        PuCleanMesh.identifyVertices((PgPointSet)skeleton, (double)0.01);
        skeleton.removeUnusedVertices();
        PuPolygonSmoothing.makeNormals(skeleton, this.m_skNeighbor, false);
    }

    public void getSkeleton(PgPolygonSet skeleton) {
        if (!this.m_hasSkeleton && this.m_targetMap != null) {
            this.computeControlSkeleton(skeleton);
        }
    }

    public PiVector[] getSkeletonNeighbor() {
        return this.m_skNeighbor;
    }

    private void makeNOLinesKnown() {
        int nop = this.m_symM_S.getNumElements();
        this.m_tri3DM_S = this.getTri3D();
        this.makeVertexNormalsKnown(this.m_tri3DM_S);
        this.m_NO = new PgPolygonSet[nop];
        int i = 0;
        while (i < nop) {
            this.m_NO[i] = this.getNOKnown(this.m_tri3DM_S[i]);
            ++i;
        }
    }

    private PgPolygonSet getNOKnown(PgElementSet tile) {
        PgPolygonSet pol = new PgPolygonSet(3);
        int n = m_discr;
        pol.setNumVertices(n);
        pol.setNumPolygons(1);
        PdVector[] vertex = tile.getVertices();
        pol.setVertex(0, vertex[0]);
        pol.setVertex(1, vertex[1]);
        pol.setVertexNormal(0, tile.getVertexNormal(0));
        pol.setVertexNormal(1, tile.getVertexNormal(1));
        PiVector f = new PiVector(n);
        f.m_data[0] = 0;
        f.m_data[n - 1] = 1;
        int i = 1;
        while (i < n - 1) {
            pol.setVertex(i + 1, vertex[i + 2]);
            pol.setVertexNormal(i + 1, tile.getVertexNormal(i + 2));
            ++i;
        }
        i = 1;
        while (i < n - 1) {
            f.m_data[i] = i + 1;
            ++i;
        }
        pol.setPolygon(0, f);
        return pol;
    }

    private boolean makeVertexNormalsKnown(PgElementSet[] tile) {
        int not = tile.length;
        int n = m_discr;
        int i = 0;
        while (i < not) {
            tile[i].makeVertexNormals();
            ++i;
        }
        PdVector edgeB = new PdVector(3);
        PdVector edgeC = new PdVector(3);
        int q = this.m_sparam.m_data[3];
        String[] eltM_S = this.m_symM_S.getElements();
        int i2 = 0;
        while (i2 < not) {
            PdVector[][] vpos = new PdVector[2 * q][3];
            PiVector[] vind = new PiVector[2 * q];
            String rep = eltM_S[i2];
            PiVector nb = new PiVector(2 * q);
            int ind = -1;
            int m = 0;
            while (m < n) {
                int index;
                if (m == 0) {
                    int k;
                    int j = 0;
                    while (j < q) {
                        nb.m_data[j] = index = PuSubgroup.getIndexOfEltInG(String.valueOf(rep) + "t", this.m_symM_S.getPermutation(), "rst", true);
                        vind[j] = tile[index].getElement(0);
                        k = 0;
                        while (k < 3) {
                            vpos[j][k] = tile[index].getVertex(vind[j].m_data[k]);
                            ++k;
                        }
                        rep = String.valueOf(rep) + "s";
                        ++j;
                    }
                    rep = eltM_S[i2];
                    j = 0;
                    while (j < q) {
                        index = PuSubgroup.getIndexOfEltInG(String.valueOf(rep) + "s", this.m_symM_S.getPermutation(), "rst", true);
                        vind[j + q] = tile[index].getElement(0);
                        nb.m_data[j + q] = index;
                        k = 0;
                        while (k < 3) {
                            vpos[j + q][k] = tile[index].getVertex(vind[j + q].m_data[k]);
                            ++k;
                        }
                        rep = String.valueOf(rep) + "s";
                        ++j;
                    }
                    ind = 0;
                } else if (m > 0 && m < n - 1) {
                    vpos = new PdVector[4][4];
                    vind = new PiVector[4];
                    nb = new PiVector(1);
                    index = PuSubgroup.getIndexOfEltInG(String.valueOf(rep) + "St", this.m_symM_S.getPermutation(), "rst", true);
                    int a = m * n - m * (1 + m) / 2;
                    int b = (m - 1) * n - (m - 1) * m / 2;
                    vind[0] = tile[i2].getElement(a);
                    int k = 0;
                    while (k < vind[0].getSize()) {
                        vpos[0][k] = tile[i2].getVertex(vind[0].m_data[k]);
                        ++k;
                    }
                    vind[1] = tile[i2].getElement(b);
                    k = 0;
                    while (k < vind[1].getSize()) {
                        vpos[1][k] = tile[i2].getVertex(vind[1].m_data[k]);
                        ++k;
                    }
                    vind[2] = tile[index].getElement(a);
                    k = 0;
                    while (k < vind[2].getSize()) {
                        vpos[2][k] = tile[index].getVertex(vind[2].m_data[k]);
                        ++k;
                    }
                    vind[3] = tile[index].getElement(b);
                    k = 0;
                    while (k < vind[3].getSize()) {
                        vpos[3][k] = tile[index].getVertex(vind[3].m_data[k]);
                        ++k;
                    }
                    ind = m + 2;
                } else if (m == n - 1) {
                    vpos = new PdVector[4][4];
                    vind = new PiVector[4];
                    nb = new PiVector(3);
                    index = PuSubgroup.getIndexOfEltInG(String.valueOf(rep) + "St", this.m_symM_S.getPermutation(), "rst", true);
                    int index2 = PuSubgroup.getIndexOfEltInG(String.valueOf(rep) + "rt", this.m_symM_S.getPermutation(), "rst", true);
                    int index3 = PuSubgroup.getIndexOfEltInG(String.valueOf(rep) + "rs", this.m_symM_S.getPermutation(), "rst", true);
                    int a = m * n - m * (1 + m) / 2 - 1;
                    vind[0] = tile[i2].getElement(a);
                    int k = 0;
                    while (k < vind[0].getSize()) {
                        vpos[0][k] = tile[i2].getVertex(vind[0].m_data[k]);
                        ++k;
                    }
                    vind[1] = tile[index].getElement(a);
                    k = 0;
                    while (k < vind[1].getSize()) {
                        vpos[1][k] = tile[index].getVertex(vind[1].m_data[k]);
                        ++k;
                    }
                    vind[2] = tile[index2].getElement(a);
                    k = 0;
                    while (k < vind[2].getSize()) {
                        vpos[2][k] = tile[index2].getVertex(vind[2].m_data[k]);
                        ++k;
                    }
                    vind[3] = tile[index3].getElement(a);
                    k = 0;
                    while (k < vind[3].getSize()) {
                        vpos[3][k] = tile[index3].getVertex(vind[3].m_data[k]);
                        ++k;
                    }
                    ind = 1;
                }
                PdVector normal = new PdVector(3);
                normal.setConstant(0.0);
                int numAdj = vind.length;
                int j = 0;
                while (j < numAdj) {
                    int l = vind[j].getIndexOf(ind);
                    int noE = vind[j].getSize();
                    PdVector vertexO = vpos[j][l];
                    PdVector vertexB = vpos[j][(l + 1) % noE];
                    PdVector vertexC = vpos[j][(l + noE - 1) % noE];
                    edgeB.sub(vertexB, vertexO);
                    edgeC.sub(vertexC, vertexO);
                    normal.add(PdVector.crossNew((PdVector)edgeB, (PdVector)edgeC));
                    ++j;
                }
                normal.normalize();
                tile[i2].setVertexNormal(ind, normal);
                ++m;
            }
            ++i2;
        }
        return true;
    }

    private void makeNOLines() {
        if (this.m_ftype.equals(TYPE_111)) {
            this.makeNOLinesForQuartertube();
        }
        if (this.m_ftype.equals(TYPE_121)) {
            this.makeNOLinesForHalftube();
        }
    }

    private void makeNOLinesForHalftube() {
        int nol = this.m_symM_S.getNumElements();
        this.m_NO = this.getNO2D();
        PgElementSet fund2DGridPatch = this.getFundGridPatch();
        PiVector[] neighborHalftube = this.makeHalftubeFromQuarterTube(this.m_symS_g.getNeighbor());
        PsVector[][] corner = new PsVector[nol][2];
        PiVector[] ihtubeEnds = new PiVector[nol];
        PiVector.realloc((PiVector[])ihtubeEnds, (int)nol, (int)2);
        PdVector[] bQuad = this.getCornerPoints();
        PdMatrix[] isom = RMap.getABC(bQuad, this.m_ftype);
        int indl = -1;
        boolean found = false;
        int ind = 0;
        while (!found) {
            PdVector N = this.m_NO[ind].getVertex(0);
            if (PuCompGeometry.isInsidePolygon(N, bQuad, true)) {
                indl = ind;
                found = true;
                continue;
            }
            ++ind;
        }
        corner[indl][0] = new PsVector(fund2DGridPatch.getName());
        ihtubeEnds[indl].m_data[0] = 0;
        this.parametrizePolygonHalftube(ihtubeEnds[indl], corner[indl], isom, neighborHalftube, this.m_NO[indl], fund2DGridPatch);
        int[] processed = new int[nol];
        boolean[] checked = new boolean[nol];
        String[] crep = new String[nol];
        crep[indl] = this.m_NO[ind].getName();
        processed[0] = indl;
        checked[indl] = true;
        String[] nb = new String[]{"t", "St", "rt"};
        int next = 1;
        int i = 0;
        while (i < nol) {
            int proci = processed[i];
            int j = 0;
            while (j < 3) {
                String rep = String.valueOf(crep[proci]) + nb[j];
                int index = PuSubgroup.getIndexOfEltInG(rep, this.m_symM_S.getPermutation(), "rst", true);
                if (!checked[index]) {
                    if (j == 0) {
                        corner[index][0] = corner[proci][0];
                        ihtubeEnds[index].m_data[0] = ihtubeEnds[proci].m_data[0];
                        this.parametrizePolygonHalftube(ihtubeEnds[index], corner[index], isom, neighborHalftube, this.m_NO[index], fund2DGridPatch);
                    } else if (j == 1) {
                        corner[index][0] = corner[proci][0];
                        corner[index][1] = corner[proci][1];
                        ihtubeEnds[index].copy(ihtubeEnds[processed[i]]);
                        this.m_NO[index].copy((PsObject)this.m_NO[proci]);
                        int nov = this.m_NO[proci].getNumVertices();
                        int k = 0;
                        while (k < nov) {
                            this.m_NO[index].setVertexNormal(k, new PdVector(0.0, 0.0, 0.0));
                            ++k;
                        }
                    } else {
                        corner[index][0] = new PsVector(corner[proci][1].m_s);
                        ihtubeEnds[index].m_data[0] = ihtubeEnds[proci].m_data[1];
                        this.m_NO[index].getPolygon(0).invert();
                        this.parametrizePolygonHalftube(ihtubeEnds[index], corner[index], isom, neighborHalftube, this.m_NO[index], fund2DGridPatch);
                        this.m_NO[index].getPolygon(0).invert();
                        String stmp = corner[index][1].m_s;
                        corner[index][1].setString(corner[index][0].m_s);
                        corner[index][0].setString(stmp);
                        int aux = ihtubeEnds[index].m_data[0];
                        ihtubeEnds[index].m_data[0] = ihtubeEnds[index].m_data[1];
                        ihtubeEnds[index].m_data[1] = aux;
                    }
                    crep[index] = rep;
                    checked[index] = true;
                    processed[next] = index;
                    if (next < processed.length) {
                        ++next;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void parametrizePolygonHalftube(PiVector ihtubeEnds, PsVector[] corner, PdMatrix[] isom, PiVector[] neighborHalftube, PgPolygonSet pol, PgElementSet twoDGridPatch) {
        int noht = neighborHalftube.length;
        int numVert = pol.getNumVertices();
        int indh = ihtubeEnds.m_data[0];
        PdVector[] bQuad = new PdVector[]{(PdVector)twoDGridPatch.getVertex(0).clone(), (PdVector)twoDGridPatch.getVertex(m_discr * m_discr + 3).clone(), (PdVector)twoDGridPatch.getVertex(m_discr * m_discr).clone(), (PdVector)twoDGridPatch.getVertex(3).clone()};
        PiVector polygon = pol.getPolygon(0);
        PdVector N = (PdVector)pol.getVertex(0).clone();
        PdVector O = (PdVector)pol.getVertex(1).clone();
        boolean[] parametrized = new boolean[numVert];
        String hName = corner[0].m_s;
        PdVector[] vertex = pol.getVertices();
        int shift = 0;
        PdMatrix trans = PuIsometry.getTrans(hName, isom, "abc");
        PdVector[] adjQuad = PuHyperboloid.transform(trans, bQuad);
        if (!PuCompGeometry.isInsidePolygon(vertex[polygon.m_data[0]], adjQuad, true)) {
            System.out.println("Vertex is not inside the transformed quad");
        }
        trans.invert();
        vertex[polygon.m_data[0]].leftMultMatrix(trans);
        this.parametrizeVertexHalftube(vertex[polygon.m_data[0]], polygon.m_data[0], indh, neighborHalftube, twoDGridPatch, pol);
        parametrized[0] = true;
        ++shift;
        boolean finish = false;
        int i = 1;
        while (i < numVert) {
            if (!parametrized[i] && PuCompGeometry.isInsidePolygon(vertex[polygon.m_data[i]], adjQuad, true)) {
                vertex[polygon.m_data[i]].leftMultMatrix(trans);
                this.parametrizeVertexHalftube(vertex[polygon.m_data[i]], polygon.m_data[i], indh, neighborHalftube, twoDGridPatch, pol);
                parametrized[i] = true;
                ++shift;
                if (parametrized[polygon.getSize() - 1]) {
                    corner[1] = new PsVector(hName);
                    ihtubeEnds.m_data[1] = indh;
                    finish = true;
                }
            }
            ++i;
        }
        String[] nb = new String[]{"ab", "a", "cab", "bab"};
        boolean[][] checked = new boolean[noht][5];
        PiVector[] processed = new PiVector[2 * noht];
        checked[indh][0] = true;
        String[] crep = new String[noht];
        if (shift != numVert) {
            crep[0] = hName;
            processed[0] = new PiVector(1);
            processed[0].set(indh);
        }
        int i2 = 0;
        int next = 1;
        int index = -1;
        boolean found = false;
        while (processed[i2] != null && !finish) {
            int proci = processed[i2].m_data[0];
            int j = 0;
            while (j < 4) {
                String rep = String.valueOf(crep[proci]) + nb[j];
                trans = PuIsometry.getTrans(rep, isom, "abc");
                adjQuad = PuHyperboloid.transform(trans, bQuad);
                if (PuCompGeometry.quadIntersectSegment(adjQuad, N, O)) {
                    index = PuSubgroup.getIndexOfEltInG(rep, this.m_symS_g.getPermutation(), "abc", true);
                    int k = 0;
                    while (k < noht) {
                        int m = 0;
                        while (m < 2) {
                            if (neighborHalftube[k].m_data[m] == index) {
                                index = k;
                                found = true;
                            }
                            ++m;
                        }
                        if (found) {
                            found = false;
                            break;
                        }
                        ++k;
                    }
                    if (!checked[index][j + 1]) {
                        checked[index][j + 1] = true;
                        k = 1;
                        while (k < numVert) {
                            if (!parametrized[k] && PuCompGeometry.isInsidePolygon(vertex[polygon.m_data[k]], adjQuad, true)) {
                                trans = PuIsometry.getTrans(rep, isom, "abc");
                                trans.invert();
                                vertex[polygon.m_data[k]].leftMultMatrix(trans);
                                this.parametrizeVertexHalftube(vertex[polygon.m_data[k]], polygon.m_data[k], index, neighborHalftube, twoDGridPatch, pol);
                                parametrized[k] = true;
                                ++shift;
                                if (parametrized[polygon.getSize() - 1]) {
                                    corner[1] = new PsVector(rep);
                                    ihtubeEnds.m_data[1] = index;
                                    finish = true;
                                }
                            }
                            ++k;
                        }
                        if (shift != numVert) {
                            crep[index] = rep;
                            processed[next] = new PiVector(1);
                            processed[next].set(index);
                            ++next;
                        }
                    }
                }
                ++j;
            }
            ++i2;
        }
        if (corner[1] == null) {
            System.out.println("Did not succeed to parametrize polygon");
        }
    }

    private void parametrizeVertexHalftube(PdVector v, int indv, int indh, PiVector[] neighborHalftube, PgElementSet twoDGridPatch, PgPolygonSet pol) {
        int locnoe = (m_discr - 1) * (m_discr - 1);
        int s = this.indOfCell(twoDGridPatch, v);
        if (s == -1) {
            System.err.println("Cell is not found");
        }
        PdVector normal = new PdVector(3);
        int shift = s < locnoe ? neighborHalftube[indh].m_data[0] * locnoe : neighborHalftube[indh].m_data[1] * locnoe;
        v.copy(this.mapTo3D(normal, s, v, twoDGridPatch, this.m_target3DQtube, shift));
        pol.setVertexNormal(indv, normal);
    }

    private void makeNOLinesForQuartertube() {
        int nol = this.m_symM_S.getNumElements();
        int noqt = this.m_symS_g.getNumElements();
        this.m_NO = this.getNO2D();
        this.m_target3DQtube = this.getTargetTube();
        this.m_target2Dtube = this.get2Dtube();
        PsVector[][] corner = new PsVector[nol][2];
        PiVector[] iqtubeEnds = new PiVector[nol];
        PdVector[] bQuad = new PdVector[4];
        PdVector.realloc((PdVector[])bQuad, (int)4, (int)3);
        int i = 0;
        while (i < 4) {
            bQuad[i].copy(this.m_target2Dtube[0].getVertex(i));
            ++i;
        }
        PdMatrix[] isom = RMap.getABC(bQuad, this.m_ftype);
        PiVector.realloc((PiVector[])iqtubeEnds, (int)nol, (int)2);
        PdVector N = (PdVector)this.m_NO[0].getVertex(0).clone();
        int indq = -1;
        PdVector[] tmp = new PdVector[4];
        int i2 = 0;
        while (i2 < noqt) {
            int j = 0;
            while (j < 4) {
                tmp[j] = this.m_target2Dtube[i2].getVertex(j);
                ++j;
            }
            boolean inside = PuCompGeometry.isPointInsidePolygon(N, tmp, true);
            if (inside) {
                indq = i2;
                break;
            }
            ++i2;
        }
        corner[0][0] = new PsVector(this.m_target2Dtube[indq].getName());
        iqtubeEnds[0].m_data[0] = indq;
        PgElementSet identity = this.m_target2Dtube[0];
        this.parametrizePolygon(iqtubeEnds[0], corner[0], isom, this.m_NO[0], identity);
        int[] processed = new int[nol];
        boolean[] checked = new boolean[nol];
        String[] crep = new String[nol];
        crep[0] = "";
        processed[0] = 0;
        checked[0] = true;
        String[] nb = new String[]{"t", "St", "rt"};
        int next = 1;
        int i3 = 0;
        while (i3 < nol) {
            int proci = processed[i3];
            int j = 0;
            while (j < 3) {
                String rep = String.valueOf(crep[proci]) + nb[j];
                int index = PuSubgroup.getIndexOfEltInG(rep, this.m_symM_S.getPermutation(), "rst", true);
                if (!checked[index]) {
                    if (j == 0) {
                        corner[index][0] = corner[proci][0];
                        iqtubeEnds[index].m_data[0] = iqtubeEnds[proci].m_data[0];
                        this.parametrizePolygon(iqtubeEnds[index], corner[index], isom, this.m_NO[index], identity);
                    } else if (j == 1) {
                        corner[index][0] = corner[processed[i3]][0];
                        corner[index][1] = corner[processed[i3]][1];
                        iqtubeEnds[index].copy(iqtubeEnds[processed[i3]]);
                        this.m_NO[index].copy((PsObject)this.m_NO[processed[i3]]);
                        int nov = this.m_NO[processed[i3]].getNumVertices();
                        int k = 0;
                        while (k < nov) {
                            this.m_NO[index].setVertexNormal(k, new PdVector(0.0, 0.0, 0.0));
                            ++k;
                        }
                    } else {
                        corner[index][0] = new PsVector(corner[proci][1].m_s);
                        iqtubeEnds[index].m_data[0] = iqtubeEnds[proci].m_data[1];
                        this.m_NO[index].getPolygon(0).invert();
                        this.parametrizePolygon(iqtubeEnds[index], corner[index], isom, this.m_NO[index], identity);
                        this.m_NO[index].getPolygon(0).invert();
                        String stmp = corner[index][1].m_s;
                        corner[index][1].setString(corner[index][0].m_s);
                        corner[index][0].setString(stmp);
                        int aux = iqtubeEnds[index].m_data[0];
                        iqtubeEnds[index].m_data[0] = iqtubeEnds[index].m_data[1];
                        iqtubeEnds[index].m_data[1] = aux;
                    }
                    crep[index] = rep;
                    checked[index] = true;
                    processed[next] = index;
                    if (next < processed.length - 1) {
                        ++next;
                    }
                }
                ++j;
            }
            ++i3;
        }
    }

    private void parametrizePolygon(PiVector iqtubeEnds, PsVector[] corner, PdMatrix[] isom, PgPolygonSet pol, PgElementSet identity) {
        int noqt = this.m_symS_g.getNumElements();
        int numVert = pol.getNumVertices();
        int indq = iqtubeEnds.m_data[0];
        PdVector[] bQuad = new PdVector[4];
        PdVector.realloc((PdVector[])bQuad, (int)4, (int)3);
        int i = 0;
        while (i < 4) {
            bQuad[i].copy(identity.getVertex(i));
            ++i;
        }
        PiVector polygon = pol.getPolygon(0);
        PdVector N = (PdVector)pol.getVertex(0).clone();
        PdVector O = (PdVector)pol.getVertex(1).clone();
        boolean[] parametrized = new boolean[numVert];
        PiVector finished = new PiVector();
        String qName = corner[0].m_s;
        PdVector[] vertex = pol.getVertices();
        PdMatrix trans = PuIsometry.getTrans(qName, isom, "abc");
        PdVector[] adjQuad = new PdVector[4];
        int k = 0;
        while (k < 4) {
            adjQuad[k] = new PdVector(3);
            trans.leftMultMatrix(adjQuad[k], bQuad[k]);
            ++k;
        }
        if (!PuCompGeometry.isPointInsidePolygon(vertex[polygon.m_data[0]], adjQuad, true)) {
            System.out.println("Vertex is not inside");
        }
        trans.invert();
        vertex[polygon.m_data[0]].leftMultMatrix(trans);
        this.parametrizeVertex(vertex[polygon.m_data[0]], polygon.m_data[0], indq, identity, pol);
        parametrized[0] = true;
        finished.addEntry(1);
        int i2 = 0;
        while (i2 < numVert) {
            if (!parametrized[i2] && PuCompGeometry.isPointInsidePolygon(vertex[polygon.m_data[i2]], adjQuad, true)) {
                trans = PuIsometry.getTrans(qName, isom, "abc");
                trans.invert();
                vertex[polygon.m_data[i2]].leftMultMatrix(trans);
                this.parametrizeVertex(vertex[polygon.m_data[i2]], polygon.m_data[i2], indq, identity, pol);
                parametrized[i2] = true;
                finished.addEntry(1);
                if (parametrized[polygon.getSize() - 1]) {
                    corner[1] = new PsVector(qName);
                    iqtubeEnds.m_data[1] = indq;
                }
            }
            ++i2;
        }
        String[] nb = new String[]{"bc", "c", "abc", "C"};
        boolean[][] checked = new boolean[noqt][5];
        PiVector[] processed = new PiVector[2 * noqt];
        checked[indq][0] = true;
        String[] crep = new String[noqt];
        if (finished.getSize() != numVert) {
            crep[indq] = qName;
            processed[0] = new PiVector(1);
            processed[0].set(indq);
        }
        int i3 = 0;
        int next = 1;
        int index = -1;
        while (processed[i3] != null) {
            int proci = processed[i3].m_data[0];
            int j = 0;
            while (j < 4) {
                String rep = String.valueOf(crep[proci]) + nb[j];
                index = PuSubgroup.getIndexOfEltInG(rep, this.m_symS_g.getPermutation(), "abc", true);
                trans = PuIsometry.getTrans(rep, isom, "abc");
                int k2 = 0;
                while (k2 < 4) {
                    adjQuad[k2] = new PdVector(3);
                    trans.leftMultMatrix(adjQuad[k2], bQuad[k2]);
                    ++k2;
                }
                if (PuCompGeometry.quadIntersectSegment(adjQuad, N, O) && !checked[index][j + 1]) {
                    checked[index][j + 1] = true;
                    k2 = 0;
                    while (k2 < numVert) {
                        if (!parametrized[k2] && PuCompGeometry.isPointInsidePolygon(vertex[polygon.m_data[k2]], adjQuad, true)) {
                            trans = PuIsometry.getTrans(rep, isom, "abc");
                            trans.invert();
                            vertex[polygon.m_data[k2]].leftMultMatrix(trans);
                            this.parametrizeVertex(vertex[polygon.m_data[k2]], polygon.m_data[k2], index, identity, pol);
                            parametrized[k2] = true;
                            finished.addEntry(1);
                            if (parametrized[polygon.getSize() - 1]) {
                                corner[1] = new PsVector(rep);
                                iqtubeEnds.m_data[1] = index;
                            }
                        }
                        ++k2;
                    }
                    if (finished.getSize() != numVert) {
                        crep[index] = rep;
                        processed[next] = new PiVector(1);
                        processed[next].set(index);
                        ++next;
                    }
                }
                ++j;
            }
            ++i3;
        }
    }

    private void parametrizeVertex(PdVector v, int indv, int indq, PgElementSet cqtube, PgPolygonSet pol) {
        int locnoe = (m_discr - 1) * (m_discr - 1);
        PdVector[] corner = new PdVector[4];
        int i = 0;
        while (i < 4) {
            corner[i] = (PdVector)cqtube.getVertex(i).clone();
            ++i;
        }
        int s = this.indOfCellNew(corner, v);
        if (s == -1) {
            System.err.println("Cell is not found");
        }
        PdVector normal = new PdVector(3);
        v.copy(this.mapTo3D(normal, s, v, cqtube, this.m_target3DQtube, indq * locnoe));
        pol.setVertexNormal(indv, normal);
    }

    public PgPolygonSet[] getNO2D() {
        int nop = this.m_symM_S.getNumElements();
        PgPolygonSet[] NO = new PgPolygonSet[nop];
        PgElementSet tri2DI = this.getTri2D()[0];
        NO[0] = this.getNOTri(tri2DI);
        NO[0].setName(" ");
        int[] processed = new int[nop];
        boolean[] checked = new boolean[nop];
        String[] crep = new String[nop];
        int p = this.m_sparam.m_data[2];
        int q = this.m_sparam.m_data[3];
        int g = this.m_sparam.m_data[0];
        double cosa = Math.cos(Math.PI / (double)q) / Math.sin(Math.PI / (double)p);
        double cosb = Math.cos(Math.PI / (double)p) / Math.sin(Math.PI / (double)q);
        PdVector O = new PdVector(1.0, 0.0, 0.0);
        PdVector N = new PdVector(cosb, -Math.sinh(PuMath.acosh((double)cosb)), 0.0);
        PdVector M = new PdVector(cosa, 0.0, PuMath.sinh((double)PuMath.acosh((double)cosa)));
        PdVector[] bTriangle = new PdVector[]{N, O, M};
        PdMatrix[] isom = PuIsometry.getIsometries(p, q, bTriangle, g);
        PdMatrix trans = new PdMatrix(3);
        crep[0] = " ";
        processed[0] = 0;
        checked[0] = true;
        String[] nb = new String[]{"t", "St", "rt"};
        int next = 1;
        int i = 0;
        while (i < nop) {
            int j = 0;
            while (j < 3) {
                String rep = String.valueOf(crep[processed[i]]) + nb[j];
                int index = PuSubgroup.getIndexOfEltInG(rep, this.m_symM_S.getPermutation(), "rst", true);
                if (!checked[index]) {
                    trans = PuIsometry.getTrans(rep, isom, "rst");
                    NO[index] = (PgPolygonSet)NO[0].clone();
                    NO[index].setName(rep);
                    int k = 0;
                    while (k < m_discr) {
                        NO[index].getVertex(k).leftMultMatrix(trans);
                        ++k;
                    }
                    crep[index] = rep;
                    checked[index] = true;
                    processed[next] = index;
                    if (next < processed.length - 1) {
                        ++next;
                    }
                }
                ++j;
            }
            ++i;
        }
        return NO;
    }

    private PdVector mapTo3D(PdVector normal, int b, PdVector p, PgElementSet twoD, PgElementSet threeD, int indexQtube) {
        PdVector Pp = (PdVector)p.clone();
        int nov = twoD.getNumVertices();
        int locnoe = (m_discr - 1) * (m_discr - 1);
        PdVector[] Pvertex = new PdVector[nov];
        PiVector[] Helt = twoD.getElements();
        int i = 0;
        while (i < nov) {
            Pvertex[i] = (PdVector)twoD.getVertex(i).clone();
            ++i;
        }
        double[] triangleArea = new double[4];
        PuHyperbolic.projectToPoincareDisk(Pp);
        PuHyperbolic.projectToPoincareDisk(Pvertex);
        int j = 0;
        while (j < 4) {
            double area;
            PdVector tmp = Pvertex[Helt[b].m_data[(j + 3) % 4]];
            PdVector tmp1 = Pvertex[Helt[b].m_data[j]];
            PdVector tmp2 = Pvertex[Helt[b].m_data[(j + 1) % 4]];
            triangleArea[j] = area = PuHyperbolic.computeAreaHyperbolic(tmp, tmp1, tmp2);
            ++j;
        }
        double[] localArea = new double[4];
        double[] w = new double[4];
        int j2 = 0;
        while (j2 < 4) {
            localArea[j2] = PuHyperbolic.computeAreaHyperbolic(Pp, Pvertex[Helt[b].m_data[j2]], Pvertex[Helt[b].m_data[(j2 + 1) % 4]]);
            ++j2;
        }
        double sum = 0.0;
        int j3 = 0;
        while (j3 < 4) {
            w[j3] = triangleArea[j3] * localArea[(j3 + 1) % 4] * localArea[(j3 + 2) % 4];
            sum += w[j3];
            ++j3;
        }
        PdVector nP = new PdVector(0.0, 0.0, 0.0);
        if (b >= locnoe) {
            b -= locnoe;
        }
        PiVector threeDElt = threeD.getElement(indexQtube + b);
        int j4 = 0;
        while (j4 < 4) {
            nP = PdVector.blendNew((double)1.0, (PdVector)nP, (double)w[j4], (PdVector)threeD.getVertex(threeDElt.m_data[j4]));
            normal.copy(PdVector.blendNew((double)1.0, (PdVector)normal, (double)w[j4], (PdVector)threeD.getVertexNormal(threeDElt.m_data[j4])));
            ++j4;
        }
        nP.multScalar(1.0 / sum);
        normal.multScalar(1.0 / sum);
        normal.normalize();
        return nP;
    }

    private int indOfCell(PgElementSet geom, PdVector p) {
        int ind = -1;
        int noc = geom.getNumElements();
        boolean insideQuad = false;
        PiVector[] cell = geom.getElements();
        PdVector[] cv = new PdVector[4];
        int i = 0;
        while (i < noc) {
            int j = 0;
            while (j < 4) {
                cv[j] = geom.getVertex(cell[i].m_data[j]);
                ++j;
            }
            if (this.m_ftype.equals(TYPE_111)) {
                insideQuad = PuCompGeometry.isInsidePolygon(p, cv, false);
            }
            if (this.m_ftype.equals(TYPE_121) && insideQuad) {
                ind = i;
                break;
            }
            ++i;
        }
        return ind;
    }

    private int indOfCellNew(PdVector[] corner, PdVector p) {
        boolean inside;
        double eps = 1.0E-8;
        PdVector[] N1N0 = PuHyperboloid.makeEdge(corner[1], corner[0], m_discr);
        PdVector[] N2N3 = PuHyperboloid.makeEdge(corner[2], corner[3], m_discr);
        PdVector[] N1N2 = PuHyperboloid.makeEdge(corner[1], corner[2], m_discr);
        PdVector[] N0N3 = PuHyperboloid.makeEdge(corner[0], corner[3], m_discr);
        PdVector[] normal_i = new PdVector[m_discr];
        PdVector[] normal_j = new PdVector[m_discr];
        int i = 0;
        while (i < m_discr) {
            normal_i[i] = PdVector.crossNew((PdVector)N1N2[i], (PdVector)N0N3[i]);
            normal_i[i].normalize();
            ++i;
        }
        i = 0;
        while (i < m_discr) {
            normal_j[i] = PdVector.crossNew((PdVector)N2N3[i], (PdVector)N1N0[i]);
            normal_j[i].normalize();
            ++i;
        }
        int ind_i = -1;
        int ind_j = -1;
        int i2 = 0;
        while (i2 < m_discr - 1) {
            double dot_i = PdVector.dot((PdVector)p, (PdVector)normal_i[i2]);
            double dot_ip1 = PdVector.dot((PdVector)p, (PdVector)normal_i[i2 + 1]);
            boolean bl = inside = dot_i < -eps && dot_ip1 > eps || Math.abs(dot_i) < eps && dot_ip1 > eps || dot_i < -eps && Math.abs(dot_ip1) < eps || Math.abs(dot_i) < eps && Math.abs(dot_ip1) < eps;
            if (inside) {
                ind_i = i2;
                break;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < m_discr - 1) {
            double dot_j = PdVector.dot((PdVector)p, (PdVector)normal_j[i2]);
            double dot_jp1 = PdVector.dot((PdVector)p, (PdVector)normal_j[i2 + 1]);
            boolean bl = inside = dot_j < -eps && dot_jp1 > eps || Math.abs(dot_j) < eps && dot_jp1 > eps || dot_j < -eps && Math.abs(dot_jp1) < eps || Math.abs(dot_j) < eps && Math.abs(dot_jp1) < eps;
            if (inside) {
                ind_j = i2;
                break;
            }
            ++i2;
        }
        return ind_j * (m_discr - 1) + ind_i;
    }

    private PgPolygonSet getNOTri(PgElementSet tile) {
        PgPolygonSet pol = new PgPolygonSet(3);
        int n = m_discr;
        pol.setNumVertices(n);
        pol.setNumPolygons(1);
        PdVector[] vertex = tile.getVertices();
        pol.setVertex(0, vertex[0]);
        pol.setVertex(1, vertex[1]);
        PiVector f = new PiVector(n);
        f.m_data[0] = 0;
        f.m_data[n - 1] = 1;
        int i = 1;
        while (i < n - 1) {
            pol.setVertex(i + 1, vertex[i + 2]);
            ++i;
        }
        i = 1;
        while (i < n - 1) {
            f.m_data[i] = i + 1;
            ++i;
        }
        pol.setPolygon(0, f);
        return pol;
    }

    public PgElementSet getI2DTargetQtube() {
        return this.getFundGridPatch();
    }

    public PgElementSet[] get2Dtube() {
        if (this.m_targetMap != null) {
            if (this.m_ftype.equals(TYPE_111)) {
                this.make2Dqtube();
            }
            if (this.m_ftype.equals(TYPE_121)) {
                this.make2Dhtube();
            }
        }
        return this.m_target2Dtube;
    }

    private void make2Dhtube() {
        this.m_target2Dtube = new PgElementSet[5];
        this.m_target2Dtube[0] = this.m_fundPatch;
        PdVector[] bQuad = this.getCornerPoints();
        PdMatrix[] isom = RMap.getABC(bQuad, this.m_ftype);
        String[] trans = new String[]{"bab", "ab", "a", "cab"};
        int i = 0;
        while (i < trans.length) {
            PdMatrix M = PuIsometry.getTrans(trans[i], isom, "abc");
            PdVector[] AbQuad = PuHyperboloid.transform(M, bQuad);
            PgElementSet f = new PgElementSet(3);
            f.setName(trans[i]);
            this.makeHalftubeGrid(f, AbQuad);
            this.m_target2Dtube[i + 1] = f;
            ++i;
        }
    }

    private void make2Dqtube() {
        int noqt = this.m_symS_g.getNumElements();
        this.m_target2Dtube = new PgElementSet[noqt];
        PdVector[] bQuad = this.getCornerPoints();
        PdMatrix[] isom = RMap.getABC(bQuad, this.m_ftype);
        this.m_target2Dtube[0] = this.make2DGrid(bQuad, m_discr);
        PiVector[] gridNeighbor = this.m_target2Dtube[0].getNeighbours();
        String[] coset = this.m_symS_g.getCosetElements();
        String[] sub = this.m_symS_g.getSubGroupElements();
        boolean[] oriented = this.m_symS_g.getElementOrientation();
        int clen = coset.length;
        int slen = sub.length;
        int i = 0;
        while (i < clen) {
            String inv = PuIsometry.getInverseStringElt(coset[i], "abc");
            int j = 0;
            while (j < slen) {
                String mov = String.valueOf(inv) + sub[j];
                int index = PuSubgroup.getIndexOfEltInG(mov, this.m_symS_g.getPermutation(), "abc", true);
                PdMatrix trans = PuIsometry.getTrans(mov, isom, "abc");
                PdVector[] transVertex = new PdVector[4];
                PdVector.realloc((PdVector[])transVertex, (int)4, (int)4);
                int k = 0;
                while (k < 4) {
                    trans.leftMultMatrix(transVertex[k], bQuad[k]);
                    ++k;
                }
                this.m_target2Dtube[index] = this.make2DGrid(transVertex, m_discr);
                this.m_target2Dtube[index].setName(" " + mov);
                if (!oriented[index]) {
                    k = 0;
                    while (k < this.m_target2Dtube[index].getNumElements()) {
                        this.m_target2Dtube[index].getElement(k).invert();
                        ++k;
                    }
                    k = 0;
                    while (k < this.m_target2Dtube[index].getNumElements()) {
                        PiVector aux = (PiVector)gridNeighbor[k].clone();
                        aux.invert();
                        this.m_target2Dtube[index].setNeighbour(k, aux);
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public PgElementSet getFundGridPatch() {
        PgElementSet grid = new PgElementSet(3);
        grid.setName(" ");
        PdVector[] corner = this.getCornerPoints();
        if (this.m_ftype.equals(TYPE_121)) {
            this.makeHalftubeGrid(grid, corner);
        } else {
            grid.copy((PsObject)this.make2DGrid(corner, m_discr));
        }
        return grid;
    }

    private PdVector[] fundQuadrilateral() {
        int p = this.m_sparam.m_data[2];
        double phi = Math.PI / (double)p;
        double a1 = PuHyperboloid.dist(PuHyperboloid.m_O, PuHyperboloid.m_P);
        double a2 = PuMath.asinh((double)(Math.cos(phi) / Math.sinh(a1)));
        double b1 = PuMath.acosh((double)(Math.cosh(a1) / Math.sin(phi)));
        PdVector N0 = new PdVector(Math.cosh(b1), -Math.sinh(b1), 0.0);
        PdVector N1 = new PdVector(1.0, 0.0, 0.0);
        PdVector N2 = new PdVector(Math.cosh(2.0 * a2), 0.0, PuMath.sinh((double)(2.0 * a2)));
        PdMatrix m = new PdMatrix(3);
        double theta = PuHyperboloid.orientedAngle(N1, N2, N0);
        PuHyperboloid.translateToOrigin(m, N2);
        PdMatrix minv = PdMatrix.copyNew((PdMatrix)m);
        minv.invert();
        m.leftMult(PuIsometry.translate(-b1));
        m.leftMult(PuIsometry.rotation(-theta));
        m.leftMult(minv);
        PdVector N3 = new PdVector(3);
        N3.leftMultMatrix(m, N2);
        PdVector[] bQuad = new PdVector[]{N0, N1, N2, N3};
        return bQuad;
    }

    public PgElementSet[] generateSymmetryGroup() {
        PdVector[] bQuad = this.fundQuadrilateral();
        PdMatrix[] isom = RMap.getABC(bQuad, this.m_ftype);
        PgElementSet[] geom = new PgElementSet[this.m_symS_g.getNumElements()];
        geom[0] = this.make2DGrid(bQuad, m_discr);
        PiVector[] gridNeighbor = geom[0].getNeighbours();
        String[] coset = this.m_symS_g.getCosetElements();
        String[] sub = this.m_symS_g.getSubGroupElements();
        boolean[] oriented = this.m_symS_g.getElementOrientation();
        Color[] color = this.m_symM_S.getColors();
        int clen = coset.length;
        int slen = sub.length;
        int i = 0;
        while (i < clen) {
            String inv = PuIsometry.getInverseStringElt(coset[i], "abc");
            int j = 0;
            while (j < slen) {
                String mov = String.valueOf(inv) + sub[j];
                int index = PuSubgroup.getIndexOfEltInG(mov, this.m_symS_g.getPermutation(), "abc", true);
                PdMatrix trans = PuIsometry.getTrans(mov, isom, "abc");
                PdVector[] transVertex = new PdVector[4];
                PdVector.realloc((PdVector[])transVertex, (int)4, (int)4);
                int k = 0;
                while (k < 4) {
                    trans.leftMultMatrix(transVertex[k], bQuad[k]);
                    ++k;
                }
                geom[index] = this.make2DGrid(transVertex, m_discr);
                geom[index].setName(" " + mov);
                k = 0;
                while (k < geom[index].getNumElements()) {
                    geom[index].setElementColor(k, color[i]);
                    ++k;
                }
                if (!oriented[index]) {
                    k = 0;
                    while (k < geom[index].getNumElements()) {
                        geom[index].getElement(k).invert();
                        ++k;
                    }
                    k = 0;
                    while (k < geom[index].getNumElements()) {
                        PiVector aux = (PiVector)gridNeighbor[k].clone();
                        aux.invert();
                        geom[index].setNeighbour(k, aux);
                        ++k;
                    }
                }
                geom[index].showElementColors(true);
                ++j;
            }
            ++i;
        }
        return geom;
    }

    public static PdMatrix[] getABC(PdVector[] N, String ftype) {
        PdMatrix[] iso = new PdMatrix[3];
        double theta = PuHyperboloid.orientedAngle(N[3], N[0], N[2]);
        double alpha = PuHyperboloid.orientedAngle(N[0], N[1], N[3]);
        PdMatrix T = new PdMatrix(3);
        PdMatrix Tinv = new PdMatrix(3);
        if (ftype.equals(TYPE_111)) {
            PuHyperboloid.translateToOrigin(T, N[0]);
            Tinv.copy(T);
            Tinv.invert();
            iso[1] = T;
            iso[1].leftMult(PuIsometry.rotation(alpha + theta));
            iso[1].leftMult(Tinv);
            PdVector midN1N2 = PuHyperboloid.getMidPoint(N[1], N[2]);
            double phi = Math.PI;
            PdMatrix R0 = new PdMatrix(3);
            PuHyperboloid.rotateAroundPoint(R0, midN1N2, phi);
            PdVector tN0 = new PdVector(3);
            PdVector tN3 = new PdVector(3);
            tN0.leftMultMatrix(R0, N[0]);
            tN3.leftMultMatrix(R0, N[3]);
            PdVector mid = PuHyperboloid.getMidPoint(tN0, tN3);
            PdMatrix R1 = new PdMatrix(3);
            PuHyperboloid.rotateAroundPoint(R1, mid, phi);
            R0.leftMult(R1);
            iso[0] = R0;
            iso[2] = PuHyperboloid.translateEdge(N[3], N[2], N[0], N[1]);
        } else if (ftype.equals(TYPE_121)) {
            iso[0] = PuHyperboloid.translateEdge(N[0], N[3], N[1], N[2]);
            PuHyperboloid.translateToOrigin(T, N[0]);
            Tinv.copy(T);
            Tinv.invert();
            iso[1] = T;
            iso[1].leftMult(PuIsometry.rotation(alpha + theta));
            iso[1].leftMult(Tinv);
            PdMatrix AB = new PdMatrix(3);
            AB.copy(iso[1]);
            AB.leftMult(iso[0]);
            PdVector transN2 = new PdVector(3);
            PdVector transN3 = new PdVector(3);
            transN2.leftMultMatrix(AB, N[2]);
            transN3.leftMultMatrix(AB, N[3]);
            iso[2] = PuHyperboloid.translateEdge(transN2, transN3, N[3], N[2]);
        }
        return iso;
    }

    public PgElementSet getTargetTube() {
        if (this.m_hasTargetQtube) {
            return this.m_target3DQtube;
        }
        if (this.m_targetMap != null) {
            this.makeTargetTube();
        }
        return this.m_target3DQtube;
    }

    public void setSpaceModel(PgElementSet geom) {
        this.m_target3DQtube = geom;
        this.hasSpaceModel(true);
    }

    public void hasSpaceModel(boolean flag) {
        this.m_hasTargetQtube = flag;
    }

    private void makeTargetTube() {
        if (!this.m_hasSkeleton) {
            this.computeControlSkeleton(this.m_skeleton);
        }
        this.setSkeleton(this.m_skeleton);
        PgPolygonSet[] NO = this.m_targetMap.m_NO;
        int noqt = NO.length;
        String[] eltM_T = this.m_symM_T.getElements();
        PgElementSet[] qtube3D = new PgElementSet[noqt];
        int i = 0;
        while (i < noqt) {
            qtube3D[i] = this.getQtube(NO, NO[i], i, this.m_symM_T);
            ++i;
        }
        PgElementSet[] tmp = new PgElementSet[noqt];
        int i2 = 0;
        while (i2 < noqt) {
            String repM_T = eltM_T[i2];
            String repS_g = this.convertToABC(repM_T);
            int index = PuSubgroup.getIndexOfEltInG(repS_g, this.m_symS_g.getPermutation(), "abc", true);
            tmp[index] = qtube3D[i2];
            ++i2;
        }
        this.m_target3DQtube.copy((PsObject)tmp[0]);
        int locnov = this.m_target3DQtube.getNumVertices();
        int locnoe = this.m_target3DQtube.getNumElements();
        this.m_target3DQtube.setNumVertices(noqt * locnov);
        this.m_target3DQtube.setNumElements(noqt * locnoe);
        PiVector[] neighbor = this.m_symS_g.getNeighbor();
        boolean[] checked = new boolean[noqt];
        int i3 = 0;
        while (i3 < noqt) {
            PiVector nb = neighbor[i3];
            int j = 0;
            while (j < 3) {
                if (!checked[nb.m_data[j]]) {
                    PgElementSet nt = tmp[nb.m_data[j]];
                    int k = 0;
                    while (k < locnov) {
                        this.m_target3DQtube.setVertex(nb.m_data[j] * locnov + k, nt.getVertex(k));
                        ++k;
                    }
                    k = 0;
                    while (k < locnoe) {
                        PiVector f = nt.getElement(k);
                        f.add(nb.m_data[j] * locnov);
                        this.m_target3DQtube.setElement(nb.m_data[j] * locnoe + k, f);
                        this.m_target3DQtube.getElement(nb.m_data[j] * locnoe + k).setName("Q :" + nb.m_data[j] + "," + k);
                        ++k;
                    }
                    checked[nb.m_data[j]] = true;
                }
                ++j;
            }
            ++i3;
        }
        PiVector[] elt = this.m_target3DQtube.getElements();
        int n = m_discr;
        PiVector celt = new PiVector(n - 1);
        PiVector nbelt = new PiVector(n - 1);
        int i4 = 0;
        while (i4 < noqt) {
            int cshifte = i4 * locnoe;
            PiVector nb = neighbor[i4];
            int j = 0;
            while (j < 3) {
                int k;
                int nbshifte = nb.m_data[j] * locnoe;
                if (j == 0) {
                    k = 0;
                    while (k < n - 1) {
                        celt.m_data[k] = cshifte + (n - 2) * (n - 1) + k;
                        nbelt.m_data[k] = nbshifte + (n - 2) * n - k;
                        ++k;
                    }
                    k = 0;
                    while (k < n - 1) {
                        if (elt[celt.m_data[k]].m_data[3] < elt[nbelt.m_data[k]].m_data[2]) {
                            elt[nbelt.m_data[k]].m_data[2] = elt[celt.m_data[k]].m_data[3];
                        } else {
                            elt[celt.m_data[k]].m_data[3] = elt[nbelt.m_data[k]].m_data[2];
                        }
                        if (elt[celt.m_data[k]].m_data[2] < elt[nbelt.m_data[k]].m_data[3]) {
                            elt[nbelt.m_data[k]].m_data[3] = elt[celt.m_data[k]].m_data[2];
                        } else {
                            elt[celt.m_data[k]].m_data[2] = elt[nbelt.m_data[k]].m_data[3];
                        }
                        ++k;
                    }
                } else if (j == 1) {
                    k = 0;
                    while (k < n - 1) {
                        celt.m_data[k] = cshifte + k * (n - 1);
                        nbelt.m_data[k] = nbshifte + k * (n - 1) + (n - 2);
                        ++k;
                    }
                    k = 0;
                    while (k < n - 1) {
                        if (elt[celt.m_data[k]].m_data[0] < elt[nbelt.m_data[k]].m_data[1]) {
                            elt[nbelt.m_data[k]].m_data[1] = elt[celt.m_data[k]].m_data[0];
                        } else {
                            elt[celt.m_data[k]].m_data[0] = elt[nbelt.m_data[k]].m_data[1];
                        }
                        if (elt[celt.m_data[k]].m_data[3] < elt[nbelt.m_data[k]].m_data[2]) {
                            elt[nbelt.m_data[k]].m_data[2] = elt[celt.m_data[k]].m_data[3];
                        } else {
                            elt[celt.m_data[k]].m_data[3] = elt[nbelt.m_data[k]].m_data[2];
                        }
                        ++k;
                    }
                    k = 0;
                    while (k < n - 1) {
                        celt.m_data[k] = cshifte + k * (n - 1) + (n - 2);
                        nbelt.m_data[k] = nbshifte + k * (n - 1);
                        ++k;
                    }
                    k = 0;
                    while (k < n - 1) {
                        if (elt[celt.m_data[k]].m_data[1] < elt[nbelt.m_data[k]].m_data[0]) {
                            elt[nbelt.m_data[k]].m_data[0] = elt[celt.m_data[k]].m_data[1];
                        } else {
                            elt[celt.m_data[k]].m_data[1] = elt[nbelt.m_data[k]].m_data[0];
                        }
                        if (elt[celt.m_data[k]].m_data[2] < elt[nbelt.m_data[k]].m_data[3]) {
                            elt[nbelt.m_data[k]].m_data[3] = elt[celt.m_data[k]].m_data[2];
                        } else {
                            elt[celt.m_data[k]].m_data[2] = elt[nbelt.m_data[k]].m_data[3];
                        }
                        ++k;
                    }
                } else if (j == 2) {
                    k = 0;
                    while (k < n - 1) {
                        celt.m_data[k] = cshifte + k;
                        nbelt.m_data[k] = nbshifte + n - 2 - k;
                        ++k;
                    }
                    k = 0;
                    while (k < n - 1) {
                        if (elt[celt.m_data[k]].m_data[0] < elt[nbelt.m_data[k]].m_data[1]) {
                            elt[nbelt.m_data[k]].m_data[1] = elt[celt.m_data[k]].m_data[0];
                        } else {
                            elt[celt.m_data[k]].m_data[0] = elt[nbelt.m_data[k]].m_data[1];
                        }
                        if (elt[celt.m_data[k]].m_data[1] < elt[nbelt.m_data[k]].m_data[0]) {
                            elt[nbelt.m_data[k]].m_data[0] = elt[celt.m_data[k]].m_data[1];
                        } else {
                            elt[celt.m_data[k]].m_data[1] = elt[nbelt.m_data[k]].m_data[0];
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i4;
        }
        this.m_target3DQtube.removeUnusedVertices();
        this.m_target3DQtube.makeNeighbour();
        this.m_target3DQtube.makeVertexNormals();
    }

    private String convertToRST(String s) {
        String rep = "";
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == 'c' || s.charAt(i) == 'C') {
                rep = String.valueOf(rep) + this.m_gen[1];
            }
            if (s.charAt(i) == 'a') {
                rep = String.valueOf(rep) + this.m_gen[0];
            }
            if (s.charAt(i) == 'b') {
                rep = String.valueOf(rep) + this.m_gen[2];
            }
            if (s.charAt(i) == 'A') {
                rep = String.valueOf(rep) + PuIsometry.getInverseStringElt(this.m_gen[0], "rst");
            }
            if (s.charAt(i) == 'B') {
                rep = String.valueOf(rep) + PuIsometry.getInverseStringElt(this.m_gen[2], "rst");
            }
            ++i;
        }
        return rep;
    }

    private String convertToABC(String s) {
        String rep = "";
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == 't' || s.charAt(i) == 'T') {
                rep = String.valueOf(rep) + "bc";
            }
            if (s.charAt(i) == 'r') {
                rep = String.valueOf(rep) + "a";
            }
            if (s.charAt(i) == 's') {
                rep = String.valueOf(rep) + "b";
            }
            if (s.charAt(i) == 'R') {
                rep = String.valueOf(rep) + "bcabc";
            }
            if (s.charAt(i) == 'S') {
                rep = String.valueOf(rep) + "B";
            }
            ++i;
        }
        return rep;
    }

    private PgElementSet getQtube(PgPolygonSet[] NO, PgPolygonSet pol, int indPol, symGroup sym) {
        PdVector n;
        PdVector n2;
        PgElementSet tube = new PgElementSet(3);
        PiVector polIndex = pol.getPolygon(0);
        PdVector[] vertex = pol.getVertices();
        int radialDiscr = m_discr;
        int polyDiscr = m_discr;
        tube.setNumVertices(polyDiscr * (radialDiscr - 1));
        PdVector[] frame_e2 = new PdVector[polyDiscr];
        PdVector[] frame_e3 = new PdVector[polyDiscr];
        PdVector[] frame_base = new PdVector[polyDiscr];
        PdVector[] polygon = pol.getVertices();
        PdVector[] normal = pol.getVertexNormals();
        PiVector[] neighbor = sym.getNeighbor();
        PiVector nb = neighbor[indPol];
        PgPolygonSet nPol0 = NO[nb.m_data[0]];
        PgPolygonSet nPol1 = NO[nb.m_data[2]];
        PdVector dir1 = PdVector.subNew((PdVector)vertex[polIndex.m_data[1]], (PdVector)pol.getVertex(0));
        PdVector dir2 = PdVector.subNew((PdVector)nPol0.getVertex(polIndex.m_data[1]), (PdVector)nPol0.getVertex(0));
        PdVector normAtN = pol.getVertexNormal(0);
        dir1 = PdVector.crossNew((PdVector)normAtN, (PdVector)PdVector.crossNew((PdVector)dir1, (PdVector)normAtN));
        dir2 = PdVector.crossNew((PdVector)normAtN, (PdVector)PdVector.crossNew((PdVector)dir2, (PdVector)normAtN));
        double angleEnd = Math.PI / 180 * PdVector.angle((PdVector)dir1, (PdVector)dir2);
        dir1 = PdVector.subNew((PdVector)vertex[polIndex.m_data[polyDiscr - 2]], (PdVector)pol.getVertex(1));
        dir2 = PdVector.subNew((PdVector)nPol1.getVertex(polIndex.m_data[polyDiscr - 2]), (PdVector)nPol1.getVertex(1));
        PdVector normAtO = pol.getVertexNormal(1);
        dir1 = PdVector.crossNew((PdVector)normAtO, (PdVector)PdVector.crossNew((PdVector)dir1, (PdVector)normAtO));
        dir2 = PdVector.crossNew((PdVector)normAtO, (PdVector)PdVector.crossNew((PdVector)dir2, (PdVector)normAtO));
        int sign = sym.getElementOrientation()[indPol] ? 1 : -1;
        double angleStart = sign == -1 ? Math.abs(PdVector.angleWithOrientation((PdVector)dir1, (PdVector)dir2, (PdVector)normAtO)) : Math.abs(PdVector.angleWithOrientation((PdVector)dir2, (PdVector)dir1, (PdVector)normAtO));
        double dEnd = 1.0 / Math.tan(angleEnd / 2.0);
        double dStart = 1.0 / Math.tan(angleStart / 2.0);
        frame_e2[0] = pol.getVertexNormal(1);
        PdVector tanDir = PdVector.subNew((PdVector)vertex[polIndex.m_data[polyDiscr - 2]], (PdVector)vertex[polIndex.m_data[polyDiscr - 1]]);
        if (sign == 1) {
            n2 = PdVector.crossNew((PdVector)frame_e2[0], (PdVector)tanDir);
            frame_e3[0] = PdVector.crossNew((PdVector)n2, (PdVector)frame_e2[0]);
        } else {
            n2 = PdVector.crossNew((PdVector)tanDir, (PdVector)frame_e2[0]);
            frame_e3[0] = PdVector.crossNew((PdVector)frame_e2[0], (PdVector)n2);
        }
        frame_e3[0].normalize();
        PuVectorGeom.rotatePointAroundVector((PdVector)frame_e3[0], (PdVector)frame_e3[0], (PdVector)frame_e2[0], (double)((double)(-sign) * angleStart / 2.0));
        frame_e3[0].setLength(1.0 / Math.sin(angleStart / 2.0));
        frame_base[0] = polygon[1];
        frame_e2[0].multScalar((double)sign);
        int i = 1;
        while (i < polyDiscr - 1) {
            frame_e2[i] = normal[polIndex.m_data[polyDiscr - 1 - i]];
            frame_e2[i].normalize();
            tanDir = PdVector.subNew((PdVector)vertex[polIndex.m_data[polyDiscr - i - 2]], (PdVector)vertex[polIndex.m_data[polyDiscr - 1 - i]]);
            frame_e3[i] = sign == 1 ? PdVector.crossNew((PdVector)tanDir, (PdVector)frame_e2[i]) : PdVector.crossNew((PdVector)frame_e2[i], (PdVector)tanDir);
            frame_e3[i].normalize();
            double t = (double)i / (double)(polyDiscr - 1);
            double di = (1.0 - t) * dStart + t * dEnd;
            double alphai = Math.atan(1.0 / di);
            double ri = 1.0 / Math.sin(alphai);
            if (alphai < 0.5235987755982988) {
                ri = 1.0 / Math.sin(0.5235987755982988);
            }
            PuVectorGeom.rotatePointAroundVector((PdVector)frame_e3[i], (PdVector)frame_e3[i], (PdVector)frame_e2[i], (double)((double)(-sign) * (1.5707963267948966 - alphai)));
            frame_e3[i].setLength(ri);
            frame_base[i] = polygon[polIndex.m_data[polyDiscr - 1 - i]];
            frame_e2[i].multScalar((double)sign);
            ++i;
        }
        frame_e2[polyDiscr - 1] = normal[polIndex.m_data[0]];
        frame_e2[polyDiscr - 1].normalize();
        tanDir = PdVector.subNew((PdVector)vertex[polIndex.m_data[1]], (PdVector)vertex[polIndex.m_data[0]]);
        if (sign == 1) {
            n = PdVector.crossNew((PdVector)frame_e2[polyDiscr - 1], (PdVector)tanDir);
            frame_e3[polyDiscr - 1] = PdVector.crossNew((PdVector)n, (PdVector)frame_e2[polyDiscr - 1]);
        } else {
            n = PdVector.crossNew((PdVector)tanDir, (PdVector)frame_e2[polyDiscr - 1]);
            frame_e3[polyDiscr - 1] = PdVector.crossNew((PdVector)frame_e2[polyDiscr - 1], (PdVector)n);
        }
        frame_e3[polyDiscr - 1].normalize();
        PuVectorGeom.rotatePointAroundVector((PdVector)frame_e3[polyDiscr - 1], (PdVector)frame_e3[polyDiscr - 1], (PdVector)frame_e2[polyDiscr - 1], (double)((double)sign * angleEnd / 2.0));
        double len = -1.0;
        len = angleEnd / 2.0 < 0.5235987755982988 ? 1.0 / Math.sin(0.5235987755982988) : 1.0 / Math.sin(angleEnd / 2.0);
        frame_e3[polyDiscr - 1].setLength(len);
        frame_base[polyDiscr - 1] = polygon[0];
        frame_e2[polyDiscr - 1].multScalar((double)sign);
        double[] vcos = new double[radialDiscr];
        double[] vsin = new double[radialDiscr];
        double vFac = Math.PI / (double)(radialDiscr - 1);
        this.m_vertex = new PdVector[polyDiscr * radialDiscr];
        int j = 0;
        while (j < radialDiscr) {
            double t = vFac * (double)j;
            vcos[j] = Math.cos(t);
            vsin[j] = Math.sin(t);
            ++j;
        }
        this.m_vertex[0] = PdVector.blendNew((double)1.0, (PdVector)frame_e2[polyDiscr - 1], (double)0.0, (PdVector)frame_e3[polyDiscr - 1]);
        this.m_vertex[1] = PdVector.blendNew((double)1.0, (PdVector)frame_e2[0], (double)0.0, (PdVector)frame_e3[0]);
        this.m_vertex[2] = PdVector.blendNew((double)-1.0, (PdVector)frame_e2[0], (double)0.0, (PdVector)frame_e3[0]);
        this.m_vertex[3] = PdVector.blendNew((double)-1.0, (PdVector)frame_e2[polyDiscr - 1], (double)0.0, (PdVector)frame_e3[polyDiscr - 1]);
        this.m_vertex[0].multScalar(m_tubeRadius);
        this.m_vertex[1].multScalar(m_tubeRadius);
        this.m_vertex[2].multScalar(m_tubeRadius);
        this.m_vertex[3].multScalar(m_tubeRadius);
        tube.setVertex(0, PdVector.blendNew((double)1.0, (PdVector)this.m_vertex[0], (double)1.0, (PdVector)frame_base[polyDiscr - 1]));
        tube.setVertex(1, PdVector.blendNew((double)1.0, (PdVector)this.m_vertex[1], (double)1.0, (PdVector)frame_base[0]));
        tube.setVertex(2, PdVector.blendNew((double)1.0, (PdVector)this.m_vertex[2], (double)1.0, (PdVector)frame_base[0]));
        tube.setVertex(3, PdVector.blendNew((double)1.0, (PdVector)this.m_vertex[3], (double)1.0, (PdVector)frame_base[polyDiscr - 1]));
        int ind = 4;
        int j2 = 1;
        while (j2 < radialDiscr - 1) {
            this.m_vertex[ind] = PdVector.blendNew((double)vcos[j2], (PdVector)frame_e2[0], (double)vsin[j2], (PdVector)frame_e3[0]);
            this.m_vertex[ind].multScalar(m_tubeRadius);
            tube.setVertex(ind, PdVector.blendNew((double)1.0, (PdVector)this.m_vertex[ind], (double)1.0, (PdVector)frame_base[0]));
            ++ind;
            ++j2;
        }
        int i2 = 1;
        while (i2 < polyDiscr - 1) {
            int j3 = 0;
            while (j3 < radialDiscr) {
                this.m_vertex[ind] = PdVector.blendNew((double)vcos[j3], (PdVector)frame_e2[i2], (double)vsin[j3], (PdVector)frame_e3[i2]);
                this.m_vertex[ind].multScalar(m_tubeRadius);
                tube.setVertex(ind, PdVector.blendNew((double)1.0, (PdVector)this.m_vertex[ind], (double)1.0, (PdVector)frame_base[i2]));
                ++ind;
                ++j3;
            }
            ++i2;
        }
        j2 = 1;
        while (j2 < radialDiscr - 1) {
            this.m_vertex[ind] = PdVector.blendNew((double)vcos[j2], (PdVector)frame_e2[polyDiscr - 1], (double)vsin[j2], (PdVector)frame_e3[polyDiscr - 1]);
            this.m_vertex[ind].multScalar(m_tubeRadius);
            tube.setVertex(ind, PdVector.blendNew((double)1.0, (PdVector)this.m_vertex[ind], (double)1.0, (PdVector)frame_base[polyDiscr - 1]));
            ++ind;
            ++j2;
        }
        int n3 = polyDiscr;
        int noe = (n3 - 1) * (n3 - 1);
        tube.setNumElements(noe);
        PiVector index = new PiVector(n3 * n3);
        index.setEntry(0, 1);
        index.setEntry(n3 - 1, 2);
        index.setEntry(n3 * (n3 - 1), 0);
        index.setEntry((n3 + 1) * (n3 - 1), 3);
        ind = 0;
        int i3 = 0;
        while (i3 < n3 * n3) {
            if (i3 != 0 && i3 != n3 - 1 && i3 != n3 * (n3 - 1) && i3 != (n3 + 1) * (n3 - 1)) {
                index.setEntry(i3, 4 + ind);
                ++ind;
            }
            ++i3;
        }
        ind = 0;
        i3 = 0;
        while (i3 < n3 - 1) {
            int j4 = 0;
            while (j4 < n3 - 1) {
                int a = index.m_data[i3 * n3 + j4];
                int b = index.m_data[i3 * n3 + j4 + 1];
                int c = index.m_data[(i3 + 1) * n3 + j4 + 1];
                int d = index.m_data[(i3 + 1) * n3 + j4];
                tube.setElement(ind, a, b, c, d);
                ++ind;
                ++j4;
            }
            ++i3;
        }
        tube.makeVertexNormals();
        return tube;
    }

    private PgElementSet make2DGrid(PdVector[] N, int n) {
        int j;
        PgElementSet geom = new PgElementSet(3);
        int i = 0;
        while (i < 4) {
            geom.setVertex(i, N[i]);
            ++i;
        }
        PuHyperboloid.hyperboloidToKlein(geom.getVertices());
        int nov = 4;
        int newnov = n * n;
        int newnoe = (n - 1) * (n - 1);
        int ind = 0;
        PdVector[] vertex = N;
        geom.setNumVertices(newnov);
        geom.setNumElements(newnoe);
        PdVector[] N1N0 = PuHyperboloid.makeEdge(vertex[1], vertex[0], n);
        PdVector[] N2N3 = PuHyperboloid.makeEdge(vertex[2], vertex[3], n);
        PdVector[] N1N2 = PuHyperboloid.makeEdge(vertex[1], vertex[2], n);
        PdVector[] N0N3 = PuHyperboloid.makeEdge(vertex[0], vertex[3], n);
        PuHyperboloid.hyperboloidToKlein(N1N0);
        PuHyperboloid.hyperboloidToKlein(N2N3);
        PuHyperboloid.hyperboloidToKlein(N1N2);
        PuHyperboloid.hyperboloidToKlein(N0N3);
        int j2 = 1;
        while (j2 < n - 1) {
            geom.setVertex(nov + ind, N1N2[j2]);
            ++ind;
            ++j2;
        }
        int i2 = 1;
        while (i2 < n - 1) {
            PdVector dir = PdVector.subNew((PdVector)N1N0[i2], (PdVector)N2N3[i2]);
            dir.normalize();
            j = 0;
            while (j < n) {
                PdVector iPoint = new PdVector(3);
                PdVector dir1 = PdVector.subNew((PdVector)N0N3[j], (PdVector)N1N2[j]);
                dir1.normalize();
                PuVectorGeom.intersectionOfLineAndLine((PdVector)iPoint, (PdVector)N0N3[j], (PdVector)dir1, (PdVector)N1N0[i2], (PdVector)dir);
                geom.setVertex(nov + ind, iPoint);
                ++ind;
                ++j;
            }
            ++i2;
        }
        i2 = 1;
        while (i2 < n - 1) {
            geom.setVertex(nov + ind, N0N3[i2]);
            ++ind;
            ++i2;
        }
        PiVector index = new PiVector(n * n);
        index.setEntry(0, 1);
        index.setEntry(n - 1, 2);
        index.setEntry(n * (n - 1), 0);
        index.setEntry((n + 1) * (n - 1), 3);
        ind = 0;
        int i3 = 0;
        while (i3 < n * n) {
            if (i3 != 0 && i3 != n - 1 && i3 != n * (n - 1) && i3 != (n + 1) * (n - 1)) {
                index.setEntry(i3, nov + ind);
                ++ind;
            }
            ++i3;
        }
        ind = 0;
        i3 = 0;
        while (i3 < n - 1) {
            j = 0;
            while (j < n - 1) {
                int a = index.m_data[i3 * n + j];
                int b = index.m_data[i3 * n + j + 1];
                int c = index.m_data[(i3 + 1) * n + j + 1];
                int d = index.m_data[(i3 + 1) * n + j];
                geom.setElement(ind, a, b, c, d);
                ++ind;
                ++j;
            }
            ++i3;
        }
        geom.makeVertexNormals();
        PiVector[] neighbor = new PiVector[newnoe];
        PiVector.realloc((PiVector[])neighbor, (int)newnoe, (int)4);
        neighbor[0].set(new int[]{1, n - 1, -1, -1});
        neighbor[n - 2].set(new int[]{-1, 2 * n - 3, n - 3, -1});
        neighbor[(n - 1) * (n - 2)].set(new int[]{(n - 1) * (n - 2) + 1, -1, -1, (n - 1) * (n - 2) - (n - 1)});
        neighbor[n * (n - 2)].set(new int[]{-1, -1, n * (n - 2) - 1, n * (n - 2) - (n - 1)});
        int i4 = 1;
        while (i4 <= n - 3) {
            neighbor[i4 * (n - 1)].set(new int[]{i4 * (n - 1) + 1, (i4 + 1) * (n - 1), -1, (i4 - 1) * (n - 1)});
            int aux = (n - 1) * (n - 2) + i4;
            neighbor[aux].set(new int[]{aux + 1, -1, aux - 1, aux - (n - 1)});
            aux = i4 * (n - 1) + (n - 2);
            neighbor[aux].set(new int[]{-1, aux + (n - 1), aux - 1, aux - (n - 1)});
            neighbor[i4].set(new int[]{i4 + 1, i4 + (n - 1), i4 - 1, -1});
            ++i4;
        }
        i4 = 0;
        while (i4 < n - 3) {
            int aux = n + i4 * (n - 1);
            neighbor[aux].set(new int[]{aux + 1, aux + (n - 1), aux - 1, aux - (n - 1)});
            neighbor[aux].set(new int[]{++aux + 1, aux + (n - 1), aux - 1, aux - (n - 1)});
            neighbor[aux].set(new int[]{++aux + 1, aux + (n - 1), aux - 1, aux - (n - 1)});
            ++i4;
        }
        geom.setNeighbours(neighbor);
        PuHyperboloid.kleinToHyperboloid(geom.getVertices());
        return geom;
    }

    public String[] getLowIndexSubGroup(String genH) {
        this.searchLowIndexSubGroup(genH);
        return this.m_lowIndexSub;
    }

    private void searchLowIndexSubGroup(String genH) {
        String[] elt = this.m_symM_S.getCosetElements();
        String[] G = new String[]{"group name:g;", "group generators:rst;", "group relators:" + this.m_symM_S.getRelators()};
        PuSubgroup.setGroup(G);
        PuSubgroup.setElementOfGroup(elt);
        this.m_lowIndexSub = PuSubgroup.searchSubgroup(genH);
    }

    public PgElementSet[] getTubifiedEdge() {
        this.makeTubeEdge();
        return this.m_tubeEdge;
    }

    private void makeTubeEdge() {
        PgPolygonSet[] NO = this.getNO();
        int i = 0;
        while (i < NO.length) {
            this.m_tubeEdge[i] = this.getQtube(NO, NO[i], i, this.m_symM_S);
            ++i;
        }
    }

    public void hasFundQtube(boolean b) {
        this.m_hasFundQtube = b;
    }

    public static void setDisplay(PvDisplayIf display) {
        m_display = display;
    }

    public PgPolygonSet[] getPipe() {
        PdVector[] corner = this.getCornerPoints();
        int noqt = this.m_symS_g.getNumElements();
        PgPolygonSet[] pipe = new PgPolygonSet[noqt];
        pipe[0] = new PgPolygonSet(3);
        PgPolygonSet pol = pipe[0];
        pol.setNumVertices(4);
        pol.setNumPolygons(1);
        pol.setVertices(corner);
        PiVector p0 = new PiVector(5);
        p0.m_data[0] = 0;
        p0.m_data[1] = 1;
        p0.m_data[2] = 2;
        p0.m_data[3] = 3;
        p0.m_data[4] = 0;
        pol.setPolygon(0, p0);
        int n = 2 * m_discr;
        int nov = pol.getNumVertices();
        int noe = pol.getNumPolygons();
        int newnov = (4 * (n - 2) + nov) * noe;
        pol.setNumVertices(newnov);
        int indv = 0;
        int i = 0;
        while (i < noe) {
            PiVector index = new PiVector(4 * n);
            int j = 0;
            while (j < 4) {
                PdVector[] e = PuHyperboloid.makeEdge(corner[j], corner[(j + 1) % 4], n);
                int k = 0;
                while (k < n) {
                    pol.setVertex(indv, e[k]);
                    index.setEntry(indv, indv);
                    ++indv;
                    ++k;
                }
                ++j;
            }
            pol.setPolygon(i, index);
            ++i;
        }
        return pipe;
    }

    private PdVector[] getCornerPoints() {
        PdVector[] corner = new PdVector[4];
        int i = 0;
        while (i < 4) {
            corner[i] = new PdVector(3);
            ++i;
        }
        corner[0] = this.m_gen[2].contains("s") ? this.m_N : this.m_M;
        PdMatrix A = PuIsometry.getTrans(this.m_gen[0], this.m_isometry, "rst");
        PdMatrix B = PuIsometry.getTrans(this.m_gen[2], this.m_isometry, "rst");
        PdMatrix C = PuIsometry.getTrans(this.m_gen[1], this.m_isometry, "rst");
        if (this.m_ftype.equals(TYPE_111)) {
            PdVector AN = new PdVector(3);
            PdVector CN = new PdVector(3);
            PdVector CAN = new PdVector(3);
            AN.leftMultMatrix(A, corner[0]);
            CN.leftMultMatrix(C, corner[0]);
            CAN.leftMultMatrix(C, AN);
            corner[1].copy(PuHyperboloid.getMidPoint(corner[0], AN));
            corner[2].copy(PuHyperboloid.getMidPoint(CN, CAN));
            corner[3].copy(CN);
        } else if (this.m_ftype.equals(TYPE_121)) {
            corner[1].leftMultMatrix(A, corner[0]);
            PdMatrix C_i = new PdMatrix(3);
            C_i.copy(C);
            C_i.invert();
            PdVector[] pf = new PdVector[10];
            PdMatrix BC_i = new PdMatrix(3);
            BC_i.mult(B, C_i);
            pf = PuHyperboloid.getFixePoints(BC_i);
            corner[3].copy(pf[0]);
            corner[2].leftMultMatrix(A, corner[3]);
        }
        return corner;
    }

    public PiVector[] getSkeletonVertexNeighbor() {
        int polSize;
        int nov = this.m_skeleton.getNumVertices();
        int nop = this.m_skeleton.getNumPolygons();
        PiVector[] neighbor = new PiVector[nov];
        PiVector[] polygon = this.m_skeleton.getPolygons();
        int i = 0;
        while (i < nop) {
            polSize = polygon[i].getSize();
            int j = 1;
            while (j < polSize - 1) {
                neighbor[polygon[i].m_data[j]] = new PiVector(2);
                neighbor[polygon[i].m_data[j]].m_data[0] = polygon[i].m_data[j + 1];
                neighbor[polygon[i].m_data[j]].m_data[1] = polygon[i].m_data[j - 1];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < nop) {
            polSize = polygon[i].getSize();
            PiVector npol = this.m_skeleton.getPolygon(this.m_skNeighbor[i].m_data[1]);
            neighbor[polygon[i].m_data[polSize - 1]] = new PiVector(2);
            neighbor[polygon[i].m_data[polSize - 1]].m_data[0] = polygon[i].m_data[polSize - 2];
            neighbor[polygon[i].m_data[polSize - 1]].m_data[1] = npol.m_data[polSize - 2];
            ++i;
        }
        boolean[] checked = new boolean[nov];
        int valence = this.m_targetMap.getParameters().m_data[3];
        int i2 = 0;
        while (i2 < nop) {
            int s = polygon[i2].m_data[0];
            if (!checked[s]) {
                neighbor[s] = new PiVector(valence);
                neighbor[s].m_data[0] = polygon[i2].m_data[1];
                int r = 1;
                int t = i2;
                while (r < valence) {
                    t = this.m_skNeighbor[t].m_data[0];
                    neighbor[s].m_data[r] = polygon[t].m_data[1];
                    ++r;
                }
                checked[s] = true;
            }
            ++i2;
        }
        return neighbor;
    }
}

