/*
 * Decompiled with CFR 0.152.
 */
package devRegularMap.grid;

import devRegularMap.functions.PuPlanarMaps;
import devRegularMap.vecmath.PuHyperboloid;
import devRegularMap.vecmath.PuSpace;
import devRegularMap.vecmath.PuSpherical;
import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPolygonSet;
import jv.object.PsObject;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;

public class PwPutGrid
extends PuPlanarMaps {
    static PgElementSet m_elementSet;
    protected static final int HYPERBOLIC = -1;
    protected static final int EUCLIDEAN = 0;
    protected static final int SPHERICAL = 1;
    protected static int m_numDiscr;

    public PwPutGrid(PvDisplayIf currDisp) {
        m_elementSet = new PgElementSet(3);
        this.m_display = currDisp;
    }

    public static void setNumDiscr(int numDiscr) {
        m_numDiscr = numDiscr;
    }

    public static void makeGrid() {
        int n = 7;
        int nov = m_elementSet.getNumVertices();
        int noe = m_elementSet.getNumElements();
        PiVector[] neighbor = m_elementSet.getNeighbours();
        PiVector[] face = m_elementSet.getElements();
        PdVector[] vertex = m_elementSet.getVertices();
        Color[] ecolor = m_elementSet.getElementColors();
        PiVector[][] newSides = new PiVector[noe][3];
        int i = 0;
        while (i < noe) {
            int j = 0;
            while (j < 3) {
                newSides[i][j] = new PiVector(n);
                ++j;
            }
            ++i;
        }
        int newnov = (int)(((double)n + 0.5) * (double)n - 0.5 * (double)(n * n)) * noe;
        int newnoe = (int)(1.0 + (double)(n - 1) / 2.0 * (double)n) * noe;
        m_elementSet.setNumVertices(newnov);
        m_elementSet.setNumElements(newnoe);
        boolean[] generated = new boolean[noe];
        int ind = 0;
        int indOfe = 0;
        int locnov = (int)(((double)n + 0.5) * (double)n - 0.5 * (double)(n * n));
        PiVector index = new PiVector(locnov);
        int m = 0;
        while (m < noe) {
            if (!generated[m]) {
                double[] alpha = new double[3];
                int i2 = 0;
                while (i2 < 3) {
                    alpha[i2] = PdVector.angle((PdVector)vertex[face[m].m_data[i2]], (PdVector)vertex[face[m].m_data[(i2 + 1) % 3]], (PdVector)vertex[face[m].m_data[(i2 + 2) % 3]]);
                    ++i2;
                }
                int[] rindex = new int[3];
                PuMath.heapsort((int)3, (double[])alpha, (int[])rindex);
                int imax = rindex[2];
                neighbor[m] = new PiVector(neighbor[m].m_data[imax], neighbor[m].m_data[(imax + 1) % 3], neighbor[m].m_data[(imax + 2) % 3]);
                PdVector[] firstSide = PwPutGrid.makeEdge(vertex[face[m].m_data[imax]], vertex[face[m].m_data[(imax + 1) % 3]], n);
                PdVector[] secondSide = PwPutGrid.makeEdge(vertex[face[m].m_data[(imax + 1) % 3]], vertex[face[m].m_data[(imax + 2) % 3]], n);
                newSides[m][0].setEntry(0, face[m].m_data[(imax + 1) % 3]);
                newSides[m][0].setEntry(n - 1, face[m].m_data[(imax + 2) % 3]);
                newSides[m][1].setEntry(0, face[m].m_data[(imax + 2) % 3]);
                newSides[m][1].setEntry(n - 1, face[m].m_data[imax]);
                newSides[m][2].setEntry(0, face[m].m_data[imax]);
                newSides[m][2].setEntry(n - 1, face[m].m_data[(imax + 1) % 3]);
                int prevnov = nov + ind;
                int i3 = 0;
                while (i3 < n - 1) {
                    int j;
                    PdVector[] v = PwPutGrid.makeEdge(secondSide[n - 1 - i3], firstSide[i3], n - i3);
                    if (i3 != 0) {
                        newSides[m][0].setEntry(i3, nov + ind);
                        newSides[m][2].setEntry(n - i3 - 1, nov + ind + n - i3 - 1);
                        j = 0;
                        while (j < n - i3) {
                            m_elementSet.setVertex(nov + ind, v[j]);
                            ++ind;
                            ++j;
                        }
                    } else {
                        j = 1;
                        while (j < n - 1) {
                            m_elementSet.setVertex(nov + ind, v[j]);
                            newSides[m][1].setEntry(n - j - 1, nov + ind);
                            ++ind;
                            ++j;
                        }
                    }
                    ++i3;
                }
                index.setEntry(0, face[m].m_data[(imax + 2) % 3]);
                index.setEntry(n - 1, face[m].m_data[imax]);
                index.setEntry(locnov - 1, face[m].m_data[(imax + 1) % 3]);
                int s = 0;
                int i4 = 1;
                while (i4 < locnov - 1) {
                    if (i4 != n - 1) {
                        index.setEntry(i4, prevnov + s);
                        ++s;
                    }
                    ++i4;
                }
                int j = 0;
                while (j < 3) {
                    if (neighbor[m].m_data[j] != -1 && generated[neighbor[m].m_data[j]]) {
                        PiVector cside = newSides[m][j];
                        PiVector nside = new PiVector(cside.getSize());
                        if (cside.m_data[0] == newSides[neighbor[m].m_data[j]][0].m_data[n - 1] && cside.m_data[n - 1] == newSides[neighbor[m].m_data[j]][0].m_data[0]) {
                            nside = newSides[neighbor[m].m_data[j]][0];
                        } else if (cside.m_data[0] == newSides[neighbor[m].m_data[j]][1].m_data[n - 1] && cside.m_data[n - 1] == newSides[neighbor[m].m_data[j]][1].m_data[0]) {
                            nside = newSides[neighbor[m].m_data[j]][1];
                        } else if (cside.m_data[0] == newSides[neighbor[m].m_data[j]][2].m_data[n - 1] && cside.m_data[n - 1] == newSides[neighbor[m].m_data[j]][2].m_data[0]) {
                            nside = newSides[neighbor[m].m_data[j]][2];
                        }
                        s = 0;
                        int k = 1;
                        while (k < locnov - 1) {
                            if (k != n - 1) {
                                int p = cside.getIndexOf(prevnov + s);
                                if (p != -1) {
                                    index.setEntry(k, nside.m_data[n - 1 - p]);
                                    m_elementSet.getVertex(prevnov + s).setTag(2);
                                }
                                ++s;
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                int k = 0;
                while (k < n - 1) {
                    int a = (int)(((double)n + 0.5) * (double)k - 0.5 * (double)k * (double)k);
                    int b = (int)(((double)n + 0.5) * (double)k - 0.5 * (double)k * (double)k + 1.0);
                    int c = (int)(((double)n + 0.5) * (double)(k + 1) - 0.5 * (double)(k + 1) * (double)(k + 1));
                    m_elementSet.setElement(noe + indOfe, index.m_data[a], index.m_data[b], index.m_data[c]);
                    m_elementSet.setElementColor(noe + indOfe, ecolor[m]);
                    ++indOfe;
                    ++k;
                }
                k = 0;
                while (k < n - 2) {
                    int l = 0;
                    while (l < n - 2 - k) {
                        int a = (int)(((double)n + 0.5) * (double)l - 0.5 * (double)l * (double)l + 1.0 + (double)k);
                        int b = (int)(((double)n + 0.5) * (double)l - 0.5 * (double)l * (double)l + 2.0 + (double)k);
                        int c = (int)(((double)n + 0.5) * (double)(l + 1) - 0.5 * (double)(l + 1) * (double)(l + 1) + 1.0 + (double)k);
                        int d = (int)(((double)n + 0.5) * (double)(l + 1) - 0.5 * (double)(l + 1) * (double)(l + 1) + (double)k);
                        m_elementSet.setElement(noe + indOfe, index.m_data[a], index.m_data[b], index.m_data[c], index.m_data[d]);
                        m_elementSet.setElementColor(noe + indOfe, ecolor[m]);
                        ++indOfe;
                        ++l;
                    }
                    ++k;
                }
                m_elementSet.getElement(m).setTag(2);
                generated[m] = true;
            }
            ++m;
        }
        m_elementSet.removeMarkedVertices();
        m_elementSet.removeMarkedElements();
    }

    private static void refineTriangle() {
        int n = 7;
        int nov = m_elementSet.getNumVertices();
        PdVector[] vertex = m_elementSet.getVertices();
        Color[] ecolor = m_elementSet.getElementColors();
        int newnoe = n - 1;
        int k = 0;
        while (k < n - 2) {
            int l = 0;
            while (l < n - 2 - k) {
                ++newnoe;
                ++l;
            }
            ++k;
        }
        int newnov = (int)(((double)n + 0.5) * (double)n - 0.5 * (double)(n * n));
        m_elementSet.setNumVertices(newnov);
        m_elementSet.setNumElements(newnoe);
        PdVector[] firstSide = PwPutGrid.makeEdge(vertex[1], vertex[2], n);
        PdVector[] secondSide = PwPutGrid.makeEdge(vertex[2], vertex[0], n);
        int ind = 0;
        int prevnov = nov + ind;
        int i = 0;
        while (i < n - 1) {
            int j;
            PdVector[] v = PwPutGrid.makeEdge(secondSide[n - 1 - i], firstSide[i], n - i);
            if (i != 0) {
                j = 0;
                while (j < n - i) {
                    m_elementSet.setVertex(nov + ind, v[j]);
                    ++ind;
                    ++j;
                }
            } else {
                j = 1;
                while (j < n - 1) {
                    m_elementSet.setVertex(nov + ind, v[j]);
                    ++ind;
                    ++j;
                }
            }
            ++i;
        }
        PiVector index = new PiVector(newnov);
        index.setEntry(0, 0);
        index.setEntry(n - 1, 1);
        index.setEntry(newnov - 1, 2);
        int s = 0;
        int i2 = 1;
        while (i2 < newnov - 1) {
            if (i2 != n - 1) {
                index.setEntry(i2, prevnov + s);
                ++s;
            }
            ++i2;
        }
        int indOfe = 0;
        int k2 = 0;
        while (k2 < n - 1) {
            int a = (int)(((double)n + 0.5) * (double)k2 - 0.5 * (double)k2 * (double)k2);
            int b = (int)(((double)n + 0.5) * (double)k2 - 0.5 * (double)k2 * (double)k2 + 1.0);
            int c = (int)(((double)n + 0.5) * (double)(k2 + 1) - 0.5 * (double)(k2 + 1) * (double)(k2 + 1));
            m_elementSet.setElement(indOfe, index.m_data[a], index.m_data[b], index.m_data[c]);
            m_elementSet.setElementColor(indOfe, ecolor[0]);
            ++indOfe;
            ++k2;
        }
        k2 = 0;
        while (k2 < n - 2) {
            int l = 0;
            while (l < n - 2 - k2) {
                int a = (int)(((double)n + 0.5) * (double)l - 0.5 * (double)l * (double)l + 1.0 + (double)k2);
                int b = (int)(((double)n + 0.5) * (double)l - 0.5 * (double)l * (double)l + 2.0 + (double)k2);
                int c = (int)(((double)n + 0.5) * (double)(l + 1) - 0.5 * (double)(l + 1) * (double)(l + 1) + 1.0 + (double)k2);
                int d = (int)(((double)n + 0.5) * (double)(l + 1) - 0.5 * (double)(l + 1) * (double)(l + 1) + (double)k2);
                m_elementSet.setElement(indOfe, index.m_data[a], index.m_data[b], index.m_data[c], index.m_data[d]);
                m_elementSet.setElementColor(indOfe, ecolor[0]);
                ++indOfe;
                ++l;
            }
            ++k2;
        }
    }

    public static void refineGrid(PgElementSet geom) {
        m_elementSet = geom;
        PwPutGrid.refineTriangle();
    }

    public static void setGeometry(PgElementSet geom) {
        m_elementSet = geom;
    }

    public static void refinePolygonSet(PgPolygonSet pol, int n, int genus) {
        int nov = pol.getNumVertices();
        int nop = pol.getNumPolygons();
        pol.setDimOfPolygons(n);
        PiVector[] polygon = pol.getPolygons();
        PdVector[] vertex = pol.getVertices();
        int newnov = nov + (n - 2) * nop;
        pol.setNumVertices(newnov);
        int indv = 0;
        int i = 0;
        while (i < nop) {
            PiVector p = polygon[i];
            p.setSize(n);
            PdVector[] newv = PwPutGrid.makeEdge(vertex[p.m_data[0]], vertex[p.m_data[1]], n, genus);
            p.setEntry(n - 1, p.m_data[1]);
            int j = 1;
            while (j < n - 1) {
                pol.setVertex(nov + indv, newv[j]);
                p.setEntry(j, nov + indv);
                ++indv;
                ++j;
            }
            ++i;
        }
    }

    public static void refinePolygonSet(PgPolygonSet pol, int n) {
        int nov = pol.getNumVertices();
        int nop = pol.getNumPolygons();
        pol.setDimOfPolygons(n);
        PiVector[] polygon = pol.getPolygons();
        PdVector[] vertex = pol.getVertices();
        int newnov = nov + (n - 2) * nop;
        pol.setNumVertices(newnov);
        int indv = 0;
        int i = 0;
        while (i < nop) {
            PiVector p = polygon[i];
            p.setSize(n);
            PdVector[] newv = PwPutGrid.makeEdge(vertex[p.m_data[0]], vertex[p.m_data[1]], n);
            p.setEntry(n - 1, p.m_data[1]);
            int j = 1;
            while (j < n - 1) {
                pol.setVertex(nov + indv, newv[j]);
                p.setEntry(j, nov + indv);
                ++indv;
                ++j;
            }
            ++i;
        }
    }

    public static void refinePolygonSetHalf(PgPolygonSet pol, int n) {
        int nov = pol.getNumVertices();
        int nop = pol.getNumPolygons();
        pol.setDimOfPolygons(n);
        PdVector[] vertex = pol.getVertices();
        int newnov = nov + (n - 2) * nop;
        pol.setNumVertices(newnov);
        PgPolygonSet tmpPol = new PgPolygonSet(3);
        tmpPol.setNumVertices(2 * nov);
        tmpPol.setNumPolygons(nop);
        int indv = 0;
        int i = 0;
        while (i < nop) {
            PiVector p = pol.getPolygon(i);
            PdVector[] newv = PwPutGrid.makeEdge(vertex[p.m_data[0]], vertex[p.m_data[1]], n);
            tmpPol.setVertex(indv, newv[1]);
            tmpPol.setVertex(indv + 1, newv[n - 2]);
            tmpPol.setPolygon(i, new PiVector(indv, indv + 1));
            indv += 2;
            ++i;
        }
        PwPutGrid.refinePolygonSet(tmpPol, 12);
        pol.copy((PsObject)tmpPol);
    }

    public static void makeCurvedEdge(PgElementSet geom) {
        m_elementSet = geom;
        int n = 7;
        int nov = m_elementSet.getNumVertices();
        int noe = m_elementSet.getNumElements();
        int noE = m_elementSet.getNumEdges();
        PiVector[] neighbor = m_elementSet.getNeighbours();
        PiVector[] face = m_elementSet.getElements();
        PdVector[] vertex = m_elementSet.getVertices();
        Color[] ecolor = m_elementSet.getElementColors();
        PiVector[][] newSides = new PiVector[noe][3];
        int i = 0;
        while (i < noe) {
            int j = 0;
            while (j < 3) {
                newSides[i][j] = new PiVector(n);
                ++j;
            }
            ++i;
        }
        int newnov = noE * (n - 2) + nov;
        m_elementSet.setNumVertices(newnov);
        boolean[] generated = new boolean[noe];
        int ind = 0;
        int locnov = 3 * (n - 2) + 3;
        PiVector index = new PiVector(locnov);
        int m = 0;
        while (m < noe) {
            if (!generated[m]) {
                double[] alpha = new double[3];
                int i2 = 0;
                while (i2 < 3) {
                    alpha[i2] = PdVector.angle((PdVector)vertex[face[m].m_data[i2]], (PdVector)vertex[face[m].m_data[(i2 + 1) % 3]], (PdVector)vertex[face[m].m_data[(i2 + 2) % 3]]);
                    ++i2;
                }
                int[] rindex = new int[3];
                PuMath.heapsort((int)3, (double[])alpha, (int[])rindex);
                int imax = rindex[2];
                neighbor[m] = new PiVector(neighbor[m].m_data[imax], neighbor[m].m_data[(imax + 1) % 3], neighbor[m].m_data[(imax + 2) % 3]);
                PdVector[] firstSide = PwPutGrid.makeEdge(vertex[face[m].m_data[imax]], vertex[face[m].m_data[(imax + 1) % 3]], n);
                PdVector[] secondSide = PwPutGrid.makeEdge(vertex[face[m].m_data[(imax + 1) % 3]], vertex[face[m].m_data[(imax + 2) % 3]], n);
                PdVector[] thirdSide = PwPutGrid.makeEdge(vertex[face[m].m_data[(imax + 2) % 3]], vertex[face[m].m_data[imax]], n);
                newSides[m][0].setEntry(0, face[m].m_data[(imax + 1) % 3]);
                newSides[m][0].setEntry(n - 1, face[m].m_data[(imax + 2) % 3]);
                newSides[m][1].setEntry(0, face[m].m_data[(imax + 2) % 3]);
                newSides[m][1].setEntry(n - 1, face[m].m_data[imax]);
                newSides[m][2].setEntry(0, face[m].m_data[imax]);
                newSides[m][2].setEntry(n - 1, face[m].m_data[(imax + 1) % 3]);
                int prevnov = nov + ind;
                int i3 = 1;
                while (i3 < n - 1) {
                    m_elementSet.setVertex(nov + ind, firstSide[i3]);
                    newSides[m][2].setEntry(i3, nov + ind);
                    ++ind;
                    ++i3;
                }
                i3 = 1;
                while (i3 < n - 1) {
                    m_elementSet.setVertex(nov + ind, secondSide[i3]);
                    newSides[m][0].setEntry(i3, nov + ind);
                    ++ind;
                    ++i3;
                }
                i3 = 1;
                while (i3 < n - 1) {
                    m_elementSet.setVertex(nov + ind, thirdSide[i3]);
                    newSides[m][1].setEntry(i3, nov + ind);
                    ++ind;
                    ++i3;
                }
                index.setEntry(0, face[m].m_data[imax]);
                index.setEntry(n - 1, face[m].m_data[(imax + 1) % 3]);
                index.setEntry(2 * n - 2, face[m].m_data[(imax + 2) % 3]);
                int s = 0;
                int i4 = 1;
                while (i4 < locnov) {
                    if (i4 != n - 1 && i4 != 2 * n - 2) {
                        index.setEntry(i4, prevnov + s);
                        ++s;
                    }
                    ++i4;
                }
                int j = 0;
                while (j < 3) {
                    if (neighbor[m].m_data[j] != -1 && generated[neighbor[m].m_data[j]]) {
                        PiVector cside = newSides[m][j];
                        PiVector nside = new PiVector(cside.getSize());
                        if (cside.m_data[0] == newSides[neighbor[m].m_data[j]][0].m_data[n - 1] && cside.m_data[n - 1] == newSides[neighbor[m].m_data[j]][0].m_data[0]) {
                            nside = newSides[neighbor[m].m_data[j]][0];
                        } else if (cside.m_data[0] == newSides[neighbor[m].m_data[j]][1].m_data[n - 1] && cside.m_data[n - 1] == newSides[neighbor[m].m_data[j]][1].m_data[0]) {
                            nside = newSides[neighbor[m].m_data[j]][1];
                        } else if (cside.m_data[0] == newSides[neighbor[m].m_data[j]][2].m_data[n - 1] && cside.m_data[n - 1] == newSides[neighbor[m].m_data[j]][2].m_data[0]) {
                            nside = newSides[neighbor[m].m_data[j]][2];
                        }
                        s = 0;
                        int k = 1;
                        while (k < locnov) {
                            if (k != n - 1 && k != 2 * n - 2) {
                                int p = cside.getIndexOf(prevnov + s);
                                if (p != -1) {
                                    index.setEntry(k, nside.m_data[n - 1 - p]);
                                    m_elementSet.getVertex(prevnov + s).setTag(2);
                                }
                                ++s;
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                PiVector newF = new PiVector(locnov);
                int i5 = 0;
                while (i5 < locnov) {
                    newF.m_data[i5] = index.getEntry(i5);
                    ++i5;
                }
                String name = m_elementSet.getElement(m).getName();
                m_elementSet.setElement(m, newF);
                m_elementSet.getElement(m).setName(name);
                m_elementSet.setElementColor(m, ecolor[m]);
                m_elementSet.setElementNormal(m, new PdVector(1.0, 0.0, 0.0));
                generated[m] = true;
            }
            ++m;
        }
        m_elementSet.removeMarkedVertices();
        m_elementSet.removeUnusedVertices();
        m_elementSet.makeNeighbour();
    }

    public static void makeCurvedEdge(PgElementSet geom, int n) {
        m_elementSet = geom;
        int nov = m_elementSet.getNumVertices();
        int noe = m_elementSet.getNumElements();
        int noE = m_elementSet.getNumEdges();
        PiVector[] neighbor = m_elementSet.getNeighbours();
        PiVector[] face = m_elementSet.getElements();
        PdVector[] vertex = m_elementSet.getVertices();
        Color[] ecolor = m_elementSet.getElementColors();
        PiVector[][] newSides = new PiVector[noe][3];
        int i = 0;
        while (i < noe) {
            int j = 0;
            while (j < 3) {
                newSides[i][j] = new PiVector(n);
                ++j;
            }
            ++i;
        }
        int newnov = noE * (n - 2) + nov;
        m_elementSet.setNumVertices(newnov);
        boolean[] generated = new boolean[noe];
        int ind = 0;
        int locnov = 3 * (n - 2) + 3;
        PiVector index = new PiVector(locnov);
        int m = 0;
        while (m < noe) {
            if (!generated[m]) {
                double[] alpha = new double[3];
                int i2 = 0;
                while (i2 < 3) {
                    alpha[i2] = PdVector.angle((PdVector)vertex[face[m].m_data[i2]], (PdVector)vertex[face[m].m_data[(i2 + 1) % 3]], (PdVector)vertex[face[m].m_data[(i2 + 2) % 3]]);
                    ++i2;
                }
                int[] rindex = new int[3];
                PuMath.heapsort((int)3, (double[])alpha, (int[])rindex);
                int imax = rindex[2];
                neighbor[m] = new PiVector(neighbor[m].m_data[imax], neighbor[m].m_data[(imax + 1) % 3], neighbor[m].m_data[(imax + 2) % 3]);
                PdVector[] firstSide = PwPutGrid.makeEdge(vertex[face[m].m_data[imax]], vertex[face[m].m_data[(imax + 1) % 3]], n);
                PdVector[] secondSide = PwPutGrid.makeEdge(vertex[face[m].m_data[(imax + 1) % 3]], vertex[face[m].m_data[(imax + 2) % 3]], n);
                PdVector[] thirdSide = PwPutGrid.makeEdge(vertex[face[m].m_data[(imax + 2) % 3]], vertex[face[m].m_data[imax]], n);
                newSides[m][0].setEntry(0, face[m].m_data[(imax + 1) % 3]);
                newSides[m][0].setEntry(n - 1, face[m].m_data[(imax + 2) % 3]);
                newSides[m][1].setEntry(0, face[m].m_data[(imax + 2) % 3]);
                newSides[m][1].setEntry(n - 1, face[m].m_data[imax]);
                newSides[m][2].setEntry(0, face[m].m_data[imax]);
                newSides[m][2].setEntry(n - 1, face[m].m_data[(imax + 1) % 3]);
                int prevnov = nov + ind;
                int i3 = 1;
                while (i3 < n - 1) {
                    m_elementSet.setVertex(nov + ind, firstSide[i3]);
                    newSides[m][2].setEntry(i3, nov + ind);
                    ++ind;
                    ++i3;
                }
                i3 = 1;
                while (i3 < n - 1) {
                    m_elementSet.setVertex(nov + ind, secondSide[i3]);
                    newSides[m][0].setEntry(i3, nov + ind);
                    ++ind;
                    ++i3;
                }
                i3 = 1;
                while (i3 < n - 1) {
                    m_elementSet.setVertex(nov + ind, thirdSide[i3]);
                    newSides[m][1].setEntry(i3, nov + ind);
                    ++ind;
                    ++i3;
                }
                index.setEntry(0, face[m].m_data[imax]);
                index.setEntry(n - 1, face[m].m_data[(imax + 1) % 3]);
                index.setEntry(2 * n - 2, face[m].m_data[(imax + 2) % 3]);
                int s = 0;
                int i4 = 1;
                while (i4 < locnov) {
                    if (i4 != n - 1 && i4 != 2 * n - 2) {
                        index.setEntry(i4, prevnov + s);
                        ++s;
                    }
                    ++i4;
                }
                int j = 0;
                while (j < 3) {
                    if (neighbor[m].m_data[j] != -1 && generated[neighbor[m].m_data[j]]) {
                        PiVector cside = newSides[m][j];
                        PiVector nside = new PiVector(cside.getSize());
                        if (cside.m_data[0] == newSides[neighbor[m].m_data[j]][0].m_data[n - 1] && cside.m_data[n - 1] == newSides[neighbor[m].m_data[j]][0].m_data[0]) {
                            nside = newSides[neighbor[m].m_data[j]][0];
                        } else if (cside.m_data[0] == newSides[neighbor[m].m_data[j]][1].m_data[n - 1] && cside.m_data[n - 1] == newSides[neighbor[m].m_data[j]][1].m_data[0]) {
                            nside = newSides[neighbor[m].m_data[j]][1];
                        } else if (cside.m_data[0] == newSides[neighbor[m].m_data[j]][2].m_data[n - 1] && cside.m_data[n - 1] == newSides[neighbor[m].m_data[j]][2].m_data[0]) {
                            nside = newSides[neighbor[m].m_data[j]][2];
                        }
                        s = 0;
                        int k = 1;
                        while (k < locnov) {
                            if (k != n - 1 && k != 2 * n - 2) {
                                int p = cside.getIndexOf(prevnov + s);
                                if (p != -1) {
                                    index.setEntry(k, nside.m_data[n - 1 - p]);
                                    m_elementSet.getVertex(prevnov + s).setTag(2);
                                }
                                ++s;
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                PiVector newF = new PiVector(locnov);
                int i5 = 0;
                while (i5 < locnov) {
                    newF.m_data[i5] = index.getEntry(i5);
                    ++i5;
                }
                String name = m_elementSet.getElement(m).getName();
                m_elementSet.setElement(m, newF);
                m_elementSet.getElement(m).setName(name);
                m_elementSet.setElementColor(m, ecolor[m]);
                m_elementSet.setElementNormal(m, new PdVector(1.0, 0.0, 0.0));
                generated[m] = true;
            }
            ++m;
        }
        m_elementSet.removeMarkedVertices();
        m_elementSet.removeUnusedVertices();
        m_elementSet.makeNeighbour();
    }

    public static PdVector[] makeEdge(PdVector p1, PdVector p2, int numDiscr, int genus) {
        PdVector[] edge = new PdVector[numDiscr];
        if (genus > 1) {
            edge = PuHyperboloid.makeEdge(p1, p2, numDiscr);
        } else if (genus == 1) {
            PdVector dir = PdVector.subNew((PdVector)p2, (PdVector)p1);
            double l = dir.length();
            dir.normalize();
            int i = 0;
            while (i < numDiscr) {
                edge[i] = new PdVector(3);
                double t = (double)i * l / (double)(numDiscr - 1);
                edge[i].multScalar(dir, t);
                edge[i].add(p1);
                ++i;
            }
        } else {
            edge = PuSpherical.makeEdge(p1, p2, numDiscr);
        }
        return edge;
    }

    public static PdVector[] makeEdge(PdVector p1, PdVector p2, int numDiscr) {
        PdVector[] edge = new PdVector[numDiscr];
        switch (PuSpace.SPACE) {
            case -1: {
                edge = PuHyperboloid.makeEdge(p1, p2, numDiscr);
                break;
            }
            case 0: {
                PdVector dir = PdVector.subNew((PdVector)p2, (PdVector)p1);
                double l = dir.length();
                dir.normalize();
                int i = 0;
                while (i < numDiscr) {
                    edge[i] = new PdVector(3);
                    double t = (double)i * l / (double)(numDiscr - 1);
                    edge[i].multScalar(dir, t);
                    edge[i].add(p1);
                    ++i;
                }
                break;
            }
            case 1: {
                edge = PuSpherical.makeEdge(p1, p2, numDiscr);
            }
        }
        return edge;
    }

    public static void makeQuadGrid(PgElementSet geom, int n) {
        int j;
        int nov = geom.getNumVertices();
        int newnov = n * n;
        int newnoe = (n - 1) * (n - 1);
        int ind = 0;
        PdVector[] vertex = geom.getVertices();
        geom.setNumVertices(newnov);
        geom.setNumElements(newnoe);
        PdVector[] N1N0 = PwPutGrid.makeEdge(vertex[1], vertex[0], n);
        PdVector[] N2N3 = PwPutGrid.makeEdge(vertex[2], vertex[3], n);
        int i = 0;
        while (i < n) {
            PdVector[] s = PwPutGrid.makeEdge(N1N0[i], N2N3[i], n);
            if (i != 0 && i != n - 1) {
                j = 0;
                while (j < n) {
                    geom.setVertex(nov + ind, s[j]);
                    ++ind;
                    ++j;
                }
            } else {
                j = 1;
                while (j < n - 1) {
                    geom.setVertex(nov + ind, s[j]);
                    ++ind;
                    ++j;
                }
            }
            ++i;
        }
        PiVector index = new PiVector(n * n);
        index.setEntry(0, 1);
        index.setEntry(n - 1, 2);
        index.setEntry(n * (n - 1), 0);
        index.setEntry((n + 1) * (n - 1), 3);
        ind = 0;
        int i2 = 0;
        while (i2 < n * n) {
            if (i2 != 0 && i2 != n - 1 && i2 != n * (n - 1) && i2 != (n + 1) * (n - 1)) {
                index.setEntry(i2, nov + ind);
                ++ind;
            }
            ++i2;
        }
        ind = 0;
        i2 = 0;
        while (i2 < n - 1) {
            j = 0;
            while (j < n - 1) {
                int a = index.m_data[i2 * n + j];
                int b = index.m_data[i2 * n + j + 1];
                int c = index.m_data[(i2 + 1) * n + j + 1];
                int d = index.m_data[(i2 + 1) * n + j];
                geom.setElement(ind, a, b, c, d);
                ++ind;
                ++j;
            }
            ++i2;
        }
        geom.makeVertexNormals();
    }

    public void showGrid() {
        PwPutGrid.makeGrid();
        m_elementSet.update((Object)m_elementSet);
    }
}

