/*
 * Decompiled with CFR 0.152.
 */
package devRegularMap.functions;

import devRegularMap.functions.PuGenerateListOfElements;
import devRegularMap.vecmath.PuSubgroup;
import devRegularMap.vecmath.PuTargetTubeSymmGroup;
import devRegularMap.vecmath.PuUniCover;
import java.awt.Color;
import java.io.IOException;
import jv.vecmath.PiVector;

public class symGroup {
    protected String[] m_elt;
    protected int[][] m_perm;
    protected PiVector[] m_neighbor;
    protected Color[] m_color;
    protected String[] m_coset;
    protected int[][] m_cosetPerm;
    protected String[] m_subH;
    protected boolean[] m_oriented;
    protected String m_genH;
    protected String[] m_uCover;
    protected String m_relators;
    private PiVector m_param;
    private String m_gen;
    private boolean m_dual;
    private String m_ftype;

    public symGroup(PiVector param, String gen, boolean flag) {
        this.m_param = param;
        this.m_gen = gen;
        this.m_dual = flag;
        this.init();
    }

    public symGroup(PiVector param, String gen, boolean flag, String ftype) throws IOException {
        this.m_param = param;
        this.m_gen = gen;
        this.m_dual = flag;
        this.setM_ftype(ftype);
        this.init();
    }

    public symGroup() {
    }

    private void init() {
        int g = this.m_param.m_data[0];
        int i = this.m_param.m_data[1];
        int p = this.m_param.m_data[2];
        int q = this.m_param.m_data[3];
        int a = this.m_param.m_data[4];
        int b = this.m_param.m_data[5];
        if (this.m_gen.contains("r")) {
            if (g == 1) {
                PuGenerateListOfElements.setTorusMap(a, b);
            }
            PuGenerateListOfElements.setParameter(g, i, p, q, this.m_dual);
            this.m_elt = PuGenerateListOfElements.getElementTable();
            this.m_perm = PuGenerateListOfElements.getPermutationTable();
            this.m_coset = PuGenerateListOfElements.getCosetRepresentativ();
            this.m_cosetPerm = PuGenerateListOfElements.getCosetPermutation();
            this.m_subH = PuGenerateListOfElements.getElementTableOfH();
            this.m_relators = PuGenerateListOfElements.getRelator();
            this.m_oriented = new boolean[this.m_elt.length];
            int j = 0;
            while (j < this.m_elt.length) {
                String rep = this.m_elt[j];
                this.m_oriented[j] = !rep.contains("t");
                ++j;
            }
        } else if (this.m_gen.contains("a")) {
            PuTargetTubeSymmGroup tub = new PuTargetTubeSymmGroup(g, i, p, q, this.m_dual, a, b);
            this.m_elt = tub.getElementTable();
            this.m_perm = tub.getPermutationTable();
            this.m_coset = tub.getCosetSubgroupTable();
            this.m_subH = tub.getSubgroup();
            this.m_cosetPerm = tub.getCosetPermutation();
            this.m_oriented = new boolean[this.m_elt.length];
            int j = 0;
            while (j < this.m_elt.length) {
                String rep = this.m_elt[j];
                this.m_oriented[j] = !rep.contains("c");
                ++j;
            }
        } else {
            System.err.println("Generators are not right");
        }
        this.m_color = new Color[this.m_coset.length];
        int j = 0;
        while (j < this.m_coset.length) {
            this.m_color[j] = Color.getHSBColor((float)Math.asin((float)j / (float)this.m_coset.length), 0.4f, 1.0f);
            ++j;
        }
        this.m_genH = "r,t";
    }

    public String getRelators() {
        return this.m_relators;
    }

    public boolean[] getElementOrientation() {
        return this.m_oriented;
    }

    public String[] getElements() {
        return this.m_elt;
    }

    public int[][] getPermutation() {
        return this.m_perm;
    }

    public PiVector[] getNeighbor() {
        int noe = this.m_elt.length;
        this.m_neighbor = new PiVector[noe];
        String[] bt = new String[2];
        if (this.m_gen.contains("r")) {
            bt = new String[]{"t", "St", "rt"};
        } else if (this.m_gen.contains("a")) {
            bt = new String[]{"bc", "c", "abc"};
        }
        int i = 0;
        while (i < noe) {
            String tr = this.m_elt[i];
            this.m_neighbor[i] = new PiVector(3);
            int j = 0;
            while (j < 3) {
                this.m_neighbor[i].m_data[j] = PuSubgroup.getIndexOfEltInG(String.valueOf(tr) + bt[j], this.m_perm, this.m_gen, true);
                ++j;
            }
            ++i;
        }
        return this.m_neighbor;
    }

    public String getElement(int indElt) {
        return this.m_elt[indElt];
    }

    public int getNumElements() {
        return this.m_elt.length;
    }

    public Color[] getColors() {
        return this.m_color;
    }

    public void setColor(int ind, Color col) {
        this.m_color[ind] = col;
    }

    public String[] getSubGroupElements() {
        return this.m_subH;
    }

    public String[] getCosetElements() {
        return this.m_coset;
    }

    public int[][] getCosetPermutation() {
        return this.m_cosetPerm;
    }

    public Color getElementColor(int index) {
        return Color.getHSBColor((float)Math.asin((float)index / (float)this.m_coset.length), 0.4f, 1.0f);
    }

    public void setSubgroupGenerator(String genH) {
        PuGenerateListOfElements.setSubgroupGenerator(genH);
    }

    public void initColors() {
    }

    public void setGeneratorH(String gen) {
        this.m_genH = gen;
    }

    public String getSubGroupGenerator() {
        return this.m_genH;
    }

    public PuUniCover getUniversalCover() {
        PuUniCover uni = new PuUniCover(this);
        return uni;
    }

    public PiVector getParameters() {
        return this.m_param;
    }

    public boolean isDual() {
        return this.m_dual;
    }

    public void setM_ftype(String m_ftype) {
        this.m_ftype = m_ftype;
    }

    public String getM_ftype() {
        return this.m_ftype;
    }
}

