/*
 * Decompiled with CFR 0.152.
 */
package devRegularMap.functions;

import devRegularMap.color.PdColor;
import devRegularMap.functions.PgFourgGon;
import devRegularMap.functions.PgGon;
import devRegularMap.functions.Pu3Dmaps;
import devRegularMap.functions.PuFtube;
import devRegularMap.grid.PwPutGrid;
import devRegularMap.groups.RMap;
import devRegularMap.groups.symGroup;
import devRegularMap.gui.PwShow;
import devRegularMap.vecmath.PuCompGeometry;
import devRegularMap.vecmath.PuHyperbolic;
import devRegularMap.vecmath.PuHyperboloid;
import devRegularMap.vecmath.PuIsometry;
import devRegularMap.vecmath.PuMesh4gGon;
import devRegularMap.vecmath.PuQuadTesselation;
import devRegularMap.vecmath.PuSpace;
import devRegularMap.vecmath.PuSubgroup;
import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygonSet;
import jv.geom.PuCleanMesh;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jvx.project.PjWorkshop;

public class PuPlanarMaps
extends PjWorkshop {
    protected PgElementSet m_planar = new PgElementSet(3);
    protected static PgElementSet m_elementSet;
    protected static int m_p;
    protected static int m_q;
    protected static int m_g;
    protected static int m_i;
    protected static int m_a;
    protected static int m_b;
    protected boolean m_dual;
    protected static PdMatrix[] m_rst;
    protected static symGroup m_symM_S;
    private static PgPolygonSet m_OM;
    private static PgPolygonSet m_MN;
    private static PgPolygonSet m_NO;
    private static PdVector m_O;
    private static PdVector m_M;
    private static PdVector m_N;
    protected PgElementSet m_fdomainSm;
    protected PgElementSet m_foldSm;
    protected static PiVector m_smparam;
    protected static String[] m_genACB;
    protected PgPolygonSet m_uCircle;
    protected boolean m_isVisible = true;
    protected static RMap m_map;
    protected static String[] m_eltG;
    protected static int[][] m_rRsSt;
    protected static String[] m_eltH;
    protected static String[] m_coset;
    protected static int[][] m_cosetPerm;
    protected static PiVector[] m_tileNeighbor;
    protected static String[] m_label;
    protected static String m_genH;
    protected static boolean[] m_oriented;
    public static Color[] m_color;
    public String[] m_stringColor;
    protected static boolean m_isH;
    protected static boolean m_isgH;
    protected static boolean m_isHg;
    protected static int[][] m_permColor;
    protected static boolean m_ispermColorSet;
    protected static boolean m_isColorSet;
    protected static int m_indCol;
    protected static Pu3Dmaps m_pu3Dmap;
    protected static PwShow m_pShow;
    protected static PgElementSet[] m_tile;
    protected static PgElementSet[] m_uniCover;
    protected PuFtube m_puFtube;
    public PdColor[] m_RGBcolor;
    protected static int[] m_number;
    protected static Color[] m_col;
    protected static PgGon m_rGon;
    protected static String[] m_name;
    protected static PgElementSet m_uniGeom;
    protected static PgPolygonSet m_plabel;
    protected static PgElementSet m_mesh4gGon;
    protected static PgElementSet m_cover;
    protected static PgElementSet m_clipMesh;
    protected PgGon m_4gGon;
    protected PgElementSet m_clipped;

    public PuPlanarMaps() {
        super("Spherical/Euclidean/Hyperbolic-PlanarTesselation");
        m_OM = new PgPolygonSet(3);
        m_MN = new PgPolygonSet(3);
        m_NO = new PgPolygonSet(3);
        this.m_uCircle = new PgPolygonSet(3);
        this.m_fdomainSm = new PgElementSet(3);
        this.m_foldSm = new PgElementSet(3);
        m_rGon = new PgGon();
        m_elementSet = new PgElementSet(3);
        m_uniGeom = new PgElementSet(3);
        m_plabel = new PgPolygonSet(3);
        m_mesh4gGon = new PgElementSet(3);
        m_cover = new PgElementSet(3);
        m_clipMesh = new PgElementSet(3);
        this.m_planar.setName("Planar");
        m_rGon.setName("4gGon");
        m_uniGeom.setName("Uni");
        m_plabel.setName("Label");
        m_mesh4gGon.setName("Mesh");
        m_cover.setName("Cover");
        m_clipMesh.setName("ClipMesh");
        m_OM.setName("OM");
        m_MN.setName("MN");
        m_NO.setName("NO");
        this.m_uCircle.setName("Circle");
        this.m_fdomainSm.setName("fdomain");
        this.m_foldSm.setName("foldSm");
        m_genH = "r,t";
        this.makeUnitCircle();
        if (((Object)((Object)this)).getClass() == PuPlanarMaps.class) {
            this.init();
        }
    }

    public boolean update(Object event) {
        int i = 0;
        while (i < this.m_RGBcolor.length) {
            if (event == this.m_RGBcolor[i]) {
                PuPlanarMaps.m_color[i] = this.m_RGBcolor[i].getColor();
                if (m_isH) {
                    this.showSubgroup();
                } else if (m_isgH) {
                    this.recomputeColors(false);
                } else if (m_isHg) {
                    this.recomputeColors(true);
                }
                return true;
            }
            ++i;
        }
        return super.update(event);
    }

    private void makeUnitCircle() {
        this.m_uCircle.setNumVertices(200);
        this.m_uCircle.setNumPolygons(1);
        PiVector p = new PiVector(201);
        int i = 0;
        while (i < 200) {
            double t = (double)(2 * i) * Math.PI / 199.0;
            this.m_uCircle.setVertex(i, 0.0, Math.cos(t), Math.sin(t));
            p.m_data[i] = i;
            ++i;
        }
        p.m_data[200] = 0;
        this.m_uCircle.setPolygon(0, p);
        this.m_uCircle.showVertices(false);
        this.m_uCircle.setGlobalPolygonSize(1.0);
    }

    public void setGeneratorABC(String[] ABC) {
        m_genACB = ABC;
    }

    public void setSmParameter(PiVector p) {
        m_smparam = p;
    }

    public void setShow(PwShow p) {
        m_pShow = p;
    }

    public void setFtube(PuFtube p) {
        this.m_puFtube = p;
    }

    public boolean isVisible() {
        return this.m_isVisible;
    }

    public void isEnabledDual(boolean flag) {
        this.m_dual = flag;
    }

    public void setVisible(boolean flag) {
        this.m_planar.setVisible(flag);
        this.m_isVisible = flag;
        this.m_planar.update((Object)this.m_planar);
        if (PuSpace.SPACE == -1) {
            this.m_uCircle.setVisible(flag);
        } else {
            this.m_uCircle.setVisible(false);
        }
        this.m_uCircle.update((Object)this.m_uCircle);
    }

    public void set3Dmap(Pu3Dmaps p) {
        m_pu3Dmap = p;
    }

    public void setParameterRM(int g, int i, int p, int q) {
        m_g = g;
        m_i = i;
        m_p = p;
        m_q = q;
    }

    public void setParameterRM(int[] parm) {
        m_g = parm[0];
        m_i = parm[1];
        m_p = parm[2];
        m_q = parm[3];
        PiVector param = new PiVector(6);
        param.m_data[0] = m_g;
        param.m_data[1] = m_i;
        param.m_data[2] = m_p;
        param.m_data[3] = m_q;
        param.m_data[4] = m_a;
        param.m_data[5] = m_b;
        m_symM_S = new symGroup(param, "rst", this.m_dual);
    }

    public void setab(int[] ab) {
        m_a = ab[0];
        m_b = ab[1];
    }

    public void fTriangle(PgElementSet geom) {
        geom.setNumVertices(3);
        geom.setNumElements(1);
        switch (PuSpace.SPACE) {
            case -1: {
                geom.setVertex(2, new PdVector(1.0, 0.0, 0.0));
                double cosa = Math.cos(Math.PI / (double)m_q) / Math.sin(Math.PI / (double)m_p);
                double cosb = Math.cos(Math.PI / (double)m_p) / Math.sin(Math.PI / (double)m_q);
                geom.setVertex(1, new PdVector(cosb, -Math.sinh(PuMath.acosh((double)cosb)), 0.0));
                geom.setVertex(0, new PdVector(cosa, 0.0, PuMath.sinh((double)PuMath.acosh((double)cosa))));
                break;
            }
            case 0: {
                geom.setVertex(2, new PdVector(0.0, 0.0, 0.0));
                geom.setVertex(0, new PdVector(0.0, 0.5, 0.0));
                geom.setVertex(1, new PdVector(-0.5 * Math.tan(Math.PI / (double)m_p), 0.0, 0.0));
                break;
            }
            case 1: {
                PuIsometry.isSpherical2D(true);
                geom.setVertex(2, new PdVector(0.0, 0.0, 0.0));
                geom.setVertex(0, new PdVector(0.0, 1.0, 0.0));
                if (m_p == 2) {
                    geom.setVertex(1, new PdVector(-Math.tan(0.9424777960769379)));
                    break;
                }
                geom.setVertex(1, new PdVector(-Math.tan(Math.PI / (double)m_p)));
            }
        }
        geom.setElement(0, 0, 1, 2);
        m_O = PdVector.copyNew((PdVector)geom.getVertex(2));
        m_M = PdVector.copyNew((PdVector)geom.getVertex(0));
        m_N = PdVector.copyNew((PdVector)geom.getVertex(1));
    }

    public void makeLinewOfTile() {
        m_OM.setNumPolygons(1);
        m_OM.setNumVertices(2);
        m_MN.setNumPolygons(1);
        m_MN.setNumVertices(2);
        m_NO.setNumPolygons(1);
        m_NO.setNumVertices(2);
        m_OM.setVertex(0, m_O);
        m_OM.setVertex(1, m_M);
        m_MN.setVertex(0, m_M);
        m_MN.setVertex(1, m_N);
        m_NO.setVertex(0, m_N);
        m_NO.setVertex(1, m_O);
        m_OM.setPolygon(0, new PiVector(0, 1));
        m_MN.setPolygon(0, new PiVector(0, 1));
        m_NO.setPolygon(0, new PiVector(0, 1));
    }

    public static void makeLinesOfTile(PgPolygonSet pol) {
        PdVector[] vertex = pol.getVertices();
        int newnov = m_eltH.length * m_coset.length;
        int newnop = m_coset.length * m_eltH.length;
        pol.setNumVertices(newnov);
        pol.setNumPolygons(newnop);
        PdMatrix trans = new PdMatrix(3);
        int indv = 0;
        int inde = 0;
        boolean[] checked = new boolean[newnop + 1];
        int index = -1;
        int i = 0;
        while (i < m_coset.length) {
            int j = 0;
            while (j < m_eltH.length) {
                String inv = PuIsometry.getInverseStringElt(m_coset[i], "rst");
                String mov = String.valueOf(inv) + m_eltH[j];
                index = PuSubgroup.getIndexOfEltInG(mov, m_rRsSt, "rst", true);
                if (!checked[index]) {
                    PdVector[] rotVertex = new PdVector[2];
                    trans = PuIsometry.getTrans(mov, m_rst, "rst");
                    int k = 0;
                    while (k < 2) {
                        rotVertex[k] = new PdVector(3);
                        PdVector vhomo = PdVector.copyNew((PdVector)vertex[k]);
                        if (PuSpace.SPACE == 0 || PuSpace.SPACE == 1) {
                            vhomo.setEntry(2, 1.0);
                            trans.leftMultMatrix(rotVertex[k], vhomo);
                            rotVertex[k].setEntry(2, 0.0);
                        } else {
                            trans.leftMultMatrix(rotVertex[k], vhomo);
                        }
                        ++k;
                    }
                    k = 0;
                    while (k < 2) {
                        pol.setVertex(indv, rotVertex[k]);
                        ++indv;
                        ++k;
                    }
                    PiVector tmp = PiVector.copyNew((PiVector)pol.getPolygon(0));
                    tmp.add(inde * 2);
                    pol.setPolygon(index, tmp);
                    pol.setPolygonSize(index, 1.0);
                    checked[index] = true;
                    ++inde;
                }
                ++j;
            }
            ++i;
        }
        pol.setGlobalPolygonSize(0.5);
        pol.update((Object)pol);
    }

    private void getGroupInformation() {
        PiVector param = new PiVector(6);
        param.set(new int[]{m_g, m_i, m_p, m_q, m_a, m_b});
        m_map = new RMap(param, null, null, this.m_dual, null);
        symGroup M_S = m_map.getSymmetryGroup();
        m_eltG = M_S.getElements();
        m_rRsSt = M_S.getPermutation();
        m_coset = M_S.getCosetElements();
        m_cosetPerm = M_S.getCosetPermutation();
        m_color = new Color[m_coset.length];
        int i = 0;
        while (i < m_coset.length) {
            PuPlanarMaps.m_color[i] = Color.getHSBColor((float)Math.asin((float)i / (float)m_coset.length), 0.4f, 1.0f);
            ++i;
        }
        m_eltH = M_S.getSubGroupElements();
        m_tile = new PgElementSet[m_eltG.length];
        m_oriented = new boolean[m_eltG.length];
        i = 0;
        while (i < m_eltG.length) {
            String rep = m_eltG[i];
            PuPlanarMaps.m_oriented[i] = !rep.contains("t");
            ++i;
        }
        m_label = new String[m_eltG.length];
        PuPlanarMaps.makeTileNeighbor();
    }

    public PgElementSet generateTriG() {
        this.getGroupInformation();
        this.fTriangle(m_elementSet);
        int nov = m_elementSet.getNumVertices();
        PdVector[] vertex = m_elementSet.getVertices();
        PuIsometry.setTriangle(vertex);
        PuIsometry.setpq(m_p, m_q);
        m_rst = PuIsometry.getIsometries();
        int newnov = nov * m_eltG.length;
        int newnoe = m_eltH.length * m_coset.length;
        m_elementSet.setNumVertices(newnov);
        m_elementSet.setNumElements(newnoe);
        PdMatrix trans = new PdMatrix(3);
        int indv = 0;
        int inde = 0;
        boolean[] checked = new boolean[m_eltH.length * m_coset.length + 1];
        int index = -1;
        int indexCoset = -1;
        int i = 0;
        while (i < m_coset.length) {
            int j = 0;
            while (j < m_eltH.length) {
                String inv = PuIsometry.getInverseStringElt(m_coset[i], "rst");
                String mov = String.valueOf(inv) + m_eltH[j];
                index = PuSubgroup.getIndexOfEltInG(mov, m_rRsSt, "rst", true);
                if (!checked[index]) {
                    PdVector[] rotVertex = new PdVector[nov];
                    trans = PuIsometry.getTrans(mov, m_rst, "rst");
                    int k = 0;
                    while (k < nov) {
                        rotVertex[k] = new PdVector(3);
                        PdVector vhomo = PdVector.copyNew((PdVector)vertex[k]);
                        if (PuSpace.SPACE == 0 || PuSpace.SPACE == 1) {
                            vhomo.setEntry(2, 1.0);
                            trans.leftMultMatrix(rotVertex[k], vhomo);
                            rotVertex[k].setEntry(2, 0.0);
                        } else {
                            trans.leftMultMatrix(rotVertex[k], vhomo);
                        }
                        ++k;
                    }
                    k = 0;
                    while (k < nov) {
                        m_elementSet.setVertex(indv, rotVertex[k]);
                        ++indv;
                        ++k;
                    }
                    PiVector tmp = PiVector.copyNew((PiVector)m_elementSet.getElement(0));
                    tmp.add(inde * nov);
                    m_elementSet.setElement(index, tmp);
                    indexCoset = PuSubgroup.getIndexOfEltInG(mov, m_cosetPerm, "rst", false);
                    m_elementSet.setElementColor(index, m_color[indexCoset]);
                    m_elementSet.getElement(index).setName(index + 1 + "," + m_eltG[index]);
                    checked[index] = true;
                    ++inde;
                }
                ++j;
            }
            ++i;
        }
        PuCleanMesh.identifyVertices((PgPointSet)m_elementSet, (double)0.02);
        m_elementSet.makeNeighbour();
        m_elementSet.showElementColors(true);
        return m_elementSet;
    }

    public PgElementSet computePlanarMap() {
        this.m_planar.copy((PsObject)this.generateTriG());
        this.makeLinewOfTile();
        PwPutGrid.setNumDiscr(7);
        return this.m_planar;
    }

    private void makeFundQtube() {
        if (PuSpace.SPACE == 0) {
            PdVector sum;
            PdVector Rdir;
            PdVector dir;
            double a = m_a;
            double b = m_b;
            double scale = Math.tan(Math.PI / (double)m_p);
            double theta = Math.PI * 2 / (double)m_q;
            if (m_p == 6) {
                theta /= 2.0;
            }
            PdMatrix R = new PdMatrix(3);
            R.set((double[][])new double[][]{{Math.cos(theta), -Math.sin(theta), 0.0}, {Math.sin(theta), Math.cos(theta), 0.0}, {0.0, 0.0, 1.0}});
            a *= scale;
            if (m_b == 0 && m_p == 6) {
                dir = new PdVector(a, 0.0, 0.0);
                Rdir = new PdVector(3);
                Rdir.leftMultMatrix(R, dir);
                sum = PdVector.addNew((PdVector)dir, (PdVector)Rdir);
                a = sum.m_data[0];
                b = sum.m_data[1];
            }
            if (m_a == m_b) {
                if (m_p != 6) {
                    dir = new PdVector(a, 0.0, 0.0);
                    Rdir = new PdVector(3);
                    Rdir.leftMultMatrix(R, dir);
                    sum = PdVector.addNew((PdVector)dir, (PdVector)Rdir);
                    a = sum.m_data[0];
                    b = sum.m_data[1];
                } else {
                    dir = new PdVector(a, 0.0, 0.0);
                    Rdir = new PdVector(3);
                    Rdir.leftMultMatrix(R, dir);
                    PdVector dir1 = PdVector.addNew((PdVector)dir, (PdVector)Rdir);
                    PdVector dir2 = new PdVector(3);
                    dir2.leftMultMatrix(R, dir1);
                    PdVector sum2 = PdVector.addNew((PdVector)dir1, (PdVector)dir2);
                    a = sum2.m_data[0];
                    b = sum2.m_data[1];
                }
            }
            PdVector v = new PdVector(3);
            R.set((double[][])new double[][]{{Math.cos(theta), -Math.sin(theta), 0.0}, {Math.sin(theta), Math.cos(theta), 0.0}, {0.0, 0.0, 1.0}});
            R.leftMultMatrix(v, new PdVector(a, b, 0.0));
            double c = v.m_data[0];
            double d = v.m_data[1];
            PdVector u = new PdVector(a, b, 0.0);
            PdVector w = new PdVector(1.0, 0.0, 0.0);
            PdVector z = new PdVector(0.0, 1.0, 0.0);
            PdMatrix SR = PuIsometry.mapXtoY(u, v, w, z);
            SR.multScalar(Math.PI * 2);
            this.m_fdomainSm.setNumVertices(4);
            this.m_fdomainSm.setNumElements(1);
            this.m_fdomainSm.setVertex(0, a, b, 0.0);
            this.m_fdomainSm.setVertex(1, a + c, b + d, 0.0);
            this.m_fdomainSm.setVertex(2, c, d, 0.0);
            this.m_fdomainSm.setVertex(3, 0.0, 0.0, 0.0);
            PiVector p = new PiVector(4);
            p.m_data[0] = 0;
            p.m_data[1] = 1;
            p.m_data[2] = 2;
            p.m_data[3] = 3;
            this.m_fdomainSm.setElement(0, p);
            this.m_fdomainSm.setElementColor(0, Color.red);
            PdVector center = new PdVector(a + c, b + d, 0.0);
            center.multScalar(0.5);
            int i = 0;
            while (i < 4) {
                this.m_fdomainSm.getVertex(i).sub(center);
                ++i;
            }
        } else if (PuSpace.SPACE == -1) {
            PdVector M = PdVector.copyNew((PdVector)PuPlanarMaps.getOM().getVertex(1));
            PdVector N = PdVector.copyNew((PdVector)PuPlanarMaps.getNO().getVertex(0));
            PdVector N0 = new PdVector(3);
            N0 = m_genACB[2].contains("s") ? N : M;
            PdMatrix A = PuIsometry.getTrans(m_genACB[0], m_rst, "rst");
            PdMatrix C = PuIsometry.getTrans(m_genACB[1], m_rst, "rst");
            PdVector AN0 = new PdVector(3);
            PdVector CN0 = new PdVector(3);
            PdVector CAN0 = new PdVector(3);
            AN0.leftMultMatrix(A, N0);
            CN0.leftMultMatrix(C, N0);
            CAN0.leftMultMatrix(C, AN0);
            PdVector N1 = PuHyperboloid.getMidPoint(N0, AN0);
            PdVector N2 = PuHyperboloid.getMidPoint(CN0, CAN0);
            PdVector N3 = CN0;
            int m_numDiscr = 7;
            PdVector[] vertex = new PdVector[]{N0, N1, N2, N3};
            PdVector[][] discrEdge = new PdVector[4][m_numDiscr];
            int i = 0;
            while (i < 4) {
                discrEdge[i] = PwPutGrid.makeEdge(vertex[i], vertex[(i + 1) % 4], m_numDiscr);
                ++i;
            }
            PiVector f = new PiVector(4 * (m_numDiscr - 1));
            int ind = 0;
            this.m_fdomainSm.setNumVertices(4 + 4 * (m_numDiscr - 1));
            this.m_fdomainSm.setNumElements(1);
            int i2 = 0;
            while (i2 < 4) {
                int j = 1;
                while (j < m_numDiscr - 1) {
                    this.m_fdomainSm.setVertex(4 + ind, discrEdge[i2][j]);
                    f.setEntry(i2 * (m_numDiscr - 1) + j, 4 + ind);
                    ++ind;
                    ++j;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < 4) {
                f.setEntry(i2 * (m_numDiscr - 1), i2);
                this.m_fdomainSm.setVertex(i2, vertex[i2]);
                ++i2;
            }
            this.m_fdomainSm.setElement(0, f);
        }
    }

    private void makeFoldoutTube() {
        this.makeFundQtube();
        this.m_foldSm.copy((PsObject)this.m_fdomainSm);
        PuQuadTesselation.replicate(this.m_foldSm, m_smparam);
    }

    public PgElementSet getFdomainSm() {
        this.makeFundQtube();
        return this.m_fdomainSm;
    }

    public PgElementSet getPfoldoutSm() {
        this.makeFoldoutTube();
        return this.m_foldSm;
    }

    private void defaultMeshView() {
        this.m_planar.showEdges(false);
        if (this.m_planar.isShowingSmoothLighting() && !this.m_planar.hasVertexNormals()) {
            this.m_planar.makeVertexNormals();
        }
        this.m_planar.showSmoothLighting(true);
    }

    public void updateDisplay() {
        this.defaultMeshView();
        if (!this.m_display.containsGeometry((PgGeometryIf)this.m_planar)) {
            this.m_display.addGeometry((PgGeometryIf)this.m_planar);
        } else {
            this.m_planar.update((Object)this.m_planar);
        }
        if (PuSpace.SPACE == 0 || PuSpace.SPACE == 1) {
            this.m_display.selectCamera(1);
        } else {
            this.m_display.selectCamera(3);
            if (!this.m_display.containsGeometry((PgGeometryIf)this.m_uCircle)) {
                this.m_display.addGeometry((PgGeometryIf)this.m_uCircle);
            }
            PwPutGrid.setNumDiscr(7);
            PwPutGrid.makeCurvedEdge(this.m_planar);
            PuHyperboloid.hyperboloidToPoincare(this.m_planar.getVertices());
            this.m_planar.update((Object)this.m_planar);
            this.m_planar.makeVertexNormals();
        }
        this.setVisible(true);
        this.m_display.fit();
        this.m_display.update((Object)this.m_display);
    }

    public void show() {
        this.updateDisplay();
        m_pu3Dmap.setVisible(false);
        this.m_puFtube.setVisible(false);
    }

    protected static void makeTileNeighbor() {
        int noe = m_eltG.length;
        m_tileNeighbor = new PiVector[noe];
        String[] bt = new String[]{"t", "St", "rt"};
        int i = 0;
        while (i < noe) {
            String tr = m_eltG[i];
            PuPlanarMaps.m_tileNeighbor[i] = new PiVector(3);
            int j = 0;
            while (j < 3) {
                PuPlanarMaps.m_tileNeighbor[i].m_data[j] = PuSubgroup.getIndexOfEltInG(String.valueOf(tr) + bt[j], m_rRsSt, "rst", true);
                ++j;
            }
            ++i;
        }
    }

    public static boolean[] getOrientation() {
        return m_oriented;
    }

    public static PiVector[] getNeighbor() {
        return m_tileNeighbor;
    }

    public static void setOM(PgPolygonSet m_OM) {
        PuPlanarMaps.m_OM = m_OM;
    }

    public static PgPolygonSet getOM() {
        PuPlanarMaps.makeLinesOfTile(m_OM);
        return m_OM;
    }

    public static void setMN(PgPolygonSet m_MN) {
        PuPlanarMaps.m_MN = m_MN;
    }

    public static PgPolygonSet getMN() {
        PuPlanarMaps.makeLinesOfTile(m_MN);
        return m_MN;
    }

    public static void setNO(PgPolygonSet m_NO) {
        PuPlanarMaps.m_NO = m_NO;
    }

    public static PgPolygonSet getNO() {
        PuPlanarMaps.makeLinesOfTile(m_NO);
        return m_NO;
    }

    public PgElementSet getGeometry() {
        return this.m_planar;
    }

    public void setElementLabel(boolean state) {
        int noe = this.m_planar.getNumElements();
        PiVector[] elt = this.m_planar.getElements();
        int i = 0;
        while (i < noe) {
            String s = elt[i].getName();
            String[] aux = s.split(",");
            if (aux.length > 1) {
                elt[i].setName(aux[1]);
            }
            ++i;
        }
    }

    public void setGeneneratorH(String gen) {
        m_genH = gen;
    }

    public void updateColor() {
        this.setPermColorSet(false);
        this.computColorPermutation();
        this.isColorSet(false);
        if (m_isH) {
            this.showSubgroup();
        } else if (m_isgH) {
            this.recomputeColors(false);
        } else if (m_isHg) {
            this.recomputeColors(true);
        }
    }

    public void initColor() {
        int numCol = m_permColor[0].length;
        m_color = new Color[numCol];
        int j = 0;
        while (j < numCol) {
            PuPlanarMaps.m_color[j] = Color.getHSBColor((float)Math.asin((float)j / (float)numCol), 0.4f, 1.0f);
            ++j;
        }
    }

    private void computColorPermutation() {
        symGroup M_S = m_map.getSymmetryGroup();
        String[] G = new String[]{"group name:g;", "group generators:rst;", "group relators:" + M_S.getRelators()};
        PuSubgroup.setGroup(G);
        String genH = "";
        if (m_genH.contains(",")) {
            String[] s = m_genH.split(",");
            genH = s[0];
            int i = 0;
            while (i < s.length) {
                genH = String.valueOf(genH) + "," + s[i];
                ++i;
            }
        } else {
            genH = m_genH;
        }
        if (!m_ispermColorSet) {
            m_permColor = PuSubgroup.getSubGroupPermutation(genH);
            m_ispermColorSet = true;
        }
    }

    public void setPermColorSet(boolean state) {
        m_ispermColorSet = state;
    }

    public void isColorSet(boolean state) {
        m_isColorSet = state;
    }

    public void showSubgroup() {
        this.computColorPermutation();
        if (!m_isColorSet) {
            this.initColor();
            this.isColorSet(true);
        }
        symGroup M_S = m_map.getSymmetryGroup();
        String[] elt = M_S.getElements();
        int noe = elt.length;
        int index = -1;
        Color red = Color.red;
        red.brighter();
        int i = 0;
        while (i < noe) {
            String rep = elt[i];
            index = PuSubgroup.getIndexOfEltInG(rep, m_permColor, "rst", true);
            if (index == 0) {
                this.m_planar.setElementColor(i, m_color[0]);
            } else {
                this.m_planar.setElementColor(i, Color.gray);
            }
            ++i;
        }
        m_isgH = false;
        m_isHg = false;
        m_isH = true;
        this.m_planar.update((Object)this.m_planar);
    }

    public void setSelectedColor(int type) {
        m_indCol = type;
    }

    public void recomputeColors(boolean state) {
        this.computColorPermutation();
        if (!m_isColorSet) {
            this.initColor();
            this.isColorSet(true);
        }
        PgElementSet geom = (PgElementSet)this.m_display.getSelectedGeometry();
        int noe = geom.getNumElements();
        int index = -1;
        PiVector lcol = new PiVector();
        lcol.setEntry(0, -1);
        String[] aux = new String[]{};
        geom.getElement(0).setName("1,I");
        int i = 0;
        while (i < noe) {
            String s = geom.getElement(i).getName();
            aux = s.split(",");
            String rep = aux[1];
            index = PuSubgroup.getIndexOfEltInG(rep, m_permColor, "rst", state);
            geom.setElementColor(i, m_color[index]);
            ++i;
        }
        if (state) {
            m_isgH = false;
            m_isHg = true;
            m_isH = false;
        } else {
            m_isgH = true;
            m_isHg = false;
            m_isH = false;
        }
        geom.update((Object)geom);
    }

    public void updateColorList() {
        int numCol = m_permColor[0].length;
        this.m_RGBcolor = new PdColor[numCol];
        int i = 0;
        while (i < numCol) {
            this.m_RGBcolor[i] = new PdColor("" + i, (PsUpdateIf)this);
            this.m_RGBcolor[i].setColor(m_color[i]);
            ++i;
        }
    }

    public void showColorSymmetry() {
        String[] lsub = m_map.getLowIndexSubGroup(m_genH);
        int len = 0;
        while (lsub[len] != null) {
            ++len;
        }
        this.m_stringColor = new String[len];
        int i = 0;
        while (i < len) {
            this.m_stringColor[i] = lsub[i];
            ++i;
        }
    }

    public void isLeftCosetColored(boolean flag) {
        m_isgH = flag;
    }

    public void showUniversalCover() {
        m_uniGeom.showEdges(false);
        m_uniGeom.showElementColors(true);
        PuHyperboloid.hyperboloidToPoincare(m_uniGeom.getVertices());
        if (!this.m_display.containsGeometry((PgGeometryIf)m_uniGeom)) {
            this.m_display.addGeometry((PgGeometryIf)m_uniGeom);
        }
        m_uniGeom.update((Object)m_uniGeom);
    }

    public PgGon getHyp4gGon() {
        return this.m_4gGon;
    }

    public void show4gGon() {
        this.m_4gGon = PgFourgGon.compute4gGon(m_elementSet);
        m_rGon.copy((PsObject)this.m_4gGon);
        m_plabel.copy((PsObject)this.m_4gGon);
        if (!this.m_display.containsGeometry((PgGeometryIf)m_rGon)) {
            this.m_display.addGeometry((PgGeometryIf)m_rGon);
            this.m_display.addGeometry((PgGeometryIf)m_plabel);
        }
        this.m_display.selectGeometry((PgGeometryIf)m_rGon);
        PuPlanarMaps.uDisplay();
    }

    public static void showIvertices() {
        PgGon g = PgFourgGon.computeIvertices();
        m_rGon.copy((PsObject)g);
        m_plabel.copy((PsObject)g);
        PuPlanarMaps.uDisplay();
    }

    public static void reduce() {
        PgGon g = PgFourgGon.reduction();
        m_rGon.copy((PsObject)g);
        m_plabel.copy((PsObject)g);
        PuPlanarMaps.uDisplay();
    }

    public static void reduceStep() {
        PgGon g = PgFourgGon.reductionStep();
        m_rGon.copy((PsObject)g);
        m_plabel.copy((PsObject)g);
        PuPlanarMaps.uDisplay();
    }

    public static void normalizeStep1() {
        PgGon g = new PgGon();
        PgFourgGon.normalizationStep1(g);
        m_rGon.copy((PsObject)g);
        m_plabel.copy((PsObject)g);
        PuPlanarMaps.uDisplay();
    }

    public static void normalizeStep2() {
        PgGon g = new PgGon();
        PgFourgGon.normalizationStep2(g);
        m_rGon.copy((PsObject)g);
        m_plabel.copy((PsObject)g);
        PuPlanarMaps.uDisplay();
    }

    public static void normalize() {
        PgGon g = PgFourgGon.normalization();
        m_rGon.copy((PsObject)g);
        m_plabel.copy((PsObject)g);
        PuPlanarMaps.uDisplay();
    }

    public static void makeRegular() {
        PgGon g = new PgGon();
        g.copy((PsObject)PgFourgGon.get4gGon());
        PgFourgGon.regularize(g);
        m_rGon.copy((PsObject)g);
        m_plabel.copy((PsObject)g);
        PuPlanarMaps.uDisplay();
    }

    private static void uDisplay() {
        if (PuSpace.SPACE == -1) {
            PwPutGrid.refinePolygonSet(m_rGon, 20);
            PuHyperboloid.hyperboloidToPoincare(m_rGon.getVertices());
            PuHyperboloid.hyperboloidToPoincare(m_plabel.getVertices());
        }
        m_rGon.showPolygonEndArrow(true);
        m_rGon.showVertices(false);
        m_rGon.setGlobalPolygonSize(1.5);
        int nov = m_plabel.getNumVertices();
        PdVector size = new PdVector(nov);
        int i = 0;
        while (i < nov) {
            size.m_data[i] = 2.5;
            ++i;
        }
        m_plabel.setVertexSizes(size);
        m_plabel.showVertexSizes(true);
        m_plabel.showEdgeLabels(true);
        m_plabel.setGlobalPolygonSize(0.0);
        m_plabel.showVertexColors(true);
        m_plabel.showPolygonEndArrow(true);
        m_rGon.update((Object)m_rGon);
        m_plabel.update((Object)m_plabel);
    }

    public void setPoincareView() {
        PgGeometryIf[] geomIf = this.m_display.getGeometries();
        int numGeom = geomIf.length;
        PgElementSet[] geom = new PgElementSet[numGeom];
        int i = 0;
        while (i < geom.length) {
            if (geomIf[i].getName() != "Circle") {
                PuHyperbolic.projectfromKleintoPoincare(geom[i].getVertices());
                geom[i].update((Object)geom[i]);
            }
            ++i;
        }
        this.m_display.update((Object)this.m_display);
    }

    public void setKleinView() {
        PgGeometryIf[] geomIf = this.m_display.getGeometries();
        int numGeom = geomIf.length;
        PgElementSet[] geom = new PgElementSet[numGeom];
        int i = 0;
        while (i < geom.length) {
            if (geomIf[i].getName() != "Circle") {
                geom[i] = (PgElementSet)geomIf[i];
                PuHyperbolic.projectToKlein(geom[i].getVertices());
                geom[i].update((Object)geom[i]);
            }
            ++i;
        }
        this.m_display.update((Object)this.m_display);
    }

    public static void symmStep1() {
        PgGon g = PgFourgGon.symmetricNormalizedStep1();
        m_rGon.copy((PsObject)g);
        m_plabel.copy((PsObject)g);
        PuPlanarMaps.uDisplay();
    }

    public static void symmStep2() {
        PgGon g = PgFourgGon.symmetricNormalizedStep2();
        m_rGon.copy((PsObject)g);
        m_plabel.copy((PsObject)g);
        PuPlanarMaps.uDisplay();
    }

    public static void symmetrize() {
        PgGon g = PgFourgGon.symmetricNormalized();
        m_rGon.copy((PsObject)g);
        m_plabel.copy((PsObject)g);
        PuPlanarMaps.uDisplay();
    }

    public static void make4gGonOrientation() {
        PgGon g = PgFourgGon.makeGlobalOrientation();
        m_rGon.copy((PsObject)g);
        m_plabel.copy((PsObject)g);
        PuPlanarMaps.uDisplay();
    }

    public static void mapToOrigin() {
        PgGon g = PgFourgGon.symPointToOrigin();
        m_rGon.copy((PsObject)g);
        m_plabel.copy((PsObject)g);
        PuPlanarMaps.uDisplay();
    }

    public void makeQuadMesh() {
        PgGon g = PgFourgGon.get4gGon();
        m_mesh4gGon.copy((PsObject)PuMesh4gGon.merge(PuMesh4gGon.createMesh(g)));
        this.updateMesh();
    }

    private void updateMesh() {
        if (PuSpace.SPACE == -1) {
            PuHyperboloid.hyperboloidToPoincare(m_mesh4gGon.getVertices());
        }
        if (!this.m_display.containsGeometry((PgGeometryIf)m_mesh4gGon)) {
            this.m_display.addGeometry((PgGeometryIf)m_mesh4gGon);
        }
        m_mesh4gGon.update((Object)m_mesh4gGon);
    }

    public PgElementSet getClip4gGon() {
        return this.m_clipped;
    }

    private PgElementSet computeClip4gGon() {
        this.m_clipped = this.computeCover();
        PgGon g = PgFourgGon.get4gGon();
        PdVector[] vertex = g.getccwVertices();
        PuCompGeometry.computeInterTrianglePgon(this.m_clipped, vertex);
        return this.m_clipped;
    }

    public void clipMesh4gGon() {
        m_clipMesh.copy((PsObject)this.computeClip4gGon());
        PuHyperboloid.hyperboloidToPoincare(m_clipMesh.getVertices());
        m_clipMesh.makeVertexNormals();
        m_clipMesh.showElementColors(true);
        if (!this.m_display.containsGeometry((PgGeometryIf)m_clipMesh)) {
            this.m_display.addGeometry((PgGeometryIf)m_clipMesh);
        }
        m_clipMesh.update((Object)m_clipMesh);
        this.m_display.update((Object)this.m_display);
    }

    private PgElementSet computeCover() {
        int numElt;
        int v1;
        int v0;
        PgElementSet cover = new PgElementSet(3);
        cover.copy((PsObject)this.m_planar);
        PgGon g = PgFourgGon.get4gGon();
        g.makeGlobalOrientation();
        int s = g.getStart();
        int nop = g.getNumPolygons();
        if (!g.isccw()) {
            boolean[] fliped = new boolean[nop];
            int i = 0;
            while (i < nop) {
                s = g.followNextBy(i);
                if (!fliped[s]) {
                    g.flip(s);
                    fliped[s] = true;
                    fliped[g.getOpposite((int)s)] = true;
                }
                ++i;
            }
        }
        int nov = g.getNumVertices();
        PdVector[] vertex = g.getVertices();
        PdVector[] ordVertex = new PdVector[nov];
        PiVector[] polygon = g.getPolygons();
        boolean[] checked = new boolean[nov];
        int ind = 0;
        int i = 0;
        while (i < nov) {
            s = g.followNextBy(i);
            v0 = polygon[s].m_data[0];
            v1 = polygon[s].m_data[1];
            if (!checked[v0]) {
                ordVertex[ind] = vertex[v0];
                checked[v0] = true;
                ++ind;
            }
            if (!checked[v1]) {
                ordVertex[ind] = vertex[v1];
                checked[v1] = true;
                ++ind;
            }
            ++i;
        }
        int noe = m_elementSet.getNumElements();
        PiVector[] elt = m_elementSet.getElements();
        PdVector[] vert = m_elementSet.getVertices();
        PdVector[] tri = new PdVector[3];
        int start = -1;
        String repStart = "";
        int i2 = 0;
        while (i2 < noe) {
            tri[0] = vert[elt[i2].m_data[0]];
            tri[1] = vert[elt[i2].m_data[1]];
            tri[2] = vert[elt[i2].m_data[2]];
            if (!PuCompGeometry.ccw(tri)) {
                PdVector tmp = tri[1];
                tri[1] = tri[2];
                tri[2] = tmp;
            }
            if (PuCompGeometry.isTriangleInsidePolygon(tri, ordVertex) || PuCompGeometry.isPolygonIntersectPolygon(ordVertex, tri)) {
                start = i2;
                repStart = elt[i2].getName().split(",")[1];
                break;
            }
            ++i2;
        }
        int not = m_symM_S.getNumElements();
        Color[] color = m_symM_S.getColors();
        checked = new boolean[not];
        double cosa = Math.cos(Math.PI / (double)m_q) / Math.sin(Math.PI / (double)m_p);
        double cosb = Math.cos(Math.PI / (double)m_p) / Math.sin(Math.PI / (double)m_q);
        PdVector O = new PdVector(1.0, 0.0, 0.0);
        PdVector N = new PdVector(cosb, -Math.sinh(PuMath.acosh((double)cosb)), 0.0);
        PdVector M = new PdVector(cosa, 0.0, PuMath.sinh((double)PuMath.acosh((double)cosa)));
        PdVector[] bTriangle = new PdVector[]{N, O, M};
        PdMatrix[] isom = PuIsometry.getIsometries(m_p, m_q, bTriangle, m_g);
        PdVector[] Itri = new PdVector[3];
        PdMatrix trans = PuIsometry.getTrans(repStart, isom, "rst");
        int i3 = 0;
        while (i3 < 3) {
            Itri[i3] = new PdVector(3);
            Itri[i3].leftMultMatrix(trans, bTriangle[i3]);
            ++i3;
        }
        cover.setNumVertices(3 * not);
        cover.setNumElements(not);
        cover.setVertex(0, Itri[0]);
        cover.setVertex(1, Itri[1]);
        cover.setVertex(2, Itri[2]);
        cover.setElement(start, 0, 1, 2);
        cover.setElementColor(start, color[start]);
        cover.getElement(start).setName(String.valueOf(start) + ",");
        String[] nb = new String[]{"t", "St", "rt"};
        checked = new boolean[not];
        PiVector[] processed = new PiVector[not];
        String[] crep = new String[not];
        crep[start] = repStart;
        processed[0] = new PiVector(1);
        processed[0].set(start);
        checked[start] = true;
        int next = 1;
        int index = -1;
        PdVector[] adjTriangle = new PdVector[3];
        PiVector[] interPol = new PiVector[nop];
        int i4 = 0;
        while (i4 < nop) {
            interPol[i4] = new PiVector();
            ++i4;
        }
        int indv = 3;
        int step = 0;
        while (step < not) {
            int proci = processed[step].m_data[0];
            int j = 0;
            while (j < 3) {
                block28: {
                    String rep;
                    block27: {
                        rep = String.valueOf(crep[proci]) + nb[j];
                        index = PuSubgroup.getIndexOfEltInG(rep, m_symM_S.getPermutation(), "rst", true);
                        trans = PuIsometry.getTrans(rep, isom, "rst");
                        int k = 0;
                        while (k < 3) {
                            adjTriangle[k] = new PdVector(3);
                            trans.leftMultMatrix(adjTriangle[k], Itri[k]);
                            ++k;
                        }
                        if (!PuCompGeometry.ccw(adjTriangle)) {
                            PdVector tmp = adjTriangle[1];
                            adjTriangle[1] = adjTriangle[2];
                            adjTriangle[2] = tmp;
                        }
                        if (!PuCompGeometry.isTriangleInsidePolygon(adjTriangle, ordVertex)) break block27;
                        if (checked[index]) break block28;
                        checked[index] = true;
                        int col = PuSubgroup.getIndexOfEltInG(rep, m_symM_S.getCosetPermutation(), "rst", false);
                        cover.setVertex(indv, adjTriangle[0]);
                        cover.setVertex(indv + 1, adjTriangle[1]);
                        cover.setVertex(indv + 2, adjTriangle[2]);
                        cover.setElement(index, indv, indv + 1, indv + 2);
                        cover.setElementColor(index, color[col]);
                        cover.getElement(index).setName(String.valueOf(index) + "," + rep);
                        indv += 3;
                        crep[index] = rep;
                        if (next >= processed.length) break block28;
                        processed[next] = new PiVector(1);
                        processed[next].set(index);
                        ++next;
                        break block28;
                    }
                    if (!checked[index] && PuCompGeometry.isPolygonIntersectPolygon(ordVertex, adjTriangle)) {
                        checked[index] = true;
                        int col = PuSubgroup.getIndexOfEltInG(rep, m_symM_S.getCosetPermutation(), "rst", false);
                        cover.setVertex(indv, adjTriangle[0]);
                        cover.setVertex(indv + 1, adjTriangle[1]);
                        cover.setVertex(indv + 2, adjTriangle[2]);
                        cover.setElement(index, indv, indv + 1, indv + 2);
                        cover.setElementColor(index, color[col]);
                        cover.getElement(index).setName(String.valueOf(index) + "," + rep);
                        crep[index] = rep;
                        indv += 3;
                        if (next < processed.length) {
                            processed[next] = new PiVector(1);
                            processed[next].set(index);
                            ++next;
                        }
                        int k = 0;
                        while (k < nop) {
                            v0 = polygon[k].m_data[0];
                            v1 = polygon[k].m_data[1];
                            if (PuCompGeometry.isLineIntersectPolygon(vertex[v0], vertex[v1], adjTriangle) && interPol[k].getIndexOf(index) == -1) {
                                interPol[k].addEntry(index);
                            }
                            ++k;
                        }
                    }
                }
                ++j;
            }
            ++step;
        }
        boolean[] added = new boolean[interPol.length];
        int numVert = cover.getNumVertices();
        int indNext = numElt = cover.getNumElements();
        int indPrev = numElt;
        cover.setNumVertices(2 * numVert);
        cover.setNumElements(2 * numElt);
        int indVert = 0;
        int indElt = 0;
        int i5 = 0;
        while (i5 < interPol.length) {
            PiVector t_i = interPol[i5];
            int io = g.getOpposite(i5);
            PdMatrix T = g.getTrans(i5, io);
            PdVector[] copyTri = new PdVector[3];
            indPrev = indNext;
            String label = "";
            int j = 0;
            while (j < t_i.getSize()) {
                PiVector f = cover.getElement(t_i.m_data[j]);
                label = f.getName();
                int m = 0;
                while (m < 3) {
                    copyTri[m] = (PdVector)cover.getVertex(f.m_data[m]).clone();
                    ++m;
                }
                copyTri[0].leftMultMatrix(T);
                copyTri[1].leftMultMatrix(T);
                copyTri[2].leftMultMatrix(T);
                cover.setVertex(numVert + indVert, copyTri[0]);
                cover.setVertex(numVert + indVert + 1, copyTri[1]);
                cover.setVertex(numVert + indVert + 2, copyTri[2]);
                cover.setElement(numElt + indElt, numVert + indVert, numVert + indVert + 1, numVert + indVert + 2);
                Color col = cover.getElementColor(t_i.m_data[j]);
                cover.setElementColor(numElt + indElt, col);
                cover.getElement(numElt + indElt).setName(f.getName());
                indVert += 3;
                ++indElt;
                ++j;
            }
            indNext = numElt + indElt;
            int ion = g.getNext(io);
            int iop = g.getPrev(io);
            int[] nArray = new int[]{ion, iop};
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int j2 = nArray[n2];
                PiVector pol = g.getPolygon(j2);
                PdVector sv = g.getVertex(pol.m_data[0]);
                PdVector ev = g.getVertex(pol.m_data[1]);
                int k = indPrev;
                while (k < indNext) {
                    PiVector f = cover.getElement(k);
                    int m = 0;
                    while (m < 3) {
                        copyTri[m] = (PdVector)cover.getVertex(f.m_data[m]).clone();
                        ++m;
                    }
                    if (PuCompGeometry.isLineIntersectPolygon(sv, ev, copyTri) && !added[j2]) {
                        interPol[j2].addEntry(k);
                        int jo = g.getOpposite(j2);
                        T = g.getTrans(j2, jo);
                        int m2 = 0;
                        while (m2 < 3) {
                            copyTri[m2] = (PdVector)cover.getVertex(f.m_data[m2]).clone();
                            ++m2;
                        }
                        copyTri[0].leftMultMatrix(T);
                        copyTri[1].leftMultMatrix(T);
                        copyTri[2].leftMultMatrix(T);
                        cover.setVertex(numVert + indVert, copyTri[0]);
                        cover.setVertex(numVert + indVert + 1, copyTri[1]);
                        cover.setVertex(numVert + indVert + 2, copyTri[2]);
                        cover.setElement(numElt + indElt, numVert + indVert, numVert + indVert + 1, numVert + indVert + 2);
                        Color col = cover.getElementColor(k);
                        cover.setElementColor(numElt + indElt, col);
                        cover.getElement(numElt + indElt).setName(String.valueOf(label) + ",");
                        indVert += 3;
                        ++indElt;
                    }
                    ++k;
                }
                ++n2;
            }
            ++i5;
        }
        PuCleanMesh.identifyVertices((PgPointSet)cover, (double)0.01);
        return cover;
    }

    public void cover4gGon() {
        m_cover.copy((PsObject)this.computeCover());
        PuHyperboloid.hyperboloidToPoincare(m_cover.getVertices());
        m_cover.showElementColors(true);
        if (!this.m_display.containsGeometry((PgGeometryIf)m_cover)) {
            this.m_display.addGeometry((PgGeometryIf)m_cover);
        }
        m_cover.update((Object)m_cover);
    }

    public PgElementSet getTriangle(PdVector[] tVert) {
        PgElementSet geom = new PgElementSet(3);
        geom.setNumVertices(3);
        geom.setNumElements(1);
        int i = 0;
        while (i < 3) {
            geom.setVertex(i, tVert[i]);
            ++i;
        }
        geom.setElement(0, 0, 1, 2);
        int n = 2;
        int nov = 3;
        PdVector[] vertex = geom.getVertices();
        int newnov = 3 * (n - 2) + 3;
        geom.setNumVertices(newnov);
        PdVector[][] newEdge = new PdVector[3][n];
        int i2 = 0;
        while (i2 < 3) {
            newEdge[i2] = PuHyperboloid.makeEdge(vertex[i2], vertex[(i2 + 1) % 3], n);
            ++i2;
        }
        int ind = 0;
        int i3 = 0;
        while (i3 < 3) {
            int j = 1;
            while (j < n - 1) {
                geom.setVertex(nov + ind, newEdge[i3][j]);
                ++ind;
                ++j;
            }
            ++i3;
        }
        PiVector index = new PiVector(n);
        index.setEntry(0, 0);
        index.setEntry(n - 1, 1);
        index.setEntry(2 * n - 2, 2);
        int s = 0;
        int i4 = 1;
        while (i4 < newnov) {
            if (i4 != n - 1 && i4 != 2 * n - 2) {
                index.setEntry(i4, nov + s);
                ++s;
            }
            ++i4;
        }
        PiVector newF = new PiVector(newnov);
        int i5 = 0;
        while (i5 < newnov) {
            newF.m_data[i5] = index.getEntry(i5);
            ++i5;
        }
        geom.setElement(0, newF);
        return geom;
    }

    public void mapToRegular() {
        PgGon g = PgFourgGon.get4gGon();
        PgGon regular = new PgGon();
        regular.copy((PsObject)g);
        PgFourgGon.regularize(regular);
        PgElementSet sourceBar = PgFourgGon.triangulate(g);
        PgElementSet targetBar = PgFourgGon.triangulate(regular);
        PgElementSet tile = this.computeClip4gGon();
        PuMesh4gGon.mapTileFromSourceToTarget(tile, sourceBar, targetBar);
        PuHyperboloid.hyperboloidToKlein(regular.getVertices());
        tile.showElementColors(true);
        this.m_display.addGeometry((PgGeometryIf)regular);
        this.m_display.addGeometry((PgGeometryIf)tile);
    }

    public PdVector mapTo3D(int b, PdVector p, PgElementSet source, PgElementSet target) {
        PdVector Pp = (PdVector)p.clone();
        int nov = source.getNumVertices();
        PdVector[] Pvertex = new PdVector[nov];
        PiVector[] Helt = source.getElements();
        int i = 0;
        while (i < nov) {
            Pvertex[i] = (PdVector)source.getVertex(i).clone();
            ++i;
        }
        double[] triangleArea = new double[4];
        PuHyperbolic.projectToPoincareDisk(Pp);
        PuHyperbolic.projectToPoincareDisk(Pvertex);
        int j = 0;
        while (j < 4) {
            double area;
            PdVector tmp = Pvertex[Helt[b].m_data[(j + 3) % 4]];
            PdVector tmp1 = Pvertex[Helt[b].m_data[j]];
            PdVector tmp2 = Pvertex[Helt[b].m_data[(j + 1) % 4]];
            triangleArea[j] = area = PuHyperbolic.computeAreaHyperbolic(tmp, tmp1, tmp2);
            ++j;
        }
        double[] localArea = new double[4];
        double[] w = new double[4];
        int j2 = 0;
        while (j2 < 4) {
            localArea[j2] = PuHyperbolic.computeAreaHyperbolic(Pp, Pvertex[Helt[b].m_data[j2]], Pvertex[Helt[b].m_data[(j2 + 1) % 4]]);
            ++j2;
        }
        double sum = 0.0;
        int j3 = 0;
        while (j3 < 4) {
            w[j3] = triangleArea[j3] * localArea[(j3 + 1) % 4] * localArea[(j3 + 2) % 4];
            sum += w[j3];
            ++j3;
        }
        PdVector nP = new PdVector(0.0, 0.0, 0.0);
        PiVector threeDElt = target.getElement(b);
        int j4 = 0;
        while (j4 < 4) {
            nP = PdVector.blendNew((double)1.0, (PdVector)nP, (double)w[j4], (PdVector)target.getVertex(threeDElt.m_data[j4]));
            ++j4;
        }
        nP.multScalar(1.0 / sum);
        return nP;
    }
}

