/*
 * Decompiled with CFR 0.152.
 */
package devRegularMap.functions;

import devRegularMap.functions.PuFtube;
import devRegularMap.functions.PuPlanarMaps;
import devRegularMap.grid.PwPutGrid;
import devRegularMap.gui.PwShow;
import devRegularMap.number.PgQuarterTube;
import devRegularMap.number.PgTile;
import devRegularMap.vecmath.PuIsometry;
import devRegularMap.vecmath.PuSpace;
import devRegularMap.vecmath.PuSubgroup;
import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygonSet;
import jv.geom.PuCleanMesh;
import jv.object.PsObject;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jvx.geom.PwCleanMesh;

public class Pu3Dmaps
extends PuPlanarMaps {
    protected PuPlanarMaps m_puPlanar;
    protected PwShow m_pShow;
    protected PgElementSet m_elementSet = new PgElementSet(3);
    protected static PgElementSet[] m_tile;
    public static PgPolygonSet m_OM;
    public PgPolygonSet m_MN;
    public static PgPolygonSet m_NO;
    protected boolean m_isVisible;
    protected boolean m_tubeIsVisible;
    protected PvDisplayIf m_display;
    protected PuFtube m_puFtube;
    protected PgElementSet m_tube;

    public Pu3Dmaps() {
        this.m_elementSet.setName("3D");
        m_OM = new PgPolygonSet(3);
        this.m_MN = new PgPolygonSet(3);
        m_NO = new PgPolygonSet(3);
        m_OM.setName("OM");
        this.m_MN.setName("MN");
        m_NO.setName("NO");
        this.m_tube = new PgElementSet(3);
    }

    @Override
    public void setShow(PwShow p) {
        this.m_pShow = p;
    }

    public void setPlanarMap(PuPlanarMaps p) {
        this.m_puPlanar = p;
    }

    @Override
    public boolean isVisible() {
        return this.m_isVisible;
    }

    public void computeFundTriangle() {
        PdVector M = new PdVector();
        PdVector N = new PdVector();
        PdVector O = new PdVector();
        switch (PuSpace.SPACE) {
            case 1: {
                double cosa = Math.cos(Math.PI / (double)m_q) / Math.sin(Math.PI / (double)m_p);
                double cosb = Math.cos(Math.PI / (double)m_p) / Math.sin(Math.PI / (double)m_q);
                M = new PdVector(0.0, cosa, Math.sin(Math.acos(cosa)));
                N = new PdVector(Math.sin(Math.acos(cosb)), cosb, 0.0);
                O = new PdVector(0.0, 1.0, 0.0);
                PuIsometry.setTriangle(new PdVector[]{M, N, O});
                PuIsometry.isSpherical2D(false);
                m_rst = PuIsometry.getIsometries();
                break;
            }
            case 0: {
                O = new PdVector(0.0, 0.0, 1.0);
                M = new PdVector(0.0, 0.5, 1.0);
                N = new PdVector(-0.5 * Math.tan(Math.PI / (double)m_p), 0.0, 1.0);
                PgTile.initParallelogram();
                break;
            }
            case -1: {
                O = new PdVector(1.0, 0.0, 0.0);
                double cosa = Math.cos(Math.PI / (double)m_q) / Math.sin(Math.PI / (double)m_p);
                double cosb = Math.cos(Math.PI / (double)m_p) / Math.sin(Math.PI / (double)m_q);
                N = new PdVector(cosb, -Math.sinh(PuMath.acosh((double)cosb)), 0.0);
                M = new PdVector(cosa, 0.0, PuMath.sinh((double)PuMath.acosh((double)cosa)));
            }
        }
        PgTile.init(M, N, O);
        m_OM.setNumVertices(2);
        m_OM.setNumPolygons(1);
        m_OM.setVertex(0, O);
        m_OM.setVertex(1, M);
        m_OM.setPolygon(0, 0, 1);
    }

    public void compute3DMap() {
        this.computeFundTriangle();
        m_tile = new PgElementSet[m_eltG.length];
        int i = 0;
        while (i < m_coset.length) {
            String c = PuIsometry.getInverseStringElt(m_coset[i], "rst");
            int j = 0;
            while (j < m_eltH.length) {
                String ch = String.valueOf(c) + m_eltH[j];
                int index = PuSubgroup.getIndexOfEltInG(ch, m_rRsSt, "rst", true);
                Pu3Dmaps.m_tile[index] = PgTile.getGeometry(ch, i);
                m_tile[index].setName("" + index);
                if (!m_oriented[index]) {
                    int k = 0;
                    while (k < m_tile[index].getNumElements()) {
                        m_tile[index].getElement(k).invert();
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        this.merge(m_tile);
    }

    private void merge(PgElementSet[] tile) {
        this.m_elementSet.copy((PsObject)tile[0]);
        int locnov = tile[0].getNumVertices();
        int locnoe = tile[0].getNumElements();
        int not = tile.length;
        this.m_elementSet.setNumVertices(not * locnov);
        this.m_elementSet.setNumElements(not * locnoe);
        PiVector[] neighbor = Pu3Dmaps.getNeighbor();
        boolean[] visited = new boolean[not];
        int[] generated = new int[not];
        int next = 1;
        visited[0] = true;
        generated[0] = 0;
        int m = 0;
        while (m < not) {
            PiVector nb = neighbor[generated[m]];
            int i = 0;
            while (i < 3) {
                if (!visited[nb.m_data[i]]) {
                    PgElementSet nt = tile[nb.m_data[i]];
                    int j = 0;
                    while (j < locnov) {
                        this.m_elementSet.setVertex(nb.m_data[i] * locnov + j, nt.getVertex(j));
                        ++j;
                    }
                    j = 0;
                    while (j < locnoe) {
                        PiVector f = nt.getElement(j);
                        f.add(nb.m_data[i] * locnov);
                        this.m_elementSet.setElement(nb.m_data[i] * locnoe + j, f);
                        this.m_elementSet.setElementColor(nb.m_data[i] * locnoe + j, nt.getElementColor(j));
                        ++j;
                    }
                    visited[nb.m_data[i]] = true;
                    generated[next] = nb.m_data[i];
                    if (next < generated.length - 1) {
                        ++next;
                    }
                }
                ++i;
            }
            ++m;
        }
        this.m_elementSet.makeVertexNormals();
    }

    public static PgPolygonSet getNO() {
        Pu3Dmaps.computeNO();
        return m_NO;
    }

    public static PgPolygonSet get3DOM() {
        PgTile.makeLines(m_OM);
        return m_OM;
    }

    private static void computeNO() {
        int nop = m_eltG.length;
        int n = 7;
        PgPolygonSet[] NO = new PgPolygonSet[nop];
        int i = 0;
        while (i < nop) {
            NO[i] = Pu3Dmaps.getNO(m_tile[i]);
            ++i;
        }
        m_NO.copy((PsObject)NO[0]);
        m_NO.setNumPolygons(nop);
        m_NO.setNumVertices(nop * n);
        PiVector[] neighbor = Pu3Dmaps.getNeighbor();
        boolean[] visited = new boolean[nop];
        int[] generated = new int[nop];
        int next = 1;
        visited[0] = true;
        generated[0] = 0;
        int m = 0;
        while (m < nop) {
            PiVector nb = neighbor[generated[m]];
            int i2 = 0;
            while (i2 < 3) {
                if (!visited[nb.m_data[i2]]) {
                    PgPolygonSet nt = NO[nb.m_data[i2]];
                    int j = 0;
                    while (j < n) {
                        m_NO.setVertex(nb.m_data[i2] * n + j, nt.getVertex(j));
                        m_NO.setVertexNormal(nb.m_data[i2] * n + j, nt.getVertexNormal(j));
                        ++j;
                    }
                    PiVector f = nt.getPolygon(0);
                    f.add(nb.m_data[i2] * n);
                    m_NO.setPolygon(nb.m_data[i2], f);
                    visited[nb.m_data[i2]] = true;
                    generated[next] = nb.m_data[i2];
                    if (next < generated.length - 1) {
                        ++next;
                    }
                }
                ++i2;
            }
            ++m;
        }
    }

    private static PgPolygonSet getNO(PgElementSet tile) {
        PgPolygonSet pol = new PgPolygonSet(3);
        int n = 7;
        pol.setNumVertices(n);
        pol.setNumPolygons(1);
        PdVector[] vertex = tile.getVertices();
        pol.setVertex(0, vertex[0]);
        pol.setVertex(1, vertex[1]);
        pol.setVertexNormal(0, tile.getVertexNormal(0));
        pol.setVertexNormal(1, tile.getVertexNormal(1));
        PiVector f = new PiVector(n);
        f.m_data[0] = 0;
        f.m_data[n - 1] = 1;
        int i = 1;
        while (i < n - 1) {
            pol.setVertex(i + 1, vertex[i + 2]);
            pol.setVertexNormal(i + 1, tile.getVertexNormal(i + 2));
            ++i;
        }
        i = 1;
        while (i < n - 1) {
            f.m_data[i] = i + 1;
            ++i;
        }
        pol.setPolygon(0, f);
        return pol;
    }

    public void makeTorusMap(PgElementSet geom) {
        PdVector sum;
        PdVector Rdir;
        PdVector dir;
        geom.copy((PsObject)this.m_puPlanar.m_planar);
        geom.setName("3D");
        double a = m_a;
        double b = m_b;
        double scale = Math.tan(Math.PI / (double)m_p);
        double theta = Math.PI * 2 / (double)m_q;
        if (m_p == 6) {
            theta /= 2.0;
        }
        PdMatrix R = new PdMatrix(3);
        R.set((double[][])new double[][]{{Math.cos(theta), -Math.sin(theta), 0.0}, {Math.sin(theta), Math.cos(theta), 0.0}, {0.0, 0.0, 1.0}});
        a *= scale;
        if (m_b == 0 && m_p == 6) {
            dir = new PdVector(a, 0.0, 0.0);
            Rdir = new PdVector(3);
            Rdir.leftMultMatrix(R, dir);
            sum = PdVector.addNew((PdVector)dir, (PdVector)Rdir);
            a = sum.m_data[0];
            b = sum.m_data[1];
        }
        if (m_a == m_b) {
            if (m_p != 6) {
                dir = new PdVector(a, 0.0, 0.0);
                Rdir = new PdVector(3);
                Rdir.leftMultMatrix(R, dir);
                sum = PdVector.addNew((PdVector)dir, (PdVector)Rdir);
                a = sum.m_data[0];
                b = sum.m_data[1];
            } else {
                dir = new PdVector(a, 0.0, 0.0);
                Rdir = new PdVector(3);
                Rdir.leftMultMatrix(R, dir);
                PdVector dir1 = PdVector.addNew((PdVector)dir, (PdVector)Rdir);
                PdVector dir2 = new PdVector(3);
                dir2.leftMultMatrix(R, dir1);
                PdVector sum2 = PdVector.addNew((PdVector)dir1, (PdVector)dir2);
                a = sum2.m_data[0];
                b = sum2.m_data[1];
            }
        }
        PdVector v = new PdVector(3);
        R.set((double[][])new double[][]{{Math.cos(theta), -Math.sin(theta), 0.0}, {Math.sin(theta), Math.cos(theta), 0.0}, {0.0, 0.0, 1.0}});
        R.leftMultMatrix(v, new PdVector(a, b, 0.0));
        PdVector u = new PdVector(a, b, 0.0);
        PdVector w = new PdVector(1.0, 0.0, 0.0);
        PdVector z = new PdVector(0.0, 1.0, 0.0);
        PdMatrix SR = PuIsometry.mapXtoY(u, v, w, z);
        SR.multScalar(Math.PI * 2);
        PwPutGrid.refineGrid(geom);
        PdVector[] vertex = geom.getVertices();
        int nov = geom.getNumVertices();
        int i = 0;
        while (i < nov) {
            vertex[i].leftMultMatrix(SR);
            double t = vertex[i].m_data[0];
            double s = vertex[i].m_data[1];
            vertex[i].m_data[0] = (2.0 + Math.cos(t)) * Math.cos(s);
            vertex[i].m_data[1] = (2.0 + Math.cos(t)) * Math.sin(s);
            vertex[i].m_data[2] = Math.sin(t);
            ++i;
        }
        PgPolygonSet[] lines = new PgPolygonSet[]{m_OM, this.m_MN, m_NO};
        int j = 0;
        while (j < 3) {
            PwPutGrid.refinePolygonSet(lines[j], 10);
            PdVector[] polVert = lines[j].getVertices();
            int k = 0;
            while (k < lines[j].getNumVertices()) {
                polVert[k].leftMultMatrix(SR);
                double t = polVert[k].m_data[0];
                double s = polVert[k].m_data[1];
                polVert[k].m_data[0] = (2.0 + Math.cos(t)) * Math.cos(s);
                polVert[k].m_data[1] = (2.0 + Math.cos(t)) * Math.sin(s);
                polVert[k].m_data[2] = Math.sin(t);
                ++k;
            }
            ++j;
        }
        geom.makeVertexNormals();
    }

    public void makeLineOfTile() {
        switch (PuSpace.SPACE) {
            case 1: {
                this.makeLinesOfTilesSpherical(m_OM);
                this.makeLinesOfTilesSpherical(this.m_MN);
                this.makeLinesOfTilesSpherical(m_NO);
            }
        }
    }

    public void makeLinesOfTilesSpherical(PgPolygonSet pol) {
        PwPutGrid.refinePolygonSet(pol, 15);
        PdVector[] vertex = pol.getVertices();
        int nov = pol.getNumVertices();
        int newnov = nov + m_eltH.length * m_coset.length;
        int newnop = m_coset.length * m_eltH.length;
        pol.setNumVertices(newnov);
        pol.setNumPolygons(newnop);
        PdMatrix trans = new PdMatrix(3);
        int indv = 0;
        int inde = 0;
        boolean[] checked = new boolean[newnop + 1];
        int index = -1;
        int i = 0;
        while (i < m_coset.length) {
            int j = 0;
            while (j < m_eltH.length) {
                String inv = PuIsometry.getInverseStringElt(m_coset[i], "rst");
                String mov = String.valueOf(inv) + m_eltH[j];
                index = PuSubgroup.getIndexOfEltInG(mov, m_rRsSt, "rst", true);
                if (!checked[index]) {
                    PdVector[] rotVertex = new PdVector[nov];
                    trans = PuIsometry.getTrans(mov, m_rst, "rst");
                    int k = 0;
                    while (k < nov) {
                        rotVertex[k] = new PdVector(3);
                        PdVector vhomo = PdVector.copyNew((PdVector)vertex[k]);
                        trans.leftMultMatrix(rotVertex[k], vhomo);
                        ++k;
                    }
                    k = 0;
                    while (k < nov) {
                        pol.setVertex(indv, rotVertex[k]);
                        ++indv;
                        ++k;
                    }
                    PiVector tmp = PiVector.copyNew((PiVector)pol.getPolygon(0));
                    tmp.add(inde * nov);
                    pol.setPolygon(index, tmp);
                    checked[index] = true;
                    ++inde;
                }
                ++j;
            }
            ++i;
        }
    }

    private void defaultMeshView() {
        this.m_elementSet.showEdges(false);
        if (this.m_elementSet.isShowingSmoothLighting() && !this.m_elementSet.hasVertexNormals()) {
            this.m_elementSet.makeVertexNormals();
        }
        this.m_elementSet.showSmoothLighting(true);
        this.m_elementSet.showElementColors(true);
    }

    public void setDisplay(PvDisplayIf disp) {
        this.m_display = disp;
    }

    @Override
    public void show() {
        this.updateDisplay();
        if (this.m_tubeIsVisible) {
            this.showTube(this.m_tubeIsVisible);
        }
        this.m_puPlanar.setVisible(false);
    }

    @Override
    public void updateDisplay() {
        this.defaultMeshView();
        if (!this.m_display.containsGeometry((PgGeometryIf)this.m_elementSet)) {
            this.m_display.addGeometry((PgGeometryIf)this.m_elementSet);
        } else {
            this.m_elementSet.update((Object)this.m_elementSet);
        }
        this.m_display.selectCamera(0);
        this.setVisible(true);
        this.m_display.fit();
        this.m_display.update((Object)this.m_display);
    }

    public void makeSphericalMap(PgElementSet geom) {
        int nov = geom.getNumVertices();
        PdVector[] vertex = geom.getVertices();
        PuIsometry.setTriangle(vertex);
        PuIsometry.isSpherical2D(false);
        m_rst = PuIsometry.getIsometries();
        geom.getElement(0).setName("1");
        int newnov = nov * (m_eltG.length + 1);
        int newnoe = m_eltH.length * m_coset.length;
        geom.setNumVertices(newnov);
        geom.setNumElements(newnoe);
        PdMatrix trans = new PdMatrix(3);
        int indv = 0;
        boolean[] checked = new boolean[m_eltH.length * m_coset.length + 1];
        int index = -1;
        int i = 0;
        while (i < m_coset.length) {
            Color col = Color.getHSBColor((float)Math.asin((float)i / (float)m_coset.length), 0.4f, 1.0f);
            int j = 0;
            while (j < m_eltH.length) {
                String inv = PuIsometry.getInverseStringElt(m_coset[i], "rst");
                String mov = String.valueOf(inv) + m_eltH[j];
                index = PuSubgroup.getIndexOfEltInG(mov, m_rRsSt, "rst", true);
                if (!checked[index - 1]) {
                    PdVector[] rotVertex = new PdVector[nov];
                    trans = PuIsometry.getTrans(mov, m_rst, "rst");
                    int k = 0;
                    while (k < nov) {
                        rotVertex[k] = new PdVector(3);
                        PdVector vhomo = PdVector.copyNew((PdVector)vertex[k]);
                        trans.leftMultMatrix(rotVertex[k], vhomo);
                        ++k;
                    }
                    k = 0;
                    while (k < nov) {
                        geom.setVertex(indv, rotVertex[k]);
                        ++indv;
                        ++k;
                    }
                    PiVector tmp = PiVector.copyNew((PiVector)geom.getElement(0));
                    tmp.add((index - 1) * nov);
                    geom.setElement(index - 1, tmp);
                    geom.getElement(index - 1).setName(mov);
                    geom.setElementColor(index - 1, col);
                    checked[index - 1] = true;
                }
                ++j;
            }
            ++i;
        }
        PuCleanMesh.identifyVertices((PgPointSet)geom, (double)0.02);
        geom.makeNeighbour();
        PwCleanMesh.makeOrientation((PgElementSet)geom);
        geom.showElementColors(true);
    }

    public void makeTube() {
        int nop = m_eltG.length;
        PgPolygonSet[] NO = new PgPolygonSet[nop];
        int i = 0;
        while (i < nop) {
            NO[i] = Pu3Dmaps.getNO(m_tile[i]);
            ++i;
        }
        PgQuarterTube.setNeighbor(NO, Pu3Dmaps.getNeighbor());
        PgQuarterTube[] qt = new PgQuarterTube[m_eltG.length];
        int i2 = 0;
        while (i2 < m_eltG.length) {
            qt[i2] = new PgQuarterTube(NO[i2], i2);
            ++i2;
        }
        this.m_tube.copy((PsObject)qt[0].get3DQuarterTube());
        i2 = 0;
        while (i2 < this.m_tube.getNumElements()) {
            this.m_tube.setElementColor(i2, m_color[0]);
            ++i2;
        }
        int locnov = this.m_tube.getNumVertices();
        int locnoe = this.m_tube.getNumElements();
        int not = qt.length;
        this.m_tube.setNumVertices(not * locnov);
        this.m_tube.setNumElements(not * locnoe);
        PiVector[] neighbor = Pu3Dmaps.getNeighbor();
        boolean[] visited = new boolean[not];
        int[] generated = new int[not];
        int next = 1;
        visited[0] = true;
        generated[0] = 0;
        int m = 0;
        while (m < not) {
            PiVector nb = neighbor[generated[m]];
            int i3 = 0;
            while (i3 < 3) {
                if (!visited[nb.m_data[i3]]) {
                    PgElementSet nt = qt[nb.m_data[i3]].get3DQuarterTube();
                    int j = 0;
                    while (j < locnov) {
                        this.m_tube.setVertex(nb.m_data[i3] * locnov + j, nt.getVertex(j));
                        ++j;
                    }
                    j = 0;
                    while (j < locnoe) {
                        PiVector f = nt.getElement(j);
                        f.add(nb.m_data[i3] * locnov);
                        this.m_tube.setElement(nb.m_data[i3] * locnoe + j, f);
                        this.m_tube.setElementColor(nb.m_data[i3] * locnoe + j, nt.getElementColor(j));
                        this.m_tube.setElementColor(nb.m_data[i3] * locnoe + j, m_tile[nb.m_data[i3]].getElementColor(3));
                        ++j;
                    }
                    visited[nb.m_data[i3]] = true;
                    generated[next] = nb.m_data[i3];
                    if (next < generated.length - 1) {
                        ++next;
                    }
                }
                ++i3;
            }
            ++m;
        }
    }

    public void showTube(boolean isVisible) {
        this.makeTube();
        if (isVisible) {
            if (!this.m_display.containsGeometry((PgGeometryIf)this.m_tube)) {
                this.m_display.addGeometry((PgGeometryIf)this.m_tube);
            }
            this.setTubeVisible(true);
        } else {
            this.setTubeVisible(false);
        }
        if (!this.m_tube.isShowingElementColors()) {
            this.m_tube.makeVertexNormals();
            this.m_tube.showSmoothLighting(true);
            this.m_tube.showElementColors(true);
            this.m_tube.showEdges(false);
            this.m_tube.makeElementNormals();
        }
        this.m_tube.update((Object)this.m_tube);
        this.m_display.update((Object)this.m_display);
    }

    @Override
    public void setVisible(boolean flag) {
        this.m_elementSet.setVisible(flag);
        this.m_isVisible = flag;
        this.m_elementSet.update((Object)this.m_elementSet);
    }

    public void setTubeVisible(boolean flag) {
        this.m_tube.setVisible(flag);
        this.m_tubeIsVisible = flag;
        this.m_tube.update((Object)this.m_tube);
    }
}

