/*
 * Decompiled with CFR 0.152.
 */
package devRegularMap.functions;

import devRegularMap.number.PgyroEinVector;
import devRegularMap.vecmath.PuCompGeometry;
import devRegularMap.vecmath.PuHyperboloid;
import jv.geom.PgPolygonSet;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgGon
extends PgPolygonSet {
    private PiVector[] m_neighbor;
    private int m_start;

    public PgGon() {
        if (((Object)((Object)this)).getClass() == PgGon.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public void makeNeighbor() {
        int nop = super.getNumPolygons();
        this.m_neighbor = new PiVector[nop];
        int i = 0;
        while (i < nop) {
            this.m_neighbor[i] = new PiVector(3);
            ++i;
        }
        PiVector[] polygon = super.getPolygons();
        int i2 = 0;
        while (i2 < nop) {
            int vS = polygon[i2].m_data[0];
            int vE = polygon[i2].m_data[1];
            String s = polygon[i2].getName();
            int j = 0;
            while (j < nop) {
                if (i2 != j) {
                    int nvS = polygon[j].m_data[0];
                    int nvE = polygon[j].m_data[1];
                    String ns = polygon[j].getName();
                    if (vS == nvS || vS == nvE) {
                        this.m_neighbor[i2].m_data[0] = j;
                    }
                    if (vE == nvS || vE == nvE) {
                        this.m_neighbor[i2].m_data[1] = j;
                    }
                    if (s.equals(ns)) {
                        this.m_neighbor[i2].m_data[2] = j;
                    }
                }
                ++j;
            }
            ++i2;
        }
    }

    public void checkNeighbor() {
        int nop = super.getNumPolygons();
        int s = this.getStart();
        int e = -1;
        int i = 0;
        while (i < nop + 1) {
            e = this.followNextBy(i);
            ++i;
        }
        if (s == e) {
            PsDebug.message((String)"Neighbor is correct");
        }
    }

    public String getEdgeLabel(int i) {
        return super.getPolygon(i).getName();
    }

    public void relabel() {
        PiVector[] polygon = super.getPolygons();
        PiVector[] neighbor = this.getNeighbors();
        int nop = super.getNumPolygons();
        int a = 0;
        int ao = neighbor[a].m_data[2];
        int an = neighbor[a].m_data[1];
        String[] name = new String[nop];
        int i = 0;
        while (i < nop) {
            name[i] = "" + i;
            ++i;
        }
        boolean[] rename = new boolean[nop];
        polygon[a].setName(name[0]);
        polygon[ao].setName(name[0]);
        rename[a] = true;
        rename[ao] = true;
        int ind = 1;
        while (an != 0) {
            if (neighbor[an].m_data[1] == a) {
                a = an;
                an = neighbor[an].m_data[0];
            } else {
                a = an;
                an = neighbor[an].m_data[1];
            }
            if (rename[a]) continue;
            polygon[a].setName(name[ind]);
            polygon[neighbor[a].m_data[2]].setName(name[ind]);
            rename[a] = true;
            rename[neighbor[a].m_data[2]] = true;
            ++ind;
        }
    }

    public PiVector[] getNeighbors() {
        return this.m_neighbor;
    }

    public void setNeighbor(PiVector[] neighbor) {
        this.m_neighbor = new PiVector[neighbor.length];
        int i = 0;
        while (i < neighbor.length) {
            this.m_neighbor[i] = (PiVector)neighbor[i].clone();
            ++i;
        }
    }

    public int getLocIndVert(int a, int b) {
        int an = this.m_neighbor[a].m_data[1];
        if (b == an) {
            return 1;
        }
        return 0;
    }

    public int getNext(int a) {
        return this.m_neighbor[a].m_data[1];
    }

    public int getOpposite(int a) {
        return this.m_neighbor[a].m_data[2];
    }

    public int getPrev(int a) {
        return this.m_neighbor[a].m_data[0];
    }

    public PiVector getNeighbor(int a) {
        return this.m_neighbor[a];
    }

    public void setStart(int a) {
        this.m_start = a;
    }

    public int getStart() {
        return this.m_start;
    }

    public int flip(int a) {
        PiVector[] polygon = super.getPolygons();
        PiVector[] neighbor = this.getNeighbors();
        int ao = neighbor[a].m_data[2];
        int tmp = polygon[a].m_data[0];
        polygon[a].m_data[0] = polygon[a].m_data[1];
        polygon[a].m_data[1] = tmp;
        tmp = polygon[ao].m_data[0];
        polygon[ao].m_data[0] = polygon[ao].m_data[1];
        polygon[ao].m_data[1] = tmp;
        tmp = neighbor[a].m_data[0];
        neighbor[a].m_data[0] = neighbor[a].m_data[1];
        neighbor[a].m_data[1] = tmp;
        tmp = neighbor[ao].m_data[0];
        neighbor[ao].m_data[0] = neighbor[ao].m_data[1];
        neighbor[ao].m_data[1] = tmp;
        return a;
    }

    public boolean isEdgeOriented(int a) {
        PiVector[] neighbor = this.getNeighbors();
        int s = this.getStart();
        if (a == s) {
            return true;
        }
        int sn = neighbor[s].m_data[1];
        while (sn != a) {
            if (neighbor[sn].m_data[1] == s) {
                s = sn;
                sn = neighbor[sn].m_data[0];
                continue;
            }
            s = sn;
            sn = neighbor[sn].m_data[1];
        }
        int ind = this.getLocIndVert(a, s);
        return ind == 0;
    }

    public boolean hasSameOrientation(int a, int b) {
        this.setStart(a);
        return this.isEdgeOriented(b);
    }

    public int followNextBy(int step) {
        PiVector[] neighbor = this.getNeighbors();
        int s = this.getStart();
        int sn = neighbor[s].m_data[1];
        int i = 0;
        while (i < step) {
            if (neighbor[sn].m_data[1] == s) {
                s = sn;
                sn = neighbor[sn].m_data[0];
            } else {
                s = sn;
                sn = neighbor[sn].m_data[1];
            }
            ++i;
        }
        return s;
    }

    public int followNextBy(int s, int step) {
        PiVector[] neighbor = this.getNeighbors();
        int sn = neighbor[s].m_data[1];
        int i = 0;
        while (i < step) {
            if (neighbor[sn].m_data[1] == s) {
                s = sn;
                sn = neighbor[sn].m_data[0];
            } else {
                s = sn;
                sn = neighbor[sn].m_data[1];
            }
            ++i;
        }
        return s;
    }

    public int followPrevBy(int s, int step) {
        PiVector[] neighbor = this.getNeighbors();
        int sp = neighbor[s].m_data[0];
        int i = 0;
        while (i < step) {
            if (neighbor[sp].m_data[1] == s) {
                s = sp;
                sp = neighbor[sp].m_data[0];
            } else {
                s = sp;
                sp = neighbor[sp].m_data[1];
            }
            ++i;
        }
        return s;
    }

    public boolean scanPrev(int a) {
        int c = this.followPrevBy(a, 2);
        String la = super.getPolygon(a).getName();
        String lc = super.getPolygon(c).getName();
        return lc.equals(la);
    }

    public boolean scanNext(int a) {
        int c = this.followNextBy(a, 2);
        String la = super.getPolygon(a).getName();
        String lc = super.getPolygon(c).getName();
        return lc == la;
    }

    public void giveSameOrientation(int a, int b) {
        if (b != this.getNext(a)) {
            this.flip(a);
        }
        if (a != this.getPrev(b)) {
            this.flip(b);
        }
    }

    public boolean isccw() {
        PdVector x0 = new PdVector(1.0, 0.0, 0.0);
        int s = this.getStart();
        PdVector v0 = super.getVertex(super.getPolygon((int)s).m_data[0]);
        PdVector v1 = super.getVertex(super.getPolygon((int)s).m_data[1]);
        PdVector[] triangle = new PdVector[]{x0, v0, v1};
        return PuCompGeometry.ccw(triangle);
    }

    public boolean isNormalized(int a) {
        return this.scanNext(a) && this.scanNext(this.getNext(a)) || this.scanNext(a) && this.scanPrev(this.getNext(a)) || this.scanPrev(a) && this.scanPrev(this.getNext(a)) || this.scanPrev(a) && this.scanPrev(this.getPrev(a));
    }

    public void makeGlobalOrientation() {
        PiVector[] neighbor = this.getNeighbors();
        int nop = super.getNumPolygons();
        boolean[] oriented = new boolean[nop];
        int s = 0;
        this.setStart(0);
        if (!this.isNormalized(s)) {
            this.flip(s);
        }
        int so = neighbor[s].m_data[2];
        oriented[s] = true;
        oriented[so] = true;
        int i = 1;
        while (i < nop) {
            int a = this.followNextBy(i);
            int ao = this.getOpposite(a);
            if (!oriented[a]) {
                if (!this.isEdgeOriented(a)) {
                    this.flip(a);
                }
                oriented[a] = true;
                oriented[ao] = true;
            }
            ++i;
        }
    }

    public void makeLabels() {
        int nop = super.getNumPolygons();
        boolean[] checked = new boolean[nop];
        int i = 0;
        while (i < nop) {
            if (!checked[i]) {
                int io = this.getOpposite(i);
                super.getPolygon(i).setName("" + i);
                super.getPolygon(io).setName("" + i);
                checked[i] = true;
                checked[io] = true;
            }
            ++i;
        }
    }

    public PdMatrix getTrans(int a, int b) {
        PiVector[] polygon = super.getPolygons();
        PdVector[] vertex = super.getVertices();
        PdMatrix T1 = PuHyperboloid.mapToCoshCurve(vertex[polygon[a].m_data[0]], vertex[polygon[a].m_data[1]]);
        PdMatrix T2 = PuHyperboloid.mapToCoshCurve(vertex[polygon[b].m_data[0]], vertex[polygon[b].m_data[1]]);
        T2.invert();
        T1.leftMult(T2);
        return T1;
    }

    public String read() {
        String label = "";
        PiVector[] polygons = super.getPolygons();
        int nop = polygons.length;
        int i = 0;
        while (i < nop) {
            String a = polygons[this.followNextBy(i)].getName();
            label = a.length() == 2 ? String.valueOf(label) + "(" + a + ")" : String.valueOf(label) + a;
            ++i;
        }
        return label;
    }

    public PdVector[] getccwVertices() {
        PgGon g = this;
        int nop = g.getNumPolygons();
        int s = -1;
        if (!g.isccw()) {
            boolean[] fliped = new boolean[nop];
            int i = 0;
            while (i < nop) {
                s = g.followNextBy(i);
                if (!fliped[s]) {
                    g.flip(s);
                    fliped[s] = true;
                    fliped[g.getOpposite((int)s)] = true;
                }
                ++i;
            }
        }
        int nov = g.getNumVertices();
        PdVector[] vertex = g.getVertices();
        PdVector[] ordVertex = new PdVector[nov];
        PiVector[] polygon = g.getPolygons();
        boolean[] checked = new boolean[nov];
        int ind = 0;
        int i = 0;
        while (i < nov) {
            s = g.followNextBy(i);
            int v0 = polygon[s].m_data[0];
            int v1 = polygon[s].m_data[1];
            if (!checked[v0]) {
                ordVertex[ind] = vertex[v0];
                checked[v0] = true;
                ++ind;
            }
            if (!checked[v1]) {
                ordVertex[ind] = vertex[v1];
                checked[v1] = true;
                ++ind;
            }
            ++i;
        }
        return ordVertex;
    }

    public PdVector getGyroBarycenter() {
        int nov = this.getNumVertices();
        PdVector[] Kvertex = new PdVector[nov];
        int i = 0;
        while (i < nov) {
            Kvertex[i] = (PdVector)this.getVertex(i).clone();
            ++i;
        }
        PuHyperboloid.hyperboloidToKlein(Kvertex);
        double[] gamma = new double[nov];
        double sum = 0.0;
        PdVector gyroBary = new PdVector(3);
        int i2 = 0;
        while (i2 < nov) {
            gamma[i2] = PgyroEinVector.getGamma(Kvertex[i2]);
            ++i2;
        }
        i2 = 0;
        while (i2 < nov) {
            gyroBary.add(gamma[i2], Kvertex[i2]);
            sum += gamma[i2];
            ++i2;
        }
        gyroBary.multScalar(1.0 / sum);
        PuHyperboloid.kleinToHyperboloid(new PdVector[]{gyroBary});
        return gyroBary;
    }

    public void copyGon(PgGon gon) {
        this.copy((PsObject)gon);
        this.setNeighbor(gon.getNeighbors());
    }
}

