/*
 * Decompiled with CFR 0.152.
 */
package devRegularMap.functions;

import devRegularMap.functions.PgGon;
import devRegularMap.functions.PuPlanarMaps;
import devRegularMap.vecmath.PuCompGeometry;
import devRegularMap.vecmath.PuHyperboloid;
import devRegularMap.vecmath.PuIsometry;
import devRegularMap.vecmath.PuSpace;
import devRegularMap.vecmath.PuSubgroup;
import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PuCleanMesh;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometry;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgFourgGon
extends PuPlanarMaps {
    protected static PgGon m_rGon;
    protected static int m_start;

    public static PgGon compute4gGon(PgElementSet m_planar) {
        m_rGon = new PgGon();
        m_start = 0;
        m_rGon.setName("Label");
        PiVector[] neighbor = m_planar.getNeighbours();
        int noe = neighbor.length;
        int nobF = 0;
        int i = 0;
        while (i < noe) {
            if (neighbor[i].getIndexOf(-1) != -1) {
                ++nobF;
            }
            ++i;
        }
        m_rGon.setNumPolygons(nobF /= 2);
        m_rGon.setNumVertices(nobF);
        m_name = new String[nobF];
        i = 0;
        while (i < nobF) {
            PgFourgGon.m_name[i] = "" + i;
            ++i;
        }
        int nopgon = m_coset.length;
        String rep = "";
        String[] nb = new String[m_p];
        String s = "";
        int i2 = 0;
        while (i2 < m_p) {
            nb[i2] = s;
            s = String.valueOf(s) + "r";
            ++i2;
        }
        int index = -1;
        int indv = 0;
        int indp = 0;
        int inds = 0;
        boolean[] identified = new boolean[m_eltG.length];
        PdVector[] vertex = m_planar.getVertices();
        PiVector[] elt = m_planar.getElements();
        int i3 = 0;
        while (i3 < nopgon) {
            String inv = PuIsometry.getInverseStringElt(m_coset[i3], "rst");
            int j = 0;
            while (j < m_p) {
                rep = String.valueOf(inv) + nb[j];
                index = PuSubgroup.getIndexOfEltInG(rep, m_rRsSt, "rst", true);
                if (neighbor[index].m_data[0] == -1 && !identified[index]) {
                    PdVector N = vertex[elt[index].m_data[1]];
                    String nrep = String.valueOf(rep) + "rt";
                    System.out.println(nrep);
                    index = PuSubgroup.getIndexOfEltInG(nrep, m_rRsSt, "rst", true);
                    PdVector Nrt = vertex[elt[index].m_data[1]];
                    m_rGon.setVertex(indv, N);
                    m_rGon.setVertex(indv + 1, Nrt);
                    m_rGon.setPolygon(indp, indv, indv + 1);
                    m_rGon.getPolygon(indp).setName(m_name[inds]);
                    indv += 2;
                    ++indp;
                    nrep = String.valueOf(rep) + "rs";
                    index = PuSubgroup.getIndexOfEltInG(nrep, m_rRsSt, "rst", true);
                    identified[index] = true;
                    N = vertex[elt[index].m_data[1]];
                    nrep = String.valueOf(nrep) + "rt";
                    index = PuSubgroup.getIndexOfEltInG(nrep, m_rRsSt, "rst", true);
                    Nrt = vertex[elt[index].m_data[1]];
                    m_rGon.setVertex(indv, N);
                    m_rGon.setVertex(indv + 1, Nrt);
                    m_rGon.setPolygon(indp, indv + 1, indv);
                    m_rGon.getPolygon(indp).setName(m_name[inds]);
                    indv += 2;
                    ++indp;
                    ++inds;
                }
                ++j;
            }
            ++i3;
        }
        PiVector[] piVectorArray = m_rGon.getPolygons();
        int n = piVectorArray.length;
        int n2 = 0;
        while (n2 < n) {
            PiVector p = piVectorArray[n2];
            if (p.getSize() == 0) {
                p.setTag(2);
            }
            ++n2;
        }
        m_rGon.removeMarkedPolygons();
        PuCleanMesh.identifyVertices((PgPointSet)m_rGon, (double)0.01);
        m_rGon.makeNeighbor();
        return m_rGon;
    }

    public static void compute4gGon(PgElementSet hyper, PgElementSet eucl, PgGon cut) {
        int a;
        PiVector e_nbo;
        PiVector[] hyperNeighbor = hyper.getNeighbours();
        PiVector[] euclNeighbor = eucl.getNeighbours();
        PiVector boundElt = new PiVector();
        PiVector coneElt = new PiVector();
        int i = 0;
        while (i < hyper.getNumElements()) {
            PiVector nb = hyperNeighbor[i];
            int count = 0;
            int[] nArray = nb.m_data;
            int n = nb.m_data.length;
            int n2 = 0;
            while (n2 < n) {
                int j = nArray[n2];
                if (j == -1) {
                    ++count;
                }
                ++n2;
            }
            if (count == 2) {
                coneElt.addEntry(i);
            } else if (count == 1) {
                boundElt.addEntry(i);
            }
            ++i;
        }
        int nobE = boundElt.getSize();
        int nocE = coneElt.getSize();
        int nop = 2 * (nobE + nocE);
        cut.setNumPolygons(nop);
        cut.setNumVertices(nop);
        String[] name = new String[nop];
        int i2 = 0;
        while (i2 < nop) {
            name[i2] = "" + i2;
            ++i2;
        }
        PdVector[] vertex = hyper.getVertices();
        PiVector[] face = hyper.getElements();
        int noe = hyper.getNumElements();
        boolean[] visited = new boolean[noe];
        int indv = 0;
        int indp = 0;
        int inds = 0;
        int[] nArray = boundElt.m_data;
        int n = boundElt.m_data.length;
        int n3 = 0;
        while (n3 < n) {
            int elt = nArray[n3];
            if (!visited[elt]) {
                PiVector h_nb = hyperNeighbor[elt];
                PiVector e_nb = euclNeighbor[elt];
                int aux = h_nb.getIndexOf(-1);
                PdVector N = vertex[face[elt].m_data[(aux + 1) % 3]];
                PdVector Nn = vertex[face[elt].m_data[(aux + 2) % 3]];
                cut.setVertex(indv, N);
                cut.setVertex(indv + 1, Nn);
                cut.setPolygon(indp, indv, indv + 1);
                cut.getPolygon(indp).setName(name[inds]);
                indv += 2;
                ++indp;
                int indelto = e_nb.m_data[aux];
                e_nbo = euclNeighbor[indelto];
                a = e_nbo.getIndexOf(elt);
                N = vertex[face[indelto].m_data[(a + 2) % 3]];
                Nn = vertex[face[indelto].m_data[(a + 1) % 3]];
                cut.setVertex(indv, N);
                cut.setVertex(indv + 1, Nn);
                cut.setPolygon(indp, indv, indv + 1);
                cut.getPolygon(indp).setName(name[inds]);
                indv += 2;
                ++indp;
                ++inds;
                visited[indelto] = true;
                visited[elt] = true;
            }
            ++n3;
        }
        boolean[][] cornerVisited = new boolean[noe][3];
        Object[] objectArray = coneElt.m_data;
        int n4 = coneElt.m_data.length;
        n = 0;
        while (n < n4) {
            int elt = objectArray[n];
            int i3 = 0;
            while (i3 < 3) {
                int inda = hyperNeighbor[elt].m_data[i3];
                if (inda == -1) {
                    int nb_inda = euclNeighbor[elt].m_data[i3];
                    if (visited[nb_inda]) {
                        cornerVisited[elt][i3] = true;
                    } else if (!cornerVisited[elt][i3]) {
                        PdVector N = vertex[face[elt].m_data[(i3 + 1) % 3]];
                        PdVector Nn = vertex[face[elt].m_data[(i3 + 2) % 3]];
                        cut.setVertex(indv, N);
                        cut.setVertex(indv + 1, Nn);
                        cut.setPolygon(indp, indv, indv + 1);
                        cut.getPolygon(indp).setName(name[inds]);
                        indv += 2;
                        ++indp;
                        e_nbo = euclNeighbor[nb_inda];
                        a = e_nbo.getIndexOf(elt);
                        N = vertex[face[nb_inda].m_data[(a + 2) % 3]];
                        Nn = vertex[face[nb_inda].m_data[(a + 1) % 3]];
                        cut.setVertex(indv, N);
                        cut.setVertex(indv + 1, Nn);
                        cut.setPolygon(indp, indv, indv + 1);
                        cut.getPolygon(indp).setName(name[inds]);
                        cornerVisited[nb_inda][a] = true;
                        cornerVisited[elt][i3] = true;
                        indv += 2;
                        ++indp;
                        ++inds;
                    }
                }
                ++i3;
            }
            ++n;
        }
        PiVector[] piVectorArray = cut.getPolygons();
        objectArray = piVectorArray;
        n4 = piVectorArray.length;
        n = 0;
        while (n < n4) {
            int p = objectArray[n];
            if (p.getSize() == 0) {
                p.setTag(2);
            }
            ++n;
        }
        cut.removeMarkedPolygons();
        PuCleanMesh.identifyVertices((PgPointSet)cut, (double)1.0E-6);
        cut.makeNeighbor();
    }

    public static PgGon get4gGon() {
        return m_rGon;
    }

    public static int multPol() {
        int cur = 0;
        boolean found = false;
        Color[] col = m_rGon.getVertexColors();
        int nop = m_rGon.getNumPolygons();
        while (!found) {
            PiVector start = m_rGon.getPolygon(cur);
            if (col[start.m_data[0]] == col[0] && col[start.m_data[1]] != col[0] || col[start.m_data[1]] == col[0] && col[start.m_data[0]] != col[0]) {
                found = true;
            } else {
                ++cur;
            }
            if (cur > nop - 1) break;
        }
        if (found) {
            return cur;
        }
        return -1;
    }

    public static int multPolNew(PgGon gon) {
        int cur = 0;
        boolean found = false;
        Color[] col = gon.getVertexColors();
        int nop = gon.getNumPolygons();
        while (!found) {
            PiVector start = gon.getPolygon(cur);
            if (col[start.m_data[0]] == col[0] && col[start.m_data[1]] != col[0] || col[start.m_data[1]] == col[0] && col[start.m_data[0]] != col[0]) {
                found = true;
            } else {
                ++cur;
            }
            if (cur > nop - 1) break;
        }
        if (found) {
            return cur;
        }
        return -1;
    }

    public static int multPol(PgGon gon) {
        int cur = 0;
        boolean found = false;
        Color[] col = gon.getVertexColors();
        int nop = gon.getNumPolygons();
        while (!found) {
            PiVector start = gon.getPolygon(cur);
            if (col[start.m_data[0]] == col[0] && col[start.m_data[1]] != col[0] || col[start.m_data[1]] == col[0] && col[start.m_data[0]] != col[0]) {
                found = true;
            } else {
                ++cur;
            }
            if (cur > nop - 1) break;
        }
        if (found) {
            return cur;
        }
        return -1;
    }

    public static void computeIvertices(PgGon gon) {
        int nop = gon.getNumPolygons();
        int nov = gon.getNumVertices();
        PiVector[] polygon = gon.getPolygons();
        Color[] col = new Color[nov];
        int[] number = new int[nov];
        int i = 0;
        while (i < nov) {
            col[i] = new Color((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0));
            ++i;
        }
        PiVector[] neighbor = gon.getNeighbors();
        boolean[] visited = new boolean[nov];
        boolean[] visitedPol = new boolean[nop];
        int indCol = 0;
        boolean back = false;
        int[] process = new int[nop];
        process[0] = 0;
        int next = 1;
        int i2 = 0;
        while (i2 < nop) {
            int cnext;
            PiVector cpol = polygon[process[i2]];
            int j = 0;
            while (j < 2) {
                int v = cpol.m_data[j];
                if (!visited[v]) {
                    gon.setVertexColor(v, col[indCol]);
                    number[v] = indCol;
                    visited[v] = true;
                    back = false;
                    int s = j;
                    int cur = process[i2];
                    int start = v;
                    while (!back) {
                        cnext = neighbor[cur].m_data[s];
                        int opp = neighbor[cnext].m_data[2];
                        int ind = neighbor[cnext].getIndexOf(cur);
                        if (ind == 0) {
                            v = polygon[opp].m_data[0];
                            s = 0;
                        } else {
                            v = polygon[opp].m_data[1];
                            s = 1;
                        }
                        visited[v] = true;
                        gon.setVertexColor(v, col[indCol]);
                        number[v] = indCol;
                        cur = opp;
                        if (v != start) continue;
                        back = true;
                    }
                    ++indCol;
                }
                ++j;
            }
            visitedPol[process[i2]] = true;
            if (next < nov - 1) {
                cnext = neighbor[process[i2]].m_data[1];
                int cprev = neighbor[process[i2]].m_data[0];
                if (!visitedPol[cnext]) {
                    process[next] = cnext;
                    ++next;
                }
                if (!visitedPol[cprev]) {
                    process[next] = cprev;
                    ++next;
                }
            }
            ++i2;
        }
    }

    public static PgGon computeIvertices() {
        int nop = m_rGon.getNumPolygons();
        int nov = m_rGon.getNumVertices();
        PiVector[] polygon = m_rGon.getPolygons();
        m_col = new Color[nov];
        m_number = new int[nov];
        int i = 0;
        while (i < nov) {
            PgFourgGon.m_col[i] = new Color((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0));
            ++i;
        }
        PiVector[] neighbor = m_rGon.getNeighbors();
        boolean[] visited = new boolean[nov];
        boolean[] visitedPol = new boolean[nop];
        int indCol = 0;
        boolean back = false;
        int[] process = new int[nop];
        process[0] = 0;
        int next = 1;
        int i2 = 0;
        while (i2 < nop) {
            int cnext;
            PiVector cpol = polygon[process[i2]];
            int j = 0;
            while (j < 2) {
                int v = cpol.m_data[j];
                if (!visited[v]) {
                    m_rGon.setVertexColor(v, m_col[indCol]);
                    PgFourgGon.m_number[v] = indCol;
                    visited[v] = true;
                    back = false;
                    int s = j;
                    int cur = process[i2];
                    int start = v;
                    while (!back) {
                        cnext = neighbor[cur].m_data[s];
                        int opp = neighbor[cnext].m_data[2];
                        int ind = neighbor[cnext].getIndexOf(cur);
                        if (ind == 0) {
                            v = polygon[opp].m_data[0];
                            s = 0;
                        } else {
                            v = polygon[opp].m_data[1];
                            s = 1;
                        }
                        visited[v] = true;
                        m_rGon.setVertexColor(v, m_col[indCol]);
                        PgFourgGon.m_number[v] = indCol;
                        cur = opp;
                        if (v != start) continue;
                        back = true;
                    }
                    ++indCol;
                }
                ++j;
            }
            visitedPol[process[i2]] = true;
            if (next < nov - 1) {
                cnext = neighbor[process[i2]].m_data[1];
                int cprev = neighbor[process[i2]].m_data[0];
                if (!visitedPol[cnext]) {
                    process[next] = cnext;
                    ++next;
                }
                if (!visitedPol[cprev]) {
                    process[next] = cprev;
                    ++next;
                }
            }
            ++i2;
        }
        return m_rGon;
    }

    public static void coloreIvertices(PgGon gon) {
        int nop = gon.getNumPolygons();
        int nov = gon.getNumVertices();
        PiVector[] polygon = gon.getPolygons();
        Color[] col = new Color[nov];
        int[] number = new int[nov];
        int i = 0;
        while (i < nov) {
            col[i] = new Color((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0));
            ++i;
        }
        PiVector[] neighbor = gon.getNeighbors();
        boolean[] visited = new boolean[nov];
        boolean[] visitedPol = new boolean[nop];
        int indCol = 0;
        boolean back = false;
        int[] process = new int[nop];
        process[0] = 0;
        int next = 1;
        int i2 = 0;
        while (i2 < nop) {
            int cnext;
            PiVector cpol = polygon[process[i2]];
            int j = 0;
            while (j < 2) {
                int v = cpol.m_data[j];
                if (!visited[v]) {
                    gon.setVertexColor(v, col[indCol]);
                    number[v] = indCol;
                    visited[v] = true;
                    back = false;
                    int s = j;
                    int cur = process[i2];
                    int start = v;
                    while (!back) {
                        cnext = neighbor[cur].m_data[s];
                        int opp = neighbor[cnext].m_data[2];
                        int ind = neighbor[cnext].getIndexOf(cur);
                        if (ind == 0) {
                            v = polygon[opp].m_data[0];
                            s = 0;
                        } else {
                            v = polygon[opp].m_data[1];
                            s = 1;
                        }
                        visited[v] = true;
                        gon.setVertexColor(v, col[indCol]);
                        number[v] = indCol;
                        cur = opp;
                        if (v != start) continue;
                        back = true;
                    }
                    ++indCol;
                }
                ++j;
            }
            visitedPol[process[i2]] = true;
            if (next < nov - 1) {
                cnext = neighbor[process[i2]].m_data[1];
                int cprev = neighbor[process[i2]].m_data[0];
                if (!visitedPol[cnext]) {
                    process[next] = cnext;
                    ++next;
                }
                if (!visitedPol[cprev]) {
                    process[next] = cprev;
                    ++next;
                }
            }
            ++i2;
        }
    }

    public static void computeIverticesNew(PgGon gon) {
        int nop = gon.getNumPolygons();
        int nov = gon.getNumVertices();
        PiVector[] polygon = gon.getPolygons();
        Color[] col = new Color[nov];
        int[] number = new int[nov];
        int i = 0;
        while (i < nov) {
            col[i] = new Color((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0));
            ++i;
        }
        PiVector[] neighbor = gon.getNeighbors();
        boolean[] visited = new boolean[nov];
        boolean[] visitedPol = new boolean[nop];
        int indCol = 0;
        boolean back = false;
        int[] process = new int[nop];
        process[0] = 0;
        int next = 1;
        int i2 = 0;
        while (i2 < nop) {
            int cnext;
            PiVector cpol = polygon[process[i2]];
            int j = 0;
            while (j < 2) {
                int v = cpol.m_data[j];
                if (!visited[v]) {
                    gon.setVertexColor(v, col[indCol]);
                    number[v] = indCol;
                    visited[v] = true;
                    back = false;
                    int s = j;
                    int cur = process[i2];
                    int start = v;
                    while (!back) {
                        cnext = neighbor[cur].m_data[s];
                        int opp = neighbor[cnext].m_data[2];
                        int ind = neighbor[cnext].getIndexOf(cur);
                        if (ind == 0) {
                            v = polygon[opp].m_data[0];
                            s = 0;
                        } else {
                            v = polygon[opp].m_data[1];
                            s = 1;
                        }
                        visited[v] = true;
                        gon.setVertexColor(v, col[indCol]);
                        number[v] = indCol;
                        cur = opp;
                        if (v != start) continue;
                        back = true;
                    }
                    ++indCol;
                }
                ++j;
            }
            visitedPol[process[i2]] = true;
            if (next < nov - 1) {
                cnext = neighbor[process[i2]].m_data[1];
                int cprev = neighbor[process[i2]].m_data[0];
                if (!visitedPol[cnext]) {
                    process[next] = cnext;
                    ++next;
                }
                if (!visitedPol[cprev]) {
                    process[next] = cprev;
                    ++next;
                }
            }
            ++i2;
        }
    }

    public static PgGon reductionStep() {
        PiVector[] polygon = m_rGon.getPolygons();
        PiVector[] neighbor = m_rGon.getNeighbors();
        int cur = PgFourgGon.multPol();
        PsDebug.message((String)(" " + cur));
        if (cur == -1) {
            PsDebug.message((String)"The reduction is finished");
        } else {
            int cp = neighbor[cur].m_data[0];
            int cn = neighbor[cur].m_data[1];
            int co = neighbor[cur].m_data[2];
            int con = neighbor[co].m_data[1];
            int cop = neighbor[co].m_data[0];
            if (polygon[cn].getName().equals(polygon[con].getName()) && co != cn && cn != con) {
                PgFourgGon.reduce1(cur);
            } else if (polygon[cp].getName().equals(polygon[cop].getName()) && co != cp && cp != cop) {
                int tmp = polygon[cur].m_data[0];
                polygon[cur].m_data[0] = polygon[cur].m_data[1];
                polygon[cur].m_data[1] = tmp;
                tmp = polygon[co].m_data[0];
                polygon[co].m_data[0] = polygon[co].m_data[1];
                polygon[co].m_data[1] = tmp;
                tmp = neighbor[cur].m_data[0];
                neighbor[cur].m_data[0] = neighbor[cur].m_data[1];
                neighbor[cur].m_data[1] = tmp;
                tmp = neighbor[co].m_data[0];
                neighbor[co].m_data[0] = neighbor[co].m_data[1];
                neighbor[co].m_data[1] = tmp;
                PgFourgGon.reduce1(cur);
            } else {
                switch (PuSpace.SPACE) {
                    case -1: {
                        PgFourgGon.reduce2(cur);
                        break;
                    }
                }
            }
        }
        m_rGon.removeMarkedPolygons();
        m_rGon.removeUnusedVertices();
        return m_rGon;
    }

    public static void reductionStep(PgGon gon) {
        PiVector[] polygon = gon.getPolygons();
        PiVector[] neighbor = gon.getNeighbors();
        int cur = PgFourgGon.multPolNew(gon);
        if (cur == -1) {
            PsDebug.message((String)"The reduction is finished");
        } else {
            int cp = neighbor[cur].m_data[0];
            int cn = neighbor[cur].m_data[1];
            int co = neighbor[cur].m_data[2];
            int con = neighbor[co].m_data[1];
            int cop = neighbor[co].m_data[0];
            if (polygon[cn].getName().equals(polygon[con].getName()) && co != cn && cn != con) {
                PgFourgGon.reduce1(cur, gon);
            } else if (polygon[cp].getName().equals(polygon[cop].getName()) && co != cp && cp != cop) {
                int tmp = polygon[cur].m_data[0];
                polygon[cur].m_data[0] = polygon[cur].m_data[1];
                polygon[cur].m_data[1] = tmp;
                tmp = polygon[co].m_data[0];
                polygon[co].m_data[0] = polygon[co].m_data[1];
                polygon[co].m_data[1] = tmp;
                tmp = neighbor[cur].m_data[0];
                neighbor[cur].m_data[0] = neighbor[cur].m_data[1];
                neighbor[cur].m_data[1] = tmp;
                tmp = neighbor[co].m_data[0];
                neighbor[co].m_data[0] = neighbor[co].m_data[1];
                neighbor[co].m_data[1] = tmp;
                PgFourgGon.reduce1(cur, gon);
            } else {
                PgFourgGon.reduce2(cur, gon);
            }
        }
        gon.removeMarkedPolygons();
        gon.removeUnusedVertices();
    }

    public static void reduction(PgGon gon) {
        int cur = PgFourgGon.multPol(gon);
        while (cur != -1) {
            PiVector[] polygon = gon.getPolygons();
            PiVector[] neighbor = gon.getNeighbors();
            int cp = neighbor[cur].m_data[0];
            int cn = neighbor[cur].m_data[1];
            int co = neighbor[cur].m_data[2];
            int con = neighbor[co].m_data[1];
            int cop = neighbor[co].m_data[0];
            if (polygon[cn].getName().equals(polygon[con].getName()) && co != cn && cn != con) {
                PgFourgGon.reduce1(cur, gon);
            } else if (polygon[cp].getName().equals(polygon[cop].getName()) && co != cp && cp != cop) {
                int tmp = polygon[cur].m_data[0];
                polygon[cur].m_data[0] = polygon[cur].m_data[1];
                polygon[cur].m_data[1] = tmp;
                tmp = polygon[co].m_data[0];
                polygon[co].m_data[0] = polygon[co].m_data[1];
                polygon[co].m_data[1] = tmp;
                tmp = neighbor[cur].m_data[0];
                neighbor[cur].m_data[0] = neighbor[cur].m_data[1];
                neighbor[cur].m_data[1] = tmp;
                tmp = neighbor[co].m_data[0];
                neighbor[co].m_data[0] = neighbor[co].m_data[1];
                neighbor[co].m_data[1] = tmp;
                PgFourgGon.reduce1(cur, gon);
            } else {
                PgFourgGon.reduce2(cur, gon);
            }
            cur = PgFourgGon.multPol(gon);
        }
    }

    public static PgGon reduction() {
        int cur = PgFourgGon.multPol();
        while (cur != -1) {
            PiVector[] polygon = m_rGon.getPolygons();
            PiVector[] neighbor = m_rGon.getNeighbors();
            int cp = neighbor[cur].m_data[0];
            int cn = neighbor[cur].m_data[1];
            int co = neighbor[cur].m_data[2];
            int con = neighbor[co].m_data[1];
            int cop = neighbor[co].m_data[0];
            if (polygon[cn].getName().equals(polygon[con].getName()) && co != cn && cn != con) {
                PgFourgGon.reduce1(cur);
            } else if (polygon[cp].getName().equals(polygon[cop].getName()) && co != cp && cp != cop) {
                int tmp = polygon[cur].m_data[0];
                polygon[cur].m_data[0] = polygon[cur].m_data[1];
                polygon[cur].m_data[1] = tmp;
                tmp = polygon[co].m_data[0];
                polygon[co].m_data[0] = polygon[co].m_data[1];
                polygon[co].m_data[1] = tmp;
                tmp = neighbor[cur].m_data[0];
                neighbor[cur].m_data[0] = neighbor[cur].m_data[1];
                neighbor[cur].m_data[1] = tmp;
                tmp = neighbor[co].m_data[0];
                neighbor[co].m_data[0] = neighbor[co].m_data[1];
                neighbor[co].m_data[1] = tmp;
                PgFourgGon.reduce1(cur);
            } else {
                switch (PuSpace.SPACE) {
                    case -1: {
                        PgFourgGon.reduce2(cur);
                        break;
                    }
                }
            }
            cur = PgFourgGon.multPol();
        }
        return m_rGon;
    }

    public static void reduce1(int a) {
        PiVector[] polygon = m_rGon.getPolygons();
        PiVector[] neighbor = m_rGon.getNeighbors();
        int an = neighbor[a].m_data[1];
        int ao = neighbor[a].m_data[2];
        int ann = neighbor[an].m_data[1];
        int aon = neighbor[ao].m_data[1];
        int aonn = neighbor[aon].m_data[1];
        int ind = (m_rGon.getLocIndVert(an, a) + 1) % 2;
        polygon[a].m_data[1] = polygon[an].m_data[ind];
        polygon[ao].m_data[1] = polygon[aon].m_data[ind];
        neighbor[a].m_data[1] = ann;
        ind = m_rGon.getLocIndVert(ann, an);
        neighbor[ann].m_data[ind] = a;
        neighbor[ao].m_data[1] = aonn;
        ind = m_rGon.getLocIndVert(aonn, aon);
        neighbor[aonn].m_data[ind] = ao;
        polygon[an].setTag(2);
        polygon[aon].setTag(2);
        m_rGon.removeMarkedPolygons();
        m_rGon.removeUnusedVertices();
        m_rGon.makeNeighbor();
    }

    public static void reduce1(int a, PgGon gon) {
        PiVector[] polygon = gon.getPolygons();
        PiVector[] neighbor = gon.getNeighbors();
        int an = neighbor[a].m_data[1];
        int ao = neighbor[a].m_data[2];
        int ann = neighbor[an].m_data[1];
        int aon = neighbor[ao].m_data[1];
        int aonn = neighbor[aon].m_data[1];
        int ind = (gon.getLocIndVert(an, a) + 1) % 2;
        polygon[a].m_data[1] = polygon[an].m_data[ind];
        polygon[ao].m_data[1] = polygon[aon].m_data[ind];
        neighbor[a].m_data[1] = ann;
        ind = gon.getLocIndVert(ann, an);
        neighbor[ann].m_data[ind] = a;
        neighbor[ao].m_data[1] = aonn;
        ind = gon.getLocIndVert(aonn, aon);
        neighbor[aonn].m_data[ind] = ao;
        polygon[an].setTag(2);
        polygon[aon].setTag(2);
        gon.removeMarkedPolygons();
        gon.removeUnusedVertices();
        gon.makeNeighbor();
    }

    public static void reduce2(int a) {
        int nov = m_rGon.getNumVertices();
        PiVector[] neighbor = m_rGon.getNeighbors();
        m_rGon.setNumVertices(nov + 1);
        int an = neighbor[a].m_data[1];
        int ind = m_rGon.getLocIndVert(an, a);
        PgFourgGon.cutAndPaste(a, 0, an, (ind + 1) % 2, an, m_rGon.getOpposite(an));
    }

    public static void reduce2(int a, PgGon gon) {
        int nov = gon.getNumVertices();
        PiVector[] neighbor = gon.getNeighbors();
        gon.setNumVertices(nov + 1);
        int an = neighbor[a].m_data[1];
        int ind = gon.getLocIndVert(an, a);
        PgFourgGon.cutAndPaste(a, 0, an, (ind + 1) % 2, an, gon.getOpposite(an), gon);
    }

    public static PgGon normalization() {
        PgGon test = new PgGon();
        while (PgFourgGon.normalizationStep1(test)) {
            PgFourgGon.normalizationStep2(test);
        }
        return m_rGon;
    }

    public static void normalization(PgGon gon) {
        PgGon test = new PgGon();
        while (PgFourgGon.normalizationStep1(test, gon)) {
            PgFourgGon.normalizationStep2(test, gon);
        }
    }

    public static boolean normalizationStep1(PgGon g, PgGon gon) {
        PiVector alternateInd = new PiVector(2);
        if (PgFourgGon.searchForAlternateLabel(alternateInd, gon)) {
            int a = alternateInd.m_data[0];
            int b = alternateInd.m_data[1];
            int bo = gon.getOpposite(b);
            int ao = gon.getOpposite(a);
            if (gon.scanPrev(a)) {
                gon.giveSameOrientation(ao, gon.getPrev(a));
                gon.setStart(gon.getOpposite(a));
            } else if (gon.scanNext(a)) {
                gon.giveSameOrientation(a, gon.getNext(a));
                gon.setStart(a);
            } else {
                PdVector O = new PdVector(1.0, 0.0, 0.0);
                PgFourgGon.cutAndPaste(a, 1, ao, 1, b, bo, O);
                gon.setStart(a);
            }
        } else {
            PsDebug.message((String)"Normalization is finished");
            g.copy((PsObject)gon);
            return false;
        }
        g.copy((PsObject)gon);
        return true;
    }

    public static boolean normalizationStep1(PgGon g) {
        PiVector alternateInd = new PiVector(2);
        if (PgFourgGon.searchForAlternateLabel(alternateInd)) {
            int a = alternateInd.m_data[0];
            int b = alternateInd.m_data[1];
            int bo = m_rGon.getOpposite(b);
            int ao = m_rGon.getOpposite(a);
            PsDebug.message((String)("Start at " + a));
            if (m_rGon.scanPrev(a)) {
                m_rGon.giveSameOrientation(ao, m_rGon.getPrev(a));
                m_rGon.setStart(m_rGon.getOpposite(a));
            } else if (m_rGon.scanNext(a)) {
                m_rGon.giveSameOrientation(a, m_rGon.getNext(a));
                m_rGon.setStart(a);
            } else {
                PdVector O = new PdVector(1.0, 0.0, 0.0);
                PgFourgGon.cutAndPaste(a, 1, ao, 1, b, bo, O);
                m_rGon.setStart(a);
            }
        } else {
            PsDebug.message((String)"Normalization is finished");
            g.copy((PsObject)m_rGon);
            return false;
        }
        PsDebug.message((String)m_rGon.read());
        g.copy((PsObject)m_rGon);
        return true;
    }

    public static boolean searchForAlternateLabel(PiVector alt) {
        PiVector[] neighbor = m_rGon.getNeighbors();
        PiVector[] polygon = m_rGon.getPolygons();
        int nop = m_rGon.getNumVertices();
        int i = 0;
        while (i < nop) {
            boolean found = false;
            int c = i;
            int cn = m_rGon.getNext(c);
            if (!polygon[c].hasTag(0)) {
                int ind = 0;
                int a = c;
                int an = cn;
                while (!found && ind < nop) {
                    if (neighbor[an].m_data[1] == a) {
                        a = an;
                        an = neighbor[an].m_data[0];
                    } else {
                        a = an;
                        an = neighbor[an].m_data[1];
                    }
                    if (!polygon[a].hasTag(0)) {
                        found = PgFourgGon.check(c, a);
                    }
                    ++ind;
                }
                if (found) {
                    alt.m_data[0] = c;
                    alt.m_data[1] = a;
                    PsDebug.message((String)(String.valueOf(c) + "," + a));
                    polygon[c].setTag(0);
                    polygon[a].setTag(0);
                    polygon[neighbor[c].m_data[2]].setTag(0);
                    polygon[neighbor[a].m_data[2]].setTag(0);
                    return !m_rGon.isNormalized(c);
                }
            }
            ++i;
        }
        return false;
    }

    public static boolean searchForAlternateLabel(PiVector alt, PgGon gon) {
        PiVector[] neighbor = gon.getNeighbors();
        PiVector[] polygon = gon.getPolygons();
        int nop = gon.getNumVertices();
        int i = 0;
        while (i < nop) {
            boolean found = false;
            int c = i;
            int cn = gon.getNext(c);
            if (!polygon[c].hasTag(0)) {
                int ind = 0;
                int a = c;
                int an = cn;
                while (!found && ind < nop) {
                    if (neighbor[an].m_data[1] == a) {
                        a = an;
                        an = neighbor[an].m_data[0];
                    } else {
                        a = an;
                        an = neighbor[an].m_data[1];
                    }
                    if (!polygon[a].hasTag(0)) {
                        found = PgFourgGon.checkNew(c, a, gon);
                    }
                    ++ind;
                }
                if (found) {
                    alt.m_data[0] = c;
                    alt.m_data[1] = a;
                    polygon[c].setTag(0);
                    polygon[a].setTag(0);
                    polygon[neighbor[c].m_data[2]].setTag(0);
                    polygon[neighbor[a].m_data[2]].setTag(0);
                    return !gon.isNormalized(c);
                }
            }
            ++i;
        }
        return false;
    }

    public static boolean normalizationStep2(PgGon g) {
        int a = m_rGon.getStart();
        int ao = m_rGon.getOpposite(a);
        int b = m_rGon.getNext(a);
        int bo = m_rGon.getOpposite(b);
        PdVector O = new PdVector(1.0, 0.0, 0.0);
        if (!m_rGon.isNormalized(a)) {
            PgFourgGon.cutAndPaste(b, 1, bo, 1, ao, a, O, m_rGon);
        }
        g.copy((PsObject)m_rGon);
        return true;
    }

    public static boolean normalizationStep2(PgGon g, PgGon gon) {
        int a = gon.getStart();
        int ao = gon.getOpposite(a);
        int b = gon.getNext(a);
        int bo = gon.getOpposite(b);
        PdVector O = new PdVector(1.0, 0.0, 0.0);
        if (!gon.isNormalized(a)) {
            PgFourgGon.cutAndPaste(b, 1, bo, 1, ao, a, O, gon);
        }
        g.copy((PsObject)gon);
        return true;
    }

    public static boolean asureOrientation(PgGon g) {
        int a = g.getStart();
        int ind = 1;
        while (!g.scanNext(a)) {
            a = g.followNextBy(ind);
            ++ind;
        }
        g.setStart(a);
        int nop = g.getNumPolygons();
        boolean[] flipped = new boolean[nop];
        int i = 1;
        while (i < nop) {
            int b = g.followNextBy(i);
            if (i % 2 == 0 && g.hasSameOrientation(a, b) && !flipped[b]) {
                g.flip(b);
                flipped[b] = true;
                flipped[g.getOpposite((int)b)] = true;
            } else if (i % 2 != 0 && !g.hasSameOrientation(a, b) && !flipped[b]) {
                g.flip(b);
                flipped[b] = true;
                flipped[g.getOpposite((int)b)] = true;
            }
            ++i;
        }
        return true;
    }

    public static boolean check(int a, int b, PgGon g) {
        int nop = g.getNumPolygons();
        int ao = g.getOpposite(a);
        int bo = g.getOpposite(b);
        int[] index = new int[nop];
        int i = 0;
        while (i < nop) {
            index[i] = 0;
            ++i;
        }
        index[a] = 1;
        index[ao] = 1;
        index[b] = 1;
        index[bo] = 1;
        int count = 0;
        int ind = 0;
        int org = a;
        while (a != ao) {
            a = g.followNextBy(org, ind);
            count += index[a];
            if (++ind <= 100) continue;
            System.err.println("Check does not return, check neighbor");
            return false;
        }
        return count == 3;
    }

    public static boolean check(int a, int b) {
        int nop = m_rGon.getNumPolygons();
        int ao = m_rGon.getOpposite(a);
        int bo = m_rGon.getOpposite(b);
        int[] index = new int[nop];
        int i = 0;
        while (i < nop) {
            index[i] = 0;
            ++i;
        }
        index[a] = 1;
        index[ao] = 1;
        index[b] = 1;
        index[bo] = 1;
        int count = 0;
        int ind = 0;
        int org = a;
        while (a != ao) {
            a = m_rGon.followNextBy(org, ind);
            count += index[a];
            if (++ind <= 100) continue;
            System.err.println("Check does not return, check neighbor");
            return false;
        }
        return count == 3;
    }

    public static boolean checkNew(int a, int b, PgGon gon) {
        int nop = gon.getNumPolygons();
        int ao = gon.getOpposite(a);
        int bo = gon.getOpposite(b);
        int[] index = new int[nop];
        int i = 0;
        while (i < nop) {
            index[i] = 0;
            ++i;
        }
        index[a] = 1;
        index[ao] = 1;
        index[b] = 1;
        index[bo] = 1;
        int count = 0;
        int ind = 0;
        int org = a;
        while (a != ao) {
            a = gon.followNextBy(org, ind);
            count += index[a];
            if (++ind <= 100) continue;
            System.err.println("Check does not return, check neighbor");
            return false;
        }
        return count == 3;
    }

    public static void regularize(PgGon g) {
        g.makeNeighbor();
        double radius = 1.0;
        int nov = g.getNumVertices();
        PdVector[] regVertex = new PdVector[nov];
        int i = 0;
        while (i < nov) {
            regVertex[i] = new PdVector(3);
            ++i;
        }
        regVertex[0] = new PdVector(Math.cosh(radius), Math.sinh(radius), 0.0);
        PdMatrix r = new PdMatrix(3);
        int i2 = 1;
        while (i2 < nov) {
            double alpha = (double)(2 * i2) * Math.PI / (double)(4 * m_g);
            PuHyperboloid.rotateAroundPoint(r, new PdVector(1.0, 0.0, 0.0), alpha);
            r.leftMultMatrix(regVertex[i2], regVertex[0]);
            ++i2;
        }
        PiVector[] polygon = g.getPolygons();
        PiVector[] neighbor = g.getNeighbors();
        PdVector[] vertex = g.getVertices();
        boolean[] mooved = new boolean[nov];
        int a = 0;
        int an = neighbor[0].m_data[1];
        int ind = 0;
        while (an != 0) {
            if (!mooved[polygon[a].m_data[0]]) {
                vertex[polygon[a].m_data[0]].copy(regVertex[ind]);
                mooved[polygon[a].m_data[0]] = true;
                ++ind;
            }
            if (!mooved[polygon[a].m_data[1]]) {
                vertex[polygon[a].m_data[1]].copy(regVertex[ind]);
                mooved[polygon[a].m_data[1]] = true;
                ++ind;
            }
            if (neighbor[an].m_data[1] == a) {
                a = an;
                an = neighbor[an].m_data[0];
                continue;
            }
            a = an;
            an = neighbor[an].m_data[1];
        }
    }

    public static PgGon symmetricNormalizedStep1() {
        m_rGon.makeGlobalOrientation();
        int start = m_rGon.getStart();
        int l_4 = m_rGon.followNextBy(4);
        int l_1 = m_rGon.followNextBy(1);
        PgFourgGon.cutAndPaste(l_1, 1, l_4, 1, l_4);
        m_rGon.setStart(start);
        return m_rGon;
    }

    public static PgGon symmetricNormalizedStep2() {
        int start = m_rGon.getStart();
        int l_3 = m_rGon.followNextBy(3);
        int l_3o = m_rGon.getOpposite(l_3);
        int l_3n = m_rGon.getNext(l_3);
        PgFourgGon.cutAndPaste(l_3o, 0, l_3n, 0, l_3o);
        m_rGon.setStart(start);
        return m_rGon;
    }

    public static PgGon symmetricNormalized() {
        m_rGon.makeGlobalOrientation();
        int start = m_rGon.getStart();
        int l_4 = m_rGon.followNextBy(4);
        int l_1 = m_rGon.followNextBy(1);
        PgFourgGon.cutAndPaste(l_1, 1, l_4, 1, l_4);
        m_rGon.setStart(start);
        int l_3 = m_rGon.followNextBy(3);
        int l_3o = m_rGon.getOpposite(l_3);
        int l_3n = m_rGon.getNext(l_3);
        PgFourgGon.cutAndPaste(l_3o, 0, l_3n, 0, l_3o);
        m_rGon.setStart(start);
        l_3 = m_rGon.followNextBy(3);
        l_3o = m_rGon.getOpposite(l_3);
        int l_3op = m_rGon.getPrev(l_3o);
        PgFourgGon.cutAndPaste(l_3, 1, l_3op, 1, l_3op);
        int l_5 = m_rGon.followNextBy(5);
        int l_5o = m_rGon.getOpposite(l_5);
        int l_5n = m_rGon.getNext(l_5);
        PgFourgGon.cutAndPaste(l_5o, 0, l_5n, 0, l_5o);
        return m_rGon;
    }

    public static PgGon cutAndPaste(int a, int b, int c) {
        m_rGon.setStart(a);
        if (m_rGon.isEdgeOriented(b)) {
            m_rGon.flip(b);
        }
        if (!m_rGon.isEdgeOriented(c)) {
            m_rGon.flip(c);
        }
        PiVector[] polygon = m_rGon.getPolygons();
        PiVector[] neighbor = m_rGon.getNeighbors();
        PdVector v1 = (PdVector)m_rGon.getVertex(polygon[a].m_data[1]).clone();
        PdVector v2 = (PdVector)m_rGon.getVertex(polygon[b].m_data[1]).clone();
        int nov = m_rGon.getNumVertices();
        m_rGon.setNumVertices(nov + 2);
        m_rGon.setVertex(nov, v1);
        m_rGon.setVertex(nov + 1, v2);
        m_rGon.setVertexColor(nov, m_rGon.getVertexColor(0));
        m_rGon.setVertexColor(nov + 1, m_rGon.getVertexColor(0));
        int an = neighbor[a].m_data[1];
        int bn = neighbor[b].m_data[1];
        int cn = neighbor[c].m_data[1];
        int ind = m_rGon.getLocIndVert(an, a);
        polygon[an].m_data[ind] = nov;
        ind = m_rGon.getLocIndVert(bn, b);
        polygon[bn].m_data[ind] = nov + 1;
        PdVector[] vertex = m_rGon.getVertices();
        int co = neighbor[c].m_data[2];
        PdMatrix T1 = PuHyperboloid.mapToCoshCurve(vertex[polygon[c].m_data[0]], vertex[polygon[c].m_data[1]]);
        PdMatrix T2 = PuHyperboloid.mapToCoshCurve(vertex[polygon[co].m_data[0]], vertex[polygon[co].m_data[1]]);
        T2.invert();
        T1.leftMult(T2);
        PiVector pol = PgFourgGon.getComponent(a, b);
        int len = pol.getSize();
        boolean[] checked = new boolean[nov + 2];
        int i = 0;
        while (i < len) {
            PiVector cPol = polygon[pol.m_data[i]];
            int j = 0;
            while (j < 2) {
                if (!checked[cPol.m_data[j]]) {
                    vertex[cPol.m_data[j]].leftMultMatrix(T1);
                    checked[cPol.m_data[j]] = true;
                }
                ++j;
            }
            ++i;
        }
        if (c == an) {
            ind = m_rGon.getLocIndVert(cn, c);
            polygon[cn].m_data[ind] = polygon[co].m_data[1];
            polygon[c].m_data[0] = polygon[a].m_data[1];
            polygon[c].m_data[1] = polygon[PgFourgGon.m_rGon.getOpposite((int)a)].m_data[1];
            polygon[co].m_data[0] = polygon[co].m_data[0];
            polygon[co].m_data[1] = nov + 1;
        } else {
            int cp = neighbor[c].m_data[0];
            ind = m_rGon.getLocIndVert(cp, c);
        }
        m_rGon.removeUnusedVertices();
        m_rGon.makeNeighbor();
        return m_rGon;
    }

    public static void cut(int a, int inda, int b, int indb) {
        PiVector[] polygon = m_rGon.getPolygons();
        PdVector v1 = (PdVector)m_rGon.getVertex(polygon[a].m_data[inda]).clone();
        PdVector v2 = (PdVector)m_rGon.getVertex(polygon[b].m_data[indb]).clone();
        int nov = m_rGon.getNumVertices();
        int nop = m_rGon.getNumPolygons();
        m_rGon.setNumVertices(nov + 2);
        m_rGon.setVertex(nov, v1);
        m_rGon.setVertex(nov + 1, v2);
        m_rGon.setVertexColor(nov, m_rGon.getVertexColor(polygon[a].m_data[inda]));
        m_rGon.setVertexColor(nov + 1, m_rGon.getVertexColor(polygon[b].m_data[indb]));
        PiVector newc = new PiVector(2);
        PiVector newco = new PiVector(2);
        newc.m_data[0] = polygon[a].m_data[inda];
        newc.m_data[1] = polygon[b].m_data[indb];
        newco.m_data[0] = nov;
        newco.m_data[1] = nov + 1;
        m_rGon.setNumPolygons(nop + 2);
        m_rGon.setPolygon(nop, newc);
        m_rGon.setPolygon(nop + 1, newco);
        m_rGon.getPolygon(nop).setName("-1");
        m_rGon.getPolygon(nop + 1).setName("-1");
        boolean orient = m_rGon.hasSameOrientation(a, b);
        int ind = -1;
        int bn = m_rGon.getNext(b);
        int an = m_rGon.getNext(a);
        int bp = m_rGon.getPrev(b);
        int ap = m_rGon.getPrev(a);
        if (!orient) {
            if (indb == inda) {
                if (indb == 0) {
                    ind = m_rGon.getLocIndVert(ap, a);
                    polygon[ap].m_data[ind] = nov;
                    ind = m_rGon.getLocIndVert(bp, b);
                    polygon[bp].m_data[ind] = nov + 1;
                } else if (indb == 1) {
                    ind = m_rGon.getLocIndVert(bn, b);
                    polygon[bn].m_data[ind] = nov + 1;
                    ind = m_rGon.getLocIndVert(an, a);
                    polygon[an].m_data[ind] = nov;
                }
            } else if (indb != inda) {
                if (indb == 0 && inda == 1) {
                    ind = m_rGon.getLocIndVert(an, a);
                    polygon[an].m_data[ind] = nov;
                    polygon[b].m_data[ind] = nov + 1;
                } else if (indb == 1 && inda == 0) {
                    polygon[a].m_data[ind] = nov;
                    ind = m_rGon.getLocIndVert(bn, b);
                    polygon[bn].m_data[ind] = nov + 1;
                }
            }
        } else if (indb == inda) {
            if (indb == 0) {
                polygon[a].m_data[ind] = nov;
                ind = m_rGon.getLocIndVert(bp, b);
                polygon[bp].m_data[ind] = nov + 1;
            } else if (indb == 1) {
                ind = m_rGon.getLocIndVert(an, a);
                polygon[an].m_data[ind] = nov;
                polygon[b].m_data[ind] = nov + 1;
            }
        } else if (indb != inda) {
            if (indb == 0 && inda == 1) {
                ind = m_rGon.getLocIndVert(an, a);
                polygon[an].m_data[ind] = nov;
                ind = m_rGon.getLocIndVert(bp, b);
                polygon[bp].m_data[ind] = nov + 1;
            } else if (indb == 1 && inda == 0) {
                ind = m_rGon.getLocIndVert(ap, a);
                polygon[ap].m_data[ind] = nov;
                ind = m_rGon.getLocIndVert(bn, b);
                polygon[bn].m_data[ind] = nov + 1;
            }
        }
        m_rGon.makeNeighbor();
    }

    public static void cut(int a, int inda, int b, int indb, PgGon gon) {
        PiVector[] polygon = gon.getPolygons();
        PdVector v1 = (PdVector)gon.getVertex(polygon[a].m_data[inda]).clone();
        PdVector v2 = (PdVector)gon.getVertex(polygon[b].m_data[indb]).clone();
        int nov = gon.getNumVertices();
        int nop = gon.getNumPolygons();
        gon.setNumVertices(nov + 2);
        gon.setVertex(nov, v1);
        gon.setVertex(nov + 1, v2);
        gon.setVertexColor(nov, gon.getVertexColor(polygon[a].m_data[inda]));
        gon.setVertexColor(nov + 1, gon.getVertexColor(polygon[b].m_data[indb]));
        PiVector newc = new PiVector(2);
        PiVector newco = new PiVector(2);
        newc.m_data[0] = polygon[a].m_data[inda];
        newc.m_data[1] = polygon[b].m_data[indb];
        newco.m_data[0] = nov;
        newco.m_data[1] = nov + 1;
        gon.setNumPolygons(nop + 2);
        gon.setPolygon(nop, newc);
        gon.setPolygon(nop + 1, newco);
        gon.getPolygon(nop).setName("-1");
        gon.getPolygon(nop + 1).setName("-1");
        boolean orient = gon.hasSameOrientation(a, b);
        int ind = -1;
        int bn = gon.getNext(b);
        int an = gon.getNext(a);
        int bp = gon.getPrev(b);
        int ap = gon.getPrev(a);
        if (!orient) {
            if (indb == inda) {
                if (indb == 0) {
                    ind = gon.getLocIndVert(ap, a);
                    polygon[ap].m_data[ind] = nov;
                    ind = gon.getLocIndVert(bp, b);
                    polygon[bp].m_data[ind] = nov + 1;
                } else if (indb == 1) {
                    ind = gon.getLocIndVert(bn, b);
                    polygon[bn].m_data[ind] = nov + 1;
                    ind = gon.getLocIndVert(an, a);
                    polygon[an].m_data[ind] = nov;
                }
            } else if (indb != inda) {
                if (indb == 0 && inda == 1) {
                    ind = gon.getLocIndVert(an, a);
                    polygon[an].m_data[ind] = nov;
                    polygon[b].m_data[ind] = nov + 1;
                } else if (indb == 1 && inda == 0) {
                    polygon[a].m_data[ind] = nov;
                    ind = gon.getLocIndVert(bn, b);
                    polygon[bn].m_data[ind] = nov + 1;
                }
            }
        } else if (indb == inda) {
            if (indb == 0) {
                polygon[a].m_data[ind] = nov;
                ind = gon.getLocIndVert(bp, b);
                polygon[bp].m_data[ind] = nov + 1;
            } else if (indb == 1) {
                ind = gon.getLocIndVert(an, a);
                polygon[an].m_data[ind] = nov;
                polygon[b].m_data[ind] = nov + 1;
            }
        } else if (indb != inda) {
            if (indb == 0 && inda == 1) {
                ind = gon.getLocIndVert(an, a);
                polygon[an].m_data[ind] = nov;
                ind = gon.getLocIndVert(bp, b);
                polygon[bp].m_data[ind] = nov + 1;
            } else if (indb == 1 && inda == 0) {
                ind = gon.getLocIndVert(ap, a);
                polygon[ap].m_data[ind] = nov;
                ind = gon.getLocIndVert(bn, b);
                polygon[bn].m_data[ind] = nov + 1;
            }
        }
        gon.makeNeighbor();
    }

    public static void paste(int c, int d) {
        if (PgFourgGon.isInSameComponent(c, d)) {
            PsDebug.message((String)"The two polygons are in the same component");
        } else {
            PiVector[] polygon = m_rGon.getPolygons();
            PdVector[] vertex = m_rGon.getVertices();
            int nov = m_rGon.getNumVertices();
            PdMatrix T1 = PuHyperboloid.mapToCoshCurve(vertex[polygon[c].m_data[0]], vertex[polygon[c].m_data[1]]);
            PdMatrix T2 = PuHyperboloid.mapToCoshCurve(vertex[polygon[d].m_data[0]], vertex[polygon[d].m_data[1]]);
            T2.invert();
            T1.leftMult(T2);
            PiVector pol = PgFourgGon.getComponent(c, m_rGon.getPrev(c));
            int len = pol.getSize();
            boolean[] checked = new boolean[nov];
            int i = 0;
            while (i < len) {
                PiVector cPol = m_rGon.getPolygon(pol.m_data[i]);
                int j = 0;
                while (j < 2) {
                    if (!checked[cPol.m_data[j]]) {
                        vertex[cPol.m_data[j]].leftMultMatrix(T1);
                        checked[cPol.m_data[j]] = true;
                    }
                    ++j;
                }
                ++i;
            }
            int cp = m_rGon.getPrev(c);
            int cn = m_rGon.getNext(c);
            polygon = m_rGon.getPolygons();
            int ind = m_rGon.getLocIndVert(cp, c);
            polygon[cp].m_data[ind] = polygon[d].m_data[0];
            ind = m_rGon.getLocIndVert(cn, c);
            polygon[cn].m_data[ind] = polygon[d].m_data[1];
            m_rGon.getPolygon(c).setTag(2);
            m_rGon.getPolygon(d).setTag(2);
            String label = m_rGon.getPolygon(c).getName();
            PiVector[] piVectorArray = m_rGon.getPolygons();
            int n = piVectorArray.length;
            int n2 = 0;
            while (n2 < n) {
                PiVector p = piVectorArray[n2];
                if (p.getName() == "-1") {
                    p.setName(label);
                }
                ++n2;
            }
            m_rGon.removeMarkedPolygons();
            m_rGon.setStart(0);
            m_rGon.makeNeighbor();
            m_rGon.removeUnusedVertices();
        }
    }

    public static void paste(int c, int d, PgGon gon) {
        if (PgFourgGon.isInSameComponent(c, d, gon)) {
            PsDebug.message((String)"The two polygons are in the same component");
        } else {
            PiVector[] polygon = gon.getPolygons();
            PdVector[] vertex = gon.getVertices();
            int nov = gon.getNumVertices();
            PdMatrix T1 = PuHyperboloid.mapToCoshCurve(vertex[polygon[c].m_data[0]], vertex[polygon[c].m_data[1]]);
            PdMatrix T2 = PuHyperboloid.mapToCoshCurve(vertex[polygon[d].m_data[0]], vertex[polygon[d].m_data[1]]);
            T2.invert();
            T1.leftMult(T2);
            PiVector pol = PgFourgGon.getComponent(c, gon.getPrev(c), gon);
            int len = pol.getSize();
            boolean[] checked = new boolean[nov];
            int i = 0;
            while (i < len) {
                PiVector cPol = gon.getPolygon(pol.m_data[i]);
                int j = 0;
                while (j < 2) {
                    if (!checked[cPol.m_data[j]]) {
                        vertex[cPol.m_data[j]].leftMultMatrix(T1);
                        checked[cPol.m_data[j]] = true;
                    }
                    ++j;
                }
                ++i;
            }
            int cp = gon.getPrev(c);
            int cn = gon.getNext(c);
            polygon = gon.getPolygons();
            int ind = gon.getLocIndVert(cp, c);
            polygon[cp].m_data[ind] = polygon[d].m_data[0];
            ind = gon.getLocIndVert(cn, c);
            polygon[cn].m_data[ind] = polygon[d].m_data[1];
            gon.getPolygon(c).setTag(2);
            gon.getPolygon(d).setTag(2);
            String label = gon.getPolygon(c).getName();
            PiVector[] piVectorArray = gon.getPolygons();
            int n = piVectorArray.length;
            int n2 = 0;
            while (n2 < n) {
                PiVector p = piVectorArray[n2];
                if (p.getName() == "-1") {
                    p.setName(label);
                }
                ++n2;
            }
            gon.removeMarkedPolygons();
            gon.setStart(0);
            gon.makeNeighbor();
            gon.removeUnusedVertices();
        }
    }

    public static boolean isInSameComponent(int c, int d) {
        int cur = -1;
        int ind = 1;
        while (cur != c) {
            cur = m_rGon.followNextBy(c, ind);
            if (cur == d) {
                return true;
            }
            ++ind;
        }
        return false;
    }

    public static boolean isInSameComponent(int c, int d, PgGon gon) {
        int cur = -1;
        int ind = 1;
        while (cur != c) {
            cur = gon.followNextBy(c, ind);
            if (cur == d) {
                return true;
            }
            ++ind;
        }
        return false;
    }

    public static void cutAndPaste(int a, int inda, int b, int indb, int c, int d) {
        PgFourgGon.cut(a, inda, b, indb);
        PgFourgGon.paste(c, d);
    }

    public static void cutAndPaste(int a, int inda, int b, int indb, int c, int d, PgGon gon) {
        PgFourgGon.cut(a, inda, b, indb, gon);
        PgFourgGon.paste(c, d, gon);
    }

    public static void cutAndPaste(int a, int inda, int b, int indb, int c, int d, PdVector v) {
        PgFourgGon.cut(a, inda, b, indb);
        PiVector c_comp = PgFourgGon.getComponent(c, m_rGon.getPrev(c));
        if (PgFourgGon.isPointInsideComponent(v, c_comp)) {
            PgFourgGon.paste(d, c);
        } else {
            PgFourgGon.paste(c, d);
        }
    }

    public static void cutAndPaste(int a, int inda, int b, int indb, int c, int d, PdVector v, PgGon gon) {
        PgFourgGon.cut(a, inda, b, indb, gon);
        PiVector c_comp = PgFourgGon.getComponent(c, gon.getPrev(c), gon);
        if (PgFourgGon.isPointInsideComponent(v, c_comp, gon)) {
            PgFourgGon.paste(d, c, gon);
        } else {
            PgFourgGon.paste(c, d, gon);
        }
    }

    public static boolean isPointInsideComponent(PdVector v, PiVector comp) {
        int nov = comp.getSize();
        PdVector[] pos = new PdVector[nov];
        PiVector[] pol = m_rGon.getPolygons();
        boolean[] check = new boolean[m_rGon.getNumVertices()];
        int ind = 0;
        int i = 0;
        while (i < nov) {
            int j = 0;
            while (j < 2) {
                int indVert = pol[comp.m_data[i]].m_data[j];
                if (!check[indVert]) {
                    pos[ind] = m_rGon.getVertex(indVert);
                    check[indVert] = true;
                    ++ind;
                }
                ++j;
            }
            ++i;
        }
        PuCompGeometry.checkCCW(pos);
        return PuCompGeometry.isInsidePolygon(v, pos, true);
    }

    public static boolean isPointInsideComponent(PdVector v, PiVector comp, PgGon gon) {
        int nov = comp.getSize();
        PdVector[] pos = new PdVector[nov];
        PiVector[] pol = gon.getPolygons();
        boolean[] check = new boolean[gon.getNumVertices()];
        int ind = 0;
        int i = 0;
        while (i < nov) {
            int j = 0;
            while (j < 2) {
                int indVert = pol[comp.m_data[i]].m_data[j];
                if (!check[indVert]) {
                    pos[ind] = gon.getVertex(indVert);
                    check[indVert] = true;
                    ++ind;
                }
                ++j;
            }
            ++i;
        }
        PuCompGeometry.checkCCW(pos);
        return PuCompGeometry.isInsidePolygon(v, pos, true);
    }

    public static void cutAndPaste(int a, int inda, int b, int indb, int c) {
        PiVector[] polygon = m_rGon.getPolygons();
        String name = polygon[c].getName();
        PdVector v1 = (PdVector)m_rGon.getVertex(polygon[a].m_data[inda]).clone();
        PdVector v2 = (PdVector)m_rGon.getVertex(polygon[b].m_data[indb]).clone();
        int nov = m_rGon.getNumVertices();
        int nop = m_rGon.getNumPolygons();
        m_rGon.setNumVertices(nov + 2);
        m_rGon.setVertex(nov, v1);
        m_rGon.setVertex(nov + 1, v2);
        m_rGon.setVertexColor(nov, m_rGon.getVertexColor(0));
        m_rGon.setVertexColor(nov + 1, m_rGon.getVertexColor(0));
        PiVector newc = new PiVector(2);
        PiVector newco = new PiVector(2);
        newc.m_data[0] = polygon[a].m_data[inda];
        newc.m_data[1] = polygon[b].m_data[indb];
        newco.m_data[0] = nov;
        newco.m_data[1] = nov + 1;
        m_rGon.setNumPolygons(nop + 2);
        m_rGon.setPolygon(nop, newc);
        m_rGon.setPolygon(nop + 1, newco);
        m_rGon.getPolygon(nop).setName("new");
        m_rGon.getPolygon(nop + 1).setName("new");
        boolean orient = m_rGon.hasSameOrientation(a, b);
        int ind = -1;
        int bn = m_rGon.getNext(b);
        int an = m_rGon.getNext(a);
        int bp = m_rGon.getPrev(b);
        int ap = m_rGon.getPrev(a);
        if (!orient) {
            if (indb == inda) {
                if (indb == 0) {
                    ind = m_rGon.getLocIndVert(bp, b);
                    polygon[bp].m_data[ind] = nov + 1;
                    ind = m_rGon.getLocIndVert(ap, a);
                    polygon[ap].m_data[ind] = nov;
                } else if (indb == 1) {
                    ind = m_rGon.getLocIndVert(bn, b);
                    polygon[bn].m_data[ind] = nov + 1;
                    ind = m_rGon.getLocIndVert(an, a);
                    polygon[an].m_data[ind] = nov;
                }
            } else if (indb != inda) {
                if (indb == 0 && inda == 1) {
                    polygon[b].m_data[0] = nov + 1;
                    ind = m_rGon.getLocIndVert(an, a);
                    polygon[an].m_data[ind] = nov;
                } else if (indb == 1 && inda == 0) {
                    polygon[a].m_data[0] = nov;
                    ind = m_rGon.getLocIndVert(bn, b);
                    polygon[bn].m_data[ind] = nov + 1;
                }
            }
        } else if (indb == inda) {
            if (indb == 0) {
                polygon[a].m_data[0] = nov;
                ind = m_rGon.getLocIndVert(bp, b);
                polygon[bp].m_data[ind] = nov + 1;
            } else if (indb == 1) {
                ind = m_rGon.getLocIndVert(an, a);
                polygon[an].m_data[ind] = nov;
                polygon[b].m_data[1] = nov + 1;
            }
        } else if (indb != inda) {
            if (indb == 0 && inda == 1) {
                ind = m_rGon.getLocIndVert(bp, b);
                polygon[bp].m_data[ind] = nov + 1;
                ind = m_rGon.getLocIndVert(an, a);
                polygon[an].m_data[ind] = nov;
            } else if (indb == 1 && inda == 0) {
                polygon[a].m_data[0] = nov;
                ind = m_rGon.getLocIndVert(bn, b);
                polygon[bn].m_data[ind] = nov + 1;
            }
        }
        m_rGon.makeNeighbor();
        PdVector[] vertex = m_rGon.getVertices();
        int co = m_rGon.getOpposite(c);
        PdMatrix T1 = PuHyperboloid.mapToCoshCurve(vertex[polygon[c].m_data[0]], vertex[polygon[c].m_data[1]]);
        PdMatrix T2 = PuHyperboloid.mapToCoshCurve(vertex[polygon[co].m_data[0]], vertex[polygon[co].m_data[1]]);
        T2.invert();
        T1.leftMult(T2);
        PiVector pol = PgFourgGon.getComponent(nop + 1, nop + 1);
        pol.addEntry(nop + 1);
        int len = pol.getSize();
        boolean[] checked = new boolean[nov + 2];
        int i = 0;
        while (i < len) {
            PiVector cPol = m_rGon.getPolygon(pol.m_data[i]);
            int j = 0;
            while (j < 2) {
                if (!checked[cPol.m_data[j]]) {
                    vertex[cPol.m_data[j]].leftMultMatrix(T1);
                    checked[cPol.m_data[j]] = true;
                }
                ++j;
            }
            ++i;
        }
        int cp = m_rGon.getPrev(c);
        int cn = m_rGon.getNext(c);
        polygon = m_rGon.getPolygons();
        ind = m_rGon.getLocIndVert(cp, c);
        polygon[cp].m_data[ind] = polygon[co].m_data[0];
        ind = m_rGon.getLocIndVert(cn, c);
        polygon[cn].m_data[ind] = polygon[co].m_data[1];
        polygon[nop].setName(name);
        polygon[nop + 1].setName(name);
        m_rGon.getPolygon(c).setTag(2);
        m_rGon.getPolygon(co).setTag(2);
        m_rGon.removeMarkedPolygons();
        m_rGon.setStart(0);
        m_rGon.makeNeighbor();
        m_rGon.removeUnusedVertices();
    }

    public static PiVector getComponent(int a, int b) {
        PiVector pol = new PiVector();
        pol.addEntry(a);
        m_rGon.setStart(a);
        int an = m_rGon.getNext(a);
        int ind = 1;
        while (an != b) {
            an = m_rGon.followNextBy(ind);
            pol.addEntry(an);
            ++ind;
        }
        return pol;
    }

    public static PiVector getComponent(int a, int b, PgGon gon) {
        PiVector pol = new PiVector();
        pol.addEntry(a);
        gon.setStart(a);
        int an = gon.getNext(a);
        int ind = 1;
        while (an != b) {
            an = gon.followNextBy(ind);
            pol.addEntry(an);
            ++ind;
        }
        return pol;
    }

    public static PgGon symPointToOrigin() {
        PdVector ao_vs;
        PdVector a_vs;
        int ao;
        PdVector[] vertex = m_rGon.getVertices();
        PiVector[] polygon = m_rGon.getPolygons();
        int nov = m_rGon.getNumVertices();
        int a = m_rGon.getStart();
        boolean oriented = m_rGon.hasSameOrientation(a, ao = m_rGon.followNextBy(2 * m_g - 1));
        if (oriented) {
            a_vs = vertex[polygon[a].m_data[0]];
            ao_vs = vertex[polygon[ao].m_data[0]];
        } else {
            a_vs = vertex[polygon[a].m_data[0]];
            ao_vs = vertex[polygon[ao].m_data[1]];
        }
        PdVector mid = PuHyperboloid.getMidPoint(a_vs, ao_vs);
        PdMatrix m = new PdMatrix(3);
        PuHyperboloid.translateToOrigin(m, mid);
        int i = 0;
        while (i < nov) {
            vertex[i].leftMultMatrix(m);
            ++i;
        }
        return m_rGon;
    }

    public static PgGon makeGlobalOrientation() {
        m_rGon.makeGlobalOrientation();
        return m_rGon;
    }

    public static PgElementSet triangulate(PgGon g) {
        PgElementSet tri = new PgElementSet(3);
        PdVector bar = g.getGyroBarycenter();
        PdVector[] ordVertex = g.getccwVertices();
        int numVert = ordVertex.length;
        tri.setNumVertices(numVert + 1);
        tri.setNumElements(numVert);
        tri.setVertex(numVert, bar);
        int i = 0;
        while (i < numVert) {
            tri.setVertex(i, ordVertex[i]);
            ++i;
        }
        i = 0;
        while (i < numVert) {
            tri.setElement(i, numVert, i, (i + 1) % numVert);
            ++i;
        }
        return tri;
    }

    public static void cover(PgElementSet hyper, PgGon cut) {
        int j;
        int end;
        int start;
        if (!PuHyperboloid.isHyperboloid((PgGeometry)hyper)) {
            PuHyperboloid.kleinToHyperboloid(hyper.getVertices());
            PuHyperboloid.kleinToHyperboloid(cut.getVertices());
        }
        int nop = cut.getNumPolygons();
        int index = 0;
        PdVector[] vertex = hyper.getVertices();
        PdVector[] pvertex = cut.getccwVertices();
        PiVector[] polygon = cut.getPolygons();
        PdVector[] cvertex = cut.getVertices();
        PiVector[] interPol = new PiVector[nop];
        int i = 0;
        while (i < nop) {
            interPol[i] = new PiVector();
            ++i;
        }
        PiVector[] piVectorArray = hyper.getElements();
        int n = piVectorArray.length;
        int n2 = 0;
        while (n2 < n) {
            PiVector e = piVectorArray[n2];
            PdVector[] pos = new PdVector[3];
            int i2 = 0;
            while (i2 < 3) {
                pos[i2] = vertex[e.m_data[i2]];
                ++i2;
            }
            if (!PuCompGeometry.ccw(pos)) {
                PdVector tmp = pos[1];
                pos[1] = pos[2];
                pos[2] = tmp;
            }
            if (PuCompGeometry.isPolygonIntersectPolygon(pos, pvertex)) {
                int k = 0;
                while (k < nop) {
                    start = polygon[k].m_data[0];
                    end = polygon[k].m_data[1];
                    if (PuCompGeometry.isLineIntersectPolygon(cvertex[start], cvertex[end], pos) && interPol[k].getIndexOf(index) == -1) {
                        interPol[k].addEntry(index);
                    }
                    ++k;
                }
            }
            ++index;
            ++n2;
        }
        PiVector[] neighbor = hyper.getNeighbours();
        PiVector[] element = hyper.getElements();
        int noe = hyper.getNumElements();
        int max_inter = 1000;
        PiVector[] newInter = new PiVector[nop];
        int i3 = 0;
        while (i3 < nop) {
            start = polygon[i3].m_data[0];
            end = polygon[i3].m_data[1];
            if (!PuCompGeometry.ccwOrientLine(cvertex[start], cvertex[end])) {
                int aux = start;
                start = end;
                end = aux;
            }
            PdVector[] line = new PdVector[]{cvertex[start], cvertex[end]};
            int size = interPol[i3].getSize();
            if (size != 0) {
                int cur = interPol[i3].m_data[0];
                element[cur].setTag(1);
                PiVector[] processed = new PiVector[max_inter];
                boolean[] checked = new boolean[noe];
                j = 0;
                while (j < interPol[i3].getSize()) {
                    processed[j] = new PiVector();
                    processed[j].addEntry(interPol[i3].m_data[j]);
                    ++j;
                }
                checked[cur] = true;
                int step = 0;
                int next = interPol[i3].getSize();
                newInter[i3] = new PiVector();
                newInter[i3].addEntry(cur);
                while (processed[step] != null) {
                    int curProc = processed[step].m_data[0];
                    PiVector nb = neighbor[curProc];
                    size = nb.getSize();
                    int j2 = 0;
                    while (j2 < size) {
                        int b = nb.m_data[j2];
                        if (b != -1 && !checked[b]) {
                            PiVector e = element[b];
                            PdVector[] pos = new PdVector[3];
                            int m = 0;
                            while (m < 3) {
                                pos[m] = vertex[e.m_data[m]];
                                ++m;
                            }
                            if (!PuCompGeometry.ccw(pos)) {
                                PdVector tmp = pos[1];
                                pos[1] = pos[2];
                                pos[2] = tmp;
                            }
                            if (PuCompGeometry.isTriangleRightToLine(pos, line) || PuCompGeometry.isLineIntersectPolygon(line[0], line[1], pos)) {
                                e.setTag(1);
                                newInter[i3].addEntry(b);
                                checked[b] = true;
                                processed[next] = new PiVector();
                                processed[next].addEntry(b);
                                ++next;
                            }
                        }
                        ++j2;
                    }
                    ++step;
                }
            }
            ++i3;
        }
        int noeTrans = 0;
        int i4 = 0;
        while (i4 < nop) {
            noeTrans += newInter[i4].getSize();
            ++i4;
        }
        int nov = hyper.getNumVertices();
        hyper.setNumElements(noe + noeTrans);
        hyper.setNumElements(nov + 3 * noeTrans);
        int indv = 0;
        int inde = 0;
        PdVector[] copyTri = new PdVector[3];
        int i5 = 0;
        while (i5 < nop) {
            PdMatrix T = cut.getTrans(i5, cut.getOpposite(i5));
            PiVector t_i = newInter[i5];
            j = 0;
            while (j < t_i.getSize()) {
                PiVector f = hyper.getElement(t_i.m_data[j]);
                int m = 0;
                while (m < 3) {
                    copyTri[m] = (PdVector)hyper.getVertex(f.m_data[m]).clone();
                    ++m;
                }
                copyTri[0].leftMultMatrix(T);
                copyTri[1].leftMultMatrix(T);
                copyTri[2].leftMultMatrix(T);
                hyper.setVertex(nov + indv, copyTri[0]);
                hyper.setVertex(nov + indv + 1, copyTri[1]);
                hyper.setVertex(nov + indv + 2, copyTri[2]);
                hyper.setElement(noe + inde, nov + indv, nov + indv + 1, nov + indv + 2);
                hyper.getElement(noe + inde).setName(f.getName());
                indv += 3;
                ++inde;
                ++j;
            }
            ++i5;
        }
        PuCleanMesh.identifyVertices((PgPointSet)hyper, (double)1.0E-5);
        hyper.makeNeighbour();
    }

    public static void translate(PdMatrix T, PgElementSet geom, PiVector tri) {
    }
}

