/*
 * Decompiled with CFR 0.152.
 */
package devRegularMap.color;

import java.awt.Color;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PuData;

public final class PdColor
extends PsObject {
    private static final int MIN_VALUE = 0;
    private static final int MAX_VALUE = 255;
    private static final int m_numDefColors = 3;
    protected boolean m_bHasAlpha;
    protected int m_alpha;
    protected int[] m_data;
    protected boolean m_enabled = true;

    public PdColor() {
        this(3, false);
    }

    public PdColor(int size, boolean bAlpha) {
        this.enableAlpha(bAlpha);
        this.setSize(size);
        this.init();
    }

    public PdColor(String name, PsUpdateIf parent) {
        this.setName(name);
        if (parent != null) {
            this.setParent(parent);
        }
        this.enableAlpha(false);
        this.setSize(3);
        this.init();
    }

    public void init() {
        super.init();
        this.setConstant(0);
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void setEnabled(boolean flag) {
        PsDebug.notify((String)("setEnabled(" + flag + ")"));
        if (this.m_enabled == flag) {
            return;
        }
        this.m_enabled = flag;
        this.updatePanels((Object)this);
    }

    public static int getColor(int a, int r, int g, int b) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int getColor(int a, int[] rgb) {
        return a << 24 | rgb[0] << 16 | rgb[1] << 8 | rgb[2];
    }

    public static Color getColorFromName(String color) {
        if (color == null || color.equalsIgnoreCase("black")) {
            return Color.black;
        }
        if (color.equalsIgnoreCase("white")) {
            return Color.white;
        }
        if (color.equalsIgnoreCase("red")) {
            return Color.red;
        }
        if (color.equalsIgnoreCase("blue")) {
            return Color.blue;
        }
        if (color.equalsIgnoreCase("green")) {
            return Color.green;
        }
        if (color.equalsIgnoreCase("cyan")) {
            return Color.cyan;
        }
        if (color.equalsIgnoreCase("darkGray") || color.equalsIgnoreCase("darkGrey")) {
            return Color.darkGray;
        }
        if (color.equalsIgnoreCase("gray") || color.equalsIgnoreCase("grey")) {
            return Color.gray;
        }
        if (color.equalsIgnoreCase("lightGray") || color.equalsIgnoreCase("lightGrey")) {
            return Color.lightGray;
        }
        if (color.equalsIgnoreCase("magenta")) {
            return Color.magenta;
        }
        if (color.equalsIgnoreCase("orange")) {
            return Color.orange;
        }
        if (color.equalsIgnoreCase("pink")) {
            return Color.pink;
        }
        if (color.equalsIgnoreCase("yellow")) {
            return Color.yellow;
        }
        return Color.black;
    }

    public int getSize() {
        return this.m_data.length;
    }

    public void setSize(int aSize) {
        if (this.m_data == null || this.m_data.length != aSize) {
            this.m_data = PuData.realloc((int[])this.m_data, (int)aSize);
        }
    }

    public boolean equals(Color col) {
        int len = this.m_data.length;
        if (col == null && len == 0) {
            return true;
        }
        if (col == null) {
            return false;
        }
        if (len < 3) {
            return false;
        }
        return this.getRed() == col.getRed() && this.getGreen() == col.getGreen() && this.getBlue() == col.getBlue();
    }

    public boolean equals(PdColor col) {
        int len = this.m_data.length;
        if (col == null && len == 0) {
            return true;
        }
        if (col == null) {
            return false;
        }
        if (len != col.getSize()) {
            return false;
        }
        --len;
        while (len >= 0) {
            if (this.m_data[len] != col.m_data[len]) {
                return false;
            }
            --len;
        }
        return true;
    }

    public int getGrey() {
        if (this.m_data.length != 1) {
            return 0;
        }
        return this.m_data[0];
    }

    public int getRed() {
        if (this.m_data.length < 1) {
            return 0;
        }
        return this.m_data[0];
    }

    public int getGreen() {
        if (this.m_data.length < 2) {
            return 0;
        }
        return this.m_data[1];
    }

    public int getBlue() {
        if (this.m_data.length < 3) {
            return 0;
        }
        return this.m_data[2];
    }

    public int getAlpha() {
        if (!this.m_bHasAlpha) {
            return 0;
        }
        return this.m_alpha;
    }

    public static int getMax(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        int max = r;
        if (g > max) {
            max = g;
        }
        if (b > max) {
            max = b;
        }
        return max;
    }

    public static int getMin(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        int min = r;
        if (g < min) {
            min = g;
        }
        if (b < min) {
            min = b;
        }
        return min;
    }

    public static Color brighter(Color color) {
        int rgb = color.getRGB();
        int r = 127 + ((rgb >> 16 & 0xFF) >> 1);
        int g = 127 + ((rgb >> 8 & 0xFF) >> 1);
        int b = 127 + ((rgb & 0xFF) >> 1);
        return new Color(r, g, b);
    }

    public static int getDimmedColor(int[] rgb, int dim) {
        int alpha = rgb[0];
        if (dim <= 0) {
            return alpha << 24;
        }
        int r = rgb[1];
        int g = rgb[2];
        int b = rgb[3];
        if (dim == 255) {
            return alpha << 24 | r << 16 | g << 8 | b;
        }
        int red = dim * r >> 8;
        int green = dim * g >> 8;
        int blue = dim * b >> 8;
        if (dim > 255) {
            if (red > 255) {
                red = 255;
            }
            if (green > 255) {
                green = 255;
            }
            if (blue > 255) {
                blue = 255;
            }
        }
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int getDimmedColor(int rgb, int dim) {
        if (dim == 255) {
            return rgb;
        }
        int alpha = rgb & 0xFF000000;
        if (dim <= 0) {
            return alpha;
        }
        int red = dim * (rgb >> 16 & 0xFF) >> 8;
        int green = dim * (rgb >> 8 & 0xFF) >> 8;
        int blue = dim * (rgb & 0xFF) >> 8;
        if (dim > 255) {
            if (red > 255) {
                red = 255;
            }
            if (green > 255) {
                green = 255;
            }
            if (blue > 255) {
                blue = 255;
            }
        }
        rgb = alpha | red << 16 | green << 8 | blue;
        return rgb;
    }

    public static int getDimmedColor(int rgb, double dim) {
        if (dim == 1.0) {
            return rgb;
        }
        int alpha = rgb & 0xFF000000;
        if (dim <= 0.0) {
            return alpha;
        }
        int red = (int)(dim * (double)(rgb >> 16 & 0xFF));
        int green = (int)(dim * (double)(rgb >> 8 & 0xFF));
        int blue = (int)(dim * (double)(rgb & 0xFF));
        if (dim > 1.0) {
            if (red > 255) {
                red = 255;
            }
            if (green > 255) {
                green = 255;
            }
            if (blue > 255) {
                blue = 255;
            }
        }
        rgb = alpha | red << 16 | green << 8 | blue;
        return rgb;
    }

    public static Color getDimmedColor(Color col, int dim) {
        if (dim == 255) {
            return col;
        }
        if (dim <= 0) {
            return Color.black;
        }
        int rgb = col.getRGB();
        int alpha = rgb & 0xFF000000;
        int red = dim * (rgb >> 16 & 0xFF) >> 8;
        int green = dim * (rgb >> 8 & 0xFF) >> 8;
        int blue = dim * (rgb & 0xFF) >> 8;
        if ((double)dim > 1.0) {
            if (red > 255) {
                red = 255;
            }
            if (green > 255) {
                green = 255;
            }
            if (blue > 255) {
                blue = 255;
            }
        }
        rgb = alpha | red << 16 | green << 8 | blue;
        return new Color(rgb);
    }

    public static Color getDimmedColor(Color col, double dim) {
        return PdColor.getDimmedColor(col, (int)(255.0 * dim + 0.5));
    }

    public static Color getDimmedColor(Color col, double dim, double offset) {
        int rgb = PdColor.getDimmedColor(col.getRGB(), dim, offset);
        return new Color(rgb);
    }

    public static int getDimmedColor(int rgb, double dim, double offset) {
        int red = (int)(offset + dim * (double)(rgb >> 16 & 0xFF));
        int green = (int)(offset + dim * (double)(rgb >> 8 & 0xFF));
        int blue = (int)(offset + dim * (double)(rgb & 0xFF));
        if (red < 0) {
            red = 0;
        }
        if (green < 0) {
            green = 0;
        }
        if (blue < 0) {
            blue = 0;
        }
        if (red > 255) {
            red = 255;
        }
        if (green > 255) {
            green = 255;
        }
        if (blue > 255) {
            blue = 255;
        }
        int alpha = rgb & 0xFF000000;
        rgb = alpha | red << 16 | green << 8 | blue;
        return rgb;
    }

    public Color getColor() {
        if (this.m_data.length < 3) {
            PsDebug.warning((String)("too small number of components == " + this.getSize()));
            return null;
        }
        return new Color(this.m_data[0], this.m_data[1], this.m_data[2]);
    }

    public void setColor(Color aColor) {
        if (aColor == null) {
            PsDebug.warning((String)"missing aColor");
            return;
        }
        int rgb = aColor.getRGB();
        this.set(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
        this.updatePanels((Object)this);
    }

    public boolean hasAlpha() {
        return this.m_bHasAlpha;
    }

    public void enableAlpha(boolean flag) {
        this.m_bHasAlpha = flag;
    }

    public int getEntry(int ind) {
        if (ind < 0 || this.m_data.length <= ind) {
            PsDebug.warning((String)("index=" + ind + " out of range"));
            return 0;
        }
        return this.m_data[ind];
    }

    public void setEntry(int ind, int value) {
        if (ind < 0 || this.m_data.length <= ind) {
            PsDebug.warning((String)("index=" + ind + " out of range"));
            return;
        }
        this.m_data[ind] = value;
    }

    public void setEntry(int ind, double value) {
        this.setEntry(ind, (int)(255.0 * value + 0.5));
    }

    public void setConstant(int value) {
        int i = 0;
        while (i < this.m_data.length) {
            this.m_data[i] = value;
            ++i;
        }
    }

    public void setAlpha(int alpha) {
        this.m_alpha = alpha;
    }

    public void setAlpha(double alpha) {
        this.setAlpha((int)(255.0 * alpha + 0.5));
    }

    public void set(int grey) {
        if (this.m_data.length < 1) {
            PsDebug.warning((String)("too small number of components == " + this.getSize()));
            return;
        }
        this.m_data[0] = grey;
    }

    public void set(int red, int green, int blue) {
        if (this.m_data.length < 3) {
            PsDebug.warning((String)("too small number of components == " + this.getSize()));
            return;
        }
        this.m_data[0] = red;
        this.m_data[1] = green;
        this.m_data[2] = blue;
    }

    public void set(int red, int green, int blue, int alpha) {
        this.set(red, green, blue);
        this.setAlpha(alpha);
    }

    public void set(double grey) {
        this.set((int)(255.0 * grey + 0.5));
    }

    public void set(double red, double green, double blue) {
        this.set((int)(255.0 * red + 0.5), (int)(255.0 * green + 0.5), (int)(255.0 * blue + 0.5));
    }

    public void set(double red, double green, double blue, double alpha) {
        this.set(red, green, blue);
        this.setAlpha(alpha);
    }

    public Object clone() {
        PdColor clone = (PdColor)((Object)super.clone());
        if (clone == null) {
            return null;
        }
        clone.m_data = (int[])this.m_data.clone();
        return clone;
    }

    public static PdColor copyNew(PdColor v) {
        if (v == null) {
            PsDebug.warning((String)"missing argument color");
            return null;
        }
        PdColor newColor = new PdColor(v.getSize(), v.m_bHasAlpha);
        newColor.copy(v);
        return newColor;
    }

    public void copy(PdColor v) {
        if (v == null) {
            PsDebug.warning((String)"missing argument color");
            return;
        }
        int vSize = v.getSize();
        if (this.m_data.length != vSize) {
            PsDebug.warning((String)"argument color has different size");
            return;
        }
        this.m_bHasAlpha = v.m_bHasAlpha;
        System.arraycopy(v.m_data, 0, this.m_data, 0, vSize);
        super.copy((PsObject)v);
    }

    public void copy(int[] anArray, int aSize) {
        if (anArray == null) {
            PsDebug.warning((String)"missing argument array");
            return;
        }
        if (this.m_data.length != aSize) {
            PsDebug.warning((String)"missing space in destination");
            return;
        }
        System.arraycopy(this.m_data, 0, anArray, 0, aSize);
    }

    public void copy(double[] anArray, int aSize) {
        if (anArray == null) {
            PsDebug.warning((String)"missing argument array");
            return;
        }
        if (this.m_data.length != aSize) {
            PsDebug.warning((String)"missing space in destination");
            return;
        }
        int i = 0;
        while (i < aSize) {
            this.m_data[i] = (int)(255.0 * anArray[i]);
            ++i;
        }
    }

    public int max() {
        int max = 0;
        int i = 0;
        while (i < this.m_data.length) {
            if (this.m_data[i] > max) {
                max = this.m_data[i];
            }
            ++i;
        }
        return max;
    }

    public int min() {
        int min = 255;
        int i = 0;
        while (i < this.m_data.length) {
            if (this.m_data[i] < min) {
                min = this.m_data[i];
            }
            ++i;
        }
        return min;
    }

    public int indexOfMax() {
        int index = 0;
        int max = 0;
        int i = 0;
        while (i < this.m_data.length) {
            if (this.m_data[i] > max) {
                max = this.m_data[i];
                index = i;
            }
            ++i;
        }
        return index;
    }

    public int indexOfMin() {
        int index = 0;
        int min = 255;
        int i = 0;
        while (i < this.m_data.length) {
            if (this.m_data[i] < min) {
                min = this.m_data[i];
                index = i;
            }
            ++i;
        }
        return index;
    }

    public static int blend(double a, int v, double b, int w) {
        int alpha = (int)(a * (double)(v >> 24 & 0xFF) + b * (double)(w >> 24 & 0xFF));
        int red = (int)(a * (double)(v >> 16 & 0xFF) + b * (double)(w >> 16 & 0xFF));
        int green = (int)(a * (double)(v >> 8 & 0xFF) + b * (double)(w >> 8 & 0xFF));
        int blue = (int)(a * (double)(v & 0xFF) + b * (double)(w & 0xFF));
        if (alpha > 255) {
            alpha = 255;
        }
        if (red > 255) {
            red = 255;
        }
        if (green > 255) {
            green = 255;
        }
        if (blue > 255) {
            blue = 255;
        }
        int rgb = alpha << 24 | red << 16 | green << 8 | blue;
        return rgb;
    }

    public static Color blend(double a, Color v, double b, Color w) {
        if (v == null || w == null) {
            return null;
        }
        if (a < 0.0) {
            a = -a;
        }
        if (b < 0.0) {
            b = -b;
        }
        int vRgb = v.getRGB();
        int wRgb = w.getRGB();
        int red = (int)(a * (double)(vRgb >> 16 & 0xFF) + b * (double)(wRgb >> 16 & 0xFF));
        int green = (int)(a * (double)(vRgb >> 8 & 0xFF) + b * (double)(wRgb >> 8 & 0xFF));
        int blue = (int)(a * (double)(vRgb & 0xFF) + b * (double)(wRgb & 0xFF));
        if (red > 255) {
            red = 255;
        }
        if (green > 255) {
            green = 255;
        }
        if (blue > 255) {
            blue = 255;
        }
        return new Color(red, green, blue);
    }

    public void blend(double a, PdColor v, double b, PdColor w) {
        if (a < 0.0) {
            a = -a;
        }
        if (b < 0.0) {
            b = -b;
        }
        int i = 0;
        while (i < this.m_data.length) {
            int newCol = (int)((double)v.m_data[i] * a + (double)w.m_data[i] * b);
            this.m_data[i] = newCol <= 0 ? 0 : (newCol >= 255 ? 255 : newCol);
            ++i;
        }
    }

    public void blendBase(PdColor v, double b, PdColor w) {
        this.blend(1.0, v, b, w);
    }

    public static Color[] realloc(Color[] data, int arraySize) {
        if (data != null && data.length == arraySize) {
            return data;
        }
        Color[] newData = new Color[arraySize];
        int commonSize = 0;
        if (data != null && (commonSize = Math.min(data.length, arraySize)) != 0) {
            System.arraycopy(data, 0, newData, 0, commonSize);
        }
        int i = commonSize;
        while (i < arraySize) {
            newData[i] = Color.black;
            ++i;
        }
        return newData;
    }

    public static PdColor[] realloc(PdColor[] data, int arraySize, int colorSize) {
        return PdColor.realloc(data, arraySize, colorSize, false);
    }

    public static PdColor[] realloc(PdColor[] data, int arraySize, int colorSize, boolean bAlpha) {
        int commonSize;
        if (data != null && data.length == arraySize) {
            int j = 0;
            while (j < data.length) {
                data[j].enableAlpha(bAlpha);
                data[j].setSize(colorSize);
                ++j;
            }
            return data;
        }
        PdColor[] newData = new PdColor[arraySize];
        if (data == null) {
            commonSize = 0;
        } else {
            commonSize = Math.min(data.length, arraySize);
            System.arraycopy(data, 0, newData, 0, commonSize);
        }
        int i = 0;
        while (i < commonSize) {
            if (newData[i].m_bHasAlpha != bAlpha) {
                newData[i].enableAlpha(bAlpha);
            }
            if (newData[i].getSize() != colorSize) {
                newData[i].setSize(colorSize);
            }
            ++i;
        }
        i = commonSize;
        while (i < arraySize) {
            newData[i] = new PdColor(colorSize, bAlpha);
            ++i;
        }
        return newData;
    }

    public static PdColor[] copyNew(PdColor[] data) {
        if (data == null) {
            PsDebug.warning((String)"missing argument");
            return null;
        }
        return PdColor.copyNew(data, data.length);
    }

    public static PdColor[] copyNew(PdColor[] data, int size) {
        if (data == null) {
            PsDebug.warning((String)"missing argument");
            return null;
        }
        PdColor[] newData = new PdColor[size];
        int i = 0;
        while (i < size) {
            newData[i] = PdColor.copyNew(data[i]);
            ++i;
        }
        return newData;
    }

    public static Color[] copyNew(Color[] data) {
        if (data == null) {
            PsDebug.warning((String)"missing argument");
            return null;
        }
        return PdColor.copyNew(data, data.length);
    }

    public static Color[] copyNew(Color[] data, int size) {
        if (data == null) {
            PsDebug.warning((String)"missing argument");
            return null;
        }
        Color[] newData = new Color[size];
        int i = 0;
        while (i < size) {
            newData[i] = data[i];
            ++i;
        }
        return newData;
    }

    public static boolean copy(Color[] dataDest, int destInd, Color[] dataSrc, int srcInd, int size) {
        if (dataDest == null || dataDest.length < destInd + size) {
            PsDebug.warning((String)"missing space in dataDest");
            return false;
        }
        if (dataSrc == null || dataSrc.length < srcInd + size) {
            PsDebug.warning((String)"missing space in dataSrc", (Object)dataSrc);
            return false;
        }
        int i = 0;
        while (i < size) {
            dataDest[destInd + i] = dataSrc[srcInd + i];
            ++i;
        }
        return true;
    }

    public static boolean copy(PdColor[] dataDest, int destInd, PdColor[] dataSrc, int srcInd, int size) {
        if (dataDest == null || dataDest.length < destInd + size) {
            PsDebug.warning((String)"missing space in dataDest");
            return false;
        }
        if (dataSrc == null || dataSrc.length < srcInd + size) {
            PsDebug.warning((String)"missing space in dataSrc", (Object)dataSrc);
            return false;
        }
        int i = 0;
        while (i < size) {
            dataDest[destInd + i].copy(dataSrc[srcInd + i]);
            ++i;
        }
        return true;
    }

    public static void rgb2hsv(PdColor hsv, PdColor rgb) {
        int max = rgb.max();
        int min = rgb.min();
        hsv.m_data[2] = max;
        hsv.m_data[1] = max == 0 ? 0 : (int)((double)(max - min) * 255.0 / (double)max + 0.5);
        if (hsv.m_data[1] == 0) {
            hsv.m_data[0] = 0;
        } else {
            double h = 0.0;
            double delta = max - min;
            h = rgb.m_data[0] == max ? (double)(rgb.m_data[1] - rgb.m_data[2]) / delta : (rgb.m_data[1] == max ? 2.0 + (double)(rgb.m_data[2] - rgb.m_data[0]) / delta : 4.0 + (double)(rgb.m_data[0] - rgb.m_data[1]) / delta);
            if ((h *= 60.0) < 0.0) {
                h += 360.0;
            }
            hsv.m_data[0] = (int)h;
        }
    }

    public static void hsv2rgb(PdColor rgb, PdColor hsv) {
        Color _rgb = PdColor.hsv2rgb(hsv.m_data[0], hsv.m_data[1], hsv.m_data[2]);
        rgb.setColor(_rgb);
    }

    public static Color hsv2rgb(Color hsv) {
        return PdColor.hsv2rgb(hsv.getRed(), hsv.getGreen(), hsv.getBlue());
    }

    public static int hsv2rgbAsInt(int h, int s, int v) {
        int opaque = -16777216;
        if (s == 0) {
            return opaque | v << 16 | v << 8 | v;
        }
        float f = (float)((double)h * 6.0 / 256.0);
        int i = (int)f;
        float ds = (float)((double)(v * s) / 255.0);
        int p = (int)((float)v - ds);
        int q = (int)((float)v - (f -= (float)i) * ds);
        int t = (int)((double)v - (1.0 - (double)f) * (double)ds);
        switch (i) {
            case 0: {
                return opaque | v << 16 | t << 8 | p;
            }
            case 1: {
                return opaque | q << 16 | v << 8 | p;
            }
            case 2: {
                return opaque | p << 16 | v << 8 | t;
            }
            case 3: {
                return opaque | p << 16 | q << 8 | v;
            }
            case 4: {
                return opaque | t << 16 | p << 8 | v;
            }
            case 5: {
                return opaque | v << 16 | p << 8 | q;
            }
        }
        return opaque;
    }

    public static Color hsv2rgb(int h, int s, int v) {
        return new Color(PdColor.hsv2rgbAsInt(h, s, v));
    }

    private static double value(double n1, double n2, double hue) {
        if (hue < 0.0) {
            hue += 360.0;
        }
        if (hue > 360.0) {
            hue -= 360.0;
        }
        if (hue < 60.0) {
            return n1 + (n2 - n1) * hue / 60.0;
        }
        if (hue < 180.0) {
            return n2;
        }
        if (hue < 240.0) {
            return n1 + (n2 - n1) * (240.0 - hue) / 60.0;
        }
        return n1;
    }

    public static Color hsl2rgb(int hi, int li, int si) {
        double b;
        double g;
        double r;
        double h = (double)hi / 255.0 * 360.0;
        double l = (double)li / 255.0;
        double s = (double)si / 255.0;
        double m2 = l < 0.5 ? l * (1.0 + s) : l + s - l * s;
        double m1 = 2.0 * l - m2;
        if (s == 0.0) {
            r = l;
            g = l;
            b = l;
        } else {
            r = PdColor.value(m1, m2, h + 120.0);
            g = PdColor.value(m1, m2, h);
            b = PdColor.value(m1, m2, h - 120.0);
        }
        return new Color((int)(r * 255.0), (int)(g * 255.0), (int)(b * 255.0));
    }

    public static Color rgb2hsl(int ri, int gi, int bi) {
        double h;
        double s;
        double r = (double)ri / 255.0;
        double g = (double)gi / 255.0;
        double b = (double)bi / 255.0;
        double min = Math.min(Math.min(r, g), b);
        double max = Math.max(Math.max(r, g), b);
        double l = (max + min) / 2.0;
        if (max == min) {
            s = 0.0;
            h = 0.0;
        } else {
            s = l <= 0.5 ? (max - min) / (max + min) : (max - min) / (2.0 - max - min);
            double delta = max - min;
            h = r == max ? (g - b) / delta : (g == max ? 2.0 + (b - r) / delta : 4.0 + (r - g) / delta);
            if ((h /= 6.0) < 0.0) {
                h += 1.0;
            }
        }
        return new Color((int)(h * 255.0), (int)(l * 255.0), (int)(s * 255.0));
    }

    public static Color yiq2rgb(int yi, int ii, int qi) {
        double y = (double)yi / 255.0;
        double i = ((double)ii / 255.0 * 2.0 - 1.0) * 0.596;
        double q = ((double)qi / 255.0 * 2.0 - 1.0) * 0.522;
        double r = Math.min(1.0, Math.max(0.0, y + 0.956 * i + 0.623 * q));
        double g = Math.min(1.0, Math.max(0.0, y - 0.272 * i - 0.648 * q));
        double b = Math.min(1.0, Math.max(0.0, y - 1.105 * i + 0.705 * q));
        return new Color((int)(r * 255.0), (int)(g * 255.0), (int)(b * 255.0));
    }

    public static Color rgb2yiq(int ri, int gi, int bi) {
        double r = (double)ri / 255.0;
        double g = (double)gi / 255.0;
        double b = (double)bi / 255.0;
        double y = 0.299 * r + 0.587 * g + 0.114 * b;
        double i = 0.596 * r - 0.274 * g - 0.322 * b;
        double q = 0.211 * r - 0.522 * g + 0.311 * b;
        i = (i / 0.596 + 1.0) / 2.0;
        q = (q / 0.522 + 1.0) / 2.0;
        return new Color((int)(y * 255.0), (int)(i * 255.0), (int)(q * 255.0));
    }

    public static Color cmyk2rgb(int c, int m, int y, int k) {
        int r = 255 - (c + k);
        int b = 255 - (m + k);
        int g = 255 - (y + k);
        return new Color(r, g, b);
    }

    public static int[] rgb2cmyk(int r, int g, int b) {
        int c = 255 - r;
        int m = 255 - g;
        int y = 255 - b;
        int k = Math.min(Math.min(c, m), y);
        return new int[]{c - k, m - k, y - k, k};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Color parseColor(String colorString) {
        if (colorString == null) {
            PsDebug.warning((String)"missing color string.");
            return null;
        }
        try {
            if (colorString.startsWith("#")) {
                if (colorString.length() != 7) {
                    PsDebug.warning((String)("wrong format in color = " + colorString));
                    return null;
                }
                int h = Integer.parseInt(colorString.substring(1), 16);
                return new Color(h >>> 16 & 0xFF, h >>> 8 & 0xFF, h & 0xFF);
            }
            char sep = ' ';
            if (colorString.indexOf(",") != -1) {
                sep = ',';
            } else if (colorString.indexOf(";") != -1) {
                sep = ';';
            }
            boolean bInt = colorString.indexOf(".") == -1;
            String[] comp = PuString.splitString((String)colorString, (char)sep);
            if (bInt) {
                int r = Integer.parseInt(comp[0]);
                int g = Integer.parseInt(comp[1]);
                int b = Integer.parseInt(comp[2]);
                return new Color(r, g, b);
            }
            float r = Float.valueOf(comp[0]).floatValue();
            float g = Float.valueOf(comp[1]).floatValue();
            float b = Float.valueOf(comp[2]).floatValue();
            return new Color(r, g, b);
        }
        catch (NumberFormatException e) {
            PsDebug.warning((String)("wrong number format in color = " + colorString));
            return null;
        }
        catch (IllegalArgumentException e) {
            PsDebug.warning((String)("wrong value in color = " + colorString));
            return null;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            PsDebug.warning((String)("wrong number of components in color = " + colorString));
            return null;
        }
    }

    public static Color parseNamedColor(String str) {
        Color color = PdColor.parseNamedColor_doIt(str);
        if (color != null) {
            return color;
        }
        if (str.substring(0, 4).equalsIgnoreCase("dark")) {
            color = PdColor.parseNamedColor_doIt(str.substring(4));
            if (color != null) {
                return color.darker();
            }
        } else if (str.substring(0, 5).equalsIgnoreCase("light") ? (color = PdColor.parseNamedColor_doIt(str.substring(5))) != null : str.substring(0, 6).equalsIgnoreCase("bright") && (color = PdColor.parseNamedColor_doIt(str.substring(6))) != null) {
            return color.brighter();
        }
        return null;
    }

    private static Color parseNamedColor_doIt(String str) {
        if (str.equalsIgnoreCase("black")) {
            return Color.black;
        }
        if (str.equalsIgnoreCase("blue")) {
            return Color.blue;
        }
        if (str.equalsIgnoreCase("cyan")) {
            return Color.cyan;
        }
        if (str.equalsIgnoreCase("green")) {
            return Color.green;
        }
        if (str.equalsIgnoreCase("gray")) {
            return Color.gray;
        }
        if (str.equalsIgnoreCase("darkGray")) {
            return Color.darkGray;
        }
        if (str.equalsIgnoreCase("lightGray")) {
            return Color.lightGray;
        }
        if (str.equalsIgnoreCase("grey")) {
            return Color.gray;
        }
        if (str.equalsIgnoreCase("darkGrey")) {
            return Color.darkGray;
        }
        if (str.equalsIgnoreCase("lightGrey")) {
            return Color.lightGray;
        }
        if (str.equalsIgnoreCase("magenta")) {
            return Color.magenta;
        }
        if (str.equalsIgnoreCase("orange")) {
            return Color.orange;
        }
        if (str.equalsIgnoreCase("pink")) {
            return Color.pink;
        }
        if (str.equalsIgnoreCase("red")) {
            return Color.red;
        }
        if (str.equalsIgnoreCase("white")) {
            return Color.white;
        }
        if (str.equalsIgnoreCase("yellow")) {
            return Color.yellow;
        }
        return null;
    }

    public static Color getXORColor(Color colCurr, Color colPref, Color colAlt, int eps) {
        if (colCurr == null) {
            return colPref;
        }
        int icc = colCurr.getRGB();
        int icp = colPref.getRGB();
        int dr = Math.abs(icc >> 16 & 255 - (icp >> 16) & 0xFF);
        int dg = Math.abs(icc >> 8 & 255 - (icp >> 8) & 0xFF);
        int db = Math.abs(icc & 255 - icp & 0xFF);
        int mc = Math.max(Math.max(dr, dg), db);
        if (dr + dg + db < eps || 2 * mc < eps) {
            return colAlt;
        }
        return colPref;
    }

    public static String toString(Color col, String sep) {
        if (col == null) {
            return null;
        }
        int rgb = col.getRGB();
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        String s = String.valueOf(String.valueOf(r)) + sep + String.valueOf(g) + sep + String.valueOf(b);
        return s;
    }

    public static String toStringAsFloat(Color col, String sep) {
        if (col == null) {
            return null;
        }
        int rgb = col.getRGB();
        float rf = (float)(rgb >> 16 & 0xFF) / 255.0f;
        float gf = (float)(rgb >> 8 & 0xFF) / 255.0f;
        float bf = (float)(rgb & 0xFF) / 255.0f;
        String s = String.valueOf(String.valueOf(rf)) + sep + String.valueOf(gf) + sep + String.valueOf(bf);
        return s;
    }
}

