/*
 * Decompiled with CFR 0.152.
 */
package devRegularMap.apps;

import devRegularMap.apps.PjRegsmoother;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.objectGui.PsTabPanel;
import jv.project.PjProject_IP;

public class PjRegsmoother_IP
extends PjProject_IP
implements ItemListener {
    protected PjRegsmoother m_pjRegSmoother;
    protected PsTabPanel m_tabPanel;
    protected CheckboxGroup m_cView;
    protected Checkbox m_cPlanar;
    protected Checkbox m_c3D;
    protected Checkbox m_cFtube;
    protected Checkbox m_cHypTube;
    protected Checkbox m_cTubify;

    public PjRegsmoother_IP() {
        if (this.getClass() == PjRegsmoother_IP.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_cView = new CheckboxGroup();
        this.m_cPlanar = new Checkbox("Planar", this.m_cView, false);
        this.m_c3D = new Checkbox("3D", this.m_cView, true);
        this.m_cFtube = new Checkbox("Ftube", this.m_cView, false);
        this.m_cHypTube = new Checkbox("HypTube", this.m_cView, false);
        this.m_cTubify = new Checkbox("Tubify");
        this.m_cPlanar.addItemListener(this);
        this.m_c3D.addItemListener(this);
        this.m_cFtube.addItemListener(this);
        this.m_cHypTube.addItemListener(this);
        this.m_cTubify.addItemListener(this);
        this.m_tabPanel = new PsTabPanel();
        this.m_tabPanel.setParent((PsUpdateIf)this);
        this.m_tabPanel.setBackColor(Color.LIGHT_GRAY);
        PsPanel p = new PsPanel();
        p.add((Component)this.m_tabPanel);
        p.setBorderType(2);
        this.add((Component)p);
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.m_pjRegSmoother = (PjRegsmoother)parent;
        PsPanel info = this.m_pjRegSmoother.m_pjRegmap.getInfoPanel();
        info.removeTitle();
        this.m_tabPanel.addPanel("Maps", info);
        info = this.m_pjRegSmoother.m_pjShowLines.getInfoPanel();
        info.removeTitle();
        this.m_tabPanel.addPanel("Lines", info);
        info = this.m_pjRegSmoother.m_pjShapeMod.getInfoPanel();
        info.removeTitle();
        this.m_tabPanel.addPanel("Shape", info);
        info = this.m_pjRegSmoother.m_pj4gGon.getInfoPanel();
        info.removeTitle();
        this.m_tabPanel.addPanel("4g-Gon", info);
        info = this.m_pjRegSmoother.m_pjColors.getInfoPanel();
        this.m_tabPanel.addPanel("Colors", info);
        this.makeLayout();
        this.m_pjRegSmoother.setVisible(this.m_cPlanar.getState(), this.m_c3D.getState(), this.m_cFtube.getState(), this.m_cHypTube.getState());
        this.setView(false);
    }

    private void makeLayout() {
        PsPanel p = new PsPanel((LayoutManager)new FlowLayout());
        p.setBorderType(3);
        p.add((Component)this.m_cPlanar);
        p.add((Component)this.m_c3D);
        this.add((Component)p);
    }

    private void setView(boolean state) {
        PsPanel p4g = this.m_tabPanel.getPanel("4g-Gon");
        PsPanel pShape = this.m_tabPanel.getPanel("Shape");
        p4g.setEnabled(state);
        pShape.setEnabled(!state);
    }

    private void setViewPatch(boolean state) {
        PsPanel p4g = this.m_tabPanel.getPanel("4g-Gon");
        PsPanel pShape = this.m_tabPanel.getPanel("Shape");
        p4g.setEnabled(!state);
        pShape.setEnabled(!state);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.m_cPlanar) {
            this.setView(this.m_cPlanar.getState());
        }
        if (source == this.m_c3D) {
            this.setView(this.m_cPlanar.getState());
        }
        if (source == this.m_cFtube) {
            this.setViewPatch(this.m_cFtube.getState());
        }
        if (source == this.m_cHypTube) {
            this.setViewPatch(this.m_cHypTube.getState());
        }
        this.m_pjRegSmoother.setVisible(this.m_cPlanar.getState(), this.m_c3D.getState(), this.m_cFtube.getState(), this.m_cHypTube.getState());
        this.m_pjRegSmoother.compute();
        this.m_pjRegSmoother.update((Object)this.m_pjRegSmoother);
    }

    public boolean update(Object event) {
        if (event == this.m_tabPanel) {
            if (this.m_tabPanel.getCurrentPanel() == "Colors") {
                this.m_pjRegSmoother.m_pjColors.setRegularMap(this.m_pjRegSmoother.m_pjRegmap.getRegularMap());
                this.m_pjRegSmoother.setGeometryToColor(this.m_cPlanar.getState(), this.m_c3D.getState(), false, false);
            } else if (this.m_tabPanel.getCurrentPanel() == "Shape") {
                this.m_pjRegSmoother.m_pjShapeMod.setRegularMap(this.m_pjRegSmoother.m_pjRegmap.getRegularMap());
                this.m_pjRegSmoother.m_pjShapeMod.setGeometry(this.m_pjRegSmoother.m_symM_S3D, this.m_pjRegSmoother.m_3DqtubeTarget);
                this.m_pjRegSmoother.m_pjShapeMod.setSkeleton(this.m_pjRegSmoother.m_skeleton);
                this.m_pjRegSmoother.m_pjShapeMod.setLineClass(this.m_pjRegSmoother.m_pjShowLines);
                this.m_pjRegSmoother.m_pjShapeMod.initSkeleton();
            } else if (this.m_tabPanel.getCurrentPanel() == "4g-Gon") {
                this.m_pjRegSmoother.m_pj4gGon.setRegularMap(this.m_pjRegSmoother.m_pjRegmap.getRegularMap());
            } else if (this.m_tabPanel.getCurrentPanel() == "Lines") {
                this.m_pjRegSmoother.m_pjShowLines.setRegularMap(this.m_pjRegSmoother.m_pjRegmap.getRegularMap());
            }
            return true;
        }
        return super.update(event);
    }
}

