/*
 * Decompiled with CFR 0.152.
 */
package devRegularMap.apps;

import devRegularMap.functions.PgGon;
import devRegularMap.functions.PuRMaps;
import devRegularMap.grid.PwPutGrid;
import devRegularMap.info.Pt4gGon;
import devRegularMap.info.PtColors;
import devRegularMap.info.PtRegmap;
import devRegularMap.info.PtShapeModelling;
import devRegularMap.info.PtShowLines;
import devRegularMap.inputApps.PjExplicitInput;
import devRegularMap.vecmath.PuHyperboloid;
import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.geom.PgPolygonSet;
import jv.geom.PuCleanMesh;
import jv.number.PuBoolean;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PjRegsmoother
extends PjProject {
    protected PuRMaps m_srcMap;
    protected PuRMaps m_trgMap;
    protected PgElementSet m_symM_S2D;
    protected PgElementSet m_symM_S3D;
    protected PgElementSet m_2DqtubeTarget;
    protected PgElementSet m_3DqtubeTarget;
    protected PgElementSet m_3Dtubify;
    protected PgElementSet m_ITargetQtube;
    protected PgElementSet m_hyperTube;
    protected PgElementSet m_uniCover;
    protected PgPolygonSet m_NO;
    protected PgPolygonSet m_OM;
    protected PgPolygonSet m_MN;
    protected PgPolygon m_uCircle;
    protected PgPolygonSet m_skeleton;
    protected PgPointSet m_N;
    protected PgPointSet m_M;
    protected PgPointSet m_O;
    protected PgGon m_4gGonComp;
    protected PgGon m_4gGonL;
    protected PgGon m_4gGon;
    protected PtRegmap m_pjRegmap;
    protected PtShowLines m_pjShowLines;
    protected PtShapeModelling m_pjShapeMod;
    protected Pt4gGon m_pj4gGon;
    protected PtColors m_pjColors;
    protected PjExplicitInput m_pjInput;
    protected boolean m_bShow2D;
    protected boolean m_bShow3D;
    protected boolean m_bShowIHyper;
    protected boolean m_bInput;
    protected PuBoolean m_bShow3DTube;
    protected PuBoolean m_bSkeleton;
    protected PuBoolean m_bShow3DTile;
    protected PuBoolean m_bShow4gGon;
    protected PuBoolean m_bUniCover;
    protected PuBoolean m_bM;
    protected PuBoolean m_bN;
    protected PuBoolean m_bO;
    protected PuBoolean m_bNO;
    protected PuBoolean m_bOM;
    protected PuBoolean m_bMN;

    public PjRegsmoother() {
        super("Regular Map");
        this.initFunctions();
        if (((Object)((Object)this)).getClass() == PjRegsmoother.class) {
            this.init();
        }
    }

    public void start() {
        this.initDisplay();
        this.compute();
        this.getDisplay().showDepthcue(false);
        this.addGeometry((PgGeometryIf)this.m_symM_S3D);
        this.addGeometry((PgGeometryIf)this.m_symM_S2D);
        this.addGeometry((PgGeometryIf)this.m_3DqtubeTarget);
        this.addGeometry((PgGeometryIf)this.m_uCircle);
        this.addGeometry((PgGeometryIf)this.m_skeleton);
        this.addGeometry((PgGeometryIf)this.m_4gGon);
        this.addGeometry((PgGeometryIf)this.m_4gGonL);
        this.addGeometry((PgGeometryIf)this.m_uniCover);
        this.addGeometry((PgGeometryIf)this.m_ITargetQtube);
        this.addGeometry((PgGeometryIf)this.m_N);
        this.addGeometry((PgGeometryIf)this.m_M);
        this.addGeometry((PgGeometryIf)this.m_O);
        this.addGeometry((PgGeometryIf)this.m_NO);
        this.addGeometry((PgGeometryIf)this.m_MN);
        this.addGeometry((PgGeometryIf)this.m_OM);
        this.update((Object)this);
        super.start();
    }

    public boolean update(Object event) {
        if (event == this) {
            this.m_pjColors.hasColor(true);
            this.update((Object)this.m_pjColors);
            if (this.m_bShow3D) {
                this.update(this.m_pjShapeMod);
            } else if (this.m_bShow2D) {
                this.update((Object)this.m_pjShowLines);
                this.update((Object)this.m_pj4gGon);
            }
            this.update(this.m_display);
        }
        if (event == this.m_pjRegmap) {
            this.m_pjColors.hasColor(false);
            this.m_pjColors.isColorSet(false);
            if (this.m_bSkeleton.getState()) {
                this.m_pjShapeMod.hasSkeleton(false);
            }
            this.update((Object)this.m_pjColors);
            if (this.m_bShow3D) {
                this.update(this.m_pjShapeMod);
            } else if (this.m_bShow2D) {
                this.update((Object)this.m_pjShowLines);
                this.update((Object)this.m_pj4gGon);
            }
            return true;
        }
        if (event == this.m_pjShapeMod) {
            this.m_pjShapeMod.setRegularMap(this.m_pjRegmap.getRegularMap());
            this.m_pjShapeMod.initSkeleton();
            this.m_pjShapeMod.setBooleanPointOrLine(new PuBoolean[]{this.m_bM, this.m_bN, this.m_bO, this.m_bNO, this.m_bOM, this.m_bMN});
            this.m_pjColors.isColorSet(true);
            this.update((Object)this.m_pjColors);
            this.update((Object)this.m_pjShowLines);
            return true;
        }
        if (event == this.m_pjColors) {
            if (this.m_bInput) {
                this.m_pjColors.setRegularMap(this.m_pjInput.getRegularMap());
            } else {
                this.m_pjColors.setRegularMap(this.m_pjRegmap.getRegularMap());
            }
            this.setGeometryToColor(this.m_bShow2D, this.m_bShow3D, this.m_bShowIHyper, false);
            this.m_pjColors.update((Object)this.m_pjColors);
            return true;
        }
        if (event == this.m_pj4gGon) {
            this.m_pj4gGon.setRegularMap(this.m_pjRegmap.getRegularMap());
            this.m_pj4gGon.setGeometry(this.m_4gGonComp);
            this.m_pj4gGon.setDisplayGeometries(this.m_4gGon, this.m_4gGonL, this.m_uniCover);
            this.m_pj4gGon.update((Object)this.m_pj4gGon);
            this.update(this.m_display);
            return true;
        }
        if (event == this.m_pjShowLines) {
            if (this.m_bInput) {
                this.m_pjShowLines.setRegularMap(this.m_pjInput.getRegularMap());
            } else {
                this.m_pjShowLines.setRegularMap(this.m_pjRegmap.getRegularMap());
            }
            this.m_pjShowLines.setGeometriesPoint(this.m_M, this.m_N, this.m_O);
            this.m_pjShowLines.setGeometriesLine(this.m_NO, this.m_OM, this.m_MN);
            this.m_pjShowLines.update((Object)this.m_pjShowLines);
            this.update(this.m_display);
            return true;
        }
        if (event == this.m_display) {
            this.updateView(this.m_bShow2D, this.m_bShow3D, this.m_bShowIHyper, false);
            return true;
        }
        return super.update(event);
    }

    public void setGeometryToColor(boolean bPlanar, boolean b3D, boolean bFtube, boolean bHyp) {
        if (bPlanar) {
            if (this.m_bUniCover.getState() && this.m_pjRegmap.m_genus.getValue() > 1) {
                this.m_pjColors.setGeometry(this.m_uniCover);
            } else {
                this.m_pjColors.setGeometry(this.m_symM_S2D);
            }
        } else if (b3D) {
            this.m_pjColors.setGeometry(this.m_symM_S3D);
        }
    }

    public void updateView(boolean bPlanar, boolean b3D, boolean bFtube, boolean bHyp) {
        this.setVisibleGeometry(this.m_bShow2D, this.m_bShow3D, this.m_bShowIHyper, false);
        this.vertexProperties();
        this.lineProperties();
        if (bPlanar) {
            int i;
            this.m_symM_S2D.showEdges(false);
            if (this.m_pjRegmap.getRegularMap().getGenus() > 1) {
                PuHyperboloid.hyperboloidToPoincare(this.m_symM_S2D.getVertices());
                i = 0;
                while (i < this.m_symM_S2D.getNumElements()) {
                    this.m_symM_S2D.setElementNormal(i, new PdVector(1.0, 0.0, 0.0));
                    ++i;
                }
                this.m_display.selectCamera(3);
            } else if (this.m_pjRegmap.m_genus.getValue() <= 1) {
                this.m_display.selectCamera(1);
            }
            if (this.m_bShow4gGon.getState()) {
                this.m_4gGon.copy((PsObject)this.m_4gGonComp);
                this.m_4gGonL.copy((PsObject)this.m_4gGonComp);
                if (this.m_pjRegmap.getRegularMap().getGenus() > 1) {
                    PwPutGrid.refinePolygonSetHalf(this.m_4gGon, 8);
                    PuHyperboloid.hyperboloidToPoincare(this.m_4gGonL.getVertices());
                    PuHyperboloid.hyperboloidToPoincare(this.m_4gGon.getVertices());
                }
                i = 0;
                while (i < this.m_4gGonL.getNumVertices()) {
                    this.m_4gGonL.setVertexSize(i, 2.0);
                    this.m_4gGon.setVertexSize(i, 0.0);
                    ++i;
                }
                this.m_4gGonL.showVertexSizes(true);
                this.m_4gGonL.showEdgeLabels(true);
                this.m_4gGonL.setGlobalPolygonSize(0.0);
                this.m_4gGonL.showVertexColors(true);
                this.m_4gGon.showPolygonEndArrow(true);
                this.m_4gGon.showVertices(false);
                this.m_4gGon.setGlobalPolygonSize(1.5);
                this.selectGeometry((PgGeometryIf)this.m_4gGonL);
            } else {
                this.selectGeometry((PgGeometryIf)this.m_symM_S2D);
            }
            if (this.m_bUniCover.getState() && this.m_pjRegmap.getRegularMap().getGenus() > 1) {
                PuHyperboloid.hyperboloidToPoincare(this.m_uniCover.getVertices());
                this.m_uniCover.showEdges(false);
                this.m_uniCover.showVertices(false);
                this.selectGeometry((PgGeometryIf)this.m_uniCover);
            }
            if (this.m_bM.getState() && this.m_pjRegmap.getRegularMap().getGenus() > 1) {
                PuHyperboloid.hyperboloidToPoincare(this.m_M.getVertices());
            }
            if (this.m_bN.getState() && this.m_pjRegmap.getRegularMap().getGenus() > 1) {
                PuHyperboloid.hyperboloidToPoincare(this.m_N.getVertices());
            }
            if (this.m_bO.getState() && this.m_pjRegmap.getRegularMap().getGenus() > 1) {
                PuHyperboloid.hyperboloidToPoincare(this.m_O.getVertices());
            }
            if (this.m_bNO.getState() && this.m_pjRegmap.getRegularMap().getGenus() > 1) {
                PuHyperboloid.hyperboloidToPoincare(this.m_NO.getVertices());
            }
            if (this.m_bOM.getState() && this.m_pjRegmap.getRegularMap().getGenus() > 1) {
                PuHyperboloid.hyperboloidToPoincare(this.m_OM.getVertices());
            }
            if (this.m_bMN.getState() && this.m_pjRegmap.getRegularMap().getGenus() > 1) {
                PuHyperboloid.hyperboloidToPoincare(this.m_MN.getVertices());
            }
            this.m_display.setEnabled3DLook(false);
        } else if (b3D) {
            this.m_display.selectCamera(0);
            if (this.m_bShow3DTube.getState() && this.m_pjRegmap.getRegularMap().getGenus() > 1) {
                this.m_3DqtubeTarget.showEdges(false);
                this.m_3DqtubeTarget.showSmoothLighting(true);
                this.m_3DqtubeTarget.makeElementNormals();
                if (!this.m_bSkeleton.getState()) {
                    this.selectGeometry((PgGeometryIf)this.m_3DqtubeTarget);
                }
                if (this.m_bSkeleton.getState()) {
                    this.m_3DqtubeTarget.setTransparency(0.3);
                    this.m_3DqtubeTarget.showTransparency(true);
                    this.selectGeometry((PgGeometryIf)this.m_skeleton);
                } else {
                    this.m_3DqtubeTarget.showTransparency(false);
                }
            } else {
                this.m_symM_S3D.showEdges(false);
                this.m_symM_S3D.showElementColors(true);
                if (this.m_pjRegmap.getRegularMap().getGenus() < 2) {
                    PuCleanMesh.identifyVertices((PgPointSet)this.m_symM_S3D, (double)0.01);
                    this.m_symM_S3D.makeVertexNormals();
                }
                this.m_symM_S3D.showSmoothLighting(true);
                if (!this.m_bSkeleton.getState()) {
                    this.selectGeometry((PgGeometryIf)this.m_symM_S3D);
                }
                if (this.m_bSkeleton.getState()) {
                    this.m_symM_S3D.showTransparency(true);
                    this.selectGeometry((PgGeometryIf)this.m_skeleton);
                } else {
                    this.m_symM_S3D.showTransparency(false);
                }
            }
            if (this.m_bM.getState() || this.m_bN.getState() || this.m_bO.getState()) {
                this.m_display.setEnabled3DLook(true);
            } else {
                this.m_display.setEnabled3DLook(false);
            }
        } else if (bFtube) {
            this.m_ITargetQtube.showEdges(false);
            if (this.m_pjRegmap.getRegularMap().getGenus() > 1) {
                PuHyperboloid.hyperboloidToPoincare(this.m_ITargetQtube.getVertices());
                int i = 0;
                while (i < this.m_ITargetQtube.getNumElements()) {
                    this.m_ITargetQtube.setElementNormal(i, new PdVector(1.0, 0.0, 0.0));
                    ++i;
                }
                this.m_display.selectCamera(3);
            } else {
                this.m_display.selectCamera(1);
            }
            this.selectGeometry((PgGeometryIf)this.m_ITargetQtube);
        }
        this.m_symM_S2D.update((Object)this.m_symM_S2D);
        this.m_symM_S3D.update((Object)this.m_symM_S3D);
        this.m_3DqtubeTarget.update((Object)this.m_3DqtubeTarget);
        this.m_uCircle.update((Object)this.m_uCircle);
        this.m_skeleton.update((Object)this.m_skeleton);
        this.m_4gGonL.update((Object)this.m_4gGonL);
        this.m_4gGon.update((Object)this.m_4gGon);
        this.m_uniCover.update((Object)this.m_uniCover);
        this.m_ITargetQtube.update((Object)this.m_ITargetQtube);
        this.m_M.update((Object)this.m_M);
        this.m_N.update((Object)this.m_N);
        this.m_O.update((Object)this.m_O);
        this.m_MN.update((Object)this.m_MN);
        this.m_NO.update((Object)this.m_NO);
        this.m_OM.update((Object)this.m_OM);
        if (bPlanar || bFtube) {
            this.m_display.fit();
        }
        this.m_display.update((Object)this.m_display);
    }

    public void setVisibleGeometry(boolean bPlanar, boolean b3D, boolean bFtube, boolean bHyp) {
        this.m_symM_S2D.setVisible(bPlanar);
        this.m_symM_S3D.setVisible(b3D);
        this.m_M.setVisible(this.m_bM.getState());
        this.m_N.setVisible(this.m_bN.getState());
        this.m_O.setVisible(this.m_bO.getState());
        this.m_MN.setVisible(this.m_bMN.getState());
        this.m_NO.setVisible(this.m_bNO.getState());
        this.m_OM.setVisible(this.m_bOM.getState());
        this.m_ITargetQtube.setVisible(bFtube);
        if (this.m_bShow3DTube.getState() && this.m_pjRegmap.getRegularMap().getGenus() > 1) {
            this.m_symM_S3D.setVisible(false);
            this.m_3DqtubeTarget.setVisible(true);
        } else {
            this.m_3DqtubeTarget.setVisible(false);
        }
        if (bPlanar) {
            this.m_4gGonL.setVisible(this.m_bShow4gGon.getState());
            this.m_4gGon.setVisible(this.m_bShow4gGon.getState());
            if (this.m_pjRegmap.getRegularMap().getGenus() > 1) {
                this.m_uCircle.setVisible(bPlanar);
            } else {
                this.m_uCircle.setVisible(false);
            }
            if (this.m_bUniCover.getState() && this.m_pjRegmap.getRegularMap().getGenus() > 1) {
                this.m_uniCover.setVisible(true);
                this.m_symM_S2D.setVisible(false);
            } else {
                this.m_uniCover.setVisible(false);
            }
            this.m_3DqtubeTarget.setVisible(false);
            this.m_symM_S3D.setVisible(false);
            this.m_skeleton.setVisible(false);
        } else if (bFtube) {
            if (this.m_pjRegmap.getRegularMap().getGenus() > 1) {
                this.m_uCircle.setVisible(bFtube);
            } else {
                this.m_uCircle.setVisible(false);
            }
            this.m_4gGonL.setVisible(false);
            this.m_4gGon.setVisible(false);
            this.m_uniCover.setVisible(false);
            this.m_skeleton.setVisible(false);
        } else {
            this.m_uCircle.setVisible(false);
            this.m_4gGonL.setVisible(false);
            this.m_4gGon.setVisible(false);
            this.m_uniCover.setVisible(false);
            this.m_skeleton.setVisible(this.m_bSkeleton.getState());
        }
        if (!this.m_bShow3DTile.getState() && !this.m_bShow3DTube.getState()) {
            this.m_3DqtubeTarget.setVisible(false);
            this.m_symM_S3D.setVisible(false);
        }
    }

    public void vertexProperties() {
        int i = 0;
        while (i < this.m_M.getNumVertices()) {
            this.m_M.setVertexSize(i, 2.0);
            ++i;
        }
        this.m_M.setGlobalVertexColor(Color.LIGHT_GRAY);
        this.m_M.showVertexSizes(true);
        i = 0;
        while (i < this.m_N.getNumVertices()) {
            this.m_N.setVertexSize(i, 2.0);
            ++i;
        }
        this.m_N.setGlobalVertexColor(Color.GREEN);
        this.m_N.showVertexSizes(true);
        i = 0;
        while (i < this.m_O.getNumVertices()) {
            this.m_O.setVertexSize(i, 2.0);
            ++i;
        }
        this.m_O.setGlobalVertexColor(Color.ORANGE);
        this.m_O.showVertexSizes(true);
    }

    public void lineProperties() {
        this.m_NO.showVertices(false);
        this.m_NO.setGlobalPolygonColor(Color.black);
        this.m_NO.setGlobalPolygonSize(0.4);
        this.m_OM.showVertices(false);
        this.m_OM.setGlobalPolygonColor(Color.gray);
        this.m_OM.setGlobalPolygonSize(0.4);
        this.m_MN.showVertices(false);
        this.m_MN.setGlobalPolygonColor(Color.darkGray);
        this.m_MN.setGlobalPolygonSize(0.4);
    }

    public void initDisplay() {
        this.m_display.setBackgroundColor(Color.white);
        this.m_display.setSizeWithinFrame(800, 600);
        this.m_display.getCamera().setDist(2.1205);
        this.m_display.update((Object)this.m_display);
    }

    public void initFunctions() {
        this.m_symM_S2D = new PgElementSet(3);
        this.m_symM_S3D = new PgElementSet(3);
        this.m_2DqtubeTarget = new PgElementSet(3);
        this.m_3DqtubeTarget = new PgElementSet(3);
        this.m_3Dtubify = new PgElementSet(3);
        this.m_uCircle = new PgPolygon();
        this.m_ITargetQtube = new PgElementSet(3);
        this.m_hyperTube = new PgElementSet(3);
        this.m_uniCover = new PgElementSet(3);
        this.m_skeleton = new PgPolygonSet(3);
        this.m_NO = new PgPolygonSet(3);
        this.m_OM = new PgPolygonSet(3);
        this.m_MN = new PgPolygonSet(3);
        this.m_4gGon = new PgGon();
        this.m_4gGonL = new PgGon();
        this.m_4gGonComp = new PgGon();
        this.m_N = new PgPointSet();
        this.m_M = new PgPointSet();
        this.m_O = new PgPointSet();
        this.m_bShow3DTube = new PuBoolean(" ", (PsUpdateIf)this, false);
        this.m_bSkeleton = new PuBoolean(" ", (PsUpdateIf)this, false);
        this.m_bShow3DTile = new PuBoolean(" ", (PsUpdateIf)this, false);
        this.m_bShow4gGon = new PuBoolean(" ", (PsUpdateIf)this, false);
        this.m_bUniCover = new PuBoolean(" ", (PsUpdateIf)this, false);
        this.m_bM = new PuBoolean(" ", (PsUpdateIf)this, false);
        this.m_bN = new PuBoolean(" ", (PsUpdateIf)this, false);
        this.m_bO = new PuBoolean(" ", (PsUpdateIf)this, false);
        this.m_bMN = new PuBoolean(" ", (PsUpdateIf)this, false);
        this.m_bNO = new PuBoolean(" ", (PsUpdateIf)this, false);
        this.m_bOM = new PuBoolean(" ", (PsUpdateIf)this, false);
        this.m_pjRegmap = new PtRegmap();
        this.m_pjInput = new PjExplicitInput();
        this.m_pjShowLines = new PtShowLines();
        this.m_pjShapeMod = new PtShapeModelling();
        this.m_pj4gGon = new Pt4gGon();
        this.m_pjColors = new PtColors();
        this.m_pjRegmap.setGeometries(this.m_symM_S2D, this.m_symM_S3D, this.m_ITargetQtube, this.m_3DqtubeTarget, this.m_skeleton);
        this.m_pjRegmap.setParent((PsUpdateIf)this);
        this.m_pjShowLines.setBooleans(this.m_bM, this.m_bN, this.m_bO, this.m_bMN, this.m_bNO, this.m_bOM);
        this.m_pjShowLines.setGeometriesPoint(this.m_M, this.m_N, this.m_O);
        this.m_pjShowLines.setParent((PsUpdateIf)this);
        this.m_pjShapeMod.setParent((PsUpdateIf)this);
        this.m_pjShapeMod.setBooleans(this.m_bShow3DTube, this.m_bShow3DTile, this.m_bSkeleton);
        this.m_pjShapeMod.setSkeleton(this.m_skeleton);
        this.m_pjColors.setParent((PsUpdateIf)this);
        this.m_pjColors.setRegularMap(this.m_pjRegmap.getRegularMap());
        this.m_pj4gGon.setParent((PsUpdateIf)this);
        this.m_pj4gGon.setGeometry(this.m_4gGonComp);
        this.m_pj4gGon.setDisplayGeometries(this.m_4gGon, this.m_4gGonL, this.m_uniCover);
        this.m_pj4gGon.setBooleans(this.m_bUniCover, this.m_bShow4gGon);
        this.m_symM_S2D.setName("2D Tile");
        this.m_symM_S3D.setName("3D Tile");
        this.m_2DqtubeTarget.setName("2D target");
        this.m_3DqtubeTarget.setName("3D target");
        this.m_3Dtubify.setName("3D tubify");
        this.m_uCircle.setName("unitCircle");
        this.m_ITargetQtube.setName("I target");
        this.m_hyperTube.setName("Hyper Tube");
        this.m_uniCover.setName("UniCover");
        this.m_skeleton.setName("Skeleton");
        this.m_NO.setName("NO");
        this.m_OM.setName("OM");
        this.m_MN.setName("MN");
        this.m_4gGon.setName("4-gon");
        this.m_4gGonL.setName("Label");
        this.m_M.setName("M");
        this.m_N.setName("N");
        this.m_O.setName("O");
        this.m_MN.setName("MN");
        this.m_NO.setName("NO");
        this.m_OM.setName("OM");
        this.makeUnitCircle();
    }

    public boolean compute() {
        this.m_pjRegmap.compute();
        return true;
    }

    public void init() {
        super.init();
    }

    public void setVisible(boolean bPlanar, boolean b3D, boolean bFtube, boolean bHyp) {
        this.m_bShow2D = bPlanar;
        this.m_bShow3D = b3D;
        this.m_bShowIHyper = bFtube;
        this.m_pjRegmap.setVisible(bPlanar, b3D, bFtube, bHyp);
        this.m_pjInput.setVisible(bPlanar, b3D, bFtube, bHyp);
        this.m_pjShowLines.setView(bPlanar, b3D);
    }

    public void makeUnitCircle() {
        this.m_uCircle.setNumVertices(500);
        PiVector p = new PiVector(501);
        int i = 0;
        while (i < 500) {
            double t = (double)(2 * i) * Math.PI / 499.0;
            this.m_uCircle.setVertex(i, 0.0, Math.cos(t), Math.sin(t));
            p.m_data[i] = i;
            ++i;
        }
        p.m_data[200] = 0;
        this.m_uCircle.showVertices(false);
        this.m_uCircle.setClosed(true);
        this.m_uCircle.setGlobalEdgeColor(Color.LIGHT_GRAY);
    }
}

