/*
 * Decompiled with CFR 0.152.
 */
package devPolygonFrameFlow;

import dev.geom.PuElementSetIterator;
import dev.vecmath.PiDynVector;
import devCovering.PgCovering;
import devCovering.PgFrameField;
import devGraph.PnAbstractGraph;
import devPolygonFrameFlow.PnPolygonFrameVariationIf;
import devProjection.PnIntrinsicPolygon;
import devShootLines.PnFrameFieldLineDir;
import devShootLines.PnLineDirIf;
import devShootLines.PwShootLines;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.number.PuBoolean;
import jv.number.PuDouble;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PbVector;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jvx.geom.PgPolygonOnElementSet;
import jvx.geom.PwBary;
import jvx.gui.PuProgressBar;
import jvx.project.PjWorkshop;

public class PwPolygonFrameFlow
extends PjWorkshop
implements Runnable {
    protected PgElementSet m_geomBase;
    protected PgFrameField m_field;
    protected int m_numPolies;
    protected PgPolygonOnElementSet[] m_polies;
    protected PnPolygonFrameVariationIf m_variation;
    protected PnFrameFieldLineDir[][] m_lineDir;
    protected PbVector m_processPoly;
    protected PdBaryDir[][] m_flowVectorsBary;
    protected PuDouble m_stepSize;
    protected int m_numSteps;
    protected PuDouble m_alignGeod;
    protected PuBoolean m_showAlignmentVectors;
    protected PuBoolean m_holdEndPoints;
    protected PuProgressBar m_progressBar;
    protected PuBoolean m_showGradient;
    protected PgVectorField[] m_flowField;
    protected PgVectorField[] m_alignmentField;
    private PnFrameFieldLineDir m_lineDirTmp;
    protected PuDouble m_endGeod;
    public PuBoolean m_constrainGradient;
    private PiVector m_endPoints;
    private PdBaryDir[] m_endPointBaries;
    private boolean[] m_allowedFaces;
    private PgPolygonOnElementSet[] m_savedPolies;
    private double m_resampleEdgeLen;
    private boolean m_flowVectorsVisible = false;
    double m_threshold;
    PdVector[] m_elementCurvatureValues;
    private PdBaryDir m_tmpBary = new PdBaryDir(3);
    private PdVector m_tmp3 = new PdVector(3);
    PdVector m_tmp = new PdVector(3);
    PdVector m_tmp2 = new PdVector(3);
    PdBaryDir m_tmpDir = new PdBaryDir(3);
    PdBaryDir[][] m_frameVectorsBary;
    PdVector[] m_gradient;

    public PwPolygonFrameFlow(String name) {
        super(name);
        this.m_stepSize = new PuDouble("Step width");
        this.m_showGradient = new PuBoolean("Show gradient", (PsUpdateIf)this);
        this.m_showAlignmentVectors = new PuBoolean("Show Alignment", (PsUpdateIf)this);
        this.m_constrainGradient = new PuBoolean("Constrain Gradient", (PsUpdateIf)this);
        this.m_holdEndPoints = new PuBoolean("Hold endpoints");
        this.m_lineDirTmp = new PnFrameFieldLineDir();
        this.m_progressBar = new PuProgressBar(true);
        if (this.getClass() == PwPolygonFrameFlow.class) {
            this.init();
        }
    }

    public PwPolygonFrameFlow(String name, PgElementSet geom) {
        this(name);
        this.setGeometry((PgGeometry)geom);
    }

    public void init() {
        super.init();
        this.m_stepSize.setDefBounds(0.0, 1.0, 0.1, 1.0);
        this.m_stepSize.setDefValue(0.1);
        this.m_stepSize.init();
        this.m_showGradient.setDefState(false);
        this.m_showGradient.init();
        this.m_alignGeod = new PuDouble("Align geod");
        this.m_alignGeod.setDefBounds(0.0, 1.0, 0.1, 0.1);
        this.m_alignGeod.setDefValue(0.0);
        this.m_alignGeod.init();
        this.m_endGeod = new PuDouble("End % geod");
        this.m_endGeod.setDefBounds(0.0, 1.0, 0.1, 0.1);
        this.m_endGeod.setDefValue(0.0);
        this.m_endGeod.init();
        this.m_holdEndPoints.setDefState(true);
        this.m_holdEndPoints.init();
        this.m_showAlignmentVectors.setDefState(false);
        this.m_showAlignmentVectors.init();
        this.m_constrainGradient.setDefState(false);
        this.m_constrainGradient.init();
    }

    public void setGeometry(PgGeometry geom) {
        if (!(geom instanceof PgElementSet)) {
            PsDebug.warning((String)"Geom is not an PgElementSet.");
            return;
        }
        super.setGeometry(geom);
        this.m_geomBase = (PgElementSet)geom;
        this.save();
        if (this.m_variation != null && this.m_geomBase != null) {
            this.m_variation.setGeometry(this.m_geomBase);
        }
        this.update(this);
    }

    public void setProgressBar(PuProgressBar bar) {
        this.m_progressBar = bar;
    }

    public void setAllowedFaces(boolean[] allowedfaces) {
        this.m_allowedFaces = allowedfaces;
    }

    public void setDisplay(PvDisplayIf display) {
        super.setDisplay(display);
    }

    public double getResampleEdgeLen() {
        return this.m_resampleEdgeLen;
    }

    public void setResampleEdgeLen(double resampleEdgeLen) {
        this.m_resampleEdgeLen = resampleEdgeLen;
    }

    public void reset() {
        super.reset();
        if (this.m_geomBase == null || this.m_geomSave == null) {
            return;
        }
        this.m_geomBase.copy((PsObject)this.m_geomSave);
    }

    public void save() {
        if (this.m_geomBase == null) {
            return;
        }
        if (this.m_geomSave != null) {
            this.m_geomSave.copy((PsObject)this.m_geomBase);
        }
    }

    public boolean update(Object event) {
        if (event == this.m_showGradient) {
            if (this.m_showGradient.getState()) {
                this.updateFlowVectors(this.m_constrainGradient.getState());
                this.showFlowVectors(true);
            } else {
                this.showFlowVectors(false);
            }
            return true;
        }
        if (event == this.m_showAlignmentVectors) {
            this.showAlignmentField(this.m_showAlignmentVectors.getState());
            return true;
        }
        if (event == this.m_constrainGradient) {
            this.updateFlowVectors(this.m_constrainGradient.getState());
            if (this.m_flowVectorsVisible) {
                this.showFlowVectors(false);
                this.showFlowVectors(true);
            }
            return true;
        }
        return super.updatePanels(event);
    }

    private void showFlowVectors(boolean show) {
        if (show == this.m_flowVectorsVisible) {
            return;
        }
        if (show) {
            int i = 0;
            while (i < this.m_numPolies) {
                if (this.m_processPoly.m_data[i]) {
                    this.m_polies[i].addVectorField(this.m_flowField[i]);
                    this.m_flowField[i].update((Object)this.m_flowField[i]);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.m_numPolies) {
                if (this.m_processPoly.m_data[i]) {
                    this.m_polies[i].removeVectorField((PgGeometryIf)this.m_flowField[i]);
                    this.m_polies[i].update((Object)this.m_polies[i]);
                }
                ++i;
            }
        }
        this.m_flowVectorsVisible = show;
    }

    public String getName() {
        return "PolygonFrameFlow workshop";
    }

    public void setPolygon(PgPolygonOnElementSet curve, boolean process) {
        PgPolygonOnElementSet[] c = new PgPolygonOnElementSet[1];
        PbVector p = new PbVector(1);
        c[0] = curve;
        p.m_data[0] = process;
        this.setPolygons(c, p);
    }

    public void setPolygons(PgPolygonOnElementSet[] polies, PbVector process) {
        this.setPolygons(polies, null, process);
    }

    public void setPolygons(PgPolygonOnElementSet[] polies, PiVector endPoints, PbVector process) {
        this.m_endPoints = endPoints;
        this.m_polies = polies;
        this.m_numPolies = polies.length;
        this.m_flowField = new PgVectorField[this.m_numPolies];
        this.m_processPoly = process;
        if (endPoints != null) {
            this.enumerateEndpoints();
        }
        int i = 0;
        while (i < this.m_numPolies) {
            if (process == null || process.m_data[i]) {
                if (this.m_polies[i] == null) {
                    PsDebug.warning((String)("Polygon [" + i + "] is null."));
                } else {
                    this.m_processPoly.m_data[i] = true;
                    this.m_flowField[i] = new PgVectorField(3, 0);
                    this.m_flowField[i].setGeometry((PgPointSet)this.m_polies[i]);
                }
            }
            ++i;
        }
        if (this.m_field != null) {
            this.resample();
        }
    }

    private void enumerateEndpoints() {
        int num = this.m_endPoints.getSize();
        int[] indx = new int[num];
        PuMath.heapsort((int)num, (int[])this.m_endPoints.m_data, (int[])indx);
        int x = 0;
        int v = this.m_endPoints.m_data[indx[0]];
        Object bary = null;
        if (this.m_processPoly.m_data[0]) {
            bary = this.m_polies[0].getVertexBary(0);
        }
        int i = 0;
        while (i < num) {
            int polInd = indx[i] / 2;
            int vertInd = 0;
            if (this.m_processPoly.m_data[polInd]) {
                int n = vertInd = indx[i] % 2 == 0 ? 0 : this.m_polies[polInd].getNumVertices() - 1;
            }
            if (this.m_endPoints.m_data[indx[i]] != v) {
                ++x;
                v = this.m_endPoints.m_data[indx[i]];
                bary = this.m_processPoly.m_data[polInd] ? this.m_polies[polInd].getVertexBary(vertInd) : null;
            } else if (this.m_processPoly.m_data[polInd]) {
                if (bary == null) {
                    bary = this.m_polies[polInd].getVertexBary(vertInd);
                } else {
                    this.m_polies[polInd].setVertexBary(vertInd, bary);
                }
            }
            this.m_endPoints.m_data[indx[i]] = x;
            ++i;
        }
        this.m_endPointBaries = new PdBaryDir[x + 1];
        i = 0;
        while (i < x + 1) {
            this.m_endPointBaries[i] = new PdBaryDir(3);
            ++i;
        }
    }

    public void setFrameField(PgFrameField frameField) {
        this.m_field = frameField;
        if (this.m_polies != null) {
            this.resample();
        }
    }

    protected void initLineDirsNonIntrinsic() {
        if (this.m_field == null || this.m_polies == null) {
            return;
        }
        if (this.m_lineDir == null || this.m_lineDir.length != this.m_numPolies) {
            this.m_lineDir = new PnFrameFieldLineDir[this.m_numPolies][];
        }
        int i = 0;
        while (i < this.m_numPolies) {
            this.m_lineDir[i] = this.m_processPoly.m_data[i] ? this.initLineDirsNonIntrinsic(this.m_polies[i]) : null;
            ++i;
        }
    }

    private PnFrameFieldLineDir[] initLineDirsNonIntrinsic(PgPolygonOnElementSet poly) {
        PiVector indices = new PiVector();
        PiVector triangles = new PiVector();
        this.makeTriangles(poly, triangles, indices);
        PnFrameFieldLineDir[] lineDirs = this.initLineDirs(poly, triangles, indices);
        int numV = poly.getNumVertices();
        PnFrameFieldLineDir[] lineDir = new PnFrameFieldLineDir[numV];
        int v = 0;
        while (v < numV) {
            lineDir[v] = lineDirs[v];
            ++v;
        }
        return lineDir;
    }

    private void makeTriangles(PgPolygonOnElementSet poly, PiVector triangles, PiVector indices) {
        PiDynVector tri = new PiDynVector();
        PiDynVector ind = new PiDynVector();
        tri.appendEntry(poly.getVertexBary(0).getElementInd());
        ind.appendEntry(0);
        PuElementSetIterator it = new PuElementSetIterator(poly.getGeometry(), 1);
        int numV = poly.getNumVertices();
        int v = 0;
        while (v < numV - 1) {
            int ne;
            int e = poly.getVertexBary(v).getElementInd();
            if (e == (ne = poly.getVertexBary(v + 1).getElementInd())) {
                ind.appendEntry(tri.getSize() - 1);
            } else {
                it.init(e, 1);
                it.getNext();
                while (it.hasNext()) {
                    if (it.getNext() != ne) continue;
                    PiVector path = PnAbstractGraph.pathToRoot((PiVector)it.getParents(), (int)ne);
                    int len = path.getSize();
                    int i = 1;
                    while (i < len) {
                        tri.appendEntry(path.m_data[len - i - 1]);
                        ++i;
                    }
                    break block1;
                }
                ind.appendEntry(tri.getSize() - 1);
            }
            ++v;
        }
        tri.toPiVector(triangles);
        ind.toPiVector(indices);
    }

    private PnFrameFieldLineDir[] initLineDirs(PgPolygonOnElementSet poly, PiVector triangleStrip, PiVector indices) {
        int startLayer = this.liftPolygonToCovering(poly, triangleStrip, indices);
        int numV = poly.getNumVertices();
        PnFrameFieldLineDir[] lineDirs = new PnFrameFieldLineDir[numV];
        PgCovering cov = this.m_field.getCovering();
        int v = 0;
        while (v < numV) {
            PnFrameFieldLineDir lineDir = new PnFrameFieldLineDir();
            lineDir.setGeometry(this.m_geomBase);
            lineDir.setFrameField(this.m_field);
            PdBary vertexBary = poly.getVertexBary(v);
            lineDir.initializeDirection(vertexBary.getElementInd(), startLayer);
            if (v < numV - 1) {
                int i = indices.m_data[v];
                while (i < indices.m_data[v + 1]) {
                    int e = triangleStrip.m_data[i];
                    PiVector neighbours = this.m_geomBase.getNeighbour(e);
                    int locNeighbInd = neighbours.getIndexOf(triangleStrip.m_data[i + 1]);
                    startLayer = (startLayer + cov.getMatching(e, locNeighbInd)) % 4;
                    ++i;
                }
            }
            lineDirs[v] = lineDir;
            ++v;
        }
        return lineDirs;
    }

    private int liftPolygonToCovering(PgPolygonOnElementSet poly, PiVector triangleStrip, PiVector indices) {
        double integral1;
        double integral0 = this.integrateOnPath(this.m_geomBase, this.m_field, poly, triangleStrip, indices, 0);
        if (integral0 < (integral1 = this.integrateOnPath(this.m_geomBase, this.m_field, poly, triangleStrip, indices, 1))) {
            return 0;
        }
        return 1;
    }

    private double integrateOnPath(PgElementSet geom, PgFrameField field, PgPolygonOnElementSet poly, PiVector triangleStrip, PiVector indices, int startLayer) {
        PdVector[] vertices = poly.getVertices();
        PiVector[] neighb = geom.getNeighbours();
        PgCovering cov = field.getCovering();
        int num = poly.getNumVertices();
        PdVector tmp = new PdVector(3);
        double value = 0.0;
        int layer = startLayer;
        int v = 0;
        while (v < num - 1) {
            int e = poly.getVertexBary(v + 1).getElementInd();
            int i = indices.m_data[v];
            while (i < indices.m_data[v + 1]) {
                int actE = triangleStrip.m_data[i];
                int locInd = neighb[actE].getIndexOf(triangleStrip.m_data[i + 1]);
                if (locInd < 0) {
                    PsDebug.warning((String)"Error in neighbours");
                    return 0.0;
                }
                layer = (layer + cov.getMatching(actE, locInd)) % 4;
                ++i;
            }
            field.getVector(e, layer, 0, tmp);
            value += Math.abs(tmp.dot(vertices[v + 1]) - tmp.dot(vertices[v]));
            ++v;
        }
        return value;
    }

    public void resample() {
        this.m_progressBar.start();
        int i = 0;
        while (i < this.m_numPolies) {
            this.m_progressBar.setProgress(1.0 * (double)i / (double)this.m_numPolies);
            if (this.m_polies[i] != null) {
                if (this.m_resampleEdgeLen <= 0.0) {
                    int numV = this.m_polies[i].getNumVertices();
                    this.resamplePolygon(i, numV);
                } else {
                    this.resamplePolygon(i, this.m_resampleEdgeLen);
                }
            }
            ++i;
        }
        if (this.m_resampleEdgeLen > 0.0) {
            this.m_frameVectorsBary = null;
        }
        this.initLineDirsNonIntrinsic();
        this.m_savedPolies = new PgPolygonOnElementSet[this.m_numPolies];
        i = 0;
        while (i < this.m_numPolies) {
            if (this.m_polies[i] != null) {
                this.m_savedPolies[i] = new PgPolygonOnElementSet(this.m_geomBase);
                int num = this.m_polies[i].getNumVertices();
                this.m_savedPolies[i].setNumVertices(num);
                int v = 0;
                while (v < num) {
                    this.m_savedPolies[i].setVertexBary(v, this.m_polies[i].getVertexBary(v));
                    ++v;
                }
            }
            ++i;
        }
        this.m_progressBar.stop();
    }

    public void fixPolygon(int i) {
        if (this.m_polies[i] == null) {
            return;
        }
        int num = this.m_savedPolies[i].getNumVertices();
        this.m_polies[i].setNumVertices(num);
        int v = 0;
        while (v < num) {
            this.m_polies[i].setVertexBary(v, this.m_savedPolies[i].getVertexBary(v));
            ++v;
        }
        this.m_processPoly.m_data[i] = false;
    }

    private void resamplePolygon(int i, int numVertices) {
        PgPolygonOnElementSet resPoly = PnIntrinsicPolygon.resamplePolygon((PgPolygonOnElementSet)this.m_polies[i], (int)numVertices);
        this.m_polies[i].copy((PsObject)resPoly);
    }

    private void resamplePolygon(int i, double newEdgeLen) {
        PgPolygonOnElementSet resPoly = PnIntrinsicPolygon.resamplePolygon((PgPolygonOnElementSet)this.m_polies[i], (double)newEdgeLen);
        this.m_polies[i].copy((PsObject)resPoly);
    }

    public PgPolygonOnElementSet[] getPolygons() {
        return this.m_polies;
    }

    public void setVariation(PnPolygonFrameVariationIf variation) {
        this.m_variation = variation;
        if (this.m_variation != null && this.m_geomBase != null) {
            this.m_variation.setGeometry(this.m_geomBase);
        }
    }

    public PnPolygonFrameVariationIf getVariation() {
        return this.m_variation;
    }

    public void setNumSteps(int numSteps) {
        this.m_numSteps = numSteps;
    }

    public void showAlignmentField(boolean show) {
        if (show) {
            boolean allocate;
            boolean bl = allocate = this.m_alignmentField == null;
            if (allocate) {
                this.m_alignmentField = new PgVectorField[this.m_numPolies];
            }
            PdBaryDir baryDir = new PdBaryDir(3);
            int i = 0;
            while (i < this.m_numPolies) {
                if (this.m_processPoly.m_data[i]) {
                    if (allocate) {
                        this.m_alignmentField[i] = new PgVectorField(3, 0);
                        this.m_alignmentField[i].setGeometry((PgPointSet)this.m_polies[i]);
                    }
                    int numV = this.m_polies[i].getNumVertices();
                    int v = 0;
                    while (v < numV) {
                        this.m_lineDir[i][v].getDirection(baryDir);
                        PdVector vector = this.m_alignmentField[i].getVector(v);
                        PwBary.getVector((PdVector)vector, (PgElementSet)this.m_geomBase, (PdBaryDir)baryDir);
                        double geodValue = this.getGeodValue(i, v);
                        vector.setLength(1.0 - geodValue);
                        ++v;
                    }
                    if (allocate) {
                        this.m_polies[i].addVectorField(this.m_alignmentField[i]);
                    }
                    this.m_polies[i].update((Object)this.m_polies[i]);
                }
                ++i;
            }
        } else if (this.m_alignmentField != null) {
            int i = 0;
            while (i < this.m_numPolies) {
                if (this.m_processPoly.m_data[i]) {
                    this.m_polies[i].removeVectorField((PgGeometryIf)this.m_alignmentField[i]);
                    this.m_polies[i].update((Object)this.m_polies[i]);
                }
                ++i;
            }
            this.m_alignmentField = null;
        }
    }

    public void setGeodValue(double threshold, PdVector[] elementCurvatureValues) {
        this.m_threshold = threshold;
        this.m_elementCurvatureValues = elementCurvatureValues;
    }

    private double getGeodValue(int polyInd, int vertInd) {
        if (this.m_elementCurvatureValues == null) {
            return this.m_alignGeod.getValue();
        }
        PdBary bary = this.m_polies[polyInd].getVertexBary(vertInd);
        int e = bary.getElementInd();
        PdVector curv = this.m_elementCurvatureValues[e];
        double max = curv.m_data[0];
        double min = curv.m_data[1];
        double value = min < 0.0 && max > 0.0 || min > 0.0 && max < 0.0 ? 0.0 : (Math.abs(min) >= Math.abs(max) * 0.4 || Math.abs(max) < this.m_threshold ? 1.0 : Math.abs(min) * 2.5 / Math.abs(max));
        return 1.0 - (1.0 - value) * (1.0 - this.m_alignGeod.getValue());
    }

    public void step(boolean removeEdges, boolean resample) {
        this.step(this.m_stepSize.getValue(), removeEdges, resample);
    }

    public void step(int numSteps, int updates, boolean removeEdges, int resample) {
        if (resample <= 0) {
            this.step(numSteps, updates, removeEdges, false);
            return;
        }
        int sum = 0;
        this.m_progressBar.start();
        while (sum < numSteps) {
            double d = 1.0 * (double)Math.min(numSteps - sum, resample) / (double)numSteps;
            this.m_progressBar.setSubInterval(1.0 * (double)sum / (double)numSteps, 1.0 * (double)sum / (double)numSteps + d);
            this.step(Math.min(numSteps - sum, resample), updates, removeEdges, true);
            sum += resample;
        }
        this.m_progressBar.stop();
    }

    public boolean step(int numSteps, int updates, boolean removeEdges, boolean resample) {
        return this.step(numSteps, this.m_stepSize.getValue(), updates, removeEdges ? 1 : 0, resample);
    }

    public void step(double stepSize, boolean removeEdges, boolean resample) {
        this.step(1, stepSize, 0, removeEdges ? 1 : 0, resample);
    }

    public boolean step(int numSteps, double stepSize, int updates, int removeEdges, boolean resample) {
        int j;
        this.m_progressBar.start();
        if (resample) {
            this.m_progressBar.setSubInterval(0.0, 0.5);
            this.resample();
            this.m_progressBar.setSubInterval(0.5, 1.0);
        }
        this.m_progressBar.start();
        boolean constrain = this.m_constrainGradient.getState();
        int lastUpdate = 0;
        int i = 0;
        while (i < numSteps) {
            this.m_progressBar.setProgress(1.0 * (double)i / (double)numSteps);
            if (!this.step_(this.m_stepSize.getValue(), constrain, removeEdges > 0 && i % removeEdges == 0)) {
                return false;
            }
            if (++lastUpdate == updates) {
                int j2 = 0;
                while (j2 < this.m_numPolies) {
                    if (this.m_processPoly.m_data[j2]) {
                        this.m_polies[j2].update((Object)this.m_polies[j2]);
                    }
                    ++j2;
                }
                this.update(this);
                lastUpdate = 0;
            }
            ++i;
        }
        int p = 0;
        while (p < this.m_numPolies) {
            if (this.m_polies[p] != null) {
                if (this.m_processPoly.m_data[p]) {
                    this.m_polies[p].clearTag(1);
                } else {
                    this.m_polies[p].setTag(1);
                }
            }
            ++p;
        }
        if (updates == 0 || lastUpdate != 0) {
            j = 0;
            while (j < this.m_numPolies) {
                if (this.m_processPoly.m_data[j]) {
                    this.m_polies[j].update((Object)this.m_polies[j]);
                    this.update(this);
                }
                ++j;
            }
        }
        if (this.m_showGradient.getState()) {
            this.updateFlowVectors(constrain);
            j = 0;
            while (j < this.m_numPolies) {
                if (this.m_processPoly.m_data[j]) {
                    this.m_flowField[j].update((Object)this.m_flowField[j]);
                }
                ++j;
            }
        }
        if (this.m_showAlignmentVectors.getState()) {
            this.showAlignmentField(true);
            j = 0;
            while (j < this.m_numPolies) {
                if (this.m_processPoly.m_data[j]) {
                    this.m_alignmentField[j].update((Object)this.m_alignmentField[j]);
                }
                ++j;
            }
        }
        this.m_progressBar.stop();
        this.m_progressBar.stop();
        return true;
    }

    private boolean step_(double stepSize, boolean constrain, boolean removeEdges) {
        if (this.m_geomBase == null || this.m_polies == null || this.m_variation == null) {
            PsDebug.warning((String)"No surface, polygon or energy set");
            return false;
        }
        int polyInd = 0;
        while (polyInd < this.m_numPolies) {
            if (this.m_processPoly.m_data[polyInd] && this.m_polies[polyInd] != null && this.m_geomBase == this.m_polies[polyInd].getGeometry() && removeEdges) {
                this.removeInvalidEdges(polyInd);
            }
            ++polyInd;
        }
        this.generateFlowVectors(constrain);
        polyInd = 0;
        while (polyInd < this.m_numPolies) {
            if (this.m_processPoly.m_data[polyInd] && this.m_polies[polyInd] != null && this.m_geomBase == this.m_polies[polyInd].getGeometry()) {
                int num = this.m_polies[polyInd].getNumVertices();
                PdBary outPoint = new PdBary(3);
                int v = 0;
                while (v < num) {
                    this.m_lineDirTmp.copy((PnLineDirIf)this.m_lineDir[polyInd][v]);
                    if (constrain) {
                        this.m_lineDir[polyInd][v].setGeodesic(0.0);
                    } else {
                        this.m_lineDir[polyInd][v].setGeodesic(1.0);
                        this.m_lineDir[polyInd][v].setActVector(this.m_flowVectorsBary[polyInd][v]);
                    }
                    if (!PwShootLines.shootLine((PgElementSet)this.m_geomBase, (PdBary)this.m_polies[polyInd].getVertexBary(v), (PnLineDirIf)this.m_lineDir[polyInd][v], (double)(stepSize * this.m_gradient[polyInd].m_data[v]), null, (PdBary)outPoint)) {
                        this.m_lineDir[polyInd][v].copy((PnLineDirIf)this.m_lineDirTmp);
                        this.m_polies[polyInd].setTagVertex(v, 1);
                    } else if (this.m_allowedFaces == null || this.m_allowedFaces[outPoint.getElementInd()]) {
                        this.m_polies[polyInd].setVertexBary(v, outPoint);
                    } else {
                        this.fixPolygon(polyInd);
                        break;
                    }
                    ++v;
                }
                v = 0;
                while (v < num) {
                    this.m_lineDir[polyInd][v].setGeodesic(0.0);
                    ++v;
                }
            }
            ++polyInd;
        }
        return true;
    }

    @Override
    public void run() {
        this.step(this.m_numSteps, 0, true, true);
    }

    /*
     * Unable to fully structure code
     */
    private void removeInvalidEdges(int polyInd) {
        poly = this.m_polies[polyInd];
        num = poly.getNumVertices();
        numMarked = 0;
        pv = 0;
        v = 1;
        while (v < num - 1) {
            sqrLen = poly.getVertex(pv).sqrDist(poly.getVertex(v));
            if (sqrLen <= 1.0E-4) {
                poly.setTagVertex(v, 2);
                ++numMarked;
            } else {
                vertex = poly.getVertex(v);
                next = poly.getVertex(v + 1);
                prev = poly.getVertex(pv);
                this.m_lineDir[polyInd][v].getDirection(this.m_tmpBary);
                PwBary.getVector((PdVector)this.m_tmp3, (PgElementSet)this.m_geomBase, (PdBaryDir)this.m_tmpBary);
                c1 = this.m_tmp3.sqrLength() * (prev.dot(vertex) + next.dot(vertex) - vertex.dot(vertex) - prev.dot(next));
                c2 = (next.dot(this.m_tmp3) - vertex.dot(this.m_tmp3)) * (vertex.dot(this.m_tmp3) - prev.dot(this.m_tmp3));
                if (c1 - c2 < 0.0) {
                    poly.setTagVertex(v, 2);
                    ++numMarked;
                } else {
                    poly.clearTagVertex(v, 2);
                    pv = v;
                }
            }
            ++v;
        }
        pos = 0;
        v = 0;
        ** GOTO lbl41
        {
            ++pos;
            do {
                if (poly.hasTagVertex(pos, 2)) continue block1;
                if (pos != v) {
                    poly.setVertexBary(v, poly.getVertexBary(pos));
                    poly.clearTagVertex(v, 2);
                    this.m_lineDir[polyInd][v] = this.m_lineDir[polyInd][pos];
                }
                ++pos;
                ++v;
lbl41:
                // 2 sources

            } while (v < num - numMarked);
        }
        poly.setNumVertices(num - numMarked);
    }

    private void updateFlowVectors(boolean constraint) {
        this.generateFlowVectors(constraint);
        int i = 0;
        while (i < this.m_numPolies) {
            if (this.m_processPoly.m_data[i]) {
                int num = this.m_polies[i].getNumVertices();
                int v = 1;
                while (v < num - 1) {
                    PwBary.getVector((PdVector)this.m_flowField[i].getVector(v), (PgElementSet)this.m_geomBase, (PdBaryDir)this.m_flowVectorsBary[i][v]);
                    ++v;
                }
            }
            ++i;
        }
    }

    private void generateFlowVectors(boolean constraint) {
        int numVertices;
        int i;
        if (this.m_gradient == null || this.m_gradient.length != this.m_numPolies) {
            this.m_gradient = new PdVector[this.m_numPolies];
        }
        if (this.m_flowVectorsBary == null || this.m_flowVectorsBary.length != this.m_numPolies) {
            this.m_flowVectorsBary = new PdBaryDir[this.m_numPolies][];
        }
        if (this.m_frameVectorsBary == null) {
            this.m_frameVectorsBary = new PdBaryDir[this.m_numPolies][];
            i = 0;
            while (i < this.m_numPolies) {
                if (this.m_processPoly.m_data[i]) {
                    numVertices = this.m_polies[i].getNumVertices();
                    this.m_frameVectorsBary[i] = new PdBaryDir[numVertices];
                    int v = 0;
                    while (v < numVertices) {
                        this.m_frameVectorsBary[i][v] = new PdBaryDir(3);
                        ++v;
                    }
                }
                ++i;
            }
        }
        int polyInd = 0;
        while (polyInd < this.m_numPolies) {
            if (this.m_processPoly.m_data[polyInd]) {
                int num = this.m_polies[polyInd].getNumVertices();
                if (this.m_gradient[polyInd] == null || this.m_gradient[polyInd].getSize() != num) {
                    this.m_gradient[polyInd] = new PdVector(num);
                }
                if (this.m_flowVectorsBary[polyInd] == null || this.m_flowVectorsBary[polyInd].length != num) {
                    this.m_flowVectorsBary[polyInd] = PdBaryDir.realloc((PdBaryDir[])this.m_flowVectorsBary[polyInd], (int)num, (int)3);
                }
                int i2 = 0;
                while (i2 < num) {
                    this.m_flowVectorsBary[polyInd][i2].setZero();
                    this.m_flowVectorsBary[polyInd][i2].setElementInd(-1);
                    ++i2;
                }
            }
            ++polyInd;
        }
        if (this.m_endPointBaries != null) {
            i = 0;
            while (i < this.m_endPointBaries.length) {
                this.m_endPointBaries[i].setZero();
                this.m_endPointBaries[i].setElementInd(-1);
                ++i;
            }
        }
        polyInd = 0;
        while (polyInd < this.m_numPolies) {
            if (this.m_processPoly.m_data[polyInd]) {
                this.generateFlowVectors(polyInd, constraint);
                if (this.m_endPointBaries != null) {
                    int len = this.m_flowVectorsBary[polyInd].length;
                    if (this.m_endPointBaries[this.m_endPoints.m_data[2 * polyInd]].getElementInd() < 0) {
                        this.m_endPointBaries[this.m_endPoints.m_data[2 * polyInd]].copy(this.m_flowVectorsBary[polyInd][0]);
                    } else {
                        PwPolygonFrameFlow.addBaries(this.m_geomBase, this.m_endPointBaries[this.m_endPoints.m_data[2 * polyInd]], this.m_flowVectorsBary[polyInd][0]);
                    }
                    if (this.m_endPointBaries[this.m_endPoints.m_data[2 * polyInd + 1]].getElementInd() < 0) {
                        this.m_endPointBaries[this.m_endPoints.m_data[2 * polyInd + 1]].copy(this.m_flowVectorsBary[polyInd][len - 1]);
                    } else {
                        PwPolygonFrameFlow.addBaries(this.m_geomBase, this.m_endPointBaries[this.m_endPoints.m_data[2 * polyInd + 1]], this.m_flowVectorsBary[polyInd][len - 1]);
                    }
                }
            }
            ++polyInd;
        }
        polyInd = 0;
        while (polyInd < this.m_numPolies) {
            if (this.m_processPoly.m_data[polyInd]) {
                numVertices = this.m_polies[polyInd].getNumVertices();
                if (this.m_endPointBaries != null && !this.m_holdEndPoints.getState()) {
                    this.m_flowVectorsBary[polyInd][0].copy(this.m_endPointBaries[this.m_endPoints.m_data[2 * polyInd]]);
                    this.m_flowVectorsBary[polyInd][numVertices - 1].copy(this.m_endPointBaries[this.m_endPoints.m_data[2 * polyInd + 1]]);
                } else {
                    this.m_flowVectorsBary[polyInd][0].setZero();
                    this.m_flowVectorsBary[polyInd][numVertices - 1].setZero();
                }
            }
            ++polyInd;
        }
    }

    public static void addBaries(PgElementSet geom, PdBaryDir bary, PdBaryDir bary2) {
        int e = bary.getElementInd();
        int e2 = bary2.getElementInd();
        if (e < 0 || e2 < 0) {
            PsDebug.warning((String)"Bary has no element index.");
            return;
        }
        if (e == e2) {
            bary.add(bary2);
            return;
        }
        PdVector dir = new PdVector(3);
        PdVector dir2 = new PdVector(3);
        PwBary.getVector((PdVector)dir, (PgElementSet)geom, (PdBaryDir)bary);
        PwBary.getVector((PdVector)dir2, (PgElementSet)geom, (PdBaryDir)bary2);
        dir.add(dir2);
        PwBary.projectOntoElement((PgElementSet)geom, (int)e, (PdVector)dir, (PdBaryDir)bary);
    }

    private void generateFlowVectors(int polyInd, boolean constraint) {
        int num = this.m_polies[polyInd].getNumVertices();
        int v = 0;
        while (v < num) {
            this.m_lineDir[polyInd][v].getDirection(this.m_frameVectorsBary[polyInd][v]);
            ++v;
        }
        v = 0;
        while (v < num) {
            this.m_variation.evalAmountOfFlow(this.m_polies[polyInd], v, this.m_frameVectorsBary[polyInd], this.getGeodValue(polyInd, v), this.m_tmp2);
            if (constraint) {
                PwBary.getVector((PdVector)this.m_tmp, (PgElementSet)this.m_geomBase, (PdBaryDir)this.m_frameVectorsBary[polyInd][v]);
                this.m_gradient[polyInd].m_data[v] = this.m_tmp2.dot(this.m_tmp);
                this.m_tmpBary.copy(this.m_frameVectorsBary[polyInd][v]);
                this.m_tmpBary.multScalar(this.m_gradient[polyInd].m_data[v]);
                this.m_flowVectorsBary[polyInd][v].copy(this.m_tmpBary);
            } else {
                this.m_gradient[polyInd].m_data[v] = 1.0;
                PwBary.projectOntoElement((PgElementSet)this.m_geomBase, (int)this.m_frameVectorsBary[polyInd][v].getElementInd(), (PdVector)this.m_tmp2, (PdBaryDir)this.m_tmpBary);
                this.m_flowVectorsBary[polyInd][v].copy(this.m_tmpBary);
            }
            ++v;
        }
    }

    public void setStepWidth(double stepWidth) {
        this.m_stepSize.setValue(stepWidth);
    }
}

