/*
 * Decompiled with CFR 0.152.
 */
package devPolygonFrameFlow;

import devCovering.PgFrameField;
import devCovering.PnFrameField;
import devPolygonFrameFlow.PnPolygonSmoothFlow;
import devPolygonFrameFlow.PwPolygonFrameFlow;
import devProjection.PgIntrinsicPolygon;
import devProjection.PnProjection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jv.geom.PgElementSet;
import jv.geom.PgPolygon;
import jv.geom.PgVectorField;
import jv.loader.PgLoader;
import jv.loader.PjImportModel;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;
import jvx.geom.PgPolygonOnElementSet;
import jvx.geom.PwShapeOperator;

public class PjPolygonFrameFlow
extends PjProject
implements ActionListener {
    public static final String DEFAULT_FILE_NAME = "models/byu/Brezel_480.byu";
    protected PjImportModel m_import = new PjImportModel();
    protected PwPolygonFrameFlow m_pwPolygonFrameFlow;
    protected PgElementSet m_geom;

    public PjPolygonFrameFlow() {
        super("EnergyMinimizerForIntrinsicPolygons Project");
        this.m_import.setTypeOfInfoPanel(1);
        this.m_import.addActionListener((ActionListener)this);
        this.m_pwPolygonFrameFlow = new PwPolygonFrameFlow("PolygonFrameFlow workshop");
        this.m_geom = null;
        if (this.getClass() == PjPolygonFrameFlow.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_import.setFileName(DEFAULT_FILE_NAME);
        this.loadGeometry(DEFAULT_FILE_NAME);
    }

    public void setDisplay(PvDisplayIf disp) {
        super.setDisplay(disp);
        this.m_pwPolygonFrameFlow.setDisplay(disp);
        PgPolygon p = new PgPolygon(3);
        p.setNumVertices(2);
        p.setVertex(0, new PdVector(0.1, 0.1, 0.0));
        p.setVertex(1, new PdVector(1.0, 0.0, 0.0));
        PgIntrinsicPolygon curve = new PgIntrinsicPolygon(this.m_geom);
        new PnProjection().projectPolygonOntoElementSet(this.m_geom, p, null, true, curve);
        this.getDisplay().addGeometry((PgGeometryIf)curve);
        this.m_pwPolygonFrameFlow.setPolygon((PgPolygonOnElementSet)curve, true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.loadGeometry(this.m_import.getFileName());
    }

    public void loadGeometry(String filename) {
        PgGeometry[] geomNew = new PgLoader().loadGeometry(null, filename);
        if (geomNew == null || geomNew.length == 0 || geomNew[0] == null) {
            PsDebug.warning((String)("loading failed, file = " + filename));
            return;
        }
        if (geomNew.length > 1) {
            PsDebug.warning((String)("only first geometry used, found = " + geomNew.length));
        }
        this.setGeometry((PgGeometryIf)geomNew[0]);
    }

    public boolean setGeometry(PgGeometryIf geomNew) {
        if (!(geomNew instanceof PgElementSet)) {
            PsDebug.warning((String)"Geometry must be an instance of PgGeometry.");
            return false;
        }
        if (this.m_geom != null) {
            this.removeGeometry((PgGeometryIf)this.m_geom);
        }
        this.m_geom = (PgElementSet)geomNew;
        this.addGeometry((PgGeometryIf)this.m_geom);
        this.selectGeometry((PgGeometryIf)this.m_geom);
        this.m_pwPolygonFrameFlow.setGeometry((PgGeometry)this.m_geom);
        PnPolygonSmoothFlow flow = new PnPolygonSmoothFlow();
        flow.setGeometry(this.m_geom);
        this.m_pwPolygonFrameFlow.setVariation(flow);
        int numElements = this.m_geom.getNumElements();
        PdVector[] elementCurvatureValues = PdVector.realloc(null, (int)numElements, (int)2);
        PgVectorField[] vf = PwShapeOperator.makeElementBasedPrincipalCurvatures((PgElementSet)this.m_geom, (PdVector[])elementCurvatureValues, (boolean)false);
        PgFrameField field = PnFrameField.makeFrameFieldFromVectorFields((PgElementSet)this.m_geom, (PgVectorField)vf[0], (PgVectorField)vf[1], (int)4);
        PnFrameField.makeCovering((PgFrameField)field, (PdVector[])elementCurvatureValues, (int)3);
        this.m_pwPolygonFrameFlow.setFrameField(field);
        return true;
    }
}

