/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.number;

import jv.geom.PgElementSet;
import jv.number.PuComplex;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;

public class PuTransitionFunction {
    public int r_matching;
    public PdVector t_trans;
    protected PgElementSet loc_geom;

    public PuTransitionFunction(PgElementSet geom, int indElt, int locIndexElt) {
        this.loc_geom = geom;
        this.computeParameters(indElt, locIndexElt);
    }

    public PuTransitionFunction() {
        this.t_trans = new PdVector(2);
    }

    public PuTransitionFunction(int matching, PdVector trans) {
        this.r_matching = matching;
        if (trans == null) {
            this.t_trans = new PdVector(2);
        } else {
            this.t_trans = new PdVector(2);
            this.t_trans.copy(trans);
        }
    }

    public void setMatching(int r) {
        this.r_matching = r;
    }

    public void setTranslation(PdVector t) {
        if (t == null || t.getSize() > 2) {
            PsDebug.error((String)"Missing vector in setTranslation()");
        }
        this.t_trans.copy(t);
    }

    private void computeParameters(int indElt, int locIndexElt) {
        PdVector[][] tex = this.loc_geom.getElementTextures();
        PiVector[] neighbor = this.loc_geom.getNeighbours();
        PdVector v_i = tex[indElt][(locIndexElt + 1) % 3];
        PdVector w_i = tex[indElt][(locIndexElt + 2) % 3];
        int locOpp = this.loc_geom.getOppVertexLocInd(indElt, locIndexElt);
        PdVector v_j = tex[neighbor[indElt].m_data[locIndexElt]][(locOpp + 1) % 3];
        PdVector w_j = tex[neighbor[indElt].m_data[locIndexElt]][(locOpp + 2) % 3];
        PuComplex c_v_i = new PuComplex(v_i.m_data[0], v_i.m_data[1]);
        PuComplex c_w_i = new PuComplex(w_i.m_data[0], w_i.m_data[1]);
        PuComplex c_v_j = new PuComplex(v_j.m_data[0], v_j.m_data[1]);
        PuComplex c_w_j = new PuComplex(w_j.m_data[0], w_j.m_data[1]);
        double r = PuComplex.log((PuComplex)c_v_j.sub((PuComplex)c_w_j).div((PuComplex)c_w_i.sub((PuComplex)c_v_i))).im;
        this.r_matching = (int)Math.round(r /= 1.5707963267948966);
        PdVector rot_v_i = PuTransitionFunction._90DegreeRotate(v_i, this.r_matching);
        this.t_trans = PdVector.subNew((PdVector)w_j, (PdVector)rot_v_i);
        if (this.t_trans.length() < 1.0000000000000001E-7) {
            this.t_trans.setConstant(0.0);
        }
    }

    public void inv() {
        this.r_matching = (4 - this.r_matching) % 4;
        int i = 0;
        while (i < 4 - this.r_matching) {
            double x = this.t_trans.getEntry(0);
            this.t_trans.setEntry(0, -this.t_trans.getEntry(1));
            this.t_trans.setEntry(1, x);
            ++i;
        }
        this.t_trans.multScalar(-1.0);
    }

    public void copy(PuTransitionFunction g) {
        if (g == null) {
            PsDebug.error((String)"Missing argument");
            return;
        }
        this.r_matching = g.r_matching;
        this.t_trans.copy(g.t_trans);
    }

    public void concatRight(PuTransitionFunction g) {
        this.t_trans = PuTransitionFunction._90DegreeRotate(this.t_trans, g.r_matching);
        this.t_trans.add(g.t_trans);
        this.r_matching += g.r_matching;
        this.r_matching = PuMath.modulo((int)this.r_matching, (int)4);
    }

    public void concatLeft(PuTransitionFunction g) {
        this.t_trans.add(PuTransitionFunction._90DegreeRotate(g.t_trans, this.r_matching));
        this.r_matching += g.r_matching;
        this.r_matching = PuMath.modulo((int)this.r_matching, (int)4);
    }

    public void eval(PdVector v) {
        if (v == null || v.getSize() != 2) {
            return;
        }
        int i = 0;
        while (i < this.r_matching) {
            double x = v.getEntry(0);
            v.setEntry(0, -v.getEntry(1));
            v.setEntry(1, x);
            ++i;
        }
        v.add(this.t_trans);
    }

    public void evalInvNew(PdVector v) {
        v.sub(this.t_trans);
        if (v.getSize() != 2) {
            return;
        }
        int i = 0;
        while (i < 4 - this.r_matching) {
            double x = v.getEntry(0);
            v.setEntry(0, -v.getEntry(1));
            v.setEntry(1, x);
            ++i;
        }
    }

    public PdVector evalNew(PdVector v) {
        PdVector trans = PdVector.copyNew((PdVector)v);
        if (v == null || v.getSize() != 2) {
            return null;
        }
        int i = 0;
        while (i < this.r_matching) {
            double x = trans.getEntry(0);
            trans.setEntry(0, -trans.getEntry(1));
            trans.setEntry(1, x);
            ++i;
        }
        trans.add(this.t_trans);
        return trans;
    }

    public PdVector[] eval(PdVector[] v) {
        if (v == null) {
            PsDebug.error((String)"Missing vector.");
            return null;
        }
        PdVector[] trans = new PdVector[v.length];
        System.arraycopy(v, 0, trans, 0, v.length);
        int i = 0;
        while (i < v.length) {
            trans[i] = this.evalNew(v[i]);
            ++i;
        }
        return trans;
    }

    public static PdVector _90DegreeRotate(PdVector v, int n) {
        PdVector trans = PdVector.copyNew((PdVector)v);
        if (v == null || v.getSize() != 2) {
            return null;
        }
        int i = 0;
        while (i < n) {
            double x = trans.getEntry(0);
            trans.setEntry(0, -trans.getEntry(1));
            trans.setEntry(1, x);
            ++i;
        }
        return trans;
    }

    public PdVector evalInv(PdVector v) {
        PdVector trans = PdVector.copyNew((PdVector)v);
        trans.sub(this.t_trans);
        if (v == null || v.getSize() != 2) {
            return null;
        }
        int i = 0;
        while (i < 4 - this.r_matching) {
            double x = trans.getEntry(0);
            trans.setEntry(0, -trans.getEntry(1));
            trans.setEntry(1, x);
            ++i;
        }
        return trans;
    }

    public static PuTransitionFunction concat(PuTransitionFunction[] g) {
        PuTransitionFunction comp = new PuTransitionFunction();
        int r = 0;
        int numFunc = g.length;
        int i = 0;
        while (i < numFunc) {
            r += g[i].r_matching;
            ++i;
        }
        r = PuMath.modulo((int)r, (int)4);
        comp.setMatching(r);
        PdVector trans = new PdVector(2);
        int i2 = 0;
        while (i2 < numFunc) {
            int rtmp = 0;
            int j = i2 + 1;
            while (j <= numFunc - 1) {
                rtmp += g[j].r_matching;
                ++j;
            }
            trans.add(PuTransitionFunction._90DegreeRotate(g[i2].t_trans, rtmp));
            ++i2;
        }
        comp.setTranslation(trans);
        return comp;
    }

    public void makeTrivial() {
        this.r_matching = 0;
        this.t_trans.setConstant(0.0);
    }

    public static PuTransitionFunction identity() {
        PuTransitionFunction identity = new PuTransitionFunction(0, null);
        return identity;
    }

    public String toShortString() {
        return "{matching,gap} : {" + this.r_matching + ", (" + this.t_trans.m_data[0] + "," + this.t_trans.m_data[1] + ")";
    }
}

