/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.modules.parameterizer;

import devCovering.PnFrameField;
import devParameterize.covering.PgTextureMapOnCovering;
import devParameterize.geom.PgParamGeom;
import devParameterize.modules.PnModule;
import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PmPositiveOrienter
extends PnModule {
    private double m_step;

    public PmPositiveOrienter() {
        this.setName("Positive Orienter");
        this.setStatusMessage("Fix orientation");
        if (((Object)((Object)this)).getClass() == PmPositiveOrienter.class) {
            this.init();
        }
    }

    @Override
    public void init() {
        super.init();
        this.setEnabled(false);
    }

    @Override
    public boolean start() {
        if (!super.start()) {
            return false;
        }
        if (this.m_geom.getParamTexture() == null) {
            PsDebug.warning((String)"missing param texture.");
            return false;
        }
        this.makePositiveOrientation(true);
        return true;
    }

    public void setGeometry(PgGeometry geom) {
        if (!(geom instanceof PgParamGeom)) {
            PsDebug.warning((String)"Geometry is not parametrized");
            return;
        }
        this.m_geom = (PgParamGeom)geom;
    }

    public boolean makePositiveOrientation(boolean isContinuous) {
        int maxIter = 1000;
        int maxNoGainIter = 1000;
        this.m_step = 2.0E-4 * this.m_geom.getDiameter();
        int noGainIter = 0;
        int firstNumNeg = 0;
        PdVector[][] tex = null;
        PgTextureMapOnCovering texMap = new PgTextureMapOnCovering();
        texMap.setGeometry(this.m_geom);
        if (isContinuous) {
            texMap.setSummand(this.m_geom.getParamTexture());
        } else {
            texMap.setSummand(this.m_geom.getDiscontinuousTexture());
        }
        PiVector[] rotation = texMap.getVertexRotation();
        PdVector uValues = texMap.getUValues();
        PdVector vValues = texMap.getVValues();
        PdVector bestUValues = new PdVector(uValues.getSize());
        PdVector bestVValues = new PdVector(vValues.getSize());
        int bestNumBad = Integer.MAX_VALUE;
        int i = 0;
        while (i < 1000 && !this.isAborted() && noGainIter < 1000) {
            tex = texMap.getTextureValues(tex);
            int numBad = PmPositiveOrienter.markNegativeTriangles((PgElementSet)this.m_geom, tex, this.m_geom.getFrameScaleFactor());
            if (i == 0) {
                firstNumNeg = numBad;
            }
            if (numBad < bestNumBad) {
                bestUValues.copy(uValues);
                bestVValues.copy(vValues);
                bestNumBad = numBad;
                noGainIter = 0;
            } else {
                ++noGainIter;
            }
            if (numBad == 0) break;
            this.fixBadTriangles(tex, rotation, uValues, vValues);
            PsDebug.showStatus((String)("[Fix Orientation] " + firstNumNeg + " --> " + numBad + " bad triangles after iteration " + (i + 1) + "."));
            if (isContinuous) {
                this.m_geom.setParamTexture(tex);
            } else {
                this.m_geom.setDiscontinuousTexture(tex);
            }
            this.m_geom.update((Object)this.m_geom);
            ++i;
        }
        uValues.copy(bestUValues);
        vValues.copy(bestVValues);
        if (isContinuous) {
            this.m_geom.setParamTexture(texMap.getTextureValues(tex));
        } else {
            this.m_geom.setDiscontinuousTexture(texMap.getTextureValues(tex));
        }
        PmPositiveOrienter.markNegativeTriangles((PgElementSet)this.m_geom, tex, this.m_geom.getFrameScaleFactor());
        this.m_geom.update((Object)this.m_geom);
        return true;
    }

    private void fixBadTriangles(PdVector[][] tex, PiVector[] rotation, PdVector uValues, PdVector vValues) {
        int symmetryOrder = this.m_geom.getCovering().getSymmetryOrder();
        PdVector[] v = this.m_geom.getVertices();
        PdVector move = new PdVector(2);
        int e = 0;
        while (e < this.m_geom.getNumElements()) {
            double area = this.m_geom.getAreaOfElement(e);
            int[] elem = this.m_geom.getElement((int)e).m_data;
            int[] vInd = this.m_geom.getElement((int)e).m_data;
            if (this.m_geom.hasTagElement(e, 1)) {
                PdVector[] edge = new PdVector[3];
                PdVector[] Jedge = new PdVector[3];
                edge[0] = PdVector.subNew((PdVector)v[elem[2]], (PdVector)v[elem[1]]);
                edge[1] = PdVector.subNew((PdVector)v[elem[0]], (PdVector)v[elem[2]]);
                edge[2] = PdVector.subNew((PdVector)v[elem[1]], (PdVector)v[elem[0]]);
                Jedge[0] = PdVector.crossNew((PdVector)this.m_geom.getElementNormal(e), (PdVector)edge[0]);
                Jedge[1] = PdVector.crossNew((PdVector)this.m_geom.getElementNormal(e), (PdVector)edge[1]);
                Jedge[2] = PdVector.crossNew((PdVector)this.m_geom.getElementNormal(e), (PdVector)edge[2]);
                int j = 0;
                while (j < 3) {
                    move.setConstant(0.0);
                    int k = 0;
                    while (k < 3) {
                        double dot = PdVector.dot((PdVector)Jedge[k], (PdVector)edge[j]) * this.m_step * 0.5 / area / edge[j].length();
                        move.m_data[0] = move.m_data[0] + tex[e][k].m_data[1] * dot;
                        move.m_data[1] = move.m_data[1] + -tex[e][k].m_data[0] * dot;
                        ++k;
                    }
                    PnFrameField.rot((PdVector)move, (int)(-rotation[e].m_data[j]), (int)symmetryOrder);
                    int n = vInd[j];
                    uValues.m_data[n] = uValues.m_data[n] - move.m_data[0];
                    int n2 = vInd[j];
                    vValues.m_data[n2] = vValues.m_data[n2] - move.m_data[1];
                    ++j;
                }
            }
            ++e;
        }
    }

    public static int markNegativeTriangles(PgElementSet geom, PdVector[][] tex, double scaleFactor) {
        int numNeg = 0;
        int e = 0;
        while (e < geom.getNumElements()) {
            double[] t1 = tex[e][1].m_data;
            double[] t0 = tex[e][0].m_data;
            double[] t2 = tex[e][2].m_data;
            double area = (t1[0] - t0[0]) * (t2[1] - t0[1]) - (t1[1] - t0[1]) * (t2[0] - t0[0]);
            double areaRatio = area / geom.getAreaOfElement(e) / (scaleFactor * scaleFactor) / 2.0;
            if (areaRatio < 0.1) {
                ++numNeg;
                geom.setTagElement(e, 1);
            } else {
                geom.clearTagElement(e, 1);
            }
            ++e;
        }
        return numNeg;
    }
}

