/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.modules.parameterizer;

import devCovering.PgCovering;
import devCovering.PgFrameField;
import devCovering.PnCovering;
import devCovering.PnFrameField;
import devGraph.PgGraphOnElementSet;
import devGraph.PwGraphBuilder;
import devParameterize.apps.PwParameterizerBase;
import devParameterize.covering.PnTopologyOnCovering;
import devParameterize.geom.PgParamGeom;
import devParameterize.modules.PnModule;
import jv.geom.PgElementSet;
import jv.number.PuBoolean;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.rsrc.PsJavaView;
import jv.vecmath.PiVector;

public class PmGraphBuilder
extends PnModule {
    protected PuBoolean m_alignVectors;

    public PmGraphBuilder() {
        this.setName("Graph Builder");
        this.setStatusMessage("Make graph");
        this.m_alignVectors = new PuBoolean("Align vectors", (PsUpdateIf)this, false);
        if (((Object)((Object)this)).getClass() == PmGraphBuilder.class) {
            this.init();
        }
    }

    @Override
    public void init() {
        super.init();
        this.m_alignVectors.init();
    }

    @Override
    public boolean setGeometry(PgParamGeom geom) {
        if (!super.setGeometry(geom)) {
            return false;
        }
        boolean activate = this.m_geom.getCutPaths() == null;
        this.setEnabled(activate);
        return true;
    }

    public boolean update(Object event) {
        if (event == this.m_alignVectors) {
            return true;
        }
        return super.update(event);
    }

    public boolean getAlignVectors() {
        return this.m_alignVectors.getState();
    }

    public void setAlignVectors(boolean alignVectors) {
        this.m_alignVectors.setState(alignVectors);
    }

    @Override
    public boolean start() {
        if (!super.start()) {
            return false;
        }
        if (this.m_geom.getFrameField() == null) {
            PsDebug.warning((String)"missing field.");
            return false;
        }
        PwGraphBuilder graphBuilder = new PwGraphBuilder("GraphBuilder");
        boolean backup = PsJavaView.isEnabledWorkshopBackup();
        PsJavaView.setEnabledWorkshopBackup((boolean)false);
        graphBuilder.setGeometry((PgGeometry)this.m_geom);
        PsJavaView.setEnabledWorkshopBackup((boolean)backup);
        PiVector fixedVertices = new PiVector(0);
        PgCovering covering = this.m_geom.getCovering();
        int symmOrder = covering.getSymmetryOrder();
        PnCovering.filterBranchPoints((PgCovering)covering, (PiVector)fixedVertices, null, (int)symmOrder);
        graphBuilder.setFixedVertices(fixedVertices);
        graphBuilder.start();
        if (this.m_alignVectors.getState() && !this.m_geom.getFixMatching()) {
            PnFrameField.alignVectors((PgFrameField)this.m_geom.getFrameField(), (PgGraphOnElementSet)graphBuilder.getElementTree());
            this.m_geom.setUpdateField(true);
            this.m_geom.setCovering(this.m_geom.getFrameField().getCovering());
        }
        PiVector bridges = new PiVector();
        this.m_geom.setCutPaths(PnTopologyOnCovering.computePathsOnCovering((PgElementSet)this.m_geom, covering, graphBuilder.getCutGraph(), bridges, symmOrder));
        this.m_geom.setBridges(bridges);
        this.m_geom.setElementTree(graphBuilder.getElementTree());
        PwParameterizerBase wParm = this.getParameterizer();
        wParm.setUpdateElementTree(true);
        return true;
    }
}

