/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.modules.parameterizer;

import dev6.numeric.PnCSparseCholesky;
import devCovering.PgCovering;
import devCovering.PgCoveringSurface;
import devCovering.PnFrameField;
import devCovering.PnStiffMatrixOnCovering;
import devParameterize.covering.PgTextureMapOnCovering;
import devParameterize.modules.PnModule;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import jv.geom.PgElementSet;
import jv.number.PuBoolean;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jvx.numeric.PnSparseMatrix;

public class PmGapRounder
extends PnModule {
    private static final double MIN_IMPROVEMENT = 0.97;
    private static final boolean DEFAULT_OPTIMIZE_GAPS = true;
    protected PuBoolean m_optimizeGaps;
    protected PuBoolean m_multiThreading;

    public PmGapRounder() {
        this.setName("Gap Rounder");
        this.setStatusMessage("Round gaps");
        this.m_optimizeGaps = new PuBoolean("Optimize Gaps", (PsUpdateIf)this, true);
        this.m_multiThreading = new PuBoolean("Multithreading", (PsUpdateIf)this, true);
        if (((Object)((Object)this)).getClass() == PmGapRounder.class) {
            this.init();
        }
    }

    @Override
    public void init() {
        super.init();
        this.m_optimizeGaps.init();
        this.m_multiThreading.init();
    }

    @Override
    public boolean start() {
        if (!super.start()) {
            return false;
        }
        if (this.m_geom.getGaps() == null) {
            PsDebug.warning((String)"missing gaps.");
            return false;
        }
        PdVector unroundedGaps = PdVector.copyNew((PdVector)this.m_geom.getGaps());
        PdVector newGaps = PdVector.copyNew((PdVector)this.m_geom.getGaps());
        this.roundGaps(this.m_geom.getGaps(), newGaps);
        this.m_geom.setGaps(newGaps);
        if (this.m_optimizeGaps.getState()) {
            if (this.m_geom.getBridges() == null || this.m_geom.getCutPaths() == null) {
                PsDebug.warning((String)"missing bridges or cut paths.");
                return false;
            }
            this.optimizeGaps(unroundedGaps);
        }
        return true;
    }

    public boolean update(Object event) {
        if (event == this.m_optimizeGaps || event == this.m_multiThreading) {
            return true;
        }
        return super.update(event);
    }

    public boolean getOptimizeGaps() {
        return this.m_optimizeGaps.getState();
    }

    public void setOptimizeGaps(boolean optimizeGaps) {
        this.m_optimizeGaps.setState(optimizeGaps);
    }

    protected void roundGaps(PdVector gaps, PdVector newGaps) {
        if (this.m_geom.getCovering().getSymmetryOrder() == 6) {
            int len = gaps.getSize() / 2;
            newGaps.setSize(2 * len);
            double sqrt3 = Math.sqrt(3.0);
            PdVector[] midPoints = new PdVector[]{new PdVector(0.0, 0.0), new PdVector(sqrt3, 0.0), new PdVector(0.0, 1.0), new PdVector(sqrt3, 1.0), new PdVector(sqrt3 * 0.5, 0.5)};
            PdVector point = new PdVector(2);
            int i = 0;
            while (i < len) {
                point.m_data[0] = gaps.m_data[2 * i] - Math.floor(gaps.m_data[2 * i] / sqrt3) * sqrt3;
                point.m_data[1] = gaps.m_data[2 * i + 1] - Math.floor(gaps.m_data[2 * i + 1]);
                double minDist = Double.MAX_VALUE;
                int nearestPoint = -1;
                int j = 0;
                while (j < 5) {
                    double dist = point.sqrDist(midPoints[j]);
                    if (dist < minDist) {
                        minDist = dist;
                        nearestPoint = j;
                    }
                    ++j;
                }
                newGaps.m_data[2 * i] = midPoints[nearestPoint].m_data[0] + Math.floor(gaps.m_data[2 * i] / sqrt3) * sqrt3;
                newGaps.m_data[2 * i + 1] = midPoints[nearestPoint].m_data[1] + Math.floor(gaps.m_data[2 * i + 1]);
                ++i;
            }
        } else {
            int size = newGaps.getSize();
            int i = 0;
            while (i < size) {
                newGaps.m_data[i] = (int)Math.round(newGaps.m_data[i]);
                ++i;
            }
        }
    }

    protected void optimizeGaps(PdVector unroundedGaps) {
        double oldNorm;
        boolean multiThreading = this.m_multiThreading.getState();
        PdVector roundedGaps = this.m_geom.getGaps();
        PdVector gaps = PdVector.subNew((PdVector)roundedGaps, (PdVector)unroundedGaps);
        final double[][] ctg = PmGapRounder.computeCotangents((PgElementSet)this.m_geom);
        final PdVector[] gridSteps = this.getGridSteps(this.m_geom.getCovering().getSymmetryOrder());
        int numGaps = unroundedGaps.getSize() / 2;
        int numSteps = gridSteps.length;
        int numCopies = multiThreading ? numSteps : 1;
        final PgTextureMapOnCovering[] texMap = new PgTextureMapOnCovering[numSteps];
        final PdVector[] gapsCopies = new PdVector[numCopies];
        int i = 0;
        while (i < numCopies) {
            texMap[i] = new PgTextureMapOnCovering();
            texMap[i].setGeometry(this.m_geom);
            texMap[i].setCutPaths(this.m_geom.getCutPaths(), this.m_geom.getBridges(), this.m_geom.getSharpConstraints());
            gapsCopies[i] = new PdVector(gaps.getSize());
            ++i;
        }
        PnSparseMatrix sm = PnStiffMatrixOnCovering.computeStiffnessMatrix((PgElementSet)this.m_geom, (PgCovering)this.m_geom.getCovering(), (PiVector[])texMap[0].getVertexRotation(), (boolean)true, null);
        sm.addDiagonal(1.0E-12);
        final PnCSparseCholesky.PnCSparseCholeskyFactor cholFact = PnCSparseCholesky.solve(sm, null, null);
        PdVector potential = PmGapRounder.computeLaplaceOfGaps(texMap[0], gaps, ctg, cholFact);
        double current = oldNorm = PmGapRounder.computeDirichletEnergy(texMap[0], potential.m_data, ctg);
        double beforeLoop = oldNorm;
        double afterLoop = 0.0;
        int iterations = 0;
        while (afterLoop < 0.97 * beforeLoop && !this.isAborted()) {
            beforeLoop = current;
            int i2 = 0;
            while (i2 < numGaps) {
                if (!multiThreading) {
                    int j = 0;
                    while (j < numSteps) {
                        int n = 2 * i2;
                        gaps.m_data[n] = gaps.m_data[n] + gridSteps[j].m_data[0];
                        int n2 = 2 * i2 + 1;
                        gaps.m_data[n2] = gaps.m_data[n2] + gridSteps[j].m_data[1];
                        PdVector coord = PmGapRounder.computeLaplaceOfGaps(texMap[0], gaps, ctg, cholFact);
                        double after = PmGapRounder.computeDirichletEnergy(texMap[0], coord.m_data, ctg);
                        if (after < current) {
                            int n3 = 2 * i2;
                            roundedGaps.m_data[n3] = roundedGaps.m_data[n3] + gridSteps[j].m_data[0];
                            int n4 = 2 * i2 + 1;
                            roundedGaps.m_data[n4] = roundedGaps.m_data[n4] + gridSteps[j].m_data[1];
                            current = after;
                        } else {
                            int n5 = 2 * i2;
                            gaps.m_data[n5] = gaps.m_data[n5] - gridSteps[j].m_data[0];
                            int n6 = 2 * i2 + 1;
                            gaps.m_data[n6] = gaps.m_data[n6] - gridSteps[j].m_data[1];
                        }
                        ++iterations;
                        ++j;
                    }
                    this.showStatus(iterations, oldNorm, current, "");
                } else {
                    final int index = i2;
                    PdVector result = new PdVector(numSteps);
                    Future[] future = new Future[numSteps];
                    int j = 0;
                    while (j < numSteps) {
                        final int jj = j;
                        gapsCopies[j].copyArray(gaps);
                        future[j] = this.getParameterizer().getThreadPool().submit(new Callable<Double>(){

                            @Override
                            public Double call() {
                                double uStep = gridSteps[jj].m_data[0];
                                double vStep = gridSteps[jj].m_data[1];
                                int n = 2 * index;
                                gapsCopies[jj].m_data[n] = gapsCopies[jj].m_data[n] + uStep;
                                int n2 = 2 * index + 1;
                                gapsCopies[jj].m_data[n2] = gapsCopies[jj].m_data[n2] + vStep;
                                PdVector coord = PmGapRounder.computeLaplaceOfGaps(texMap[jj], gapsCopies[jj], ctg, cholFact);
                                double norm = PmGapRounder.computeDirichletEnergy(texMap[jj], coord.m_data, ctg);
                                int n3 = 2 * index;
                                gapsCopies[jj].m_data[n3] = gapsCopies[jj].m_data[n3] - uStep;
                                int n4 = 2 * index + 1;
                                gapsCopies[jj].m_data[n4] = gapsCopies[jj].m_data[n4] - vStep;
                                return new Double(norm);
                            }
                        });
                        ++j;
                    }
                    try {
                        j = 0;
                        while (j < numSteps) {
                            result.m_data[j] = (Double)future[j].get();
                            this.showStatus(iterations++, oldNorm, current, "");
                            ++j;
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                    if (result.min() < current) {
                        j = result.indexOfMin();
                        int n = 2 * i2;
                        gaps.m_data[n] = gaps.m_data[n] + gridSteps[j].m_data[0];
                        int n7 = 2 * i2 + 1;
                        gaps.m_data[n7] = gaps.m_data[n7] + gridSteps[j].m_data[1];
                        int n8 = 2 * i2;
                        roundedGaps.m_data[n8] = roundedGaps.m_data[n8] + gridSteps[j].m_data[0];
                        int n9 = 2 * i2 + 1;
                        roundedGaps.m_data[n9] = roundedGaps.m_data[n9] + gridSteps[j].m_data[1];
                        current = result.m_data[j];
                    }
                }
                ++i2;
            }
            afterLoop = current;
        }
    }

    public static double[][] computeCotangents(PgElementSet geom) {
        double[][] ctg = new double[geom.getNumElements()][3];
        PdVector[] v = geom.getVertices();
        int e = 0;
        while (e < geom.getNumElements()) {
            PiVector elem = geom.getElement(e);
            double a = PdVector.dist((PdVector)v[elem.m_data[1]], (PdVector)v[elem.m_data[2]]);
            double b = PdVector.dist((PdVector)v[elem.m_data[0]], (PdVector)v[elem.m_data[2]]);
            double c = PdVector.dist((PdVector)v[elem.m_data[0]], (PdVector)v[elem.m_data[1]]);
            PuMath.ctg((double[])ctg[e], (double)a, (double)b, (double)c);
            ++e;
        }
        return ctg;
    }

    protected PdVector[] getGridSteps(int symmetryOrder) {
        switch (symmetryOrder) {
            case 6: {
                double sqrt3 = Math.sqrt(3.0);
                return new PdVector[]{new PdVector(0.0, 1.0), new PdVector(sqrt3, 0.0), new PdVector(-sqrt3, 0.0), new PdVector(0.0, -1.0), new PdVector(-sqrt3, -1.0), new PdVector(sqrt3, -1.0), new PdVector(-sqrt3, 1.0), new PdVector(sqrt3, 1.0)};
            }
            case 4: {
                return new PdVector[]{new PdVector(0.0, 1.0), new PdVector(1.0, 0.0), new PdVector(-1.0, 0.0), new PdVector(0.0, -1.0)};
            }
        }
        PsDebug.warning((String)"Symmetry order not supported yet.");
        return null;
    }

    protected static PdVector computeLaplaceOfGaps(PgTextureMapOnCovering texMap, PdVector gaps, double[][] ctg, PnCSparseCholesky.PnCSparseCholeskyFactor cholFact) {
        PgCoveringSurface geom = texMap.getGeometry();
        int numLayers = geom.getCovering().getSymmetryOrder();
        PdVector tGaps = PdVector.copyNew((PdVector)gaps);
        texMap.makeValidGapsAndConstraintValues(tGaps);
        texMap.makeSummandFromGaps(tGaps);
        tGaps = null;
        PdVector rv = new PdVector(2 * geom.getNumVertices());
        int numElements = geom.getNumElements();
        PiVector[] vertexRotation = texMap.getVertexRotation();
        PdVector[] uSum = texMap.getUSummand();
        PdVector[] vSum = texMap.getVSummand();
        PdVector tmpi = new PdVector(2);
        PdVector tmpj = new PdVector(2);
        PdVector tmp = new PdVector(2);
        int e = 0;
        while (e < numElements) {
            int[] elem = geom.getElement((int)e).m_data;
            int k = 0;
            while (k < 3) {
                int rj;
                int i = (k + 1) % 3;
                int j = (k + 2) % 3;
                tmp.set(ctg[e][k] * (uSum[e].m_data[i] - uSum[e].m_data[j]), ctg[e][k] * (vSum[e].m_data[i] - vSum[e].m_data[j]));
                int ri = vertexRotation[e].m_data[i];
                if (ri != Integer.MAX_VALUE) {
                    PnFrameField.rot((PdVector)tmp, (int)(-ri), (int)numLayers, (PdVector)tmpi);
                    int n = 2 * elem[i];
                    rv.m_data[n] = rv.m_data[n] - tmpi.m_data[0];
                    int n2 = 2 * elem[i] + 1;
                    rv.m_data[n2] = rv.m_data[n2] - tmpi.m_data[1];
                }
                if ((rj = vertexRotation[e].m_data[j]) != Integer.MAX_VALUE) {
                    PnFrameField.rot((PdVector)tmp, (int)(-rj), (int)numLayers, (PdVector)tmpj);
                    int n = 2 * elem[j];
                    rv.m_data[n] = rv.m_data[n] + tmpj.m_data[0];
                    int n3 = 2 * elem[j] + 1;
                    rv.m_data[n3] = rv.m_data[n3] + tmpj.m_data[1];
                }
                ++k;
            }
            ++e;
        }
        PdVector coord = new PdVector(2 * geom.getNumVertices());
        PnCSparseCholesky.solveUseFactorization(cholFact, coord, rv);
        return coord;
    }

    public static double computeDirichletEnergy(PgTextureMapOnCovering texMap, double[] coord, double[][] ctg) {
        PiVector[] vertexRotation = texMap.getVertexRotation();
        PdVector[] uSum = texMap.getUSummand();
        PdVector[] vSum = texMap.getVSummand();
        PdVector tmp = new PdVector(2);
        PgCoveringSurface geom = texMap.getGeometry();
        int numLayers = geom.getCovering().getSymmetryOrder();
        double sum = 0.0;
        double[] u = new double[3];
        double[] v = new double[3];
        int e = 0;
        while (e < geom.getNumElements()) {
            int[] elem = geom.getElement((int)e).m_data;
            int k = 0;
            while (k < 3) {
                int rot = vertexRotation[e].m_data[k];
                u[k] = uSum[e].m_data[k];
                v[k] = vSum[e].m_data[k];
                if (rot != Integer.MAX_VALUE) {
                    tmp.set(coord[2 * elem[k]], coord[2 * elem[k] + 1]);
                    PnFrameField.rot((PdVector)tmp, (int)rot, (int)numLayers);
                    int n = k;
                    u[n] = u[n] + tmp.m_data[0];
                    int n2 = k;
                    v[n2] = v[n2] + tmp.m_data[1];
                }
                ++k;
            }
            sum += ctg[e][0] * (PuMath.sqr((double)(u[1] - u[2])) + PuMath.sqr((double)(v[1] - v[2])));
            sum += ctg[e][1] * (PuMath.sqr((double)(u[0] - u[2])) + PuMath.sqr((double)(v[0] - v[2])));
            sum += ctg[e][2] * (PuMath.sqr((double)(u[0] - u[1])) + PuMath.sqr((double)(v[0] - v[1])));
            ++e;
        }
        return Math.sqrt(sum / 2.0);
    }

    private void showStatus(int iterations, double initialEnergy, double currEnergy, String extraInfo) {
        PsDebug.showStatus((String)("[Gap Optimization] Iteration: " + iterations + ",    L2 norm of harmonic correction field decreased to " + PuString.toString((double)(100.0 * currEnergy / initialEnergy), (int)1) + "%" + extraInfo));
    }
}

