/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.modules.parameterizer;

import devCovering.PgFrameField;
import devCovering.PnFrameField;
import devGraph.PgGraphOnElementSet;
import devParameterize.covering.PgTextureMapOnCovering;
import devParameterize.covering.PnFrameFieldHodge;
import devParameterize.geom.PgParamGeom;
import devParameterize.modules.PnModule;
import jv.geom.PgElementSet;
import jv.number.PuBoolean;
import jv.number.PuDouble;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PmGapEstimator
extends PnModule {
    protected PuDouble m_scaleFactor;
    protected PuBoolean m_scaleInObjectUnits;
    private double m_diameter = 1.0;

    public PmGapEstimator() {
        this.setName("Gap estimator");
        this.setStatusMessage("Project to curl free part");
        this.m_scaleFactor = new PuDouble("Scale", (PsUpdateIf)this);
        this.m_scaleInObjectUnits = new PuBoolean("Scale relative to object diameter", (PsUpdateIf)this, true);
        this.m_diameter = 1.0;
        if (((Object)((Object)this)).getClass() == PmGapEstimator.class) {
            this.init();
        }
    }

    @Override
    public void init() {
        super.init();
        this.m_scaleFactor.setDefBounds(0.0, 100.0, 1.0, 1.0);
        this.m_scaleFactor.setDefValue(20.0);
        this.m_scaleFactor.init();
        this.m_scaleInObjectUnits.init();
    }

    @Override
    public boolean setGeometry(PgParamGeom geom) {
        if (!super.setGeometry(geom)) {
            return false;
        }
        this.m_diameter = this.m_geom.getDiameter();
        boolean activate = this.m_geom.getDiscontinuousTexture() == null || this.m_geom.getGaps() == null;
        this.setEnabled(activate);
        if (Double.isNaN(this.m_geom.getFrameScaleFactor())) {
            this.m_geom.setFrameScaleFactor(this.getScaleFactor());
        } else {
            this.setScaleFactor(this.m_geom.getFrameScaleFactor());
        }
        return true;
    }

    public boolean update(Object event) {
        if (event == null) {
            return super.update(event);
        }
        if (event == this.m_scaleInObjectUnits) {
            if (this.m_scaleInObjectUnits.getState()) {
                this.m_scaleFactor.setValue(this.m_scaleFactor.getValue() * this.m_diameter);
            } else {
                this.m_scaleFactor.setValue(this.m_scaleFactor.getValue() / this.m_diameter);
            }
            return true;
        }
        if (event == this.m_scaleFactor) {
            this.m_geom.setFrameScaleFactor(this.getScaleFactor());
            return true;
        }
        return super.update(event);
    }

    @Override
    public boolean start() {
        if (!super.start()) {
            return false;
        }
        if (this.m_geom.getFrameField() == null) {
            PsDebug.warning((String)"missing frame field.");
            return false;
        }
        if (this.m_geom.getElementTree() == null) {
            PsDebug.warning((String)"missing element tree.");
            return false;
        }
        if (this.m_geom.getCutPaths() == null || this.m_geom.getBridges() == null) {
            PsDebug.warning((String)"missing paths or bridges.");
            return false;
        }
        PnFrameFieldHodge hodge = new PnFrameFieldHodge();
        hodge.setGeometry((PgElementSet)this.m_geom);
        hodge.setSolver(this.m_geom.getPreferredSolver());
        hodge.setField(this.m_geom.getFrameField());
        PgFrameField curlFreeField = hodge.projectToRotStarFree();
        this.m_geom.setFrameScaleFactor(this.getScaleFactor());
        curlFreeField.multScalar(this.m_geom.getFrameScaleFactor());
        PdVector[][] tex = PnFrameField.integrate((PgElementSet)this.m_geom, (PgFrameField)curlFreeField, (PdVector[][])this.m_geom.getDiscontinuousTexture(), (PgGraphOnElementSet)this.m_geom.getElementTree());
        PdVector[][] texCopy = new PdVector[tex.length][];
        int i = 0;
        while (i < tex.length) {
            texCopy[i] = PdVector.copyNew((PdVector[])tex[i]);
            ++i;
        }
        this.m_geom.scaleTextureForHex(texCopy);
        this.m_geom.setDiscontinuousTexture(texCopy);
        PgTextureMapOnCovering texMap = new PgTextureMapOnCovering();
        texMap.setGeometry(this.m_geom);
        texMap.setSummand(tex);
        int numGaps = this.m_geom.getCutPaths().length;
        PdVector uGaps = new PdVector(numGaps);
        PdVector vGaps = new PdVector(numGaps);
        texMap.computeGaps(this.m_geom.getCutPaths(), this.m_geom.getBridges(), uGaps, vGaps);
        int numC = 0;
        PdVector constraintValues = null;
        if (this.m_geom.getSharpConstraints() != null) {
            this.m_geom.getSharpConstraints().updateConstraints();
            numC = this.m_geom.getSharpConstraints().getNumConstraintsCut();
            PiVector[] elementsRight = this.m_geom.getSharpConstraints().getElementsRight();
            PiVector[] locVertIndsRight = this.m_geom.getSharpConstraints().getLocVertexIndRight();
            constraintValues = new PdVector(2 * numC);
            int i2 = 0;
            while (i2 < numC) {
                if (this.m_geom.getSharpConstraints().isEnabled(i2)) {
                    PdVector cv = tex[elementsRight[i2].m_data[0]][locVertIndsRight[i2].m_data[0]];
                    constraintValues.m_data[2 * i2] = cv.m_data[0];
                    constraintValues.m_data[2 * i2 + 1] = cv.m_data[1];
                }
                ++i2;
            }
        }
        PdVector gaps = PgTextureMapOnCovering.flattenValues(uGaps, vGaps, null);
        if (numC > 0) {
            gaps.setSize(2 * (numGaps + numC));
            System.arraycopy(constraintValues.m_data, 0, gaps.m_data, 2 * numGaps, 2 * numC);
        }
        this.m_geom.setGaps(gaps);
        return true;
    }

    public double getScaleFactor() {
        if (this.m_scaleInObjectUnits.getState()) {
            return this.m_scaleFactor.getValue() / this.m_diameter;
        }
        return this.m_scaleFactor.getValue();
    }

    public void setScaleFactor(double value) {
        if (this.m_scaleInObjectUnits.getState()) {
            this.m_scaleFactor.setValue(value * this.m_diameter);
        } else {
            this.m_scaleFactor.setValue(value);
        }
        this.m_geom.setFrameScaleFactor(this.getScaleFactor());
    }
}

