/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.modules.parameterizer;

import devCovering.PgPathOnCovering;
import devCovering.PnFrameField;
import devParameterize.covering.PgTextureMapOnCovering;
import devParameterize.geom.PgParamGeom;
import devParameterize.modules.PnModule;
import devParameterize.modules.parameterizer.PmGapEstimator;
import java.awt.Color;
import java.util.Vector;
import jv.geom.PgElementSet;
import jv.geom.PgPolygon;
import jv.geom.PgPolygonSet;
import jv.number.PuBoolean;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PvPickEvent;
import jv.project.PvPickListenerIf;
import jv.vecmath.PdBary;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jvx.geom.PgPolygonOnElementSet;
import jvx.geom.PgVertexStar;
import jvx.geom.PwGeodesic;
import org.netlib.lapack.Dgesvd;
import org.netlib.lapack.Dgetrf;
import org.netlib.lapack.Dgetrs;
import org.netlib.util.intW;

public class PmGapEditor
extends PnModule
implements PvPickListenerIf {
    protected final Object m_continueWaiter;
    protected PuInteger m_index;
    protected PuDouble m_gapX;
    protected PuDouble m_gapY;
    protected PdVector m_cutDirection;
    protected PdMatrix m_matrix;
    protected PuDouble m_cutDirX;
    protected PuDouble m_cutDirY;
    protected PuInteger m_scaleMult;
    private final boolean m_bFullRank = true;
    protected PuBoolean m_bShiftSolution;
    private PgPolygonSet m_cutPaths;

    public PmGapEditor() {
        this.setName("Gap Editor");
        this.m_continueWaiter = new Object();
        this.m_bShiftSolution = new PuBoolean("1/2 Shift Singularities", (PsUpdateIf)this, false);
        if (((Object)((Object)this)).getClass() == PmGapEditor.class) {
            this.init();
        }
    }

    @Override
    public void init() {
        super.init();
        this.m_index = new PuInteger("Path Index");
        this.m_index.setDefBounds(0, 1, 1, 10);
        this.m_index.setDefValue(0);
        this.m_index.init();
        this.m_index.addUpdateListener((PsUpdateIf)this);
        this.m_gapX = new PuDouble("Gap X Value");
        this.m_gapX.setDefBounds(-100.0, 100.0, 1.0, 5.0);
        this.m_gapX.setDefValue(0.0);
        this.m_gapX.init();
        this.m_gapX.addUpdateListener((PsUpdateIf)this);
        this.m_gapY = new PuDouble("Gap Y Value");
        this.m_gapY.setDefBounds(-100.0, 100.0, 1.0, 5.0);
        this.m_gapY.setDefValue(0.0);
        this.m_gapY.init();
        this.m_gapY.addUpdateListener((PsUpdateIf)this);
        this.m_cutDirX = new PuDouble("Cut X Direction");
        this.m_cutDirX.setDefBounds(-100.0, 100.0, 0.5, 1.0);
        this.m_cutDirX.setDefValue(0.0);
        this.m_cutDirX.init();
        this.m_cutDirX.addUpdateListener((PsUpdateIf)this);
        this.m_cutDirY = new PuDouble("Cut Y Direction");
        this.m_cutDirY.setDefBounds(-100.0, 100.0, 0.5, 1.0);
        this.m_cutDirY.setDefValue(0.0);
        this.m_cutDirY.init();
        this.m_cutDirY.addUpdateListener((PsUpdateIf)this);
        this.m_scaleMult = new PuInteger("Scale Multiplier");
        this.m_scaleMult.setDefBounds(1, 10, 1, 1);
        this.m_scaleMult.setDefValue(5);
        this.m_scaleMult.init();
        this.setEnabled(false);
    }

    @Override
    public boolean setGeometry(PgParamGeom geom) {
        if (!super.setGeometry(geom)) {
            return false;
        }
        this.m_cutPaths = null;
        return true;
    }

    @Override
    public boolean start() {
        if (this.m_cutPaths != null) {
            return true;
        }
        int numPaths = this.m_geom.getCutPaths().length;
        this.m_index.setDefBounds(0, numPaths - 1, 1, 10);
        this.m_index.setBounds(0, numPaths - 1);
        this.m_index.setValue(0);
        this.m_index.init();
        this.setGapSliders();
        this.computeMatrix();
        this.gapsToCutDirection();
        this.m_cutPaths = this.showPaths();
        this.m_cutPaths.setTagPolygon(0, 11);
        this.m_cutPaths.update((Object)this.m_cutPaths);
        this.m_display.update((Object)this.m_cutPaths);
        return true;
    }

    private PgPolygonSet showPaths() {
        PgPolygonSet cutPaths = new PgPolygonSet(3);
        cutPaths.showVertices(false);
        cutPaths.setGlobalPolygonColor(new Color(0, 63, 63));
        cutPaths.setGlobalPolygonSize(4.0);
        PgPathOnCovering[] path = this.m_geom.getCutPaths();
        int numPaths = path.length;
        cutPaths.setNumPolygons(numPaths);
        cutPaths.setName("Cut Path");
        int i = 0;
        while (i < numPaths) {
            PiVector index = path[i].getVertexIndices();
            int length = index.getSize();
            int halfLength = (length - 1) / 2;
            PiVector triangleStrip = new PiVector(0);
            int stripLength = 0;
            int j = 0;
            while (j < halfLength) {
                PiVector star = path[i].getElementNeighbours()[j];
                int starSize = star.getSize();
                triangleStrip.setSize(stripLength + starSize);
                int k = 0;
                while (k < starSize - 1) {
                    triangleStrip.m_data[stripLength + k] = star.m_data[k];
                    ++k;
                }
                if (j == halfLength - 1) {
                    triangleStrip.m_data[stripLength + starSize - 1] = star.m_data[starSize - 1];
                    ++stripLength;
                }
                stripLength += starSize - 1;
                ++j;
            }
            int index0 = triangleStrip.m_data[0];
            PdBary bary0 = new PdBary();
            bary0.setElementInd(index0);
            PiVector element = this.m_geom.getElement(index0);
            if (element.m_data[0] == index.m_data[0]) {
                bary0.set(1.0, 0.0, 0.0);
            } else if (element.m_data[1] == index.m_data[0]) {
                bary0.set(0.0, 1.0, 0.0);
            } else {
                bary0.set(0.0, 0.0, 1.0);
            }
            int index1 = triangleStrip.m_data[stripLength - 1];
            PdBary bary1 = new PdBary();
            bary1.setElementInd(index1);
            element = this.m_geom.getElement(index1);
            if (element.m_data[0] == index.m_data[halfLength]) {
                bary1.set(1.0, 0.0, 0.0);
            } else if (element.m_data[1] == index.m_data[halfLength]) {
                bary1.set(0.0, 1.0, 0.0);
            } else {
                bary1.set(0.0, 0.0, 1.0);
            }
            PgPolygonOnElementSet poly = PwGeodesic.getShortest((PgElementSet)this.m_geom, (PdBary)bary0, (int)triangleStrip.m_data[0], (PdBary)bary1, (int)triangleStrip.m_data[stripLength - 1], (PiVector)triangleStrip, null, null, null, null, null, null, null, null, null);
            PgPolygon cp = poly.getPolygon();
            int nv = cp.getNumVertices();
            int nov = cutPaths.getNumVertices();
            cutPaths.setNumVertices(nov + nv);
            PiVector polyIndex = new PiVector(nv);
            int j2 = 0;
            while (j2 < nv) {
                polyIndex.m_data[j2] = nov + j2;
                cutPaths.setVertex(nov + j2, cp.getVertex(j2));
                ++j2;
            }
            cutPaths.setPolygon(i, polyIndex);
            ++i;
        }
        this.m_display.addGeometry((PgGeometryIf)cutPaths);
        this.m_display.selectGeometry((PgGeometryIf)cutPaths);
        this.m_display.update(null);
        this.m_display.addPickListener((PvPickListenerIf)this);
        return cutPaths;
    }

    private void setGapSliders() {
        int index = this.m_index.getValue();
        this.m_gapX.setValue(this.m_geom.getGaps().m_data[2 * index + 0]);
        this.m_gapY.setValue(this.m_geom.getGaps().m_data[2 * index + 1]);
    }

    private void setCutDirSliders() {
        int index = this.m_index.getValue();
        this.m_cutDirX.setValue(this.m_cutDirection.m_data[2 * index + 0]);
        this.m_cutDirY.setValue(this.m_cutDirection.m_data[2 * index + 1]);
    }

    public boolean update(Object event) {
        if (event == this.m_bShiftSolution) {
            this.cutDirectionToGaps();
            this.setGapSliders();
            return true;
        }
        if (event == this.m_index) {
            int selInd = this.m_index.getValue();
            int i = 0;
            while (i < this.m_cutPaths.getNumPolygons()) {
                this.m_cutPaths.clearTagPolygon(i, 11);
                ++i;
            }
            this.m_cutPaths.setTagPolygon(selInd, 11);
            this.m_cutPaths.update((Object)this.m_cutPaths);
            this.m_display.update((Object)this.m_cutPaths);
            this.setGapSliders();
            this.setCutDirSliders();
            return true;
        }
        if (event == this.m_gapX) {
            int index = this.m_index.getValue();
            this.m_geom.getGaps().m_data[2 * index + 0] = this.m_gapX.getValue();
            this.computeMatrix();
            this.gapsToCutDirection();
            this.setCutDirSliders();
            return true;
        }
        if (event == this.m_gapY) {
            int index = this.m_index.getValue();
            this.m_geom.getGaps().m_data[2 * index + 1] = this.m_gapY.getValue();
            this.computeMatrix();
            this.gapsToCutDirection();
            this.setCutDirSliders();
            return true;
        }
        if (event == this.m_cutDirX) {
            int index = this.m_index.getValue();
            this.m_cutDirection.m_data[2 * index + 0] = this.m_cutDirX.getValue();
            this.cutDirectionToGaps();
            this.setGapSliders();
            return true;
        }
        if (event == this.m_cutDirY) {
            int index = this.m_index.getValue();
            this.m_cutDirection.m_data[2 * index + 1] = this.m_cutDirY.getValue();
            this.cutDirectionToGaps();
            this.setGapSliders();
            return true;
        }
        return super.update(event);
    }

    private void gapsToCutDirection() {
        PdVector gap = this.m_geom.getGaps();
        int numPaths = this.m_geom.getCutPaths().length;
        int numGaps = gap.getSize();
        if (numGaps < numPaths) {
            PsDebug.warning((String)"Missing gap variables.");
            return;
        }
        this.m_cutDirection.setConstant(0.0);
        int i = 0;
        while (i < 2 * numPaths) {
            int j = 0;
            while (j < 2 * numPaths) {
                int n = i;
                this.m_cutDirection.m_data[n] = this.m_cutDirection.m_data[n] + this.m_matrix.m_data[i][j] * gap.m_data[j];
                ++j;
            }
            ++i;
        }
        this.setCutDirSliders();
    }

    private void cutDirectionToGaps() {
        int i;
        PdVector gap = this.m_geom.getGaps();
        int numPaths = this.m_geom.getCutPaths().length;
        int numGaps = gap.getSize();
        if (numGaps < numPaths) {
            PsDebug.warning((String)"Missing gap variables.");
            return;
        }
        PdMatrix matrix = PdMatrix.copyNew((PdMatrix)this.m_matrix);
        intW info = new intW(0);
        int n = 2 * numPaths;
        int m = 2 * numPaths;
        double[] a2 = new double[n * m];
        int j = 0;
        while (j < n) {
            int k = 0;
            while (k < m) {
                a2[j + k * n] = 0.0;
                i = 0;
                while (i < 2 * numPaths + 2) {
                    int n2 = j + k * n;
                    a2[n2] = a2[n2] + matrix.m_data[i][j] * matrix.m_data[i][k];
                    ++i;
                }
                ++k;
            }
            ++j;
        }
        int[] ipiv = new int[m];
        Dgetrf.dgetrf((int)n, (int)m, (double[])a2, (int)0, (int)n, (int[])ipiv, (int)0, (intW)info);
        if (info.val != 0) {
            System.err.println("LU failed: " + info.val);
        }
        double[][] b = new double[1][m];
        i = 0;
        while (i < m) {
            b[0][i] = 0.0;
            int j2 = 0;
            while (j2 < 2 * numPaths) {
                double[] dArray = b[0];
                int n3 = i;
                dArray[n3] = dArray[n3] + this.m_cutDirection.m_data[j2] * matrix.m_data[j2][i];
                ++j2;
            }
            if (this.m_bShiftSolution.getState()) {
                double[] dArray = b[0];
                int n4 = i;
                dArray[n4] = dArray[n4] + matrix.m_data[2 * numPaths][i] * 0.5;
                double[] dArray2 = b[0];
                int n5 = i;
                dArray2[n5] = dArray2[n5] + matrix.m_data[2 * numPaths + 1][i] * 0.5;
            }
            ++i;
        }
        String trans = "N";
        Dgetrs.dgetrs((String)trans, (int)n, (int)1, (double[])a2, (int)0, (int)m, (int[])ipiv, (int)0, (double[])b[0], (int)0, (int)m, (intW)info);
        if (info.val != 0) {
            System.err.println("Solving from LU failed: " + info.val);
        }
        int i2 = 0;
        while (i2 < 2 * numPaths) {
            gap.m_data[i2] = Math.round(b[0][i2]);
            ++i2;
        }
        PdVector testCutDirection = new PdVector(2 * numPaths);
        testCutDirection.setConstant(0.0);
        int i3 = 0;
        while (i3 < 2 * numPaths) {
            int j3 = 0;
            while (j3 < 2 * numPaths) {
                int n6 = i3;
                testCutDirection.m_data[n6] = testCutDirection.m_data[n6] + this.m_matrix.m_data[i3][j3] * gap.m_data[j3];
                ++j3;
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < 2 * numPaths) {
            if (testCutDirection.m_data[i3] != this.m_cutDirection.m_data[i3]) {
                int index = i3 / 2;
                String dir = i3 % 2 == 0 ? "u" : "v";
                PsDebug.message((String)("Path " + index + " direction " + dir + " not correct, it is " + testCutDirection.m_data[i3] + " instead of " + this.m_cutDirection.m_data[i3] + "."));
            }
            ++i3;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void computeMatrix() {
        PdVector gap = this.m_geom.getGaps();
        int numGaps = gap.getSize();
        PgPathOnCovering[] path = this.m_geom.getCutPaths();
        int numPaths = path.length;
        this.m_matrix = new PdMatrix(2 * numPaths + 2, 2 * numPaths);
        this.m_cutDirection = new PdVector(2 * numPaths);
        if (numGaps < numPaths) {
            PsDebug.warning((String)"Missing gap variables.");
            return;
        }
        PgTextureMapOnCovering texMap = new PgTextureMapOnCovering();
        texMap.setGeometry(this.m_geom);
        texMap.setCutPaths(this.m_geom.getCutPaths(), this.m_geom.getBridges(), this.m_geom.getSharpConstraints());
        texMap.makeSummandFromGaps(gap);
        Vector softConstraintsInds = new Vector();
        Vector softConstraintsVals = new Vector();
        int symmOrder = this.m_geom.getCovering().getSymmetryOrder();
        int i = 0;
        while (i < numPaths) {
            PiVector locInd;
            PiVector elementIndex;
            PiVector index = path[i].getVertexIndices();
            int length = index.getSize();
            int halfLength = (length - 1) / 2;
            PiVector constrInd = new PiVector(2);
            constrInd.m_data[0] = 2 * numPaths + 2 * i;
            constrInd.m_data[1] = 2 * numPaths + 2 * i + 1;
            PdVector[] constrVal = new PdVector[]{new PdVector(1.0, 0.0), new PdVector(0.0, 1.0)};
            PiVector actSummandInds = null;
            PdVector[] actSummandVals = null;
            PiVector layer = null;
            int starSize = 0;
            int j = 0;
            while (j < halfLength) {
                elementIndex = path[i].getElementNeighbours()[j];
                layer = path[i].getElementLayers()[j];
                locInd = path[i].getVertexLocInd()[j];
                starSize = elementIndex.getSize();
                actSummandInds = texMap.getSymbolicSummandInds()[elementIndex.m_data[0]][locInd.m_data[0]];
                actSummandVals = texMap.getSymbolicSummandVals()[elementIndex.m_data[0]][locInd.m_data[0]];
                if (j == 0) {
                    this.addSoftConstraint(softConstraintsInds, softConstraintsVals, constrInd, constrVal, actSummandInds, actSummandVals, PuMath.modulo((int)layer.m_data[0], (int)(symmOrder / 2)));
                    this.addSoftConstraint(softConstraintsInds, softConstraintsVals, constrInd, constrVal, actSummandInds, actSummandVals, PuMath.modulo((int)(layer.m_data[0] + 1), (int)(symmOrder / 2)));
                } else {
                    int asLen = actSummandInds == null ? 0 : actSummandInds.getSize();
                    int cLen = constrInd == null ? 0 : constrInd.getSize();
                    PiVector diffInds = new PiVector(asLen + cLen);
                    PdVector[] diffVals = new PdVector[asLen + cLen];
                    int k = 0;
                    while (k < asLen) {
                        diffInds.m_data[k] = actSummandInds.m_data[k];
                        diffVals[k] = PdVector.copyNew((PdVector)actSummandVals[k]);
                        diffVals[k].multScalar(-1.0);
                        ++k;
                    }
                    k = 0;
                    while (k < cLen) {
                        diffInds.m_data[asLen + k] = constrInd.m_data[k];
                        diffVals[asLen + k] = PdVector.copyNew((PdVector)constrVal[k]);
                        ++k;
                    }
                    PgVertexStar star = new PgVertexStar();
                    int v = this.m_geom.getElement((int)elementIndex.m_data[0]).m_data[locInd.m_data[0]];
                    star.makeVertexStar((PgElementSet)this.m_geom, v, elementIndex.m_data[0]);
                    PiVector elements = star.getElement();
                    int vrot = texMap.getVertexRotation()[elementIndex.m_data[0]].m_data[locInd.m_data[0]];
                    int dim = diffInds.getSize();
                    int size = star.getSize();
                    int ii = 0;
                    while (ii < size) {
                        int dimSummand;
                        int actE = elements.m_data[ii];
                        int actLocInd = star.getVertexLocInd().m_data[ii];
                        int actVr = texMap.getVertexRotation()[actE].m_data[actLocInd];
                        int n = dimSummand = texMap.getSymbolicSummandInds()[actE][actLocInd] == null ? 0 : texMap.getSymbolicSummandInds()[actE][actLocInd].getSize();
                        if (texMap.getSymbolicSummandInds()[actE][actLocInd] == null) {
                            texMap.getSymbolicSummandInds()[actE][actLocInd] = new PiVector(dim);
                        } else {
                            texMap.getSymbolicSummandInds()[actE][actLocInd].setSize(dimSummand + dim);
                        }
                        texMap.getSymbolicSummandVals()[actE][actLocInd] = PdVector.realloc((PdVector[])texMap.getSymbolicSummandVals()[actE][actLocInd], (int)(dim + dimSummand), (int)2);
                        int jj = 0;
                        while (jj < dim) {
                            texMap.getSymbolicSummandInds()[actE][actLocInd].m_data[dimSummand + jj] = diffInds.m_data[jj];
                            PnFrameField.rot((PdVector)diffVals[jj], (int)(actVr - vrot), (int)symmOrder, (PdVector)texMap.getSymbolicSummandVals()[actE][actLocInd][dimSummand + jj]);
                            ++jj;
                        }
                        ++ii;
                    }
                }
                if (starSize > 1) {
                    constrInd = texMap.getSymbolicSummandInds()[elementIndex.m_data[starSize - 1]][locInd.m_data[starSize - 1]];
                    constrVal = texMap.getSymbolicSummandVals()[elementIndex.m_data[starSize - 1]][locInd.m_data[starSize - 1]];
                }
                ++j;
            }
            elementIndex = path[i].getElementNeighbours()[halfLength];
            layer = path[i].getElementLayers()[halfLength];
            locInd = path[i].getVertexLocInd()[halfLength];
            actSummandInds = texMap.getSymbolicSummandInds()[elementIndex.m_data[0]][locInd.m_data[0]];
            actSummandVals = texMap.getSymbolicSummandVals()[elementIndex.m_data[0]][locInd.m_data[0]];
            this.addSoftConstraint(softConstraintsInds, softConstraintsVals, constrInd, constrVal, actSummandInds, actSummandVals, PuMath.modulo((int)layer.m_data[0], (int)(symmOrder / 2)));
            this.addSoftConstraint(softConstraintsInds, softConstraintsVals, constrInd, constrVal, actSummandInds, actSummandVals, PuMath.modulo((int)(layer.m_data[0] + 1), (int)(symmOrder / 2)));
            PiVector indsStart0 = (PiVector)softConstraintsInds.elementAt(0);
            PdVector valsStart0 = (PdVector)softConstraintsVals.elementAt(0);
            PiVector indsStart1 = (PiVector)softConstraintsInds.elementAt(1);
            PdVector valsStart1 = (PdVector)softConstraintsVals.elementAt(1);
            PiVector indsEnd0 = (PiVector)softConstraintsInds.elementAt(2);
            PdVector valsEnd0 = (PdVector)softConstraintsVals.elementAt(2);
            PiVector indsEnd1 = (PiVector)softConstraintsInds.elementAt(3);
            PdVector valsEnd1 = (PdVector)softConstraintsVals.elementAt(3);
            PdVector equationStart0 = new PdVector(2 * numPaths + 2 * numPaths);
            int j2 = 0;
            while (j2 < indsStart0.getSize()) {
                int n = indsStart0.m_data[j2];
                equationStart0.m_data[n] = equationStart0.m_data[n] + valsStart0.m_data[j2];
                ++j2;
            }
            PdVector equationStart1 = new PdVector(2 * numPaths + 2 * numPaths);
            int j3 = 0;
            while (j3 < indsStart1.getSize()) {
                int n = indsStart1.m_data[j3];
                equationStart1.m_data[n] = equationStart1.m_data[n] + valsStart1.m_data[j3];
                ++j3;
            }
            PdVector equationEnd0 = new PdVector(2 * numPaths + 2 * numPaths);
            int j4 = 0;
            while (j4 < indsEnd0.getSize()) {
                int n = indsEnd0.m_data[j4];
                equationEnd0.m_data[n] = equationEnd0.m_data[n] + valsEnd0.m_data[j4];
                ++j4;
            }
            PdVector equationEnd1 = new PdVector(2 * numPaths + 2 * numPaths);
            int j5 = 0;
            while (j5 < indsEnd1.getSize()) {
                int n = indsEnd1.m_data[j5];
                equationEnd1.m_data[n] = equationEnd1.m_data[n] + valsEnd1.m_data[j5];
                ++j5;
            }
            if (i == 0) {
                PdVector fixPosition0 = PdVector.copyNew((PdVector)equationStart0);
                fixPosition0.setSize(2 * numPaths);
                this.m_matrix.setRow(2 * numPaths, fixPosition0);
                PdVector fixPosition1 = PdVector.copyNew((PdVector)equationStart1);
                fixPosition1.setSize(2 * numPaths);
                this.m_matrix.setRow(2 * numPaths + 1, fixPosition1);
            }
            if (equationStart0.m_data[2 * numPaths + 2 * i] * equationEnd0.m_data[2 * numPaths + 2 * i] != 0.0) {
                equationEnd0.multScalar(equationStart0.m_data[2 * numPaths + 2 * i] / equationEnd0.m_data[2 * numPaths + 2 * i]);
                equationStart0.sub(equationEnd0);
                if (equationStart1.m_data[2 * numPaths + 2 * i + 1] * equationEnd1.m_data[2 * numPaths + 2 * i + 1] == 0.0) {
                    PsDebug.message((String)"Unexpected result of summing symbolic summands.");
                    return;
                }
                equationEnd1.multScalar(equationStart1.m_data[2 * numPaths + 2 * i + 1] / equationEnd1.m_data[2 * numPaths + 2 * i + 1]);
                equationStart1.sub(equationEnd1);
            } else if (equationStart0.m_data[2 * numPaths + 2 * i] * equationEnd1.m_data[2 * numPaths + 2 * i] != 0.0) {
                equationEnd1.multScalar(equationStart0.m_data[2 * numPaths + 2 * i] / equationEnd1.m_data[2 * numPaths + 2 * i]);
                equationStart0.sub(equationEnd1);
                if (equationStart1.m_data[2 * numPaths + 2 * i + 1] * equationEnd0.m_data[2 * numPaths + 2 * i + 1] == 0.0) {
                    PsDebug.message((String)"Unexpected result of summing symbolic summands.");
                    return;
                }
                equationEnd0.multScalar(equationStart1.m_data[2 * numPaths + 2 * i + 1] / equationEnd0.m_data[2 * numPaths + 2 * i + 1]);
                equationStart1.sub(equationEnd0);
            }
            equationStart0.setSize(2 * numPaths);
            this.m_matrix.setRow(2 * i, equationStart0);
            equationStart1.setSize(2 * numPaths);
            this.m_matrix.setRow(2 * i + 1, equationStart1);
            softConstraintsInds.removeAllElements();
            softConstraintsVals.removeAllElements();
            ++i;
        }
    }

    public static void testSVD(PdMatrix matrix) {
        int n = matrix.getNumRows();
        int m = matrix.getNumCols();
        double[] a = new double[n * m];
        int j = 0;
        while (j < n) {
            int k = 0;
            while (k < m) {
                a[j + k * n] = matrix.m_data[j][k];
                ++k;
            }
            ++j;
        }
        double[] singular_values = new double[Math.min(n, m)];
        String jobu = "N";
        String jobvt = "O";
        int lwork = Math.max(3 * Math.min(m, n) + Math.max(m, n), 5 * Math.min(m, n));
        double[] work = new double[lwork];
        intW info = new intW(0);
        Dgesvd.dgesvd((String)jobu, (String)jobvt, (int)n, (int)m, (double[])a, (int)0, (int)n, (double[])singular_values, (int)0, null, (int)0, (int)n, null, (int)0, (int)m, (double[])work, (int)0, (int)lwork, (intW)info);
        if (info.val != 0) {
            System.err.println("SVD orthonormalization failed: " + info.val);
        }
        PdVector sv = new PdVector(singular_values);
        PsDebug.message((String)("SVD result: " + sv.toShortString()));
    }

    private void addSoftConstraint(Vector softConstraintsInds, Vector softConstraintsVals, PiVector constr1Ind, PdVector[] constr1Val, PiVector constr2Ind, PdVector[] constr2Val, int layer) {
        int k;
        int dim1 = constr1Ind == null ? 0 : constr1Ind.getSize();
        int dim2 = constr2Ind == null ? 0 : constr2Ind.getSize();
        PiVector inds = new PiVector(dim1 + dim2);
        PdVector[] vals = new PdVector[dim1 + dim2];
        int k2 = 0;
        while (k2 < dim1) {
            inds.m_data[k2] = constr1Ind.m_data[k2];
            vals[k2] = PdVector.copyNew((PdVector)constr1Val[k2]);
            ++k2;
        }
        k2 = 0;
        while (k2 < dim2) {
            inds.m_data[dim1 + k2] = constr2Ind.m_data[k2];
            vals[dim1 + k2] = PdVector.copyNew((PdVector)constr2Val[k2]);
            vals[dim1 + k2].multScalar(-1.0);
            ++k2;
        }
        if (layer > 0) {
            int symmOrder = this.m_geom.getCovering().getSymmetryOrder();
            k = 0;
            while (k < dim1 + dim2) {
                PnFrameField.rot((PdVector)vals[k], (int)layer, (int)symmOrder);
                ++k;
            }
        }
        PdVector scVals = new PdVector(dim1 + dim2);
        k = 0;
        while (k < dim1 + dim2) {
            scVals.m_data[k] = vals[k].m_data[0];
            ++k;
        }
        softConstraintsInds.addElement(PiVector.copyNew((PiVector)inds));
        softConstraintsVals.addElement(scVals);
        if (layer < 0) {
            scVals = new PdVector(dim1 + dim2);
            k = 0;
            while (k < dim1 + dim2) {
                scVals.m_data[k] = vals[k].m_data[1];
                ++k;
            }
            softConstraintsInds.addElement(PiVector.copyNew((PiVector)inds));
            softConstraintsVals.addElement(scVals);
        }
    }

    public void selectGeometry(PgGeometryIf geom) {
        System.out.println("test3");
    }

    public void pickDisplay(PvPickEvent pos) {
        System.out.println("test4");
    }

    public void dragDisplay(PvPickEvent pos) {
    }

    public void pickInitial(PvPickEvent pos) {
        if (pos.getElementInd() != -1 && this.m_display.getSelectedGeometry() == this.m_cutPaths) {
            int selInd = pos.getElementInd();
            this.m_index.setValue(selInd);
            int i = 0;
            while (i < this.m_cutPaths.getNumPolygons()) {
                this.m_cutPaths.clearTagPolygon(i, 11);
                ++i;
            }
            this.m_cutPaths.setTagPolygon(selInd, 11);
            this.m_cutPaths.update((Object)this.m_cutPaths);
            this.m_display.update((Object)this.m_cutPaths);
            this.setGapSliders();
            this.setCutDirSliders();
        }
    }

    public void dragInitial(PvPickEvent pos) {
    }

    public void pickVertex(PgGeometryIf geom, int index, PdVector vertex) {
    }

    public void dragVertex(PgGeometryIf geom, int index, PdVector vertex) {
    }

    public void markVertices(PvPickEvent pos) {
        System.out.println("test");
    }

    public void unmarkVertices(PvPickEvent pos) {
    }

    public void refine() {
        if (this.m_cutPaths == null) {
            return;
        }
        double curScaleFactor = ((PmGapEstimator)this.getParameterizer().getUsedModuleGlobalID(12)).getScaleFactor();
        ((PmGapEstimator)this.getParameterizer().getUsedModuleGlobalID(12)).setScaleFactor(curScaleFactor * (double)this.m_scaleMult.getValue());
        this.getParameterizer().getUsedModuleGlobalID(12).setEnabled(true);
        this.getParameterizer().startFFExtension();
        this.gapsToCutDirection();
        this.setGapSliders();
        this.setCutDirSliders();
    }

    public void coarsen() {
        if (this.m_cutPaths == null) {
            return;
        }
        double curScaleFactor = ((PmGapEstimator)this.getParameterizer().getUsedModuleGlobalID(12)).getScaleFactor();
        ((PmGapEstimator)this.getParameterizer().getUsedModuleGlobalID(12)).setScaleFactor(curScaleFactor / (double)this.m_scaleMult.getValue());
        int i = 0;
        while (i < this.m_cutDirection.getSize()) {
            this.m_cutDirection.setEntry(i, this.m_cutDirection.getEntry(i) / (double)this.m_scaleMult.getValue());
            ++i;
        }
        this.cutDirectionToGaps();
        this.getParameterizer().startModule(this.getParameterizer().getUsedModuleGlobalID(14));
        this.setGapSliders();
        this.setCutDirSliders();
    }
}

