/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.modules.parameterizer;

import devParameterize.geom.PgParamGeom;
import devParameterize.modules.parameterizer.PmDegenerationDetector;
import devParameterize.modules.parameterizer.PmPositiveOrienter;
import java.awt.Button;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.vecmath.PiVector;

public class PmDegenerationDetector_IP
extends PsPanel
implements ActionListener {
    protected PmDegenerationDetector m_pmDegenerationDetector;
    private Button m_check;

    public PmDegenerationDetector_IP() {
        if (this.getClass() == PmDegenerationDetector_IP.class) {
            this.init();
        }
    }

    public void setParent(PsUpdateIf parent) {
        if (parent == null) {
            return;
        }
        if (!(parent instanceof PmDegenerationDetector)) {
            PsDebug.warning((String)"Parent has to be of type PmPositiveOrienter");
            return;
        }
        this.m_pmDegenerationDetector = (PmDegenerationDetector)parent;
        super.setParent(parent);
        this.makeLayout();
    }

    public void makeLayout() {
        this.removeAll();
        this.m_check = new Button("Check");
        this.m_check.addActionListener(this);
        Panel p = new Panel(new GridLayout(1, 2));
        p.add(this.m_check);
        p.add((Component)this.m_pmDegenerationDetector.m_merge.getInfoPanel());
        this.add(p);
        this.setInsetSize(0);
    }

    public boolean update(Object event) {
        if (this.m_pmDegenerationDetector == null) {
            PsDebug.notify((String)"missing parent");
            return true;
        }
        return super.update(event);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_check) {
            PgParamGeom geom = this.m_pmDegenerationDetector.getGeometry();
            if (geom == null || geom.getCovering() == null || geom.getParamTexture() == null) {
                return;
            }
            int counter = PmPositiveOrienter.markNegativeTriangles((PgElementSet)geom, geom.getParamTexture(), geom.getFrameScaleFactor());
            PiVector bp = this.m_pmDegenerationDetector.getSingularitiesAtMarkedTriangles();
            this.m_pmDegenerationDetector.checkAndMerge(this.m_pmDegenerationDetector.getGeometry(), bp, true, false);
            PsDebug.showStatus((String)(counter + " elements have negative texture orientation."));
        }
    }
}

