/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.modules.parameterizer;

import devCovering.PgPathOnCovering;
import devCovering.PnFrameField;
import devParameterize.geom.PgParamGeom;
import devParameterize.modules.PnModule;
import devParameterize.modules.fieldGenerator.PmVectorAngleSmoother;
import devParameterize.modules.parameterizer.PmPositiveOrienter;
import jv.geom.PgElementSet;
import jv.number.PuBoolean;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgVertexStar;

public class PmDegenerationDetector
extends PnModule {
    protected PuBoolean m_merge;
    private boolean m_merged;

    public PmDegenerationDetector() {
        this.setName("Degeneration Detector");
        this.setStatusMessage("Check degeneration");
        this.m_merge = new PuBoolean("merge", (PsUpdateIf)this, true);
        if (((Object)((Object)this)).getClass() == PmDegenerationDetector.class) {
            this.init();
        }
    }

    @Override
    public void init() {
        super.init();
        this.setEnabled(false);
    }

    @Override
    public boolean start() {
        if (!super.start()) {
            return false;
        }
        if (this.m_geom.getParamTexture() == null) {
            return false;
        }
        this.m_merged = false;
        PgParamGeom geom = this.m_geom;
        int i = 0;
        while (i < geom.getNumVertices()) {
            geom.getVertex(i).setName("");
            ++i;
        }
        int counter = PmPositiveOrienter.markNegativeTriangles((PgElementSet)geom, this.m_geom.getParamTexture(), this.m_geom.getFrameScaleFactor());
        PiVector bp = this.getSingularitiesAtMarkedTriangles();
        this.checkAndMerge(geom, bp, true, this.m_merge.getState());
        PsDebug.showStatus((String)(counter + " elements have negative texture orientation."));
        return true;
    }

    @Override
    public int jumpToModule() {
        if (this.m_merged) {
            return 10;
        }
        return -1;
    }

    protected void checkAndMerge(PgParamGeom geom, PiVector bp, boolean check, boolean merge) {
        int i;
        if (check) {
            i = 0;
            while (i < geom.getNumVertices()) {
                geom.getVertex(i).clearTag(1);
                ++i;
            }
        }
        i = 0;
        while (i < bp.getSize()) {
            if (this.m_geom.getCovering().getBranchPoints().contains(bp.getEntry(i))) {
                PmVectorAngleSmoother smoother = this.getParameterizer().getSmoother();
                PiVector[] paths = smoother.findPaths(this.m_geom.getCovering(), bp.getEntry(i), 3);
                if (paths == null) break;
                int p = 0;
                while (p < paths.length) {
                    PiVector path = paths[p];
                    if (paths[p] == null) break;
                    PdVector coord = this.integratePath(path);
                    if (coord != null) {
                        int v = path.getFirstEntry();
                        int v2 = path.getLastEntry();
                        if (this.m_geom.getCovering().getBranchPoints().contains(v) && this.m_geom.getCovering().getBranchPoints().contains(v2) && coord.length() < 1.0E-5) {
                            if (check) {
                                geom.setTagVertex(v, 1);
                            }
                            if (!merge) break;
                            smoother.applyChange(path, -smoother.getIndex(v));
                            this.m_geom.setUpdateBranchpoints(true);
                            smoother.start();
                            this.m_merged = true;
                            break;
                        }
                    }
                    ++p;
                }
            }
            ++i;
        }
        geom.update((Object)geom);
    }

    private PdVector integratePath(PiVector path) {
        PdVector coord = new PdVector(2);
        PdVector[][] tex = this.m_geom.getParamTexture();
        PiVector el = PgVertexStar.getElementPerVertex((PgElementSet)this.m_geom);
        int i = 0;
        while (i < path.getSize()) {
            PgPathOnCovering poc = new PgPathOnCovering();
            poc.setGeometry((PgElementSet)this.m_geom, this.m_geom.getCovering());
            poc.makePath(path, el);
            PdVector t1 = new PdVector(2);
            PdVector t2 = new PdVector(2);
            PiVector[] pathElements = poc.getElementNeighbours();
            PiVector[] elementLayers = poc.getElementLayers();
            PiVector[] pathLocInd = poc.getVertexLocInd();
            int numLayers = this.m_geom.getCovering().getSymmetryOrder();
            int e = 1;
            while (e < pathElements.length) {
                if (pathElements[e].getSize() == 0) {
                    return null;
                }
                int elem = pathElements[e].getEntry(0);
                int vLocInd = pathLocInd[e].m_data[0];
                int r = elementLayers[e].m_data[0];
                t2 = tex[elem][vLocInd];
                t1 = tex[elem][(vLocInd + 1) % 3];
                PdVector diff = PdVector.subNew((PdVector)t2, (PdVector)t1);
                PnFrameField.rot((PdVector)diff, (int)(-r), (int)numLayers);
                coord.add(diff);
                if (this.m_geom.getElement(elem).getEntry(vLocInd) == path.getLastEntry()) break;
                ++e;
            }
            ++i;
        }
        return coord;
    }

    protected PiVector getSingularitiesAtMarkedTriangles() {
        PiVector bp = this.m_geom.getCovering().getBranchPoints();
        PiVector bpAtMark = new PiVector();
        PgParamGeom geom = this.m_geom;
        int numElements = geom.getNumElements();
        int e = 0;
        while (e < numElements) {
            if (geom.hasTagElement(e, 1)) {
                PiVector element = geom.getElement(e);
                int i = 0;
                while (i < 3) {
                    int v = element.getEntry(i);
                    if (bp.contains(v) && !bpAtMark.contains(v)) {
                        bpAtMark.addEntry(v);
                    }
                    ++i;
                }
            }
            ++e;
        }
        return bpAtMark;
    }

    public boolean update(Object event) {
        if (event == this.m_merge) {
            return true;
        }
        return super.update(event);
    }
}

