/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.modules.parameterizer;

import devParameterize.covering.PgTextureMapOnCovering;
import devParameterize.covering.PnFrameFieldHodge;
import devParameterize.geom.PgSharpConstraints;
import devParameterize.modules.PnModule;
import jv.geom.PgElementSet;
import jv.number.PuBoolean;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jvx.numeric.PnSparseMatrix;

public class PmContinuousMaker
extends PnModule {
    public PuBoolean m_bHarmonify;

    public PmContinuousMaker() {
        this.setName("Continuous Maker");
        this.setStatusMessage("Assure continuity");
        this.m_bHarmonify = new PuBoolean("Make Harmonic");
        if (((Object)((Object)this)).getClass() == PmContinuousMaker.class) {
            this.init();
        }
    }

    @Override
    public void init() {
        super.init();
    }

    public boolean update(Object event) {
        return super.update(event);
    }

    @Override
    public boolean start() {
        if (!super.start()) {
            return false;
        }
        if (this.m_geom.getFrameField() == null) {
            PsDebug.warning((String)"missing frame field");
            return false;
        }
        if (this.m_geom.getCutPaths() == null || this.m_geom.getBridges() == null) {
            PsDebug.warning((String)"Missing paths or bridges.");
            return false;
        }
        if (this.m_geom.getGaps() == null) {
            PsDebug.warning((String)"Missing gaps.");
            return false;
        }
        PgTextureMapOnCovering potential = new PgTextureMapOnCovering();
        potential.setGeometry(this.m_geom);
        potential.setCutPaths(this.m_geom.getCutPaths(), this.m_geom.getBridges(), this.m_geom.getSharpConstraints());
        potential.makeValidGapsAndConstraintValues(this.m_geom.getGaps());
        potential.makeSummandFromGaps(this.m_geom.getGaps());
        PnSparseMatrix constraint = null;
        PdVector constraintRv = null;
        if (this.m_geom.getSharpConstraints() != null) {
            constraint = new PnSparseMatrix();
            constraintRv = new PdVector();
            this.makeDiriBoundaryConditions(potential, this.m_geom.getDiscontinuousTexture(), this.m_geom.getSharpConstraints(), constraint, constraintRv);
        }
        PnFrameFieldHodge hodge = new PnFrameFieldHodge();
        hodge.setGeometry((PgElementSet)this.m_geom);
        hodge.setConstraint(constraint, constraintRv);
        hodge.setSolver(0);
        hodge.setVertexRotation(potential.getVertexRotation());
        hodge.setField(this.m_geom.getFrameField());
        this.m_geom.getFrameField().multScalar(this.m_geom.getFrameScaleFactor());
        hodge.calcDivAndHarmonicPotential(potential);
        this.m_geom.getFrameField().multScalar(1.0 / this.m_geom.getFrameScaleFactor());
        PdVector[][] tex = potential.getTextureValues(this.m_geom.getParamTexture());
        if (this.m_bHarmonify.getState()) {
            tex = PnFrameFieldHodge.harmonify((PgElementSet)this.m_geom, this.m_geom.getCovering(), tex, 0, constraint, constraintRv);
        }
        this.m_geom.scaleTextureForHex(tex);
        this.m_geom.setParamTexture(tex);
        return true;
    }

    private void makeDiriBoundaryConditions(PgTextureMapOnCovering potential, PdVector[][] discontinuousTexture, PgSharpConstraints sharpConstraints, PnSparseMatrix constraint, PdVector constraintRv) {
        int numV = this.m_geom.getNumVertices();
        constraint.setSize(2 * numV, 2 * numV);
        constraintRv.setSize(numV);
        int constrInd = 0;
        int symmOrder = potential.getGeometry().getCovering().getSymmetryOrder();
        PiVector constrVertices = potential.getConstrainedVertices();
        int v = 0;
        while (v < numV) {
            if (constrVertices.m_data[v] != -2) {
                if (constrVertices.m_data[v] == -1) {
                    constraint.addEntry(constrInd, 2 * v, 1.0);
                    constraint.addEntry(++constrInd, 2 * v + 1, 1.0);
                    ++constrInd;
                } else {
                    int layer = constrVertices.m_data[v];
                    PdVector constrDir = PmContinuousMaker.getConstrainedDir(layer, symmOrder);
                    if (constrDir.m_data[0] != 0.0) {
                        constraint.addEntry(constrInd, 2 * v, constrDir.m_data[0]);
                    }
                    if (constrDir.m_data[1] != 0.0) {
                        constraint.addEntry(constrInd, 2 * v + 1, constrDir.m_data[1]);
                    }
                    ++constrInd;
                }
            }
            ++v;
        }
        constraint.setSize(constrInd, 2 * numV);
        constraintRv.setSize(constrInd);
    }

    private static PdVector getConstrainedDir(int layer, int symmOrder) {
        if (symmOrder == 4) {
            if ((layer & 1) > 0) {
                return new PdVector(0.0, 1.0);
            }
            return new PdVector(1.0, 0.0);
        }
        if (symmOrder == 6) {
            int l = PuMath.modulo((int)layer, (int)symmOrder);
            double[] cos = new double[]{1.0, 0.5, -0.5, -1.0, -0.5, 0.5};
            double d = Math.sqrt(3.0) / 2.0;
            double[] sin = new double[]{0.0, d, d, 0.0, -d, -d};
            return new PdVector(cos[l], sin[l]);
        }
        int l = PuMath.modulo((int)layer, (int)symmOrder);
        return new PdVector(Math.cos(Math.PI * 2 * (double)l / (double)symmOrder), Math.sin(Math.PI * 2 * (double)l / (double)symmOrder));
    }
}

