/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.modules.parameterizer;

import devCovering.PgFrameField;
import devParameterize.geom.PgParamGeom;
import devParameterize.geom.PgSharpConstraints;
import devParameterize.modules.PnModule;
import devParameterize.modules.editor.PmCoveringEditor;
import java.awt.Color;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.TreeSet;
import jv.geom.PgElementSet;
import jv.geom.PgPolygonSet;
import jv.geom.PgVectorField;
import jv.number.PuBoolean;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;

public class PmAntiSpiraler
extends PnModule {
    protected static double SAME_SING_EPS = 5.0E-5;
    protected boolean m_bFindExistingLines = true;
    protected PuDouble m_maxJoinDist;
    protected PuDouble m_minJoinRatio;
    protected PuInteger m_maxNoJoints;
    protected PuDouble m_maxErrorGrowth;
    protected PuBoolean m_sortByRatio;
    private int m_countedJoints;
    private PgPolygonSet m_constraintPaths;
    private TreeSet<ConstraintProposal> m_constraintProposals;
    private PiVector m_singularityIndices;
    private ElementInfo[] m_processedElemInfo;
    private PriorityQueue<ElementInfo> m_queue;
    private PdVector[][] m_paramTex;
    private Color[] m_palette;

    public PmAntiSpiraler() {
        this.setName("Anti Spiraling Module");
        this.setStatusMessage("Generating soft constraints for connectable singularities...");
        if (((Object)((Object)this)).getClass() == PmAntiSpiraler.class) {
            this.init();
        }
    }

    @Override
    public void init() {
        super.init();
        this.m_maxJoinDist = new PuDouble("Max. dist to join");
        this.m_maxJoinDist.setDefBounds(0.1, 10.0, 0.1, 1.0);
        this.m_maxJoinDist.setDefValue(1.0);
        this.m_maxJoinDist.init();
        this.m_minJoinRatio = new PuDouble("Min. ratio to join");
        this.m_minJoinRatio.setDefBounds(1.0, 100.0, 0.5, 10.0);
        this.m_minJoinRatio.setDefValue(3.0);
        this.m_minJoinRatio.init();
        this.m_maxNoJoints = new PuInteger("Max. number of joinings");
        this.m_maxNoJoints.setDefBounds(1, 20, 1, 5);
        this.m_maxNoJoints.setDefValue(1);
        this.m_maxNoJoints.init();
        this.m_sortByRatio = new PuBoolean("Sort by largest ratio?");
        this.m_sortByRatio.setDefState(false);
        this.m_sortByRatio.init();
        this.m_maxErrorGrowth = new PuDouble("Max error growth in % (0 means don't check)");
        this.m_maxErrorGrowth.setDefBounds(0.0, 100.0, 0.5, 5.0);
        this.m_maxErrorGrowth.setDefValue(0.0);
        this.m_maxErrorGrowth.init();
        this.m_countedJoints = 0;
        this.setEnabled(false);
    }

    @Override
    public boolean setGeometry(PgParamGeom geom) {
        return super.setGeometry(geom);
    }

    @Override
    public boolean start() {
        if (!super.start()) {
            return false;
        }
        if (this.m_geom.getParamTexture() == null) {
            PsDebug.warning((String)"missing texture data.");
            return false;
        }
        if (this.m_geom.getCovering() == null) {
            PsDebug.warning((String)"missing covering");
            return false;
        }
        if (this.m_geom.getCovering().getBranchPoints() == null) {
            PsDebug.warning((String)"missing singularities");
            return false;
        }
        if (this.m_geom.getCovering().getBranchPoints().getSize() == 0) {
            return true;
        }
        this.m_countedJoints = 0;
        this.antiSpiraling();
        return true;
    }

    public void antiSpiraling() {
        this.setStatusMessage("Starting region growing...");
        this.m_processedElemInfo = new ElementInfo[this.m_geom.getNumElements()];
        this.m_queue = new PriorityQueue<ElementInfo>(10, new SingularityDistanceComparator());
        this.m_singularityIndices = this.m_geom.getCovering().getBranchPoints();
        this.m_paramTex = this.m_geom.getParamTexture();
        this.m_palette = new Color[this.m_singularityIndices.getSize()];
        int i = 0;
        while (i < this.m_palette.length) {
            this.m_palette[i] = Color.getHSBColor((float)(2.5751560882000963 * (double)i), 0.5f, 0.9f);
            ++i;
        }
        int oldShowingColor = this.m_geom.getShowingColor();
        this.m_geom.showColors(4);
        this.m_geom.assureElementColors();
        this.m_geom.showElementColors(true);
        this.m_geom.update((Object)this.m_geom);
        int i2 = 0;
        while (i2 < this.m_singularityIndices.getSize()) {
            int elemId = this.m_geom.getElementWithVertex(this.m_singularityIndices.getEntry(i2));
            ElementInfo info = this.processElement(elemId, -1, this.m_singularityIndices.getEntry(i2), -1);
            this.m_queue.add(info);
            ++i2;
        }
        while (!this.m_queue.isEmpty()) {
            ElementInfo curInfo = this.m_queue.poll();
            PiVector neighbours = this.m_geom.getNeighbour(curInfo.myElemIndex);
            int i3 = 0;
            while (i3 < neighbours.getSize()) {
                if (neighbours.getEntry(i3) > -1 && this.m_processedElemInfo[neighbours.getEntry(i3)] == null) {
                    this.setStatusMessage("Processing element " + neighbours.getEntry(i3));
                    this.m_queue.add(this.processElement(neighbours.getEntry(i3), curInfo.myElemIndex, curInfo.singularityIndex, i3));
                }
                ++i3;
            }
        }
        this.m_geom.update((Object)this.m_geom);
        this.getDisplay().update((Object)this.m_geom);
        this.setStatusMessage("Region growing done, looking for soft constraints");
        this.m_constraintProposals = this.m_sortByRatio.getState() ? new TreeSet<ConstraintProposal>(new ConstraintProposalRatioComparator()) : new TreeSet<ConstraintProposal>(new ConstraintProposalAbsoluteComparator());
        i = 0;
        while (i < this.m_geom.getNumElements()) {
            PiVector neighbours = this.m_geom.getNeighbour(i);
            int j = 0;
            while (j < neighbours.getSize()) {
                if (neighbours.getEntry(j) > -1 && this.m_processedElemInfo[i].singularityIndex != this.m_processedElemInfo[neighbours.getEntry((int)j)].singularityIndex) {
                    this.m_constraintProposals.add(new ConstraintProposal(this.m_geom, this.m_processedElemInfo[i], this.m_processedElemInfo[neighbours.getEntry(j)], j));
                }
                ++j;
            }
            ++i;
        }
        this.m_constraintPaths = this.m_geom.getSharpConstraints() != null ? this.m_geom.getSharpConstraints().getConstraintsAsPolygonSet() : null;
        while (this.m_constraintProposals.size() > 0 && (!this.m_bFindExistingLines && Math.abs(this.m_constraintProposals.first().distance.getEntry(0)) < SAME_SING_EPS || this.isProposalDisabled(this.m_constraintProposals.first()) || this.m_constraintProposals.first().getSmallerDist() > this.m_maxJoinDist.getValue() + SAME_SING_EPS || this.m_constraintProposals.first().getRatio() < this.m_minJoinRatio.getValue() - SAME_SING_EPS)) {
            this.m_constraintProposals.pollFirst();
        }
        if (this.m_constraintProposals.size() == 0) {
            this.onLeave(oldShowingColor);
            return;
        }
        ConstraintProposal bestProp = this.m_constraintProposals.first();
        PiVector path = bestProp.getPath();
        if (this.m_geom.getSharpConstraints() == null) {
            PgSharpConstraints sharpConstraints = new PgSharpConstraints();
            sharpConstraints.setGeometry(this.m_geom);
            this.m_geom.setSharpConstraints(sharpConstraints);
            this.getParameterizer().setUpdateSharpConstraints(true);
        }
        this.m_geom.getSharpConstraints().addConstraint(path);
        this.m_geom.getSharpConstraints().setHard(this.m_geom.getSharpConstraints().getNumConstraints() - 1, false);
        this.m_geom.setGaps(null);
        this.m_geom.setUpdateBranchpoints(true);
        this.m_geom.update((Object)this.m_geom);
        double oldError = 0.0;
        if (this.m_maxErrorGrowth.getValue() > 0.0) {
            oldError = PmAntiSpiraler.computeFFError(this.m_geom);
        }
        this.setStatusMessage("Added constraint, restarting parameterization...");
        this.getParameterizer().abort();
        this.joinSingularity();
        ++this.m_countedJoints;
        double newError = 0.0;
        if (this.m_maxErrorGrowth.getValue() > 0.0 && (newError = PmAntiSpiraler.computeFFError(this.m_geom)) / oldError > 1.0 + this.m_maxErrorGrowth.getValue() / 100.0) {
            this.m_geom.getSharpConstraints().setEnabled(this.m_geom.getSharpConstraints().getNumConstraints() - 1, false);
            this.joinSingularity();
            --this.m_countedJoints;
        }
        if (this.m_countedJoints < this.m_maxNoJoints.getValue()) {
            this.antiSpiraling();
        }
        this.onLeave(oldShowingColor);
    }

    public static double computeFFError(PgParamGeom geom) {
        double errorSum = 0.0;
        int numElements = geom.getNumElements();
        int numFields = geom.getFrameField().getNumFields();
        PgFrameField gradField = PmCoveringEditor.getFrameFieldFromTexture(geom);
        if (gradField.getNumFields() != numFields) {
            PsDebug.warning((String)"Error in number of frame fields!");
        }
        PgVectorField[] gradVectorFields = new PgVectorField[numFields];
        PgVectorField[] origVectorFields = new PgVectorField[numFields];
        int j = 0;
        while (j < numFields) {
            gradVectorFields[j] = gradField.getField(j);
            origVectorFields[j] = geom.getFrameField().getField(j);
            ++j;
        }
        int i = 0;
        while (i < numElements) {
            int j2 = 0;
            while (j2 < numFields) {
                errorSum += PdVector.angle((PdVector)gradVectorFields[j2].getVector(i), (PdVector)origVectorFields[j2].getVector(i)) * geom.getAreaOfElement(i);
                ++j2;
            }
            ++i;
        }
        return errorSum;
    }

    private void onLeave(int oldShowingColor) {
        this.m_geom.showColors(oldShowingColor);
        this.m_parameterizer.setUpdateSharpConstraints(true);
        this.m_geom.updateVisualizations();
        this.m_geom.update((Object)this.m_geom);
        this.getDisplay().update((Object)this.m_geom);
    }

    private boolean isProposalDisabled(ConstraintProposal cp) {
        if (this.m_constraintPaths == null || this.m_geom.getSharpConstraints() == null) {
            return false;
        }
        PiVector cpPath = cp.getPath();
        int numC = this.m_constraintPaths.getNumPolygons();
        int i = 0;
        while (i < numC) {
            PiVector p = this.m_constraintPaths.getPolygon(i);
            if (p.getEntry(0) == cpPath.getEntry(0) && p.getEntry(p.getSize() - 1) == cpPath.getEntry(cpPath.getSize() - 1) || p.getEntry(0) == cpPath.getEntry(cpPath.getSize() - 1) && p.getEntry(p.getSize() - 1) == cpPath.getEntry(0)) {
                PdVector dist = this.computeConstraintDistance(i);
                if (Math.abs(dist.m_data[0]) - cp.distance.m_data[0] < SAME_SING_EPS && Math.abs(dist.m_data[1]) - cp.distance.m_data[1] < SAME_SING_EPS || Math.abs(dist.m_data[0]) - cp.distance.m_data[1] < SAME_SING_EPS && Math.abs(dist.m_data[1]) - cp.distance.m_data[0] < SAME_SING_EPS) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private ElementInfo processElement(int elemIndex, int parentIndex, int singIndex, int elemLocIndex) {
        ElementInfo info = new ElementInfo();
        if (parentIndex >= 0) {
            info.parent = this.m_processedElemInfo[parentIndex];
        }
        info.singularityIndex = singIndex;
        info.myElemIndex = elemIndex;
        info.textureCoords = this.m_paramTex[elemIndex];
        this.m_processedElemInfo[elemIndex] = info;
        PiVector vInds = this.m_geom.getElement(elemIndex);
        if (parentIndex == -1) {
            int i = 0;
            while (i < 3) {
                if (vInds.getEntry(i) == singIndex) {
                    info.singularityCoords = this.m_paramTex[elemIndex][i];
                    info.totalTurns = 0;
                    info.totalGap = new PdVector(0.0, 0.0);
                    break;
                }
                ++i;
            }
        } else {
            info.singularityCoords = this.m_processedElemInfo[parentIndex].singularityCoords;
            int turnTimes = PuMath.modulo((int)this.m_geom.getCovering().getMatching(parentIndex, elemLocIndex), (int)this.m_geom.getCovering().getSymmetryOrder());
            int oldNoTurns = this.m_processedElemInfo[parentIndex].totalTurns;
            info.totalTurns = PuMath.modulo((int)(oldNoTurns + this.m_geom.getCovering().getSymmetryOrder() - turnTimes), (int)this.m_geom.getCovering().getSymmetryOrder());
            int[] mutVertex = PmAntiSpiraler.getMutualVertex((PgElementSet)this.m_geom, elemIndex, parentIndex);
            if (mutVertex == null) {
                PsDebug.warning((String)"Unhandled error in connectivity information.");
            }
            PdVector gap = PmAntiSpiraler.getGap(this.m_geom, this.m_processedElemInfo, elemIndex, parentIndex, elemLocIndex, this.m_paramTex[elemIndex][mutVertex[0]], this.m_paramTex[parentIndex][mutVertex[1]]);
            info.totalGap = PdVector.addNew((PdVector)this.m_processedElemInfo[parentIndex].totalGap, (PdVector)gap);
        }
        this.m_geom.setElementColor(elemIndex, this.m_palette[this.m_singularityIndices.getIndexOf(singIndex)]);
        return info;
    }

    private PdVector computeConstraintDistance(int index) {
        if (this.m_constraintPaths == null || this.m_geom.getSharpConstraints() == null) {
            return null;
        }
        PgSharpConstraints constraints = this.m_geom.getSharpConstraints();
        PiVector elementIndex = constraints.getElementsRight()[index];
        PiVector vertexLocIndex = constraints.getLocVertexIndRight()[index];
        int currEl = elementIndex.m_data[0];
        int totalTurns = 0;
        PdVector singularityCoords = this.m_paramTex[currEl][vertexLocIndex.m_data[0]];
        PdVector totalGap = new PdVector(0.0, 0.0);
        int length = elementIndex.getSize();
        int symmOrder = this.m_geom.getCovering().getSymmetryOrder();
        int i = 1;
        while (i < length) {
            if (currEl != elementIndex.m_data[i]) {
                int locInd = this.m_geom.getNeighbour(currEl).getIndexOf(elementIndex.m_data[i]);
                int turnTimes = PuMath.modulo((int)this.m_geom.getCovering().getMatching(currEl, locInd), (int)symmOrder);
                int newTotalTurns = PuMath.modulo((int)(totalTurns + symmOrder - turnTimes), (int)symmOrder);
                int[] mutVertex = PmAntiSpiraler.getMutualVertex((PgElementSet)this.m_geom, elementIndex.m_data[i], currEl);
                PdVector tex1 = this.m_paramTex[elementIndex.m_data[i]][mutVertex[0]];
                PdVector tex2 = this.m_paramTex[currEl][mutVertex[1]];
                PdVector originCoordsElem = PmAntiSpiraler.quarterRotationLeft(tex1, newTotalTurns);
                PdVector originCoordsParent = PmAntiSpiraler.quarterRotationLeft(tex2, totalTurns);
                PdVector gap = PdVector.subNew((PdVector)originCoordsElem, (PdVector)originCoordsParent);
                totalGap.add(gap);
                totalTurns = newTotalTurns;
                currEl = elementIndex.m_data[i];
            }
            ++i;
        }
        PdVector distance = PmAntiSpiraler.quarterRotationLeft(this.m_paramTex[elementIndex.m_data[length - 1]][vertexLocIndex.m_data[length - 1]], totalTurns);
        distance.sub(totalGap);
        distance.sub(singularityCoords);
        return distance;
    }

    public static PdVector getGap(PgParamGeom geom, ElementInfo[] eInfo, int e1, int e2, int locInd, PdVector tex1, PdVector tex2) {
        int turnTimes = PuMath.modulo((int)geom.getCovering().getMatching(e2, locInd), (int)geom.getCovering().getSymmetryOrder());
        int oldNoTurns = eInfo[e2].totalTurns;
        int totalTurns = PuMath.modulo((int)(oldNoTurns + geom.getCovering().getSymmetryOrder() - turnTimes), (int)geom.getCovering().getSymmetryOrder());
        int[] mutVertex = PmAntiSpiraler.getMutualVertex((PgElementSet)geom, e1, e2);
        if (mutVertex == null) {
            PsDebug.warning((String)"Unhandled error in connectivity information.");
        }
        PdVector originCoordsElem = PmAntiSpiraler.quarterRotationLeft(tex1, totalTurns);
        PdVector originCoordsParent = PmAntiSpiraler.quarterRotationLeft(tex2, oldNoTurns);
        return PdVector.subNew((PdVector)originCoordsElem, (PdVector)originCoordsParent);
    }

    public static PdVector quarterRotationRight(PdVector v, int noTurns) {
        if (noTurns < 0) {
            return PmAntiSpiraler.quarterRotationLeft(v, -noTurns);
        }
        if (v == null || v.getSize() != 2) {
            return null;
        }
        PdVector rot = PdVector.copyNew((PdVector)v);
        int i = 1;
        while (i <= noTurns) {
            double x = rot.getEntry(0);
            rot.setEntry(0, rot.getEntry(1));
            rot.setEntry(1, -x);
            ++i;
        }
        return rot;
    }

    public static PdVector quarterRotationLeft(PdVector v, int noTurns) {
        if (noTurns < 0) {
            return PmAntiSpiraler.quarterRotationRight(v, -noTurns);
        }
        if (v == null || v.getSize() != 2) {
            return null;
        }
        PdVector rot = PdVector.copyNew((PdVector)v);
        int i = 1;
        while (i <= noTurns) {
            double x = rot.getEntry(0);
            rot.setEntry(0, -rot.getEntry(1));
            rot.setEntry(1, x);
            ++i;
        }
        return rot;
    }

    public static PiVector getVertexCorrespondence(PgElementSet geom, int elem1, int elem2) {
        int e1size = geom.getElement(elem1).getSize();
        int e2size = geom.getElement(elem2).getSize();
        PiVector p = new PiVector(e1size);
        int i = 0;
        while (i < e1size) {
            p.setEntry(i, -1);
            int j = 0;
            while (j < e2size) {
                if (geom.getElement(elem1).getEntry(i) == geom.getElement(elem2).getEntry(j)) {
                    p.setEntry(i, j);
                }
                ++j;
            }
            ++i;
        }
        return p;
    }

    public static int[] getMutualVertex(PgElementSet geom, int elem1, int elem2) {
        if (elem1 >= geom.getNumElements() || elem2 >= geom.getNumElements()) {
            return null;
        }
        int e1size = geom.getElement(elem1).getSize();
        int e2size = geom.getElement(elem2).getSize();
        int i = 0;
        while (i < e1size) {
            int j = 0;
            while (j < e2size) {
                if (geom.getElement(elem1).getEntry(i) == geom.getElement(elem2).getEntry(j)) {
                    return new int[]{i, j};
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public void joinSingularity() {
        boolean oldEnabled = this.getEnabled();
        this.setEnabled(false);
        this.m_parameterizer.startFFExtension();
        this.setEnabled(oldEnabled);
    }

    public void setNumJoints(int i) {
        this.m_maxNoJoints.setValue(i);
    }

    public void setMaxErrorGrowth(float f) {
        this.m_maxErrorGrowth.setValue((double)f);
    }

    public void setMaxJoinDist(float f) {
        this.m_maxJoinDist.setValue((double)f);
    }

    public void setMinRatio(float f) {
        this.m_minJoinRatio.setValue((double)f);
    }

    private class ConstraintProposal {
        public int singularityElementIndex1;
        public int singularityElementIndex2;
        public ElementInfo m_eInfo1;
        public ElementInfo m_eInfo2;
        private PgParamGeom m_cpGeom;
        public PdVector distance;

        ConstraintProposal(PgParamGeom geom, ElementInfo eInfo1, ElementInfo eInfo2, int locInd) {
            int eInd1 = eInfo1.myElemIndex;
            int eInd2 = eInfo2.myElemIndex;
            this.m_eInfo1 = eInfo1;
            this.m_eInfo2 = eInfo2;
            this.m_cpGeom = geom;
            this.singularityElementIndex1 = eInd1;
            this.singularityElementIndex2 = eInd2;
            this.distance = new PdVector(2);
            int[] mutV = PmAntiSpiraler.getMutualVertex((PgElementSet)geom, eInd1, eInd2);
            PdVector sing1dist = PdVector.copyNew((PdVector)eInfo1.getOrigCoordinates(mutV[0]));
            sing1dist.sub(eInfo1.singularityCoords);
            sing1dist = PmAntiSpiraler.quarterRotationRight(sing1dist, eInfo1.totalTurns);
            PdVector sing2dist = PdVector.copyNew((PdVector)eInfo2.getOrigCoordinates(mutV[1]));
            sing2dist.sub(eInfo2.singularityCoords);
            sing2dist = PmAntiSpiraler.quarterRotationRight(sing2dist, eInfo2.totalTurns);
            int turns = PuMath.modulo((int)geom.getCovering().getMatching(eInd1, locInd), (int)geom.getCovering().getSymmetryOrder());
            PdVector totalDist = PmAntiSpiraler.quarterRotationLeft(sing1dist, turns);
            totalDist.sub(sing2dist);
            totalDist.setEntry(0, Math.abs(totalDist.getEntry(0)));
            totalDist.setEntry(1, Math.abs(totalDist.getEntry(1)));
            totalDist.sort();
            this.distance = totalDist;
        }

        public double getRatio() {
            if (this.distance.getEntry(0) == 0.0) {
                return Double.MAX_VALUE;
            }
            return this.distance.getEntry(1) / this.distance.getEntry(0);
        }

        public double getSmallerDist() {
            return this.distance.getEntry(0);
        }

        public boolean equals(Object c) {
            if (!(c instanceof ConstraintProposal)) {
                return false;
            }
            ConstraintProposal cp = (ConstraintProposal)c;
            return (cp.singularityElementIndex1 == this.singularityElementIndex1 && cp.singularityElementIndex2 == this.singularityElementIndex2 || cp.singularityElementIndex1 == this.singularityElementIndex2 && cp.singularityElementIndex2 == this.singularityElementIndex1) && Math.abs(this.distance.getEntry(0) - cp.distance.getEntry(0)) < SAME_SING_EPS && Math.abs(this.distance.getEntry(1) - cp.distance.getEntry(1)) < SAME_SING_EPS;
        }

        public PiVector getPath() {
            int[] mutV = PmAntiSpiraler.getMutualVertex((PgElementSet)this.m_cpGeom, this.m_eInfo1.myElemIndex, this.m_eInfo2.myElemIndex);
            PiVector p1 = this.tracePathToSingularity(this.m_eInfo1, mutV[0], true);
            PiVector p2 = this.tracePathToSingularity(this.m_eInfo2, mutV[1], false);
            p1.invert();
            p1.concat(p2);
            p1.removeSuccessiveDuplicates();
            boolean bShortened = true;
            while (bShortened) {
                bShortened = false;
                int size = p1.getSize();
                int i = size - 2;
                while (i > 0) {
                    if (p1.m_data[i + 1] == p1.m_data[i - 1]) {
                        p1.removeEntry(i);
                        bShortened = true;
                    }
                    --i;
                }
                p1.removeSuccessiveDuplicates();
            }
            return p1;
        }

        private PiVector tracePathToSingularity(ElementInfo startElem, int startVertexLocInd, boolean addStartVertex) {
            int prevLeft;
            ElementInfo curE = startElem;
            PiVector pathLeft = new PiVector(0);
            PiVector pathRight = new PiVector(0);
            int prevRight = prevLeft = this.m_cpGeom.getElement(curE.myElemIndex).getEntry(startVertexLocInd);
            if (addStartVertex) {
                pathLeft.addEntry(prevLeft);
                pathRight.addEntry(prevRight);
            }
            while (curE.parent != null) {
                int locInd;
                if (this.m_cpGeom.getElement(curE.parent.myElemIndex).getIndexOf(prevLeft) == -1) {
                    locInd = this.m_cpGeom.getElement(curE.myElemIndex).getIndexOf(prevLeft);
                    prevLeft = this.m_cpGeom.getElement((int)curE.myElemIndex).m_data[(locInd + 1) % 3];
                    pathLeft.addEntry(prevLeft);
                }
                if (this.m_cpGeom.getElement(curE.parent.myElemIndex).getIndexOf(prevRight) == -1) {
                    locInd = this.m_cpGeom.getElement(curE.myElemIndex).getIndexOf(prevRight);
                    prevRight = this.m_cpGeom.getElement((int)curE.myElemIndex).m_data[(locInd + 2) % 3];
                    pathRight.addEntry(prevRight);
                }
                curE = curE.parent;
            }
            if (pathLeft.getSize() == 0 || pathLeft.getLastEntry() != startElem.singularityIndex) {
                pathLeft.addEntry(curE.singularityIndex);
            }
            if (pathRight.getSize() == 0 || pathRight.getLastEntry() != startElem.singularityIndex) {
                pathRight.addEntry(curE.singularityIndex);
            }
            if (pathLeft.getSize() < pathRight.getSize()) {
                return pathLeft;
            }
            return pathRight;
        }

        public String toString() {
            double[] dist = new double[]{0.5 * (double)((int)(2.0 * this.distance.m_data[0] + 0.5)), 0.5 * (double)((int)(2.0 * this.distance.m_data[1] + 0.5))};
            return "ConstraintProposal - Dist: (" + dist[0] + "|" + dist[1] + ") connects " + this.m_eInfo1.singularityIndex + " to " + this.m_eInfo2.singularityIndex;
        }
    }

    private class ConstraintProposalAbsoluteComparator
    implements Comparator<ConstraintProposal> {
        @Override
        public int compare(ConstraintProposal e1, ConstraintProposal e2) {
            double deltaDist = e1.getSmallerDist() - e2.getSmallerDist();
            if (Math.abs(deltaDist) < SAME_SING_EPS) {
                if (Math.abs(e2.distance.length() - e1.distance.length()) > SAME_SING_EPS) {
                    return (int)Math.signum(e2.distance.length() - e1.distance.length());
                }
                if (e1.m_eInfo1.singularityIndex == e2.m_eInfo1.singularityIndex && e1.m_eInfo2.singularityIndex == e2.m_eInfo2.singularityIndex || e1.m_eInfo1.singularityIndex == e2.m_eInfo2.singularityIndex && e1.m_eInfo2.singularityIndex == e2.m_eInfo1.singularityIndex) {
                    return 0;
                }
                return -1;
            }
            return (int)Math.signum(deltaDist);
        }
    }

    private class ConstraintProposalRatioComparator
    implements Comparator<ConstraintProposal> {
        @Override
        public int compare(ConstraintProposal e1, ConstraintProposal e2) {
            if (Math.abs(e1.distance.m_data[0]) <= SAME_SING_EPS && Math.abs(e2.distance.m_data[0]) > SAME_SING_EPS) {
                return -1;
            }
            if (Math.abs(e1.distance.m_data[0]) > SAME_SING_EPS && Math.abs(e2.distance.m_data[0]) <= SAME_SING_EPS) {
                return 1;
            }
            if (Math.abs(e1.distance.m_data[0]) < SAME_SING_EPS && Math.abs(e2.distance.m_data[0]) < SAME_SING_EPS) {
                if (Math.abs(e2.distance.getEntry(1) - e1.distance.getEntry(1)) < SAME_SING_EPS) {
                    if (e1.m_eInfo1.singularityIndex == e2.m_eInfo1.singularityIndex && e1.m_eInfo2.singularityIndex == e2.m_eInfo2.singularityIndex || e1.m_eInfo1.singularityIndex == e2.m_eInfo2.singularityIndex && e1.m_eInfo2.singularityIndex == e2.m_eInfo1.singularityIndex) {
                        return 0;
                    }
                    return -1;
                }
                return (int)Math.signum(e2.distance.getEntry(1) - e1.distance.getEntry(1));
            }
            double deltaDistRatio = e2.getRatio() - e1.getRatio();
            if (Math.abs(deltaDistRatio) < SAME_SING_EPS) {
                if (Math.abs(e1.distance.getEntry(0) - e2.distance.getEntry(0)) > SAME_SING_EPS) {
                    return (int)Math.signum(e1.distance.getEntry(0) - e2.distance.getEntry(0));
                }
                if (e1.m_eInfo1.singularityIndex == e2.m_eInfo1.singularityIndex && e1.m_eInfo2.singularityIndex == e2.m_eInfo2.singularityIndex || e1.m_eInfo1.singularityIndex == e2.m_eInfo2.singularityIndex && e1.m_eInfo2.singularityIndex == e2.m_eInfo1.singularityIndex) {
                    return 0;
                }
                return -1;
            }
            return (int)Math.signum(deltaDistRatio);
        }
    }

    private class ElementInfo {
        public PdVector[] textureCoords;
        public int myElemIndex;
        public int singularityIndex;
        public int totalTurns;
        public ElementInfo parent;
        public PdVector totalGap;
        public PdVector singularityCoords;

        public double getDistToSingularity() {
            double min = Double.MAX_VALUE;
            int i = 0;
            while (i < 3) {
                PdVector distVec = this.getOrigCoordinates(i);
                distVec.sub(this.singularityCoords);
                double dist = distVec.length();
                if (min > dist) {
                    min = dist;
                }
                ++i;
            }
            return min;
        }

        public PdVector getOrigCoordinates(int locInd) {
            PdVector v = PmAntiSpiraler.quarterRotationLeft(this.textureCoords[locInd], this.totalTurns);
            v.sub(this.totalGap);
            return v;
        }
    }

    private class SingularityDistanceComparator
    implements Comparator<ElementInfo> {
        @Override
        public int compare(ElementInfo e1, ElementInfo e2) {
            return (int)Math.signum(e1.getDistToSingularity() - e2.getDistToSingularity());
        }
    }
}

