/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.modules.fieldGenerator;

import devCovering.PgFrameField;
import devParameterize.modules.PnModule;
import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgVectorField;
import jv.number.PuBoolean;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.vecmath.PbVector;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;
import jvx.geom.PgUtil;
import jvx.util.PuPriorityQueue;
import jvx.vector.PwVectorField;

public class PwExtenderParallel
extends PnModule {
    public boolean m_bColorElements;
    public double m_avgEdgeLength;
    public PuBoolean m_spreadByDistance;

    public PwExtenderParallel() {
        this.setName("Parallel extender");
        this.setStatusMessage("Parallel Extender");
        this.m_bColorElements = false;
        this.m_avgEdgeLength = 1.0;
        this.m_spreadByDistance = new PuBoolean("Spread by Distance", (PsUpdateIf)this, true);
        if (((Object)((Object)this)).getClass() == PwExtenderParallel.class) {
            this.init();
        }
    }

    @Override
    public boolean start() {
        if (!super.start()) {
            return false;
        }
        if (this.m_geom.getFrameField() == null) {
            PsDebug.warning((String)"missing frame field");
            PgFrameField frameField = new PgFrameField(this.m_geom.getCovering());
            frameField.setName("Frame Field");
            frameField.assureFields();
            this.m_geom.setFrameField(frameField);
        }
        PbVector bTrusted = new PbVector(this.m_geom.getNumElements());
        int i = 0;
        while (i < this.m_geom.getNumElements()) {
            bTrusted.m_data[i] = this.m_geom.getTrustWeights() == null || this.m_geom.getTrustWeights().getEntry(i) > 0.0;
            ++i;
        }
        this.extend(bTrusted.m_data);
        this.m_geom.setFrameField(this.m_geom.getFrameField());
        return true;
    }

    public PsPanel getInfoPanel() {
        return this.m_spreadByDistance.getInfoPanel();
    }

    public PgFrameField extend(boolean[] trusted) {
        PgVectorField sparseField = this.m_geom.getSparseField();
        PgFrameField field = this.m_geom.getFrameField();
        if (sparseField == null) {
            PsDebug.warning((String)"missing sparse field");
            return null;
        }
        if (field == null) {
            PsDebug.warning((String)"missing frame field");
            return null;
        }
        field.getField(0).setVectors(sparseField.getVectors());
        field.getField(1).setVectors(sparseField.getVectors());
        PwVectorField.rotateVectorField((PgVectorField)field.getField(1));
        PuPriorityQueue q = new PuPriorityQueue(this.m_geom.getNumElements());
        boolean[] touched = new boolean[this.m_geom.getNumElements()];
        this.m_avgEdgeLength = PgUtil.getEdgeLengths((PgElementSet)this.m_geom, null, (boolean)true).average();
        PdVector hues = this.m_bColorElements ? PwExtenderParallel.makeElementColorHues((PgElementSet)this.m_geom) : null;
        int i = 0;
        while (i < this.m_geom.getNumElements()) {
            if (trusted[i]) {
                q.enqueue(i, 0.0);
                if (hues != null) {
                    this.m_geom.setElementColor(i, Color.getHSBColor((float)hues.m_data[i], 1.0f, 0.7f));
                }
            } else {
                PiVector element = this.m_geom.getElement(i);
                int v0 = element.m_data[0];
                int v1 = element.m_data[1];
                PdVector vector = field.getField(0).getVector(i);
                vector.sub(this.m_geom.getVertex(v1), this.m_geom.getVertex(v0));
                vector.normalize();
                field.getField(1).getVector(i).cross(this.m_geom.getElementNormal(i), vector);
            }
            ++i;
        }
        while (!q.isEmpty()) {
            int e = q.extractMin();
            double parentKey = q.getKey(e);
            touched[e] = true;
            int i2 = 0;
            while (i2 < 3) {
                double key;
                int ne = this.m_geom.getNeighbour((int)e).m_data[i2];
                if (ne != -1 && !touched[ne] && !trusted[ne] && q.enqueueOrDecrease(ne, key = parentKey + this.getEdgeCost((PgElementSet)this.m_geom, e, ne))) {
                    if (hues != null) {
                        if (trusted[e]) {
                            this.m_geom.setElementColor(ne, Color.getHSBColor((float)hues.m_data[e], 0.3f, 1.0f));
                        } else {
                            this.m_geom.setElementColor(ne, this.m_geom.getElementColor(e));
                        }
                    }
                    PwExtenderParallel.transportFrame(field, e, ne);
                }
                ++i2;
            }
        }
        return field;
    }

    private static PdVector makeElementColorHues(PgElementSet geom) {
        PdVector colorVals = new PdVector(geom.getNumElements());
        geom.showElementColors(true);
        double[][] bb = PdVector.getEntries((PdVector[])geom.getBounds());
        int e = 0;
        while (e < geom.getNumElements()) {
            double[] coord = PgGeometry.getCenterOfElement(null, (PdVector[])geom.getVertices(), (int[])geom.getElement((int)e).m_data).m_data;
            colorVals.m_data[e] = 0.4 * ((coord[0] - bb[0][0]) / (bb[1][0] - bb[0][0])) + 0.4 * ((coord[1] - bb[0][1]) / (bb[1][1] - bb[0][1])) + 0.4 * ((coord[2] - bb[0][2]) / (bb[1][2] - bb[0][2]));
            ++e;
        }
        return colorVals;
    }

    private static void transportFrame(PgFrameField field, int e, int ne) {
        PgElementSet geom = field.getGeometry();
        double angle = PwVectorField.calcAngle((PgVectorField)field.getField(0), (int)e, (int)ne);
        int i = 0;
        while (i < 2) {
            PdVector v = field.getField(i).getVector(ne);
            PuVectorGeom.rotatePointAroundVector((PdVector)v, (PdVector)v, (PdVector)geom.getElementNormal(ne), (double)(-angle));
            ++i;
        }
    }

    private double getEdgeCost(PgElementSet geom, int e, int ne) {
        if (this.m_spreadByDistance.getState()) {
            return geom.getCenterOfElement(null, e).dist(geom.getCenterOfElement(null, ne));
        }
        PdVector eNormal = geom.getElementNormal(e);
        PdVector neNormal = geom.getElementNormal(ne);
        return Math.acos(PdVector.dot((PdVector)eNormal, (PdVector)neNormal));
    }

    public boolean update(Object event) {
        if (event == this.m_spreadByDistance) {
            return true;
        }
        return super.update(event);
    }
}

