/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.modules.fieldGenerator;

import dev.geom.PnStructureElementSet;
import dev.numeric.PnTaucsSolver;
import dev.numeric.PuSparseMatrix;
import devCovering.PgCovering;
import devCovering.PgFrameField;
import devCovering.PnFrameField;
import devGraph.PgAbstractGraph;
import devGraph.PgGraphOnElementSet;
import devGraph.PnAbstractGraph;
import devGraph.PnGraphOnElementSet;
import jv.geom.PgElementSet;
import jv.geom.PgVectorField;
import jv.number.PuBoolean;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.vecmath.PbVector;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;
import jvx.numeric.PnConjugateGradientMatrix;
import jvx.numeric.PnSparseMatrix;
import jvx.vector.PwVectorField;

public class PwExtenderAngle
extends PsObject {
    private boolean m_useTAUCS = PsConfig.isApplication() && PnTaucsSolver.isAvailable();
    protected PgElementSet m_geom;
    protected PgVectorField m_sparseField;
    protected PbVector m_trusted;
    protected PgFrameField m_extendedField;
    protected PuBoolean m_useGreedyRounding;
    protected int m_symmetryOrder = 4;
    private PgCovering m_customCovering;
    private PgCovering m_covering;
    private PgGraphOnElementSet m_elementTree;
    private PgGraphOnElementSet m_cutGraph;

    public PwExtenderAngle() {
        this.setName("Minimize angles");
        this.m_useGreedyRounding = new PuBoolean("Use greedy rounding");
        if (((Object)((Object)this)).getClass() == PwExtenderAngle.class) {
            this.init();
        }
    }

    public void init() {
        this.m_useGreedyRounding.setDefState(true);
        this.m_useGreedyRounding.init();
    }

    public void setField(PgVectorField sparseField, int symmetryOrder, PbVector trusted) {
        if (sparseField == null) {
            PsDebug.warning((String)"missing sparse field");
            return;
        }
        if (!(sparseField.getGeometry() instanceof PgElementSet)) {
            PsDebug.warning((String)"sparse field must live on an element set");
            return;
        }
        this.m_sparseField = sparseField;
        this.m_symmetryOrder = symmetryOrder;
        this.m_trusted = trusted;
        this.m_geom = (PgElementSet)sparseField.getGeometry();
    }

    public void setCustomCovering(PgCovering customCovering) {
        this.m_customCovering = customCovering;
    }

    public static PgFrameField extend(PgVectorField sparseField, int symmetryOrder, PbVector trusted, PgCovering customCovering, PdVector[] refVectors, PdVector[] edgeAngles, PgFrameField extField) {
        if (sparseField == null) {
            PsDebug.warning((String)"missing sparse field");
            return null;
        }
        if (!(sparseField.getGeometry() instanceof PgElementSet)) {
            PsDebug.warning((String)"sparse field must live on an element set");
            return null;
        }
        PwExtenderAngle ext = new PwExtenderAngle();
        ext.setField(sparseField, symmetryOrder, trusted);
        ext.setCustomCovering(customCovering);
        ext.start(extField, refVectors, edgeAngles);
        return extField;
    }

    public void start(PgFrameField outField, PdVector[] refVectors, PdVector[] edgeAngles) {
        int i;
        if (this.m_sparseField == null || this.m_trusted == null) {
            PsDebug.warning((String)"No sparse field or trusted array set");
            return;
        }
        if (outField == null) {
            if (this.m_covering == null) {
                this.m_covering = new PgCovering(this.m_geom, this.m_symmetryOrder);
            }
            outField = new PgFrameField(this.m_covering);
            outField.assureFields();
        } else {
            this.m_covering = outField.getCovering();
            if (this.m_covering == null) {
                this.m_covering = new PgCovering(outField.getGeometry(), this.m_symmetryOrder);
                outField.setCovering(this.m_covering);
            }
        }
        this.m_extendedField = outField;
        this.m_extendedField.getField(0).setVectors(this.m_sparseField.getVectors());
        this.m_extendedField.getField(1).setVectors(this.m_sparseField.getVectors());
        PwVectorField.rotateVectorField((PgVectorField)this.m_extendedField.getField(1));
        int e = 0;
        int ne = 0;
        int locInd = 0;
        int m = 0;
        int numEdges = 0;
        int numE = this.m_geom.getNumElements();
        e = 0;
        while (e < numE) {
            int i2 = 0;
            while (i2 < 3) {
                ne = this.m_geom.getNeighbour((int)e).m_data[i2];
                if (ne >= e) {
                    ++numEdges;
                }
                ++i2;
            }
            ++e;
        }
        PiVector edgeElement = new PiVector(numEdges);
        PiVector edgeLocInd = new PiVector(numEdges);
        numEdges = 0;
        e = 0;
        while (e < numE) {
            int i3 = 0;
            while (i3 < 3) {
                ne = this.m_geom.getNeighbour((int)e).m_data[i3];
                if (ne >= e) {
                    edgeElement.m_data[numEdges] = e;
                    edgeLocInd.m_data[numEdges] = i3;
                    ++numEdges;
                }
                ++i3;
            }
            ++e;
        }
        PnSparseMatrix matrix = new PnSparseMatrix(numE + numEdges, numE + numEdges);
        PdVector rightVector = new PdVector(numE + numEdges);
        e = 0;
        while (e < numE) {
            i = 0;
            while (i < 3) {
                ne = this.m_geom.getNeighbour((int)e).m_data[i];
                if (ne > e) {
                    matrix.appendEntry(e, e, 1.0);
                    matrix.appendEntry(ne, e, -1.0);
                    matrix.appendEntry(e, ne, -1.0);
                    matrix.appendEntry(ne, ne, 1.0);
                    int n = e;
                    rightVector.m_data[n] = rightVector.m_data[n] + edgeAngles[e].m_data[i];
                    int n2 = ne;
                    rightVector.m_data[n2] = rightVector.m_data[n2] - edgeAngles[e].m_data[i];
                }
                ++i;
            }
            ++e;
        }
        i = 0;
        while (i < numEdges) {
            e = edgeElement.m_data[i];
            locInd = edgeLocInd.m_data[i];
            ne = this.m_geom.getNeighbour((int)e).m_data[edgeLocInd.m_data[i]];
            matrix.appendEntry(numE + i, e, -1.0);
            matrix.appendEntry(numE + i, ne, 1.0);
            matrix.appendEntry(e, numE + i, -1.0);
            matrix.appendEntry(ne, numE + i, 1.0);
            matrix.appendEntry(numE + i, numE + i, 1.0);
            int n = numE + i;
            rightVector.m_data[n] = rightVector.m_data[n] - edgeAngles[e].m_data[locInd];
            ++i;
        }
        matrix.validate();
        boolean[] fixed = new boolean[numE + numEdges];
        System.arraycopy(this.m_trusted.m_data, 0, fixed, 0, numE);
        PdVector coord = new PdVector(numE + numEdges);
        e = 0;
        while (e < numE) {
            if (this.m_trusted.m_data[e]) {
                coord.m_data[e] = PdVector.angleWithOrientation((PdVector)refVectors[e], (PdVector)this.m_extendedField.getField(0).getVector(e), (PdVector)this.m_geom.getElementNormal(e));
                if (coord.m_data[e] > Math.PI) {
                    coord.m_data[e] = coord.m_data[e] - Math.PI * 2;
                }
            }
            ++e;
        }
        if (this.m_customCovering == null) {
            this.initializeCovering();
        } else {
            this.m_covering.copy(this.m_customCovering);
            this.m_extendedField.setCovering(this.m_covering);
        }
        int fixedEdges = 0;
        int i4 = 0;
        while (i4 < numEdges) {
            e = edgeElement.m_data[i4];
            locInd = edgeLocInd.m_data[i4];
            ne = this.m_geom.getNeighbour((int)e).m_data[edgeLocInd.m_data[i4]];
            m = this.m_covering.getMatching(e, edgeLocInd.m_data[i4]);
            if (m == Integer.MAX_VALUE && this.m_trusted.m_data[e] && this.m_trusted.m_data[ne]) {
                m = PnFrameField.calcMatchingFrameAngle((PgVectorField)this.m_extendedField.getField(0), (int)this.m_symmetryOrder, (int)e, (int)ne);
                this.m_covering.setMatching(e, locInd, m);
            }
            if (m != Integer.MAX_VALUE) {
                ++fixedEdges;
                fixed[numE + i4] = true;
                coord.m_data[numE + i4] = (double)(m * 2) * Math.PI / (double)this.m_symmetryOrder;
            }
            ++i4;
        }
        PnSparseMatrix reducedMatrix = new PnSparseMatrix();
        PdVector reducedRightVector = new PdVector();
        PdVector bRv = PdVector.copyNew((PdVector)rightVector);
        PuSparseMatrix.getReducedSystem((PnSparseMatrix)matrix, (PnSparseMatrix)reducedMatrix, (PdVector)coord, (PdVector)bRv, (PdVector)reducedRightVector, (boolean[])fixed, null);
        PdVector reducedCoord = new PdVector(reducedRightVector.getSize());
        if (reducedRightVector.getSize() > 0) {
            if (this.m_useTAUCS) {
                PnTaucsSolver.logfile2StandardOut((boolean)false);
                long taucsFactorReduced = PnTaucsSolver.getCholeksyFactorization((PnSparseMatrix)reducedMatrix);
                PnTaucsSolver.solveUseFactorization((long)taucsFactorReduced, (double[])reducedCoord.m_data, (double[])reducedRightVector.m_data);
                PnTaucsSolver.freeFactorization((long)taucsFactorReduced);
            } else {
                PnConjugateGradientMatrix solver = new PnConjugateGradientMatrix();
                solver.solve(reducedMatrix, reducedCoord, reducedRightVector);
            }
            int numFreeEdges = numEdges - fixedEdges;
            int numConti = reducedRightVector.getSize() - numFreeEdges;
            if (!this.m_useGreedyRounding.getState()) {
                this.intelligentRounding(numConti, numFreeEdges, reducedMatrix, reducedRightVector, reducedCoord);
            }
        }
        PdVector finalCoord = new PdVector();
        PuSparseMatrix.enlargeReducedSolutionVector((PdVector)coord, (boolean[])fixed, (PdVector)reducedCoord, (PdVector)finalCoord);
        int i5 = 0;
        while (i5 < numEdges) {
            e = edgeElement.m_data[i5];
            locInd = edgeLocInd.m_data[i5];
            this.m_covering.setMatching(e, locInd, (int)Math.round(finalCoord.m_data[numE + i5] * (double)this.m_symmetryOrder / (Math.PI * 2)));
            ++i5;
        }
        this.m_covering.updateBranchpoints();
        PgVectorField field0 = this.m_extendedField.getField(0);
        PgVectorField field1 = this.m_extendedField.getField(1);
        e = 0;
        while (e < numE) {
            double angle = finalCoord.m_data[e];
            PuVectorGeom.rotatePointAroundVector((PdVector)field0.getVector(e), (PdVector)refVectors[e], (PdVector)this.m_geom.getElementNormal(e), (double)angle);
            if (field1 != null) {
                PuVectorGeom.rotatePointAroundVector((PdVector)field1.getVector(e), (PdVector)refVectors[e], (PdVector)this.m_geom.getElementNormal(e), (double)(angle + 1.5707963267948966));
            }
            ++e;
        }
    }

    protected void initializeCovering() {
        this.findConnectedComponents();
        this.makeCutGraph();
        this.makeCovering();
        this.m_extendedField.setCovering(this.m_covering);
    }

    /*
     * Exception decompiling
     */
    private void findConnectedComponents() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[DOLOOP]], but top level block is 3[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void makeCutGraph() {
        this.m_elementTree = new PgGraphOnElementSet(this.m_geom, 1);
        PgGraphOnElementSet domain = new PgGraphOnElementSet(this.m_geom, 1);
        PnGraphOnElementSet.makeConnectivityGraph((PgGraphOnElementSet)domain);
        int numElements = this.m_geom.getNumElements();
        int e = 0;
        while (e < numElements) {
            int i = 0;
            while (i < 3) {
                int ne = this.m_geom.getNeighbour((int)e).m_data[i];
                if (ne >= 0 && this.m_trusted.m_data[e] && this.m_trusted.m_data[ne]) {
                    domain.removeEdge(e, ne);
                }
                ++i;
            }
            ++e;
        }
        int numRoots = 0;
        int e2 = 0;
        while (e2 < numElements) {
            if (this.m_trusted.m_data[e2]) {
                ++numRoots;
            }
            ++e2;
        }
        PiVector roots = new PiVector(numRoots);
        int ind = 0;
        int e3 = 0;
        while (e3 < numElements) {
            if (this.m_trusted.m_data[e3]) {
                roots.m_data[ind++] = e3;
            }
            ++e3;
        }
        PnAbstractGraph.makeShortestPathTree((PgAbstractGraph)this.m_elementTree, (PgAbstractGraph)domain, (PiVector)roots, (boolean)true, null, null);
        this.m_cutGraph = PnGraphOnElementSet.makeDualGraph((PgGraphOnElementSet)this.m_elementTree);
        this.m_cutGraph.setName("Cut graph");
        e3 = 0;
        while (e3 < numElements) {
            if (this.m_trusted.m_data[e3]) {
                int i = 0;
                while (i < 3) {
                    int ne = this.m_geom.getNeighbour((int)e3).m_data[i];
                    if (ne >= 0 && this.m_trusted.m_data[ne]) {
                        PiVector element = this.m_geom.getElement(e3);
                        this.m_cutGraph.removeEdge(element.m_data[(i + 1) % 3], element.m_data[(i + 2) % 3]);
                    }
                    ++i;
                }
            }
            ++e3;
        }
    }

    private void makeCovering() {
        int numElements = this.m_geom.getNumElements();
        this.m_covering = this.m_extendedField.getCovering();
        PiVector[] matching = this.m_covering.getMatching();
        PiVector tmp = new PiVector(2);
        int e = 0;
        while (e < numElements) {
            int i = 0;
            while (i < 3) {
                int ne = this.m_geom.getNeighbour((int)e).m_data[i];
                if (ne < 0) {
                    matching[e].m_data[i] = Integer.MAX_VALUE;
                } else if (this.m_trusted.m_data[e] && this.m_trusted.m_data[ne]) {
                    matching[e].m_data[i] = Integer.MAX_VALUE;
                } else {
                    PnStructureElementSet.dualEdgeFromElements((PgElementSet)this.m_geom, (int)e, (int)ne, (PiVector)tmp);
                    matching[e].m_data[i] = !this.m_cutGraph.isAdjacent(tmp.m_data[0], tmp.m_data[1]) ? 0 : Integer.MAX_VALUE;
                }
                ++i;
            }
            ++e;
        }
    }

    private void intelligentRounding(int numConti, int numFixed, PnSparseMatrix matrix, PdVector rightVector, PdVector coord) {
        PnTaucsSolver.logfile2StandardOut((boolean)false);
        PbVector fixed = new PbVector(numConti + numFixed);
        int fixedIndex = 0;
        while (fixedIndex < numFixed + 1) {
            if (!this.m_useTAUCS) {
                PsDebug.warning((String)"Only taucs implemented");
                return;
            }
            PnSparseMatrix reducedMatrix = new PnSparseMatrix();
            PdVector reducedRightVector = new PdVector();
            PdVector bRv = PdVector.copyNew((PdVector)rightVector);
            PuSparseMatrix.getReducedSystem((PnSparseMatrix)matrix, (PnSparseMatrix)reducedMatrix, (PdVector)coord, (PdVector)bRv, (PdVector)reducedRightVector, (boolean[])fixed.m_data, null);
            PdVector reducedCoord = new PdVector(reducedRightVector.getSize());
            PnTaucsSolver.solveCholeksy((PnSparseMatrix)reducedMatrix, (PdVector)reducedCoord, (PdVector)reducedRightVector);
            PuSparseMatrix.enlargeReducedSolutionVector((PdVector)coord, (boolean[])fixed.m_data, (PdVector)reducedCoord);
            if (fixedIndex == numFixed) break;
            double bestFit = 1.0;
            int bestIndex = -1;
            int i = 0;
            while (i < numFixed) {
                double m;
                double left;
                if (!fixed.m_data[numConti + i] && (left = Math.abs((double)Math.round(m = coord.m_data[numConti + i] * (double)this.m_symmetryOrder / (Math.PI * 2)) - m)) < bestFit) {
                    bestFit = left;
                    bestIndex = i;
                }
                ++i;
            }
            fixed.m_data[numConti + bestIndex] = true;
            coord.m_data[numConti + bestIndex] = (double)(Math.round(coord.m_data[numConti + bestIndex] * (double)this.m_symmetryOrder / (Math.PI * 2)) * 2L) * Math.PI / (double)this.m_symmetryOrder;
            ++fixedIndex;
        }
    }
}

