/*
 * Decompiled with CFR 0.152.
 */
package devParameterize.modules.fieldGenerator;

import dev.geom.PnStructureElementSet;
import devCovering.PgCovering;
import devCovering.PgFrameField;
import devCovering.PgPathOnCovering;
import devGraph.PnGraphOnElementSet;
import devParameterize.covering.PgTextureMapOnCovering;
import devParameterize.modules.parameterizer.PmContinuousMaker;
import jv.geom.PgElementSet;
import jv.geom.PgPolygonSet;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.project.PvPickEvent;
import jv.project.PvPickListenerIf;
import jv.vecmath.PdBary;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgVertexStar;
import jvx.project.PjWorkshop;

public class PwCoveringEditor
extends PjWorkshop
implements PvPickListenerIf {
    protected PgElementSet m_geom;
    private PgTextureMapOnCovering m_contiTex;
    private PgFrameField m_field;
    private PgPathOnCovering[] m_paths;
    private PgCovering m_covering;
    private PiVector m_bridges;
    protected PgFrameField m_editedField;
    protected PgPathOnCovering[] m_editedPaths;
    protected PgCovering m_editedCovering;
    protected PiVector m_editedBridges;
    private boolean m_useGreedyAlgorithm = false;
    protected PmContinuousMaker m_pwContiMaker = new PmContinuousMaker();
    private boolean m_valid;
    protected double m_energyValue = -1.0;
    protected int m_startVertex = -1;
    private PgPolygonSet m_edits;
    private PiVector m_elementPerVertex;
    private PiVector[] m_vertexToPaths;

    public PwCoveringEditor() {
        super("CoveringEditor workshop");
        if (((Object)((Object)this)).getClass() == PwCoveringEditor.class) {
            this.init();
        }
    }

    public PwCoveringEditor(PgElementSet geom) {
        this();
        this.setGeometry((PgGeometry)geom);
    }

    public void init() {
        super.init();
    }

    public void setGeometry(PgGeometry geom) {
        if (geom == null || !(geom instanceof PgElementSet)) {
            PsDebug.warning((String)"Geom is not an PgElementSet.");
            return;
        }
        this.clearCache();
        super.setGeometry(geom);
        this.m_geom = (PgElementSet)geom;
        this.m_elementPerVertex = PgVertexStar.getElementPerVertex((PgElementSet)this.m_geom);
        this.update((Object)this);
    }

    public void setDisplay(PvDisplayIf display) {
        super.setDisplay(display);
        display.addPickListener((PvPickListenerIf)this);
    }

    private void updateEnergy() {
        this.m_energyValue = this.m_field == null || this.m_contiTex == null ? Double.NaN : this.m_contiTex.distL2(this.m_field);
        this.update((Object)this);
    }

    public boolean update(Object event) {
        if (event == null) {
            return super.update(event);
        }
        return super.update(event);
    }

    public String getName() {
        return "CoveringEditor workshop";
    }

    public void start() {
        if (this.m_editedField == null) {
            this.m_editedField = PgFrameField.copyNew((PgFrameField)this.m_field);
            this.m_editedCovering = PgCovering.copyNew((PgCovering)this.m_covering);
            this.m_editedField.setCovering(this.m_editedCovering);
        }
        if (this.m_editedPaths == null) {
            this.m_editedPaths = new PgPathOnCovering[this.m_paths.length];
            this.m_editedBridges = PiVector.copyNew((PiVector)this.m_bridges);
            int i = 0;
            while (i < this.m_paths.length) {
                this.m_editedPaths[i] = PgPathOnCovering.copyNew((PgPathOnCovering)this.m_paths[i]);
                this.m_editedPaths[i].setCovering(this.m_editedCovering);
                ++i;
            }
        }
        if (this.m_useGreedyAlgorithm) {
            this.startGreedy();
        } else {
            this.editCovering();
        }
        this.update((Object)this);
    }

    private void editCovering() {
        if (this.m_edits == null) {
            return;
        }
        int numV = this.m_geom.getNumVertices();
        this.m_vertexToPaths = PiVector.realloc((PiVector[])this.m_vertexToPaths, (int)numV, (int)0);
        PgPathOnCovering[] paths = this.m_editedPaths;
        int numPaths = paths.length;
        int p = 0;
        while (p < numPaths) {
            PiVector vertices = paths[p].getVertexIndices();
            int size = vertices.getSize();
            int i = 0;
            while (i < size) {
                int v = vertices.m_data[i];
                if (this.m_vertexToPaths[v].getIndexOf(p) < 0) {
                    this.m_vertexToPaths[v].addEntry(p);
                }
                ++i;
            }
            ++p;
        }
        int numEdits = this.m_edits.getNumPolygons();
        PiVector bp = this.m_editedCovering.getBranchPoints();
        int p2 = 0;
        while (p2 < numEdits) {
            PiVector path = this.m_edits.getPolygon(p2);
            int bpInd = bp.getIndexOf(path.m_data[0]);
            if (bpInd < 0) {
                PsDebug.warning((String)"Internal error.");
                return;
            }
            int size = path.getSize();
            int index = this.m_editedCovering.getBranchTypes().m_data[bpInd];
            int i = 0;
            while (i < size - 1) {
                this.moveSingularity(index, path.m_data[i], path.m_data[i + 1], true);
                ++i;
            }
            ++p2;
        }
        this.m_pwContiMaker.start();
        this.updateEnergy();
        this.resetEdits();
    }

    public void startGreedy() {
        int v;
        int i;
        int numV = this.m_geom.getNumVertices();
        this.m_vertexToPaths = PiVector.realloc((PiVector[])this.m_vertexToPaths, (int)numV, (int)0);
        int numPaths = this.m_editedPaths == null ? 0 : this.m_editedPaths.length;
        int p = 0;
        while (p < numPaths) {
            PiVector vertices = this.m_editedPaths[p].getVertexIndices();
            int size = vertices.getSize();
            i = 0;
            while (i < size) {
                v = vertices.m_data[i];
                if (this.m_vertexToPaths[v].getIndexOf(p) < 0) {
                    this.m_vertexToPaths[v].addEntry(p);
                }
                ++i;
            }
            ++p;
        }
        PiVector bp = this.m_editedCovering.getBranchPoints();
        PiVector bBp = PiVector.copyNew((PiVector)bp);
        int num = bBp.getSize();
        i = 0;
        while (i < num) {
            System.err.println("Start search for branch point " + i + "/" + bBp.getSize() + ", v=" + bBp.m_data[i]);
            while (bBp.m_data[i] >= 0) {
                v = bBp.m_data[i];
                int ind = this.m_editedCovering.getBranchPoints().getIndexOf(v);
                if (ind >= 0) {
                    bBp.m_data[i] = this.searchMinimumForBp(ind);
                } else {
                    PsDebug.warning((String)("Vertex not found in branch point list: v = " + v));
                }
                System.err.println("  -> best position: " + bBp.m_data[i]);
            }
            ++i;
        }
        this.update((Object)this);
    }

    public int searchMinimumForBp(int bpInd) {
        PiVector bp = this.m_editedCovering.getBranchPoints();
        int brIndex = this.m_editedCovering.getBranchTypes().m_data[bpInd];
        int v = bp.m_data[bpInd];
        PgPathOnCovering[] paths = this.m_paths;
        int numPaths = paths.length;
        PgCovering bCov = PgCovering.copyNew((PgCovering)this.m_editedCovering);
        PiVector bBridges = PiVector.copyNew((PiVector)this.m_bridges);
        PiVector[] bPaths = new PiVector[numPaths];
        int i = 0;
        while (i < numPaths) {
            bPaths[i] = PiVector.copyNew((PiVector)paths[i].getVertexIndices());
            ++i;
        }
        PgVertexStar star = new PgVertexStar();
        star.makeVertexStar(this.m_geom, v, this.m_elementPerVertex.m_data[v]);
        PiVector link = star.getLink();
        int size = link.getSize();
        double bestEnergy = this.m_energyValue;
        int moveTo = -1;
        int i2 = 0;
        while (i2 < size) {
            int nv = link.m_data[i2];
            double energyValue = this.moveAndSolve(brIndex, v, nv, false);
            if (energyValue < bestEnergy) {
                bestEnergy = energyValue;
                moveTo = nv;
            }
            this.m_editedCovering.copy(bCov);
            this.m_bridges.copy(bBridges);
            int j = 0;
            while (j < numPaths) {
                paths[j].getVertexIndices().setSize(bPaths[j].getSize());
                paths[j].makePath(bPaths[j], this.m_elementPerVertex);
                ++j;
            }
            ++i2;
        }
        if (moveTo >= 0) {
            this.m_energyValue = this.moveAndSolve(brIndex, v, moveTo, true);
        }
        return moveTo;
    }

    private double moveAndSolve(int branchIndex, int v, int nv, boolean makeEntry) {
        if (!this.moveSingularity(branchIndex, v, nv, makeEntry)) {
            return Double.MAX_VALUE;
        }
        this.m_pwContiMaker.start();
        double value = this.m_contiTex.distL2(this.m_field);
        System.err.println("  Position: " + nv + ", Energy: " + value);
        return value;
    }

    private boolean moveSingularity(int branchIndex, int from, int to, boolean makeEntry) {
        int e = PnStructureElementSet.dualEdgeFromVertices((PgElementSet)this.m_geom, (int)from, (int)to, (int)this.m_elementPerVertex.m_data[from], null).m_data[0];
        int locInd = (this.m_geom.getElement(e).getIndexOf(from) + 1) % 3;
        PiVector fromPaths = this.m_vertexToPaths[from];
        PiVector toPaths = this.m_vertexToPaths[to];
        int numToPaths = toPaths.getSize();
        int i = 0;
        while (i < numToPaths) {
            if (fromPaths.getIndexOf(toPaths.m_data[i]) < 0) {
                return false;
            }
            ++i;
        }
        int m = this.m_editedCovering.getMatching(e, locInd);
        this.m_editedCovering.setMatching(e, locInd, m - branchIndex);
        this.m_editedCovering.getBranchPoints().changeValue(from, to);
        PgPathOnCovering[] paths = this.m_paths;
        int numPaths = paths.length;
        int p = 0;
        while (p < numPaths) {
            boolean modified = false;
            PiVector vertices = paths[p].getVertexIndices();
            int pathSize = vertices.getSize();
            if (vertices.m_data[0] == from) {
                if (vertices.m_data[1] == to) {
                    PsDebug.warning((String)"todo");
                    return false;
                }
                vertices = this.pathInsert(vertices, p, 0, to);
                pathSize = vertices.getSize();
                modified = true;
            }
            if (vertices.m_data[pathSize - 1] == from) {
                if (vertices.m_data[pathSize - 2] == to) {
                    PsDebug.warning((String)"todo");
                    return false;
                }
                vertices = this.pathInsert(vertices, p, pathSize, to);
                pathSize = vertices.getSize();
                modified = true;
            }
            if (vertices.m_data[pathSize / 2] == from) {
                if (vertices.m_data[pathSize / 2 + 1] == to) {
                    PsDebug.warning((String)"todo");
                    return false;
                }
                vertices = this.pathInsert(vertices, p, pathSize / 2, to);
                vertices = this.pathInsert(vertices, p, pathSize / 2, from);
                modified = true;
            }
            if (modified) {
                paths[p].makePath(vertices, this.m_elementPerVertex);
                if (makeEntry && this.m_vertexToPaths[to].getIndexOf(p) < 0) {
                    this.m_vertexToPaths[to].addEntry(p);
                }
            }
            ++p;
        }
        return true;
    }

    private PiVector pathInsert(PiVector vertices, int p, int pos, int vertex) {
        int size = vertices.getSize();
        PiVector v2 = new PiVector(size + 1);
        if (pos > 0) {
            v2.copy(0, vertices, 0, pos);
        }
        if (size - pos > 0) {
            v2.copy(pos + 1, vertices, pos, size - pos);
        }
        v2.m_data[pos] = vertex;
        if (this.m_editedBridges.m_data[p] >= pos) {
            int n = p;
            this.m_editedBridges.m_data[n] = this.m_editedBridges.m_data[n] + 1;
        }
        return v2;
    }

    public void resetEdits() {
        if (this.m_edits != null) {
            this.m_display.removeGeometry((PgGeometryIf)this.m_edits);
            this.m_edits = null;
        }
    }

    public void addEdit(int startV, int endV) {
        if (this.m_edits == null) {
            this.m_edits = new PgPolygonSet(3);
            this.m_edits.setName("Edits");
            this.m_edits.showVertices(false);
            this.m_edits.setNumVertices(this.m_geom.getNumVertices());
            this.m_edits.setVertices(this.m_geom.getVertices());
            this.m_display.addGeometry((PgGeometryIf)this.m_edits);
        }
        PiVector path = PnGraphOnElementSet.makeShortestPath((PgElementSet)this.m_geom, (int)startV, (int)endV, (int)0);
        this.m_edits.addPolygon(path);
        this.m_edits.update((Object)this.m_edits);
    }

    public void selectGeometry(PgGeometryIf geom) {
    }

    public void pickDisplay(PvPickEvent pos) {
    }

    public void dragDisplay(PvPickEvent pos) {
    }

    public void pickInitial(PvPickEvent pos) {
        if (pos.getGeometry() != this.m_geom) {
            return;
        }
        if (this.m_field == null) {
            PsDebug.warning((String)"No field set.");
            return;
        }
        PdBary b = pos.getBary();
        int e = b.getElementInd();
        if (e < 0) {
            return;
        }
        int locInd = b.m_data[0] >= b.m_data[1] && b.m_data[0] >= b.m_data[2] ? 0 : (b.m_data[1] >= b.m_data[2] ? 1 : 2);
        int v = this.m_geom.getElement((int)e).m_data[locInd];
        if (this.m_startVertex < 0) {
            PgCovering cov = this.m_field.getCovering();
            if (cov.getBranchPoints().getIndexOf(v) < 0) {
                PsDebug.warning((String)"Pick a branch point.");
                return;
            }
            this.m_startVertex = v;
        } else {
            this.addEdit(this.m_startVertex, v);
            this.m_startVertex = -1;
        }
        this.update((Object)this);
    }

    public void dragInitial(PvPickEvent pos) {
    }

    public void pickVertex(PgGeometryIf geom, int index, PdVector vertex) {
    }

    public void dragVertex(PgGeometryIf geom, int index, PdVector vertex) {
    }

    public void markVertices(PvPickEvent pos) {
    }

    public void unmarkVertices(PvPickEvent pos) {
    }

    public void setField(PgFrameField field) {
        this.m_field = field;
        this.m_covering = field.getCovering();
        this.m_editedField = null;
        this.m_editedCovering = null;
        this.updateEnergy();
    }

    public void setTextures(PgTextureMapOnCovering tex) {
        this.m_contiTex = tex;
        this.updateEnergy();
    }

    public void setPaths(PgPathOnCovering[] paths, PiVector bridges) {
        this.m_paths = paths;
        this.m_bridges = bridges;
        this.m_editedBridges = null;
        this.m_editedPaths = null;
    }

    public PgFrameField getEditedField() {
        return this.m_editedField;
    }

    public PgPathOnCovering[] getEditedPaths() {
        return this.m_editedPaths;
    }

    public PgCovering getEditedCovering() {
        return this.m_editedCovering;
    }

    public PiVector getEditedBridges() {
        return this.m_editedBridges;
    }

    public boolean isValid() {
        return this.m_valid;
    }

    public void clearCache() {
        this.m_contiTex = null;
        this.m_field = null;
        this.m_paths = null;
        this.m_covering = null;
        this.m_bridges = null;
        this.m_editedField = null;
        this.m_editedPaths = null;
        this.m_editedCovering = null;
        this.m_editedBridges = null;
        this.m_valid = false;
    }
}

